#ifndef _flextvk_h_
#define _flextvk_h_
/*
    This file is part of Magnum.

    Copyright © 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019,
                2020 Vladimír Vondruš <mosra@centrum.cz>

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included
    in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
    THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

#include <cstdint>
#include <cstddef>
#include <Corrade/Utility/VisibilityMacros.h>

#include "Magnum/configure.h"

/* Defensive include guards */

#if defined(VULKAN_H_)
#error Attempt to include auto-generated header after including vulkan.h
#endif
#if defined(VK_PLATFORM_H_)
#error Attempt to include auto-generated header after including vk_platform.h
#endif

#define VULKAN_H_
#define VK_PLATFORM_H_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef DOXYGEN_GENERATING_OUTPUT /* So the macro names are preserved in the docs */

/* Function declaration macros */

#ifndef MAGNUM_BUILD_STATIC
    #ifdef FlextVk_EXPORTS
        #define FLEXTVK_EXPORT CORRADE_VISIBILITY_EXPORT
    #else
        #define FLEXTVK_EXPORT CORRADE_VISIBILITY_IMPORT
    #endif
#else
    #define FLEXTVK_EXPORT CORRADE_VISIBILITY_STATIC
#endif

/* Verbatim copied from upstream vk_platform.h */
#if defined(_WIN32)
    // On Windows, Vulkan commands use the stdcall convention
    #define VKAPI_ATTR
    #define VKAPI_CALL __stdcall
    #define VKAPI_PTR  VKAPI_CALL
#elif defined(__ANDROID__) && defined(__ARM_ARCH) && __ARM_ARCH < 7
    #error "Vulkan isn't supported for the 'armeabi' NDK ABI"
#elif defined(__ANDROID__) && defined(__ARM_ARCH) && __ARM_ARCH >= 7 && defined(__ARM_32BIT_STATE)
    // On Android 32-bit ARM targets, Vulkan functions use the "hardfloat"
    // calling convention, i.e. float parameters are passed in registers. This
    // is true even if the rest of the application passes floats on the stack,
    // as it does by default when compiling for the armeabi-v7a NDK ABI.
    #define VKAPI_ATTR __attribute__((pcs("aapcs-vfp")))
    #define VKAPI_CALL
    #define VKAPI_PTR  VKAPI_ATTR
#else
    // On other platforms, use the default calling convention
    #define VKAPI_ATTR
    #define VKAPI_CALL
    #define VKAPI_PTR
#endif

/* Enums */

#define VK_MAX_PHYSICAL_DEVICE_NAME_SIZE 256
#define VK_UUID_SIZE 16
#define VK_LUID_SIZE 8
#define VK_MAX_EXTENSION_NAME_SIZE 256
#define VK_MAX_DESCRIPTION_SIZE 256
#define VK_MAX_MEMORY_TYPES 32
#define VK_MAX_MEMORY_HEAPS 16
#define VK_QUEUE_FAMILY_EXTERNAL (~0U-1)
#define VK_MAX_DEVICE_GROUP_SIZE 32
#define VK_MAX_DRIVER_NAME_SIZE 256
#define VK_MAX_DRIVER_INFO_SIZE 256

/* VK_VERSION_1_0 */

#define VK_LOD_CLAMP_NONE 1000.0f
#define VK_REMAINING_MIP_LEVELS (~0U)
#define VK_REMAINING_ARRAY_LAYERS (~0U)
#define VK_WHOLE_SIZE (~0ULL)
#define VK_ATTACHMENT_UNUSED (~0U)
#define VK_TRUE 1
#define VK_FALSE 0
#define VK_QUEUE_FAMILY_IGNORED (~0U)
#define VK_SUBPASS_EXTERNAL (~0U)

/* VK_VERSION_1_1 */

#define VK_MAX_DEVICE_GROUP_SIZE 32
#define VK_LUID_SIZE 8
#define VK_QUEUE_FAMILY_EXTERNAL (~0U-1)

/* VK_VERSION_1_2 */

#define VK_MAX_DRIVER_NAME_SIZE 256
#define VK_MAX_DRIVER_INFO_SIZE 256

/* VK_KHR_get_physical_device_properties2 */

#define VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_SPEC_VERSION 2
#define VK_KHR_GET_PHYSICAL_DEVICE_PROPERTIES_2_EXTENSION_NAME "VK_KHR_get_physical_device_properties2"

/* VK_KHR_storage_buffer_storage_class */

#define VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_SPEC_VERSION 1
#define VK_KHR_STORAGE_BUFFER_STORAGE_CLASS_EXTENSION_NAME "VK_KHR_storage_buffer_storage_class"

/* VK_KHR_16bit_storage */

#define VK_KHR_16BIT_STORAGE_SPEC_VERSION 1
#define VK_KHR_16BIT_STORAGE_EXTENSION_NAME "VK_KHR_16bit_storage"

/* VK_KHR_bind_memory2 */

#define VK_KHR_BIND_MEMORY_2_SPEC_VERSION 1
#define VK_KHR_BIND_MEMORY_2_EXTENSION_NAME "VK_KHR_bind_memory2"

/* VK_KHR_get_memory_requirements2 */

#define VK_KHR_GET_MEMORY_REQUIREMENTS_2_SPEC_VERSION 1
#define VK_KHR_GET_MEMORY_REQUIREMENTS_2_EXTENSION_NAME "VK_KHR_get_memory_requirements2"

/* VK_KHR_dedicated_allocation */

#define VK_KHR_DEDICATED_ALLOCATION_SPEC_VERSION 3
#define VK_KHR_DEDICATED_ALLOCATION_EXTENSION_NAME "VK_KHR_dedicated_allocation"

/* VK_KHR_descriptor_update_template */

#define VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_SPEC_VERSION 1
#define VK_KHR_DESCRIPTOR_UPDATE_TEMPLATE_EXTENSION_NAME "VK_KHR_descriptor_update_template"

/* VK_KHR_device_group_creation */

#define VK_KHR_DEVICE_GROUP_CREATION_SPEC_VERSION 1
#define VK_KHR_DEVICE_GROUP_CREATION_EXTENSION_NAME "VK_KHR_device_group_creation"
#define VK_MAX_DEVICE_GROUP_SIZE_KHR VK_MAX_DEVICE_GROUP_SIZE

/* VK_KHR_device_group */

#define VK_KHR_DEVICE_GROUP_SPEC_VERSION 4
#define VK_KHR_DEVICE_GROUP_EXTENSION_NAME "VK_KHR_device_group"

/* VK_KHR_external_memory_capabilities */

#define VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_MEMORY_CAPABILITIES_EXTENSION_NAME "VK_KHR_external_memory_capabilities"
#define VK_LUID_SIZE_KHR VK_LUID_SIZE

/* VK_KHR_external_memory */

#define VK_KHR_EXTERNAL_MEMORY_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_MEMORY_EXTENSION_NAME "VK_KHR_external_memory"
#define VK_QUEUE_FAMILY_EXTERNAL_KHR VK_QUEUE_FAMILY_EXTERNAL

/* VK_KHR_external_semaphore_capabilities */

#define VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_SEMAPHORE_CAPABILITIES_EXTENSION_NAME "VK_KHR_external_semaphore_capabilities"
#define VK_LUID_SIZE_KHR VK_LUID_SIZE

/* VK_KHR_external_semaphore */

#define VK_KHR_EXTERNAL_SEMAPHORE_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_SEMAPHORE_EXTENSION_NAME "VK_KHR_external_semaphore"

/* VK_KHR_external_fence_capabilities */

#define VK_KHR_EXTERNAL_FENCE_CAPABILITIES_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_FENCE_CAPABILITIES_EXTENSION_NAME "VK_KHR_external_fence_capabilities"
#define VK_LUID_SIZE_KHR VK_LUID_SIZE

/* VK_KHR_external_fence */

#define VK_KHR_EXTERNAL_FENCE_SPEC_VERSION 1
#define VK_KHR_EXTERNAL_FENCE_EXTENSION_NAME "VK_KHR_external_fence"

/* VK_KHR_maintenance1 */

#define VK_KHR_MAINTENANCE1_SPEC_VERSION 2
#define VK_KHR_MAINTENANCE1_EXTENSION_NAME "VK_KHR_maintenance1"

/* VK_KHR_maintenance2 */

#define VK_KHR_MAINTENANCE2_SPEC_VERSION 1
#define VK_KHR_MAINTENANCE2_EXTENSION_NAME "VK_KHR_maintenance2"

/* VK_KHR_maintenance3 */

#define VK_KHR_MAINTENANCE3_SPEC_VERSION 1
#define VK_KHR_MAINTENANCE3_EXTENSION_NAME "VK_KHR_maintenance3"

/* VK_KHR_multiview */

#define VK_KHR_MULTIVIEW_SPEC_VERSION 1
#define VK_KHR_MULTIVIEW_EXTENSION_NAME "VK_KHR_multiview"

/* VK_KHR_relaxed_block_layout */

#define VK_KHR_RELAXED_BLOCK_LAYOUT_SPEC_VERSION 1
#define VK_KHR_RELAXED_BLOCK_LAYOUT_EXTENSION_NAME "VK_KHR_relaxed_block_layout"

/* VK_KHR_sampler_ycbcr_conversion */

#define VK_KHR_SAMPLER_YCBCR_CONVERSION_SPEC_VERSION 14
#define VK_KHR_SAMPLER_YCBCR_CONVERSION_EXTENSION_NAME "VK_KHR_sampler_ycbcr_conversion"

/* VK_KHR_shader_draw_parameters */

#define VK_KHR_SHADER_DRAW_PARAMETERS_SPEC_VERSION 1
#define VK_KHR_SHADER_DRAW_PARAMETERS_EXTENSION_NAME "VK_KHR_shader_draw_parameters"

/* VK_KHR_variable_pointers */

#define VK_KHR_VARIABLE_POINTERS_SPEC_VERSION 1
#define VK_KHR_VARIABLE_POINTERS_EXTENSION_NAME "VK_KHR_variable_pointers"

/* VK_EXT_texture_compression_astc_hdr */

#define VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_SPEC_VERSION 1
#define VK_EXT_TEXTURE_COMPRESSION_ASTC_HDR_EXTENSION_NAME "VK_EXT_texture_compression_astc_hdr"

/* VK_EXT_index_type_uint8 */

#define VK_EXT_INDEX_TYPE_UINT8_SPEC_VERSION 1
#define VK_EXT_INDEX_TYPE_UINT8_EXTENSION_NAME "VK_EXT_index_type_uint8"

/* VK_IMG_format_pvrtc */

#define VK_IMG_FORMAT_PVRTC_SPEC_VERSION 1
#define VK_IMG_FORMAT_PVRTC_EXTENSION_NAME "VK_IMG_format_pvrtc"

/* Data types */

#define VK_MAKE_VERSION(major, minor, patch) \
    (((major) << 22) | ((minor) << 12) | (patch))
#define VK_VERSION_MAJOR(version) ((uint32_t)(version) >> 22)
#define VK_VERSION_MINOR(version) (((uint32_t)(version) >> 12) & 0x3ff)
#define VK_VERSION_PATCH(version) ((uint32_t)(version) & 0xfff)
// Vulkan 1.0 version number
#define VK_API_VERSION_1_0 VK_MAKE_VERSION(1, 0, 0)// Patch version should always be set to 0
// Vulkan 1.1 version number
#define VK_API_VERSION_1_1 VK_MAKE_VERSION(1, 1, 0)// Patch version should always be set to 0
// Vulkan 1.2 version number
#define VK_API_VERSION_1_2 VK_MAKE_VERSION(1, 2, 0)// Patch version should always be set to 0
// Version of this file
#define VK_HEADER_VERSION 133
#define VK_DEFINE_HANDLE(object) typedef struct object##_T* object;
#if !defined(VK_DEFINE_NON_DISPATCHABLE_HANDLE)
#if defined(__LP64__) || defined(_WIN64) || (defined(__x86_64__) && !defined(__ILP32__) ) || defined(_M_X64) || defined(__ia64) || defined (_M_IA64) || defined(__aarch64__) || defined(__powerpc64__)
        #define VK_DEFINE_NON_DISPATCHABLE_HANDLE(object) typedef struct object##_T *object;
#else
        #define VK_DEFINE_NON_DISPATCHABLE_HANDLE(object) typedef uint64_t object;
#endif
#endif
#define VK_NULL_HANDLE 0
typedef uint32_t VkSampleMask;
typedef uint32_t VkBool32;
typedef uint32_t VkFlags;
typedef uint64_t VkDeviceSize;
typedef uint64_t VkDeviceAddress;
typedef VkFlags VkFramebufferCreateFlags;
typedef VkFlags VkQueryPoolCreateFlags;
typedef VkFlags VkRenderPassCreateFlags;
typedef VkFlags VkSamplerCreateFlags;
typedef VkFlags VkPipelineLayoutCreateFlags;
typedef VkFlags VkPipelineCacheCreateFlags;
typedef VkFlags VkPipelineDepthStencilStateCreateFlags;
typedef VkFlags VkPipelineDynamicStateCreateFlags;
typedef VkFlags VkPipelineColorBlendStateCreateFlags;
typedef VkFlags VkPipelineMultisampleStateCreateFlags;
typedef VkFlags VkPipelineRasterizationStateCreateFlags;
typedef VkFlags VkPipelineViewportStateCreateFlags;
typedef VkFlags VkPipelineTessellationStateCreateFlags;
typedef VkFlags VkPipelineInputAssemblyStateCreateFlags;
typedef VkFlags VkPipelineVertexInputStateCreateFlags;
typedef VkFlags VkPipelineShaderStageCreateFlags;
typedef VkFlags VkDescriptorSetLayoutCreateFlags;
typedef VkFlags VkBufferViewCreateFlags;
typedef VkFlags VkInstanceCreateFlags;
typedef VkFlags VkDeviceCreateFlags;
typedef VkFlags VkDeviceQueueCreateFlags;
typedef VkFlags VkQueueFlags;
typedef VkFlags VkMemoryPropertyFlags;
typedef VkFlags VkMemoryHeapFlags;
typedef VkFlags VkAccessFlags;
typedef VkFlags VkBufferUsageFlags;
typedef VkFlags VkBufferCreateFlags;
typedef VkFlags VkShaderStageFlags;
typedef VkFlags VkImageUsageFlags;
typedef VkFlags VkImageCreateFlags;
typedef VkFlags VkImageViewCreateFlags;
typedef VkFlags VkPipelineCreateFlags;
typedef VkFlags VkColorComponentFlags;
typedef VkFlags VkFenceCreateFlags;
typedef VkFlags VkSemaphoreCreateFlags;
typedef VkFlags VkFormatFeatureFlags;
typedef VkFlags VkQueryControlFlags;
typedef VkFlags VkQueryResultFlags;
typedef VkFlags VkShaderModuleCreateFlags;
typedef VkFlags VkEventCreateFlags;
typedef VkFlags VkCommandPoolCreateFlags;
typedef VkFlags VkCommandPoolResetFlags;
typedef VkFlags VkCommandBufferResetFlags;
typedef VkFlags VkCommandBufferUsageFlags;
typedef VkFlags VkQueryPipelineStatisticFlags;
typedef VkFlags VkMemoryMapFlags;
typedef VkFlags VkImageAspectFlags;
typedef VkFlags VkSparseMemoryBindFlags;
typedef VkFlags VkSparseImageFormatFlags;
typedef VkFlags VkSubpassDescriptionFlags;
typedef VkFlags VkPipelineStageFlags;
typedef VkFlags VkSampleCountFlags;
typedef VkFlags VkAttachmentDescriptionFlags;
typedef VkFlags VkStencilFaceFlags;
typedef VkFlags VkCullModeFlags;
typedef VkFlags VkDescriptorPoolCreateFlags;
typedef VkFlags VkDescriptorPoolResetFlags;
typedef VkFlags VkDependencyFlags;
typedef VkFlags VkSubgroupFeatureFlags;
typedef VkFlags VkDescriptorUpdateTemplateCreateFlags;
typedef VkFlags VkSemaphoreWaitFlags;
typedef VkFlags VkPeerMemoryFeatureFlags;

typedef VkPeerMemoryFeatureFlags VkPeerMemoryFeatureFlagsKHR;
typedef VkFlags VkMemoryAllocateFlags;
typedef VkFlags VkCommandPoolTrimFlags;

typedef VkCommandPoolTrimFlags VkCommandPoolTrimFlagsKHR;
typedef VkFlags VkExternalMemoryHandleTypeFlags;
typedef VkFlags VkExternalMemoryFeatureFlags;
typedef VkFlags VkExternalSemaphoreHandleTypeFlags;
typedef VkFlags VkExternalSemaphoreFeatureFlags;
typedef VkFlags VkExternalFenceHandleTypeFlags;
typedef VkFlags VkExternalFenceFeatureFlags;
typedef VkFlags VkDescriptorBindingFlags;
typedef VkFlags VkResolveModeFlags;
VK_DEFINE_HANDLE(VkInstance)
VK_DEFINE_HANDLE(VkPhysicalDevice)
VK_DEFINE_HANDLE(VkDevice)
VK_DEFINE_HANDLE(VkQueue)
VK_DEFINE_HANDLE(VkCommandBuffer)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkDeviceMemory)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkCommandPool)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkBuffer)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkBufferView)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkImage)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkImageView)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkShaderModule)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkPipeline)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkPipelineLayout)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkSampler)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkDescriptorSet)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkDescriptorSetLayout)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkDescriptorPool)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkFence)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkSemaphore)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkEvent)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkQueryPool)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkFramebuffer)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkRenderPass)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkPipelineCache)
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkDescriptorUpdateTemplate)

typedef VkDescriptorUpdateTemplate VkDescriptorUpdateTemplateKHR;
VK_DEFINE_NON_DISPATCHABLE_HANDLE(VkSamplerYcbcrConversion)

typedef VkSamplerYcbcrConversion VkSamplerYcbcrConversionKHR;

typedef enum {
    VK_ATTACHMENT_LOAD_OP_LOAD = 0,
    VK_ATTACHMENT_LOAD_OP_CLEAR = 1,
    VK_ATTACHMENT_LOAD_OP_DONT_CARE = 2
} VkAttachmentLoadOp;

typedef enum {
    VK_ATTACHMENT_STORE_OP_STORE = 0,
    VK_ATTACHMENT_STORE_OP_DONT_CARE = 1
} VkAttachmentStoreOp;

typedef enum {
    VK_BLEND_FACTOR_ZERO = 0,
    VK_BLEND_FACTOR_ONE = 1,
    VK_BLEND_FACTOR_SRC_COLOR = 2,
    VK_BLEND_FACTOR_ONE_MINUS_SRC_COLOR = 3,
    VK_BLEND_FACTOR_DST_COLOR = 4,
    VK_BLEND_FACTOR_ONE_MINUS_DST_COLOR = 5,
    VK_BLEND_FACTOR_SRC_ALPHA = 6,
    VK_BLEND_FACTOR_ONE_MINUS_SRC_ALPHA = 7,
    VK_BLEND_FACTOR_DST_ALPHA = 8,
    VK_BLEND_FACTOR_ONE_MINUS_DST_ALPHA = 9,
    VK_BLEND_FACTOR_CONSTANT_COLOR = 10,
    VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_COLOR = 11,
    VK_BLEND_FACTOR_CONSTANT_ALPHA = 12,
    VK_BLEND_FACTOR_ONE_MINUS_CONSTANT_ALPHA = 13,
    VK_BLEND_FACTOR_SRC_ALPHA_SATURATE = 14,
    VK_BLEND_FACTOR_SRC1_COLOR = 15,
    VK_BLEND_FACTOR_ONE_MINUS_SRC1_COLOR = 16,
    VK_BLEND_FACTOR_SRC1_ALPHA = 17,
    VK_BLEND_FACTOR_ONE_MINUS_SRC1_ALPHA = 18
} VkBlendFactor;

typedef enum {
    VK_BLEND_OP_ADD = 0,
    VK_BLEND_OP_SUBTRACT = 1,
    VK_BLEND_OP_REVERSE_SUBTRACT = 2,
    VK_BLEND_OP_MIN = 3,
    VK_BLEND_OP_MAX = 4
} VkBlendOp;

typedef enum {
    VK_BORDER_COLOR_FLOAT_TRANSPARENT_BLACK = 0,
    VK_BORDER_COLOR_INT_TRANSPARENT_BLACK = 1,
    VK_BORDER_COLOR_FLOAT_OPAQUE_BLACK = 2,
    VK_BORDER_COLOR_INT_OPAQUE_BLACK = 3,
    VK_BORDER_COLOR_FLOAT_OPAQUE_WHITE = 4,
    VK_BORDER_COLOR_INT_OPAQUE_WHITE = 5
} VkBorderColor;

typedef int VkFramebufferCreateFlagBits;

typedef int VkRenderPassCreateFlagBits;

typedef int VkSamplerCreateFlagBits;

typedef enum {
    VK_PIPELINE_CACHE_HEADER_VERSION_ONE = 1
} VkPipelineCacheHeaderVersion;

typedef int VkPipelineShaderStageCreateFlagBits;

typedef int VkDescriptorSetLayoutCreateFlagBits;

typedef int VkDeviceQueueCreateFlagBits;

typedef enum {
    VK_BUFFER_CREATE_SPARSE_BINDING_BIT = 1 << 0,
    VK_BUFFER_CREATE_SPARSE_RESIDENCY_BIT = 1 << 1,
    VK_BUFFER_CREATE_SPARSE_ALIASED_BIT = 1 << 2,
    VK_BUFFER_CREATE_PROTECTED_BIT = 1 << 3,
    VK_BUFFER_CREATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT = 1 << 4
} VkBufferCreateFlagBits;

typedef enum {
    VK_BUFFER_USAGE_TRANSFER_SRC_BIT = 1 << 0,
    VK_BUFFER_USAGE_TRANSFER_DST_BIT = 1 << 1,
    VK_BUFFER_USAGE_UNIFORM_TEXEL_BUFFER_BIT = 1 << 2,
    VK_BUFFER_USAGE_STORAGE_TEXEL_BUFFER_BIT = 1 << 3,
    VK_BUFFER_USAGE_UNIFORM_BUFFER_BIT = 1 << 4,
    VK_BUFFER_USAGE_STORAGE_BUFFER_BIT = 1 << 5,
    VK_BUFFER_USAGE_INDEX_BUFFER_BIT = 1 << 6,
    VK_BUFFER_USAGE_VERTEX_BUFFER_BIT = 1 << 7,
    VK_BUFFER_USAGE_INDIRECT_BUFFER_BIT = 1 << 8,
    VK_BUFFER_USAGE_SHADER_DEVICE_ADDRESS_BIT = 1 << 17
} VkBufferUsageFlagBits;

typedef enum {
    VK_COLOR_COMPONENT_R_BIT = 1 << 0,
    VK_COLOR_COMPONENT_G_BIT = 1 << 1,
    VK_COLOR_COMPONENT_B_BIT = 1 << 2,
    VK_COLOR_COMPONENT_A_BIT = 1 << 3
} VkColorComponentFlagBits;

typedef enum {
    VK_COMPONENT_SWIZZLE_IDENTITY = 0,
    VK_COMPONENT_SWIZZLE_ZERO = 1,
    VK_COMPONENT_SWIZZLE_ONE = 2,
    VK_COMPONENT_SWIZZLE_R = 3,
    VK_COMPONENT_SWIZZLE_G = 4,
    VK_COMPONENT_SWIZZLE_B = 5,
    VK_COMPONENT_SWIZZLE_A = 6
} VkComponentSwizzle;

typedef enum {
    VK_COMMAND_POOL_CREATE_TRANSIENT_BIT = 1 << 0,
    VK_COMMAND_POOL_CREATE_RESET_COMMAND_BUFFER_BIT = 1 << 1,
    VK_COMMAND_POOL_CREATE_PROTECTED_BIT = 1 << 2
} VkCommandPoolCreateFlagBits;

typedef enum {
    VK_COMMAND_POOL_RESET_RELEASE_RESOURCES_BIT = 1 << 0
} VkCommandPoolResetFlagBits;

typedef enum {
    VK_COMMAND_BUFFER_RESET_RELEASE_RESOURCES_BIT = 1 << 0
} VkCommandBufferResetFlagBits;

typedef enum {
    VK_COMMAND_BUFFER_LEVEL_PRIMARY = 0,
    VK_COMMAND_BUFFER_LEVEL_SECONDARY = 1
} VkCommandBufferLevel;

typedef enum {
    VK_COMMAND_BUFFER_USAGE_ONE_TIME_SUBMIT_BIT = 1 << 0,
    VK_COMMAND_BUFFER_USAGE_RENDER_PASS_CONTINUE_BIT = 1 << 1,
    VK_COMMAND_BUFFER_USAGE_SIMULTANEOUS_USE_BIT = 1 << 2
} VkCommandBufferUsageFlagBits;

typedef enum {
    VK_COMPARE_OP_NEVER = 0,
    VK_COMPARE_OP_LESS = 1,
    VK_COMPARE_OP_EQUAL = 2,
    VK_COMPARE_OP_LESS_OR_EQUAL = 3,
    VK_COMPARE_OP_GREATER = 4,
    VK_COMPARE_OP_NOT_EQUAL = 5,
    VK_COMPARE_OP_GREATER_OR_EQUAL = 6,
    VK_COMPARE_OP_ALWAYS = 7
} VkCompareOp;

typedef enum {
    VK_CULL_MODE_NONE = 0,
    VK_CULL_MODE_FRONT_BIT = 1 << 0,
    VK_CULL_MODE_BACK_BIT = 1 << 1,
    VK_CULL_MODE_FRONT_AND_BACK = 0x00000003
} VkCullModeFlagBits;

typedef enum {
    VK_DESCRIPTOR_TYPE_SAMPLER = 0,
    VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER = 1,
    VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE = 2,
    VK_DESCRIPTOR_TYPE_STORAGE_IMAGE = 3,
    VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER = 4,
    VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER = 5,
    VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER = 6,
    VK_DESCRIPTOR_TYPE_STORAGE_BUFFER = 7,
    VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC = 8,
    VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC = 9,
    VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT = 10
} VkDescriptorType;

typedef enum {
    VK_DYNAMIC_STATE_VIEWPORT = 0,
    VK_DYNAMIC_STATE_SCISSOR = 1,
    VK_DYNAMIC_STATE_LINE_WIDTH = 2,
    VK_DYNAMIC_STATE_DEPTH_BIAS = 3,
    VK_DYNAMIC_STATE_BLEND_CONSTANTS = 4,
    VK_DYNAMIC_STATE_DEPTH_BOUNDS = 5,
    VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK = 6,
    VK_DYNAMIC_STATE_STENCIL_WRITE_MASK = 7,
    VK_DYNAMIC_STATE_STENCIL_REFERENCE = 8
} VkDynamicState;

typedef enum {
    VK_FENCE_CREATE_SIGNALED_BIT = 1 << 0
} VkFenceCreateFlagBits;

typedef enum {
    VK_POLYGON_MODE_FILL = 0,
    VK_POLYGON_MODE_LINE = 1,
    VK_POLYGON_MODE_POINT = 2
} VkPolygonMode;

typedef enum {
    VK_FORMAT_UNDEFINED = 0,
    VK_FORMAT_R4G4_UNORM_PACK8 = 1,
    VK_FORMAT_R4G4B4A4_UNORM_PACK16 = 2,
    VK_FORMAT_B4G4R4A4_UNORM_PACK16 = 3,
    VK_FORMAT_R5G6B5_UNORM_PACK16 = 4,
    VK_FORMAT_B5G6R5_UNORM_PACK16 = 5,
    VK_FORMAT_R5G5B5A1_UNORM_PACK16 = 6,
    VK_FORMAT_B5G5R5A1_UNORM_PACK16 = 7,
    VK_FORMAT_A1R5G5B5_UNORM_PACK16 = 8,
    VK_FORMAT_R8_UNORM = 9,
    VK_FORMAT_R8_SNORM = 10,
    VK_FORMAT_R8_USCALED = 11,
    VK_FORMAT_R8_SSCALED = 12,
    VK_FORMAT_R8_UINT = 13,
    VK_FORMAT_R8_SINT = 14,
    VK_FORMAT_R8_SRGB = 15,
    VK_FORMAT_R8G8_UNORM = 16,
    VK_FORMAT_R8G8_SNORM = 17,
    VK_FORMAT_R8G8_USCALED = 18,
    VK_FORMAT_R8G8_SSCALED = 19,
    VK_FORMAT_R8G8_UINT = 20,
    VK_FORMAT_R8G8_SINT = 21,
    VK_FORMAT_R8G8_SRGB = 22,
    VK_FORMAT_R8G8B8_UNORM = 23,
    VK_FORMAT_R8G8B8_SNORM = 24,
    VK_FORMAT_R8G8B8_USCALED = 25,
    VK_FORMAT_R8G8B8_SSCALED = 26,
    VK_FORMAT_R8G8B8_UINT = 27,
    VK_FORMAT_R8G8B8_SINT = 28,
    VK_FORMAT_R8G8B8_SRGB = 29,
    VK_FORMAT_B8G8R8_UNORM = 30,
    VK_FORMAT_B8G8R8_SNORM = 31,
    VK_FORMAT_B8G8R8_USCALED = 32,
    VK_FORMAT_B8G8R8_SSCALED = 33,
    VK_FORMAT_B8G8R8_UINT = 34,
    VK_FORMAT_B8G8R8_SINT = 35,
    VK_FORMAT_B8G8R8_SRGB = 36,
    VK_FORMAT_R8G8B8A8_UNORM = 37,
    VK_FORMAT_R8G8B8A8_SNORM = 38,
    VK_FORMAT_R8G8B8A8_USCALED = 39,
    VK_FORMAT_R8G8B8A8_SSCALED = 40,
    VK_FORMAT_R8G8B8A8_UINT = 41,
    VK_FORMAT_R8G8B8A8_SINT = 42,
    VK_FORMAT_R8G8B8A8_SRGB = 43,
    VK_FORMAT_B8G8R8A8_UNORM = 44,
    VK_FORMAT_B8G8R8A8_SNORM = 45,
    VK_FORMAT_B8G8R8A8_USCALED = 46,
    VK_FORMAT_B8G8R8A8_SSCALED = 47,
    VK_FORMAT_B8G8R8A8_UINT = 48,
    VK_FORMAT_B8G8R8A8_SINT = 49,
    VK_FORMAT_B8G8R8A8_SRGB = 50,
    VK_FORMAT_A8B8G8R8_UNORM_PACK32 = 51,
    VK_FORMAT_A8B8G8R8_SNORM_PACK32 = 52,
    VK_FORMAT_A8B8G8R8_USCALED_PACK32 = 53,
    VK_FORMAT_A8B8G8R8_SSCALED_PACK32 = 54,
    VK_FORMAT_A8B8G8R8_UINT_PACK32 = 55,
    VK_FORMAT_A8B8G8R8_SINT_PACK32 = 56,
    VK_FORMAT_A8B8G8R8_SRGB_PACK32 = 57,
    VK_FORMAT_A2R10G10B10_UNORM_PACK32 = 58,
    VK_FORMAT_A2R10G10B10_SNORM_PACK32 = 59,
    VK_FORMAT_A2R10G10B10_USCALED_PACK32 = 60,
    VK_FORMAT_A2R10G10B10_SSCALED_PACK32 = 61,
    VK_FORMAT_A2R10G10B10_UINT_PACK32 = 62,
    VK_FORMAT_A2R10G10B10_SINT_PACK32 = 63,
    VK_FORMAT_A2B10G10R10_UNORM_PACK32 = 64,
    VK_FORMAT_A2B10G10R10_SNORM_PACK32 = 65,
    VK_FORMAT_A2B10G10R10_USCALED_PACK32 = 66,
    VK_FORMAT_A2B10G10R10_SSCALED_PACK32 = 67,
    VK_FORMAT_A2B10G10R10_UINT_PACK32 = 68,
    VK_FORMAT_A2B10G10R10_SINT_PACK32 = 69,
    VK_FORMAT_R16_UNORM = 70,
    VK_FORMAT_R16_SNORM = 71,
    VK_FORMAT_R16_USCALED = 72,
    VK_FORMAT_R16_SSCALED = 73,
    VK_FORMAT_R16_UINT = 74,
    VK_FORMAT_R16_SINT = 75,
    VK_FORMAT_R16_SFLOAT = 76,
    VK_FORMAT_R16G16_UNORM = 77,
    VK_FORMAT_R16G16_SNORM = 78,
    VK_FORMAT_R16G16_USCALED = 79,
    VK_FORMAT_R16G16_SSCALED = 80,
    VK_FORMAT_R16G16_UINT = 81,
    VK_FORMAT_R16G16_SINT = 82,
    VK_FORMAT_R16G16_SFLOAT = 83,
    VK_FORMAT_R16G16B16_UNORM = 84,
    VK_FORMAT_R16G16B16_SNORM = 85,
    VK_FORMAT_R16G16B16_USCALED = 86,
    VK_FORMAT_R16G16B16_SSCALED = 87,
    VK_FORMAT_R16G16B16_UINT = 88,
    VK_FORMAT_R16G16B16_SINT = 89,
    VK_FORMAT_R16G16B16_SFLOAT = 90,
    VK_FORMAT_R16G16B16A16_UNORM = 91,
    VK_FORMAT_R16G16B16A16_SNORM = 92,
    VK_FORMAT_R16G16B16A16_USCALED = 93,
    VK_FORMAT_R16G16B16A16_SSCALED = 94,
    VK_FORMAT_R16G16B16A16_UINT = 95,
    VK_FORMAT_R16G16B16A16_SINT = 96,
    VK_FORMAT_R16G16B16A16_SFLOAT = 97,
    VK_FORMAT_R32_UINT = 98,
    VK_FORMAT_R32_SINT = 99,
    VK_FORMAT_R32_SFLOAT = 100,
    VK_FORMAT_R32G32_UINT = 101,
    VK_FORMAT_R32G32_SINT = 102,
    VK_FORMAT_R32G32_SFLOAT = 103,
    VK_FORMAT_R32G32B32_UINT = 104,
    VK_FORMAT_R32G32B32_SINT = 105,
    VK_FORMAT_R32G32B32_SFLOAT = 106,
    VK_FORMAT_R32G32B32A32_UINT = 107,
    VK_FORMAT_R32G32B32A32_SINT = 108,
    VK_FORMAT_R32G32B32A32_SFLOAT = 109,
    VK_FORMAT_R64_UINT = 110,
    VK_FORMAT_R64_SINT = 111,
    VK_FORMAT_R64_SFLOAT = 112,
    VK_FORMAT_R64G64_UINT = 113,
    VK_FORMAT_R64G64_SINT = 114,
    VK_FORMAT_R64G64_SFLOAT = 115,
    VK_FORMAT_R64G64B64_UINT = 116,
    VK_FORMAT_R64G64B64_SINT = 117,
    VK_FORMAT_R64G64B64_SFLOAT = 118,
    VK_FORMAT_R64G64B64A64_UINT = 119,
    VK_FORMAT_R64G64B64A64_SINT = 120,
    VK_FORMAT_R64G64B64A64_SFLOAT = 121,
    VK_FORMAT_B10G11R11_UFLOAT_PACK32 = 122,
    VK_FORMAT_E5B9G9R9_UFLOAT_PACK32 = 123,
    VK_FORMAT_D16_UNORM = 124,
    VK_FORMAT_X8_D24_UNORM_PACK32 = 125,
    VK_FORMAT_D32_SFLOAT = 126,
    VK_FORMAT_S8_UINT = 127,
    VK_FORMAT_D16_UNORM_S8_UINT = 128,
    VK_FORMAT_D24_UNORM_S8_UINT = 129,
    VK_FORMAT_D32_SFLOAT_S8_UINT = 130,
    VK_FORMAT_BC1_RGB_UNORM_BLOCK = 131,
    VK_FORMAT_BC1_RGB_SRGB_BLOCK = 132,
    VK_FORMAT_BC1_RGBA_UNORM_BLOCK = 133,
    VK_FORMAT_BC1_RGBA_SRGB_BLOCK = 134,
    VK_FORMAT_BC2_UNORM_BLOCK = 135,
    VK_FORMAT_BC2_SRGB_BLOCK = 136,
    VK_FORMAT_BC3_UNORM_BLOCK = 137,
    VK_FORMAT_BC3_SRGB_BLOCK = 138,
    VK_FORMAT_BC4_UNORM_BLOCK = 139,
    VK_FORMAT_BC4_SNORM_BLOCK = 140,
    VK_FORMAT_BC5_UNORM_BLOCK = 141,
    VK_FORMAT_BC5_SNORM_BLOCK = 142,
    VK_FORMAT_BC6H_UFLOAT_BLOCK = 143,
    VK_FORMAT_BC6H_SFLOAT_BLOCK = 144,
    VK_FORMAT_BC7_UNORM_BLOCK = 145,
    VK_FORMAT_BC7_SRGB_BLOCK = 146,
    VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK = 147,
    VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK = 148,
    VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK = 149,
    VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK = 150,
    VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK = 151,
    VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK = 152,
    VK_FORMAT_EAC_R11_UNORM_BLOCK = 153,
    VK_FORMAT_EAC_R11_SNORM_BLOCK = 154,
    VK_FORMAT_EAC_R11G11_UNORM_BLOCK = 155,
    VK_FORMAT_EAC_R11G11_SNORM_BLOCK = 156,
    VK_FORMAT_ASTC_4x4_UNORM_BLOCK = 157,
    VK_FORMAT_ASTC_4x4_SRGB_BLOCK = 158,
    VK_FORMAT_ASTC_5x4_UNORM_BLOCK = 159,
    VK_FORMAT_ASTC_5x4_SRGB_BLOCK = 160,
    VK_FORMAT_ASTC_5x5_UNORM_BLOCK = 161,
    VK_FORMAT_ASTC_5x5_SRGB_BLOCK = 162,
    VK_FORMAT_ASTC_6x5_UNORM_BLOCK = 163,
    VK_FORMAT_ASTC_6x5_SRGB_BLOCK = 164,
    VK_FORMAT_ASTC_6x6_UNORM_BLOCK = 165,
    VK_FORMAT_ASTC_6x6_SRGB_BLOCK = 166,
    VK_FORMAT_ASTC_8x5_UNORM_BLOCK = 167,
    VK_FORMAT_ASTC_8x5_SRGB_BLOCK = 168,
    VK_FORMAT_ASTC_8x6_UNORM_BLOCK = 169,
    VK_FORMAT_ASTC_8x6_SRGB_BLOCK = 170,
    VK_FORMAT_ASTC_8x8_UNORM_BLOCK = 171,
    VK_FORMAT_ASTC_8x8_SRGB_BLOCK = 172,
    VK_FORMAT_ASTC_10x5_UNORM_BLOCK = 173,
    VK_FORMAT_ASTC_10x5_SRGB_BLOCK = 174,
    VK_FORMAT_ASTC_10x6_UNORM_BLOCK = 175,
    VK_FORMAT_ASTC_10x6_SRGB_BLOCK = 176,
    VK_FORMAT_ASTC_10x8_UNORM_BLOCK = 177,
    VK_FORMAT_ASTC_10x8_SRGB_BLOCK = 178,
    VK_FORMAT_ASTC_10x10_UNORM_BLOCK = 179,
    VK_FORMAT_ASTC_10x10_SRGB_BLOCK = 180,
    VK_FORMAT_ASTC_12x10_UNORM_BLOCK = 181,
    VK_FORMAT_ASTC_12x10_SRGB_BLOCK = 182,
    VK_FORMAT_ASTC_12x12_UNORM_BLOCK = 183,
    VK_FORMAT_ASTC_12x12_SRGB_BLOCK = 184,
    VK_FORMAT_G8B8G8R8_422_UNORM = 1000156000,
    VK_FORMAT_B8G8R8G8_422_UNORM = 1000156001,
    VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM = 1000156002,
    VK_FORMAT_G8_B8R8_2PLANE_420_UNORM = 1000156003,
    VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM = 1000156004,
    VK_FORMAT_G8_B8R8_2PLANE_422_UNORM = 1000156005,
    VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM = 1000156006,
    VK_FORMAT_R10X6_UNORM_PACK16 = 1000156007,
    VK_FORMAT_R10X6G10X6_UNORM_2PACK16 = 1000156008,
    VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16 = 1000156009,
    VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16 = 1000156010,
    VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16 = 1000156011,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16 = 1000156012,
    VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16 = 1000156013,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16 = 1000156014,
    VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16 = 1000156015,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16 = 1000156016,
    VK_FORMAT_R12X4_UNORM_PACK16 = 1000156017,
    VK_FORMAT_R12X4G12X4_UNORM_2PACK16 = 1000156018,
    VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16 = 1000156019,
    VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16 = 1000156020,
    VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16 = 1000156021,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16 = 1000156022,
    VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16 = 1000156023,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16 = 1000156024,
    VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16 = 1000156025,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16 = 1000156026,
    VK_FORMAT_G16B16G16R16_422_UNORM = 1000156027,
    VK_FORMAT_B16G16R16G16_422_UNORM = 1000156028,
    VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM = 1000156029,
    VK_FORMAT_G16_B16R16_2PLANE_420_UNORM = 1000156030,
    VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM = 1000156031,
    VK_FORMAT_G16_B16R16_2PLANE_422_UNORM = 1000156032,
    VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM = 1000156033,
    VK_FORMAT_G8B8G8R8_422_UNORM_KHR = VK_FORMAT_G8B8G8R8_422_UNORM,
    VK_FORMAT_B8G8R8G8_422_UNORM_KHR = VK_FORMAT_B8G8R8G8_422_UNORM,
    VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM,
    VK_FORMAT_G8_B8R8_2PLANE_420_UNORM_KHR = VK_FORMAT_G8_B8R8_2PLANE_420_UNORM,
    VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM,
    VK_FORMAT_G8_B8R8_2PLANE_422_UNORM_KHR = VK_FORMAT_G8_B8R8_2PLANE_422_UNORM,
    VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM_KHR = VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM,
    VK_FORMAT_R10X6_UNORM_PACK16_KHR = VK_FORMAT_R10X6_UNORM_PACK16,
    VK_FORMAT_R10X6G10X6_UNORM_2PACK16_KHR = VK_FORMAT_R10X6G10X6_UNORM_2PACK16,
    VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16_KHR = VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16,
    VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16_KHR = VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16,
    VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16_KHR = VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16,
    VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16,
    VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16,
    VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16_KHR = VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16,
    VK_FORMAT_R12X4_UNORM_PACK16_KHR = VK_FORMAT_R12X4_UNORM_PACK16,
    VK_FORMAT_R12X4G12X4_UNORM_2PACK16_KHR = VK_FORMAT_R12X4G12X4_UNORM_2PACK16,
    VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16_KHR = VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16,
    VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16_KHR = VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16,
    VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16_KHR = VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16,
    VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16,
    VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16,
    VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16_KHR = VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16,
    VK_FORMAT_G16B16G16R16_422_UNORM_KHR = VK_FORMAT_G16B16G16R16_422_UNORM,
    VK_FORMAT_B16G16R16G16_422_UNORM_KHR = VK_FORMAT_B16G16R16G16_422_UNORM,
    VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM,
    VK_FORMAT_G16_B16R16_2PLANE_420_UNORM_KHR = VK_FORMAT_G16_B16R16_2PLANE_420_UNORM,
    VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM,
    VK_FORMAT_G16_B16R16_2PLANE_422_UNORM_KHR = VK_FORMAT_G16_B16R16_2PLANE_422_UNORM,
    VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM_KHR = VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM,
    VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK_EXT = 1000066000,
    VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK_EXT = 1000066001,
    VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK_EXT = 1000066002,
    VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK_EXT = 1000066003,
    VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK_EXT = 1000066004,
    VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK_EXT = 1000066005,
    VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK_EXT = 1000066006,
    VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK_EXT = 1000066007,
    VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK_EXT = 1000066008,
    VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK_EXT = 1000066009,
    VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK_EXT = 1000066010,
    VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK_EXT = 1000066011,
    VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK_EXT = 1000066012,
    VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK_EXT = 1000066013,
    VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG = 1000054000,
    VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG = 1000054001,
    VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG = 1000054002,
    VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG = 1000054003,
    VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG = 1000054004,
    VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG = 1000054005,
    VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG = 1000054006,
    VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG = 1000054007
} VkFormat;

typedef enum {
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_BIT = 1 << 0,
    VK_FORMAT_FEATURE_STORAGE_IMAGE_BIT = 1 << 1,
    VK_FORMAT_FEATURE_STORAGE_IMAGE_ATOMIC_BIT = 1 << 2,
    VK_FORMAT_FEATURE_UNIFORM_TEXEL_BUFFER_BIT = 1 << 3,
    VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_BIT = 1 << 4,
    VK_FORMAT_FEATURE_STORAGE_TEXEL_BUFFER_ATOMIC_BIT = 1 << 5,
    VK_FORMAT_FEATURE_VERTEX_BUFFER_BIT = 1 << 6,
    VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BIT = 1 << 7,
    VK_FORMAT_FEATURE_COLOR_ATTACHMENT_BLEND_BIT = 1 << 8,
    VK_FORMAT_FEATURE_DEPTH_STENCIL_ATTACHMENT_BIT = 1 << 9,
    VK_FORMAT_FEATURE_BLIT_SRC_BIT = 1 << 10,
    VK_FORMAT_FEATURE_BLIT_DST_BIT = 1 << 11,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_LINEAR_BIT = 1 << 12,
    VK_FORMAT_FEATURE_TRANSFER_SRC_BIT = 1 << 14,
    VK_FORMAT_FEATURE_TRANSFER_DST_BIT = 1 << 15,
    VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT = 1 << 17,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT = 1 << 18,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT = 1 << 19,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT = 1 << 20,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT = 1 << 21,
    VK_FORMAT_FEATURE_DISJOINT_BIT = 1 << 22,
    VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT = 1 << 23,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_FILTER_MINMAX_BIT = 1 << 16,
    VK_FORMAT_FEATURE_TRANSFER_SRC_BIT_KHR = VK_FORMAT_FEATURE_TRANSFER_SRC_BIT,
    VK_FORMAT_FEATURE_TRANSFER_DST_BIT_KHR = VK_FORMAT_FEATURE_TRANSFER_DST_BIT,
    VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT_KHR = VK_FORMAT_FEATURE_MIDPOINT_CHROMA_SAMPLES_BIT,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_LINEAR_FILTER_BIT,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_SEPARATE_RECONSTRUCTION_FILTER_BIT,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_BIT,
    VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT_KHR = VK_FORMAT_FEATURE_SAMPLED_IMAGE_YCBCR_CONVERSION_CHROMA_RECONSTRUCTION_EXPLICIT_FORCEABLE_BIT,
    VK_FORMAT_FEATURE_DISJOINT_BIT_KHR = VK_FORMAT_FEATURE_DISJOINT_BIT,
    VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT_KHR = VK_FORMAT_FEATURE_COSITED_CHROMA_SAMPLES_BIT
} VkFormatFeatureFlagBits;

typedef enum {
    VK_FRONT_FACE_COUNTER_CLOCKWISE = 0,
    VK_FRONT_FACE_CLOCKWISE = 1
} VkFrontFace;

typedef enum {
    VK_IMAGE_ASPECT_COLOR_BIT = 1 << 0,
    VK_IMAGE_ASPECT_DEPTH_BIT = 1 << 1,
    VK_IMAGE_ASPECT_STENCIL_BIT = 1 << 2,
    VK_IMAGE_ASPECT_METADATA_BIT = 1 << 3,
    VK_IMAGE_ASPECT_PLANE_0_BIT = 1 << 4,
    VK_IMAGE_ASPECT_PLANE_1_BIT = 1 << 5,
    VK_IMAGE_ASPECT_PLANE_2_BIT = 1 << 6,
    VK_IMAGE_ASPECT_PLANE_0_BIT_KHR = VK_IMAGE_ASPECT_PLANE_0_BIT,
    VK_IMAGE_ASPECT_PLANE_1_BIT_KHR = VK_IMAGE_ASPECT_PLANE_1_BIT,
    VK_IMAGE_ASPECT_PLANE_2_BIT_KHR = VK_IMAGE_ASPECT_PLANE_2_BIT
} VkImageAspectFlagBits;

typedef enum {
    VK_IMAGE_CREATE_SPARSE_BINDING_BIT = 1 << 0,
    VK_IMAGE_CREATE_SPARSE_RESIDENCY_BIT = 1 << 1,
    VK_IMAGE_CREATE_SPARSE_ALIASED_BIT = 1 << 2,
    VK_IMAGE_CREATE_MUTABLE_FORMAT_BIT = 1 << 3,
    VK_IMAGE_CREATE_CUBE_COMPATIBLE_BIT = 1 << 4,
    VK_IMAGE_CREATE_ALIAS_BIT = 1 << 10,
    VK_IMAGE_CREATE_SPLIT_INSTANCE_BIND_REGIONS_BIT = 1 << 6,
    VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT = 1 << 5,
    VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT = 1 << 7,
    VK_IMAGE_CREATE_EXTENDED_USAGE_BIT = 1 << 8,
    VK_IMAGE_CREATE_PROTECTED_BIT = 1 << 11,
    VK_IMAGE_CREATE_DISJOINT_BIT = 1 << 9,
    VK_IMAGE_CREATE_ALIAS_BIT_KHR = VK_IMAGE_CREATE_ALIAS_BIT,
    VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT_KHR = VK_IMAGE_CREATE_2D_ARRAY_COMPATIBLE_BIT,
    VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT_KHR = VK_IMAGE_CREATE_BLOCK_TEXEL_VIEW_COMPATIBLE_BIT,
    VK_IMAGE_CREATE_EXTENDED_USAGE_BIT_KHR = VK_IMAGE_CREATE_EXTENDED_USAGE_BIT,
    VK_IMAGE_CREATE_DISJOINT_BIT_KHR = VK_IMAGE_CREATE_DISJOINT_BIT
} VkImageCreateFlagBits;

typedef enum {
    VK_IMAGE_LAYOUT_UNDEFINED = 0,
    VK_IMAGE_LAYOUT_GENERAL = 1,
    VK_IMAGE_LAYOUT_COLOR_ATTACHMENT_OPTIMAL = 2,
    VK_IMAGE_LAYOUT_DEPTH_STENCIL_ATTACHMENT_OPTIMAL = 3,
    VK_IMAGE_LAYOUT_DEPTH_STENCIL_READ_ONLY_OPTIMAL = 4,
    VK_IMAGE_LAYOUT_SHADER_READ_ONLY_OPTIMAL = 5,
    VK_IMAGE_LAYOUT_TRANSFER_SRC_OPTIMAL = 6,
    VK_IMAGE_LAYOUT_TRANSFER_DST_OPTIMAL = 7,
    VK_IMAGE_LAYOUT_PREINITIALIZED = 8,
    VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL = 1000117000,
    VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL = 1000117001,
    VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_OPTIMAL = 1000241000,
    VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_OPTIMAL = 1000241001,
    VK_IMAGE_LAYOUT_STENCIL_ATTACHMENT_OPTIMAL = 1000241002,
    VK_IMAGE_LAYOUT_STENCIL_READ_ONLY_OPTIMAL = 1000241003,
    VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL_KHR = VK_IMAGE_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_OPTIMAL,
    VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL_KHR = VK_IMAGE_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_OPTIMAL
} VkImageLayout;

typedef enum {
    VK_IMAGE_TILING_OPTIMAL = 0,
    VK_IMAGE_TILING_LINEAR = 1
} VkImageTiling;

typedef enum {
    VK_IMAGE_TYPE_1D = 0,
    VK_IMAGE_TYPE_2D = 1,
    VK_IMAGE_TYPE_3D = 2
} VkImageType;

typedef enum {
    VK_IMAGE_USAGE_TRANSFER_SRC_BIT = 1 << 0,
    VK_IMAGE_USAGE_TRANSFER_DST_BIT = 1 << 1,
    VK_IMAGE_USAGE_SAMPLED_BIT = 1 << 2,
    VK_IMAGE_USAGE_STORAGE_BIT = 1 << 3,
    VK_IMAGE_USAGE_COLOR_ATTACHMENT_BIT = 1 << 4,
    VK_IMAGE_USAGE_DEPTH_STENCIL_ATTACHMENT_BIT = 1 << 5,
    VK_IMAGE_USAGE_TRANSIENT_ATTACHMENT_BIT = 1 << 6,
    VK_IMAGE_USAGE_INPUT_ATTACHMENT_BIT = 1 << 7
} VkImageUsageFlagBits;

typedef int VkImageViewCreateFlagBits;

typedef enum {
    VK_IMAGE_VIEW_TYPE_1D = 0,
    VK_IMAGE_VIEW_TYPE_2D = 1,
    VK_IMAGE_VIEW_TYPE_3D = 2,
    VK_IMAGE_VIEW_TYPE_CUBE = 3,
    VK_IMAGE_VIEW_TYPE_1D_ARRAY = 4,
    VK_IMAGE_VIEW_TYPE_2D_ARRAY = 5,
    VK_IMAGE_VIEW_TYPE_CUBE_ARRAY = 6
} VkImageViewType;

typedef enum {
    VK_SHARING_MODE_EXCLUSIVE = 0,
    VK_SHARING_MODE_CONCURRENT = 1
} VkSharingMode;

typedef enum {
    VK_INDEX_TYPE_UINT16 = 0,
    VK_INDEX_TYPE_UINT32 = 1,
    VK_INDEX_TYPE_UINT8_EXT = 1000265000
} VkIndexType;

typedef enum {
    VK_LOGIC_OP_CLEAR = 0,
    VK_LOGIC_OP_AND = 1,
    VK_LOGIC_OP_AND_REVERSE = 2,
    VK_LOGIC_OP_COPY = 3,
    VK_LOGIC_OP_AND_INVERTED = 4,
    VK_LOGIC_OP_NO_OP = 5,
    VK_LOGIC_OP_XOR = 6,
    VK_LOGIC_OP_OR = 7,
    VK_LOGIC_OP_NOR = 8,
    VK_LOGIC_OP_EQUIVALENT = 9,
    VK_LOGIC_OP_INVERT = 10,
    VK_LOGIC_OP_OR_REVERSE = 11,
    VK_LOGIC_OP_COPY_INVERTED = 12,
    VK_LOGIC_OP_OR_INVERTED = 13,
    VK_LOGIC_OP_NAND = 14,
    VK_LOGIC_OP_SET = 15
} VkLogicOp;

typedef enum {
    VK_MEMORY_HEAP_DEVICE_LOCAL_BIT = 1 << 0,
    VK_MEMORY_HEAP_MULTI_INSTANCE_BIT = 1 << 1,
    VK_MEMORY_HEAP_MULTI_INSTANCE_BIT_KHR = VK_MEMORY_HEAP_MULTI_INSTANCE_BIT
} VkMemoryHeapFlagBits;

typedef enum {
    VK_ACCESS_INDIRECT_COMMAND_READ_BIT = 1 << 0,
    VK_ACCESS_INDEX_READ_BIT = 1 << 1,
    VK_ACCESS_VERTEX_ATTRIBUTE_READ_BIT = 1 << 2,
    VK_ACCESS_UNIFORM_READ_BIT = 1 << 3,
    VK_ACCESS_INPUT_ATTACHMENT_READ_BIT = 1 << 4,
    VK_ACCESS_SHADER_READ_BIT = 1 << 5,
    VK_ACCESS_SHADER_WRITE_BIT = 1 << 6,
    VK_ACCESS_COLOR_ATTACHMENT_READ_BIT = 1 << 7,
    VK_ACCESS_COLOR_ATTACHMENT_WRITE_BIT = 1 << 8,
    VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_READ_BIT = 1 << 9,
    VK_ACCESS_DEPTH_STENCIL_ATTACHMENT_WRITE_BIT = 1 << 10,
    VK_ACCESS_TRANSFER_READ_BIT = 1 << 11,
    VK_ACCESS_TRANSFER_WRITE_BIT = 1 << 12,
    VK_ACCESS_HOST_READ_BIT = 1 << 13,
    VK_ACCESS_HOST_WRITE_BIT = 1 << 14,
    VK_ACCESS_MEMORY_READ_BIT = 1 << 15,
    VK_ACCESS_MEMORY_WRITE_BIT = 1 << 16
} VkAccessFlagBits;

typedef enum {
    VK_MEMORY_PROPERTY_DEVICE_LOCAL_BIT = 1 << 0,
    VK_MEMORY_PROPERTY_HOST_VISIBLE_BIT = 1 << 1,
    VK_MEMORY_PROPERTY_HOST_COHERENT_BIT = 1 << 2,
    VK_MEMORY_PROPERTY_HOST_CACHED_BIT = 1 << 3,
    VK_MEMORY_PROPERTY_LAZILY_ALLOCATED_BIT = 1 << 4,
    VK_MEMORY_PROPERTY_PROTECTED_BIT = 1 << 5
} VkMemoryPropertyFlagBits;

typedef enum {
    VK_PHYSICAL_DEVICE_TYPE_OTHER = 0,
    VK_PHYSICAL_DEVICE_TYPE_INTEGRATED_GPU = 1,
    VK_PHYSICAL_DEVICE_TYPE_DISCRETE_GPU = 2,
    VK_PHYSICAL_DEVICE_TYPE_VIRTUAL_GPU = 3,
    VK_PHYSICAL_DEVICE_TYPE_CPU = 4
} VkPhysicalDeviceType;

typedef enum {
    VK_PIPELINE_BIND_POINT_GRAPHICS = 0,
    VK_PIPELINE_BIND_POINT_COMPUTE = 1
} VkPipelineBindPoint;

typedef enum {
    VK_PIPELINE_CREATE_DISABLE_OPTIMIZATION_BIT = 1 << 0,
    VK_PIPELINE_CREATE_ALLOW_DERIVATIVES_BIT = 1 << 1,
    VK_PIPELINE_CREATE_DERIVATIVE_BIT = 1 << 2,
    VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT = 1 << 3,
    VK_PIPELINE_CREATE_DISPATCH_BASE_BIT = 1 << 4,
    VK_PIPELINE_CREATE_DISPATCH_BASE = VK_PIPELINE_CREATE_DISPATCH_BASE_BIT,
    VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT_KHR = VK_PIPELINE_CREATE_VIEW_INDEX_FROM_DEVICE_INDEX_BIT,
    VK_PIPELINE_CREATE_DISPATCH_BASE_KHR = VK_PIPELINE_CREATE_DISPATCH_BASE
} VkPipelineCreateFlagBits;

typedef enum {
    VK_PRIMITIVE_TOPOLOGY_POINT_LIST = 0,
    VK_PRIMITIVE_TOPOLOGY_LINE_LIST = 1,
    VK_PRIMITIVE_TOPOLOGY_LINE_STRIP = 2,
    VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST = 3,
    VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP = 4,
    VK_PRIMITIVE_TOPOLOGY_TRIANGLE_FAN = 5,
    VK_PRIMITIVE_TOPOLOGY_LINE_LIST_WITH_ADJACENCY = 6,
    VK_PRIMITIVE_TOPOLOGY_LINE_STRIP_WITH_ADJACENCY = 7,
    VK_PRIMITIVE_TOPOLOGY_TRIANGLE_LIST_WITH_ADJACENCY = 8,
    VK_PRIMITIVE_TOPOLOGY_TRIANGLE_STRIP_WITH_ADJACENCY = 9,
    VK_PRIMITIVE_TOPOLOGY_PATCH_LIST = 10
} VkPrimitiveTopology;

typedef enum {
    VK_QUERY_CONTROL_PRECISE_BIT = 1 << 0
} VkQueryControlFlagBits;

typedef enum {
    VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_VERTICES_BIT = 1 << 0,
    VK_QUERY_PIPELINE_STATISTIC_INPUT_ASSEMBLY_PRIMITIVES_BIT = 1 << 1,
    VK_QUERY_PIPELINE_STATISTIC_VERTEX_SHADER_INVOCATIONS_BIT = 1 << 2,
    VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_INVOCATIONS_BIT = 1 << 3,
    VK_QUERY_PIPELINE_STATISTIC_GEOMETRY_SHADER_PRIMITIVES_BIT = 1 << 4,
    VK_QUERY_PIPELINE_STATISTIC_CLIPPING_INVOCATIONS_BIT = 1 << 5,
    VK_QUERY_PIPELINE_STATISTIC_CLIPPING_PRIMITIVES_BIT = 1 << 6,
    VK_QUERY_PIPELINE_STATISTIC_FRAGMENT_SHADER_INVOCATIONS_BIT = 1 << 7,
    VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_CONTROL_SHADER_PATCHES_BIT = 1 << 8,
    VK_QUERY_PIPELINE_STATISTIC_TESSELLATION_EVALUATION_SHADER_INVOCATIONS_BIT = 1 << 9,
    VK_QUERY_PIPELINE_STATISTIC_COMPUTE_SHADER_INVOCATIONS_BIT = 1 << 10
} VkQueryPipelineStatisticFlagBits;

typedef enum {
    VK_QUERY_RESULT_64_BIT = 1 << 0,
    VK_QUERY_RESULT_WAIT_BIT = 1 << 1,
    VK_QUERY_RESULT_WITH_AVAILABILITY_BIT = 1 << 2,
    VK_QUERY_RESULT_PARTIAL_BIT = 1 << 3
} VkQueryResultFlagBits;

typedef enum {
    VK_QUERY_TYPE_OCCLUSION = 0,
    VK_QUERY_TYPE_PIPELINE_STATISTICS = 1,
    VK_QUERY_TYPE_TIMESTAMP = 2
} VkQueryType;

typedef enum {
    VK_QUEUE_GRAPHICS_BIT = 1 << 0,
    VK_QUEUE_COMPUTE_BIT = 1 << 1,
    VK_QUEUE_TRANSFER_BIT = 1 << 2,
    VK_QUEUE_SPARSE_BINDING_BIT = 1 << 3,
    VK_QUEUE_PROTECTED_BIT = 1 << 4
} VkQueueFlagBits;

typedef enum {
    VK_SUBPASS_CONTENTS_INLINE = 0,
    VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS = 1
} VkSubpassContents;

typedef enum {
    VK_SUCCESS = 0,
    VK_NOT_READY = 1,
    VK_TIMEOUT = 2,
    VK_EVENT_SET = 3,
    VK_EVENT_RESET = 4,
    VK_INCOMPLETE = 5,
    VK_ERROR_OUT_OF_HOST_MEMORY = -1,
    VK_ERROR_OUT_OF_DEVICE_MEMORY = -2,
    VK_ERROR_INITIALIZATION_FAILED = -3,
    VK_ERROR_DEVICE_LOST = -4,
    VK_ERROR_MEMORY_MAP_FAILED = -5,
    VK_ERROR_LAYER_NOT_PRESENT = -6,
    VK_ERROR_EXTENSION_NOT_PRESENT = -7,
    VK_ERROR_FEATURE_NOT_PRESENT = -8,
    VK_ERROR_INCOMPATIBLE_DRIVER = -9,
    VK_ERROR_TOO_MANY_OBJECTS = -10,
    VK_ERROR_FORMAT_NOT_SUPPORTED = -11,
    VK_ERROR_FRAGMENTED_POOL = -12,
    VK_ERROR_UNKNOWN = -13,
    VK_ERROR_OUT_OF_POOL_MEMORY = -1000069000,
    VK_ERROR_INVALID_EXTERNAL_HANDLE = -1000072003,
    VK_ERROR_FRAGMENTATION = -1000161000,
    VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS = -1000257000,
    VK_ERROR_INVALID_EXTERNAL_HANDLE_KHR = VK_ERROR_INVALID_EXTERNAL_HANDLE,
    VK_ERROR_OUT_OF_POOL_MEMORY_KHR = VK_ERROR_OUT_OF_POOL_MEMORY
} VkResult;

typedef enum {
    VK_SHADER_STAGE_VERTEX_BIT = 1 << 0,
    VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT = 1 << 1,
    VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT = 1 << 2,
    VK_SHADER_STAGE_GEOMETRY_BIT = 1 << 3,
    VK_SHADER_STAGE_FRAGMENT_BIT = 1 << 4,
    VK_SHADER_STAGE_COMPUTE_BIT = 1 << 5,
    VK_SHADER_STAGE_ALL_GRAPHICS = 0x0000001F,
    VK_SHADER_STAGE_ALL = 0x7FFFFFFF
} VkShaderStageFlagBits;

typedef enum {
    VK_SPARSE_MEMORY_BIND_METADATA_BIT = 1 << 0
} VkSparseMemoryBindFlagBits;

typedef enum {
    VK_STENCIL_FACE_FRONT_BIT = 1 << 0,
    VK_STENCIL_FACE_BACK_BIT = 1 << 1,
    VK_STENCIL_FACE_FRONT_AND_BACK = 0x00000003,
    VK_STENCIL_FRONT_AND_BACK = VK_STENCIL_FACE_FRONT_AND_BACK
} VkStencilFaceFlagBits;

typedef enum {
    VK_STENCIL_OP_KEEP = 0,
    VK_STENCIL_OP_ZERO = 1,
    VK_STENCIL_OP_REPLACE = 2,
    VK_STENCIL_OP_INCREMENT_AND_CLAMP = 3,
    VK_STENCIL_OP_DECREMENT_AND_CLAMP = 4,
    VK_STENCIL_OP_INVERT = 5,
    VK_STENCIL_OP_INCREMENT_AND_WRAP = 6,
    VK_STENCIL_OP_DECREMENT_AND_WRAP = 7
} VkStencilOp;

typedef enum {
    VK_STRUCTURE_TYPE_APPLICATION_INFO = 0,
    VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO = 1,
    VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO = 2,
    VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO = 3,
    VK_STRUCTURE_TYPE_SUBMIT_INFO = 4,
    VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO = 5,
    VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE = 6,
    VK_STRUCTURE_TYPE_BIND_SPARSE_INFO = 7,
    VK_STRUCTURE_TYPE_FENCE_CREATE_INFO = 8,
    VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO = 9,
    VK_STRUCTURE_TYPE_EVENT_CREATE_INFO = 10,
    VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO = 11,
    VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO = 12,
    VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO = 13,
    VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO = 14,
    VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO = 15,
    VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO = 16,
    VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO = 17,
    VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO = 18,
    VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO = 19,
    VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO = 20,
    VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO = 21,
    VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO = 22,
    VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO = 23,
    VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO = 24,
    VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO = 25,
    VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO = 26,
    VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO = 27,
    VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO = 28,
    VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO = 29,
    VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO = 30,
    VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO = 31,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO = 32,
    VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO = 33,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO = 34,
    VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET = 35,
    VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET = 36,
    VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO = 37,
    VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO = 38,
    VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO = 39,
    VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO = 40,
    VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO = 41,
    VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO = 42,
    VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO = 43,
    VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER = 44,
    VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER = 45,
    VK_STRUCTURE_TYPE_MEMORY_BARRIER = 46,
    VK_STRUCTURE_TYPE_LOADER_INSTANCE_CREATE_INFO = 47,
    VK_STRUCTURE_TYPE_LOADER_DEVICE_CREATE_INFO = 48,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES = 1000094000,
    VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO = 1000157000,
    VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO = 1000157001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES = 1000083000,
    VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS = 1000127000,
    VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO = 1000127001,
    VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO = 1000060000,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO = 1000060003,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO = 1000060004,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO = 1000060005,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO = 1000060006,
    VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO = 1000060013,
    VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO = 1000060014,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES = 1000070000,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO = 1000070001,
    VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2 = 1000146000,
    VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2 = 1000146001,
    VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2 = 1000146002,
    VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2 = 1000146003,
    VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2 = 1000146004,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 = 1000059000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 = 1000059001,
    VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 = 1000059002,
    VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 = 1000059003,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2 = 1000059004,
    VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 = 1000059005,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 = 1000059006,
    VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 = 1000059007,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2 = 1000059008,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES = 1000117000,
    VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO = 1000117001,
    VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO = 1000117002,
    VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO = 1000117003,
    VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO = 1000053000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES = 1000053001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES = 1000053002,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES = 1000120000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES,
    VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO = 1000145000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES = 1000145001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES = 1000145002,
    VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2 = 1000145003,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO = 1000156000,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO = 1000156001,
    VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO = 1000156002,
    VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO = 1000156003,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES = 1000156004,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES = 1000156005,
    VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO = 1000085000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO = 1000071000,
    VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES = 1000071001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO = 1000071002,
    VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES = 1000071003,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES = 1000071004,
    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO = 1000072000,
    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO = 1000072001,
    VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO = 1000072002,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO = 1000112000,
    VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES = 1000112001,
    VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO = 1000113000,
    VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO = 1000077000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO = 1000076000,
    VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES = 1000076001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES = 1000168000,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT = 1000168001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES = 1000063000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETER_FEATURES = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES = 49,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES = 50,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES = 51,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES = 52,
    VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO = 1000147000,
    VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2 = 1000109000,
    VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2 = 1000109001,
    VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2 = 1000109002,
    VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2 = 1000109003,
    VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2 = 1000109004,
    VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO = 1000109005,
    VK_STRUCTURE_TYPE_SUBPASS_END_INFO = 1000109006,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES = 1000177000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES = 1000196000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES = 1000180000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES = 1000082000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES = 1000197000,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO = 1000161000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES = 1000161001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES = 1000161002,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO = 1000161003,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT = 1000161004,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES = 1000199000,
    VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE = 1000199001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES = 1000221000,
    VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO = 1000246000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES = 1000130000,
    VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO = 1000130001,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES = 1000211000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES = 1000108000,
    VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO = 1000108001,
    VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO = 1000108002,
    VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO = 1000108003,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES = 1000253000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES = 1000175000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES = 1000241000,
    VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT = 1000241001,
    VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT = 1000241002,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES = 1000261000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES = 1000207000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES = 1000207001,
    VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO = 1000207002,
    VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO = 1000207003,
    VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO = 1000207004,
    VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO = 1000207005,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES = 1000257000,
    VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO = 1000244001,
    VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO = 1000257002,
    VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO = 1000257003,
    VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO = 1000257004,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2,
    VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2,
    VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2,
    VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2,
    VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2_KHR = VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES,
    VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO_KHR = VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO,
    VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO_KHR = VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO,
    VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2_KHR = VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2,
    VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2_KHR = VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2,
    VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2_KHR = VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2,
    VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2_KHR = VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2,
    VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2_KHR = VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2,
    VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS_KHR = VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS,
    VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO_KHR = VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO,
    VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES,
    VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO,
    VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES_KHR = VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO,
    VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES_KHR = VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES,
    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO,
    VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO,
    VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_KHR = VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO,
    VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES_KHR = VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES,
    VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO,
    VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES_KHR = VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES,
    VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES,
    VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO,
    VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES,
    VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT_KHR = VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT,
    VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO_KHR = VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO_KHR = VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO,
    VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO_KHR = VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO,
    VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO_KHR = VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES,
    VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES_KHR = VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES_KHR = VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTER_FEATURES,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES_EXT = 1000066000,
    VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT = 1000265000
} VkStructureType;

typedef enum {
    VK_SYSTEM_ALLOCATION_SCOPE_COMMAND = 0,
    VK_SYSTEM_ALLOCATION_SCOPE_OBJECT = 1,
    VK_SYSTEM_ALLOCATION_SCOPE_CACHE = 2,
    VK_SYSTEM_ALLOCATION_SCOPE_DEVICE = 3,
    VK_SYSTEM_ALLOCATION_SCOPE_INSTANCE = 4
} VkSystemAllocationScope;

typedef enum {
    VK_INTERNAL_ALLOCATION_TYPE_EXECUTABLE = 0
} VkInternalAllocationType;

typedef enum {
    VK_SAMPLER_ADDRESS_MODE_REPEAT = 0,
    VK_SAMPLER_ADDRESS_MODE_MIRRORED_REPEAT = 1,
    VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_EDGE = 2,
    VK_SAMPLER_ADDRESS_MODE_CLAMP_TO_BORDER = 3,
    VK_SAMPLER_ADDRESS_MODE_MIRROR_CLAMP_TO_EDGE = 4
} VkSamplerAddressMode;

typedef enum {
    VK_FILTER_NEAREST = 0,
    VK_FILTER_LINEAR = 1
} VkFilter;

typedef enum {
    VK_SAMPLER_MIPMAP_MODE_NEAREST = 0,
    VK_SAMPLER_MIPMAP_MODE_LINEAR = 1
} VkSamplerMipmapMode;

typedef enum {
    VK_VERTEX_INPUT_RATE_VERTEX = 0,
    VK_VERTEX_INPUT_RATE_INSTANCE = 1
} VkVertexInputRate;

typedef enum {
    VK_PIPELINE_STAGE_TOP_OF_PIPE_BIT = 1 << 0,
    VK_PIPELINE_STAGE_DRAW_INDIRECT_BIT = 1 << 1,
    VK_PIPELINE_STAGE_VERTEX_INPUT_BIT = 1 << 2,
    VK_PIPELINE_STAGE_VERTEX_SHADER_BIT = 1 << 3,
    VK_PIPELINE_STAGE_TESSELLATION_CONTROL_SHADER_BIT = 1 << 4,
    VK_PIPELINE_STAGE_TESSELLATION_EVALUATION_SHADER_BIT = 1 << 5,
    VK_PIPELINE_STAGE_GEOMETRY_SHADER_BIT = 1 << 6,
    VK_PIPELINE_STAGE_FRAGMENT_SHADER_BIT = 1 << 7,
    VK_PIPELINE_STAGE_EARLY_FRAGMENT_TESTS_BIT = 1 << 8,
    VK_PIPELINE_STAGE_LATE_FRAGMENT_TESTS_BIT = 1 << 9,
    VK_PIPELINE_STAGE_COLOR_ATTACHMENT_OUTPUT_BIT = 1 << 10,
    VK_PIPELINE_STAGE_COMPUTE_SHADER_BIT = 1 << 11,
    VK_PIPELINE_STAGE_TRANSFER_BIT = 1 << 12,
    VK_PIPELINE_STAGE_BOTTOM_OF_PIPE_BIT = 1 << 13,
    VK_PIPELINE_STAGE_HOST_BIT = 1 << 14,
    VK_PIPELINE_STAGE_ALL_GRAPHICS_BIT = 1 << 15,
    VK_PIPELINE_STAGE_ALL_COMMANDS_BIT = 1 << 16
} VkPipelineStageFlagBits;

typedef enum {
    VK_SPARSE_IMAGE_FORMAT_SINGLE_MIPTAIL_BIT = 1 << 0,
    VK_SPARSE_IMAGE_FORMAT_ALIGNED_MIP_SIZE_BIT = 1 << 1,
    VK_SPARSE_IMAGE_FORMAT_NONSTANDARD_BLOCK_SIZE_BIT = 1 << 2
} VkSparseImageFormatFlagBits;

typedef enum {
    VK_SAMPLE_COUNT_1_BIT = 1 << 0,
    VK_SAMPLE_COUNT_2_BIT = 1 << 1,
    VK_SAMPLE_COUNT_4_BIT = 1 << 2,
    VK_SAMPLE_COUNT_8_BIT = 1 << 3,
    VK_SAMPLE_COUNT_16_BIT = 1 << 4,
    VK_SAMPLE_COUNT_32_BIT = 1 << 5,
    VK_SAMPLE_COUNT_64_BIT = 1 << 6
} VkSampleCountFlagBits;

typedef enum {
    VK_ATTACHMENT_DESCRIPTION_MAY_ALIAS_BIT = 1 << 0
} VkAttachmentDescriptionFlagBits;

typedef enum {
    VK_DESCRIPTOR_POOL_CREATE_FREE_DESCRIPTOR_SET_BIT = 1 << 0,
    VK_DESCRIPTOR_POOL_CREATE_UPDATE_AFTER_BIND_BIT = 1 << 1
} VkDescriptorPoolCreateFlagBits;

typedef enum {
    VK_DEPENDENCY_BY_REGION_BIT = 1 << 0,
    VK_DEPENDENCY_DEVICE_GROUP_BIT = 1 << 2,
    VK_DEPENDENCY_VIEW_LOCAL_BIT = 1 << 1,
    VK_DEPENDENCY_DEVICE_GROUP_BIT_KHR = VK_DEPENDENCY_DEVICE_GROUP_BIT,
    VK_DEPENDENCY_VIEW_LOCAL_BIT_KHR = VK_DEPENDENCY_VIEW_LOCAL_BIT
} VkDependencyFlagBits;

typedef enum {
    VK_DESCRIPTOR_UPDATE_TEMPLATE_TYPE_DESCRIPTOR_SET = 0
} VkDescriptorUpdateTemplateType;

typedef int VkSubpassDescriptionFlagBits;

typedef enum {
    VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES = 0,
    VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY = 1,
    VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES_KHR = VK_POINT_CLIPPING_BEHAVIOR_ALL_CLIP_PLANES,
    VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY_KHR = VK_POINT_CLIPPING_BEHAVIOR_USER_CLIP_PLANES_ONLY
} VkPointClippingBehavior;

typedef enum {
    VK_RESOLVE_MODE_NONE = 0,
    VK_RESOLVE_MODE_SAMPLE_ZERO_BIT = 1 << 0,
    VK_RESOLVE_MODE_AVERAGE_BIT = 1 << 1,
    VK_RESOLVE_MODE_MIN_BIT = 1 << 2,
    VK_RESOLVE_MODE_MAX_BIT = 1 << 3
} VkResolveModeFlagBits;

typedef enum {
    VK_DESCRIPTOR_BINDING_UPDATE_AFTER_BIND_BIT = 1 << 0,
    VK_DESCRIPTOR_BINDING_UPDATE_UNUSED_WHILE_PENDING_BIT = 1 << 1,
    VK_DESCRIPTOR_BINDING_PARTIALLY_BOUND_BIT = 1 << 2,
    VK_DESCRIPTOR_BINDING_VARIABLE_DESCRIPTOR_COUNT_BIT = 1 << 3
} VkDescriptorBindingFlagBits;

typedef enum {
    VK_SEMAPHORE_TYPE_BINARY = 0,
    VK_SEMAPHORE_TYPE_TIMELINE = 1
} VkSemaphoreType;

typedef enum {
    VK_SEMAPHORE_WAIT_ANY_BIT = 1 << 0
} VkSemaphoreWaitFlagBits;

typedef int VkShaderModuleCreateFlagBits;

typedef enum {
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT = 1 << 0,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT = 1 << 1,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT = 1 << 2,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT = 1 << 3,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT = 1 << 4,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT = 1 << 5,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT = 1 << 6,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT,
    VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT_KHR = VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT
} VkExternalMemoryHandleTypeFlagBits;

typedef enum {
    VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT = 1 << 0,
    VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT = 1 << 1,
    VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT = 1 << 2,
    VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT_KHR = VK_EXTERNAL_MEMORY_FEATURE_DEDICATED_ONLY_BIT,
    VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT_KHR = VK_EXTERNAL_MEMORY_FEATURE_EXPORTABLE_BIT,
    VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT_KHR = VK_EXTERNAL_MEMORY_FEATURE_IMPORTABLE_BIT
} VkExternalMemoryFeatureFlagBits;

typedef enum {
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT = 1 << 0,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT = 1 << 1,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT = 1 << 2,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT = 1 << 3,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT = 1 << 4,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR = VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_FD_BIT,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR = VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_BIT,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR = VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT_KHR = VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_D3D12_FENCE_BIT,
    VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT_KHR = VK_EXTERNAL_SEMAPHORE_HANDLE_TYPE_SYNC_FD_BIT
} VkExternalSemaphoreHandleTypeFlagBits;

typedef enum {
    VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT = 1 << 0,
    VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT = 1 << 1,
    VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT_KHR = VK_EXTERNAL_SEMAPHORE_FEATURE_EXPORTABLE_BIT,
    VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT_KHR = VK_EXTERNAL_SEMAPHORE_FEATURE_IMPORTABLE_BIT
} VkExternalSemaphoreFeatureFlagBits;

typedef enum {
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT = 1 << 0,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT = 1 << 1,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT = 1 << 2,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT = 1 << 3,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT_KHR = VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_FD_BIT,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT_KHR = VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_BIT,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT_KHR = VK_EXTERNAL_FENCE_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT,
    VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT_KHR = VK_EXTERNAL_FENCE_HANDLE_TYPE_SYNC_FD_BIT
} VkExternalFenceHandleTypeFlagBits;

typedef enum {
    VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT = 1 << 0,
    VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT = 1 << 1,
    VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT_KHR = VK_EXTERNAL_FENCE_FEATURE_EXPORTABLE_BIT,
    VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT_KHR = VK_EXTERNAL_FENCE_FEATURE_IMPORTABLE_BIT
} VkExternalFenceFeatureFlagBits;

typedef enum {
    VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT = 1 << 0,
    VK_PEER_MEMORY_FEATURE_COPY_DST_BIT = 1 << 1,
    VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT = 1 << 2,
    VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT = 1 << 3,
    VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT_KHR = VK_PEER_MEMORY_FEATURE_COPY_SRC_BIT,
    VK_PEER_MEMORY_FEATURE_COPY_DST_BIT_KHR = VK_PEER_MEMORY_FEATURE_COPY_DST_BIT,
    VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT_KHR = VK_PEER_MEMORY_FEATURE_GENERIC_SRC_BIT,
    VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT_KHR = VK_PEER_MEMORY_FEATURE_GENERIC_DST_BIT
} VkPeerMemoryFeatureFlagBits;

typedef enum {
    VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT = 1 << 0,
    VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_BIT = 1 << 1,
    VK_MEMORY_ALLOCATE_DEVICE_ADDRESS_CAPTURE_REPLAY_BIT = 1 << 2,
    VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT_KHR = VK_MEMORY_ALLOCATE_DEVICE_MASK_BIT
} VkMemoryAllocateFlagBits;

typedef enum {
    VK_SUBGROUP_FEATURE_BASIC_BIT = 1 << 0,
    VK_SUBGROUP_FEATURE_VOTE_BIT = 1 << 1,
    VK_SUBGROUP_FEATURE_ARITHMETIC_BIT = 1 << 2,
    VK_SUBGROUP_FEATURE_BALLOT_BIT = 1 << 3,
    VK_SUBGROUP_FEATURE_SHUFFLE_BIT = 1 << 4,
    VK_SUBGROUP_FEATURE_SHUFFLE_RELATIVE_BIT = 1 << 5,
    VK_SUBGROUP_FEATURE_CLUSTERED_BIT = 1 << 6,
    VK_SUBGROUP_FEATURE_QUAD_BIT = 1 << 7
} VkSubgroupFeatureFlagBits;

typedef enum {
    VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT = 0,
    VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT = 1,
    VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT_KHR = VK_TESSELLATION_DOMAIN_ORIGIN_UPPER_LEFT,
    VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT_KHR = VK_TESSELLATION_DOMAIN_ORIGIN_LOWER_LEFT
} VkTessellationDomainOrigin;

typedef enum {
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY = 0,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY = 1,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709 = 2,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601 = 3,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020 = 4,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY_KHR = VK_SAMPLER_YCBCR_MODEL_CONVERSION_RGB_IDENTITY,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY_KHR = VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_IDENTITY,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709_KHR = VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_709,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601_KHR = VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_601,
    VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020_KHR = VK_SAMPLER_YCBCR_MODEL_CONVERSION_YCBCR_2020
} VkSamplerYcbcrModelConversion;

typedef enum {
    VK_SAMPLER_YCBCR_RANGE_ITU_FULL = 0,
    VK_SAMPLER_YCBCR_RANGE_ITU_NARROW = 1,
    VK_SAMPLER_YCBCR_RANGE_ITU_FULL_KHR = VK_SAMPLER_YCBCR_RANGE_ITU_FULL,
    VK_SAMPLER_YCBCR_RANGE_ITU_NARROW_KHR = VK_SAMPLER_YCBCR_RANGE_ITU_NARROW
} VkSamplerYcbcrRange;

typedef enum {
    VK_CHROMA_LOCATION_COSITED_EVEN = 0,
    VK_CHROMA_LOCATION_MIDPOINT = 1,
    VK_CHROMA_LOCATION_COSITED_EVEN_KHR = VK_CHROMA_LOCATION_COSITED_EVEN,
    VK_CHROMA_LOCATION_MIDPOINT_KHR = VK_CHROMA_LOCATION_MIDPOINT
} VkChromaLocation;

typedef enum {
    VK_SAMPLER_REDUCTION_MODE_WEIGHTED_AVERAGE = 0,
    VK_SAMPLER_REDUCTION_MODE_MIN = 1,
    VK_SAMPLER_REDUCTION_MODE_MAX = 2
} VkSamplerReductionMode;

typedef enum {
    VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_32_BIT_ONLY = 0,
    VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_ALL = 1,
    VK_SHADER_FLOAT_CONTROLS_INDEPENDENCE_NONE = 2
} VkShaderFloatControlsIndependence;

typedef enum {
    VK_VENDOR_ID_VIV = 0x10001,
    VK_VENDOR_ID_VSI = 0x10002,
    VK_VENDOR_ID_KAZAN = 0x10003,
    VK_VENDOR_ID_CODEPLAY = 0x10004
} VkVendorId;

typedef enum {
    VK_DRIVER_ID_AMD_PROPRIETARY = 1,
    VK_DRIVER_ID_AMD_OPEN_SOURCE = 2,
    VK_DRIVER_ID_MESA_RADV = 3,
    VK_DRIVER_ID_NVIDIA_PROPRIETARY = 4,
    VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS = 5,
    VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA = 6,
    VK_DRIVER_ID_IMAGINATION_PROPRIETARY = 7,
    VK_DRIVER_ID_QUALCOMM_PROPRIETARY = 8,
    VK_DRIVER_ID_ARM_PROPRIETARY = 9,
    VK_DRIVER_ID_GOOGLE_SWIFTSHADER = 10,
    VK_DRIVER_ID_GGP_PROPRIETARY = 11,
    VK_DRIVER_ID_BROADCOM_PROPRIETARY = 12
} VkDriverId;
typedef void (VKAPI_PTR *PFN_vkInternalAllocationNotification)(
    void*                                       pUserData,
    size_t                                      size,
    VkInternalAllocationType                    allocationType,
    VkSystemAllocationScope                     allocationScope);
typedef void (VKAPI_PTR *PFN_vkInternalFreeNotification)(
    void*                                       pUserData,
    size_t                                      size,
    VkInternalAllocationType                    allocationType,
    VkSystemAllocationScope                     allocationScope);
typedef void* (VKAPI_PTR *PFN_vkReallocationFunction)(
    void*                                       pUserData,
    void*                                       pOriginal,
    size_t                                      size,
    size_t                                      alignment,
    VkSystemAllocationScope                     allocationScope);
typedef void* (VKAPI_PTR *PFN_vkAllocationFunction)(
    void*                                       pUserData,
    size_t                                      size,
    size_t                                      alignment,
    VkSystemAllocationScope                     allocationScope);
typedef void (VKAPI_PTR *PFN_vkFreeFunction)(
    void*                                       pUserData,
    void*                                       pMemory);
typedef void (VKAPI_PTR *PFN_vkVoidFunction)(void);

typedef struct VkBaseOutStructure {
    VkStructureType sType;
    struct VkBaseOutStructure* pNext;
} VkBaseOutStructure;

typedef struct VkBaseInStructure {
    VkStructureType sType;
    const struct VkBaseInStructure* pNext;
} VkBaseInStructure;

typedef struct VkOffset2D {
    int32_t        x;
    int32_t        y;
} VkOffset2D;

typedef struct VkOffset3D {
    int32_t        x;
    int32_t        y;
    int32_t        z;
} VkOffset3D;

typedef struct VkExtent2D {
    uint32_t        width;
    uint32_t        height;
} VkExtent2D;

typedef struct VkExtent3D {
    uint32_t        width;
    uint32_t        height;
    uint32_t        depth;
} VkExtent3D;

typedef struct VkViewport {
    float x;
    float y;
    float width;
    float height;
    float                       minDepth;
    float                       maxDepth;
} VkViewport;

typedef struct VkRect2D {
    VkOffset2D     offset;
    VkExtent2D     extent;
} VkRect2D;

typedef struct VkClearRect {
    VkRect2D       rect;
    uint32_t       baseArrayLayer;
    uint32_t       layerCount;
} VkClearRect;

typedef struct VkComponentMapping {
    VkComponentSwizzle r;
    VkComponentSwizzle g;
    VkComponentSwizzle b;
    VkComponentSwizzle a;
} VkComponentMapping;

typedef struct VkPhysicalDeviceLimits {
    uint32_t               maxImageDimension1D;
    uint32_t               maxImageDimension2D;
    uint32_t               maxImageDimension3D;
    uint32_t               maxImageDimensionCube;
    uint32_t               maxImageArrayLayers;
    uint32_t               maxTexelBufferElements;
    uint32_t               maxUniformBufferRange;
    uint32_t               maxStorageBufferRange;
    uint32_t               maxPushConstantsSize;
    uint32_t               maxMemoryAllocationCount;
    uint32_t               maxSamplerAllocationCount;
    VkDeviceSize           bufferImageGranularity;
    VkDeviceSize           sparseAddressSpaceSize;
    uint32_t               maxBoundDescriptorSets;
    uint32_t               maxPerStageDescriptorSamplers;
    uint32_t               maxPerStageDescriptorUniformBuffers;
    uint32_t               maxPerStageDescriptorStorageBuffers;
    uint32_t               maxPerStageDescriptorSampledImages;
    uint32_t               maxPerStageDescriptorStorageImages;
    uint32_t               maxPerStageDescriptorInputAttachments;
    uint32_t               maxPerStageResources;
    uint32_t               maxDescriptorSetSamplers;
    uint32_t               maxDescriptorSetUniformBuffers;
    uint32_t               maxDescriptorSetUniformBuffersDynamic;
    uint32_t               maxDescriptorSetStorageBuffers;
    uint32_t               maxDescriptorSetStorageBuffersDynamic;
    uint32_t               maxDescriptorSetSampledImages;
    uint32_t               maxDescriptorSetStorageImages;
    uint32_t               maxDescriptorSetInputAttachments;
    uint32_t               maxVertexInputAttributes;
    uint32_t               maxVertexInputBindings;
    uint32_t               maxVertexInputAttributeOffset;
    uint32_t               maxVertexInputBindingStride;
    uint32_t               maxVertexOutputComponents;
    uint32_t               maxTessellationGenerationLevel;
    uint32_t               maxTessellationPatchSize;
    uint32_t               maxTessellationControlPerVertexInputComponents;
    uint32_t               maxTessellationControlPerVertexOutputComponents;
    uint32_t               maxTessellationControlPerPatchOutputComponents;
    uint32_t               maxTessellationControlTotalOutputComponents;
    uint32_t               maxTessellationEvaluationInputComponents;
    uint32_t               maxTessellationEvaluationOutputComponents;
    uint32_t               maxGeometryShaderInvocations;
    uint32_t               maxGeometryInputComponents;
    uint32_t               maxGeometryOutputComponents;
    uint32_t               maxGeometryOutputVertices;
    uint32_t               maxGeometryTotalOutputComponents;
    uint32_t               maxFragmentInputComponents;
    uint32_t               maxFragmentOutputAttachments;
    uint32_t               maxFragmentDualSrcAttachments;
    uint32_t               maxFragmentCombinedOutputResources;
    uint32_t               maxComputeSharedMemorySize;
    uint32_t               maxComputeWorkGroupCount[3];
    uint32_t               maxComputeWorkGroupInvocations;
    uint32_t               maxComputeWorkGroupSize[3];
    uint32_t               subPixelPrecisionBits;
    uint32_t               subTexelPrecisionBits;
    uint32_t               mipmapPrecisionBits;
    uint32_t               maxDrawIndexedIndexValue;
    uint32_t               maxDrawIndirectCount;
    float                  maxSamplerLodBias;
    float                  maxSamplerAnisotropy;
    uint32_t               maxViewports;
    uint32_t               maxViewportDimensions[2];
    float                  viewportBoundsRange[2];
    uint32_t               viewportSubPixelBits;
    size_t                 minMemoryMapAlignment;
    VkDeviceSize           minTexelBufferOffsetAlignment;
    VkDeviceSize           minUniformBufferOffsetAlignment;
    VkDeviceSize           minStorageBufferOffsetAlignment;
    int32_t                minTexelOffset;
    uint32_t               maxTexelOffset;
    int32_t                minTexelGatherOffset;
    uint32_t               maxTexelGatherOffset;
    float                  minInterpolationOffset;
    float                  maxInterpolationOffset;
    uint32_t               subPixelInterpolationOffsetBits;
    uint32_t               maxFramebufferWidth;
    uint32_t               maxFramebufferHeight;
    uint32_t               maxFramebufferLayers;
    VkSampleCountFlags     framebufferColorSampleCounts;
    VkSampleCountFlags     framebufferDepthSampleCounts;
    VkSampleCountFlags     framebufferStencilSampleCounts;
    VkSampleCountFlags     framebufferNoAttachmentsSampleCounts;
    uint32_t               maxColorAttachments;
    VkSampleCountFlags     sampledImageColorSampleCounts;
    VkSampleCountFlags     sampledImageIntegerSampleCounts;
    VkSampleCountFlags     sampledImageDepthSampleCounts;
    VkSampleCountFlags     sampledImageStencilSampleCounts;
    VkSampleCountFlags     storageImageSampleCounts;
    uint32_t               maxSampleMaskWords;
    VkBool32               timestampComputeAndGraphics;
    float                  timestampPeriod;
    uint32_t               maxClipDistances;
    uint32_t               maxCullDistances;
    uint32_t               maxCombinedClipAndCullDistances;
    uint32_t               discreteQueuePriorities;
    float                  pointSizeRange[2];
    float                  lineWidthRange[2];
    float                  pointSizeGranularity;
    float                  lineWidthGranularity;
    VkBool32               strictLines;
    VkBool32               standardSampleLocations;
    VkDeviceSize           optimalBufferCopyOffsetAlignment;
    VkDeviceSize           optimalBufferCopyRowPitchAlignment;
    VkDeviceSize           nonCoherentAtomSize;
} VkPhysicalDeviceLimits;

typedef struct VkPhysicalDeviceSparseProperties {
    VkBool32               residencyStandard2DBlockShape;
    VkBool32               residencyStandard2DMultisampleBlockShape;
    VkBool32               residencyStandard3DBlockShape;
    VkBool32               residencyAlignedMipSize;
    VkBool32               residencyNonResidentStrict;
} VkPhysicalDeviceSparseProperties;

typedef struct VkPhysicalDeviceProperties {
    uint32_t       apiVersion;
    uint32_t       driverVersion;
    uint32_t       vendorID;
    uint32_t       deviceID;
    VkPhysicalDeviceType deviceType;
    char           deviceName[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE];
    uint8_t        pipelineCacheUUID[VK_UUID_SIZE];
    VkPhysicalDeviceLimits limits;
    VkPhysicalDeviceSparseProperties sparseProperties;
} VkPhysicalDeviceProperties;

typedef struct VkExtensionProperties {
    char            extensionName[VK_MAX_EXTENSION_NAME_SIZE];
    uint32_t        specVersion;
} VkExtensionProperties;

typedef struct VkLayerProperties {
    char            layerName[VK_MAX_EXTENSION_NAME_SIZE];
    uint32_t        specVersion;
    uint32_t        implementationVersion;
    char            description[VK_MAX_DESCRIPTION_SIZE];
} VkLayerProperties;

typedef struct VkApplicationInfo {
    VkStructureType sType;
    const void*     pNext;
    const char*     pApplicationName;
    uint32_t        applicationVersion;
    const char*     pEngineName;
    uint32_t        engineVersion;
    uint32_t        apiVersion;
} VkApplicationInfo;

typedef struct VkAllocationCallbacks {
    void*           pUserData;
    PFN_vkAllocationFunction   pfnAllocation;
    PFN_vkReallocationFunction pfnReallocation;
    PFN_vkFreeFunction    pfnFree;
    PFN_vkInternalAllocationNotification pfnInternalAllocation;
    PFN_vkInternalFreeNotification pfnInternalFree;
} VkAllocationCallbacks;

typedef struct VkDeviceQueueCreateInfo {
    VkStructureType sType;
    const void*     pNext;
    VkDeviceQueueCreateFlags    flags;
    uint32_t        queueFamilyIndex;
    uint32_t        queueCount;
    const float*    pQueuePriorities;
} VkDeviceQueueCreateInfo;

typedef struct VkPhysicalDeviceFeatures {
    VkBool32               robustBufferAccess;
    VkBool32               fullDrawIndexUint32;
    VkBool32               imageCubeArray;
    VkBool32               independentBlend;
    VkBool32               geometryShader;
    VkBool32               tessellationShader;
    VkBool32               sampleRateShading;
    VkBool32               dualSrcBlend;
    VkBool32               logicOp;
    VkBool32               multiDrawIndirect;
    VkBool32               drawIndirectFirstInstance;
    VkBool32               depthClamp;
    VkBool32               depthBiasClamp;
    VkBool32               fillModeNonSolid;
    VkBool32               depthBounds;
    VkBool32               wideLines;
    VkBool32               largePoints;
    VkBool32               alphaToOne;
    VkBool32               multiViewport;
    VkBool32               samplerAnisotropy;
    VkBool32               textureCompressionETC2;
    VkBool32               textureCompressionASTC_LDR;
    VkBool32               textureCompressionBC;
    VkBool32               occlusionQueryPrecise;
    VkBool32               pipelineStatisticsQuery;
    VkBool32               vertexPipelineStoresAndAtomics;
    VkBool32               fragmentStoresAndAtomics;
    VkBool32               shaderTessellationAndGeometryPointSize;
    VkBool32               shaderImageGatherExtended;
    VkBool32               shaderStorageImageExtendedFormats;
    VkBool32               shaderStorageImageMultisample;
    VkBool32               shaderStorageImageReadWithoutFormat;
    VkBool32               shaderStorageImageWriteWithoutFormat;
    VkBool32               shaderUniformBufferArrayDynamicIndexing;
    VkBool32               shaderSampledImageArrayDynamicIndexing;
    VkBool32               shaderStorageBufferArrayDynamicIndexing;
    VkBool32               shaderStorageImageArrayDynamicIndexing;
    VkBool32               shaderClipDistance;
    VkBool32               shaderCullDistance;
    VkBool32               shaderFloat64;
    VkBool32               shaderInt64;
    VkBool32               shaderInt16;
    VkBool32               shaderResourceResidency;
    VkBool32               shaderResourceMinLod;
    VkBool32               sparseBinding;
    VkBool32               sparseResidencyBuffer;
    VkBool32               sparseResidencyImage2D;
    VkBool32               sparseResidencyImage3D;
    VkBool32               sparseResidency2Samples;
    VkBool32               sparseResidency4Samples;
    VkBool32               sparseResidency8Samples;
    VkBool32               sparseResidency16Samples;
    VkBool32               sparseResidencyAliased;
    VkBool32               variableMultisampleRate;
    VkBool32               inheritedQueries;
} VkPhysicalDeviceFeatures;

typedef struct VkDeviceCreateInfo {
    VkStructureType sType;
    const void*     pNext;
    VkDeviceCreateFlags    flags;
    uint32_t        queueCreateInfoCount;
    const VkDeviceQueueCreateInfo* pQueueCreateInfos;
    uint32_t               enabledLayerCount;
    const char* const*      ppEnabledLayerNames;
    uint32_t               enabledExtensionCount;
    const char* const*      ppEnabledExtensionNames;
    const VkPhysicalDeviceFeatures* pEnabledFeatures;
} VkDeviceCreateInfo;

typedef struct VkInstanceCreateInfo {
    VkStructureType sType;
    const void*     pNext;
    VkInstanceCreateFlags  flags;
    const VkApplicationInfo* pApplicationInfo;
    uint32_t               enabledLayerCount;
    const char* const*      ppEnabledLayerNames;
    uint32_t               enabledExtensionCount;
    const char* const*      ppEnabledExtensionNames;
} VkInstanceCreateInfo;

typedef struct VkQueueFamilyProperties {
    VkQueueFlags           queueFlags;
    uint32_t               queueCount;
    uint32_t               timestampValidBits;
    VkExtent3D             minImageTransferGranularity;
} VkQueueFamilyProperties;

typedef struct VkMemoryHeap {
    VkDeviceSize           size;
    VkMemoryHeapFlags      flags;
} VkMemoryHeap;

typedef struct VkMemoryType {
    VkMemoryPropertyFlags  propertyFlags;
    uint32_t               heapIndex;
} VkMemoryType;

typedef struct VkPhysicalDeviceMemoryProperties {
    uint32_t               memoryTypeCount;
    VkMemoryType           memoryTypes[VK_MAX_MEMORY_TYPES];
    uint32_t               memoryHeapCount;
    VkMemoryHeap           memoryHeaps[VK_MAX_MEMORY_HEAPS];
} VkPhysicalDeviceMemoryProperties;

typedef struct VkMemoryAllocateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkDeviceSize           allocationSize;
    uint32_t               memoryTypeIndex;
} VkMemoryAllocateInfo;

typedef struct VkMemoryRequirements {
    VkDeviceSize           size;
    VkDeviceSize           alignment;
    uint32_t               memoryTypeBits;
} VkMemoryRequirements;

typedef struct VkSparseImageFormatProperties {
    VkImageAspectFlags     aspectMask;
    VkExtent3D             imageGranularity;
    VkSparseImageFormatFlags flags;
} VkSparseImageFormatProperties;

typedef struct VkSparseImageMemoryRequirements {
    VkSparseImageFormatProperties formatProperties;
    uint32_t               imageMipTailFirstLod;
    VkDeviceSize           imageMipTailSize;
    VkDeviceSize           imageMipTailOffset;
    VkDeviceSize           imageMipTailStride;
} VkSparseImageMemoryRequirements;

typedef struct VkMappedMemoryRange {
    VkStructureType sType;
    const void*            pNext;
    VkDeviceMemory         memory;
    VkDeviceSize           offset;
    VkDeviceSize           size;
} VkMappedMemoryRange;

typedef struct VkFormatProperties {
    VkFormatFeatureFlags   linearTilingFeatures;
    VkFormatFeatureFlags   optimalTilingFeatures;
    VkFormatFeatureFlags   bufferFeatures;
} VkFormatProperties;

typedef struct VkImageFormatProperties {
    VkExtent3D             maxExtent;
    uint32_t               maxMipLevels;
    uint32_t               maxArrayLayers;
    VkSampleCountFlags     sampleCounts;
    VkDeviceSize           maxResourceSize;
} VkImageFormatProperties;

typedef struct VkDescriptorBufferInfo {
    VkBuffer               buffer;
    VkDeviceSize           offset;
    VkDeviceSize           range;
} VkDescriptorBufferInfo;

typedef struct VkDescriptorImageInfo {
    VkSampler       sampler;
    VkImageView     imageView;
    VkImageLayout   imageLayout;
} VkDescriptorImageInfo;

typedef struct VkWriteDescriptorSet {
    VkStructureType sType;
    const void*            pNext;
    VkDescriptorSet        dstSet;
    uint32_t               dstBinding;
    uint32_t               dstArrayElement;
    uint32_t               descriptorCount;
    VkDescriptorType       descriptorType;
    const VkDescriptorImageInfo* pImageInfo;
    const VkDescriptorBufferInfo* pBufferInfo;
    const VkBufferView*    pTexelBufferView;
} VkWriteDescriptorSet;

typedef struct VkCopyDescriptorSet {
    VkStructureType sType;
    const void*            pNext;
    VkDescriptorSet        srcSet;
    uint32_t               srcBinding;
    uint32_t               srcArrayElement;
    VkDescriptorSet        dstSet;
    uint32_t               dstBinding;
    uint32_t               dstArrayElement;
    uint32_t               descriptorCount;
} VkCopyDescriptorSet;

typedef struct VkBufferCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkBufferCreateFlags    flags;
    VkDeviceSize           size;
    VkBufferUsageFlags     usage;
    VkSharingMode          sharingMode;
    uint32_t               queueFamilyIndexCount;
    const uint32_t*        pQueueFamilyIndices;
} VkBufferCreateInfo;

typedef struct VkBufferViewCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkBufferViewCreateFlags flags;
    VkBuffer               buffer;
    VkFormat               format;
    VkDeviceSize           offset;
    VkDeviceSize           range;
} VkBufferViewCreateInfo;

typedef struct VkImageSubresource {
    VkImageAspectFlags     aspectMask;
    uint32_t               mipLevel;
    uint32_t               arrayLayer;
} VkImageSubresource;

typedef struct VkImageSubresourceLayers {
    VkImageAspectFlags     aspectMask;
    uint32_t               mipLevel;
    uint32_t               baseArrayLayer;
    uint32_t               layerCount;
} VkImageSubresourceLayers;

typedef struct VkImageSubresourceRange {
    VkImageAspectFlags     aspectMask;
    uint32_t               baseMipLevel;
    uint32_t               levelCount;
    uint32_t               baseArrayLayer;
    uint32_t               layerCount;
} VkImageSubresourceRange;

typedef struct VkMemoryBarrier {
    VkStructureType sType;
    const void*            pNext;
    VkAccessFlags          srcAccessMask;
    VkAccessFlags          dstAccessMask;
} VkMemoryBarrier;

typedef struct VkBufferMemoryBarrier {
    VkStructureType sType;
    const void*            pNext;
    VkAccessFlags          srcAccessMask;
    VkAccessFlags          dstAccessMask;
    uint32_t               srcQueueFamilyIndex;
    uint32_t               dstQueueFamilyIndex;
    VkBuffer               buffer;
    VkDeviceSize           offset;
    VkDeviceSize           size;
} VkBufferMemoryBarrier;

typedef struct VkImageMemoryBarrier {
    VkStructureType sType;
    const void*            pNext;
    VkAccessFlags          srcAccessMask;
    VkAccessFlags          dstAccessMask;
    VkImageLayout          oldLayout;
    VkImageLayout          newLayout;
    uint32_t               srcQueueFamilyIndex;
    uint32_t               dstQueueFamilyIndex;
    VkImage                image;
    VkImageSubresourceRange subresourceRange;
} VkImageMemoryBarrier;

typedef struct VkImageCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkImageCreateFlags     flags;
    VkImageType            imageType;
    VkFormat               format;
    VkExtent3D             extent;
    uint32_t               mipLevels;
    uint32_t               arrayLayers;
    VkSampleCountFlagBits  samples;
    VkImageTiling          tiling;
    VkImageUsageFlags      usage;
    VkSharingMode          sharingMode;
    uint32_t               queueFamilyIndexCount;
    const uint32_t*        pQueueFamilyIndices;
    VkImageLayout          initialLayout;
} VkImageCreateInfo;

typedef struct VkSubresourceLayout {
    VkDeviceSize           offset;
    VkDeviceSize           size;
    VkDeviceSize           rowPitch;
    VkDeviceSize           arrayPitch;
    VkDeviceSize           depthPitch;
} VkSubresourceLayout;

typedef struct VkImageViewCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkImageViewCreateFlags flags;
    VkImage                image;
    VkImageViewType        viewType;
    VkFormat               format;
    VkComponentMapping     components;
    VkImageSubresourceRange subresourceRange;
} VkImageViewCreateInfo;

typedef struct VkBufferCopy {
    VkDeviceSize                       srcOffset;
    VkDeviceSize                       dstOffset;
    VkDeviceSize size;
} VkBufferCopy;

typedef struct VkSparseMemoryBind {
    VkDeviceSize           resourceOffset;
    VkDeviceSize           size;
    VkDeviceMemory         memory;
    VkDeviceSize           memoryOffset;
    VkSparseMemoryBindFlags flags;
} VkSparseMemoryBind;

typedef struct VkSparseImageMemoryBind {
    VkImageSubresource     subresource;
    VkOffset3D             offset;
    VkExtent3D             extent;
    VkDeviceMemory         memory;
    VkDeviceSize           memoryOffset;
    VkSparseMemoryBindFlags flags;
} VkSparseImageMemoryBind;

typedef struct VkSparseBufferMemoryBindInfo {
    VkBuffer buffer;
    uint32_t               bindCount;
    const VkSparseMemoryBind* pBinds;
} VkSparseBufferMemoryBindInfo;

typedef struct VkSparseImageOpaqueMemoryBindInfo {
    VkImage image;
    uint32_t               bindCount;
    const VkSparseMemoryBind* pBinds;
} VkSparseImageOpaqueMemoryBindInfo;

typedef struct VkSparseImageMemoryBindInfo {
    VkImage image;
    uint32_t               bindCount;
    const VkSparseImageMemoryBind* pBinds;
} VkSparseImageMemoryBindInfo;

typedef struct VkBindSparseInfo {
    VkStructureType sType;
    const void*            pNext;
    uint32_t               waitSemaphoreCount;
    const VkSemaphore*     pWaitSemaphores;
    uint32_t               bufferBindCount;
    const VkSparseBufferMemoryBindInfo* pBufferBinds;
    uint32_t               imageOpaqueBindCount;
    const VkSparseImageOpaqueMemoryBindInfo* pImageOpaqueBinds;
    uint32_t               imageBindCount;
    const VkSparseImageMemoryBindInfo* pImageBinds;
    uint32_t               signalSemaphoreCount;
    const VkSemaphore*     pSignalSemaphores;
} VkBindSparseInfo;

typedef struct VkImageCopy {
    VkImageSubresourceLayers srcSubresource;
    VkOffset3D             srcOffset;
    VkImageSubresourceLayers dstSubresource;
    VkOffset3D             dstOffset;
    VkExtent3D             extent;
} VkImageCopy;

typedef struct VkImageBlit {
    VkImageSubresourceLayers srcSubresource;
    VkOffset3D             srcOffsets[2];
    VkImageSubresourceLayers dstSubresource;
    VkOffset3D             dstOffsets[2];
} VkImageBlit;

typedef struct VkBufferImageCopy {
    VkDeviceSize           bufferOffset;
    uint32_t               bufferRowLength;
    uint32_t               bufferImageHeight;
    VkImageSubresourceLayers imageSubresource;
    VkOffset3D             imageOffset;
    VkExtent3D             imageExtent;
} VkBufferImageCopy;

typedef struct VkImageResolve {
    VkImageSubresourceLayers srcSubresource;
    VkOffset3D             srcOffset;
    VkImageSubresourceLayers dstSubresource;
    VkOffset3D             dstOffset;
    VkExtent3D             extent;
} VkImageResolve;

typedef struct VkShaderModuleCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkShaderModuleCreateFlags flags;
    size_t                 codeSize;
    const uint32_t*            pCode;
} VkShaderModuleCreateInfo;

typedef struct VkDescriptorSetLayoutBinding {
    uint32_t               binding;
    VkDescriptorType       descriptorType;
    uint32_t descriptorCount;
    VkShaderStageFlags     stageFlags;
    const VkSampler*       pImmutableSamplers;
} VkDescriptorSetLayoutBinding;

typedef struct VkDescriptorSetLayoutCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkDescriptorSetLayoutCreateFlags    flags;
    uint32_t               bindingCount;
    const VkDescriptorSetLayoutBinding* pBindings;
} VkDescriptorSetLayoutCreateInfo;

typedef struct VkDescriptorPoolSize {
    VkDescriptorType       type;
    uint32_t               descriptorCount;
} VkDescriptorPoolSize;

typedef struct VkDescriptorPoolCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkDescriptorPoolCreateFlags  flags;
    uint32_t               maxSets;
    uint32_t               poolSizeCount;
    const VkDescriptorPoolSize* pPoolSizes;
} VkDescriptorPoolCreateInfo;

typedef struct VkDescriptorSetAllocateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkDescriptorPool       descriptorPool;
    uint32_t               descriptorSetCount;
    const VkDescriptorSetLayout* pSetLayouts;
} VkDescriptorSetAllocateInfo;

typedef struct VkSpecializationMapEntry {
    uint32_t                     constantID;
    uint32_t                     offset;
    size_t size;
} VkSpecializationMapEntry;

typedef struct VkSpecializationInfo {
    uint32_t               mapEntryCount;
    const VkSpecializationMapEntry* pMapEntries;
    size_t                 dataSize;
    const void*            pData;
} VkSpecializationInfo;

typedef struct VkPipelineShaderStageCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineShaderStageCreateFlags    flags;
    VkShaderStageFlagBits  stage;
    VkShaderModule         module;
    const char*            pName;
    const VkSpecializationInfo* pSpecializationInfo;
} VkPipelineShaderStageCreateInfo;

typedef struct VkComputePipelineCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineCreateFlags  flags;
    VkPipelineShaderStageCreateInfo stage;
    VkPipelineLayout       layout;
    VkPipeline      basePipelineHandle;
    int32_t                basePipelineIndex;
} VkComputePipelineCreateInfo;

typedef struct VkVertexInputBindingDescription {
    uint32_t               binding;
    uint32_t               stride;
    VkVertexInputRate      inputRate;
} VkVertexInputBindingDescription;

typedef struct VkVertexInputAttributeDescription {
    uint32_t               location;
    uint32_t               binding;
    VkFormat               format;
    uint32_t               offset;
} VkVertexInputAttributeDescription;

typedef struct VkPipelineVertexInputStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineVertexInputStateCreateFlags    flags;
    uint32_t               vertexBindingDescriptionCount;
    const VkVertexInputBindingDescription* pVertexBindingDescriptions;
    uint32_t               vertexAttributeDescriptionCount;
    const VkVertexInputAttributeDescription* pVertexAttributeDescriptions;
} VkPipelineVertexInputStateCreateInfo;

typedef struct VkPipelineInputAssemblyStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineInputAssemblyStateCreateFlags    flags;
    VkPrimitiveTopology    topology;
    VkBool32               primitiveRestartEnable;
} VkPipelineInputAssemblyStateCreateInfo;

typedef struct VkPipelineTessellationStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineTessellationStateCreateFlags    flags;
    uint32_t               patchControlPoints;
} VkPipelineTessellationStateCreateInfo;

typedef struct VkPipelineViewportStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineViewportStateCreateFlags    flags;
    uint32_t               viewportCount;
    const VkViewport*      pViewports;
    uint32_t               scissorCount;
    const VkRect2D*        pScissors;
} VkPipelineViewportStateCreateInfo;

typedef struct VkPipelineRasterizationStateCreateInfo {
    VkStructureType sType;
    const void* pNext;
    VkPipelineRasterizationStateCreateFlags    flags;
    VkBool32               depthClampEnable;
    VkBool32               rasterizerDiscardEnable;
    VkPolygonMode          polygonMode;
    VkCullModeFlags        cullMode;
    VkFrontFace            frontFace;
    VkBool32               depthBiasEnable;
    float                  depthBiasConstantFactor;
    float                  depthBiasClamp;
    float                  depthBiasSlopeFactor;
    float                  lineWidth;
} VkPipelineRasterizationStateCreateInfo;

typedef struct VkPipelineMultisampleStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineMultisampleStateCreateFlags    flags;
    VkSampleCountFlagBits  rasterizationSamples;
    VkBool32               sampleShadingEnable;
    float                  minSampleShading;
    const VkSampleMask*    pSampleMask;
    VkBool32               alphaToCoverageEnable;
    VkBool32               alphaToOneEnable;
} VkPipelineMultisampleStateCreateInfo;

typedef struct VkPipelineColorBlendAttachmentState {
    VkBool32               blendEnable;
    VkBlendFactor          srcColorBlendFactor;
    VkBlendFactor          dstColorBlendFactor;
    VkBlendOp              colorBlendOp;
    VkBlendFactor          srcAlphaBlendFactor;
    VkBlendFactor          dstAlphaBlendFactor;
    VkBlendOp              alphaBlendOp;
    VkColorComponentFlags  colorWriteMask;
} VkPipelineColorBlendAttachmentState;

typedef struct VkPipelineColorBlendStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineColorBlendStateCreateFlags    flags;
    VkBool32               logicOpEnable;
    VkLogicOp              logicOp;
    uint32_t               attachmentCount;
    const VkPipelineColorBlendAttachmentState* pAttachments;
    float                  blendConstants[4];
} VkPipelineColorBlendStateCreateInfo;

typedef struct VkPipelineDynamicStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineDynamicStateCreateFlags    flags;
    uint32_t               dynamicStateCount;
    const VkDynamicState*  pDynamicStates;
} VkPipelineDynamicStateCreateInfo;

typedef struct VkStencilOpState {
    VkStencilOp            failOp;
    VkStencilOp            passOp;
    VkStencilOp            depthFailOp;
    VkCompareOp            compareOp;
    uint32_t               compareMask;
    uint32_t               writeMask;
    uint32_t               reference;
} VkStencilOpState;

typedef struct VkPipelineDepthStencilStateCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineDepthStencilStateCreateFlags    flags;
    VkBool32               depthTestEnable;
    VkBool32               depthWriteEnable;
    VkCompareOp            depthCompareOp;
    VkBool32               depthBoundsTestEnable;
    VkBool32               stencilTestEnable;
    VkStencilOpState       front;
    VkStencilOpState       back;
    float                  minDepthBounds;
    float                  maxDepthBounds;
} VkPipelineDepthStencilStateCreateInfo;

typedef struct VkGraphicsPipelineCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineCreateFlags  flags;
    uint32_t               stageCount;
    const VkPipelineShaderStageCreateInfo* pStages;
    const VkPipelineVertexInputStateCreateInfo* pVertexInputState;
    const VkPipelineInputAssemblyStateCreateInfo* pInputAssemblyState;
    const VkPipelineTessellationStateCreateInfo* pTessellationState;
    const VkPipelineViewportStateCreateInfo* pViewportState;
    const VkPipelineRasterizationStateCreateInfo* pRasterizationState;
    const VkPipelineMultisampleStateCreateInfo* pMultisampleState;
    const VkPipelineDepthStencilStateCreateInfo* pDepthStencilState;
    const VkPipelineColorBlendStateCreateInfo* pColorBlendState;
    const VkPipelineDynamicStateCreateInfo* pDynamicState;
    VkPipelineLayout       layout;
    VkRenderPass           renderPass;
    uint32_t               subpass;
    VkPipeline      basePipelineHandle;
    int32_t                basePipelineIndex;
} VkGraphicsPipelineCreateInfo;

typedef struct VkPipelineCacheCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineCacheCreateFlags    flags;
    size_t                 initialDataSize;
    const void*            pInitialData;
} VkPipelineCacheCreateInfo;

typedef struct VkPushConstantRange {
    VkShaderStageFlags     stageFlags;
    uint32_t               offset;
    uint32_t               size;
} VkPushConstantRange;

typedef struct VkPipelineLayoutCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkPipelineLayoutCreateFlags    flags;
    uint32_t               setLayoutCount;
    const VkDescriptorSetLayout* pSetLayouts;
    uint32_t               pushConstantRangeCount;
    const VkPushConstantRange* pPushConstantRanges;
} VkPipelineLayoutCreateInfo;

typedef struct VkSamplerCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSamplerCreateFlags   flags;
    VkFilter               magFilter;
    VkFilter               minFilter;
    VkSamplerMipmapMode    mipmapMode;
    VkSamplerAddressMode   addressModeU;
    VkSamplerAddressMode   addressModeV;
    VkSamplerAddressMode   addressModeW;
    float                  mipLodBias;
    VkBool32               anisotropyEnable;
    float                  maxAnisotropy;
    VkBool32               compareEnable;
    VkCompareOp            compareOp;
    float                  minLod;
    float                  maxLod;
    VkBorderColor          borderColor;
    VkBool32               unnormalizedCoordinates;
} VkSamplerCreateInfo;

typedef struct VkCommandPoolCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkCommandPoolCreateFlags   flags;
    uint32_t               queueFamilyIndex;
} VkCommandPoolCreateInfo;

typedef struct VkCommandBufferAllocateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkCommandPool          commandPool;
    VkCommandBufferLevel   level;
    uint32_t               commandBufferCount;
} VkCommandBufferAllocateInfo;

typedef struct VkCommandBufferInheritanceInfo {
    VkStructureType sType;
    const void*            pNext;
    VkRenderPass    renderPass;
    uint32_t               subpass;
    VkFramebuffer   framebuffer;
    VkBool32               occlusionQueryEnable;
    VkQueryControlFlags    queryFlags;
    VkQueryPipelineStatisticFlags pipelineStatistics;
} VkCommandBufferInheritanceInfo;

typedef struct VkCommandBufferBeginInfo {
    VkStructureType sType;
    const void*            pNext;
    VkCommandBufferUsageFlags  flags;
    const VkCommandBufferInheritanceInfo*       pInheritanceInfo;
} VkCommandBufferBeginInfo;

typedef union VkClearColorValue {
    float                  float32[4];
    int32_t                int32[4];
    uint32_t               uint32[4];
} VkClearColorValue;

typedef struct VkClearDepthStencilValue {
    float                  depth;
    uint32_t               stencil;
} VkClearDepthStencilValue;

typedef union VkClearValue {
    VkClearColorValue      color;
    VkClearDepthStencilValue depthStencil;
} VkClearValue;

typedef struct VkRenderPassBeginInfo {
    VkStructureType sType;
    const void*            pNext;
    VkRenderPass           renderPass;
    VkFramebuffer          framebuffer;
    VkRect2D               renderArea;
    uint32_t               clearValueCount;
    const VkClearValue*    pClearValues;
} VkRenderPassBeginInfo;

typedef struct VkClearAttachment {
    VkImageAspectFlags     aspectMask;
    uint32_t               colorAttachment;
    VkClearValue           clearValue;
} VkClearAttachment;

typedef struct VkAttachmentDescription {
    VkAttachmentDescriptionFlags flags;
    VkFormat               format;
    VkSampleCountFlagBits  samples;
    VkAttachmentLoadOp     loadOp;
    VkAttachmentStoreOp    storeOp;
    VkAttachmentLoadOp     stencilLoadOp;
    VkAttachmentStoreOp    stencilStoreOp;
    VkImageLayout          initialLayout;
    VkImageLayout          finalLayout;
} VkAttachmentDescription;

typedef struct VkAttachmentReference {
    uint32_t               attachment;
    VkImageLayout          layout;
} VkAttachmentReference;

typedef struct VkSubpassDescription {
    VkSubpassDescriptionFlags flags;
    VkPipelineBindPoint    pipelineBindPoint;
    uint32_t               inputAttachmentCount;
    const VkAttachmentReference* pInputAttachments;
    uint32_t               colorAttachmentCount;
    const VkAttachmentReference* pColorAttachments;
    const VkAttachmentReference* pResolveAttachments;
    const VkAttachmentReference* pDepthStencilAttachment;
    uint32_t               preserveAttachmentCount;
    const uint32_t* pPreserveAttachments;
} VkSubpassDescription;

typedef struct VkSubpassDependency {
    uint32_t               srcSubpass;
    uint32_t               dstSubpass;
    VkPipelineStageFlags   srcStageMask;
    VkPipelineStageFlags   dstStageMask;
    VkAccessFlags          srcAccessMask;
    VkAccessFlags          dstAccessMask;
    VkDependencyFlags      dependencyFlags;
} VkSubpassDependency;

typedef struct VkRenderPassCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkRenderPassCreateFlags flags;
    uint32_t   attachmentCount;
    const VkAttachmentDescription* pAttachments;
    uint32_t               subpassCount;
    const VkSubpassDescription* pSubpasses;
    uint32_t       dependencyCount;
    const VkSubpassDependency* pDependencies;
} VkRenderPassCreateInfo;

typedef struct VkEventCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkEventCreateFlags     flags;
} VkEventCreateInfo;

typedef struct VkFenceCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkFenceCreateFlags     flags;
} VkFenceCreateInfo;

typedef struct VkSemaphoreCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSemaphoreCreateFlags flags;
} VkSemaphoreCreateInfo;

typedef struct VkQueryPoolCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkQueryPoolCreateFlags flags;
    VkQueryType            queryType;
    uint32_t               queryCount;
    VkQueryPipelineStatisticFlags pipelineStatistics;
} VkQueryPoolCreateInfo;

typedef struct VkFramebufferCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkFramebufferCreateFlags    flags;
    VkRenderPass           renderPass;
    uint32_t               attachmentCount;
    const VkImageView*     pAttachments;
    uint32_t               width;
    uint32_t               height;
    uint32_t               layers;
} VkFramebufferCreateInfo;

typedef struct VkDrawIndirectCommand {
    uint32_t                       vertexCount;
    uint32_t                       instanceCount;
    uint32_t                       firstVertex;
    uint32_t firstInstance;
} VkDrawIndirectCommand;

typedef struct VkDrawIndexedIndirectCommand {
    uint32_t                       indexCount;
    uint32_t                       instanceCount;
    uint32_t                       firstIndex;
    int32_t                        vertexOffset;
    uint32_t firstInstance;
} VkDrawIndexedIndirectCommand;

typedef struct VkDispatchIndirectCommand {
    uint32_t x;
    uint32_t y;
    uint32_t z;
} VkDispatchIndirectCommand;

typedef struct VkSubmitInfo {
    VkStructureType sType;
    const void* pNext;
    uint32_t       waitSemaphoreCount;
    const VkSemaphore*     pWaitSemaphores;
    const VkPipelineStageFlags*           pWaitDstStageMask;
    uint32_t       commandBufferCount;
    const VkCommandBuffer*     pCommandBuffers;
    uint32_t       signalSemaphoreCount;
    const VkSemaphore*     pSignalSemaphores;
} VkSubmitInfo;

typedef struct VkPhysicalDeviceFeatures2 {
    VkStructureType sType;
    void*                            pNext;
    VkPhysicalDeviceFeatures         features;
} VkPhysicalDeviceFeatures2;

typedef VkPhysicalDeviceFeatures2 VkPhysicalDeviceFeatures2KHR;

typedef struct VkPhysicalDeviceProperties2 {
    VkStructureType sType;
    void*                            pNext;
    VkPhysicalDeviceProperties       properties;
} VkPhysicalDeviceProperties2;

typedef VkPhysicalDeviceProperties2 VkPhysicalDeviceProperties2KHR;

typedef struct VkFormatProperties2 {
    VkStructureType sType;
    void*                            pNext;
    VkFormatProperties               formatProperties;
} VkFormatProperties2;

typedef VkFormatProperties2 VkFormatProperties2KHR;

typedef struct VkImageFormatProperties2 {
    VkStructureType sType;
    void* pNext;
    VkImageFormatProperties          imageFormatProperties;
} VkImageFormatProperties2;

typedef VkImageFormatProperties2 VkImageFormatProperties2KHR;

typedef struct VkPhysicalDeviceImageFormatInfo2 {
    VkStructureType sType;
    const void* pNext;
    VkFormat                         format;
    VkImageType                      type;
    VkImageTiling                    tiling;
    VkImageUsageFlags                usage;
    VkImageCreateFlags flags;
} VkPhysicalDeviceImageFormatInfo2;

typedef VkPhysicalDeviceImageFormatInfo2 VkPhysicalDeviceImageFormatInfo2KHR;

typedef struct VkQueueFamilyProperties2 {
    VkStructureType sType;
    void*                            pNext;
    VkQueueFamilyProperties          queueFamilyProperties;
} VkQueueFamilyProperties2;

typedef VkQueueFamilyProperties2 VkQueueFamilyProperties2KHR;

typedef struct VkPhysicalDeviceMemoryProperties2 {
    VkStructureType sType;
    void*                            pNext;
    VkPhysicalDeviceMemoryProperties memoryProperties;
} VkPhysicalDeviceMemoryProperties2;

typedef VkPhysicalDeviceMemoryProperties2 VkPhysicalDeviceMemoryProperties2KHR;

typedef struct VkSparseImageFormatProperties2 {
    VkStructureType sType;
    void*                            pNext;
    VkSparseImageFormatProperties    properties;
} VkSparseImageFormatProperties2;

typedef VkSparseImageFormatProperties2 VkSparseImageFormatProperties2KHR;

typedef struct VkPhysicalDeviceSparseImageFormatInfo2 {
    VkStructureType sType;
    const void*                      pNext;
    VkFormat                         format;
    VkImageType                      type;
    VkSampleCountFlagBits            samples;
    VkImageUsageFlags                usage;
    VkImageTiling                    tiling;
} VkPhysicalDeviceSparseImageFormatInfo2;

typedef VkPhysicalDeviceSparseImageFormatInfo2 VkPhysicalDeviceSparseImageFormatInfo2KHR;

typedef struct VkConformanceVersion {
    uint8_t                          major;
    uint8_t                          minor;
    uint8_t                          subminor;
    uint8_t                          patch;
} VkConformanceVersion;

typedef struct VkPhysicalDeviceDriverProperties {
    VkStructureType sType;
    void*                            pNext;
    VkDriverId                       driverID;
    char                             driverName[VK_MAX_DRIVER_NAME_SIZE];
    char                             driverInfo[VK_MAX_DRIVER_INFO_SIZE];
    VkConformanceVersion             conformanceVersion;
} VkPhysicalDeviceDriverProperties;

typedef struct VkPhysicalDeviceVariablePointersFeatures {
    VkStructureType sType;
    void*                            pNext;
    VkBool32                         variablePointersStorageBuffer;
    VkBool32                         variablePointers;
} VkPhysicalDeviceVariablePointersFeatures;

typedef VkPhysicalDeviceVariablePointersFeatures VkPhysicalDeviceVariablePointersFeaturesKHR;

typedef VkPhysicalDeviceVariablePointersFeatures VkPhysicalDeviceVariablePointerFeaturesKHR;

typedef VkPhysicalDeviceVariablePointersFeatures VkPhysicalDeviceVariablePointerFeatures;

typedef struct VkExternalMemoryProperties {
    VkExternalMemoryFeatureFlags  externalMemoryFeatures;
    VkExternalMemoryHandleTypeFlags exportFromImportedHandleTypes;
    VkExternalMemoryHandleTypeFlags compatibleHandleTypes;
} VkExternalMemoryProperties;

typedef struct VkPhysicalDeviceExternalImageFormatInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalMemoryHandleTypeFlagBits handleType;
} VkPhysicalDeviceExternalImageFormatInfo;

typedef VkPhysicalDeviceExternalImageFormatInfo VkPhysicalDeviceExternalImageFormatInfoKHR;

typedef struct VkExternalImageFormatProperties {
    VkStructureType sType;
    void*                            pNext;
    VkExternalMemoryProperties externalMemoryProperties;
} VkExternalImageFormatProperties;

typedef VkExternalImageFormatProperties VkExternalImageFormatPropertiesKHR;

typedef struct VkPhysicalDeviceExternalBufferInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkBufferCreateFlags flags;
    VkBufferUsageFlags               usage;
    VkExternalMemoryHandleTypeFlagBits handleType;
} VkPhysicalDeviceExternalBufferInfo;

typedef VkPhysicalDeviceExternalBufferInfo VkPhysicalDeviceExternalBufferInfoKHR;

typedef struct VkExternalBufferProperties {
    VkStructureType sType;
    void*                            pNext;
    VkExternalMemoryProperties    externalMemoryProperties;
} VkExternalBufferProperties;

typedef VkExternalBufferProperties VkExternalBufferPropertiesKHR;

typedef struct VkPhysicalDeviceIDProperties {
    VkStructureType sType;
    void*                            pNext;
    uint8_t                          deviceUUID[VK_UUID_SIZE];
    uint8_t                          driverUUID[VK_UUID_SIZE];
    uint8_t                          deviceLUID[VK_LUID_SIZE];
    uint32_t                         deviceNodeMask;
    VkBool32                         deviceLUIDValid;
} VkPhysicalDeviceIDProperties;

typedef VkPhysicalDeviceIDProperties VkPhysicalDeviceIDPropertiesKHR;

typedef struct VkExternalMemoryImageCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalMemoryHandleTypeFlags handleTypes;
} VkExternalMemoryImageCreateInfo;

typedef VkExternalMemoryImageCreateInfo VkExternalMemoryImageCreateInfoKHR;

typedef struct VkExternalMemoryBufferCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalMemoryHandleTypeFlags handleTypes;
} VkExternalMemoryBufferCreateInfo;

typedef VkExternalMemoryBufferCreateInfo VkExternalMemoryBufferCreateInfoKHR;

typedef struct VkExportMemoryAllocateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalMemoryHandleTypeFlags handleTypes;
} VkExportMemoryAllocateInfo;

typedef VkExportMemoryAllocateInfo VkExportMemoryAllocateInfoKHR;

typedef struct VkPhysicalDeviceExternalSemaphoreInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalSemaphoreHandleTypeFlagBits handleType;
} VkPhysicalDeviceExternalSemaphoreInfo;

typedef VkPhysicalDeviceExternalSemaphoreInfo VkPhysicalDeviceExternalSemaphoreInfoKHR;

typedef struct VkExternalSemaphoreProperties {
    VkStructureType sType;
    void*                            pNext;
    VkExternalSemaphoreHandleTypeFlags exportFromImportedHandleTypes;
    VkExternalSemaphoreHandleTypeFlags compatibleHandleTypes;
    VkExternalSemaphoreFeatureFlags externalSemaphoreFeatures;
} VkExternalSemaphoreProperties;

typedef VkExternalSemaphoreProperties VkExternalSemaphorePropertiesKHR;

typedef struct VkExportSemaphoreCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalSemaphoreHandleTypeFlags handleTypes;
} VkExportSemaphoreCreateInfo;

typedef VkExportSemaphoreCreateInfo VkExportSemaphoreCreateInfoKHR;

typedef struct VkPhysicalDeviceExternalFenceInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalFenceHandleTypeFlagBits handleType;
} VkPhysicalDeviceExternalFenceInfo;

typedef VkPhysicalDeviceExternalFenceInfo VkPhysicalDeviceExternalFenceInfoKHR;

typedef struct VkExternalFenceProperties {
    VkStructureType sType;
    void*                            pNext;
    VkExternalFenceHandleTypeFlags exportFromImportedHandleTypes;
    VkExternalFenceHandleTypeFlags compatibleHandleTypes;
    VkExternalFenceFeatureFlags externalFenceFeatures;
} VkExternalFenceProperties;

typedef VkExternalFenceProperties VkExternalFencePropertiesKHR;

typedef struct VkExportFenceCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkExternalFenceHandleTypeFlags handleTypes;
} VkExportFenceCreateInfo;

typedef VkExportFenceCreateInfo VkExportFenceCreateInfoKHR;

typedef struct VkPhysicalDeviceMultiviewFeatures {
    VkStructureType sType;
    void*                            pNext;
    VkBool32                         multiview;
    VkBool32                         multiviewGeometryShader;
    VkBool32                         multiviewTessellationShader;
} VkPhysicalDeviceMultiviewFeatures;

typedef VkPhysicalDeviceMultiviewFeatures VkPhysicalDeviceMultiviewFeaturesKHR;

typedef struct VkPhysicalDeviceMultiviewProperties {
    VkStructureType sType;
    void*                            pNext;
    uint32_t                         maxMultiviewViewCount;
    uint32_t                         maxMultiviewInstanceIndex;
} VkPhysicalDeviceMultiviewProperties;

typedef VkPhysicalDeviceMultiviewProperties VkPhysicalDeviceMultiviewPropertiesKHR;

typedef struct VkRenderPassMultiviewCreateInfo {
    VkStructureType        sType;
    const void*            pNext;
    uint32_t               subpassCount;
    const uint32_t*     pViewMasks;
    uint32_t               dependencyCount;
    const int32_t*   pViewOffsets;
    uint32_t               correlationMaskCount;
    const uint32_t* pCorrelationMasks;
} VkRenderPassMultiviewCreateInfo;

typedef VkRenderPassMultiviewCreateInfo VkRenderPassMultiviewCreateInfoKHR;

typedef struct VkPhysicalDeviceGroupProperties {
    VkStructureType sType;
    void*                            pNext;
    uint32_t                         physicalDeviceCount;
    VkPhysicalDevice                 physicalDevices[VK_MAX_DEVICE_GROUP_SIZE];
    VkBool32                         subsetAllocation;
} VkPhysicalDeviceGroupProperties;

typedef VkPhysicalDeviceGroupProperties VkPhysicalDeviceGroupPropertiesKHR;

typedef struct VkMemoryAllocateFlagsInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkMemoryAllocateFlags flags;
    uint32_t                         deviceMask;
} VkMemoryAllocateFlagsInfo;

typedef VkMemoryAllocateFlagsInfo VkMemoryAllocateFlagsInfoKHR;

typedef struct VkBindBufferMemoryInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkBuffer                         buffer;
    VkDeviceMemory                   memory;
    VkDeviceSize                     memoryOffset;
} VkBindBufferMemoryInfo;

typedef VkBindBufferMemoryInfo VkBindBufferMemoryInfoKHR;

typedef struct VkBindBufferMemoryDeviceGroupInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t         deviceIndexCount;
    const uint32_t*  pDeviceIndices;
} VkBindBufferMemoryDeviceGroupInfo;

typedef struct VkBindImageMemoryInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkImage                          image;
    VkDeviceMemory                   memory;
    VkDeviceSize                     memoryOffset;
} VkBindImageMemoryInfo;

typedef VkBindImageMemoryInfo VkBindImageMemoryInfoKHR;

typedef struct VkBindImageMemoryDeviceGroupInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t         deviceIndexCount;
    const uint32_t*  pDeviceIndices;
    uint32_t         splitInstanceBindRegionCount;
    const VkRect2D*  pSplitInstanceBindRegions;
} VkBindImageMemoryDeviceGroupInfo;

typedef struct VkDeviceGroupRenderPassBeginInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t                         deviceMask;
    uint32_t         deviceRenderAreaCount;
    const VkRect2D*  pDeviceRenderAreas;
} VkDeviceGroupRenderPassBeginInfo;

typedef VkDeviceGroupRenderPassBeginInfo VkDeviceGroupRenderPassBeginInfoKHR;

typedef struct VkDeviceGroupCommandBufferBeginInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t                         deviceMask;
} VkDeviceGroupCommandBufferBeginInfo;

typedef VkDeviceGroupCommandBufferBeginInfo VkDeviceGroupCommandBufferBeginInfoKHR;

typedef struct VkDeviceGroupSubmitInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t         waitSemaphoreCount;
    const uint32_t*    pWaitSemaphoreDeviceIndices;
    uint32_t         commandBufferCount;
    const uint32_t*    pCommandBufferDeviceMasks;
    uint32_t         signalSemaphoreCount;
    const uint32_t*  pSignalSemaphoreDeviceIndices;
} VkDeviceGroupSubmitInfo;

typedef VkDeviceGroupSubmitInfo VkDeviceGroupSubmitInfoKHR;

typedef struct VkDeviceGroupBindSparseInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t                         resourceDeviceIndex;
    uint32_t                         memoryDeviceIndex;
} VkDeviceGroupBindSparseInfo;

typedef VkDeviceGroupBindSparseInfo VkDeviceGroupBindSparseInfoKHR;

typedef struct VkDeviceGroupDeviceCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t                         physicalDeviceCount;
    const VkPhysicalDevice*  pPhysicalDevices;
} VkDeviceGroupDeviceCreateInfo;

typedef VkDeviceGroupDeviceCreateInfo VkDeviceGroupDeviceCreateInfoKHR;

typedef struct VkDescriptorUpdateTemplateEntry {
    uint32_t                         dstBinding;
    uint32_t                         dstArrayElement;
    uint32_t                         descriptorCount;
    VkDescriptorType                 descriptorType;
    size_t                           offset;
    size_t                           stride;
} VkDescriptorUpdateTemplateEntry;

typedef struct VkDescriptorUpdateTemplateCreateInfo {
    VkStructureType sType;
    const void*                               pNext;
    VkDescriptorUpdateTemplateCreateFlags    flags;
    uint32_t                 descriptorUpdateEntryCount;
    const VkDescriptorUpdateTemplateEntry* pDescriptorUpdateEntries;
    VkDescriptorUpdateTemplateType templateType;
    VkDescriptorSetLayout descriptorSetLayout;
    VkPipelineBindPoint pipelineBindPoint;
    VkPipelineLayout pipelineLayout;
    uint32_t set;
} VkDescriptorUpdateTemplateCreateInfo;

typedef VkDescriptorUpdateTemplateCreateInfo VkDescriptorUpdateTemplateCreateInfoKHR;

typedef struct VkInputAttachmentAspectReference {
    uint32_t                        subpass;
    uint32_t                        inputAttachmentIndex;
    VkImageAspectFlags              aspectMask;
} VkInputAttachmentAspectReference;

typedef struct VkRenderPassInputAttachmentAspectCreateInfo {
    VkStructureType sType;
    const void*                     pNext;
    uint32_t                        aspectReferenceCount;
    const VkInputAttachmentAspectReference* pAspectReferences;
} VkRenderPassInputAttachmentAspectCreateInfo;

typedef VkRenderPassInputAttachmentAspectCreateInfo VkRenderPassInputAttachmentAspectCreateInfoKHR;

typedef struct VkPhysicalDevice16BitStorageFeatures {
    VkStructureType sType;
    void*      pNext;
    VkBool32                         storageBuffer16BitAccess;
    VkBool32                         uniformAndStorageBuffer16BitAccess;
    VkBool32                         storagePushConstant16;
    VkBool32                         storageInputOutput16;
} VkPhysicalDevice16BitStorageFeatures;

typedef VkPhysicalDevice16BitStorageFeatures VkPhysicalDevice16BitStorageFeaturesKHR;

typedef struct VkPhysicalDeviceSubgroupProperties {
    VkStructureType sType;
    void*                   pNext;
    uint32_t                      subgroupSize;
    VkShaderStageFlags            supportedStages;
    VkSubgroupFeatureFlags        supportedOperations;
    VkBool32 quadOperationsInAllStages;
} VkPhysicalDeviceSubgroupProperties;

typedef struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures {
    VkStructureType sType;
    void*                          pNext;
    VkBool32 shaderSubgroupExtendedTypes;
} VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures;

typedef struct VkBufferMemoryRequirementsInfo2 {
    VkStructureType sType;
    const void*                                                          pNext;
    VkBuffer                                                             buffer;
} VkBufferMemoryRequirementsInfo2;

typedef VkBufferMemoryRequirementsInfo2 VkBufferMemoryRequirementsInfo2KHR;

typedef struct VkImageMemoryRequirementsInfo2 {
    VkStructureType sType;
    const void*                                                          pNext;
    VkImage                                                              image;
} VkImageMemoryRequirementsInfo2;

typedef VkImageMemoryRequirementsInfo2 VkImageMemoryRequirementsInfo2KHR;

typedef struct VkImageSparseMemoryRequirementsInfo2 {
    VkStructureType sType;
    const void*                                                          pNext;
    VkImage                                                              image;
} VkImageSparseMemoryRequirementsInfo2;

typedef VkImageSparseMemoryRequirementsInfo2 VkImageSparseMemoryRequirementsInfo2KHR;

typedef struct VkMemoryRequirements2 {
    VkStructureType sType;
    void* pNext;
    VkMemoryRequirements                                                 memoryRequirements;
} VkMemoryRequirements2;

typedef VkMemoryRequirements2 VkMemoryRequirements2KHR;

typedef struct VkSparseImageMemoryRequirements2 {
    VkStructureType sType;
    void*                                       pNext;
    VkSparseImageMemoryRequirements                                      memoryRequirements;
} VkSparseImageMemoryRequirements2;

typedef VkSparseImageMemoryRequirements2 VkSparseImageMemoryRequirements2KHR;

typedef struct VkPhysicalDevicePointClippingProperties {
    VkStructureType sType;
    void*                            pNext;
    VkPointClippingBehavior      pointClippingBehavior;
} VkPhysicalDevicePointClippingProperties;

typedef VkPhysicalDevicePointClippingProperties VkPhysicalDevicePointClippingPropertiesKHR;

typedef struct VkMemoryDedicatedRequirements {
    VkStructureType sType;
    void*                            pNext;
    VkBool32                         prefersDedicatedAllocation;
    VkBool32                         requiresDedicatedAllocation;
} VkMemoryDedicatedRequirements;

typedef VkMemoryDedicatedRequirements VkMemoryDedicatedRequirementsKHR;

typedef struct VkMemoryDedicatedAllocateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkImage          image;
    VkBuffer         buffer;
} VkMemoryDedicatedAllocateInfo;

typedef VkMemoryDedicatedAllocateInfo VkMemoryDedicatedAllocateInfoKHR;

typedef struct VkImageViewUsageCreateInfo {
    VkStructureType sType;
    const void* pNext;
    VkImageUsageFlags usage;
} VkImageViewUsageCreateInfo;

typedef VkImageViewUsageCreateInfo VkImageViewUsageCreateInfoKHR;

typedef struct VkPipelineTessellationDomainOriginStateCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkTessellationDomainOrigin    domainOrigin;
} VkPipelineTessellationDomainOriginStateCreateInfo;

typedef VkPipelineTessellationDomainOriginStateCreateInfo VkPipelineTessellationDomainOriginStateCreateInfoKHR;

typedef struct VkSamplerYcbcrConversionInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkSamplerYcbcrConversion      conversion;
} VkSamplerYcbcrConversionInfo;

typedef VkSamplerYcbcrConversionInfo VkSamplerYcbcrConversionInfoKHR;

typedef struct VkSamplerYcbcrConversionCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkFormat                         format;
    VkSamplerYcbcrModelConversion ycbcrModel;
    VkSamplerYcbcrRange           ycbcrRange;
    VkComponentMapping               components;
    VkChromaLocation              xChromaOffset;
    VkChromaLocation              yChromaOffset;
    VkFilter                         chromaFilter;
    VkBool32                         forceExplicitReconstruction;
} VkSamplerYcbcrConversionCreateInfo;

typedef VkSamplerYcbcrConversionCreateInfo VkSamplerYcbcrConversionCreateInfoKHR;

typedef struct VkBindImagePlaneMemoryInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkImageAspectFlagBits            planeAspect;
} VkBindImagePlaneMemoryInfo;

typedef VkBindImagePlaneMemoryInfo VkBindImagePlaneMemoryInfoKHR;

typedef struct VkImagePlaneMemoryRequirementsInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkImageAspectFlagBits            planeAspect;
} VkImagePlaneMemoryRequirementsInfo;

typedef VkImagePlaneMemoryRequirementsInfo VkImagePlaneMemoryRequirementsInfoKHR;

typedef struct VkPhysicalDeviceSamplerYcbcrConversionFeatures {
    VkStructureType sType;
    void*      pNext;
    VkBool32                         samplerYcbcrConversion;
} VkPhysicalDeviceSamplerYcbcrConversionFeatures;

typedef VkPhysicalDeviceSamplerYcbcrConversionFeatures VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR;

typedef struct VkSamplerYcbcrConversionImageFormatProperties {
    VkStructureType sType;
    void*      pNext;
    uint32_t                         combinedImageSamplerDescriptorCount;
} VkSamplerYcbcrConversionImageFormatProperties;

typedef VkSamplerYcbcrConversionImageFormatProperties VkSamplerYcbcrConversionImageFormatPropertiesKHR;

typedef struct VkProtectedSubmitInfo {
    VkStructureType sType;
    const void*                     pNext;
    VkBool32                        protectedSubmit;
} VkProtectedSubmitInfo;

typedef struct VkPhysicalDeviceProtectedMemoryFeatures {
    VkStructureType sType;
    void*                               pNext;
    VkBool32                            protectedMemory;
} VkPhysicalDeviceProtectedMemoryFeatures;

typedef struct VkPhysicalDeviceProtectedMemoryProperties {
    VkStructureType sType;
    void*                               pNext;
    VkBool32                            protectedNoFault;
} VkPhysicalDeviceProtectedMemoryProperties;

typedef struct VkDeviceQueueInfo2 {
    VkStructureType sType;
    const void*                         pNext;
    VkDeviceQueueCreateFlags            flags;
    uint32_t                            queueFamilyIndex;
    uint32_t                            queueIndex;
} VkDeviceQueueInfo2;

typedef struct VkPhysicalDeviceSamplerFilterMinmaxProperties {
    VkStructureType sType;
    void*                  pNext;
    VkBool32               filterMinmaxSingleComponentFormats;
    VkBool32               filterMinmaxImageComponentMapping;
} VkPhysicalDeviceSamplerFilterMinmaxProperties;

typedef struct VkSamplerReductionModeCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkSamplerReductionMode           reductionMode;
} VkSamplerReductionModeCreateInfo;

typedef struct VkImageFormatListCreateInfo {
    VkStructureType sType;
    const void*                            pNext;
    uint32_t               viewFormatCount;
    const VkFormat*  pViewFormats;
} VkImageFormatListCreateInfo;

typedef struct VkPhysicalDeviceMaintenance3Properties {
    VkStructureType sType;
    void*                            pNext;
    uint32_t                         maxPerSetDescriptors;
    VkDeviceSize                     maxMemoryAllocationSize;
} VkPhysicalDeviceMaintenance3Properties;

typedef VkPhysicalDeviceMaintenance3Properties VkPhysicalDeviceMaintenance3PropertiesKHR;

typedef struct VkDescriptorSetLayoutSupport {
    VkStructureType sType;
    void*            pNext;
    VkBool32         supported;
} VkDescriptorSetLayoutSupport;

typedef VkDescriptorSetLayoutSupport VkDescriptorSetLayoutSupportKHR;

typedef struct VkPhysicalDeviceShaderDrawParametersFeatures {
    VkStructureType sType;
    void*                            pNext;
    VkBool32                         shaderDrawParameters;
} VkPhysicalDeviceShaderDrawParametersFeatures;

typedef VkPhysicalDeviceShaderDrawParametersFeatures VkPhysicalDeviceShaderDrawParameterFeatures;

typedef struct VkPhysicalDeviceShaderFloat16Int8Features {
    VkStructureType sType;
    void*      pNext;
    VkBool32                         shaderFloat16;
    VkBool32                         shaderInt8;
} VkPhysicalDeviceShaderFloat16Int8Features;

typedef struct VkPhysicalDeviceFloatControlsProperties {
    VkStructureType sType;
    void*                            pNext;
    VkShaderFloatControlsIndependence denormBehaviorIndependence;
    VkShaderFloatControlsIndependence roundingModeIndependence;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat16;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat32;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat64;
    VkBool32                         shaderDenormPreserveFloat16;
    VkBool32                         shaderDenormPreserveFloat32;
    VkBool32                         shaderDenormPreserveFloat64;
    VkBool32                         shaderDenormFlushToZeroFloat16;
    VkBool32                         shaderDenormFlushToZeroFloat32;
    VkBool32                         shaderDenormFlushToZeroFloat64;
    VkBool32                         shaderRoundingModeRTEFloat16;
    VkBool32                         shaderRoundingModeRTEFloat32;
    VkBool32                         shaderRoundingModeRTEFloat64;
    VkBool32                         shaderRoundingModeRTZFloat16;
    VkBool32                         shaderRoundingModeRTZFloat32;
    VkBool32                         shaderRoundingModeRTZFloat64;
} VkPhysicalDeviceFloatControlsProperties;

typedef struct VkPhysicalDeviceHostQueryResetFeatures {
    VkStructureType sType;
    void*        pNext;
    VkBool32                           hostQueryReset;
} VkPhysicalDeviceHostQueryResetFeatures;

typedef struct VkPhysicalDeviceDescriptorIndexingFeatures {
    VkStructureType sType;
    void*                            pNext;
    VkBool32               shaderInputAttachmentArrayDynamicIndexing;
    VkBool32               shaderUniformTexelBufferArrayDynamicIndexing;
    VkBool32               shaderStorageTexelBufferArrayDynamicIndexing;
    VkBool32               shaderUniformBufferArrayNonUniformIndexing;
    VkBool32               shaderSampledImageArrayNonUniformIndexing;
    VkBool32               shaderStorageBufferArrayNonUniformIndexing;
    VkBool32               shaderStorageImageArrayNonUniformIndexing;
    VkBool32               shaderInputAttachmentArrayNonUniformIndexing;
    VkBool32               shaderUniformTexelBufferArrayNonUniformIndexing;
    VkBool32               shaderStorageTexelBufferArrayNonUniformIndexing;
    VkBool32               descriptorBindingUniformBufferUpdateAfterBind;
    VkBool32               descriptorBindingSampledImageUpdateAfterBind;
    VkBool32               descriptorBindingStorageImageUpdateAfterBind;
    VkBool32               descriptorBindingStorageBufferUpdateAfterBind;
    VkBool32               descriptorBindingUniformTexelBufferUpdateAfterBind;
    VkBool32               descriptorBindingStorageTexelBufferUpdateAfterBind;
    VkBool32               descriptorBindingUpdateUnusedWhilePending;
    VkBool32               descriptorBindingPartiallyBound;
    VkBool32               descriptorBindingVariableDescriptorCount;
    VkBool32               runtimeDescriptorArray;
} VkPhysicalDeviceDescriptorIndexingFeatures;

typedef struct VkPhysicalDeviceDescriptorIndexingProperties {
    VkStructureType sType;
    void*                            pNext;
    uint32_t               maxUpdateAfterBindDescriptorsInAllPools;
    VkBool32               shaderUniformBufferArrayNonUniformIndexingNative;
    VkBool32               shaderSampledImageArrayNonUniformIndexingNative;
    VkBool32               shaderStorageBufferArrayNonUniformIndexingNative;
    VkBool32               shaderStorageImageArrayNonUniformIndexingNative;
    VkBool32               shaderInputAttachmentArrayNonUniformIndexingNative;
    VkBool32               robustBufferAccessUpdateAfterBind;
    VkBool32               quadDivergentImplicitLod;
    uint32_t               maxPerStageDescriptorUpdateAfterBindSamplers;
    uint32_t               maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    uint32_t               maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    uint32_t               maxPerStageDescriptorUpdateAfterBindSampledImages;
    uint32_t               maxPerStageDescriptorUpdateAfterBindStorageImages;
    uint32_t               maxPerStageDescriptorUpdateAfterBindInputAttachments;
    uint32_t               maxPerStageUpdateAfterBindResources;
    uint32_t               maxDescriptorSetUpdateAfterBindSamplers;
    uint32_t               maxDescriptorSetUpdateAfterBindUniformBuffers;
    uint32_t               maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    uint32_t               maxDescriptorSetUpdateAfterBindStorageBuffers;
    uint32_t               maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    uint32_t               maxDescriptorSetUpdateAfterBindSampledImages;
    uint32_t               maxDescriptorSetUpdateAfterBindStorageImages;
    uint32_t               maxDescriptorSetUpdateAfterBindInputAttachments;
} VkPhysicalDeviceDescriptorIndexingProperties;

typedef struct VkDescriptorSetLayoutBindingFlagsCreateInfo {
    VkStructureType sType;
    const void*                                                        pNext;
    uint32_t                                           bindingCount;
    const VkDescriptorBindingFlags* pBindingFlags;
} VkDescriptorSetLayoutBindingFlagsCreateInfo;

typedef struct VkDescriptorSetVariableDescriptorCountAllocateInfo {
    VkStructureType sType;
    const void*                            pNext;
    uint32_t               descriptorSetCount;
    const uint32_t* pDescriptorCounts;
} VkDescriptorSetVariableDescriptorCountAllocateInfo;

typedef struct VkDescriptorSetVariableDescriptorCountLayoutSupport {
    VkStructureType sType;
    void*            pNext;
    uint32_t         maxVariableDescriptorCount;
} VkDescriptorSetVariableDescriptorCountLayoutSupport;

typedef struct VkAttachmentDescription2 {
    VkStructureType sType;
    const void*            pNext;
    VkAttachmentDescriptionFlags flags;
    VkFormat                                     format;
    VkSampleCountFlagBits                        samples;
    VkAttachmentLoadOp                           loadOp;
    VkAttachmentStoreOp                          storeOp;
    VkAttachmentLoadOp                           stencilLoadOp;
    VkAttachmentStoreOp                          stencilStoreOp;
    VkImageLayout                                initialLayout;
    VkImageLayout                                finalLayout;
} VkAttachmentDescription2;

typedef struct VkAttachmentReference2 {
    VkStructureType sType;
    const void* pNext;
    uint32_t                          attachment;
    VkImageLayout                     layout;
    VkImageAspectFlags aspectMask;
} VkAttachmentReference2;

typedef struct VkSubpassDescription2 {
    VkStructureType sType;
    const void*                           pNext;
    VkSubpassDescriptionFlags                   flags;
    VkPipelineBindPoint                                         pipelineBindPoint;
    uint32_t                                                    viewMask;
    uint32_t                                    inputAttachmentCount;
    const VkAttachmentReference2*    pInputAttachments;
    uint32_t                                    colorAttachmentCount;
    const VkAttachmentReference2*    pColorAttachments;
    const VkAttachmentReference2* pResolveAttachments;
    const VkAttachmentReference2*               pDepthStencilAttachment;
    uint32_t                                    preserveAttachmentCount;
    const uint32_t*               pPreserveAttachments;
} VkSubpassDescription2;

typedef struct VkSubpassDependency2 {
    VkStructureType sType;
    const void* pNext;
    uint32_t                          srcSubpass;
    uint32_t                          dstSubpass;
    VkPipelineStageFlags              srcStageMask;
    VkPipelineStageFlags              dstStageMask;
    VkAccessFlags     srcAccessMask;
    VkAccessFlags     dstAccessMask;
    VkDependencyFlags dependencyFlags;
    int32_t           viewOffset;
} VkSubpassDependency2;

typedef struct VkRenderPassCreateInfo2 {
    VkStructureType sType;
    const void*                                              pNext;
    VkRenderPassCreateFlags                  flags;
    uint32_t                                 attachmentCount;
    const VkAttachmentDescription2*    pAttachments;
    uint32_t                                                 subpassCount;
    const VkSubpassDescription2*          pSubpasses;
    uint32_t                                 dependencyCount;
    const VkSubpassDependency2*        pDependencies;
    uint32_t                                 correlatedViewMaskCount;
    const uint32_t*            pCorrelatedViewMasks;
} VkRenderPassCreateInfo2;

typedef struct VkSubpassBeginInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSubpassContents      contents;
} VkSubpassBeginInfo;

typedef struct VkSubpassEndInfo {
    VkStructureType sType;
    const void*            pNext;
} VkSubpassEndInfo;

typedef struct VkPhysicalDeviceTimelineSemaphoreFeatures {
    VkStructureType sType;
    void*                  pNext;
    VkBool32               timelineSemaphore;
} VkPhysicalDeviceTimelineSemaphoreFeatures;

typedef struct VkPhysicalDeviceTimelineSemaphoreProperties {
    VkStructureType sType;
    void*                  pNext;
    uint64_t               maxTimelineSemaphoreValueDifference;
} VkPhysicalDeviceTimelineSemaphoreProperties;

typedef struct VkSemaphoreTypeCreateInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSemaphoreType        semaphoreType;
    uint64_t               initialValue;
} VkSemaphoreTypeCreateInfo;

typedef struct VkTimelineSemaphoreSubmitInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint32_t         waitSemaphoreValueCount;
    const uint64_t* pWaitSemaphoreValues;
    uint32_t         signalSemaphoreValueCount;
    const uint64_t* pSignalSemaphoreValues;
} VkTimelineSemaphoreSubmitInfo;

typedef struct VkSemaphoreWaitInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSemaphoreWaitFlags flags;
    uint32_t               semaphoreCount;
    const VkSemaphore* pSemaphores;
    const uint64_t*    pValues;
} VkSemaphoreWaitInfo;

typedef struct VkSemaphoreSignalInfo {
    VkStructureType sType;
    const void*            pNext;
    VkSemaphore            semaphore;
    uint64_t               value;
} VkSemaphoreSignalInfo;

typedef struct VkPhysicalDevice8BitStorageFeatures {
    VkStructureType sType;
    void*      pNext;
    VkBool32                         storageBuffer8BitAccess;
    VkBool32                         uniformAndStorageBuffer8BitAccess;
    VkBool32                         storagePushConstant8;
} VkPhysicalDevice8BitStorageFeatures;

typedef struct VkPhysicalDeviceVulkanMemoryModelFeatures {
    VkStructureType sType;
    void*      pNext;
    VkBool32                         vulkanMemoryModel;
    VkBool32                         vulkanMemoryModelDeviceScope;
    VkBool32                         vulkanMemoryModelAvailabilityVisibilityChains;
} VkPhysicalDeviceVulkanMemoryModelFeatures;

typedef struct VkPhysicalDeviceShaderAtomicInt64Features {
    VkStructureType sType;
    void*                               pNext;
    VkBool32                            shaderBufferInt64Atomics;
    VkBool32                            shaderSharedInt64Atomics;
} VkPhysicalDeviceShaderAtomicInt64Features;

typedef struct VkPhysicalDeviceDepthStencilResolveProperties {
    VkStructureType sType;
    void*                                pNext;
    VkResolveModeFlags                   supportedDepthResolveModes;
    VkResolveModeFlags                   supportedStencilResolveModes;
    VkBool32                             independentResolveNone;
    VkBool32                             independentResolve;
} VkPhysicalDeviceDepthStencilResolveProperties;

typedef struct VkSubpassDescriptionDepthStencilResolve {
    VkStructureType sType;
    const void*                                              pNext;
    VkResolveModeFlagBits                                    depthResolveMode;
    VkResolveModeFlagBits                                    stencilResolveMode;
    const VkAttachmentReference2*            pDepthStencilResolveAttachment;
} VkSubpassDescriptionDepthStencilResolve;

typedef struct VkImageStencilUsageCreateInfo {
    VkStructureType sType;
    const void* pNext;
    VkImageUsageFlags stencilUsage;
} VkImageStencilUsageCreateInfo;

typedef struct VkPhysicalDeviceScalarBlockLayoutFeatures {
    VkStructureType sType;
    void*                               pNext;
    VkBool32                            scalarBlockLayout;
} VkPhysicalDeviceScalarBlockLayoutFeatures;

typedef struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures {
    VkStructureType sType;
    void*                               pNext;
    VkBool32                            uniformBufferStandardLayout;
} VkPhysicalDeviceUniformBufferStandardLayoutFeatures;

typedef struct VkPhysicalDeviceBufferDeviceAddressFeatures {
    VkStructureType sType;
    void*        pNext;
    VkBool32                           bufferDeviceAddress;
    VkBool32                           bufferDeviceAddressCaptureReplay;
    VkBool32                           bufferDeviceAddressMultiDevice;
} VkPhysicalDeviceBufferDeviceAddressFeatures;

typedef struct VkBufferDeviceAddressInfo {
    VkStructureType sType;
    const void*                                            pNext;
    VkBuffer                                               buffer;
} VkBufferDeviceAddressInfo;

typedef struct VkBufferOpaqueCaptureAddressCreateInfo {
    VkStructureType sType;
    const void*                      pNext;
    uint64_t                         opaqueCaptureAddress;
} VkBufferOpaqueCaptureAddressCreateInfo;

typedef struct VkPhysicalDeviceImagelessFramebufferFeatures {
    VkStructureType sType;
    void*                                    pNext;
    VkBool32                                 imagelessFramebuffer;
} VkPhysicalDeviceImagelessFramebufferFeatures;

typedef struct VkFramebufferAttachmentImageInfo {
    VkStructureType sType;
    const void*                              pNext;
    VkImageCreateFlags       flags;
    VkImageUsageFlags                        usage;
    uint32_t                                 width;
    uint32_t                                 height;
    uint32_t                                 layerCount;
    uint32_t                 viewFormatCount;
    const VkFormat*    pViewFormats;
} VkFramebufferAttachmentImageInfo;

typedef struct VkFramebufferAttachmentsCreateInfo {
    VkStructureType sType;
    const void*                              pNext;
    uint32_t                 attachmentImageInfoCount;
    const VkFramebufferAttachmentImageInfo* pAttachmentImageInfos;
} VkFramebufferAttachmentsCreateInfo;

typedef struct VkRenderPassAttachmentBeginInfo {
    VkStructureType sType;
    const void*                              pNext;
    uint32_t                 attachmentCount;
    const VkImageView* pAttachments;
} VkRenderPassAttachmentBeginInfo;

typedef struct VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT {
    VkStructureType sType;
    void*                  pNext;
    VkBool32               textureCompressionASTC_HDR;
} VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT;

typedef struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT {
    VkStructureType sType;
    void*        pNext;
    VkBool32                           indexTypeUint8;
} VkPhysicalDeviceIndexTypeUint8FeaturesEXT;

typedef struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures {
    VkStructureType sType;
    void*    pNext;
    VkBool32                       separateDepthStencilLayouts;
} VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures;

typedef struct VkAttachmentReferenceStencilLayout {
    VkStructureType sType;
    void*    pNext;
    VkImageLayout                  stencilLayout;
} VkAttachmentReferenceStencilLayout;

typedef struct VkAttachmentDescriptionStencilLayout {
    VkStructureType sType;
    void*    pNext;
    VkImageLayout                  stencilInitialLayout;
    VkImageLayout                  stencilFinalLayout;
} VkAttachmentDescriptionStencilLayout;

typedef struct VkMemoryOpaqueCaptureAddressAllocateInfo {
    VkStructureType sType;
    const void*                   pNext;
    uint64_t                      opaqueCaptureAddress;
} VkMemoryOpaqueCaptureAddressAllocateInfo;

typedef struct VkDeviceMemoryOpaqueCaptureAddressInfo {
    VkStructureType sType;
    const void*                      pNext;
    VkDeviceMemory                   memory;
} VkDeviceMemoryOpaqueCaptureAddressInfo;

typedef struct VkPhysicalDeviceVulkan11Features {
    VkStructureType sType;
    void*    pNext;
    VkBool32                         storageBuffer16BitAccess;
    VkBool32                         uniformAndStorageBuffer16BitAccess;
    VkBool32                         storagePushConstant16;
    VkBool32                         storageInputOutput16;
    VkBool32                         multiview;
    VkBool32                         multiviewGeometryShader;
    VkBool32                         multiviewTessellationShader;
    VkBool32                         variablePointersStorageBuffer;
    VkBool32                         variablePointers;
    VkBool32                         protectedMemory;
    VkBool32                         samplerYcbcrConversion;
    VkBool32                         shaderDrawParameters;
} VkPhysicalDeviceVulkan11Features;

typedef struct VkPhysicalDeviceVulkan11Properties {
    VkStructureType sType;
    void*      pNext;
    uint8_t                          deviceUUID[VK_UUID_SIZE];
    uint8_t                          driverUUID[VK_UUID_SIZE];
    uint8_t                          deviceLUID[VK_LUID_SIZE];
    uint32_t                         deviceNodeMask;
    VkBool32                         deviceLUIDValid;
    uint32_t                      subgroupSize;
    VkShaderStageFlags            subgroupSupportedStages;
    VkSubgroupFeatureFlags        subgroupSupportedOperations;
    VkBool32                      subgroupQuadOperationsInAllStages;
    VkPointClippingBehavior          pointClippingBehavior;
    uint32_t                         maxMultiviewViewCount;
    uint32_t                         maxMultiviewInstanceIndex;
    VkBool32                         protectedNoFault;
    uint32_t                         maxPerSetDescriptors;
    VkDeviceSize                     maxMemoryAllocationSize;
} VkPhysicalDeviceVulkan11Properties;

typedef struct VkPhysicalDeviceVulkan12Features {
    VkStructureType sType;
    void*    pNext;
    VkBool32                         samplerMirrorClampToEdge;
    VkBool32                         drawIndirectCount;
    VkBool32                         storageBuffer8BitAccess;
    VkBool32                         uniformAndStorageBuffer8BitAccess;
    VkBool32                         storagePushConstant8;
    VkBool32                         shaderBufferInt64Atomics;
    VkBool32                         shaderSharedInt64Atomics;
    VkBool32                         shaderFloat16;
    VkBool32                         shaderInt8;
    VkBool32                         descriptorIndexing;
    VkBool32                         shaderInputAttachmentArrayDynamicIndexing;
    VkBool32                         shaderUniformTexelBufferArrayDynamicIndexing;
    VkBool32                         shaderStorageTexelBufferArrayDynamicIndexing;
    VkBool32                         shaderUniformBufferArrayNonUniformIndexing;
    VkBool32                         shaderSampledImageArrayNonUniformIndexing;
    VkBool32                         shaderStorageBufferArrayNonUniformIndexing;
    VkBool32                         shaderStorageImageArrayNonUniformIndexing;
    VkBool32                         shaderInputAttachmentArrayNonUniformIndexing;
    VkBool32                         shaderUniformTexelBufferArrayNonUniformIndexing;
    VkBool32                         shaderStorageTexelBufferArrayNonUniformIndexing;
    VkBool32                         descriptorBindingUniformBufferUpdateAfterBind;
    VkBool32                         descriptorBindingSampledImageUpdateAfterBind;
    VkBool32                         descriptorBindingStorageImageUpdateAfterBind;
    VkBool32                         descriptorBindingStorageBufferUpdateAfterBind;
    VkBool32                         descriptorBindingUniformTexelBufferUpdateAfterBind;
    VkBool32                         descriptorBindingStorageTexelBufferUpdateAfterBind;
    VkBool32                         descriptorBindingUpdateUnusedWhilePending;
    VkBool32                         descriptorBindingPartiallyBound;
    VkBool32                         descriptorBindingVariableDescriptorCount;
    VkBool32                         runtimeDescriptorArray;
    VkBool32                         samplerFilterMinmax;
    VkBool32                         scalarBlockLayout;
    VkBool32                         imagelessFramebuffer;
    VkBool32                         uniformBufferStandardLayout;
    VkBool32                         shaderSubgroupExtendedTypes;
    VkBool32                         separateDepthStencilLayouts;
    VkBool32                         hostQueryReset;
    VkBool32                         timelineSemaphore;
    VkBool32                         bufferDeviceAddress;
    VkBool32                         bufferDeviceAddressCaptureReplay;
    VkBool32                         bufferDeviceAddressMultiDevice;
    VkBool32                         vulkanMemoryModel;
    VkBool32                         vulkanMemoryModelDeviceScope;
    VkBool32                         vulkanMemoryModelAvailabilityVisibilityChains;
    VkBool32                         shaderOutputViewportIndex;
    VkBool32                         shaderOutputLayer;
    VkBool32                         subgroupBroadcastDynamicId;
} VkPhysicalDeviceVulkan12Features;

typedef struct VkPhysicalDeviceVulkan12Properties {
    VkStructureType sType;
    void*    pNext;
    VkDriverId                       driverID;
    char                             driverName[VK_MAX_DRIVER_NAME_SIZE];
    char                             driverInfo[VK_MAX_DRIVER_INFO_SIZE];
    VkConformanceVersion             conformanceVersion;
    VkShaderFloatControlsIndependence denormBehaviorIndependence;
    VkShaderFloatControlsIndependence roundingModeIndependence;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat16;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat32;
    VkBool32                         shaderSignedZeroInfNanPreserveFloat64;
    VkBool32                         shaderDenormPreserveFloat16;
    VkBool32                         shaderDenormPreserveFloat32;
    VkBool32                         shaderDenormPreserveFloat64;
    VkBool32                         shaderDenormFlushToZeroFloat16;
    VkBool32                         shaderDenormFlushToZeroFloat32;
    VkBool32                         shaderDenormFlushToZeroFloat64;
    VkBool32                         shaderRoundingModeRTEFloat16;
    VkBool32                         shaderRoundingModeRTEFloat32;
    VkBool32                         shaderRoundingModeRTEFloat64;
    VkBool32                         shaderRoundingModeRTZFloat16;
    VkBool32                         shaderRoundingModeRTZFloat32;
    VkBool32                         shaderRoundingModeRTZFloat64;
    uint32_t                         maxUpdateAfterBindDescriptorsInAllPools;
    VkBool32                         shaderUniformBufferArrayNonUniformIndexingNative;
    VkBool32                         shaderSampledImageArrayNonUniformIndexingNative;
    VkBool32                         shaderStorageBufferArrayNonUniformIndexingNative;
    VkBool32                         shaderStorageImageArrayNonUniformIndexingNative;
    VkBool32                         shaderInputAttachmentArrayNonUniformIndexingNative;
    VkBool32                         robustBufferAccessUpdateAfterBind;
    VkBool32                         quadDivergentImplicitLod;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindSamplers;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindSampledImages;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindStorageImages;
    uint32_t                         maxPerStageDescriptorUpdateAfterBindInputAttachments;
    uint32_t                         maxPerStageUpdateAfterBindResources;
    uint32_t                         maxDescriptorSetUpdateAfterBindSamplers;
    uint32_t                         maxDescriptorSetUpdateAfterBindUniformBuffers;
    uint32_t                         maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    uint32_t                         maxDescriptorSetUpdateAfterBindStorageBuffers;
    uint32_t                         maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    uint32_t                         maxDescriptorSetUpdateAfterBindSampledImages;
    uint32_t                         maxDescriptorSetUpdateAfterBindStorageImages;
    uint32_t                         maxDescriptorSetUpdateAfterBindInputAttachments;
    VkResolveModeFlags               supportedDepthResolveModes;
    VkResolveModeFlags               supportedStencilResolveModes;
    VkBool32                         independentResolveNone;
    VkBool32                         independentResolve;
    VkBool32                         filterMinmaxSingleComponentFormats;
    VkBool32                         filterMinmaxImageComponentMapping;
    uint64_t                         maxTimelineSemaphoreValueDifference;
    VkSampleCountFlags framebufferIntegerColorSampleCounts;
} VkPhysicalDeviceVulkan12Properties;

/* I'll bite the bullet and expect that vkCreateInstance(),
   vkEnumerateInstanceExtensionProperties() and vkEnumerateInstanceLayerProperties()
   functions can be loaded statically to avoid the need for a global
   flextVkInit() that needs to be called before everything else */
VKAPI_ATTR VkResult VKAPI_CALL vkCreateInstance(const VkInstanceCreateInfo*, const VkAllocationCallbacks*, VkInstance*);
VKAPI_ATTR VkResult VKAPI_CALL vkEnumerateInstanceExtensionProperties(const char*, uint32_t*, VkExtensionProperties*);
VKAPI_ATTR VkResult VKAPI_CALL vkEnumerateInstanceLayerProperties(uint32_t*, VkLayerProperties*);
VKAPI_ATTR PFN_vkVoidFunction VKAPI_CALL vkGetInstanceProcAddr(VkInstance, const char*);

/* Global function pointers. These are not present in all Vulkan versions, so
   they need to be loaded at runtime. */
extern FLEXTVK_EXPORT VkResult(VKAPI_PTR *flextvkEnumerateInstanceVersion)(uint32_t*);
#define vkEnumerateInstanceVersion flextvkEnumerateInstanceVersion

/* Global function pointer initialization */
void FLEXTVK_EXPORT flextVkInit();

/* Per-instance function pointers */
struct FlextVkInstance {

    /* VK_KHR_bind_memory2 */


    /* VK_KHR_descriptor_update_template */


    /* VK_KHR_device_group */


    /* VK_KHR_device_group_creation */

    VkResult    (VKAPI_PTR *EnumeratePhysicalDeviceGroupsKHR)(VkInstance, uint32_t*, VkPhysicalDeviceGroupProperties*);

    /* VK_KHR_external_fence_capabilities */

    void    (VKAPI_PTR *GetPhysicalDeviceExternalFencePropertiesKHR)(VkPhysicalDevice, const VkPhysicalDeviceExternalFenceInfo*, VkExternalFenceProperties*);

    /* VK_KHR_external_memory_capabilities */

    void    (VKAPI_PTR *GetPhysicalDeviceExternalBufferPropertiesKHR)(VkPhysicalDevice, const VkPhysicalDeviceExternalBufferInfo*, VkExternalBufferProperties*);

    /* VK_KHR_external_semaphore_capabilities */

    void    (VKAPI_PTR *GetPhysicalDeviceExternalSemaphorePropertiesKHR)(VkPhysicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo*, VkExternalSemaphoreProperties*);

    /* VK_KHR_get_memory_requirements2 */


    /* VK_KHR_get_physical_device_properties2 */

    void    (VKAPI_PTR *GetPhysicalDeviceFeatures2KHR)(VkPhysicalDevice, VkPhysicalDeviceFeatures2*);
    void    (VKAPI_PTR *GetPhysicalDeviceFormatProperties2KHR)(VkPhysicalDevice, VkFormat, VkFormatProperties2*);
    VkResult    (VKAPI_PTR *GetPhysicalDeviceImageFormatProperties2KHR)(VkPhysicalDevice, const VkPhysicalDeviceImageFormatInfo2*, VkImageFormatProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceMemoryProperties2KHR)(VkPhysicalDevice, VkPhysicalDeviceMemoryProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceProperties2KHR)(VkPhysicalDevice, VkPhysicalDeviceProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceQueueFamilyProperties2KHR)(VkPhysicalDevice, uint32_t*, VkQueueFamilyProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceSparseImageFormatProperties2KHR)(VkPhysicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2*, uint32_t*, VkSparseImageFormatProperties2*);

    /* VK_KHR_maintenance1 */


    /* VK_KHR_maintenance3 */


    /* VK_KHR_sampler_ycbcr_conversion */


    /* VK_VERSION_1_0 */

    VkResult    (VKAPI_PTR *CreateDevice)(VkPhysicalDevice, const VkDeviceCreateInfo*, const VkAllocationCallbacks*, VkDevice*);
    void    (VKAPI_PTR *DestroyInstance)(VkInstance, const VkAllocationCallbacks*);
    VkResult    (VKAPI_PTR *EnumerateDeviceExtensionProperties)(VkPhysicalDevice, const char*, uint32_t*, VkExtensionProperties*);
    VkResult    (VKAPI_PTR *EnumerateDeviceLayerProperties)(VkPhysicalDevice, uint32_t*, VkLayerProperties*);
    VkResult    (VKAPI_PTR *EnumeratePhysicalDevices)(VkInstance, uint32_t*, VkPhysicalDevice*);
    PFN_vkVoidFunction    (VKAPI_PTR *GetDeviceProcAddr)(VkDevice, const char*);
    void    (VKAPI_PTR *GetPhysicalDeviceFeatures)(VkPhysicalDevice, VkPhysicalDeviceFeatures*);
    void    (VKAPI_PTR *GetPhysicalDeviceFormatProperties)(VkPhysicalDevice, VkFormat, VkFormatProperties*);
    VkResult    (VKAPI_PTR *GetPhysicalDeviceImageFormatProperties)(VkPhysicalDevice, VkFormat, VkImageType, VkImageTiling, VkImageUsageFlags, VkImageCreateFlags, VkImageFormatProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceMemoryProperties)(VkPhysicalDevice, VkPhysicalDeviceMemoryProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceProperties)(VkPhysicalDevice, VkPhysicalDeviceProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceQueueFamilyProperties)(VkPhysicalDevice, uint32_t*, VkQueueFamilyProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceSparseImageFormatProperties)(VkPhysicalDevice, VkFormat, VkImageType, VkSampleCountFlagBits, VkImageUsageFlags, VkImageTiling, uint32_t*, VkSparseImageFormatProperties*);

    /* VK_VERSION_1_1 */

    VkResult    (VKAPI_PTR *EnumeratePhysicalDeviceGroups)(VkInstance, uint32_t*, VkPhysicalDeviceGroupProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceExternalBufferProperties)(VkPhysicalDevice, const VkPhysicalDeviceExternalBufferInfo*, VkExternalBufferProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceExternalFenceProperties)(VkPhysicalDevice, const VkPhysicalDeviceExternalFenceInfo*, VkExternalFenceProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceExternalSemaphoreProperties)(VkPhysicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo*, VkExternalSemaphoreProperties*);
    void    (VKAPI_PTR *GetPhysicalDeviceFeatures2)(VkPhysicalDevice, VkPhysicalDeviceFeatures2*);
    void    (VKAPI_PTR *GetPhysicalDeviceFormatProperties2)(VkPhysicalDevice, VkFormat, VkFormatProperties2*);
    VkResult    (VKAPI_PTR *GetPhysicalDeviceImageFormatProperties2)(VkPhysicalDevice, const VkPhysicalDeviceImageFormatInfo2*, VkImageFormatProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceMemoryProperties2)(VkPhysicalDevice, VkPhysicalDeviceMemoryProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceProperties2)(VkPhysicalDevice, VkPhysicalDeviceProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceQueueFamilyProperties2)(VkPhysicalDevice, uint32_t*, VkQueueFamilyProperties2*);
    void    (VKAPI_PTR *GetPhysicalDeviceSparseImageFormatProperties2)(VkPhysicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2*, uint32_t*, VkSparseImageFormatProperties2*);

    /* VK_VERSION_1_2 */

};

/* Per-instance function pointer initialization */
void FLEXTVK_EXPORT flextVkInitInstance(VkInstance instance, FlextVkInstance* data);

/* Per-device function pointers */
struct FlextVkDevice {

    /* VK_KHR_bind_memory2 */

    VkResult    (VKAPI_PTR *BindBufferMemory2KHR)(VkDevice, uint32_t, const VkBindBufferMemoryInfo*);
    VkResult    (VKAPI_PTR *BindImageMemory2KHR)(VkDevice, uint32_t, const VkBindImageMemoryInfo*);

    /* VK_KHR_descriptor_update_template */

    VkResult    (VKAPI_PTR *CreateDescriptorUpdateTemplateKHR)(VkDevice, const VkDescriptorUpdateTemplateCreateInfo*, const VkAllocationCallbacks*, VkDescriptorUpdateTemplate*);
    void    (VKAPI_PTR *DestroyDescriptorUpdateTemplateKHR)(VkDevice, VkDescriptorUpdateTemplate, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *UpdateDescriptorSetWithTemplateKHR)(VkDevice, VkDescriptorSet, VkDescriptorUpdateTemplate, const void*);

    /* VK_KHR_device_group */

    void    (VKAPI_PTR *CmdDispatchBaseKHR)(VkCommandBuffer, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdSetDeviceMaskKHR)(VkCommandBuffer, uint32_t);
    void    (VKAPI_PTR *GetDeviceGroupPeerMemoryFeaturesKHR)(VkDevice, uint32_t, uint32_t, uint32_t, VkPeerMemoryFeatureFlags*);

    /* VK_KHR_device_group_creation */


    /* VK_KHR_external_fence_capabilities */


    /* VK_KHR_external_memory_capabilities */


    /* VK_KHR_external_semaphore_capabilities */


    /* VK_KHR_get_memory_requirements2 */

    void    (VKAPI_PTR *GetBufferMemoryRequirements2KHR)(VkDevice, const VkBufferMemoryRequirementsInfo2*, VkMemoryRequirements2*);
    void    (VKAPI_PTR *GetImageMemoryRequirements2KHR)(VkDevice, const VkImageMemoryRequirementsInfo2*, VkMemoryRequirements2*);
    void    (VKAPI_PTR *GetImageSparseMemoryRequirements2KHR)(VkDevice, const VkImageSparseMemoryRequirementsInfo2*, uint32_t*, VkSparseImageMemoryRequirements2*);

    /* VK_KHR_get_physical_device_properties2 */


    /* VK_KHR_maintenance1 */

    void    (VKAPI_PTR *TrimCommandPoolKHR)(VkDevice, VkCommandPool, VkCommandPoolTrimFlags);

    /* VK_KHR_maintenance3 */

    void    (VKAPI_PTR *GetDescriptorSetLayoutSupportKHR)(VkDevice, const VkDescriptorSetLayoutCreateInfo*, VkDescriptorSetLayoutSupport*);

    /* VK_KHR_sampler_ycbcr_conversion */

    VkResult    (VKAPI_PTR *CreateSamplerYcbcrConversionKHR)(VkDevice, const VkSamplerYcbcrConversionCreateInfo*, const VkAllocationCallbacks*, VkSamplerYcbcrConversion*);
    void    (VKAPI_PTR *DestroySamplerYcbcrConversionKHR)(VkDevice, VkSamplerYcbcrConversion, const VkAllocationCallbacks*);

    /* VK_VERSION_1_0 */

    VkResult    (VKAPI_PTR *AllocateCommandBuffers)(VkDevice, const VkCommandBufferAllocateInfo*, VkCommandBuffer*);
    VkResult    (VKAPI_PTR *AllocateDescriptorSets)(VkDevice, const VkDescriptorSetAllocateInfo*, VkDescriptorSet*);
    VkResult    (VKAPI_PTR *AllocateMemory)(VkDevice, const VkMemoryAllocateInfo*, const VkAllocationCallbacks*, VkDeviceMemory*);
    VkResult    (VKAPI_PTR *BeginCommandBuffer)(VkCommandBuffer, const VkCommandBufferBeginInfo*);
    VkResult    (VKAPI_PTR *BindBufferMemory)(VkDevice, VkBuffer, VkDeviceMemory, VkDeviceSize);
    VkResult    (VKAPI_PTR *BindImageMemory)(VkDevice, VkImage, VkDeviceMemory, VkDeviceSize);
    void    (VKAPI_PTR *CmdBeginQuery)(VkCommandBuffer, VkQueryPool, uint32_t, VkQueryControlFlags);
    void    (VKAPI_PTR *CmdBeginRenderPass)(VkCommandBuffer, const VkRenderPassBeginInfo*, VkSubpassContents);
    void    (VKAPI_PTR *CmdBindDescriptorSets)(VkCommandBuffer, VkPipelineBindPoint, VkPipelineLayout, uint32_t, uint32_t, const VkDescriptorSet*, uint32_t, const uint32_t*);
    void    (VKAPI_PTR *CmdBindIndexBuffer)(VkCommandBuffer, VkBuffer, VkDeviceSize, VkIndexType);
    void    (VKAPI_PTR *CmdBindPipeline)(VkCommandBuffer, VkPipelineBindPoint, VkPipeline);
    void    (VKAPI_PTR *CmdBindVertexBuffers)(VkCommandBuffer, uint32_t, uint32_t, const VkBuffer*, const VkDeviceSize*);
    void    (VKAPI_PTR *CmdBlitImage)(VkCommandBuffer, VkImage, VkImageLayout, VkImage, VkImageLayout, uint32_t, const VkImageBlit*, VkFilter);
    void    (VKAPI_PTR *CmdClearAttachments)(VkCommandBuffer, uint32_t, const VkClearAttachment*, uint32_t, const VkClearRect*);
    void    (VKAPI_PTR *CmdClearColorImage)(VkCommandBuffer, VkImage, VkImageLayout, const VkClearColorValue*, uint32_t, const VkImageSubresourceRange*);
    void    (VKAPI_PTR *CmdClearDepthStencilImage)(VkCommandBuffer, VkImage, VkImageLayout, const VkClearDepthStencilValue*, uint32_t, const VkImageSubresourceRange*);
    void    (VKAPI_PTR *CmdCopyBuffer)(VkCommandBuffer, VkBuffer, VkBuffer, uint32_t, const VkBufferCopy*);
    void    (VKAPI_PTR *CmdCopyBufferToImage)(VkCommandBuffer, VkBuffer, VkImage, VkImageLayout, uint32_t, const VkBufferImageCopy*);
    void    (VKAPI_PTR *CmdCopyImage)(VkCommandBuffer, VkImage, VkImageLayout, VkImage, VkImageLayout, uint32_t, const VkImageCopy*);
    void    (VKAPI_PTR *CmdCopyImageToBuffer)(VkCommandBuffer, VkImage, VkImageLayout, VkBuffer, uint32_t, const VkBufferImageCopy*);
    void    (VKAPI_PTR *CmdCopyQueryPoolResults)(VkCommandBuffer, VkQueryPool, uint32_t, uint32_t, VkBuffer, VkDeviceSize, VkDeviceSize, VkQueryResultFlags);
    void    (VKAPI_PTR *CmdDispatch)(VkCommandBuffer, uint32_t, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdDispatchIndirect)(VkCommandBuffer, VkBuffer, VkDeviceSize);
    void    (VKAPI_PTR *CmdDraw)(VkCommandBuffer, uint32_t, uint32_t, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdDrawIndexed)(VkCommandBuffer, uint32_t, uint32_t, uint32_t, int32_t, uint32_t);
    void    (VKAPI_PTR *CmdDrawIndexedIndirect)(VkCommandBuffer, VkBuffer, VkDeviceSize, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdDrawIndirect)(VkCommandBuffer, VkBuffer, VkDeviceSize, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdEndQuery)(VkCommandBuffer, VkQueryPool, uint32_t);
    void    (VKAPI_PTR *CmdEndRenderPass)(VkCommandBuffer);
    void    (VKAPI_PTR *CmdExecuteCommands)(VkCommandBuffer, uint32_t, const VkCommandBuffer*);
    void    (VKAPI_PTR *CmdFillBuffer)(VkCommandBuffer, VkBuffer, VkDeviceSize, VkDeviceSize, uint32_t);
    void    (VKAPI_PTR *CmdNextSubpass)(VkCommandBuffer, VkSubpassContents);
    void    (VKAPI_PTR *CmdPipelineBarrier)(VkCommandBuffer, VkPipelineStageFlags, VkPipelineStageFlags, VkDependencyFlags, uint32_t, const VkMemoryBarrier*, uint32_t, const VkBufferMemoryBarrier*, uint32_t, const VkImageMemoryBarrier*);
    void    (VKAPI_PTR *CmdPushConstants)(VkCommandBuffer, VkPipelineLayout, VkShaderStageFlags, uint32_t, uint32_t, const void*);
    void    (VKAPI_PTR *CmdResetEvent)(VkCommandBuffer, VkEvent, VkPipelineStageFlags);
    void    (VKAPI_PTR *CmdResetQueryPool)(VkCommandBuffer, VkQueryPool, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdResolveImage)(VkCommandBuffer, VkImage, VkImageLayout, VkImage, VkImageLayout, uint32_t, const VkImageResolve*);
    void    (VKAPI_PTR *CmdSetBlendConstants)(VkCommandBuffer, const float [4]);
    void    (VKAPI_PTR *CmdSetDepthBias)(VkCommandBuffer, float, float, float);
    void    (VKAPI_PTR *CmdSetDepthBounds)(VkCommandBuffer, float, float);
    void    (VKAPI_PTR *CmdSetEvent)(VkCommandBuffer, VkEvent, VkPipelineStageFlags);
    void    (VKAPI_PTR *CmdSetLineWidth)(VkCommandBuffer, float);
    void    (VKAPI_PTR *CmdSetScissor)(VkCommandBuffer, uint32_t, uint32_t, const VkRect2D*);
    void    (VKAPI_PTR *CmdSetStencilCompareMask)(VkCommandBuffer, VkStencilFaceFlags, uint32_t);
    void    (VKAPI_PTR *CmdSetStencilReference)(VkCommandBuffer, VkStencilFaceFlags, uint32_t);
    void    (VKAPI_PTR *CmdSetStencilWriteMask)(VkCommandBuffer, VkStencilFaceFlags, uint32_t);
    void    (VKAPI_PTR *CmdSetViewport)(VkCommandBuffer, uint32_t, uint32_t, const VkViewport*);
    void    (VKAPI_PTR *CmdUpdateBuffer)(VkCommandBuffer, VkBuffer, VkDeviceSize, VkDeviceSize, const void*);
    void    (VKAPI_PTR *CmdWaitEvents)(VkCommandBuffer, uint32_t, const VkEvent*, VkPipelineStageFlags, VkPipelineStageFlags, uint32_t, const VkMemoryBarrier*, uint32_t, const VkBufferMemoryBarrier*, uint32_t, const VkImageMemoryBarrier*);
    void    (VKAPI_PTR *CmdWriteTimestamp)(VkCommandBuffer, VkPipelineStageFlagBits, VkQueryPool, uint32_t);
    VkResult    (VKAPI_PTR *CreateBuffer)(VkDevice, const VkBufferCreateInfo*, const VkAllocationCallbacks*, VkBuffer*);
    VkResult    (VKAPI_PTR *CreateBufferView)(VkDevice, const VkBufferViewCreateInfo*, const VkAllocationCallbacks*, VkBufferView*);
    VkResult    (VKAPI_PTR *CreateCommandPool)(VkDevice, const VkCommandPoolCreateInfo*, const VkAllocationCallbacks*, VkCommandPool*);
    VkResult    (VKAPI_PTR *CreateComputePipelines)(VkDevice, VkPipelineCache, uint32_t, const VkComputePipelineCreateInfo*, const VkAllocationCallbacks*, VkPipeline*);
    VkResult    (VKAPI_PTR *CreateDescriptorPool)(VkDevice, const VkDescriptorPoolCreateInfo*, const VkAllocationCallbacks*, VkDescriptorPool*);
    VkResult    (VKAPI_PTR *CreateDescriptorSetLayout)(VkDevice, const VkDescriptorSetLayoutCreateInfo*, const VkAllocationCallbacks*, VkDescriptorSetLayout*);
    VkResult    (VKAPI_PTR *CreateEvent)(VkDevice, const VkEventCreateInfo*, const VkAllocationCallbacks*, VkEvent*);
    VkResult    (VKAPI_PTR *CreateFence)(VkDevice, const VkFenceCreateInfo*, const VkAllocationCallbacks*, VkFence*);
    VkResult    (VKAPI_PTR *CreateFramebuffer)(VkDevice, const VkFramebufferCreateInfo*, const VkAllocationCallbacks*, VkFramebuffer*);
    VkResult    (VKAPI_PTR *CreateGraphicsPipelines)(VkDevice, VkPipelineCache, uint32_t, const VkGraphicsPipelineCreateInfo*, const VkAllocationCallbacks*, VkPipeline*);
    VkResult    (VKAPI_PTR *CreateImage)(VkDevice, const VkImageCreateInfo*, const VkAllocationCallbacks*, VkImage*);
    VkResult    (VKAPI_PTR *CreateImageView)(VkDevice, const VkImageViewCreateInfo*, const VkAllocationCallbacks*, VkImageView*);
    VkResult    (VKAPI_PTR *CreatePipelineCache)(VkDevice, const VkPipelineCacheCreateInfo*, const VkAllocationCallbacks*, VkPipelineCache*);
    VkResult    (VKAPI_PTR *CreatePipelineLayout)(VkDevice, const VkPipelineLayoutCreateInfo*, const VkAllocationCallbacks*, VkPipelineLayout*);
    VkResult    (VKAPI_PTR *CreateQueryPool)(VkDevice, const VkQueryPoolCreateInfo*, const VkAllocationCallbacks*, VkQueryPool*);
    VkResult    (VKAPI_PTR *CreateRenderPass)(VkDevice, const VkRenderPassCreateInfo*, const VkAllocationCallbacks*, VkRenderPass*);
    VkResult    (VKAPI_PTR *CreateSampler)(VkDevice, const VkSamplerCreateInfo*, const VkAllocationCallbacks*, VkSampler*);
    VkResult    (VKAPI_PTR *CreateSemaphore)(VkDevice, const VkSemaphoreCreateInfo*, const VkAllocationCallbacks*, VkSemaphore*);
    VkResult    (VKAPI_PTR *CreateShaderModule)(VkDevice, const VkShaderModuleCreateInfo*, const VkAllocationCallbacks*, VkShaderModule*);
    void    (VKAPI_PTR *DestroyBuffer)(VkDevice, VkBuffer, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyBufferView)(VkDevice, VkBufferView, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyCommandPool)(VkDevice, VkCommandPool, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyDescriptorPool)(VkDevice, VkDescriptorPool, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyDescriptorSetLayout)(VkDevice, VkDescriptorSetLayout, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyDevice)(VkDevice, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyEvent)(VkDevice, VkEvent, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyFence)(VkDevice, VkFence, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyFramebuffer)(VkDevice, VkFramebuffer, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyImage)(VkDevice, VkImage, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyImageView)(VkDevice, VkImageView, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyPipeline)(VkDevice, VkPipeline, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyPipelineCache)(VkDevice, VkPipelineCache, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyPipelineLayout)(VkDevice, VkPipelineLayout, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyQueryPool)(VkDevice, VkQueryPool, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyRenderPass)(VkDevice, VkRenderPass, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroySampler)(VkDevice, VkSampler, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroySemaphore)(VkDevice, VkSemaphore, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroyShaderModule)(VkDevice, VkShaderModule, const VkAllocationCallbacks*);
    VkResult    (VKAPI_PTR *DeviceWaitIdle)(VkDevice);
    VkResult    (VKAPI_PTR *EndCommandBuffer)(VkCommandBuffer);
    VkResult    (VKAPI_PTR *FlushMappedMemoryRanges)(VkDevice, uint32_t, const VkMappedMemoryRange*);
    void    (VKAPI_PTR *FreeCommandBuffers)(VkDevice, VkCommandPool, uint32_t, const VkCommandBuffer*);
    VkResult    (VKAPI_PTR *FreeDescriptorSets)(VkDevice, VkDescriptorPool, uint32_t, const VkDescriptorSet*);
    void    (VKAPI_PTR *FreeMemory)(VkDevice, VkDeviceMemory, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *GetBufferMemoryRequirements)(VkDevice, VkBuffer, VkMemoryRequirements*);
    void    (VKAPI_PTR *GetDeviceMemoryCommitment)(VkDevice, VkDeviceMemory, VkDeviceSize*);
    void    (VKAPI_PTR *GetDeviceQueue)(VkDevice, uint32_t, uint32_t, VkQueue*);
    VkResult    (VKAPI_PTR *GetEventStatus)(VkDevice, VkEvent);
    VkResult    (VKAPI_PTR *GetFenceStatus)(VkDevice, VkFence);
    void    (VKAPI_PTR *GetImageMemoryRequirements)(VkDevice, VkImage, VkMemoryRequirements*);
    void    (VKAPI_PTR *GetImageSparseMemoryRequirements)(VkDevice, VkImage, uint32_t*, VkSparseImageMemoryRequirements*);
    void    (VKAPI_PTR *GetImageSubresourceLayout)(VkDevice, VkImage, const VkImageSubresource*, VkSubresourceLayout*);
    VkResult    (VKAPI_PTR *GetPipelineCacheData)(VkDevice, VkPipelineCache, size_t*, void*);
    VkResult    (VKAPI_PTR *GetQueryPoolResults)(VkDevice, VkQueryPool, uint32_t, uint32_t, size_t, void*, VkDeviceSize, VkQueryResultFlags);
    void    (VKAPI_PTR *GetRenderAreaGranularity)(VkDevice, VkRenderPass, VkExtent2D*);
    VkResult    (VKAPI_PTR *InvalidateMappedMemoryRanges)(VkDevice, uint32_t, const VkMappedMemoryRange*);
    VkResult    (VKAPI_PTR *MapMemory)(VkDevice, VkDeviceMemory, VkDeviceSize, VkDeviceSize, VkMemoryMapFlags, void**);
    VkResult    (VKAPI_PTR *MergePipelineCaches)(VkDevice, VkPipelineCache, uint32_t, const VkPipelineCache*);
    VkResult    (VKAPI_PTR *QueueBindSparse)(VkQueue, uint32_t, const VkBindSparseInfo*, VkFence);
    VkResult    (VKAPI_PTR *QueueSubmit)(VkQueue, uint32_t, const VkSubmitInfo*, VkFence);
    VkResult    (VKAPI_PTR *QueueWaitIdle)(VkQueue);
    VkResult    (VKAPI_PTR *ResetCommandBuffer)(VkCommandBuffer, VkCommandBufferResetFlags);
    VkResult    (VKAPI_PTR *ResetCommandPool)(VkDevice, VkCommandPool, VkCommandPoolResetFlags);
    VkResult    (VKAPI_PTR *ResetDescriptorPool)(VkDevice, VkDescriptorPool, VkDescriptorPoolResetFlags);
    VkResult    (VKAPI_PTR *ResetEvent)(VkDevice, VkEvent);
    VkResult    (VKAPI_PTR *ResetFences)(VkDevice, uint32_t, const VkFence*);
    VkResult    (VKAPI_PTR *SetEvent)(VkDevice, VkEvent);
    void    (VKAPI_PTR *UnmapMemory)(VkDevice, VkDeviceMemory);
    void    (VKAPI_PTR *UpdateDescriptorSets)(VkDevice, uint32_t, const VkWriteDescriptorSet*, uint32_t, const VkCopyDescriptorSet*);
    VkResult    (VKAPI_PTR *WaitForFences)(VkDevice, uint32_t, const VkFence*, VkBool32, uint64_t);

    /* VK_VERSION_1_1 */

    VkResult    (VKAPI_PTR *BindBufferMemory2)(VkDevice, uint32_t, const VkBindBufferMemoryInfo*);
    VkResult    (VKAPI_PTR *BindImageMemory2)(VkDevice, uint32_t, const VkBindImageMemoryInfo*);
    void    (VKAPI_PTR *CmdDispatchBase)(VkCommandBuffer, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdSetDeviceMask)(VkCommandBuffer, uint32_t);
    VkResult    (VKAPI_PTR *CreateDescriptorUpdateTemplate)(VkDevice, const VkDescriptorUpdateTemplateCreateInfo*, const VkAllocationCallbacks*, VkDescriptorUpdateTemplate*);
    VkResult    (VKAPI_PTR *CreateSamplerYcbcrConversion)(VkDevice, const VkSamplerYcbcrConversionCreateInfo*, const VkAllocationCallbacks*, VkSamplerYcbcrConversion*);
    void    (VKAPI_PTR *DestroyDescriptorUpdateTemplate)(VkDevice, VkDescriptorUpdateTemplate, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *DestroySamplerYcbcrConversion)(VkDevice, VkSamplerYcbcrConversion, const VkAllocationCallbacks*);
    void    (VKAPI_PTR *GetBufferMemoryRequirements2)(VkDevice, const VkBufferMemoryRequirementsInfo2*, VkMemoryRequirements2*);
    void    (VKAPI_PTR *GetDescriptorSetLayoutSupport)(VkDevice, const VkDescriptorSetLayoutCreateInfo*, VkDescriptorSetLayoutSupport*);
    void    (VKAPI_PTR *GetDeviceGroupPeerMemoryFeatures)(VkDevice, uint32_t, uint32_t, uint32_t, VkPeerMemoryFeatureFlags*);
    void    (VKAPI_PTR *GetDeviceQueue2)(VkDevice, const VkDeviceQueueInfo2*, VkQueue*);
    void    (VKAPI_PTR *GetImageMemoryRequirements2)(VkDevice, const VkImageMemoryRequirementsInfo2*, VkMemoryRequirements2*);
    void    (VKAPI_PTR *GetImageSparseMemoryRequirements2)(VkDevice, const VkImageSparseMemoryRequirementsInfo2*, uint32_t*, VkSparseImageMemoryRequirements2*);
    void    (VKAPI_PTR *TrimCommandPool)(VkDevice, VkCommandPool, VkCommandPoolTrimFlags);
    void    (VKAPI_PTR *UpdateDescriptorSetWithTemplate)(VkDevice, VkDescriptorSet, VkDescriptorUpdateTemplate, const void*);

    /* VK_VERSION_1_2 */

    void    (VKAPI_PTR *CmdBeginRenderPass2)(VkCommandBuffer, const VkRenderPassBeginInfo*, const VkSubpassBeginInfo*);
    void    (VKAPI_PTR *CmdDrawIndexedIndirectCount)(VkCommandBuffer, VkBuffer, VkDeviceSize, VkBuffer, VkDeviceSize, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdDrawIndirectCount)(VkCommandBuffer, VkBuffer, VkDeviceSize, VkBuffer, VkDeviceSize, uint32_t, uint32_t);
    void    (VKAPI_PTR *CmdEndRenderPass2)(VkCommandBuffer, const VkSubpassEndInfo*);
    void    (VKAPI_PTR *CmdNextSubpass2)(VkCommandBuffer, const VkSubpassBeginInfo*, const VkSubpassEndInfo*);
    VkResult    (VKAPI_PTR *CreateRenderPass2)(VkDevice, const VkRenderPassCreateInfo2*, const VkAllocationCallbacks*, VkRenderPass*);
    VkDeviceAddress    (VKAPI_PTR *GetBufferDeviceAddress)(VkDevice, const VkBufferDeviceAddressInfo*);
    uint64_t    (VKAPI_PTR *GetBufferOpaqueCaptureAddress)(VkDevice, const VkBufferDeviceAddressInfo*);
    uint64_t    (VKAPI_PTR *GetDeviceMemoryOpaqueCaptureAddress)(VkDevice, const VkDeviceMemoryOpaqueCaptureAddressInfo*);
    VkResult    (VKAPI_PTR *GetSemaphoreCounterValue)(VkDevice, VkSemaphore, uint64_t*);
    void    (VKAPI_PTR *ResetQueryPool)(VkDevice, VkQueryPool, uint32_t, uint32_t);
    VkResult    (VKAPI_PTR *SignalSemaphore)(VkDevice, const VkSemaphoreSignalInfo*);
    VkResult    (VKAPI_PTR *WaitSemaphores)(VkDevice, const VkSemaphoreWaitInfo*, uint64_t);
};

/* Per-device function pointer initialization */
void FLEXTVK_EXPORT flextVkInitDevice(VkDevice device, FlextVkDevice* data, PFN_vkVoidFunction(VKAPI_PTR *getDeviceProcAddr)(VkDevice, const char*));

#endif

#ifdef __cplusplus
}
#endif

#endif

