/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@PhaseDescription(name="StaticDefaultFunction", prerequisite={})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitSimpleFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getStaticFunctionWithReceivers", "function", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nStaticDefaultFunctionLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StaticDefaultFunctionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,93:1\n401#2,3:94\n*S KotlinDebug\n*F\n+ 1 StaticDefaultFunctionLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/StaticDefaultFunctionLowering\n*L\n84#1:94,3\n*E\n"})
public final class StaticDefaultFunctionLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public StaticDefaultFunctionLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.accept(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER()) && declaration.getDispatchReceiverParameter() != null) {
            void it;
            IrSimpleFunction irSimpleFunction2;
            IrSimpleFunction irSimpleFunction3 = irSimpleFunction2 = this.getStaticFunctionWithReceivers(declaration);
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            it.setBody(IrInlineUtilsKt.moveBodyTo(declaration, (IrFunction)it));
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irSimpleFunction = irSimpleFunction2;
        } else {
            irSimpleFunction = declaration;
        }
        return super.visitFunction(irSimpleFunction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrReturnTarget irReturnTarget = expression2.getReturnTargetSymbol().getOwner();
        IrSimpleFunction irSimpleFunction = irReturnTarget instanceof IrSimpleFunction ? (IrSimpleFunction)irReturnTarget : null;
        IrSimpleFunction irFunction = irSimpleFunction != null ? JvmIrAttributesKt.getStaticDefaultStub(irSimpleFunction) : null;
        StaticDefaultFunctionLowering staticDefaultFunctionLowering = this;
        if (irFunction != null) {
            void $this$visitReturn_u24lambda_u240;
            IrReturn irReturn2 = expression2;
            StaticDefaultFunctionLowering staticDefaultFunctionLowering2 = staticDefaultFunctionLowering;
            boolean bl = false;
            staticDefaultFunctionLowering = staticDefaultFunctionLowering2;
            irReturn = new IrReturnImpl($this$visitReturn_u24lambda_u240.getStartOffset(), $this$visitReturn_u24lambda_u240.getEndOffset(), $this$visitReturn_u24lambda_u240.getType(), irFunction.getSymbol(), $this$visitReturn_u24lambda_u240.getValue());
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (callee.getOrigin() != IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER() || expression2.getDispatchReceiver() == null) {
            return super.visitCall(expression2);
        }
        IrSimpleFunction newCallee = this.getStaticFunctionWithReceivers(callee);
        IrCall newCall = IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, newCallee, null, null, 12, null);
        return super.visitCall(newCall);
    }

    private final IrSimpleFunction getStaticFunctionWithReceivers(IrSimpleFunction function2) {
        KMutableProperty0 $this$getOrSetIfNull$iv = new MutablePropertyReference0Impl(function2){

            public Object get() {
                return JvmIrAttributesKt.getStaticDefaultStub((IrSimpleFunction)this.receiver);
            }

            public void set(Object value2) {
                JvmIrAttributesKt.setStaticDefaultStub((IrSimpleFunction)this.receiver, (IrSimpleFunction)value2);
            }
        };
        boolean $i$f$getOrSetIfNull = false;
        Object object = $this$getOrSetIfNull$iv.get();
        if (object == null) {
            IrSimpleFunction irSimpleFunction;
            boolean bl = false;
            IrSimpleFunction it$iv = irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default(this.context.getIrFactory(), function2.getParent(), function2.getName(), function2, null, null, null, null, false, false, null, new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.context){

                public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    Intrinsics.checkNotNullParameter(p1, "p1");
                    ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
                }
            }, 1016, null);
            boolean bl2 = false;
            $this$getOrSetIfNull$iv.set(it$iv);
            object = irSimpleFunction;
        }
        return (IrSimpleFunction)object;
    }
}

