/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.impl.URIDecoder;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.AuthorizationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.InputTrustHandler;
import io.vertx.ext.web.handler.MultiTenantHandler;
import io.vertx.ext.web.handler.PlatformHandler;
import io.vertx.ext.web.handler.ProtocolUpgradeHandler;
import io.vertx.ext.web.handler.SecurityPolicyHandler;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import io.vertx.ext.web.impl.RoutingContextImplBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RouteState {
    private static final Logger LOG = LoggerFactory.getLogger(RouteState.class);
    private final RouteImpl route;
    private final Map<String, Object> metadata;
    private final String path;
    private final String name;
    private final int order;
    private final boolean enabled;
    private final Set<HttpMethod> methods;
    private final Set<MIMEHeader> consumes;
    private final boolean emptyBodyPermittedWithConsumes;
    private final Set<MIMEHeader> produces;
    private final List<Handler<RoutingContext>> contextHandlers;
    private final List<Handler<RoutingContext>> failureHandlers;
    private final boolean added;
    private final Pattern pattern;
    private final List<String> groups;
    private final boolean useNormalizedPath;
    private final Set<String> namedGroupsInRegex;
    private final Pattern virtualHostPattern;
    private final boolean pathEndsWithSlash;
    private final boolean exclusive;
    private final boolean exactPath;

    private static Priority weight(Handler<RoutingContext> handler) {
        if (handler instanceof PlatformHandler) {
            return Priority.PLATFORM;
        }
        if (handler instanceof SecurityPolicyHandler) {
            return Priority.SECURITY_POLICY;
        }
        if (handler instanceof BodyHandler) {
            return Priority.BODY;
        }
        if (handler instanceof MultiTenantHandler) {
            return Priority.MULTI_TENANT;
        }
        if (handler instanceof AuthenticationHandler) {
            return Priority.AUTHENTICATION;
        }
        if (handler instanceof InputTrustHandler) {
            return Priority.INPUT_TRUST;
        }
        if (handler instanceof AuthorizationHandler) {
            return Priority.AUTHORIZATION;
        }
        return Priority.USER;
    }

    private RouteState(RouteImpl route, Map<String, Object> metadata, String path, String name, int order, boolean enabled, Set<HttpMethod> methods, Set<MIMEHeader> consumes, boolean emptyBodyPermittedWithConsumes, Set<MIMEHeader> produces, List<Handler<RoutingContext>> contextHandlers, List<Handler<RoutingContext>> failureHandlers, boolean added, Pattern pattern, List<String> groups, boolean useNormalizedPath, Set<String> namedGroupsInRegex, Pattern virtualHostPattern, boolean pathEndsWithSlash, boolean exclusive, boolean exactPath) {
        this.route = route;
        this.metadata = metadata;
        this.path = path;
        this.name = name;
        this.order = order;
        this.enabled = enabled;
        this.methods = methods;
        this.consumes = consumes;
        this.emptyBodyPermittedWithConsumes = emptyBodyPermittedWithConsumes;
        this.produces = produces;
        this.contextHandlers = contextHandlers;
        this.failureHandlers = failureHandlers;
        this.added = added;
        this.pattern = pattern;
        this.groups = groups;
        this.useNormalizedPath = useNormalizedPath;
        this.namedGroupsInRegex = namedGroupsInRegex;
        this.virtualHostPattern = virtualHostPattern;
        this.pathEndsWithSlash = pathEndsWithSlash;
        this.exclusive = exclusive;
        this.exactPath = exactPath;
    }

    RouteState(RouteImpl route, int order) {
        this(route, null, null, null, order, true, null, null, false, null, null, null, false, null, null, true, null, null, false, false, true);
    }

    public RouteImpl getRoute() {
        return this.route;
    }

    public RouterImpl getRouter() {
        return this.route.router();
    }

    public RouteState putMetadata(String key, Object value) {
        HashMap<String, Object> metadata;
        HashMap<String, Object> hashMap = metadata = this.metadata == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.metadata);
        if (value == null) {
            metadata.remove(key);
        } else {
            metadata.put(key, value);
        }
        return new RouteState(this.route, Collections.unmodifiableMap(metadata), this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String getPath() {
        return this.path;
    }

    RouteState setPath(String path) {
        return new RouteState(this.route, this.metadata, path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public int getOrder() {
        return this.order;
    }

    RouteState setOrder(int order) {
        return new RouteState(this.route, this.metadata, this.path, this.name, order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    RouteState setEnabled(boolean enabled) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public Set<HttpMethod> getMethods() {
        return this.methods;
    }

    RouteState setMethods(Set<HttpMethod> methods) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public RouteState addMethod(HttpMethod method) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods == null ? new HashSet<HttpMethod>() : new HashSet<HttpMethod>(this.methods), this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.methods.add(method);
        return newState;
    }

    public Set<MIMEHeader> getConsumes() {
        return this.consumes;
    }

    RouteState setConsumes(Set<MIMEHeader> consumes) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addConsume(MIMEHeader mime) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes == null ? new LinkedHashSet<MIMEHeader>() : new LinkedHashSet<MIMEHeader>(this.consumes), this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.consumes.add(mime);
        return newState;
    }

    public boolean isEmptyBodyPermittedWithConsumes() {
        return this.emptyBodyPermittedWithConsumes;
    }

    RouteState setEmptyBodyPermittedWithConsumes(boolean emptyBodyPermittedWithConsumes) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public Set<MIMEHeader> getProduces() {
        return this.produces;
    }

    RouteState setProduces(Set<MIMEHeader> produces) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addProduce(MIMEHeader mime) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces == null ? new LinkedHashSet<MIMEHeader>() : new LinkedHashSet<MIMEHeader>(this.produces), this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.produces.add(mime);
        return newState;
    }

    public List<Handler<RoutingContext>> getContextHandlers() {
        return this.contextHandlers;
    }

    public int getContextHandlersLength() {
        return this.contextHandlers == null ? 0 : this.contextHandlers.size();
    }

    RouteState setContextHandlers(List<Handler<RoutingContext>> contextHandlers) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addContextHandler(Handler<RoutingContext> contextHandler) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers == null ? new ArrayList<Handler<RoutingContext>>() : new ArrayList<Handler<RoutingContext>>(this.contextHandlers), this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        int len = newState.contextHandlers.size();
        Priority weight = RouteState.weight(contextHandler);
        if (len > 0) {
            Handler<RoutingContext> lastHandler = newState.contextHandlers.get(len - 1);
            Priority lastWeight = RouteState.weight(lastHandler);
            if (lastWeight.ordinal() > weight.ordinal()) {
                RouteState.failOrWarn("Cannot add [" + weight.name() + "] handler to route with [" + lastWeight.name() + "] handler at index " + (len - 1));
            }
            if (contextHandler instanceof ProtocolUpgradeHandler && newState.hasBodyHandler()) {
                RouteState.failOrWarn("Cannot add [PROTOCOL_UPGRADE] handler to route with [BODY] handler");
            }
        }
        newState.contextHandlers.add(contextHandler);
        return newState;
    }

    private static void failOrWarn(String message) {
        if (!Boolean.getBoolean("io.vertx.web.router.setup.lenient")) {
            throw new IllegalStateException(message);
        }
        LOG.warn((Object)message);
    }

    private boolean hasBodyHandler() {
        for (Handler<RoutingContext> contextHandler : this.contextHandlers) {
            if (!(contextHandler instanceof BodyHandler)) continue;
            return true;
        }
        return false;
    }

    public List<Handler<RoutingContext>> getFailureHandlers() {
        return this.failureHandlers;
    }

    public int getFailureHandlersLength() {
        return this.failureHandlers == null ? 0 : this.failureHandlers.size();
    }

    RouteState setFailureHandlers(List<Handler<RoutingContext>> failureHandlers) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addFailureHandler(Handler<RoutingContext> failureHandler) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers == null ? new ArrayList<Handler<RoutingContext>>() : new ArrayList<Handler<RoutingContext>>(this.failureHandlers), this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.failureHandlers.add(failureHandler);
        return newState;
    }

    public boolean isAdded() {
        return this.added;
    }

    RouteState setAdded(boolean added) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    RouteState setPattern(Pattern pattern) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public List<String> getGroups() {
        return this.groups;
    }

    RouteState setGroups(List<String> groups) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addGroup(String group) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups == null ? new ArrayList<String>() : new ArrayList<String>(this.groups), this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.groups.add(group);
        return newState;
    }

    public boolean isUseNormalizedPath() {
        return this.useNormalizedPath;
    }

    RouteState setUseNormalizedPath(boolean useNormalizedPath) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public Set<String> getNamedGroupsInRegex() {
        return this.namedGroupsInRegex;
    }

    RouteState setNamedGroupsInRegex(Set<String> namedGroupsInRegex) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    RouteState addNamedGroupInRegex(String namedGroupInRegex) {
        RouteState newState = new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex == null ? new HashSet<String>() : new HashSet<String>(this.namedGroupsInRegex), this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
        newState.namedGroupsInRegex.add(namedGroupInRegex);
        return newState;
    }

    public Pattern getVirtualHostPattern() {
        return this.virtualHostPattern;
    }

    RouteState setVirtualHostPattern(Pattern virtualHostPattern) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public boolean isPathEndsWithSlash() {
        return this.pathEndsWithSlash;
    }

    RouteState setPathEndsWithSlash(boolean pathEndsWithSlash) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    RouteState setExclusive(boolean exclusive) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, exclusive, this.exactPath);
    }

    public boolean isExactPath() {
        return this.exactPath;
    }

    RouteState setExactPath(boolean exactPath) {
        return new RouteState(this.route, this.metadata, this.path, this.name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, exactPath);
    }

    RouteState setName(String name) {
        return new RouteState(this.route, this.metadata, this.path, name, this.order, this.enabled, this.methods, this.consumes, this.emptyBodyPermittedWithConsumes, this.produces, this.contextHandlers, this.failureHandlers, this.added, this.pattern, this.groups, this.useNormalizedPath, this.namedGroupsInRegex, this.virtualHostPattern, this.pathEndsWithSlash, this.exclusive, this.exactPath);
    }

    private boolean containsMethod(HttpServerRequest request) {
        if (!RouteState.isEmpty(this.methods)) {
            return this.methods.contains(request.method());
        }
        return false;
    }

    private static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int matches(RoutingContextImplBase context, String mountPoint, boolean failure) {
        List<MIMEHeader> acceptableTypes;
        MIMEHeader contentType;
        MIMEHeader consumal;
        if (failure && !this.hasNextFailureHandler(context) || !failure && !this.hasNextContextHandler(context)) {
            return 404;
        }
        if (!this.enabled) {
            return 404;
        }
        HttpServerRequest request = context.request();
        if (this.path != null && this.pattern == null && !this.pathMatches(mountPoint, context)) {
            return 404;
        }
        if (this.pattern != null) {
            Matcher m;
            String path;
            context.pathParams().remove("*");
            String string = path = this.useNormalizedPath ? context.normalizedPath() : context.request().path();
            if (mountPoint != null) {
                int strip = mountPoint.length();
                if (mountPoint.charAt(strip - 1) == '/') {
                    --strip;
                }
                if (path != null) {
                    path = path.substring(strip);
                }
            }
            if (path == null || !(m = this.pattern.matcher(path)).matches()) return 404;
            if (!RouteState.isEmpty(this.methods) && !this.containsMethod(request)) {
                return 405;
            }
            context.matchRest = -1;
            context.normalizedMatch = this.useNormalizedPath;
            if (m.groupCount() > 0) {
                if (!this.exactPath) {
                    context.matchRest = m.start("rest");
                    context.pathParams().put("*", path.substring(context.matchRest));
                }
                if (!RouteState.isEmpty(this.groups)) {
                    int len = Math.min(this.groups.size(), m.groupCount());
                    for (int i = 0; i < len; ++i) {
                        String undecodedValue;
                        String k = this.groups.get(i);
                        try {
                            undecodedValue = m.group("p" + i);
                        }
                        catch (IllegalArgumentException e) {
                            try {
                                undecodedValue = m.group(k);
                            }
                            catch (IllegalArgumentException e1) {
                                undecodedValue = m.group(i + 1);
                            }
                        }
                        if (undecodedValue == null) continue;
                        this.addPathParam(context, k, undecodedValue);
                    }
                } else {
                    if (!RouteState.isEmpty(this.namedGroupsInRegex)) {
                        for (String namedGroup : this.namedGroupsInRegex) {
                            String namedGroupValue = m.group(namedGroup);
                            if (namedGroupValue == null) continue;
                            this.addPathParam(context, namedGroup, namedGroupValue);
                        }
                    }
                    for (int i = 0; i < m.groupCount(); ++i) {
                        String group = m.group(i + 1);
                        if (group == null) continue;
                        String k = "param" + i;
                        this.addPathParam(context, k, group);
                    }
                }
            }
        } else if (!RouteState.isEmpty(this.methods) && !this.containsMethod(request)) {
            return 405;
        }
        if (!(RouteState.isEmpty(this.consumes) || (consumal = (contentType = context.parsedHeaders().contentType()).findMatchedBy(this.consumes)) != null || contentType.rawValue().isEmpty() && this.emptyBodyPermittedWithConsumes)) {
            return 415;
        }
        if (!RouteState.isEmpty(this.produces) && !(acceptableTypes = context.parsedHeaders().accept()).isEmpty()) {
            MIMEHeader selectedAccept = context.parsedHeaders().findBestUserAcceptedIn(acceptableTypes, this.produces);
            if (selectedAccept == null) return 406;
            context.setAcceptableContentType(selectedAccept.rawValue());
        }
        if (this.virtualHostMatches(context.request())) return 0;
        return 404;
    }

    private boolean pathMatches(String mountPoint, RoutingContext ctx) {
        String requestPath;
        boolean pathEndsWithSlash;
        String thePath;
        boolean rootRouter;
        boolean bl = rootRouter = mountPoint == null;
        if (rootRouter) {
            thePath = this.path;
            pathEndsWithSlash = this.pathEndsWithSlash;
        } else {
            boolean mountPointEndsWithSlash;
            boolean bl2 = mountPointEndsWithSlash = mountPoint.charAt(mountPoint.length() - 1) == '/';
            if (this.path.length() == 1) {
                thePath = mountPoint;
                pathEndsWithSlash = mountPointEndsWithSlash;
            } else {
                thePath = mountPointEndsWithSlash ? mountPoint + this.path.substring(1) : mountPoint + this.path;
                pathEndsWithSlash = this.pathEndsWithSlash;
            }
        }
        if (this.useNormalizedPath) {
            requestPath = ctx.normalizedPath();
        } else {
            requestPath = ctx.request().path();
            if (requestPath == null) {
                requestPath = "/";
            }
        }
        if (this.exactPath) {
            ctx.pathParams().remove("*");
            return RouteState.pathMatchesExact(thePath, requestPath, pathEndsWithSlash);
        }
        if (pathEndsWithSlash) {
            int pathLen = thePath.length();
            int reqLen = requestPath.length();
            if (reqLen < pathLen - 2) {
                return false;
            }
            if (reqLen == pathLen - 1 && thePath.regionMatches(0, requestPath, 0, pathLen - 1)) {
                ctx.pathParams().put("*", "/");
                return true;
            }
        }
        if (requestPath.startsWith(thePath)) {
            ctx.pathParams().put("*", URIDecoder.decodeURIComponent((String)requestPath.substring(thePath.length()), (boolean)false));
            return true;
        }
        return false;
    }

    private boolean virtualHostMatches(HttpServerRequest request) {
        int delim;
        if (this.virtualHostPattern == null) {
            return true;
        }
        HostAndPort authority = request.authority();
        if (authority == null) {
            return false;
        }
        String host = authority.host();
        int len = host.length();
        if (len > 3 && host.charAt(0) == '[' && (delim = host.indexOf(93)) != -1 && (delim == len - 1 || host.charAt(delim + 1) == ':')) {
            host = host.substring(1, delim);
            return this.virtualHostPattern.matcher(host).matches();
        }
        int portSeparatorIdx = host.lastIndexOf(58);
        if (portSeparatorIdx != -1) {
            host = host.substring(0, portSeparatorIdx);
        }
        return this.virtualHostPattern.matcher(host).matches();
    }

    private static boolean pathMatchesExact(String base, String other, boolean significantSlash) {
        int len = other.length();
        if (significantSlash) {
            if (other.charAt(len - 1) != '/') {
                return false;
            }
        } else if (other.charAt(len - 1) == '/') {
            if (base.length() != --len) {
                return false;
            }
            return other.regionMatches(0, base, 0, len);
        }
        return other.equals(base);
    }

    private void addPathParam(RoutingContext context, String name, String value) {
        HttpServerRequest request = context.request();
        String decodedValue = URIDecoder.decodeURIComponent((String)value, (boolean)false);
        if (!request.params().contains(name)) {
            request.params().add(name, decodedValue);
        }
        context.pathParams().put(name, decodedValue);
    }

    boolean hasNextContextHandler(RoutingContextImplBase context) {
        return context.currentRouteNextHandlerIndex() < this.getContextHandlersLength();
    }

    boolean hasNextFailureHandler(RoutingContextImplBase context) {
        return context.currentRouteNextFailureHandlerIndex() < this.getFailureHandlersLength();
    }

    void handleContext(RoutingContextImplBase context) {
        this.contextHandlers.get(context.currentRouteNextHandlerIndex() - 1).handle((Object)context);
    }

    void handleFailure(RoutingContextImplBase context) {
        this.failureHandlers.get(context.currentRouteNextFailureHandlerIndex() - 1).handle((Object)context);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.path != null) {
            return this.path;
        }
        if (this.pattern != null) {
            return this.pattern.pattern();
        }
        return null;
    }

    public String toString() {
        return "RouteState{metadata=" + this.metadata + ", path='" + this.path + '\'' + ", name=" + this.name + ", order=" + this.order + ", enabled=" + this.enabled + ", methods=" + this.methods + ", consumes=" + this.consumes + ", emptyBodyPermittedWithConsumes=" + this.emptyBodyPermittedWithConsumes + ", produces=" + this.produces + ", contextHandlers=" + this.contextHandlers + ", failureHandlers=" + this.failureHandlers + ", added=" + this.added + ", pattern=" + this.pattern + ", groups=" + this.groups + ", useNormalizedPath=" + this.useNormalizedPath + ", namedGroupsInRegex=" + this.namedGroupsInRegex + ", virtualHostPattern=" + this.virtualHostPattern + ", pathEndsWithSlash=" + this.pathEndsWithSlash + ", exclusive=" + this.exclusive + ", exactPath=" + this.exactPath + '}';
    }

    static enum Priority {
        PLATFORM,
        SECURITY_POLICY,
        BODY,
        MULTI_TENANT,
        AUTHENTICATION,
        INPUT_TRUST,
        AUTHORIZATION,
        USER;

    }
}

