/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.internal.BaseExecutionContext;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;

public class RowProcessingStateStandardImpl
extends BaseExecutionContext
implements RowProcessingState {
    private final JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState;
    private final RowReader<?> rowReader;
    private final JdbcValues jdbcValues;
    private final ExecutionContext executionContext;
    private final boolean needsResolveState;
    private final InitializerData[] initializerData;

    public RowProcessingStateStandardImpl(JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState, ExecutionContext executionContext, RowReader<?> rowReader, JdbcValues jdbcValues) {
        super(resultSetProcessingState.getSession());
        this.resultSetProcessingState = resultSetProcessingState;
        this.executionContext = executionContext;
        this.rowReader = rowReader;
        this.jdbcValues = jdbcValues;
        this.needsResolveState = !this.isQueryCacheHit() && this.getQueryOptions().isResultCachingEnabled() == Boolean.TRUE;
        this.initializerData = new InitializerData[rowReader.getInitializerCount()];
    }

    @Override
    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.resultSetProcessingState;
    }

    @Override
    public LockMode determineEffectiveLockMode(String alias) {
        if (this.jdbcValues.usesFollowOnLocking()) {
            return LockMode.NONE;
        }
        LockMode effectiveLockMode = this.resultSetProcessingState.getQueryOptions().getLockOptions().getLockMode();
        return effectiveLockMode == LockMode.NONE ? this.jdbcValues.getValuesMapping().determineDefaultLockMode(alias, effectiveLockMode) : effectiveLockMode;
    }

    @Override
    public boolean needsResolveState() {
        return this.needsResolveState;
    }

    @Override
    public <T extends InitializerData> T getInitializerData(int initializerId) {
        return (T)this.initializerData[initializerId];
    }

    @Override
    public void setInitializerData(int initializerId, InitializerData state) {
        this.initializerData[initializerId] = state;
    }

    @Override
    public RowReader<?> getRowReader() {
        return this.rowReader;
    }

    public boolean next() {
        return this.jdbcValues.next(this);
    }

    public boolean previous() {
        return this.jdbcValues.previous(this);
    }

    public boolean scroll(int i) {
        return this.jdbcValues.scroll(i, this);
    }

    public boolean position(int i) {
        return this.jdbcValues.position(i, this);
    }

    public int getPosition() {
        return this.jdbcValues.getPosition();
    }

    public boolean isBeforeFirst() {
        return this.jdbcValues.isBeforeFirst(this);
    }

    public void beforeFirst() {
        this.jdbcValues.beforeFirst(this);
    }

    public boolean isFirst() {
        return this.jdbcValues.isFirst(this);
    }

    public boolean first() {
        return this.jdbcValues.first(this);
    }

    public boolean last() {
        return this.jdbcValues.last(this);
    }

    public boolean isLast() {
        return this.jdbcValues.isLast(this);
    }

    public void afterLast() {
        this.jdbcValues.afterLast(this);
    }

    public boolean isAfterLast() {
        return this.jdbcValues.isAfterLast(this);
    }

    @Override
    public Object getJdbcValue(int position) {
        return this.jdbcValues.getCurrentRowValue(position);
    }

    @Override
    public void registerNonExists(EntityFetch fetch) {
    }

    @Override
    public boolean isQueryCacheHit() {
        return this.jdbcValues instanceof JdbcValuesCacheHit;
    }

    @Override
    public void finishRowProcessing(boolean wasAdded) {
        this.jdbcValues.finishRowProcessing(this, wasAdded);
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.executionContext.getQueryOptions();
    }

    @Override
    public QueryParameterBindings getQueryParameterBindings() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getQueryParameterBindings();
    }

    @Override
    public boolean isScrollResult() {
        return this.executionContext.isScrollResult();
    }

    @Override
    public Callback getCallback() {
        return this.executionContext.getCallback();
    }

    @Override
    public boolean hasCallbackActions() {
        return this.executionContext.hasCallbackActions();
    }

    @Override
    public CollectionKey getCollectionKey() {
        return this.executionContext.getCollectionKey();
    }

    @Override
    public Object getEntityInstance() {
        return this.executionContext.getEntityInstance();
    }

    @Override
    public Object getEntityId() {
        return this.executionContext.getEntityId();
    }

    @Override
    public String getEntityUniqueKeyAttributePath() {
        return this.executionContext.getEntityUniqueKeyAttributePath();
    }

    @Override
    public Object getEntityUniqueKey() {
        return this.executionContext.getEntityUniqueKey();
    }

    @Override
    public EntityMappingType getRootEntityDescriptor() {
        return this.executionContext.getRootEntityDescriptor();
    }

    @Override
    public void registerLoadingEntityHolder(EntityHolder holder) {
        this.executionContext.registerLoadingEntityHolder(holder);
    }

    @Override
    public void afterStatement(LogicalConnectionImplementor logicalConnection) {
        this.executionContext.afterStatement(logicalConnection);
    }

    @Override
    public boolean hasQueryExecutionToBeAddedToStatistics() {
        return this.executionContext.hasQueryExecutionToBeAddedToStatistics();
    }

    @Override
    public boolean upgradeLocks() {
        return this.executionContext.upgradeLocks();
    }
}

