/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.InterpolatorEnum;
import org.itk.simple.PixelIDValueEnum;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.Transform;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorUInt32;

public class ResampleImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected ResampleImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.ResampleImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(ResampleImageFilter resampleImageFilter) {
        return resampleImageFilter == null ? 0L : resampleImageFilter.swigCPtr;
    }

    protected static long swigRelease(ResampleImageFilter resampleImageFilter) {
        long l = 0L;
        if (resampleImageFilter != null) {
            if (!resampleImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = resampleImageFilter.swigCPtr;
            resampleImageFilter.swigCMemOwn = false;
            resampleImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_ResampleImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public ResampleImageFilter() {
        this(SimpleITKJNI.new_ResampleImageFilter(), true);
    }

    public void setSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.ResampleImageFilter_setSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getSize() {
        return new VectorUInt32(SimpleITKJNI.ResampleImageFilter_getSize(this.swigCPtr, this), true);
    }

    public void setTransform(Transform transform) {
        SimpleITKJNI.ResampleImageFilter_setTransform(this.swigCPtr, this, Transform.getCPtr(transform), transform);
    }

    public Transform getTransform() {
        return new Transform(SimpleITKJNI.ResampleImageFilter_getTransform(this.swigCPtr, this), true);
    }

    public void setInterpolator(InterpolatorEnum interpolatorEnum) {
        SimpleITKJNI.ResampleImageFilter_setInterpolator(this.swigCPtr, this, interpolatorEnum.swigValue());
    }

    public InterpolatorEnum getInterpolator() {
        return InterpolatorEnum.swigToEnum(SimpleITKJNI.ResampleImageFilter_getInterpolator(this.swigCPtr, this));
    }

    public void setOutputOrigin(VectorDouble vectorDouble) {
        SimpleITKJNI.ResampleImageFilter_setOutputOrigin(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputOrigin() {
        return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputOrigin(this.swigCPtr, this), true);
    }

    public void setOutputSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.ResampleImageFilter_setOutputSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputSpacing() {
        return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputSpacing(this.swigCPtr, this), true);
    }

    public void setOutputDirection(VectorDouble vectorDouble) {
        SimpleITKJNI.ResampleImageFilter_setOutputDirection(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOutputDirection() {
        return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputDirection(this.swigCPtr, this), true);
    }

    public void setDefaultPixelValue(double d) {
        SimpleITKJNI.ResampleImageFilter_setDefaultPixelValue(this.swigCPtr, this, d);
    }

    public double getDefaultPixelValue() {
        return SimpleITKJNI.ResampleImageFilter_getDefaultPixelValue(this.swigCPtr, this);
    }

    public void setOutputPixelType(PixelIDValueEnum pixelIDValueEnum) {
        SimpleITKJNI.ResampleImageFilter_setOutputPixelType(this.swigCPtr, this, pixelIDValueEnum.swigValue());
    }

    public PixelIDValueEnum getOutputPixelType() {
        return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ResampleImageFilter_getOutputPixelType(this.swigCPtr, this));
    }

    public void setUseNearestNeighborExtrapolator(boolean bl) {
        SimpleITKJNI.ResampleImageFilter_setUseNearestNeighborExtrapolator(this.swigCPtr, this, bl);
    }

    public void useNearestNeighborExtrapolatorOn() {
        SimpleITKJNI.ResampleImageFilter_useNearestNeighborExtrapolatorOn(this.swigCPtr, this);
    }

    public void useNearestNeighborExtrapolatorOff() {
        SimpleITKJNI.ResampleImageFilter_useNearestNeighborExtrapolatorOff(this.swigCPtr, this);
    }

    public boolean getUseNearestNeighborExtrapolator() {
        return SimpleITKJNI.ResampleImageFilter_getUseNearestNeighborExtrapolator(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.ResampleImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.ResampleImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.ResampleImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }

    public void setReferenceImage(Image image) {
        SimpleITKJNI.ResampleImageFilter_setReferenceImage(this.swigCPtr, this, Image.getCPtr(image), image);
    }
}

