/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.splashscreen.parts.DescriptionInfoItem;
import net.sourceforge.jnlp.splashscreen.parts.InfoItem;
import net.sourceforge.jnlp.util.logging.OutputController;

public class InformationElement {
    private InfoItem title;
    private InfoItem vendor;
    private InfoItem homepage;
    private List<DescriptionInfoItem> descriptions = new ArrayList<DescriptionInfoItem>(5);

    public void setTitle(String title) {
        if (title == null) {
            return;
        }
        this.title = new InfoItem("title", title);
    }

    public void setvendor(String vendor) {
        if (vendor == null) {
            return;
        }
        this.vendor = new InfoItem("vendor", vendor);
    }

    public void setHomepage(String homepage) {
        if (homepage == null) {
            return;
        }
        this.homepage = new InfoItem("homepage", homepage);
    }

    public void addDescription(String description) {
        this.addDescription(description, null);
    }

    public void addDescription(String description, String kind) {
        if (description == null) {
            return;
        }
        DescriptionInfoItem d = new DescriptionInfoItem(description, kind);
        for (DescriptionInfoItem descriptionInfoItem : this.descriptions) {
            if (!descriptionInfoItem.isOfSameKind(d)) continue;
            this.descriptions.remove(descriptionInfoItem);
            this.descriptions.add(d);
            return;
        }
        this.descriptions.add(d);
    }

    public InfoItem getBestMatchingDescriptionForSplash() {
        for (DescriptionInfoItem d : this.descriptions) {
            if (!InfoItem.descriptionKindOneLine.equals(d.getKind())) continue;
            return d;
        }
        for (DescriptionInfoItem d : this.descriptions) {
            if (d.getKind() != null) continue;
            return d;
        }
        return null;
    }

    public InfoItem getLongestDescriptionForSplash() {
        for (DescriptionInfoItem d : this.descriptions) {
            if (!InfoItem.descriptionKindShort.equals(d.getKind())) continue;
            return d;
        }
        for (DescriptionInfoItem d : this.descriptions) {
            if (d.getKind() != null) continue;
            return d;
        }
        for (DescriptionInfoItem d : this.descriptions) {
            if (!InfoItem.descriptionKindOneLine.equals(d.getKind())) continue;
            return d;
        }
        for (DescriptionInfoItem d : this.descriptions) {
            if (!InfoItem.descriptionKindToolTip.equals(d.getKind())) continue;
            return d;
        }
        return null;
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.toNiceString();
    }

    public String getVendor() {
        if (this.vendor == null) {
            return null;
        }
        return this.vendor.toNiceString();
    }

    public String getHomepage() {
        if (this.homepage == null) {
            return null;
        }
        return this.homepage.toNiceString();
    }

    List<DescriptionInfoItem> getDescriptions() {
        return Collections.unmodifiableList(this.descriptions);
    }

    public String getDescription() {
        InfoItem i = this.getBestMatchingDescriptionForSplash();
        if (i == null) {
            return null;
        }
        return i.toNiceString();
    }

    public List<String> getHeader() {
        ArrayList<String> r = new ArrayList<String>(4);
        String t = this.getTitle();
        String v = this.getVendor();
        String h = this.getHomepage();
        if (t != null) {
            r.add(t);
        }
        if (v != null) {
            r.add(v);
        }
        if (h != null) {
            r.add(h);
        }
        return r;
    }

    public static InformationElement createFromJNLP(JNLPFile file) {
        try {
            if (file == null) {
                String message = Translator.R("SPLASHerrorInInformation");
                InformationElement ie = new InformationElement();
                ie.setHomepage("");
                ie.setTitle(message);
                ie.setvendor("");
                ie.addDescription(message);
                return ie;
            }
            if (file.getInformation() == null) {
                String message = Translator.R("SPLASHmissingInformation");
                InformationElement ie = new InformationElement();
                ie.setHomepage("");
                ie.setTitle(message);
                ie.setvendor("");
                ie.addDescription(message);
                return ie;
            }
            InformationElement ie = new InformationElement();
            String homePage = Translator.R("SPLASHdefaultHomepage");
            if (file.getInformation().getHomepage() != null) {
                homePage = file.getInformation().getHomepage().toString();
            }
            ie.setHomepage(homePage);
            ie.setTitle(file.getInformation().getTitle());
            ie.setvendor(file.getInformation().getVendor());
            ie.addDescription(file.getInformation().getDescriptionStrict((String)InformationDesc.DEFAULT));
            ie.addDescription(file.getInformation().getDescriptionStrict(InfoItem.descriptionKindOneLine), InfoItem.descriptionKindOneLine);
            ie.addDescription(file.getInformation().getDescriptionStrict(InfoItem.descriptionKindShort), InfoItem.descriptionKindShort);
            ie.addDescription(file.getInformation().getDescriptionStrict(InfoItem.descriptionKindToolTip), InfoItem.descriptionKindToolTip);
            return ie;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            String message = Translator.R("SPLASHerrorInInformation");
            InformationElement ie = new InformationElement();
            ie.setHomepage("");
            ie.setTitle(message);
            ie.setvendor("");
            ie.addDescription(ex.getMessage());
            return ie;
        }
    }
}

