/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.action;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef.EditDomain;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.ui.editors.erd.ERDUIUtils;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorAdapter;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;

public class ERDHandlerFocus
extends AbstractHandler {
    private static final String DIAGRAM_FOCUS = "org.jkiss.dbeaver.erd.focus.diagram";
    private static final String PALETTE_FOCUS = "org.jkiss.dbeaver.erd.focus.palette";
    private static final String OUTLINE_FOCUS = "org.jkiss.dbeaver.erd.focus.outline";
    private static final String PARAMETER_FOCUS = "org.jkiss.dbeaver.erd.focus.parameter";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ERDEditorPart part = this.getPart(event);
        if (part == null) {
            return null;
        }
        switch (event.getCommand().getId()) {
            case "org.jkiss.dbeaver.erd.focus.diagram": {
                part.getViewer().getControl().forceFocus();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.palette": {
                Object adapter = part.getAdapter(EditDomain.class);
                if (!(adapter instanceof EditDomain) || ((EditDomain)adapter).getPaletteViewer() == null) break;
                ((EditDomain)adapter).getPaletteViewer().getControl().setFocus();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.outline": {
                ERDUIUtils.openOutline();
                break;
            }
            case "org.jkiss.dbeaver.erd.focus.parameter": {
                ERDUIUtils.openProperties();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getCommand().getId());
            }
        }
        return null;
    }

    private ERDEditorPart getPart(ExecutionEvent event) {
        Object activeEditor;
        ERDEditorPart editor = null;
        Control control = (Control)HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeFocusControl");
        if (control != null) {
            editor = ERDEditorAdapter.getEditor(control);
        }
        if (editor == null && (activeEditor = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditor")) != null) {
            editor = new ERDEditorAdapter().getAdapter(activeEditor, ERDEditorPart.class);
        }
        return editor;
    }
}

