/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IErrorBarPolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ZoomableChart;
import info.monitorenter.gui.chart.axis.AxisLinear;
import info.monitorenter.gui.chart.axis.AxisLog10;
import info.monitorenter.gui.chart.axis.AxisLogE;
import info.monitorenter.gui.chart.errorbars.AErrorBarPolicyConfigurable;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyAbsoluteSummation;
import info.monitorenter.gui.chart.errorbars.ErrorBarPolicyRelative;
import info.monitorenter.gui.chart.events.AxisActionSetGrid;
import info.monitorenter.gui.chart.events.AxisActionSetRange;
import info.monitorenter.gui.chart.events.AxisActionSetRangePolicy;
import info.monitorenter.gui.chart.events.AxisActionSetTitle;
import info.monitorenter.gui.chart.events.AxisActionSetTitleFont;
import info.monitorenter.gui.chart.events.Chart2DActionPrintSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSaveEpsSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSaveImageSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetAxis;
import info.monitorenter.gui.chart.events.Chart2DActionSetCustomGridColorSingleton;
import info.monitorenter.gui.chart.events.Chart2DActionSetGridColor;
import info.monitorenter.gui.chart.events.ErrorBarPolicyMultiAction;
import info.monitorenter.gui.chart.events.JComponentActionSetBackground;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomBackgroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetCustomForegroundSingleton;
import info.monitorenter.gui.chart.events.JComponentActionSetForeground;
import info.monitorenter.gui.chart.events.PopupListener;
import info.monitorenter.gui.chart.events.Trace2DActionAddRemoveTracePainter;
import info.monitorenter.gui.chart.events.Trace2DActionRemove;
import info.monitorenter.gui.chart.events.Trace2DActionSetColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetCustomColor;
import info.monitorenter.gui.chart.events.Trace2DActionSetName;
import info.monitorenter.gui.chart.events.Trace2DActionSetPhysicalUnits;
import info.monitorenter.gui.chart.events.Trace2DActionSetStroke;
import info.monitorenter.gui.chart.events.Trace2DActionSetVisible;
import info.monitorenter.gui.chart.events.Trace2DActionSetZindex;
import info.monitorenter.gui.chart.events.Trace2DActionZindexDecrease;
import info.monitorenter.gui.chart.events.Trace2DActionZindexIncrease;
import info.monitorenter.gui.chart.events.ZoomableChartZoomOutAction;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyFixedViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyForcedPoint;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyHighestValues;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyMinimumViewport;
import info.monitorenter.gui.chart.rangepolicies.RangePolicyUnbounded;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import info.monitorenter.gui.chart.traces.painters.TracePainterDisc;
import info.monitorenter.gui.chart.traces.painters.TracePainterFill;
import info.monitorenter.gui.chart.traces.painters.TracePainterPolyline;
import info.monitorenter.gui.chart.traces.painters.TracePainterVerticalBar;
import info.monitorenter.util.Range;
import info.monitorenter.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;

public final class LayoutFactory {
    private static LayoutFactory instance;
    private boolean m_showAxisXGridMenu = true;
    private boolean m_showAxisXMenu = true;
    private boolean m_showAxisXRangePolicyMenu = true;
    private boolean m_showAxisXTitleMenu = true;
    private boolean m_showAxisXTypeMenu = true;
    private boolean m_showAxisYGridMenu = true;
    private boolean m_showAxisYMenu = true;
    private boolean m_showAxisYRangePolicyMenu = true;
    private boolean m_showAxisYTitleMenu = true;
    private boolean m_showAxisYTypeMenu = true;
    private boolean m_showChartBackgroundMenu = true;
    private boolean m_showChartForegroundMenu = true;
    private boolean m_showErrorBarWizardMenu = true;
    private boolean m_showGridColorMenu = true;
    private boolean m_showPhysicalUnitsMenu = true;
    private boolean m_showRemoveTraceMenu = false;
    private boolean m_showSaveMenu = true;
    private boolean m_showPrintMenu = true;
    private boolean m_showSaveEpsMenu = true;
    private boolean m_showTraceColorMenu = true;
    private boolean m_showTraceNameMenu = true;
    private boolean m_showTracePainterMenu = true;
    private boolean m_showTraceStrokeMenu = true;
    private boolean m_showTraceVisibleMenu = true;
    private boolean m_showTraceZindexMenu = true;
    private boolean m_showZoomOutMenu = true;
    private String[] m_strokeNames;
    private Stroke[] m_strokes = new Stroke[6];

    private LayoutFactory() {
        this.m_strokeNames = new String[6];
        this.m_strokes[0] = new BasicStroke();
        this.m_strokeNames[0] = "basic";
        this.m_strokes[1] = new BasicStroke(2.0f);
        this.m_strokeNames[1] = "thick";
        this.m_strokes[2] = new BasicStroke(6.0f, 1, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[2] = "round caps";
        this.m_strokes[3] = new BasicStroke(1.0f, 0, 0, 1.5f, new float[]{5.0f, 5.0f}, 2.5f);
        this.m_strokeNames[3] = "dashed";
        this.m_strokes[4] = new BasicStroke(6.0f, 2, 1, 10.0f, new float[]{0.0f, 10.0f}, 0.0f);
        this.m_strokeNames[4] = "square caps";
        this.m_strokes[5] = new BasicStroke(3.0f, 0, 2, 1.5f, new float[]{10.0f, 2.0f}, 1.0f);
        this.m_strokeNames[5] = "dashed thick";
    }

    public static LayoutFactory getInstance() {
        if (instance == null) {
            instance = new LayoutFactory();
        }
        return instance;
    }

    private static Font[] getSystemFonts(float pointSize) {
        Font[] result = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = result.length - 1; i > -1; --i) {
            result[i] = result[i].deriveFont(pointSize);
        }
        return result;
    }

    public JMenu createAxisRangePolicyMenu(Chart2D chart2D, IAxis iAxis, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Range policy") : new JMenu("Range policy");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> clazz = iAxis.getRangePolicy().getClass();
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Fixed viewport", iAxis.getDimension(), new RangePolicyFixedViewport())) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Fixed viewport", iAxis.getDimension(), new RangePolicyFixedViewport()));
        jRadioButtonMenuItem.setToolTipText("Zooms or expands to the configured range without respect to the data to display. ");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == RangePolicyFixedViewport.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Minimum viewport", iAxis.getDimension(), new RangePolicyUnbounded())) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Minimum viewport", iAxis.getDimension(), new RangePolicyUnbounded()));
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setToolTipText("Ensures all data is shown with minimal bounds.");
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == RangePolicyUnbounded.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Minimum viewport with range", iAxis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0)))) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Minimum viewport with range", iAxis.getDimension(), new RangePolicyMinimumViewport(new Range(10.0, 10.0))));
        jRadioButtonMenuItem.setToolTipText("Ensures that all data is shown and expands if range is higher. ");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == RangePolicyMinimumViewport.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Ensure visible point", iAxis.getDimension(), new RangePolicyForcedPoint(0.0))) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Ensure visible point", iAxis.getDimension(), new RangePolicyForcedPoint(0.0)));
        jRadioButtonMenuItem.setToolTipText("Only the minimum value of the axis' range will be ensured to be visible.");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == RangePolicyForcedPoint.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new AxisActionSetRangePolicy(chart2D, "Highest points within max-50 to max.", iAxis.getDimension(), new RangePolicyHighestValues(50))) : new SelectionAdaptJRadioButtonMenuItem(new AxisActionSetRangePolicy(chart2D, "Highest points within max-50 to max.", iAxis.getDimension(), new RangePolicyHighestValues(50)));
        jRadioButtonMenuItem.setToolTipText("Shows the highest values from max-50 to max.");
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == RangePolicyHighestValues.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        return jMenu;
    }

    public JMenu createAxisTitleMenu(Chart2D chart, IAxis axis, int axisDimension, boolean adaptUI2Chart) {
        JMenu axisTitle = adaptUI2Chart ? new PropertyChangeMenu(chart, "Title") : new JMenu("Title");
        JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new AxisActionSetTitle(chart, "Title", axisDimension)) : new JMenuItem(new AxisActionSetTitle(chart, "Title", axisDimension));
        axisTitle.add(item);
        JMenu axisTitleFont = adaptUI2Chart ? new PropertyChangeMenu(chart, "Font") : new JMenu("Font");
        Font[] fonts = LayoutFactory.getSystemFonts(14.0f);
        for (int i = fonts.length - 1; i > -1; --i) {
            item = adaptUI2Chart ? new OrderingCheckBoxPropertyChangeMenuItem(chart, new AxisActionSetTitleFont(chart, fonts[i].getName(), axisDimension, fonts[i]), axisTitleFont, false) : new OrderingCheckBoxMenuItem(new AxisActionSetTitleFont(chart, fonts[i].getName(), axisDimension, fonts[i]), axisTitleFont, false);
            item.setFont(fonts[i]);
            axisTitleFont.add(item);
        }
        axisTitle.add(axisTitleFont);
        return axisTitle;
    }

    public JMenu createAxisTypeMenu(Chart2D chart2D, IAxis iAxis, int n, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Type") : new JMenu("Type");
        ButtonGroup buttonGroup = new ButtonGroup();
        Class<?> clazz = iAxis.getClass();
        JRadioButtonMenuItem jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLinear(), "Linear", n)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLinear(), "Linear", n));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == AxisLinear.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLogE(), "Log E", n)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLogE(), "Log E", n));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == AxisLogE.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        jRadioButtonMenuItem = bl ? new PropertyChangeJRadioButtonMenuItem(chart2D, new Chart2DActionSetAxis(chart2D, new AxisLog10(), "Log 10", n)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetAxis(chart2D, new AxisLog10(), "Log 10", n));
        jMenu.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        if (clazz == AxisLog10.class) {
            buttonGroup.setSelected(jRadioButtonMenuItem.getModel(), true);
        }
        return jMenu;
    }

    public JMenu createBackgroundColorMenu(Chart2D chart, boolean adaptUI2Chart) {
        Color backgroundColor = chart.getBackground();
        boolean nonStandardColor = true;
        JMenu bgColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Background color") : new JMenu("Background color");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "White", Color.WHITE)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "White", Color.WHITE));
        if (backgroundColor.equals(Color.WHITE)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        bgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Gray", Color.GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Gray", Color.GRAY));
        if (backgroundColor.equals(Color.GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        bgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Light gray", Color.LIGHT_GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Light gray", Color.LIGHT_GRAY));
        if (backgroundColor.equals(Color.LIGHT_GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        bgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetBackground(chart, "Black", Color.BLACK)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetBackground(chart, "Black", Color.BLACK));
        if (backgroundColor.equals(Color.BLACK)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        bgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, JComponentActionSetCustomBackgroundSingleton.getInstance(chart, "Custom Color")) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomBackgroundSingleton.getInstance(chart, "Custom Color"));
        item.setSelected(nonStandardColor);
        buttonGroup.add(item);
        bgColorMenu.add(item);
        return bgColorMenu;
    }

    public JLabel createContextMenuLabel(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        String traceLabel = trace.getLabel();
        TraceJLabel ret = null;
        if (!StringUtil.isEmpty(traceLabel)) {
            JMenuItem item;
            ret = new TraceJLabel(trace.getLabel());
            PropertyChangePopupMenu popup = new PropertyChangePopupMenu(chart);
            Color background = chart.getBackground();
            ret.setBackground(background);
            ret.setForeground(trace.getColor());
            if (this.m_showTraceVisibleMenu) {
                item = adaptUI2Chart ? new PropertyChangeCheckBoxMenuItem(chart, new Trace2DActionSetVisible(trace, "Visible"), trace.isVisible()) : new SelectionAdaptJCheckBoxMenuItem(new Trace2DActionSetVisible(trace, "Visible"), trace.isVisible());
                popup.add(item);
            }
            if (this.m_showTraceNameMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetName(trace, "Name", chart)) : new JMenuItem(new Trace2DActionSetName(trace, "Name", chart));
                popup.add(item);
            }
            if (this.m_showPhysicalUnitsMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionSetPhysicalUnits(trace, "Physical Units", chart)) : new JMenuItem(new Trace2DActionSetPhysicalUnits(trace, "Physical Units", chart));
                popup.add(item);
            }
            if (this.m_showTraceColorMenu) {
                popup.add(this.createTraceColorMenu(chart, trace, ret, adaptUI2Chart));
            }
            if (this.m_showTraceZindexMenu) {
                popup.add(this.createTraceZindexMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showTraceStrokeMenu) {
                popup.add(this.createTraceStrokesMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showTracePainterMenu) {
                popup.add(this.createTracePainterMenu(chart, trace, adaptUI2Chart));
            }
            if (this.m_showRemoveTraceMenu) {
                item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new Trace2DActionRemove(trace, "Remove")) : new JMenuItem(new Trace2DActionRemove(trace, "Remove"));
                popup.add(item);
            }
            if (this.m_showErrorBarWizardMenu) {
                popup.add(this.createErrorBarWizardMenu(chart, trace, adaptUI2Chart));
            }
            ret.addMouseListener(new PopupListener(popup));
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_COLOR", ret);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_NAME", ret);
            trace.addPropertyChangeListener("ITrace2D.PROPERTY_PHYSICALUNITS", ret);
            chart.addPropertyChangeListener("Chart2D.PROPERTY_FONT", ret);
        }
        return ret;
    }

    public JMenu createErrorBarWizardMenu(Chart2D chart, ITrace2D trace, boolean adaptUI2Chart) {
        JMenu errorBarMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "error bar policies") : new JMenu("error bar policies");
        JMenu errorBarAddMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "+") : new JMenu("+");
        errorBarMenu.add(errorBarAddMenu);
        JMenu errorBarRemoveMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "-") : new JMenu("-");
        errorBarMenu.add(errorBarRemoveMenu);
        JMenu erroBarEditMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "edit") : new JMenu("edit");
        errorBarMenu.add(erroBarEditMenu);
        LinkedList<JMenu> group1 = new LinkedList<JMenu>();
        group1.add(erroBarEditMenu);
        group1.add(errorBarRemoveMenu);
        LinkedList<JMenu> group2 = new LinkedList<JMenu>();
        group2.add(errorBarAddMenu);
        TreeSet<AErrorBarPolicyConfigurable> allErrorBarPolicies = new TreeSet<AErrorBarPolicyConfigurable>();
        allErrorBarPolicies.add(new ErrorBarPolicyRelative(0.02, 0.02));
        allErrorBarPolicies.add(new ErrorBarPolicyAbsoluteSummation(4.0, 4.0));
        Set<IErrorBarPolicy> errorBarPolicies = trace.getErrorBarPolicies();
        for (IErrorBarPolicy errorBarPolicy : errorBarPolicies) {
            JMenuItem item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)) : new JMenuItem(new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu));
            erroBarEditMenu.add(item);
        }
        TreeSet addableErrorBarPolicies = new TreeSet(allErrorBarPolicies);
        for (IErrorBarPolicy errorBarPolicy : errorBarPolicies) {
            addableErrorBarPolicies.remove(errorBarPolicy);
        }
        for (IErrorBarPolicy errorBarPolicy : addableErrorBarPolicies) {
            if (adaptUI2Chart) {
                errorBarAddMenu.add(new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
                continue;
            }
            errorBarAddMenu.add(new JMenuItem(new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
        }
        for (IErrorBarPolicy errorBarPolicy : errorBarPolicies) {
            if (adaptUI2Chart) {
                errorBarRemoveMenu.add(new PropertyChangeMenuItem(chart, new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
                continue;
            }
            errorBarRemoveMenu.add(new JMenuItem(new ErrorBarPolicyMultiAction(trace, errorBarPolicy.getClass().getName(), errorBarPolicy, errorBarAddMenu, errorBarRemoveMenu, erroBarEditMenu)));
        }
        return errorBarMenu;
    }

    public JMenuItem createForegroundColorMenu(Chart2D chart, boolean adaptUI2Chart) {
        Color foregroundColor = chart.getForeground();
        boolean nonStandardColor = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu fgColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Foreground color") : new JMenu("Foreground color");
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "White", Color.WHITE)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "White", Color.WHITE));
        if (foregroundColor.equals(Color.WHITE)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        fgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "Gray", Color.GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Gray", Color.GRAY));
        if (foregroundColor.equals(Color.GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        fgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "Light gray", Color.LIGHT_GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Light gray", Color.LIGHT_GRAY));
        if (foregroundColor.equals(Color.LIGHT_GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        fgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new JComponentActionSetForeground(chart, "Black", Color.BLACK)) : new SelectionAdaptJRadioButtonMenuItem(new JComponentActionSetForeground(chart, "Black", Color.BLACK));
        if (foregroundColor.equals(Color.BLACK)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        fgColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, JComponentActionSetCustomForegroundSingleton.getInstance(chart, "Custom Color")) : new SelectionAdaptJRadioButtonMenuItem(JComponentActionSetCustomForegroundSingleton.getInstance(chart, "Custom Color"));
        item.setSelected(nonStandardColor);
        buttonGroup.add(item);
        fgColorMenu.add(item);
        return fgColorMenu;
    }

    public JMenu createGridColorMenu(Chart2D chart, boolean adaptUI2Chart) {
        Color gridColor = chart.getGridColor();
        boolean nonStandardColor = true;
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu gridColorMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Grid color") : new JMenu("Grid color");
        JRadioButtonMenuItem item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Gray", Color.GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Gray", Color.GRAY));
        if (gridColor.equals(Color.GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        gridColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Light gray", Color.LIGHT_GRAY)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Light gray", Color.LIGHT_GRAY));
        if (gridColor.equals(Color.LIGHT_GRAY)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        gridColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "Black", Color.BLACK)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "Black", Color.BLACK));
        if (gridColor.equals(Color.BLACK)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        gridColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, new Chart2DActionSetGridColor(chart, "White", Color.WHITE)) : new SelectionAdaptJRadioButtonMenuItem(new Chart2DActionSetGridColor(chart, "White", Color.WHITE));
        if (gridColor.equals(Color.WHITE)) {
            item.setSelected(true);
            nonStandardColor = false;
        }
        buttonGroup.add(item);
        gridColorMenu.add(item);
        item = adaptUI2Chart ? new PropertyChangeJRadioButtonMenuItem(chart, Chart2DActionSetCustomGridColorSingleton.getInstance(chart, "Custom")) : new SelectionAdaptJRadioButtonMenuItem(Chart2DActionSetCustomGridColorSingleton.getInstance(chart, "Custom"));
        item.setSelected(nonStandardColor);
        buttonGroup.add(item);
        gridColorMenu.add(item);
        return gridColorMenu;
    }

    public JMenu createMenu(Chart2D chart, boolean adaptUI2Chart) {
        JMenuItem item;
        JMenu chartMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Chart") : new JMenu("Chart");
        if (this.m_showChartBackgroundMenu) {
            chartMenu.add(this.createBackgroundColorMenu(chart, adaptUI2Chart));
        }
        if (this.m_showChartForegroundMenu) {
            chartMenu.add(this.createForegroundColorMenu(chart, adaptUI2Chart));
        }
        if (this.m_showGridColorMenu) {
            chartMenu.add(this.createGridColorMenu(chart, adaptUI2Chart));
        }
        if (this.m_showAxisXMenu || this.m_showAxisYMenu) {
            JMenu axisMenu = adaptUI2Chart ? new PropertyChangeMenu(chart, "Axis") : new JMenu("Axis");
            if (this.m_showAxisXMenu) {
                JMenuItem xAxisMenuItem = this.createAxisMenuItem(chart.getAxisX(), 1, adaptUI2Chart);
                axisMenu.add(xAxisMenuItem);
            }
            if (this.m_showAxisYMenu) {
                JMenuItem yAxisMenuItem = this.createAxisMenuItem(chart.getAxisY(), 2, adaptUI2Chart);
                axisMenu.add(yAxisMenuItem);
            }
            chartMenu.add(axisMenu);
        }
        if (this.m_showSaveMenu) {
            item = this.createSaveMenu(chart, adaptUI2Chart);
            chartMenu.add(item);
        }
        if (this.m_showPrintMenu) {
            item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, Chart2DActionPrintSingleton.getInstance(chart, "Print chart")) : new JMenuItem(Chart2DActionPrintSingleton.getInstance(chart, "Print chart"));
            chartMenu.add(item);
        }
        if (chart instanceof ZoomableChart && this.m_showZoomOutMenu) {
            item = adaptUI2Chart ? new PropertyChangeMenuItem(chart, new ZoomableChartZoomOutAction((ZoomableChart)chart, "Zoom Out")) : new JMenuItem(new ZoomableChartZoomOutAction((ZoomableChart)chart, "Zoom Out"));
            chartMenu.add(item);
        }
        return chartMenu;
    }

    public JMenuBar createMenuBar(Chart2D chart, boolean adaptUI2Chart) {
        JMenu chartMenu = this.createMenu(chart, adaptUI2Chart);
        JMenuBar menubar = adaptUI2Chart ? new PropertyChangeJMenuBar(chart) : new JMenuBar();
        menubar.add(chartMenu);
        return menubar;
    }

    public void createPopupMenu(Chart2D chart, boolean adaptUI2Chart) {
        JPopupMenu popup = adaptUI2Chart ? new PropertyChangePopupMenu(chart) : new JPopupMenu();
        JMenu menu = this.createMenu(chart, adaptUI2Chart);
        for (Component component : menu.getMenuComponents()) {
            menu.remove(component);
            popup.add(component);
        }
        chart.addMouseListener(new PopupListener(popup));
    }

    public JMenu createSaveMenu(Chart2D chart, boolean adaptUI2Chart) {
        JMenu result;
        if (adaptUI2Chart) {
            result = new PropertyChangeMenu(chart, "Save");
            PropertyChangeMenuItem item = new PropertyChangeMenuItem(chart, Chart2DActionSaveImageSingleton.getInstance(chart, "Save image"));
            result.add(item);
            if (this.m_showSaveEpsMenu) {
                item = new PropertyChangeMenuItem(chart, Chart2DActionSaveEpsSingleton.getInstance(chart, "Save eps"));
                result.add(item);
            }
        } else {
            result = new JMenu("Save");
            JMenuItem item = new JMenuItem(Chart2DActionSaveImageSingleton.getInstance(chart, "Save image"));
            result.add(item);
            if (this.m_showSaveEpsMenu) {
                item = new JMenuItem(Chart2DActionSaveEpsSingleton.getInstance(chart, "Save eps"));
                result.add(item);
            }
        }
        return result;
    }

    public JMenu createTraceColorMenu(Chart2D chart2D, ITrace2D iTrace2D, JComponent jComponent, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Color") : new JMenu("Color");
        JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Red", Color.RED)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Red", Color.RED));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Green", Color.GREEN)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Green", Color.GREEN));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Blue", Color.BLUE)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Blue", Color.BLUE));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Gray", Color.GRAY)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Gray", Color.GRAY));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Magenta", Color.MAGENTA)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Magenta", Color.MAGENTA));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Pink", Color.PINK)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Pink", Color.PINK));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetColor(iTrace2D, "Black", Color.BLACK)) : new JMenuItem(new Trace2DActionSetColor(iTrace2D, "Black", Color.BLACK));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetCustomColor(iTrace2D, "Custom", jComponent)) : new JMenuItem(new Trace2DActionSetCustomColor(iTrace2D, "Custom", jComponent));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JMenu createTracePainterMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "renderer") : new JMenu("renderer");
        ATracePainter aTracePainter = new TracePainterDisc(4);
        OrderingCheckBoxMenuItem orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "discs", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "discs", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        if (iTrace2D.getTracePainters().contains(aTracePainter)) {
            orderingCheckBoxMenuItem.setSelected(true);
        }
        jMenu.add(orderingCheckBoxMenuItem);
        aTracePainter = new TracePainterPolyline();
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "line", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "line", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        if (iTrace2D.getTracePainters().contains(aTracePainter)) {
            orderingCheckBoxMenuItem.setSelected(true);
        }
        aTracePainter = new TracePainterFill(chart2D);
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "fill", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "fill", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        if (iTrace2D.getTracePainters().contains(aTracePainter)) {
            orderingCheckBoxMenuItem.setSelected(true);
        }
        aTracePainter = new TracePainterVerticalBar(chart2D);
        orderingCheckBoxMenuItem = bl ? new OrderingCheckBoxPropertyChangeMenuItem(chart2D, new Trace2DActionAddRemoveTracePainter(iTrace2D, "bar", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter)) : new OrderingCheckBoxMenuItem(new Trace2DActionAddRemoveTracePainter(iTrace2D, "bar", aTracePainter), jMenu, iTrace2D.containsTracePainter(aTracePainter));
        jMenu.add(orderingCheckBoxMenuItem);
        if (iTrace2D.getTracePainters().contains(aTracePainter)) {
            orderingCheckBoxMenuItem.setSelected(true);
        }
        return jMenu;
    }

    public JMenu createTraceStrokesMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Stroke") : new JMenu("Stroke");
        for (int i = 0; i < this.m_strokes.length; ++i) {
            JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetStroke(iTrace2D, this.m_strokeNames[i], this.m_strokes[i])) : new JMenuItem(new Trace2DActionSetStroke(iTrace2D, this.m_strokeNames[i], this.m_strokes[i]));
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public JMenu createTraceZindexMenu(Chart2D chart2D, ITrace2D iTrace2D, boolean bl) {
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "layer") : new JMenu("layer");
        JMenuItem jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetZindex(iTrace2D, "bring to front", 0)) : new JMenuItem(new Trace2DActionSetZindex(iTrace2D, "bring to front", 0));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionSetZindex(iTrace2D, "send to back", 100)) : new JMenuItem(new Trace2DActionSetZindex(iTrace2D, "send to back", 100));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionZindexDecrease(iTrace2D, "forward", 2)) : new JMenuItem(new Trace2DActionZindexDecrease(iTrace2D, "forward", 2));
        jMenu.add(jMenuItem);
        jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new Trace2DActionZindexIncrease(iTrace2D, "backwards", 2)) : new JMenuItem(new Trace2DActionZindexIncrease(iTrace2D, "backwards", 2));
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public final boolean isShowAxisXGridMenu() {
        return this.m_showAxisXGridMenu;
    }

    public final boolean isShowAxisXMenu() {
        return this.m_showAxisXMenu;
    }

    public final boolean isShowAxisXRangePolicyMenu() {
        return this.m_showAxisXRangePolicyMenu;
    }

    public final boolean isShowAxisXTypeMenu() {
        return this.m_showAxisXTypeMenu;
    }

    public final boolean isShowAxisYGridMenu() {
        return this.m_showAxisYGridMenu;
    }

    public final boolean isShowAxisYMenu() {
        return this.m_showAxisYMenu;
    }

    public final boolean isShowAxisYRangePolicyMenu() {
        return this.m_showAxisYRangePolicyMenu;
    }

    public final boolean isShowAxisYTypeMenu() {
        return this.m_showAxisYTypeMenu;
    }

    public final boolean isShowChartBackgroundMenu() {
        return this.m_showChartBackgroundMenu;
    }

    public final boolean isShowChartForegroundMenu() {
        return this.m_showChartForegroundMenu;
    }

    public final boolean isShowGridColorMenu() {
        return this.m_showGridColorMenu;
    }

    public final boolean isShowPrintMenu() {
        return this.m_showPrintMenu;
    }

    public final boolean isShowSaveEpsMenu() {
        return this.m_showSaveEpsMenu;
    }

    public final boolean isShowSaveMenu() {
        return this.m_showSaveMenu;
    }

    public final boolean isShowTraceColorMenu() {
        return this.m_showTraceColorMenu;
    }

    public final boolean isShowTraceNameMenu() {
        return this.m_showTraceNameMenu;
    }

    public final boolean isShowTracePainterMenu() {
        return this.m_showTracePainterMenu;
    }

    public final boolean isShowTraceStrokeMenu() {
        return this.m_showTraceStrokeMenu;
    }

    public final boolean isShowTraceVisibleMenu() {
        return this.m_showTraceVisibleMenu;
    }

    public final boolean isShowTraceZindexMenu() {
        return this.m_showTraceZindexMenu;
    }

    public final boolean isZoomOutMenu() {
        return this.m_showZoomOutMenu;
    }

    public final void setShowAxisXGridMenu(boolean showAxisXGridMenu) {
        this.m_showAxisXGridMenu = showAxisXGridMenu;
    }

    public final void setShowAxisXMenu(boolean showAxisXMenu) {
        this.m_showAxisXMenu = showAxisXMenu;
    }

    public final void setShowAxisXRangePolicyMenu(boolean showAxisXRangePolicyMenu) {
        this.m_showAxisXRangePolicyMenu = showAxisXRangePolicyMenu;
    }

    public final void setShowAxisXTypeMenu(boolean showAxisXTypeMenu) {
        this.m_showAxisXTypeMenu = showAxisXTypeMenu;
    }

    public final void setShowAxisYGridMenu(boolean showAxisYGridMenu) {
        this.m_showAxisYGridMenu = showAxisYGridMenu;
    }

    public final void setShowAxisYMenu(boolean showAxisYMenu) {
        this.m_showAxisYMenu = showAxisYMenu;
    }

    public final void setShowAxisYRangePolicyMenu(boolean showAxisYRangePolicyMenu) {
        this.m_showAxisYRangePolicyMenu = showAxisYRangePolicyMenu;
    }

    public final void setShowAxisYTypeMenu(boolean showAxisYTypeMenu) {
        this.m_showAxisYTypeMenu = showAxisYTypeMenu;
    }

    public final void setShowChartBackgroundMenu(boolean showChartBackgroundMenu) {
        this.m_showChartBackgroundMenu = showChartBackgroundMenu;
    }

    public final void setShowChartForegroundMenu(boolean showChartForegroundMenu) {
        this.m_showChartForegroundMenu = showChartForegroundMenu;
    }

    public final void setShowGridColorMenu(boolean showGridColorMenu) {
        this.m_showGridColorMenu = showGridColorMenu;
    }

    public final void setShowPrintMenu(boolean showPrintMenu) {
        this.m_showPrintMenu = showPrintMenu;
    }

    public final void setShowSaveEpsMenu(boolean showSaveEpsMenu) {
        this.m_showSaveEpsMenu = showSaveEpsMenu;
    }

    public final void setShowSaveMenu(boolean showSaveMenu) {
        this.m_showSaveMenu = showSaveMenu;
    }

    public final void setShowTraceColorMenu(boolean showTraceColorMenu) {
        this.m_showTraceColorMenu = showTraceColorMenu;
    }

    public final void setShowTraceNameMenu(boolean showTraceNameMenu) {
        this.m_showTraceNameMenu = showTraceNameMenu;
    }

    public final void setShowTracePainterMenu(boolean showTracePainterMenu) {
        this.m_showTracePainterMenu = showTracePainterMenu;
    }

    public final void setShowTraceStrokeMenu(boolean showTraceStrokeMenu) {
        this.m_showTraceStrokeMenu = showTraceStrokeMenu;
    }

    public final void setShowTraceVisibleMenu(boolean showTraceVisibleMenu) {
        this.m_showTraceVisibleMenu = showTraceVisibleMenu;
    }

    public final void setShowTraceZindexMenu(boolean showTraceZindexMenu) {
        this.m_showTraceZindexMenu = showTraceZindexMenu;
    }

    public final void setZoomOutMenu(boolean showZoomOutMenu) {
        this.m_showZoomOutMenu = showZoomOutMenu;
    }

    protected JMenuItem createAxisMenuItem(IAxis iAxis, int n, boolean bl) {
        JMenuItem jMenuItem;
        Chart2D chart2D = iAxis.getAccessor().getChart();
        JMenu jMenu = bl ? new PropertyChangeMenu(chart2D, "Axis" + iAxis.getAccessor().toString()) : new JMenu("Axis" + iAxis.getAccessor().toString());
        if (this.m_showAxisXTypeMenu && n == 1 || this.m_showAxisYTypeMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisTypeMenu(chart2D, iAxis, n, bl));
        }
        if (this.m_showAxisXRangePolicyMenu && n == 1 || this.m_showAxisYRangePolicyMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisRangePolicyMenu(chart2D, iAxis, bl));
            jMenuItem = bl ? new PropertyChangeMenuItem(chart2D, new AxisActionSetRange(chart2D, "Range", n)) : new JMenuItem(new AxisActionSetRange(chart2D, "Range", n));
            ((Container)jMenu).add(jMenuItem);
        }
        if (this.m_showAxisXTitleMenu && n == 1 || this.m_showAxisYTitleMenu && n == 2) {
            ((Container)jMenu).add(this.createAxisTitleMenu(chart2D, iAxis, n, bl));
        }
        if (this.m_showAxisXGridMenu && n == 1 || this.m_showAxisYGridMenu && n == 2) {
            jMenuItem = bl ? new PropertyChangeCheckBoxMenuItem(chart2D, new AxisActionSetGrid(chart2D, "Grid", n), iAxis.isPaintGrid()) : new SelectionAdaptJCheckBoxMenuItem(new AxisActionSetGrid(chart2D, "Grid", n), iAxis.isPaintGrid());
            ((Container)jMenu).add(jMenuItem);
        }
        return jMenu;
    }

    protected final boolean isShowPhysicalUnitsMenu() {
        return this.m_showPhysicalUnitsMenu;
    }

    protected final boolean isShowRemoveTraceMenu() {
        return this.m_showRemoveTraceMenu;
    }

    protected final void setShowPhysicalUnitsMenu(boolean showPhysicalUnitsMenu) {
        this.m_showPhysicalUnitsMenu = showPhysicalUnitsMenu;
    }

    protected final void setShowRemoveTraceMenu(boolean showRemoveTraceMenu) {
        this.m_showRemoveTraceMenu = showRemoveTraceMenu;
    }

    private static class SelectionAdaptJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        public SelectionAdaptJRadioButtonMenuItem(Action action) {
            super(action);
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class SelectionAdaptJCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public SelectionAdaptJCheckBoxMenuItem(Action action, boolean state) {
            super(action);
            this.setSelected(state);
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangePopupMenu
    extends JPopupMenu {
        public PropertyChangePopupMenu(JComponent component) {
            new BasicPropertyAdaptSupport(this, component);
        }
    }

    private static class PropertyChangeMenu
    extends JMenu {
        public PropertyChangeMenu(JComponent component, String name) {
            super(name);
            this.setOpaque(true);
            new BasicPropertyAdaptSupport(this, component);
        }
    }

    private static class PropertyChangeJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        public PropertyChangeJRadioButtonMenuItem(JComponent component, Action action) {
            super(action);
            new BasicPropertyAdaptSupport(this, component);
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    private static class PropertyChangeJMenuBar
    extends JMenuBar {
        public PropertyChangeJMenuBar(JComponent component) {
            new BasicPropertyAdaptSupport(this, component);
        }
    }

    private static class OrderingCheckBoxPropertyChangeMenuItem
    extends OrderingCheckBoxMenuItem {
        public OrderingCheckBoxPropertyChangeMenuItem(JComponent component, Action action, JMenu container, boolean checked) {
            super(action, container, checked);
            new BasicPropertyAdaptSupport(this, component);
        }
    }

    private static class OrderingCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        protected JMenu m_menu;

        public OrderingCheckBoxMenuItem(Action action, JMenu container, boolean checked) {
            this.setSelected(checked);
            this.m_menu = container;
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
            super.setAction(new JMenuOrderingAction(action));
        }

        private final class JMenuOrderingAction
        extends AbstractAction {
            private Action m_action;

            protected JMenuOrderingAction(Action delegate) {
                this.m_action = delegate;
            }

            public void actionPerformed(ActionEvent e) {
                this.m_action.actionPerformed(e);
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                boolean state = item.getState();
                if (state) {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add((Component)OrderingCheckBoxMenuItem.this, 0);
                } else {
                    OrderingCheckBoxMenuItem.this.m_menu.remove(OrderingCheckBoxMenuItem.this);
                    OrderingCheckBoxMenuItem.this.m_menu.add(OrderingCheckBoxMenuItem.this);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                this.m_action.addPropertyChangeListener(listener);
            }

            public boolean equals(Object obj) {
                return this.m_action.equals(obj);
            }

            public Object getValue(String key) {
                return this.m_action.getValue(key);
            }

            public int hashCode() {
                return this.m_action.hashCode();
            }

            public boolean isEnabled() {
                return this.m_action.isEnabled();
            }

            public void putValue(String key, Object value) {
                this.m_action.putValue(key, value);
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                this.m_action.removePropertyChangeListener(listener);
            }

            public void setEnabled(boolean b) {
                this.m_action.setEnabled(b);
            }

            public String toString() {
                return this.m_action.toString();
            }
        }
    }

    final class TraceJLabel
    extends JLabel
    implements PropertyChangeListener {
        public TraceJLabel(String name) {
            super(name);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName.equals("ITrace2D.PROPERTY_COLOR")) {
                Color background;
                Color color = (Color)evt.getNewValue();
                if (color.equals(background = this.getBackground())) {
                    this.setBackground(this.getForeground());
                }
                this.setForeground(color);
            } else if (propertyName.equals("Chart2D.PROPERTY_BACKGROUND_COLOR")) {
                Color foreground;
                Color background = (Color)evt.getNewValue();
                if (background.equals(foreground = this.getForeground())) {
                    this.setForeground(this.getBackground());
                }
                this.setBackground(background);
            } else if (propertyName.equals("Chart2D.PROPERTY_FONT")) {
                Font font = (Font)evt.getNewValue();
                this.setFont(font);
            } else if (propertyName.equals("ITrace2D.PROPERTY_NAME")) {
                ITrace2D source = (ITrace2D)evt.getSource();
                this.setText(source.getLabel());
            } else if (propertyName.equals("ITrace2D.PROPERTY_PHYSICALUNITS")) {
                ITrace2D source = (ITrace2D)evt.getSource();
                this.setText(source.getLabel());
            }
        }
    }

    public static class SelectionPropertyAdaptSupport
    implements PropertyChangeListener {
        protected WeakReference<AbstractButton> m_delegate;

        public SelectionPropertyAdaptSupport(AbstractButton delegate) {
            this.m_delegate = new WeakReference<AbstractButton>(delegate);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            AbstractButton button = (AbstractButton)this.m_delegate.get();
            if (button != null) {
                if (prop.equals("")) {
                    boolean state = (Boolean)evt.getNewValue();
                    button.setSelected(state);
                }
            } else {
                ((Component)evt.getSource()).removePropertyChangeListener(this);
            }
        }
    }

    public static class PropertyChangeMenuItem
    extends JMenuItem {
        private WeakReference<JComponent> m_component;

        public PropertyChangeMenuItem(JComponent component, Action action) {
            super(action);
            new BasicPropertyAdaptSupport(this, component);
            this.m_component = new WeakReference<JComponent>(component);
        }

        public JComponent getUIAdaptee() {
            return (JComponent)this.m_component.get();
        }
    }

    public static class PropertyChangeCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        public static final String PROPERTY_SELECTED = "";

        public PropertyChangeCheckBoxMenuItem(JComponent component, Action action, boolean checked) {
            super(action);
            this.setState(checked);
            new BasicPropertyAdaptSupport(this, component);
            if (action != null) {
                action.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }

        public void setAction(Action a) {
            if (a != null) {
                super.setAction(a);
                a.addPropertyChangeListener(new SelectionPropertyAdaptSupport(this));
            }
        }
    }

    public static class BasicPropertyAdaptSupport
    implements PropertyChangeListener {
        private Component m_adaptee;
        protected WeakReference<Component> m_delegate;

        public BasicPropertyAdaptSupport(Component delegate, Component adaptee) {
            this.m_delegate = new WeakReference<Component>(delegate);
            this.m_adaptee = adaptee;
            delegate.setFont(adaptee.getFont());
            delegate.setBackground(adaptee.getBackground());
            delegate.setForeground(adaptee.getForeground());
            adaptee.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            Object reference = this.m_delegate.get();
            if (reference != null) {
                Component component = (Component)reference;
                if (prop.equals("Chart2D.PROPERTY_BACKGROUND_COLOR")) {
                    Color foreground;
                    Color color = (Color)evt.getNewValue();
                    if (color.equals(foreground = component.getForeground())) {
                        component.setForeground(component.getBackground());
                    }
                    component.setBackground(color);
                    component.repaint();
                } else if (prop.equals("Chart2D.PROPERTY_FONT")) {
                    Font font = (Font)evt.getNewValue();
                    component.setFont(font);
                } else if (prop.equals("Chart2D.PROPERTY_FOREGROUND_COLOR")) {
                    Color background;
                    Color color = (Color)evt.getNewValue();
                    if (color.equals(background = component.getBackground())) {
                        component.setBackground(component.getForeground());
                    }
                    component.setForeground(color);
                }
            } else {
                ((Component)evt.getSource()).removePropertyChangeListener(this);
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.m_adaptee.removePropertyChangeListener(this);
        }
    }
}

