# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the action that will be triggered by the Automation."""

    LOGIC_APP = "LogicApp"
    EVENT_HUB = "EventHub"
    WORKSPACE = "Workspace"


class AssessedResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Sub-assessment resource type."""

    SQL_SERVER_VULNERABILITY = "SqlServerVulnerability"
    CONTAINER_REGISTRY_VULNERABILITY = "ContainerRegistryVulnerability"
    SERVER_VULNERABILITY = "ServerVulnerability"


class EventSource(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A valid event source type."""

    ASSESSMENTS = "Assessments"
    ASSESSMENTS_SNAPSHOT = "AssessmentsSnapshot"
    SUB_ASSESSMENTS = "SubAssessments"
    SUB_ASSESSMENTS_SNAPSHOT = "SubAssessmentsSnapshot"
    ALERTS = "Alerts"
    SECURE_SCORES = "SecureScores"
    SECURE_SCORES_SNAPSHOT = "SecureScoresSnapshot"
    SECURE_SCORE_CONTROLS = "SecureScoreControls"
    SECURE_SCORE_CONTROLS_SNAPSHOT = "SecureScoreControlsSnapshot"
    REGULATORY_COMPLIANCE_ASSESSMENT = "RegulatoryComplianceAssessment"
    REGULATORY_COMPLIANCE_ASSESSMENT_SNAPSHOT = "RegulatoryComplianceAssessmentSnapshot"


class Operator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """A valid comparer operator to use. A case-insensitive comparison will be applied for String
    PropertyType.
    """

    EQUALS = "Equals"
    """Applies for decimal and non-decimal operands"""
    GREATER_THAN = "GreaterThan"
    """Applies only for decimal operands"""
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    """Applies only for decimal operands"""
    LESSER_THAN = "LesserThan"
    """Applies only for decimal operands"""
    LESSER_THAN_OR_EQUAL_TO = "LesserThanOrEqualTo"
    """Applies only for decimal operands"""
    NOT_EQUALS = "NotEquals"
    """Applies  for decimal and non-decimal operands"""
    CONTAINS = "Contains"
    """Applies only for non-decimal operands"""
    STARTS_WITH = "StartsWith"
    """Applies only for non-decimal operands"""
    ENDS_WITH = "EndsWith"
    """Applies only for non-decimal operands"""


class PropertyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The data type of the compared operands (string, integer, floating point number or a boolean
    [true/false]].
    """

    STRING = "String"
    INTEGER = "Integer"
    NUMBER = "Number"
    BOOLEAN = "Boolean"


class RuleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible states of the rule."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"
    EXPIRED = "Expired"


class Severity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sub-assessment severity level."""

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"


class Source(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The platform where the assessed resource resides."""

    AZURE = "Azure"
    """Resource is in Azure"""
    ON_PREMISE = "OnPremise"
    """Resource in an on premise machine connected to Azure cloud"""
    ON_PREMISE_SQL = "OnPremiseSql"
    """SQL Resource in an on premise machine connected to Azure cloud"""


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Aggregative state based on the standard's supported controls states."""

    PASSED = "Passed"
    """All supported regulatory compliance controls in the given standard have a passed state"""
    FAILED = "Failed"
    """At least one supported regulatory compliance control in the given standard has a state of
    #: failed"""
    SKIPPED = "Skipped"
    """All supported regulatory compliance controls in the given standard have a state of skipped"""
    UNSUPPORTED = "Unsupported"
    """No supported regulatory compliance data for the given standard"""


class SubAssessmentStatusCode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Programmatic code for the status of the assessment."""

    HEALTHY = "Healthy"
    """The resource is healthy"""
    UNHEALTHY = "Unhealthy"
    """The resource has a security issue that needs to be addressed"""
    NOT_APPLICABLE = "NotApplicable"
    """Assessment for this resource did not happen"""
