﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>

namespace Aws {
namespace imagebuilder {
namespace Model {
enum class LifecycleExecutionResourceActionName { NOT_SET, AVAILABLE, DELETE_, DEPRECATE, DISABLE };

namespace LifecycleExecutionResourceActionNameMapper {
AWS_IMAGEBUILDER_API LifecycleExecutionResourceActionName GetLifecycleExecutionResourceActionNameForName(const Aws::String& name);

AWS_IMAGEBUILDER_API Aws::String GetNameForLifecycleExecutionResourceActionName(LifecycleExecutionResourceActionName value);
}  // namespace LifecycleExecutionResourceActionNameMapper
}  // namespace Model
}  // namespace imagebuilder
}  // namespace Aws
