﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/rekognition/RekognitionRequest.h>
#include <aws/rekognition/Rekognition_EXPORTS.h>
#include <aws/rekognition/model/Image.h>

#include <utility>

namespace Aws {
namespace Rekognition {
namespace Model {

/**
 */
class RecognizeCelebritiesRequest : public RekognitionRequest {
 public:
  AWS_REKOGNITION_API RecognizeCelebritiesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "RecognizeCelebrities"; }

  AWS_REKOGNITION_API Aws::String SerializePayload() const override;

  AWS_REKOGNITION_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The input image as base64-encoded bytes or an S3 object. If you use the AWS
   * CLI to call Amazon Rekognition operations, passing base64-encoded image bytes is
   * not supported. </p> <p>If you are using an AWS SDK to call Amazon Rekognition,
   * you might not need to base64-encode image bytes passed using the
   * <code>Bytes</code> field. For more information, see Images in the Amazon
   * Rekognition developer guide.</p>
   */
  inline const Image& GetImage() const { return m_image; }
  inline bool ImageHasBeenSet() const { return m_imageHasBeenSet; }
  template <typename ImageT = Image>
  void SetImage(ImageT&& value) {
    m_imageHasBeenSet = true;
    m_image = std::forward<ImageT>(value);
  }
  template <typename ImageT = Image>
  RecognizeCelebritiesRequest& WithImage(ImageT&& value) {
    SetImage(std::forward<ImageT>(value));
    return *this;
  }
  ///@}
 private:
  Image m_image;
  bool m_imageHasBeenSet = false;
};

}  // namespace Model
}  // namespace Rekognition
}  // namespace Aws
