/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.CheckedIntConsumer;
import org.apache.lucene.search.DocIdStream;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.neuralsearch.query.HybridBulkScorer;

public class HybridQueryDocIdStream
extends DocIdStream {
    private static final int BLOCK_SHIFT = 6;
    private final HybridBulkScorer hybridBulkScorer;
    private FixedBitSet localMatchingBitSet;
    private int base;

    public int count(int upTo) {
        int[] count = new int[]{0};
        try {
            this.forEach(upTo, (CheckedIntConsumer<IOException>)((CheckedIntConsumer)docId -> {
                count[0] = count[0] + 1;
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return count[0];
    }

    public boolean mayHaveRemaining() {
        return false;
    }

    public void forEach(int upTo, CheckedIntConsumer<IOException> consumer) throws IOException {
        FixedBitSet matchingBitSet = this.hybridBulkScorer.getMatching();
        long[] bitArray = matchingBitSet.getBits();
        for (int idx = 0; idx < bitArray.length; ++idx) {
            int numberOfTrailingZeros;
            for (long bits = bitArray[idx]; bits != 0L; bits ^= 1L << numberOfTrailingZeros) {
                numberOfTrailingZeros = Long.numberOfTrailingZeros(bits);
                int docIndexInWindow = idx << 6 | numberOfTrailingZeros;
                int docId = this.base | docIndexInWindow;
                float[][] windowScores = this.hybridBulkScorer.getWindowScores();
                for (int subQueryIndex = 0; subQueryIndex < windowScores.length; ++subQueryIndex) {
                    float scoreOfDocIdForSubQuery;
                    if (Objects.isNull(windowScores[subQueryIndex])) continue;
                    this.hybridBulkScorer.getHybridSubQueryScorer().getSubQueryScores()[subQueryIndex] = scoreOfDocIdForSubQuery = windowScores[subQueryIndex][docIndexInWindow];
                }
                consumer.accept(docId);
                this.hybridBulkScorer.getHybridSubQueryScorer().resetScores();
            }
        }
    }

    private FixedBitSet getLocalMatchingBitSet() {
        if (this.localMatchingBitSet == null) {
            this.localMatchingBitSet = this.hybridBulkScorer.getMatching().clone();
        }
        return this.localMatchingBitSet;
    }

    @Generated
    public HybridQueryDocIdStream(HybridBulkScorer hybridBulkScorer) {
        this.hybridBulkScorer = hybridBulkScorer;
    }

    @Generated
    public void setBase(int base) {
        this.base = base;
    }
}

