/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.lang.ASTNode;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TreeChangeImpl
implements Comparable<TreeChangeImpl> {
    private final ASTNode myParent;
    private final List<ASTNode> mySuperParents;
    private final LinkedHashMap<ASTNode, Integer> myInitialLengths;
    private final Set<ASTNode> myContentChangeChildren;
    private Map<ASTNode, ChangeInfoImpl> myChanges;

    public TreeChangeImpl(@NotNull ASTNode parent2) {
        if (parent2 == null) {
            TreeChangeImpl.$$$reportNull$$$0(0);
        }
        this.myInitialLengths = new LinkedHashMap();
        this.myContentChangeChildren = new HashSet<ASTNode>();
        this.myParent = parent2;
        assert (this.myParent.getPsi() != null) : this.myParent.getElementType() + " of " + this.myParent.getClass();
        this.mySuperParents = JBIterable.generate(parent2.getTreeParent(), ASTNode::getTreeParent).toList();
        for (ASTNode child : this.getCurrentChildren()) {
            this.myInitialLengths.put(child, child.getTextLength());
        }
    }

    List<ASTNode> getSuperParents() {
        return this.mySuperParents;
    }

    @NotNull
    private JBIterable<ASTNode> getCurrentChildren() {
        JBIterable<ASTNode> jBIterable = JBIterable.generate(this.myParent.getFirstChildNode(), ASTNode::getTreeNext);
        if (jBIterable == null) {
            TreeChangeImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    @Override
    public int compareTo(@NotNull TreeChangeImpl o2) {
        if (o2 == null) {
            TreeChangeImpl.$$$reportNull$$$0(2);
        }
        List<ASTNode> thisParents = ContainerUtil.reverse(this.getSuperParents());
        List<ASTNode> thatParents = ContainerUtil.reverse(o2.getSuperParents());
        for (int i2 = 1; i2 <= thisParents.size() && i2 <= thatParents.size(); ++i2) {
            ASTNode thatParent;
            ASTNode thisParent = i2 < thisParents.size() ? thisParents.get(i2) : this.myParent;
            int result2 = TreeChangeImpl.compareNodePositions(thisParent, thatParent = i2 < thatParents.size() ? thatParents.get(i2) : o2.myParent);
            if (result2 == 0) continue;
            return result2;
        }
        return 0;
    }

    private static int compareNodePositions(ASTNode node1, ASTNode node2) {
        int o2;
        if (node1 == node2) {
            return 0;
        }
        int o1 = node1.getStartOffsetInParent();
        return o1 != (o2 = node2.getStartOffsetInParent()) ? Integer.compare(o1, o2) : Integer.compare(TreeChangeImpl.getChildIndex(node1), TreeChangeImpl.getChildIndex(node2));
    }

    private static int getChildIndex(ASTNode e2) {
        return ArrayUtil.indexOf(e2.getTreeParent().getChildren(null), e2);
    }

    int getLengthDelta() {
        return this.getAllChanges().values().stream().mapToInt(ChangeInfoImpl::getLengthDelta).sum();
    }

    void clearCache() {
        this.myChanges = null;
    }

    private Map<ASTNode, ChangeInfoImpl> getAllChanges() {
        Map<ASTNode, ChangeInfoImpl> changes = this.myChanges;
        if (changes == null) {
            this.myChanges = changes = new ChildrenDiff().calcChanges();
        }
        return changes;
    }

    @NotNull
    public ASTNode getChangedParent() {
        ASTNode aSTNode = this.myParent;
        if (aSTNode == null) {
            TreeChangeImpl.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    void fireEvents(PsiFile file) {
        int start = this.myParent.getStartOffset();
        Collection<ChangeInfoImpl> changes = this.getAllChanges().values();
        if (ContainerUtil.exists(changes, c2 -> c2.hasNoPsi())) {
            ChangeInfoImpl.childrenChanged(ChangeInfoImpl.createEvent(file, start), this.myParent, this.myParent.getTextLength() - this.getLengthDelta());
            return;
        }
        for (ChangeInfoImpl change : changes) {
            change.fireEvent(start, file, this.myParent);
        }
    }

    public ASTNode @NotNull [] getAffectedChildren() {
        ASTNode[] aSTNodeArray = this.getAllChanges().keySet().toArray(ASTNode.EMPTY_ARRAY);
        if (aSTNodeArray == null) {
            TreeChangeImpl.$$$reportNull$$$0(4);
        }
        return aSTNodeArray;
    }

    public ChangeInfoImpl getChangeByChild(ASTNode child) {
        return this.getAllChanges().get(child);
    }

    public String toString() {
        return this.myParent + ": " + this.getAllChanges().values();
    }

    void appendChanges(@NotNull TreeChangeImpl next) {
        if (next == null) {
            TreeChangeImpl.$$$reportNull$$$0(5);
        }
        this.myContentChangeChildren.addAll(next.myContentChangeChildren);
        this.clearCache();
    }

    public void markChildChanged(@NotNull ASTNode child, int lengthDelta) {
        if (child == null) {
            TreeChangeImpl.$$$reportNull$$$0(6);
        }
        this.myContentChangeChildren.add(child);
        if (lengthDelta != 0) {
            this.myInitialLengths.computeIfPresent(child, (c2, oldLength) -> oldLength - lengthDelta);
        }
        this.clearCache();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/tree/events/impl/TreeChangeImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/tree/events/impl/TreeChangeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChildren";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markChildChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ChildrenDiff {
        LinkedHashSet<ASTNode> currentChildren;
        Iterator<ASTNode> itOld;
        Iterator<ASTNode> itNew;
        ASTNode oldChild;
        ASTNode newChild;
        int oldOffset;
        LinkedHashMap<ASTNode, ChangeInfoImpl> result;

        private ChildrenDiff() {
            this.currentChildren = TreeChangeImpl.this.getCurrentChildren().addAllTo(new LinkedHashSet());
            this.itOld = TreeChangeImpl.this.myInitialLengths.keySet().iterator();
            this.itNew = this.currentChildren.iterator();
            this.oldOffset = 0;
            this.result = new LinkedHashMap();
        }

        void advanceOld() {
            this.oldOffset += this.oldChild == null ? 0 : (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild);
            this.oldChild = this.itOld.hasNext() ? this.itOld.next() : null;
        }

        void advanceNew() {
            this.newChild = this.itNew.hasNext() ? this.itNew.next() : null;
        }

        Map<ASTNode, ChangeInfoImpl> calcChanges() {
            this.advanceOld();
            this.advanceNew();
            while (this.oldChild != null || this.newChild != null) {
                if (this.oldChild == this.newChild) {
                    if (TreeChangeImpl.this.myContentChangeChildren.contains(this.oldChild)) {
                        this.addChange(new ChangeInfoImpl(this.oldChild, this.oldChild, this.oldOffset, (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild)));
                    }
                    this.advanceOld();
                    this.advanceNew();
                    continue;
                }
                boolean oldDisappeared = this.oldChild != null && !this.currentChildren.contains(this.oldChild);
                boolean newAppeared = this.newChild != null && !TreeChangeImpl.this.myInitialLengths.containsKey(this.newChild);
                this.addChange(new ChangeInfoImpl(oldDisappeared ? this.oldChild : null, newAppeared ? this.newChild : null, this.oldOffset, oldDisappeared ? (Integer)TreeChangeImpl.this.myInitialLengths.get(this.oldChild) : 0));
                if (oldDisappeared) {
                    this.advanceOld();
                }
                if (!newAppeared) continue;
                this.advanceNew();
            }
            return this.result;
        }

        private void addChange(ChangeInfoImpl change) {
            this.result.put(change.getAffectedChild(), change);
            this.oldOffset += change.getLengthDelta();
        }
    }
}

