# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class AdministratorListResult(_serialization.Model):
    """A list of active directory administrators.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerAzureADAdministrator]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerAzureADAdministrator]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerAzureADAdministrator"]] = None
        self.next_link: Optional[str] = None


class Resource(_serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """


class Advisor(ProxyResource):
    """Database, Server or Elastic Pool Advisor.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar advisor_status: Gets the status of availability of this advisor to customers. Possible
     values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'. Known values
     are: "GA", "PublicPreview", "LimitedPublicPreview", and "PrivatePreview".
    :vartype advisor_status: str or ~azure.mgmt.sql.models.AdvisorStatus
    :ivar auto_execute_status: Gets the auto-execute status (whether to let the system execute the
     recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'. Known values
     are: "Enabled", "Disabled", and "Default".
    :vartype auto_execute_status: str or ~azure.mgmt.sql.models.AutoExecuteStatus
    :ivar auto_execute_status_inherited_from: Gets the resource from which current value of
     auto-execute status is inherited. Auto-execute status can be set on (and inherited from)
     different levels in the resource hierarchy. Possible values are 'Subscription', 'Server',
     'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level). Known
     values are: "Default", "Subscription", "Server", "ElasticPool", and "Database".
    :vartype auto_execute_status_inherited_from: str or
     ~azure.mgmt.sql.models.AutoExecuteStatusInheritedFrom
    :ivar recommendations_status: Gets that status of recommendations for this advisor and reason
     for not having any recommendations. Possible values include, but are not limited to, 'Ok'
     (Recommendations available),LowActivity (not enough workload to analyze), 'DbSeemsTuned'
     (Database is doing well), etc.
    :vartype recommendations_status: str
    :ivar last_checked: Gets the time when the current resource was analyzed for recommendations by
     this advisor.
    :vartype last_checked: ~datetime.datetime
    :ivar recommended_actions: Gets the recommended actions for this advisor.
    :vartype recommended_actions: list[~azure.mgmt.sql.models.RecommendedAction]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "location": {"readonly": True},
        "advisor_status": {"readonly": True},
        "auto_execute_status_inherited_from": {"readonly": True},
        "recommendations_status": {"readonly": True},
        "last_checked": {"readonly": True},
        "recommended_actions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "advisor_status": {"key": "properties.advisorStatus", "type": "str"},
        "auto_execute_status": {"key": "properties.autoExecuteStatus", "type": "str"},
        "auto_execute_status_inherited_from": {"key": "properties.autoExecuteStatusInheritedFrom", "type": "str"},
        "recommendations_status": {"key": "properties.recommendationsStatus", "type": "str"},
        "last_checked": {"key": "properties.lastChecked", "type": "iso-8601"},
        "recommended_actions": {"key": "properties.recommendedActions", "type": "[RecommendedAction]"},
    }

    def __init__(
        self, *, auto_execute_status: Optional[Union[str, "_models.AutoExecuteStatus"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword auto_execute_status: Gets the auto-execute status (whether to let the system execute
         the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'. Known
         values are: "Enabled", "Disabled", and "Default".
        :paramtype auto_execute_status: str or ~azure.mgmt.sql.models.AutoExecuteStatus
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.location: Optional[str] = None
        self.advisor_status: Optional[Union[str, "_models.AdvisorStatus"]] = None
        self.auto_execute_status = auto_execute_status
        self.auto_execute_status_inherited_from: Optional[Union[str, "_models.AutoExecuteStatusInheritedFrom"]] = None
        self.recommendations_status: Optional[str] = None
        self.last_checked: Optional[datetime.datetime] = None
        self.recommended_actions: Optional[List["_models.RecommendedAction"]] = None


class AutomaticTuningOptions(_serialization.Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar desired_state: Automatic tuning option desired state. Known values are: "Off", "On", and
     "Default".
    :vartype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Known values are: "Off" and "On".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are different. Known values
     are: "Default", "Disabled", "AutoConfigured", "InheritedFromServer", "QueryStoreOff",
     "QueryStoreReadOnly", and "NotSupported".
    :vartype reason_desc: str or ~azure.mgmt.sql.models.AutomaticTuningDisabledReason
    """

    _validation = {
        "actual_state": {"readonly": True},
        "reason_code": {"readonly": True},
        "reason_desc": {"readonly": True},
    }

    _attribute_map = {
        "desired_state": {"key": "desiredState", "type": "str"},
        "actual_state": {"key": "actualState", "type": "str"},
        "reason_code": {"key": "reasonCode", "type": "int"},
        "reason_desc": {"key": "reasonDesc", "type": "str"},
    }

    def __init__(
        self, *, desired_state: Optional[Union[str, "_models.AutomaticTuningOptionModeDesired"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword desired_state: Automatic tuning option desired state. Known values are: "Off", "On",
         and "Default".
        :paramtype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
        """
        super().__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state: Optional[Union[str, "_models.AutomaticTuningOptionModeActual"]] = None
        self.reason_code: Optional[int] = None
        self.reason_desc: Optional[Union[str, "_models.AutomaticTuningDisabledReason"]] = None


class AutomaticTuningServerOptions(_serialization.Model):
    """Automatic tuning properties for individual advisors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar desired_state: Automatic tuning option desired state. Known values are: "Off", "On", and
     "Default".
    :vartype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
    :ivar actual_state: Automatic tuning option actual state. Known values are: "Off" and "On".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeActual
    :ivar reason_code: Reason code if desired and actual state are different.
    :vartype reason_code: int
    :ivar reason_desc: Reason description if desired and actual state are different. Known values
     are: "Default", "Disabled", and "AutoConfigured".
    :vartype reason_desc: str or ~azure.mgmt.sql.models.AutomaticTuningServerReason
    """

    _validation = {
        "actual_state": {"readonly": True},
        "reason_code": {"readonly": True},
        "reason_desc": {"readonly": True},
    }

    _attribute_map = {
        "desired_state": {"key": "desiredState", "type": "str"},
        "actual_state": {"key": "actualState", "type": "str"},
        "reason_code": {"key": "reasonCode", "type": "int"},
        "reason_desc": {"key": "reasonDesc", "type": "str"},
    }

    def __init__(
        self, *, desired_state: Optional[Union[str, "_models.AutomaticTuningOptionModeDesired"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword desired_state: Automatic tuning option desired state. Known values are: "Off", "On",
         and "Default".
        :paramtype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningOptionModeDesired
        """
        super().__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state: Optional[Union[str, "_models.AutomaticTuningOptionModeActual"]] = None
        self.reason_code: Optional[int] = None
        self.reason_desc: Optional[Union[str, "_models.AutomaticTuningServerReason"]] = None


class AutoPauseDelayTimeRange(_serialization.Model):
    """Supported auto pause delay time range.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: int
    :ivar max_value: Maximum value.
    :vartype max_value: int
    :ivar step_size: Step value for discrete values between the minimum value and the maximum
     value.
    :vartype step_size: int
    :ivar default: Default value is no value is provided.
    :vartype default: int
    :ivar unit: Unit of time that delay is expressed in. "Minutes"
    :vartype unit: str or ~azure.mgmt.sql.models.PauseDelayTimeUnit
    :ivar do_not_pause_value: Value that is used to not pause (infinite delay before pause).
    :vartype do_not_pause_value: int
    """

    _validation = {
        "min_value": {"readonly": True},
        "max_value": {"readonly": True},
        "step_size": {"readonly": True},
        "default": {"readonly": True},
        "unit": {"readonly": True},
        "do_not_pause_value": {"readonly": True},
    }

    _attribute_map = {
        "min_value": {"key": "minValue", "type": "int"},
        "max_value": {"key": "maxValue", "type": "int"},
        "step_size": {"key": "stepSize", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "do_not_pause_value": {"key": "doNotPauseValue", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.min_value: Optional[int] = None
        self.max_value: Optional[int] = None
        self.step_size: Optional[int] = None
        self.default: Optional[int] = None
        self.unit: Optional[Union[str, "_models.PauseDelayTimeUnit"]] = None
        self.do_not_pause_value: Optional[int] = None


class AzureADOnlyAuthListResult(_serialization.Model):
    """A list of active directory only authentications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerAzureADOnlyAuthentication]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerAzureADOnlyAuthentication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerAzureADOnlyAuthentication"]] = None
        self.next_link: Optional[str] = None


class BackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar retention_days: The backup retention period in days. This is how many days Point-in-Time
     Restore will be supported.
    :vartype retention_days: int
    :ivar diff_backup_interval_in_hours: The differential backup interval in hours. This is how
     many interval hours between each differential backup will be supported. This is only applicable
     to live databases but not dropped databases. Known values are: 12 and 24.
    :vartype diff_backup_interval_in_hours: int or ~azure.mgmt.sql.models.DiffBackupIntervalInHours
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "diff_backup_interval_in_hours": {"key": "properties.diffBackupIntervalInHours", "type": "int"},
    }

    def __init__(
        self,
        *,
        retention_days: Optional[int] = None,
        diff_backup_interval_in_hours: Optional[Union[int, "_models.DiffBackupIntervalInHours"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_days: The backup retention period in days. This is how many days
         Point-in-Time Restore will be supported.
        :paramtype retention_days: int
        :keyword diff_backup_interval_in_hours: The differential backup interval in hours. This is how
         many interval hours between each differential backup will be supported. This is only applicable
         to live databases but not dropped databases. Known values are: 12 and 24.
        :paramtype diff_backup_interval_in_hours: int or
         ~azure.mgmt.sql.models.DiffBackupIntervalInHours
        """
        super().__init__(**kwargs)
        self.retention_days = retention_days
        self.diff_backup_interval_in_hours = diff_backup_interval_in_hours


class BackupShortTermRetentionPolicyListResult(_serialization.Model):
    """A list of short term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.BackupShortTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BackupShortTermRetentionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.BackupShortTermRetentionPolicy"]] = None
        self.next_link: Optional[str] = None


class Baseline(_serialization.Model):
    """SQL Vulnerability Assessment baseline Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expected_results: SQL Vulnerability Assessment baseline expected results.
    :vartype expected_results: list[list[str]]
    :ivar updated_time: SQL Vulnerability Assessment baseline update time (UTC).
    :vartype updated_time: ~datetime.datetime
    """

    _validation = {
        "expected_results": {"readonly": True},
        "updated_time": {"readonly": True},
    }

    _attribute_map = {
        "expected_results": {"key": "expectedResults", "type": "[[str]]"},
        "updated_time": {"key": "updatedTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.expected_results: Optional[List[List[str]]] = None
        self.updated_time: Optional[datetime.datetime] = None


class BaselineAdjustedResult(_serialization.Model):
    """SQL Vulnerability Assessment baseline adjusted results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar baseline: SQL Vulnerability Assessment baseline details.
    :vartype baseline: ~azure.mgmt.sql.models.Baseline
    :ivar status: SQL Vulnerability Assessment baseline status. Known values are: "NonFinding",
     "Finding", and "InternalError".
    :vartype status: str or ~azure.mgmt.sql.models.RuleStatus
    :ivar results_not_in_baseline: SQL Vulnerability Assessment results that are not in baseline.
    :vartype results_not_in_baseline: list[list[str]]
    :ivar results_only_in_baseline: SQL Vulnerability Assessment results that are in baseline.
    :vartype results_only_in_baseline: list[list[str]]
    """

    _validation = {
        "baseline": {"readonly": True},
        "status": {"readonly": True},
        "results_not_in_baseline": {"readonly": True},
        "results_only_in_baseline": {"readonly": True},
    }

    _attribute_map = {
        "baseline": {"key": "baseline", "type": "Baseline"},
        "status": {"key": "status", "type": "str"},
        "results_not_in_baseline": {"key": "resultsNotInBaseline", "type": "[[str]]"},
        "results_only_in_baseline": {"key": "resultsOnlyInBaseline", "type": "[[str]]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.baseline: Optional["_models.Baseline"] = None
        self.status: Optional[Union[str, "_models.RuleStatus"]] = None
        self.results_not_in_baseline: Optional[List[List[str]]] = None
        self.results_only_in_baseline: Optional[List[List[str]]] = None


class BenchmarkReference(_serialization.Model):
    """SQL Vulnerability Assessment benchmark reference.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar benchmark: SQL Vulnerability Assessment benchmark name.
    :vartype benchmark: str
    :ivar reference: SQL Vulnerability Assessment benchmark reference.
    :vartype reference: str
    """

    _validation = {
        "benchmark": {"readonly": True},
        "reference": {"readonly": True},
    }

    _attribute_map = {
        "benchmark": {"key": "benchmark", "type": "str"},
        "reference": {"key": "reference", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.benchmark: Optional[str] = None
        self.reference: Optional[str] = None


class CertificateInfo(_serialization.Model):
    """Certificate information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar certificate_name: The certificate name.
    :vartype certificate_name: str
    :ivar expiry_date: The certificate expiry date.
    :vartype expiry_date: ~datetime.datetime
    """

    _validation = {
        "certificate_name": {"readonly": True},
        "expiry_date": {"readonly": True},
    }

    _attribute_map = {
        "certificate_name": {"key": "certificateName", "type": "str"},
        "expiry_date": {"key": "expiryDate", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.certificate_name: Optional[str] = None
        self.expiry_date: Optional[datetime.datetime] = None


class ChangeLongTermRetentionBackupAccessTierParameters(_serialization.Model):  # pylint: disable=name-too-long
    """Contains the information necessary to change long term retention backup access tier and related
    operation mode.

    All required parameters must be populated in order to send to server.

    :ivar backup_storage_access_tier: The long term retention backup storage access tier. Required.
    :vartype backup_storage_access_tier: str
    :ivar operation_mode: The operation mode when updating ltr backup storage access tier.
     Required.
    :vartype operation_mode: str
    """

    _validation = {
        "backup_storage_access_tier": {"required": True},
        "operation_mode": {"required": True},
    }

    _attribute_map = {
        "backup_storage_access_tier": {"key": "backupStorageAccessTier", "type": "str"},
        "operation_mode": {"key": "operationMode", "type": "str"},
    }

    def __init__(self, *, backup_storage_access_tier: str, operation_mode: str, **kwargs: Any) -> None:
        """
        :keyword backup_storage_access_tier: The long term retention backup storage access tier.
         Required.
        :paramtype backup_storage_access_tier: str
        :keyword operation_mode: The operation mode when updating ltr backup storage access tier.
         Required.
        :paramtype operation_mode: str
        """
        super().__init__(**kwargs)
        self.backup_storage_access_tier = backup_storage_access_tier
        self.operation_mode = operation_mode


class CheckNameAvailabilityRequest(_serialization.Model):
    """A request to check whether the specified name for a resource is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar name: Required.
    :vartype name: str
    :ivar type: Required. Default value is "Microsoft.Sql/servers".
    :vartype type: str
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True, "constant": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    type = "Microsoft.Sql/servers"

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResponse(_serialization.Model):
    """The result of a name availability check.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name whose availability was checked.
    :vartype name: str
    :ivar available: True if the name is available, otherwise false.
    :vartype available: bool
    :ivar reason: The reason code explaining why the name is unavailable. Will be undefined if the
     name is available. Known values are: "Invalid" and "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.sql.models.CheckNameAvailabilityReason
    :ivar message: A message explaining why the name is unavailable. Will be undefined if the name
     is available.
    :vartype message: str
    """

    _validation = {
        "name": {"readonly": True},
        "available": {"readonly": True},
        "reason": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "available": {"key": "available", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.available: Optional[bool] = None
        self.reason: Optional[Union[str, "_models.CheckNameAvailabilityReason"]] = None
        self.message: Optional[str] = None


class CompleteDatabaseRestoreDefinition(_serialization.Model):
    """Contains the information necessary to perform a complete database restore operation.

    All required parameters must be populated in order to send to server.

    :ivar last_backup_name: The last backup name to apply. Required.
    :vartype last_backup_name: str
    """

    _validation = {
        "last_backup_name": {"required": True},
    }

    _attribute_map = {
        "last_backup_name": {"key": "lastBackupName", "type": "str"},
    }

    def __init__(self, *, last_backup_name: str, **kwargs: Any) -> None:
        """
        :keyword last_backup_name: The last backup name to apply. Required.
        :paramtype last_backup_name: str
        """
        super().__init__(**kwargs)
        self.last_backup_name = last_backup_name


class CopyLongTermRetentionBackupParameters(_serialization.Model):
    """Contains the information necessary to perform long term retention backup copy operation.

    :ivar target_subscription_id: The subscription that owns the target server.
    :vartype target_subscription_id: str
    :ivar target_resource_group: The resource group that owns the target server.
    :vartype target_resource_group: str
    :ivar target_server_resource_id: The resource Id of the target server that owns the database.
    :vartype target_server_resource_id: str
    :ivar target_server_fully_qualified_domain_name: The fully qualified domain name of the target
     server.
    :vartype target_server_fully_qualified_domain_name: str
    :ivar target_database_name: The name of the database owns the copied backup.
    :vartype target_database_name: str
    :ivar target_backup_storage_redundancy: The storage redundancy type of the copied backup. Known
     values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype target_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    """

    _attribute_map = {
        "target_subscription_id": {"key": "properties.targetSubscriptionId", "type": "str"},
        "target_resource_group": {"key": "properties.targetResourceGroup", "type": "str"},
        "target_server_resource_id": {"key": "properties.targetServerResourceId", "type": "str"},
        "target_server_fully_qualified_domain_name": {
            "key": "properties.targetServerFullyQualifiedDomainName",
            "type": "str",
        },
        "target_database_name": {"key": "properties.targetDatabaseName", "type": "str"},
        "target_backup_storage_redundancy": {"key": "properties.targetBackupStorageRedundancy", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_subscription_id: Optional[str] = None,
        target_resource_group: Optional[str] = None,
        target_server_resource_id: Optional[str] = None,
        target_server_fully_qualified_domain_name: Optional[str] = None,
        target_database_name: Optional[str] = None,
        target_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_subscription_id: The subscription that owns the target server.
        :paramtype target_subscription_id: str
        :keyword target_resource_group: The resource group that owns the target server.
        :paramtype target_resource_group: str
        :keyword target_server_resource_id: The resource Id of the target server that owns the
         database.
        :paramtype target_server_resource_id: str
        :keyword target_server_fully_qualified_domain_name: The fully qualified domain name of the
         target server.
        :paramtype target_server_fully_qualified_domain_name: str
        :keyword target_database_name: The name of the database owns the copied backup.
        :paramtype target_database_name: str
        :keyword target_backup_storage_redundancy: The storage redundancy type of the copied backup.
         Known values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype target_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        """
        super().__init__(**kwargs)
        self.target_subscription_id = target_subscription_id
        self.target_resource_group = target_resource_group
        self.target_server_resource_id = target_server_resource_id
        self.target_server_fully_qualified_domain_name = target_server_fully_qualified_domain_name
        self.target_database_name = target_database_name
        self.target_backup_storage_redundancy = target_backup_storage_redundancy


class CreateDatabaseRestorePointDefinition(_serialization.Model):
    """Contains the information necessary to perform a create database restore point operation.

    All required parameters must be populated in order to send to server.

    :ivar restore_point_label: The restore point label to apply. Required.
    :vartype restore_point_label: str
    """

    _validation = {
        "restore_point_label": {"required": True},
    }

    _attribute_map = {
        "restore_point_label": {"key": "restorePointLabel", "type": "str"},
    }

    def __init__(self, *, restore_point_label: str, **kwargs: Any) -> None:
        """
        :keyword restore_point_label: The restore point label to apply. Required.
        :paramtype restore_point_label: str
        """
        super().__init__(**kwargs)
        self.restore_point_label = restore_point_label


class TrackedResource(Resource):
    """ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Database(TrackedResource):
    """A database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The database SKU.

     The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU
     name, tier/edition, family, and capacity) that are available to your subscription in an Azure
     region, use the ``Capabilities_ListByLocation`` REST API or one of the following commands:

     .. code-block:: azurecli

        az sql db list-editions -l <location> -o table
        `

     .. code-block:: powershell

        Get-AzSqlServerServiceObjective -Location <location>
        `.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of database. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar managed_by: Resource that manages the database.
    :vartype managed_by: str
    :ivar identity: The Azure Active Directory identity of the database.
    :vartype identity: ~azure.mgmt.sql.models.DatabaseIdentity
    :ivar create_mode: Specifies the mode of database creation.

     Default: regular database creation.

     Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
     as the resource ID of the source database.

     Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
     must be specified as the resource ID of the existing primary database.

     PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
     database. sourceDatabaseId must be specified as the resource ID of the existing database, and
     restorePointInTime must be specified.

     Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
     specified as the recoverable database resource ID to restore.

     Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
     be specified. If sourceDatabaseId is the database's original resource ID, then
     sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
     dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
     also be specified to restore from an earlier point in time.

     RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
     vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
     ID.

     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
     edition. Known values are: "Default", "Copy", "Secondary", "PointInTimeRestore", "Restore",
     "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
     "RestoreLongTermRetentionBackup", and "OnlineSecondary".
    :vartype create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :ivar collation: The collation of the database.
    :vartype collation: str
    :ivar max_size_bytes: The max size of the database expressed in bytes.
    :vartype max_size_bytes: int
    :ivar sample_name: The name of the sample schema to apply when creating this database. Known
     values are: "AdventureWorksLT", "WideWorldImportersStd", and "WideWorldImportersFull".
    :vartype sample_name: str or ~azure.mgmt.sql.models.SampleName
    :ivar elastic_pool_id: The resource identifier of the elastic pool containing this database.
    :vartype elastic_pool_id: str
    :ivar source_database_id: The resource identifier of the source database associated with create
     operation of this database.
    :vartype source_database_id: str
    :ivar status: The status of the database. Known values are: "Online", "Restoring",
     "RecoveryPending", "Recovering", "Suspect", "Offline", "Standby", "Shutdown", "EmergencyMode",
     "AutoClosed", "Copying", "Creating", "Inaccessible", "OfflineSecondary", "Pausing", "Paused",
     "Resuming", "Scaling", "OfflineChangingDwPerformanceTiers", "OnlineChangingDwPerformanceTiers",
     "Disabled", "Stopping", "Stopped", and "Starting".
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar current_service_objective_name: The current service level objective name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level objective name of the
     database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this database belongs to.
    :vartype failover_group_id: str
    :ivar restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar source_database_deletion_date: Specifies the time that the database was deleted.
    :vartype source_database_deletion_date: ~datetime.datetime
    :ivar recovery_services_recovery_point_id: The resource identifier of the recovery point
     associated with create operation of this database.
    :vartype recovery_services_recovery_point_id: str
    :ivar long_term_retention_backup_resource_id: The resource identifier of the long term
     retention backup associated with create operation of this database.
    :vartype long_term_retention_backup_resource_id: str
    :ivar recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :vartype recoverable_database_id: str
    :ivar restorable_dropped_database_id: The resource identifier of the restorable dropped
     database associated with create operation of this database.
    :vartype restorable_dropped_database_id: str
    :ivar catalog_collation: Collation of the metadata catalog. Known values are:
     "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
    :vartype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :ivar zone_redundant: Whether or not this database is zone redundant, which means the replicas
     of this database will be spread across multiple availability zones.
    :vartype zone_redundant: bool
    :ivar license_type: The license type to apply for this database. ``LicenseIncluded`` if you
     need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
     Benefit. Known values are: "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: int
    :ivar earliest_restore_date: This records the earliest start date and time that restore is
     available for this database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar read_scale: The state of read-only routing. If enabled, connections that have application
     intent set to readonly in their connection string may be routed to a readonly secondary replica
     in the same region. Not applicable to a Hyperscale database within an elastic pool. Known
     values are: "Enabled" and "Disabled".
    :vartype read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :ivar high_availability_replica_count: The number of secondary replicas associated with the
     Business Critical, Premium, or Hyperscale edition database that are used to provide high
     availability. Not applicable to a Hyperscale database within an elastic pool.
    :vartype high_availability_replica_count: int
    :ivar secondary_type: The secondary type of the database if it is a secondary.  Valid values
     are Geo, Named and Standby. Known values are: "Geo", "Named", and "Standby".
    :vartype secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :ivar auto_pause_delay: Time in minutes after which database is automatically paused. A value
     of -1 means that automatic pause is disabled.
    :vartype auto_pause_delay: int
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar requested_backup_storage_redundancy: The storage account type to be used to store backups
     for this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar min_capacity: Minimal capacity that database will always have allocated, if not paused.
    :vartype min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration or action(ISO8601
     format). Null if the database is ready.
    :vartype paused_date: ~datetime.datetime
    :ivar resumed_date: The date when database was resumed by user action or database login
     (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: ~datetime.datetime
    :ivar maintenance_configuration_id: Maintenance configuration id assigned to the database. This
     configuration defines the period when the maintenance updates will occur.
    :vartype maintenance_configuration_id: str
    :ivar is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :vartype is_ledger_on: bool
    :ivar is_infra_encryption_enabled: Infra encryption is enabled for this database.
    :vartype is_infra_encryption_enabled: bool
    :ivar federated_client_id: The Client id used for cross tenant per database CMK scenario.
    :vartype federated_client_id: str
    :ivar keys: The resource ids of the user assigned identities to use.
    :vartype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
    :ivar encryption_protector: The azure key vault URI of the database if it's configured with per
     Database Customer Managed Keys.
    :vartype encryption_protector: str
    :ivar preferred_enclave_type: Type of enclave requested on the database i.e. Default or VBS
     enclaves. Known values are: "Default" and "VBS".
    :vartype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
    :ivar use_free_limit: Whether or not the database uses free monthly limits. Allowed on one
     database in a subscription.
    :vartype use_free_limit: bool
    :ivar free_limit_exhaustion_behavior: Specifies the behavior when monthly free limits are
     exhausted for the free database.

     AutoPause: The database will be auto paused upon exhaustion of free limits for remainder of the
     month.

     BillForUsage: The database will continue to be online upon exhaustion of free limits and any
     overage will be billed. Known values are: "AutoPause" and "BillOverUsage".
    :vartype free_limit_exhaustion_behavior: str or
     ~azure.mgmt.sql.models.FreeLimitExhaustionBehavior
    :ivar source_resource_id: The resource identifier of the source associated with the create
     operation of this database.

     This property is only supported for DataWarehouse edition and allows to restore across
     subscriptions.

     When sourceResourceId is specified, sourceDatabaseId, recoverableDatabaseId,
     restorableDroppedDatabaseId and sourceDatabaseDeletionDate must not be specified and CreateMode
     must be PointInTimeRestore, Restore or Recover.

     When createMode is PointInTimeRestore, sourceResourceId must be the resource ID of the existing
     database or existing sql pool, and restorePointInTime must be specified.

     When createMode is Restore, sourceResourceId must be the resource ID of restorable dropped
     database or restorable dropped sql pool.

     When createMode is Recover, sourceResourceId must be the resource ID of recoverable database or
     recoverable sql pool.

     When source subscription belongs to a different tenant than target subscription,
     “x-ms-authorization-auxiliary” header must contain authentication token for the source tenant.
     For more details about “x-ms-authorization-auxiliary” header see
     https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/authenticate-multi-tenant.
    :vartype source_resource_id: str
    :ivar manual_cutover: Whether or not customer controlled manual cutover needs to be done during
     Update Database operation to Hyperscale tier.

     This property is only applicable when scaling database from Business Critical/General
     Purpose/Premium/Standard tier to Hyperscale tier.

     When manualCutover is specified, the scaling operation will wait for user input to trigger
     cutover to Hyperscale database.

     To trigger cutover, please provide 'performCutover' parameter when the Scaling operation is in
     Waiting state.
    :vartype manual_cutover: bool
    :ivar perform_cutover: To trigger customer controlled manual cutover during the wait state
     while Scaling operation is in progress.

     This property parameter is only applicable for scaling operations that are initiated along with
     'manualCutover' parameter.

     This property is only applicable when scaling database from Business Critical/General
     Purpose/Premium/Standard tier to Hyperscale tier is already in progress.

     When performCutover is specified, the scaling operation will trigger cutover and perform
     role-change to Hyperscale database.
    :vartype perform_cutover: bool
    :ivar availability_zone: Specifies the availability zone the database is pinned to. Known
     values are: "NoPreference", "1", "2", and "3".
    :vartype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
    :ivar encryption_protector_auto_rotation: The flag to enable or disable auto rotation of
     database encryption protector AKV key.
    :vartype encryption_protector_auto_rotation: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "kind": {"readonly": True},
        "managed_by": {"readonly": True},
        "status": {"readonly": True},
        "database_id": {"readonly": True},
        "creation_date": {"readonly": True},
        "current_service_objective_name": {"readonly": True},
        "requested_service_objective_name": {"readonly": True},
        "default_secondary_location": {"readonly": True},
        "failover_group_id": {"readonly": True},
        "max_log_size_bytes": {"readonly": True},
        "earliest_restore_date": {"readonly": True},
        "current_sku": {"readonly": True},
        "current_backup_storage_redundancy": {"readonly": True},
        "paused_date": {"readonly": True},
        "resumed_date": {"readonly": True},
        "is_infra_encryption_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "identity": {"key": "identity", "type": "DatabaseIdentity"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "collation": {"key": "properties.collation", "type": "str"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "int"},
        "sample_name": {"key": "properties.sampleName", "type": "str"},
        "elastic_pool_id": {"key": "properties.elasticPoolId", "type": "str"},
        "source_database_id": {"key": "properties.sourceDatabaseId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "database_id": {"key": "properties.databaseId", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "current_service_objective_name": {"key": "properties.currentServiceObjectiveName", "type": "str"},
        "requested_service_objective_name": {"key": "properties.requestedServiceObjectiveName", "type": "str"},
        "default_secondary_location": {"key": "properties.defaultSecondaryLocation", "type": "str"},
        "failover_group_id": {"key": "properties.failoverGroupId", "type": "str"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "source_database_deletion_date": {"key": "properties.sourceDatabaseDeletionDate", "type": "iso-8601"},
        "recovery_services_recovery_point_id": {"key": "properties.recoveryServicesRecoveryPointId", "type": "str"},
        "long_term_retention_backup_resource_id": {
            "key": "properties.longTermRetentionBackupResourceId",
            "type": "str",
        },
        "recoverable_database_id": {"key": "properties.recoverableDatabaseId", "type": "str"},
        "restorable_dropped_database_id": {"key": "properties.restorableDroppedDatabaseId", "type": "str"},
        "catalog_collation": {"key": "properties.catalogCollation", "type": "str"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "max_log_size_bytes": {"key": "properties.maxLogSizeBytes", "type": "int"},
        "earliest_restore_date": {"key": "properties.earliestRestoreDate", "type": "iso-8601"},
        "read_scale": {"key": "properties.readScale", "type": "str"},
        "high_availability_replica_count": {"key": "properties.highAvailabilityReplicaCount", "type": "int"},
        "secondary_type": {"key": "properties.secondaryType", "type": "str"},
        "current_sku": {"key": "properties.currentSku", "type": "Sku"},
        "auto_pause_delay": {"key": "properties.autoPauseDelay", "type": "int"},
        "current_backup_storage_redundancy": {"key": "properties.currentBackupStorageRedundancy", "type": "str"},
        "requested_backup_storage_redundancy": {"key": "properties.requestedBackupStorageRedundancy", "type": "str"},
        "min_capacity": {"key": "properties.minCapacity", "type": "float"},
        "paused_date": {"key": "properties.pausedDate", "type": "iso-8601"},
        "resumed_date": {"key": "properties.resumedDate", "type": "iso-8601"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "is_ledger_on": {"key": "properties.isLedgerOn", "type": "bool"},
        "is_infra_encryption_enabled": {"key": "properties.isInfraEncryptionEnabled", "type": "bool"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
        "keys": {"key": "properties.keys", "type": "{DatabaseKey}"},
        "encryption_protector": {"key": "properties.encryptionProtector", "type": "str"},
        "preferred_enclave_type": {"key": "properties.preferredEnclaveType", "type": "str"},
        "use_free_limit": {"key": "properties.useFreeLimit", "type": "bool"},
        "free_limit_exhaustion_behavior": {"key": "properties.freeLimitExhaustionBehavior", "type": "str"},
        "source_resource_id": {"key": "properties.sourceResourceId", "type": "str"},
        "manual_cutover": {"key": "properties.manualCutover", "type": "bool"},
        "perform_cutover": {"key": "properties.performCutover", "type": "bool"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
        "encryption_protector_auto_rotation": {"key": "properties.encryptionProtectorAutoRotation", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.DatabaseIdentity"] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        collation: Optional[str] = None,
        max_size_bytes: Optional[int] = None,
        sample_name: Optional[Union[str, "_models.SampleName"]] = None,
        elastic_pool_id: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        source_database_deletion_date: Optional[datetime.datetime] = None,
        recovery_services_recovery_point_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        catalog_collation: Optional[Union[str, "_models.CatalogCollationType"]] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DatabaseLicenseType"]] = None,
        read_scale: Optional[Union[str, "_models.DatabaseReadScale"]] = None,
        high_availability_replica_count: Optional[int] = None,
        secondary_type: Optional[Union[str, "_models.SecondaryType"]] = None,
        auto_pause_delay: Optional[int] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        min_capacity: Optional[float] = None,
        maintenance_configuration_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        keys: Optional[Dict[str, "_models.DatabaseKey"]] = None,
        encryption_protector: Optional[str] = None,
        preferred_enclave_type: Optional[Union[str, "_models.AlwaysEncryptedEnclaveType"]] = None,
        use_free_limit: Optional[bool] = None,
        free_limit_exhaustion_behavior: Optional[Union[str, "_models.FreeLimitExhaustionBehavior"]] = None,
        source_resource_id: Optional[str] = None,
        manual_cutover: Optional[bool] = None,
        perform_cutover: Optional[bool] = None,
        availability_zone: Optional[Union[str, "_models.AvailabilityZoneType"]] = None,
        encryption_protector_auto_rotation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The database SKU.

         The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU
         name, tier/edition, family, and capacity) that are available to your subscription in an Azure
         region, use the ``Capabilities_ListByLocation`` REST API or one of the following commands:

         .. code-block:: azurecli

            az sql db list-editions -l <location> -o table
            `

         .. code-block:: powershell

            Get-AzSqlServerServiceObjective -Location <location>
            `.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword identity: The Azure Active Directory identity of the database.
        :paramtype identity: ~azure.mgmt.sql.models.DatabaseIdentity
        :keyword create_mode: Specifies the mode of database creation.

         Default: regular database creation.

         Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
         as the resource ID of the source database.

         Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
         must be specified as the resource ID of the existing primary database.

         PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
         database. sourceDatabaseId must be specified as the resource ID of the existing database, and
         restorePointInTime must be specified.

         Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
         specified as the recoverable database resource ID to restore.

         Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
         be specified. If sourceDatabaseId is the database's original resource ID, then
         sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
         dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
         also be specified to restore from an earlier point in time.

         RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
         vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
         ID.

         Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
         edition. Known values are: "Default", "Copy", "Secondary", "PointInTimeRestore", "Restore",
         "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
         "RestoreLongTermRetentionBackup", and "OnlineSecondary".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.CreateMode
        :keyword collation: The collation of the database.
        :paramtype collation: str
        :keyword max_size_bytes: The max size of the database expressed in bytes.
        :paramtype max_size_bytes: int
        :keyword sample_name: The name of the sample schema to apply when creating this database. Known
         values are: "AdventureWorksLT", "WideWorldImportersStd", and "WideWorldImportersFull".
        :paramtype sample_name: str or ~azure.mgmt.sql.models.SampleName
        :keyword elastic_pool_id: The resource identifier of the elastic pool containing this database.
        :paramtype elastic_pool_id: str
        :keyword source_database_id: The resource identifier of the source database associated with
         create operation of this database.
        :paramtype source_database_id: str
        :keyword restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
         database that will be restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword source_database_deletion_date: Specifies the time that the database was deleted.
        :paramtype source_database_deletion_date: ~datetime.datetime
        :keyword recovery_services_recovery_point_id: The resource identifier of the recovery point
         associated with create operation of this database.
        :paramtype recovery_services_recovery_point_id: str
        :keyword long_term_retention_backup_resource_id: The resource identifier of the long term
         retention backup associated with create operation of this database.
        :paramtype long_term_retention_backup_resource_id: str
        :keyword recoverable_database_id: The resource identifier of the recoverable database
         associated with create operation of this database.
        :paramtype recoverable_database_id: str
        :keyword restorable_dropped_database_id: The resource identifier of the restorable dropped
         database associated with create operation of this database.
        :paramtype restorable_dropped_database_id: str
        :keyword catalog_collation: Collation of the metadata catalog. Known values are:
         "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
        :paramtype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
        :keyword zone_redundant: Whether or not this database is zone redundant, which means the
         replicas of this database will be spread across multiple availability zones.
        :paramtype zone_redundant: bool
        :keyword license_type: The license type to apply for this database. ``LicenseIncluded`` if you
         need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
         Benefit. Known values are: "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
        :keyword read_scale: The state of read-only routing. If enabled, connections that have
         application intent set to readonly in their connection string may be routed to a readonly
         secondary replica in the same region. Not applicable to a Hyperscale database within an elastic
         pool. Known values are: "Enabled" and "Disabled".
        :paramtype read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
        :keyword high_availability_replica_count: The number of secondary replicas associated with the
         Business Critical, Premium, or Hyperscale edition database that are used to provide high
         availability. Not applicable to a Hyperscale database within an elastic pool.
        :paramtype high_availability_replica_count: int
        :keyword secondary_type: The secondary type of the database if it is a secondary.  Valid values
         are Geo, Named and Standby. Known values are: "Geo", "Named", and "Standby".
        :paramtype secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
        :keyword auto_pause_delay: Time in minutes after which database is automatically paused. A
         value of -1 means that automatic pause is disabled.
        :paramtype auto_pause_delay: int
        :keyword requested_backup_storage_redundancy: The storage account type to be used to store
         backups for this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype requested_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        :keyword min_capacity: Minimal capacity that database will always have allocated, if not
         paused.
        :paramtype min_capacity: float
        :keyword maintenance_configuration_id: Maintenance configuration id assigned to the database.
         This configuration defines the period when the maintenance updates will occur.
        :paramtype maintenance_configuration_id: str
        :keyword is_ledger_on: Whether or not this database is a ledger database, which means all
         tables in the database are ledger tables. Note: the value of this property cannot be changed
         after the database has been created.
        :paramtype is_ledger_on: bool
        :keyword federated_client_id: The Client id used for cross tenant per database CMK scenario.
        :paramtype federated_client_id: str
        :keyword keys: The resource ids of the user assigned identities to use.
        :paramtype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
        :keyword encryption_protector: The azure key vault URI of the database if it's configured with
         per Database Customer Managed Keys.
        :paramtype encryption_protector: str
        :keyword preferred_enclave_type: Type of enclave requested on the database i.e. Default or VBS
         enclaves. Known values are: "Default" and "VBS".
        :paramtype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
        :keyword use_free_limit: Whether or not the database uses free monthly limits. Allowed on one
         database in a subscription.
        :paramtype use_free_limit: bool
        :keyword free_limit_exhaustion_behavior: Specifies the behavior when monthly free limits are
         exhausted for the free database.

         AutoPause: The database will be auto paused upon exhaustion of free limits for remainder of the
         month.

         BillForUsage: The database will continue to be online upon exhaustion of free limits and any
         overage will be billed. Known values are: "AutoPause" and "BillOverUsage".
        :paramtype free_limit_exhaustion_behavior: str or
         ~azure.mgmt.sql.models.FreeLimitExhaustionBehavior
        :keyword source_resource_id: The resource identifier of the source associated with the create
         operation of this database.

         This property is only supported for DataWarehouse edition and allows to restore across
         subscriptions.

         When sourceResourceId is specified, sourceDatabaseId, recoverableDatabaseId,
         restorableDroppedDatabaseId and sourceDatabaseDeletionDate must not be specified and CreateMode
         must be PointInTimeRestore, Restore or Recover.

         When createMode is PointInTimeRestore, sourceResourceId must be the resource ID of the existing
         database or existing sql pool, and restorePointInTime must be specified.

         When createMode is Restore, sourceResourceId must be the resource ID of restorable dropped
         database or restorable dropped sql pool.

         When createMode is Recover, sourceResourceId must be the resource ID of recoverable database or
         recoverable sql pool.

         When source subscription belongs to a different tenant than target subscription,
         “x-ms-authorization-auxiliary” header must contain authentication token for the source tenant.
         For more details about “x-ms-authorization-auxiliary” header see
         https://docs.microsoft.com/en-us/azure/azure-resource-manager/management/authenticate-multi-tenant.
        :paramtype source_resource_id: str
        :keyword manual_cutover: Whether or not customer controlled manual cutover needs to be done
         during Update Database operation to Hyperscale tier.

         This property is only applicable when scaling database from Business Critical/General
         Purpose/Premium/Standard tier to Hyperscale tier.

         When manualCutover is specified, the scaling operation will wait for user input to trigger
         cutover to Hyperscale database.

         To trigger cutover, please provide 'performCutover' parameter when the Scaling operation is in
         Waiting state.
        :paramtype manual_cutover: bool
        :keyword perform_cutover: To trigger customer controlled manual cutover during the wait state
         while Scaling operation is in progress.

         This property parameter is only applicable for scaling operations that are initiated along with
         'manualCutover' parameter.

         This property is only applicable when scaling database from Business Critical/General
         Purpose/Premium/Standard tier to Hyperscale tier is already in progress.

         When performCutover is specified, the scaling operation will trigger cutover and perform
         role-change to Hyperscale database.
        :paramtype perform_cutover: bool
        :keyword availability_zone: Specifies the availability zone the database is pinned to. Known
         values are: "NoPreference", "1", "2", and "3".
        :paramtype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
        :keyword encryption_protector_auto_rotation: The flag to enable or disable auto rotation of
         database encryption protector AKV key.
        :paramtype encryption_protector_auto_rotation: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind: Optional[str] = None
        self.managed_by: Optional[str] = None
        self.identity = identity
        self.create_mode = create_mode
        self.collation = collation
        self.max_size_bytes = max_size_bytes
        self.sample_name = sample_name
        self.elastic_pool_id = elastic_pool_id
        self.source_database_id = source_database_id
        self.status: Optional[Union[str, "_models.DatabaseStatus"]] = None
        self.database_id: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.current_service_objective_name: Optional[str] = None
        self.requested_service_objective_name: Optional[str] = None
        self.default_secondary_location: Optional[str] = None
        self.failover_group_id: Optional[str] = None
        self.restore_point_in_time = restore_point_in_time
        self.source_database_deletion_date = source_database_deletion_date
        self.recovery_services_recovery_point_id = recovery_services_recovery_point_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.recoverable_database_id = recoverable_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.catalog_collation = catalog_collation
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.max_log_size_bytes: Optional[int] = None
        self.earliest_restore_date: Optional[datetime.datetime] = None
        self.read_scale = read_scale
        self.high_availability_replica_count = high_availability_replica_count
        self.secondary_type = secondary_type
        self.current_sku: Optional["_models.Sku"] = None
        self.auto_pause_delay = auto_pause_delay
        self.current_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.min_capacity = min_capacity
        self.paused_date: Optional[datetime.datetime] = None
        self.resumed_date: Optional[datetime.datetime] = None
        self.maintenance_configuration_id = maintenance_configuration_id
        self.is_ledger_on = is_ledger_on
        self.is_infra_encryption_enabled: Optional[bool] = None
        self.federated_client_id = federated_client_id
        self.keys = keys
        self.encryption_protector = encryption_protector
        self.preferred_enclave_type = preferred_enclave_type
        self.use_free_limit = use_free_limit
        self.free_limit_exhaustion_behavior = free_limit_exhaustion_behavior
        self.source_resource_id = source_resource_id
        self.manual_cutover = manual_cutover
        self.perform_cutover = perform_cutover
        self.availability_zone = availability_zone
        self.encryption_protector_auto_rotation = encryption_protector_auto_rotation


class DatabaseAdvancedThreatProtection(ProxyResource):
    """A database Advanced Threat Protection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of AdvancedThreatProtectionResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "New", "Enabled", and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "New", "Enabled", and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.creation_time: Optional[datetime.datetime] = None


class DatabaseAdvancedThreatProtectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the database's Advanced Threat Protection configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseAdvancedThreatProtection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseAdvancedThreatProtection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseAdvancedThreatProtection"]] = None
        self.next_link: Optional[str] = None


class DatabaseAutomaticTuning(ProxyResource):
    """Database-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar desired_state: Automatic tuning desired state. Known values are: "Inherit", "Custom",
     "Auto", and "Unspecified".
    :vartype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :ivar actual_state: Automatic tuning actual state. Known values are: "Inherit", "Custom",
     "Auto", and "Unspecified".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
    :ivar options: Automatic tuning options definition.
    :vartype options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningOptions]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "actual_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "desired_state": {"key": "properties.desiredState", "type": "str"},
        "actual_state": {"key": "properties.actualState", "type": "str"},
        "options": {"key": "properties.options", "type": "{AutomaticTuningOptions}"},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "_models.AutomaticTuningMode"]] = None,
        options: Optional[Dict[str, "_models.AutomaticTuningOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword desired_state: Automatic tuning desired state. Known values are: "Inherit", "Custom",
         "Auto", and "Unspecified".
        :paramtype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningMode
        :keyword options: Automatic tuning options definition.
        :paramtype options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningOptions]
        """
        super().__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state: Optional[Union[str, "_models.AutomaticTuningMode"]] = None
        self.options = options


class DatabaseBlobAuditingPolicy(ProxyResource):
    """A database blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :vartype retention_days: int
    :ivar audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:

     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.

     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.

     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     DBCC_GROUP
     DATABASE_OWNERSHIP_CHANGE_GROUP
     DATABASE_CHANGE_GROUP
     LEDGER_OPERATION_GROUP

     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.

     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES

     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}

     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public

     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :vartype audit_actions_and_groups: list[str]
    :ivar is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :vartype is_storage_secondary_key_in_use: bool
    :ivar is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.

     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_azure_monitor_target_enabled: bool
    :ivar queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit
     actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :vartype queue_delay_ms: int
    :ivar is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
     storage.
    :vartype is_managed_identity_in_use: bool
    :ivar state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:


     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :vartype storage_account_access_key: str
    :ivar storage_account_subscription_id: Specifies the blob storage subscription Id.
    :vartype storage_account_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "audit_actions_and_groups": {"key": "properties.auditActionsAndGroups", "type": "[str]"},
        "is_storage_secondary_key_in_use": {"key": "properties.isStorageSecondaryKeyInUse", "type": "bool"},
        "is_azure_monitor_target_enabled": {"key": "properties.isAzureMonitorTargetEnabled", "type": "bool"},
        "queue_delay_ms": {"key": "properties.queueDelayMs", "type": "int"},
        "is_managed_identity_in_use": {"key": "properties.isManagedIdentityInUse", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "storage_account_subscription_id": {"key": "properties.storageAccountSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        is_managed_identity_in_use: Optional[bool] = None,
        state: Optional[Union[str, "_models.BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_days: Specifies the number of days to keep in the audit logs in the storage
         account.
        :paramtype retention_days: int
        :keyword audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

         The recommended set of action groups to use is the following combination - this will audit all
         the queries and stored procedures executed against the database, as well as successful and
         failed logins:

         BATCH_COMPLETED_GROUP,
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
         FAILED_DATABASE_AUTHENTICATION_GROUP.

         This above combination is also the set that is configured by default when enabling auditing
         from the Azure portal.

         The supported action groups to audit are (note: choose only specific groups that cover your
         auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

         APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
         BACKUP_RESTORE_GROUP
         DATABASE_LOGOUT_GROUP
         DATABASE_OBJECT_CHANGE_GROUP
         DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
         DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
         DATABASE_OPERATION_GROUP
         DATABASE_PERMISSION_CHANGE_GROUP
         DATABASE_PRINCIPAL_CHANGE_GROUP
         DATABASE_PRINCIPAL_IMPERSONATION_GROUP
         DATABASE_ROLE_MEMBER_CHANGE_GROUP
         FAILED_DATABASE_AUTHENTICATION_GROUP
         SCHEMA_OBJECT_ACCESS_GROUP
         SCHEMA_OBJECT_CHANGE_GROUP
         SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
         SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
         USER_CHANGE_PASSWORD_GROUP
         BATCH_STARTED_GROUP
         BATCH_COMPLETED_GROUP
         DBCC_GROUP
         DATABASE_OWNERSHIP_CHANGE_GROUP
         DATABASE_CHANGE_GROUP
         LEDGER_OPERATION_GROUP

         These are groups that cover all sql statements and stored procedures executed against the
         database, and should not be used in combination with other groups as this will result in
         duplicate audit logs.

         For more information, see `Database-Level Audit Action Groups
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

         For Database auditing policy, specific Actions can also be specified (note that Actions cannot
         be specified for Server auditing policy). The supported actions to audit are:
         SELECT
         UPDATE
         INSERT
         DELETE
         EXECUTE
         RECEIVE
         REFERENCES

         The general form for defining an action to be audited is:
         {action} ON {object} BY {principal}

         Note that :code:`<object>` in the above format can refer to an object like a table, view, or
         stored procedure, or an entire database or schema. For the latter cases, the forms
         DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

         For example:
         SELECT on dbo.myTable by public
         SELECT on DATABASE::myDatabase by public
         SELECT on SCHEMA::mySchema by public

         For more information, see `Database-Level Audit Actions
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
        :paramtype audit_actions_and_groups: list[str]
        :keyword is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is
         the storage's secondary key.
        :paramtype is_storage_secondary_key_in_use: bool
        :keyword is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
         Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
         'IsAzureMonitorTargetEnabled' as true.

         When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
         diagnostic logs category on the database should be also created.
         Note that for server level audit you should use the 'master' database as {databaseName}.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_azure_monitor_target_enabled: bool
        :keyword queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
         audit actions are forced to be processed.
         The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :paramtype queue_delay_ms: int
        :keyword is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
         storage.
        :paramtype is_managed_identity_in_use: bool
        :keyword state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled is required.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the auditing storage
         account.
         If state is Enabled and storageEndpoint is specified, not specifying the
         storageAccountAccessKey will use SQL server system-assigned managed identity to access the
         storage.
         Prerequisites for using managed identity authentication:


         #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
         #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
         Contributor' RBAC role to the server identity.
            For more information, see `Auditing to storage using Managed Identity authentication
         <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
        :paramtype storage_account_access_key: str
        :keyword storage_account_subscription_id: Specifies the blob storage subscription Id.
        :paramtype storage_account_subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.is_managed_identity_in_use = is_managed_identity_in_use
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class DatabaseBlobAuditingPolicyListResult(_serialization.Model):
    """A list of database auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseBlobAuditingPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseBlobAuditingPolicy"]] = None
        self.next_link: Optional[str] = None


class DatabaseColumn(ProxyResource):
    """A database column resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar column_type: The column data type. Known values are: "image", "text", "uniqueidentifier",
     "date", "time", "datetime2", "datetimeoffset", "tinyint", "smallint", "int", "smalldatetime",
     "real", "money", "datetime", "float", "sql_variant", "ntext", "bit", "decimal", "numeric",
     "smallmoney", "bigint", "hierarchyid", "geometry", "geography", "varbinary", "varchar",
     "binary", "char", "timestamp", "nvarchar", "nchar", "xml", "sysname", and "int".
    :vartype column_type: str or ~azure.mgmt.sql.models.ColumnDataType
    :ivar temporal_type: The table temporal type. Known values are: "NonTemporalTable",
     "HistoryTable", and "SystemVersionedTemporalTable".
    :vartype temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
    :ivar memory_optimized: Whether or not the column belongs to a memory optimized table.
    :vartype memory_optimized: bool
    :ivar is_computed: Whether or not the column is computed.
    :vartype is_computed: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "column_type": {"key": "properties.columnType", "type": "str"},
        "temporal_type": {"key": "properties.temporalType", "type": "str"},
        "memory_optimized": {"key": "properties.memoryOptimized", "type": "bool"},
        "is_computed": {"key": "properties.isComputed", "type": "bool"},
    }

    def __init__(
        self,
        *,
        column_type: Optional[Union[str, "_models.ColumnDataType"]] = None,
        temporal_type: Optional[Union[str, "_models.TableTemporalType"]] = None,
        memory_optimized: Optional[bool] = None,
        is_computed: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword column_type: The column data type. Known values are: "image", "text",
         "uniqueidentifier", "date", "time", "datetime2", "datetimeoffset", "tinyint", "smallint",
         "int", "smalldatetime", "real", "money", "datetime", "float", "sql_variant", "ntext", "bit",
         "decimal", "numeric", "smallmoney", "bigint", "hierarchyid", "geometry", "geography",
         "varbinary", "varchar", "binary", "char", "timestamp", "nvarchar", "nchar", "xml", "sysname",
         and "int".
        :paramtype column_type: str or ~azure.mgmt.sql.models.ColumnDataType
        :keyword temporal_type: The table temporal type. Known values are: "NonTemporalTable",
         "HistoryTable", and "SystemVersionedTemporalTable".
        :paramtype temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
        :keyword memory_optimized: Whether or not the column belongs to a memory optimized table.
        :paramtype memory_optimized: bool
        :keyword is_computed: Whether or not the column is computed.
        :paramtype is_computed: bool
        """
        super().__init__(**kwargs)
        self.column_type = column_type
        self.temporal_type = temporal_type
        self.memory_optimized = memory_optimized
        self.is_computed = is_computed


class DatabaseColumnListResult(_serialization.Model):
    """A list of database columns.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseColumn]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseColumn]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseColumn"]] = None
        self.next_link: Optional[str] = None


class DatabaseExtensions(ProxyResource):
    """An Import, Export, or PolybaseImport resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation_mode: Operation mode of the operation: Import, Export, or PolybaseImport. Known
     values are: "PolybaseImport", "Import", "Export", and "Import".
    :vartype operation_mode: str or ~azure.mgmt.sql.models.OperationMode
    :ivar storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey or ManagedIdentity.
     Known values are: "SharedAccessKey", "StorageAccessKey", and "ManagedIdentity".
    :vartype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :ivar storage_key: Storage key for the storage account. If StorageKeyType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID.
    :vartype storage_key: str
    :ivar storage_uri: Storage Uri for the storage account.
    :vartype storage_uri: str
    :ivar administrator_login: Administrator login name. If AuthenticationType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID.
    :vartype administrator_login: str
    :ivar administrator_login_password: Administrator login password. If AuthenticationType is
     ManagedIdentity, this field should not be specified.
    :vartype administrator_login_password: str
    :ivar authentication_type: Authentication type used to access the SQL: Sql, ADPassword or
     ManagedIdentity.
    :vartype authentication_type: str
    :ivar database_edition: Database edition for the newly created database in the case of an
     import operation.
    :vartype database_edition: str
    :ivar service_objective_name: Database service level objective for the newly created database
     in the case of an import operation.
    :vartype service_objective_name: str
    :ivar max_size_bytes: Database max size in bytes for the newly created database in the case of
     an import operation.
    :vartype max_size_bytes: str
    :ivar network_isolation: Optional resource information to enable network isolation for request.
    :vartype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "operation_mode": {"key": "properties.operationMode", "type": "str"},
        "storage_key_type": {"key": "properties.storageKeyType", "type": "str"},
        "storage_key": {"key": "properties.storageKey", "type": "str"},
        "storage_uri": {"key": "properties.storageUri", "type": "str"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "authentication_type": {"key": "properties.authenticationType", "type": "str"},
        "database_edition": {"key": "properties.databaseEdition", "type": "str"},
        "service_objective_name": {"key": "properties.serviceObjectiveName", "type": "str"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "str"},
        "network_isolation": {"key": "properties.networkIsolation", "type": "NetworkIsolationSettings"},
    }

    def __init__(
        self,
        *,
        operation_mode: Optional[Union[str, "_models.OperationMode"]] = None,
        storage_key_type: Optional[Union[str, "_models.StorageKeyType"]] = None,
        storage_key: Optional[str] = None,
        storage_uri: Optional[str] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        authentication_type: Optional[str] = None,
        database_edition: Optional[str] = None,
        service_objective_name: Optional[str] = None,
        max_size_bytes: Optional[str] = None,
        network_isolation: Optional["_models.NetworkIsolationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_mode: Operation mode of the operation: Import, Export, or PolybaseImport.
         Known values are: "PolybaseImport", "Import", "Export", and "Import".
        :paramtype operation_mode: str or ~azure.mgmt.sql.models.OperationMode
        :keyword storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey or
         ManagedIdentity. Known values are: "SharedAccessKey", "StorageAccessKey", and
         "ManagedIdentity".
        :paramtype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
        :keyword storage_key: Storage key for the storage account. If StorageKeyType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID.
        :paramtype storage_key: str
        :keyword storage_uri: Storage Uri for the storage account.
        :paramtype storage_uri: str
        :keyword administrator_login: Administrator login name. If AuthenticationType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID.
        :paramtype administrator_login: str
        :keyword administrator_login_password: Administrator login password. If AuthenticationType is
         ManagedIdentity, this field should not be specified.
        :paramtype administrator_login_password: str
        :keyword authentication_type: Authentication type used to access the SQL: Sql, ADPassword or
         ManagedIdentity.
        :paramtype authentication_type: str
        :keyword database_edition: Database edition for the newly created database in the case of an
         import operation.
        :paramtype database_edition: str
        :keyword service_objective_name: Database service level objective for the newly created
         database in the case of an import operation.
        :paramtype service_objective_name: str
        :keyword max_size_bytes: Database max size in bytes for the newly created database in the case
         of an import operation.
        :paramtype max_size_bytes: str
        :keyword network_isolation: Optional resource information to enable network isolation for
         request.
        :paramtype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
        """
        super().__init__(**kwargs)
        self.operation_mode = operation_mode
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.database_edition = database_edition
        self.service_objective_name = service_objective_name
        self.max_size_bytes = max_size_bytes
        self.network_isolation = network_isolation


class DatabaseIdentity(_serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The identity type. Known values are: "None" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.sql.models.DatabaseIdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    :ivar user_assigned_identities: The resource ids of the user assigned identities to use.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.sql.models.DatabaseUserIdentity]
    """

    _validation = {
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{DatabaseUserIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.DatabaseIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.DatabaseUserIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Known values are: "None" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.sql.models.DatabaseIdentityType
        :keyword user_assigned_identities: The resource ids of the user assigned identities to use.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.sql.models.DatabaseUserIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.tenant_id: Optional[str] = None
        self.user_assigned_identities = user_assigned_identities


class DatabaseKey(_serialization.Model):
    """Database level key used for encryption at rest.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The database key type. Only supported value is 'AzureKeyVault'. "AzureKeyVault"
    :vartype type: str or ~azure.mgmt.sql.models.DatabaseKeyType
    :ivar thumbprint: Thumbprint of the database key.
    :vartype thumbprint: str
    :ivar creation_date: The database key creation date.
    :vartype creation_date: ~datetime.datetime
    :ivar subregion: Subregion of the server key.
    :vartype subregion: str
    :ivar key_version: The database key's version.
    :vartype key_version: str
    """

    _validation = {
        "type": {"readonly": True},
        "thumbprint": {"readonly": True},
        "creation_date": {"readonly": True},
        "subregion": {"readonly": True},
        "key_version": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "creation_date": {"key": "creationDate", "type": "iso-8601"},
        "subregion": {"key": "subregion", "type": "str"},
        "key_version": {"key": "keyVersion", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.DatabaseKeyType"]] = None
        self.thumbprint: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.subregion: Optional[str] = None
        self.key_version: Optional[str] = None


class DatabaseListResult(_serialization.Model):
    """A list of databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Database]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Database]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Database"]] = None
        self.next_link: Optional[str] = None


class DatabaseOperation(ProxyResource):
    """A database operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_name: The name of the database the operation is being performed on.
    :vartype database_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    :ivar operation_phase_details: The operation phase details.
    :vartype operation_phase_details: ~azure.mgmt.sql.models.PhaseDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "database_name": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "percent_complete": {"readonly": True},
        "server_name": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "is_user_error": {"readonly": True},
        "estimated_completion_time": {"readonly": True},
        "description": {"readonly": True},
        "is_cancellable": {"readonly": True},
        "operation_phase_details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "is_user_error": {"key": "properties.isUserError", "type": "bool"},
        "estimated_completion_time": {"key": "properties.estimatedCompletionTime", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
        "operation_phase_details": {"key": "properties.operationPhaseDetails", "type": "PhaseDetails"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.percent_complete: Optional[int] = None
        self.server_name: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.ManagementOperationState"]] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.is_user_error: Optional[bool] = None
        self.estimated_completion_time: Optional[datetime.datetime] = None
        self.description: Optional[str] = None
        self.is_cancellable: Optional[bool] = None
        self.operation_phase_details: Optional["_models.PhaseDetails"] = None


class DatabaseOperationListResult(_serialization.Model):
    """The response to a list database operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseOperation"]] = None
        self.next_link: Optional[str] = None


class DatabaseSchema(ProxyResource):
    """A database schema resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """


class DatabaseSchemaListResult(_serialization.Model):
    """A list of database schemas.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSchema]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseSchema]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseSchema"]] = None
        self.next_link: Optional[str] = None


class DatabaseSecurityAlertListResult(_serialization.Model):
    """A list of the database's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseSecurityAlertPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseSecurityAlertPolicy"]] = None
        self.next_link: Optional[str] = None


class DatabaseSecurityAlertPolicy(ProxyResource):
    """A database security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :ivar disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :vartype disabled_alerts: list[str]
    :ivar email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :vartype email_addresses: list[str]
    :ivar email_account_admins: Specifies that the alert is sent to the account administrators.
    :vartype email_account_admins: bool
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :vartype storage_account_access_key: str
    :ivar retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :vartype retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "disabled_alerts": {"key": "properties.disabledAlerts", "type": "[str]"},
        "email_addresses": {"key": "properties.emailAddresses", "type": "[str]"},
        "email_account_admins": {"key": "properties.emailAccountAdmins", "type": "bool"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the policy, whether it is enabled or disabled or a
         policy has not been applied yet on the specific database. Known values are: "Enabled" and
         "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
        :keyword disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
         Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
         Brute_Force.
        :paramtype disabled_alerts: list[str]
        :keyword email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
        :paramtype email_addresses: list[str]
        :keyword email_account_admins: Specifies that the alert is sent to the account administrators.
        :paramtype email_account_admins: bool
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
         audit logs.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the Threat Detection audit
         storage account.
        :paramtype storage_account_access_key: str
        :keyword retention_days: Specifies the number of days to keep in the Threat Detection audit
         logs.
        :paramtype retention_days: int
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time: Optional[datetime.datetime] = None


class DatabaseSqlVulnerabilityAssessmentBaselineSet(ProxyResource):  # pylint: disable=name-too-long
    """A database sql vulnerability assessment baseline set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of DatabaseSqlVulnerabilityAssessmentBaselineSetResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar results: The baseline set result.
    :vartype results: dict[str, list[list[str]]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "results": {"key": "properties.results", "type": "{[[str]]}"},
    }

    def __init__(self, *, results: Optional[Dict[str, List[List[str]]]] = None, **kwargs: Any) -> None:
        """
        :keyword results: The baseline set result.
        :paramtype results: dict[str, list[list[str]]]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.results = results


class DatabaseSqlVulnerabilityAssessmentBaselineSetListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of SQL Vulnerability Assessments baseline set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentBaselineSet]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseSqlVulnerabilityAssessmentBaselineSet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseSqlVulnerabilityAssessmentBaselineSet"]] = None
        self.next_link: Optional[str] = None


class DatabaseSqlVulnerabilityAssessmentRuleBaseline(ProxyResource):  # pylint: disable=name-too-long
    """A database sql vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar results: The rule baseline result.
    :vartype results: list[list[str]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "results": {"key": "properties.results", "type": "[[str]]"},
    }

    def __init__(self, *, results: Optional[List[List[str]]] = None, **kwargs: Any) -> None:
        """
        :keyword results: The rule baseline result.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.results = results


class DatabaseSqlVulnerabilityAssessmentRuleBaselineInput(ProxyResource):  # pylint: disable=name-too-long
    """A database sql vulnerability assessment rule baseline input.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineInputResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar latest_scan: The latest scan flag.
    :vartype latest_scan: bool
    :ivar results: The rule baseline result.
    :vartype results: list[list[str]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "latest_scan": {"key": "properties.latestScan", "type": "bool"},
        "results": {"key": "properties.results", "type": "[[str]]"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[List[List[str]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: The latest scan flag.
        :paramtype latest_scan: bool
        :keyword results: The rule baseline result.
        :paramtype results: list[list[str]]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.latest_scan = latest_scan
        self.results = results


class DatabaseSqlVulnerabilityAssessmentRuleBaselineListInput(ProxyResource):  # pylint: disable=name-too-long
    """A database sql vulnerability assessment rule baseline list input.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of
     DatabaseSqlVulnerabilityAssessmentRuleBaselineListInputResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar latest_scan: The latest scan flag.
    :vartype latest_scan: bool
    :ivar results: The rule baseline result list.
    :vartype results: dict[str, list[list[str]]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "latest_scan": {"key": "properties.latestScan", "type": "bool"},
        "results": {"key": "properties.results", "type": "{[[str]]}"},
    }

    def __init__(
        self, *, latest_scan: Optional[bool] = None, results: Optional[Dict[str, List[List[str]]]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword latest_scan: The latest scan flag.
        :paramtype latest_scan: bool
        :keyword results: The rule baseline result list.
        :paramtype results: dict[str, list[list[str]]]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.latest_scan = latest_scan
        self.results = results


class DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of SQL Vulnerability Assessments rule baseline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseSqlVulnerabilityAssessmentRuleBaseline]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseSqlVulnerabilityAssessmentRuleBaseline]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseSqlVulnerabilityAssessmentRuleBaseline"]] = None
        self.next_link: Optional[str] = None


class DatabaseTable(ProxyResource):
    """A database table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar temporal_type: The table temporal type. Known values are: "NonTemporalTable",
     "HistoryTable", and "SystemVersionedTemporalTable".
    :vartype temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
    :ivar memory_optimized: Whether or not the table is memory optimized.
    :vartype memory_optimized: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "temporal_type": {"key": "properties.temporalType", "type": "str"},
        "memory_optimized": {"key": "properties.memoryOptimized", "type": "bool"},
    }

    def __init__(
        self,
        *,
        temporal_type: Optional[Union[str, "_models.TableTemporalType"]] = None,
        memory_optimized: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword temporal_type: The table temporal type. Known values are: "NonTemporalTable",
         "HistoryTable", and "SystemVersionedTemporalTable".
        :paramtype temporal_type: str or ~azure.mgmt.sql.models.TableTemporalType
        :keyword memory_optimized: Whether or not the table is memory optimized.
        :paramtype memory_optimized: bool
        """
        super().__init__(**kwargs)
        self.temporal_type = temporal_type
        self.memory_optimized = memory_optimized


class DatabaseTableListResult(_serialization.Model):
    """A list of database tables.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseTable]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseTable"]] = None
        self.next_link: Optional[str] = None


class DatabaseUpdate(_serialization.Model):
    """A database update resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar identity: Database identity.
    :vartype identity: ~azure.mgmt.sql.models.DatabaseIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar create_mode: Specifies the mode of database creation.

     Default: regular database creation.

     Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
     as the resource ID of the source database.

     Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
     must be specified as the resource ID of the existing primary database.

     PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
     database. sourceDatabaseId must be specified as the resource ID of the existing database, and
     restorePointInTime must be specified.

     Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
     specified as the recoverable database resource ID to restore.

     Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
     be specified. If sourceDatabaseId is the database's original resource ID, then
     sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
     dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
     also be specified to restore from an earlier point in time.

     RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
     vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
     ID.

     Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
     edition. Known values are: "Default", "Copy", "Secondary", "PointInTimeRestore", "Restore",
     "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
     "RestoreLongTermRetentionBackup", and "OnlineSecondary".
    :vartype create_mode: str or ~azure.mgmt.sql.models.CreateMode
    :ivar collation: The collation of the database.
    :vartype collation: str
    :ivar max_size_bytes: The max size of the database expressed in bytes.
    :vartype max_size_bytes: int
    :ivar sample_name: The name of the sample schema to apply when creating this database. Known
     values are: "AdventureWorksLT", "WideWorldImportersStd", and "WideWorldImportersFull".
    :vartype sample_name: str or ~azure.mgmt.sql.models.SampleName
    :ivar elastic_pool_id: The resource identifier of the elastic pool containing this database.
    :vartype elastic_pool_id: str
    :ivar source_database_id: The resource identifier of the source database associated with create
     operation of this database.
    :vartype source_database_id: str
    :ivar status: The status of the database. Known values are: "Online", "Restoring",
     "RecoveryPending", "Recovering", "Suspect", "Offline", "Standby", "Shutdown", "EmergencyMode",
     "AutoClosed", "Copying", "Creating", "Inaccessible", "OfflineSecondary", "Pausing", "Paused",
     "Resuming", "Scaling", "OfflineChangingDwPerformanceTiers", "OnlineChangingDwPerformanceTiers",
     "Disabled", "Stopping", "Stopped", and "Starting".
    :vartype status: str or ~azure.mgmt.sql.models.DatabaseStatus
    :ivar database_id: The ID of the database.
    :vartype database_id: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar current_service_objective_name: The current service level objective name of the database.
    :vartype current_service_objective_name: str
    :ivar requested_service_objective_name: The requested service level objective name of the
     database.
    :vartype requested_service_objective_name: str
    :ivar default_secondary_location: The default secondary region for this database.
    :vartype default_secondary_location: str
    :ivar failover_group_id: Failover Group resource identifier that this database belongs to.
    :vartype failover_group_id: str
    :ivar restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar source_database_deletion_date: Specifies the time that the database was deleted.
    :vartype source_database_deletion_date: ~datetime.datetime
    :ivar recovery_services_recovery_point_id: The resource identifier of the recovery point
     associated with create operation of this database.
    :vartype recovery_services_recovery_point_id: str
    :ivar long_term_retention_backup_resource_id: The resource identifier of the long term
     retention backup associated with create operation of this database.
    :vartype long_term_retention_backup_resource_id: str
    :ivar recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :vartype recoverable_database_id: str
    :ivar restorable_dropped_database_id: The resource identifier of the restorable dropped
     database associated with create operation of this database.
    :vartype restorable_dropped_database_id: str
    :ivar catalog_collation: Collation of the metadata catalog. Known values are:
     "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
    :vartype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :ivar zone_redundant: Whether or not this database is zone redundant, which means the replicas
     of this database will be spread across multiple availability zones.
    :vartype zone_redundant: bool
    :ivar license_type: The license type to apply for this database. ``LicenseIncluded`` if you
     need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
     Benefit. Known values are: "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
    :ivar max_log_size_bytes: The max log size for this database.
    :vartype max_log_size_bytes: int
    :ivar earliest_restore_date: This records the earliest start date and time that restore is
     available for this database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar read_scale: The state of read-only routing. If enabled, connections that have application
     intent set to readonly in their connection string may be routed to a readonly secondary replica
     in the same region. Not applicable to a Hyperscale database within an elastic pool. Known
     values are: "Enabled" and "Disabled".
    :vartype read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
    :ivar high_availability_replica_count: The number of secondary replicas associated with the
     Business Critical, Premium, or Hyperscale edition database that are used to provide high
     availability. Not applicable to a Hyperscale database within an elastic pool.
    :vartype high_availability_replica_count: int
    :ivar secondary_type: The secondary type of the database if it is a secondary.  Valid values
     are Geo, Named and Standby. Known values are: "Geo", "Named", and "Standby".
    :vartype secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
    :ivar current_sku: The name and tier of the SKU.
    :vartype current_sku: ~azure.mgmt.sql.models.Sku
    :ivar auto_pause_delay: Time in minutes after which database is automatically paused. A value
     of -1 means that automatic pause is disabled.
    :vartype auto_pause_delay: int
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar requested_backup_storage_redundancy: The storage account type to be used to store backups
     for this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar min_capacity: Minimal capacity that database will always have allocated, if not paused.
    :vartype min_capacity: float
    :ivar paused_date: The date when database was paused by user configuration or action(ISO8601
     format). Null if the database is ready.
    :vartype paused_date: ~datetime.datetime
    :ivar resumed_date: The date when database was resumed by user action or database login
     (ISO8601 format). Null if the database is paused.
    :vartype resumed_date: ~datetime.datetime
    :ivar maintenance_configuration_id: Maintenance configuration id assigned to the database. This
     configuration defines the period when the maintenance updates will occur.
    :vartype maintenance_configuration_id: str
    :ivar is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :vartype is_ledger_on: bool
    :ivar is_infra_encryption_enabled: Infra encryption is enabled for this database.
    :vartype is_infra_encryption_enabled: bool
    :ivar federated_client_id: The Client id used for cross tenant per database CMK scenario.
    :vartype federated_client_id: str
    :ivar keys: The resource ids of the user assigned identities to use.
    :vartype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
    :ivar encryption_protector: The azure key vault URI of the database if it's configured with per
     Database Customer Managed Keys.
    :vartype encryption_protector: str
    :ivar preferred_enclave_type: Type of enclave requested on the database i.e. Default or VBS
     enclaves. Known values are: "Default" and "VBS".
    :vartype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
    :ivar use_free_limit: Whether or not the database uses free monthly limits. Allowed on one
     database in a subscription.
    :vartype use_free_limit: bool
    :ivar free_limit_exhaustion_behavior: Specifies the behavior when monthly free limits are
     exhausted for the free database.

     AutoPause: The database will be auto paused upon exhaustion of free limits for remainder of the
     month.

     BillForUsage: The database will continue to be online upon exhaustion of free limits and any
     overage will be billed. Known values are: "AutoPause" and "BillOverUsage".
    :vartype free_limit_exhaustion_behavior: str or
     ~azure.mgmt.sql.models.FreeLimitExhaustionBehavior
    :ivar manual_cutover: Whether or not customer controlled manual cutover needs to be done during
     Update Database operation to Hyperscale tier.

     This property is only applicable when scaling database from Business Critical/General
     Purpose/Premium/Standard tier to Hyperscale tier.

     When manualCutover is specified, the scaling operation will wait for user input to trigger
     cutover to Hyperscale database.

     To trigger cutover, please provide 'performCutover' parameter when the Scaling operation is in
     Waiting state.
    :vartype manual_cutover: bool
    :ivar perform_cutover: To trigger customer controlled manual cutover during the wait state
     while Scaling operation is in progress.

     This property parameter is only applicable for scaling operations that are initiated along with
     'manualCutover' parameter.

     This property is only applicable when scaling database from Business Critical/General
     Purpose/Premium/Standard tier to Hyperscale tier is already in progress.

     When performCutover is specified, the scaling operation will trigger cutover and perform
     role-change to Hyperscale database.
    :vartype perform_cutover: bool
    :ivar encryption_protector_auto_rotation: The flag to enable or disable auto rotation of
     database encryption protector AKV key.
    :vartype encryption_protector_auto_rotation: bool
    """

    _validation = {
        "status": {"readonly": True},
        "database_id": {"readonly": True},
        "creation_date": {"readonly": True},
        "current_service_objective_name": {"readonly": True},
        "requested_service_objective_name": {"readonly": True},
        "default_secondary_location": {"readonly": True},
        "failover_group_id": {"readonly": True},
        "max_log_size_bytes": {"readonly": True},
        "earliest_restore_date": {"readonly": True},
        "current_sku": {"readonly": True},
        "current_backup_storage_redundancy": {"readonly": True},
        "paused_date": {"readonly": True},
        "resumed_date": {"readonly": True},
        "is_infra_encryption_enabled": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "DatabaseIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "collation": {"key": "properties.collation", "type": "str"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "int"},
        "sample_name": {"key": "properties.sampleName", "type": "str"},
        "elastic_pool_id": {"key": "properties.elasticPoolId", "type": "str"},
        "source_database_id": {"key": "properties.sourceDatabaseId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "database_id": {"key": "properties.databaseId", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "current_service_objective_name": {"key": "properties.currentServiceObjectiveName", "type": "str"},
        "requested_service_objective_name": {"key": "properties.requestedServiceObjectiveName", "type": "str"},
        "default_secondary_location": {"key": "properties.defaultSecondaryLocation", "type": "str"},
        "failover_group_id": {"key": "properties.failoverGroupId", "type": "str"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "source_database_deletion_date": {"key": "properties.sourceDatabaseDeletionDate", "type": "iso-8601"},
        "recovery_services_recovery_point_id": {"key": "properties.recoveryServicesRecoveryPointId", "type": "str"},
        "long_term_retention_backup_resource_id": {
            "key": "properties.longTermRetentionBackupResourceId",
            "type": "str",
        },
        "recoverable_database_id": {"key": "properties.recoverableDatabaseId", "type": "str"},
        "restorable_dropped_database_id": {"key": "properties.restorableDroppedDatabaseId", "type": "str"},
        "catalog_collation": {"key": "properties.catalogCollation", "type": "str"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "max_log_size_bytes": {"key": "properties.maxLogSizeBytes", "type": "int"},
        "earliest_restore_date": {"key": "properties.earliestRestoreDate", "type": "iso-8601"},
        "read_scale": {"key": "properties.readScale", "type": "str"},
        "high_availability_replica_count": {"key": "properties.highAvailabilityReplicaCount", "type": "int"},
        "secondary_type": {"key": "properties.secondaryType", "type": "str"},
        "current_sku": {"key": "properties.currentSku", "type": "Sku"},
        "auto_pause_delay": {"key": "properties.autoPauseDelay", "type": "int"},
        "current_backup_storage_redundancy": {"key": "properties.currentBackupStorageRedundancy", "type": "str"},
        "requested_backup_storage_redundancy": {"key": "properties.requestedBackupStorageRedundancy", "type": "str"},
        "min_capacity": {"key": "properties.minCapacity", "type": "float"},
        "paused_date": {"key": "properties.pausedDate", "type": "iso-8601"},
        "resumed_date": {"key": "properties.resumedDate", "type": "iso-8601"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "is_ledger_on": {"key": "properties.isLedgerOn", "type": "bool"},
        "is_infra_encryption_enabled": {"key": "properties.isInfraEncryptionEnabled", "type": "bool"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
        "keys": {"key": "properties.keys", "type": "{DatabaseKey}"},
        "encryption_protector": {"key": "properties.encryptionProtector", "type": "str"},
        "preferred_enclave_type": {"key": "properties.preferredEnclaveType", "type": "str"},
        "use_free_limit": {"key": "properties.useFreeLimit", "type": "bool"},
        "free_limit_exhaustion_behavior": {"key": "properties.freeLimitExhaustionBehavior", "type": "str"},
        "manual_cutover": {"key": "properties.manualCutover", "type": "bool"},
        "perform_cutover": {"key": "properties.performCutover", "type": "bool"},
        "encryption_protector_auto_rotation": {"key": "properties.encryptionProtectorAutoRotation", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.DatabaseIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        collation: Optional[str] = None,
        max_size_bytes: Optional[int] = None,
        sample_name: Optional[Union[str, "_models.SampleName"]] = None,
        elastic_pool_id: Optional[str] = None,
        source_database_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        source_database_deletion_date: Optional[datetime.datetime] = None,
        recovery_services_recovery_point_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        catalog_collation: Optional[Union[str, "_models.CatalogCollationType"]] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.DatabaseLicenseType"]] = None,
        read_scale: Optional[Union[str, "_models.DatabaseReadScale"]] = None,
        high_availability_replica_count: Optional[int] = None,
        secondary_type: Optional[Union[str, "_models.SecondaryType"]] = None,
        auto_pause_delay: Optional[int] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        min_capacity: Optional[float] = None,
        maintenance_configuration_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        federated_client_id: Optional[str] = None,
        keys: Optional[Dict[str, "_models.DatabaseKey"]] = None,
        encryption_protector: Optional[str] = None,
        preferred_enclave_type: Optional[Union[str, "_models.AlwaysEncryptedEnclaveType"]] = None,
        use_free_limit: Optional[bool] = None,
        free_limit_exhaustion_behavior: Optional[Union[str, "_models.FreeLimitExhaustionBehavior"]] = None,
        manual_cutover: Optional[bool] = None,
        perform_cutover: Optional[bool] = None,
        encryption_protector_auto_rotation: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword identity: Database identity.
        :paramtype identity: ~azure.mgmt.sql.models.DatabaseIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword create_mode: Specifies the mode of database creation.

         Default: regular database creation.

         Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified
         as the resource ID of the source database.

         Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId
         must be specified as the resource ID of the existing primary database.

         PointInTimeRestore: Creates a database by restoring a point in time backup of an existing
         database. sourceDatabaseId must be specified as the resource ID of the existing database, and
         restorePointInTime must be specified.

         Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be
         specified as the recoverable database resource ID to restore.

         Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must
         be specified. If sourceDatabaseId is the database's original resource ID, then
         sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable
         dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may
         also be specified to restore from an earlier point in time.

         RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention
         vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource
         ID.

         Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse
         edition. Known values are: "Default", "Copy", "Secondary", "PointInTimeRestore", "Restore",
         "Recovery", "RestoreExternalBackup", "RestoreExternalBackupSecondary",
         "RestoreLongTermRetentionBackup", and "OnlineSecondary".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.CreateMode
        :keyword collation: The collation of the database.
        :paramtype collation: str
        :keyword max_size_bytes: The max size of the database expressed in bytes.
        :paramtype max_size_bytes: int
        :keyword sample_name: The name of the sample schema to apply when creating this database. Known
         values are: "AdventureWorksLT", "WideWorldImportersStd", and "WideWorldImportersFull".
        :paramtype sample_name: str or ~azure.mgmt.sql.models.SampleName
        :keyword elastic_pool_id: The resource identifier of the elastic pool containing this database.
        :paramtype elastic_pool_id: str
        :keyword source_database_id: The resource identifier of the source database associated with
         create operation of this database.
        :paramtype source_database_id: str
        :keyword restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
         database that will be restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword source_database_deletion_date: Specifies the time that the database was deleted.
        :paramtype source_database_deletion_date: ~datetime.datetime
        :keyword recovery_services_recovery_point_id: The resource identifier of the recovery point
         associated with create operation of this database.
        :paramtype recovery_services_recovery_point_id: str
        :keyword long_term_retention_backup_resource_id: The resource identifier of the long term
         retention backup associated with create operation of this database.
        :paramtype long_term_retention_backup_resource_id: str
        :keyword recoverable_database_id: The resource identifier of the recoverable database
         associated with create operation of this database.
        :paramtype recoverable_database_id: str
        :keyword restorable_dropped_database_id: The resource identifier of the restorable dropped
         database associated with create operation of this database.
        :paramtype restorable_dropped_database_id: str
        :keyword catalog_collation: Collation of the metadata catalog. Known values are:
         "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
        :paramtype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
        :keyword zone_redundant: Whether or not this database is zone redundant, which means the
         replicas of this database will be spread across multiple availability zones.
        :paramtype zone_redundant: bool
        :keyword license_type: The license type to apply for this database. ``LicenseIncluded`` if you
         need a license, or ``BasePrice`` if you have a license and are eligible for the Azure Hybrid
         Benefit. Known values are: "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.DatabaseLicenseType
        :keyword read_scale: The state of read-only routing. If enabled, connections that have
         application intent set to readonly in their connection string may be routed to a readonly
         secondary replica in the same region. Not applicable to a Hyperscale database within an elastic
         pool. Known values are: "Enabled" and "Disabled".
        :paramtype read_scale: str or ~azure.mgmt.sql.models.DatabaseReadScale
        :keyword high_availability_replica_count: The number of secondary replicas associated with the
         Business Critical, Premium, or Hyperscale edition database that are used to provide high
         availability. Not applicable to a Hyperscale database within an elastic pool.
        :paramtype high_availability_replica_count: int
        :keyword secondary_type: The secondary type of the database if it is a secondary.  Valid values
         are Geo, Named and Standby. Known values are: "Geo", "Named", and "Standby".
        :paramtype secondary_type: str or ~azure.mgmt.sql.models.SecondaryType
        :keyword auto_pause_delay: Time in minutes after which database is automatically paused. A
         value of -1 means that automatic pause is disabled.
        :paramtype auto_pause_delay: int
        :keyword requested_backup_storage_redundancy: The storage account type to be used to store
         backups for this database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype requested_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        :keyword min_capacity: Minimal capacity that database will always have allocated, if not
         paused.
        :paramtype min_capacity: float
        :keyword maintenance_configuration_id: Maintenance configuration id assigned to the database.
         This configuration defines the period when the maintenance updates will occur.
        :paramtype maintenance_configuration_id: str
        :keyword is_ledger_on: Whether or not this database is a ledger database, which means all
         tables in the database are ledger tables. Note: the value of this property cannot be changed
         after the database has been created.
        :paramtype is_ledger_on: bool
        :keyword federated_client_id: The Client id used for cross tenant per database CMK scenario.
        :paramtype federated_client_id: str
        :keyword keys: The resource ids of the user assigned identities to use.
        :paramtype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
        :keyword encryption_protector: The azure key vault URI of the database if it's configured with
         per Database Customer Managed Keys.
        :paramtype encryption_protector: str
        :keyword preferred_enclave_type: Type of enclave requested on the database i.e. Default or VBS
         enclaves. Known values are: "Default" and "VBS".
        :paramtype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
        :keyword use_free_limit: Whether or not the database uses free monthly limits. Allowed on one
         database in a subscription.
        :paramtype use_free_limit: bool
        :keyword free_limit_exhaustion_behavior: Specifies the behavior when monthly free limits are
         exhausted for the free database.

         AutoPause: The database will be auto paused upon exhaustion of free limits for remainder of the
         month.

         BillForUsage: The database will continue to be online upon exhaustion of free limits and any
         overage will be billed. Known values are: "AutoPause" and "BillOverUsage".
        :paramtype free_limit_exhaustion_behavior: str or
         ~azure.mgmt.sql.models.FreeLimitExhaustionBehavior
        :keyword manual_cutover: Whether or not customer controlled manual cutover needs to be done
         during Update Database operation to Hyperscale tier.

         This property is only applicable when scaling database from Business Critical/General
         Purpose/Premium/Standard tier to Hyperscale tier.

         When manualCutover is specified, the scaling operation will wait for user input to trigger
         cutover to Hyperscale database.

         To trigger cutover, please provide 'performCutover' parameter when the Scaling operation is in
         Waiting state.
        :paramtype manual_cutover: bool
        :keyword perform_cutover: To trigger customer controlled manual cutover during the wait state
         while Scaling operation is in progress.

         This property parameter is only applicable for scaling operations that are initiated along with
         'manualCutover' parameter.

         This property is only applicable when scaling database from Business Critical/General
         Purpose/Premium/Standard tier to Hyperscale tier is already in progress.

         When performCutover is specified, the scaling operation will trigger cutover and perform
         role-change to Hyperscale database.
        :paramtype perform_cutover: bool
        :keyword encryption_protector_auto_rotation: The flag to enable or disable auto rotation of
         database encryption protector AKV key.
        :paramtype encryption_protector_auto_rotation: bool
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.identity = identity
        self.tags = tags
        self.create_mode = create_mode
        self.collation = collation
        self.max_size_bytes = max_size_bytes
        self.sample_name = sample_name
        self.elastic_pool_id = elastic_pool_id
        self.source_database_id = source_database_id
        self.status: Optional[Union[str, "_models.DatabaseStatus"]] = None
        self.database_id: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.current_service_objective_name: Optional[str] = None
        self.requested_service_objective_name: Optional[str] = None
        self.default_secondary_location: Optional[str] = None
        self.failover_group_id: Optional[str] = None
        self.restore_point_in_time = restore_point_in_time
        self.source_database_deletion_date = source_database_deletion_date
        self.recovery_services_recovery_point_id = recovery_services_recovery_point_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.recoverable_database_id = recoverable_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.catalog_collation = catalog_collation
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.max_log_size_bytes: Optional[int] = None
        self.earliest_restore_date: Optional[datetime.datetime] = None
        self.read_scale = read_scale
        self.high_availability_replica_count = high_availability_replica_count
        self.secondary_type = secondary_type
        self.current_sku: Optional["_models.Sku"] = None
        self.auto_pause_delay = auto_pause_delay
        self.current_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.min_capacity = min_capacity
        self.paused_date: Optional[datetime.datetime] = None
        self.resumed_date: Optional[datetime.datetime] = None
        self.maintenance_configuration_id = maintenance_configuration_id
        self.is_ledger_on = is_ledger_on
        self.is_infra_encryption_enabled: Optional[bool] = None
        self.federated_client_id = federated_client_id
        self.keys = keys
        self.encryption_protector = encryption_protector
        self.preferred_enclave_type = preferred_enclave_type
        self.use_free_limit = use_free_limit
        self.free_limit_exhaustion_behavior = free_limit_exhaustion_behavior
        self.manual_cutover = manual_cutover
        self.perform_cutover = perform_cutover
        self.encryption_protector_auto_rotation = encryption_protector_auto_rotation


class DatabaseUsage(ProxyResource):
    """Usage metric of a database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "float"},
        "limit": {"key": "properties.limit", "type": "float"},
        "unit": {"key": "properties.unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.current_value: Optional[float] = None
        self.limit: Optional[float] = None
        self.unit: Optional[str] = None


class DatabaseUsageListResult(_serialization.Model):
    """A list of database usage metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseUsage"]] = None
        self.next_link: Optional[str] = None


class DatabaseUserIdentity(_serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :ivar client_id: The Azure Active Directory client id.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class DatabaseVulnerabilityAssessment(ProxyResource):
    """A database vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level
     vulnerability assessment policy doesn't set.
    :vartype storage_container_path: str
    :ivar storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not
     behind a Vnet or a firewall.
    :vartype storage_container_sas_key: str
    :ivar storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
     or a firewall.
    :vartype storage_account_access_key: str
    :ivar recurring_scans: The recurring scans settings.
    :vartype recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_container_path": {"key": "properties.storageContainerPath", "type": "str"},
        "storage_container_sas_key": {"key": "properties.storageContainerSasKey", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "recurring_scans": {
            "key": "properties.recurringScans",
            "type": "VulnerabilityAssessmentRecurringScansProperties",
        },
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["_models.VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_container_path: A blob storage container path to hold the scan results (e.g.
         https://myStorage.blob.core.windows.net/VaScans/).  It is required if server level
         vulnerability assessment policy doesn't set.
        :paramtype storage_container_path: str
        :keyword storage_container_sas_key: A shared access signature (SAS Key) that has write access
         to the blob container specified in 'storageContainerPath' parameter. If
         'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if
         the storage account is not behind a Vnet or a firewall.
        :paramtype storage_container_sas_key: str
        :keyword storage_account_access_key: Specifies the identifier key of the storage account for
         vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
         storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
         or a firewall.
        :paramtype storage_account_access_key: str
        :keyword recurring_scans: The recurring scans settings.
        :paramtype recurring_scans:
         ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
        """
        super().__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class DatabaseVulnerabilityAssessmentListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the database's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DatabaseVulnerabilityAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DatabaseVulnerabilityAssessment"]] = None
        self.next_link: Optional[str] = None


class DatabaseVulnerabilityAssessmentRuleBaseline(ProxyResource):  # pylint: disable=name-too-long
    """A database vulnerability assessment rule baseline.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar baseline_results: The rule baseline result.
    :vartype baseline_results:
     list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "baseline_results": {
            "key": "properties.baselineResults",
            "type": "[DatabaseVulnerabilityAssessmentRuleBaselineItem]",
        },
    }

    def __init__(
        self,
        *,
        baseline_results: Optional[List["_models.DatabaseVulnerabilityAssessmentRuleBaselineItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword baseline_results: The rule baseline result.
        :paramtype baseline_results:
         list[~azure.mgmt.sql.models.DatabaseVulnerabilityAssessmentRuleBaselineItem]
        """
        super().__init__(**kwargs)
        self.baseline_results = baseline_results


class DatabaseVulnerabilityAssessmentRuleBaselineItem(_serialization.Model):  # pylint: disable=name-too-long
    """Properties for an Azure SQL Database Vulnerability Assessment rule baseline's result.

    All required parameters must be populated in order to send to server.

    :ivar result: The rule baseline result. Required.
    :vartype result: list[str]
    """

    _validation = {
        "result": {"required": True},
    }

    _attribute_map = {
        "result": {"key": "result", "type": "[str]"},
    }

    def __init__(self, *, result: List[str], **kwargs: Any) -> None:
        """
        :keyword result: The rule baseline result. Required.
        :paramtype result: list[str]
        """
        super().__init__(**kwargs)
        self.result = result


class DatabaseVulnerabilityAssessmentScansExport(ProxyResource):  # pylint: disable=name-too-long
    """A database Vulnerability Assessment scan export resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar exported_report_location: Location of the exported report (e.g.
     https://myStorage.blob.core.windows.net/VaScans/scans/serverName/databaseName/scan_scanId.xlsx).
    :vartype exported_report_location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "exported_report_location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "exported_report_location": {"key": "properties.exportedReportLocation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.exported_report_location: Optional[str] = None


class DataMaskingPolicy(ProxyResource):
    """A database data masking policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The location of the data masking policy.
    :vartype location: str
    :ivar kind: The kind of Data Masking Policy. Metadata, used for Azure portal.
    :vartype kind: str
    :ivar data_masking_state: The state of the data masking policy. Known values are: "Enabled" and
     "Disabled".
    :vartype data_masking_state: str or ~azure.mgmt.sql.models.DataMaskingState
    :ivar exempt_principals: The list of the exempt principals. Specifies the semicolon-separated
     list of database users for which the data masking policy does not apply. The specified users
     receive data results without masking for all of the database queries.
    :vartype exempt_principals: str
    :ivar application_principals: The list of the application principals. This is a legacy
     parameter and is no longer used.
    :vartype application_principals: str
    :ivar masking_level: The masking level. This is a legacy parameter and is no longer used.
    :vartype masking_level: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "kind": {"readonly": True},
        "application_principals": {"readonly": True},
        "masking_level": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_masking_state": {"key": "properties.dataMaskingState", "type": "str"},
        "exempt_principals": {"key": "properties.exemptPrincipals", "type": "str"},
        "application_principals": {"key": "properties.applicationPrincipals", "type": "str"},
        "masking_level": {"key": "properties.maskingLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_masking_state: Optional[Union[str, "_models.DataMaskingState"]] = None,
        exempt_principals: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_masking_state: The state of the data masking policy. Known values are: "Enabled"
         and "Disabled".
        :paramtype data_masking_state: str or ~azure.mgmt.sql.models.DataMaskingState
        :keyword exempt_principals: The list of the exempt principals. Specifies the
         semicolon-separated list of database users for which the data masking policy does not apply.
         The specified users receive data results without masking for all of the database queries.
        :paramtype exempt_principals: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.kind: Optional[str] = None
        self.data_masking_state = data_masking_state
        self.exempt_principals = exempt_principals
        self.application_principals: Optional[str] = None
        self.masking_level: Optional[str] = None


class DataMaskingRule(ProxyResource):
    """A database data masking rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The location of the data masking rule.
    :vartype location: str
    :ivar kind: The kind of Data Masking Rule. Metadata, used for Azure portal.
    :vartype kind: str
    :ivar id_properties_id: The rule Id.
    :vartype id_properties_id: str
    :ivar rule_state: The rule state. Used to delete a rule. To delete an existing rule, specify
     the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled.
     However, if the rule doesn't already exist, the rule will be created with ruleState set to
     enabled, regardless of the provided value of ruleState. Known values are: "Enabled" and
     "Disabled".
    :vartype rule_state: str or ~azure.mgmt.sql.models.DataMaskingRuleState
    :ivar schema_name: The schema name on which the data masking rule is applied.
    :vartype schema_name: str
    :ivar table_name: The table name on which the data masking rule is applied.
    :vartype table_name: str
    :ivar column_name: The column name on which the data masking rule is applied.
    :vartype column_name: str
    :ivar alias_name: The alias name. This is a legacy parameter and is no longer used.
    :vartype alias_name: str
    :ivar masking_function: The masking function that is used for the data masking rule. Known
     values are: "Default", "CCN", "Email", "Number", "SSN", and "Text".
    :vartype masking_function: str or ~azure.mgmt.sql.models.DataMaskingFunction
    :ivar number_from: The numberFrom property of the masking rule. Required if maskingFunction is
     set to Number, otherwise this parameter will be ignored.
    :vartype number_from: str
    :ivar number_to: The numberTo property of the data masking rule. Required if maskingFunction is
     set to Number, otherwise this parameter will be ignored.
    :vartype number_to: str
    :ivar prefix_size: If maskingFunction is set to Text, the number of characters to show unmasked
     in the beginning of the string. Otherwise, this parameter will be ignored.
    :vartype prefix_size: str
    :ivar suffix_size: If maskingFunction is set to Text, the number of characters to show unmasked
     at the end of the string. Otherwise, this parameter will be ignored.
    :vartype suffix_size: str
    :ivar replacement_string: If maskingFunction is set to Text, the character to use for masking
     the unexposed part of the string. Otherwise, this parameter will be ignored.
    :vartype replacement_string: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "kind": {"readonly": True},
        "id_properties_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id_properties_id": {"key": "properties.id", "type": "str"},
        "rule_state": {"key": "properties.ruleState", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
        "column_name": {"key": "properties.columnName", "type": "str"},
        "alias_name": {"key": "properties.aliasName", "type": "str"},
        "masking_function": {"key": "properties.maskingFunction", "type": "str"},
        "number_from": {"key": "properties.numberFrom", "type": "str"},
        "number_to": {"key": "properties.numberTo", "type": "str"},
        "prefix_size": {"key": "properties.prefixSize", "type": "str"},
        "suffix_size": {"key": "properties.suffixSize", "type": "str"},
        "replacement_string": {"key": "properties.replacementString", "type": "str"},
    }

    def __init__(
        self,
        *,
        rule_state: Optional[Union[str, "_models.DataMaskingRuleState"]] = None,
        schema_name: Optional[str] = None,
        table_name: Optional[str] = None,
        column_name: Optional[str] = None,
        alias_name: Optional[str] = None,
        masking_function: Optional[Union[str, "_models.DataMaskingFunction"]] = None,
        number_from: Optional[str] = None,
        number_to: Optional[str] = None,
        prefix_size: Optional[str] = None,
        suffix_size: Optional[str] = None,
        replacement_string: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_state: The rule state. Used to delete a rule. To delete an existing rule, specify
         the schemaName, tableName, columnName, maskingFunction, and specify ruleState as disabled.
         However, if the rule doesn't already exist, the rule will be created with ruleState set to
         enabled, regardless of the provided value of ruleState. Known values are: "Enabled" and
         "Disabled".
        :paramtype rule_state: str or ~azure.mgmt.sql.models.DataMaskingRuleState
        :keyword schema_name: The schema name on which the data masking rule is applied.
        :paramtype schema_name: str
        :keyword table_name: The table name on which the data masking rule is applied.
        :paramtype table_name: str
        :keyword column_name: The column name on which the data masking rule is applied.
        :paramtype column_name: str
        :keyword alias_name: The alias name. This is a legacy parameter and is no longer used.
        :paramtype alias_name: str
        :keyword masking_function: The masking function that is used for the data masking rule. Known
         values are: "Default", "CCN", "Email", "Number", "SSN", and "Text".
        :paramtype masking_function: str or ~azure.mgmt.sql.models.DataMaskingFunction
        :keyword number_from: The numberFrom property of the masking rule. Required if maskingFunction
         is set to Number, otherwise this parameter will be ignored.
        :paramtype number_from: str
        :keyword number_to: The numberTo property of the data masking rule. Required if maskingFunction
         is set to Number, otherwise this parameter will be ignored.
        :paramtype number_to: str
        :keyword prefix_size: If maskingFunction is set to Text, the number of characters to show
         unmasked in the beginning of the string. Otherwise, this parameter will be ignored.
        :paramtype prefix_size: str
        :keyword suffix_size: If maskingFunction is set to Text, the number of characters to show
         unmasked at the end of the string. Otherwise, this parameter will be ignored.
        :paramtype suffix_size: str
        :keyword replacement_string: If maskingFunction is set to Text, the character to use for
         masking the unexposed part of the string. Otherwise, this parameter will be ignored.
        :paramtype replacement_string: str
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.kind: Optional[str] = None
        self.id_properties_id: Optional[str] = None
        self.rule_state = rule_state
        self.schema_name = schema_name
        self.table_name = table_name
        self.column_name = column_name
        self.alias_name = alias_name
        self.masking_function = masking_function
        self.number_from = number_from
        self.number_to = number_to
        self.prefix_size = prefix_size
        self.suffix_size = suffix_size
        self.replacement_string = replacement_string


class DataMaskingRuleListResult(_serialization.Model):
    """The list of database data masking rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DataMaskingRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataMaskingRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DataMaskingRule"]] = None
        self.next_link: Optional[str] = None


class DataWarehouseUserActivities(ProxyResource):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar active_queries_count: Count of running and suspended queries.
    :vartype active_queries_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "active_queries_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "active_queries_count": {"key": "properties.activeQueriesCount", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.active_queries_count: Optional[int] = None


class DataWarehouseUserActivitiesListResult(_serialization.Model):
    """User activities of a data warehouse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DataWarehouseUserActivities]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataWarehouseUserActivities]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DataWarehouseUserActivities"]] = None
        self.next_link: Optional[str] = None


class DeletedServer(ProxyResource):
    """A deleted server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar version: The version of the deleted server.
    :vartype version: str
    :ivar deletion_time: The deletion time of the deleted server.
    :vartype deletion_time: ~datetime.datetime
    :ivar original_id: The original ID of the server before deletion.
    :vartype original_id: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "version": {"readonly": True},
        "deletion_time": {"readonly": True},
        "original_id": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "deletion_time": {"key": "properties.deletionTime", "type": "iso-8601"},
        "original_id": {"key": "properties.originalId", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.version: Optional[str] = None
        self.deletion_time: Optional[datetime.datetime] = None
        self.original_id: Optional[str] = None
        self.fully_qualified_domain_name: Optional[str] = None


class DeletedServerListResult(_serialization.Model):
    """A list of deleted servers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DeletedServer]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedServer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DeletedServer"]] = None
        self.next_link: Optional[str] = None


class DistributedAvailabilityGroup(ProxyResource):
    """Distributed availability group between box and Sql Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar distributed_availability_group_name: Name of the distributed availability group.
    :vartype distributed_availability_group_name: str
    :ivar distributed_availability_group_id: ID of the distributed availability group.
    :vartype distributed_availability_group_id: str
    :ivar replication_mode: Replication mode of the link. Known values are: "Async", "Sync", and
     "Async".
    :vartype replication_mode: str or ~azure.mgmt.sql.models.ReplicationModeType
    :ivar partner_link_role: SQL server side link role. Known values are: "Primary" and
     "Secondary".
    :vartype partner_link_role: str or ~azure.mgmt.sql.models.LinkRole
    :ivar partner_availability_group_name: SQL server side availability group name.
    :vartype partner_availability_group_name: str
    :ivar partner_endpoint: SQL server side endpoint - IP or DNS resolvable name.
    :vartype partner_endpoint: str
    :ivar instance_link_role: Managed instance side link role. Known values are: "Primary" and
     "Secondary".
    :vartype instance_link_role: str or ~azure.mgmt.sql.models.LinkRole
    :ivar instance_availability_group_name: Managed instance side availability group name.
    :vartype instance_availability_group_name: str
    :ivar failover_mode: The link failover mode - can be Manual if intended to be used for two-way
     failover with a supported SQL Server, or None for one-way failover to Azure. Known values are:
     "None" and "Manual".
    :vartype failover_mode: str or ~azure.mgmt.sql.models.FailoverModeType
    :ivar seeding_mode: Database seeding mode – can be Automatic (default), or Manual for supported
     scenarios. Known values are: "Automatic" and "Manual".
    :vartype seeding_mode: str or ~azure.mgmt.sql.models.SeedingModeType
    :ivar databases: Databases in the distributed availability group.
    :vartype databases: list[~azure.mgmt.sql.models.DistributedAvailabilityGroupDatabase]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "distributed_availability_group_name": {"readonly": True},
        "distributed_availability_group_id": {"readonly": True},
        "partner_link_role": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "distributed_availability_group_name": {"key": "properties.distributedAvailabilityGroupName", "type": "str"},
        "distributed_availability_group_id": {"key": "properties.distributedAvailabilityGroupId", "type": "str"},
        "replication_mode": {"key": "properties.replicationMode", "type": "str"},
        "partner_link_role": {"key": "properties.partnerLinkRole", "type": "str"},
        "partner_availability_group_name": {"key": "properties.partnerAvailabilityGroupName", "type": "str"},
        "partner_endpoint": {"key": "properties.partnerEndpoint", "type": "str"},
        "instance_link_role": {"key": "properties.instanceLinkRole", "type": "str"},
        "instance_availability_group_name": {"key": "properties.instanceAvailabilityGroupName", "type": "str"},
        "failover_mode": {"key": "properties.failoverMode", "type": "str"},
        "seeding_mode": {"key": "properties.seedingMode", "type": "str"},
        "databases": {"key": "properties.databases", "type": "[DistributedAvailabilityGroupDatabase]"},
    }

    def __init__(
        self,
        *,
        replication_mode: Optional[Union[str, "_models.ReplicationModeType"]] = None,
        partner_availability_group_name: Optional[str] = None,
        partner_endpoint: Optional[str] = None,
        instance_link_role: Optional[Union[str, "_models.LinkRole"]] = None,
        instance_availability_group_name: Optional[str] = None,
        failover_mode: Optional[Union[str, "_models.FailoverModeType"]] = None,
        seeding_mode: Optional[Union[str, "_models.SeedingModeType"]] = None,
        databases: Optional[List["_models.DistributedAvailabilityGroupDatabase"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword replication_mode: Replication mode of the link. Known values are: "Async", "Sync", and
         "Async".
        :paramtype replication_mode: str or ~azure.mgmt.sql.models.ReplicationModeType
        :keyword partner_availability_group_name: SQL server side availability group name.
        :paramtype partner_availability_group_name: str
        :keyword partner_endpoint: SQL server side endpoint - IP or DNS resolvable name.
        :paramtype partner_endpoint: str
        :keyword instance_link_role: Managed instance side link role. Known values are: "Primary" and
         "Secondary".
        :paramtype instance_link_role: str or ~azure.mgmt.sql.models.LinkRole
        :keyword instance_availability_group_name: Managed instance side availability group name.
        :paramtype instance_availability_group_name: str
        :keyword failover_mode: The link failover mode - can be Manual if intended to be used for
         two-way failover with a supported SQL Server, or None for one-way failover to Azure. Known
         values are: "None" and "Manual".
        :paramtype failover_mode: str or ~azure.mgmt.sql.models.FailoverModeType
        :keyword seeding_mode: Database seeding mode – can be Automatic (default), or Manual for
         supported scenarios. Known values are: "Automatic" and "Manual".
        :paramtype seeding_mode: str or ~azure.mgmt.sql.models.SeedingModeType
        :keyword databases: Databases in the distributed availability group.
        :paramtype databases: list[~azure.mgmt.sql.models.DistributedAvailabilityGroupDatabase]
        """
        super().__init__(**kwargs)
        self.distributed_availability_group_name: Optional[str] = None
        self.distributed_availability_group_id: Optional[str] = None
        self.replication_mode = replication_mode
        self.partner_link_role: Optional[Union[str, "_models.LinkRole"]] = None
        self.partner_availability_group_name = partner_availability_group_name
        self.partner_endpoint = partner_endpoint
        self.instance_link_role = instance_link_role
        self.instance_availability_group_name = instance_availability_group_name
        self.failover_mode = failover_mode
        self.seeding_mode = seeding_mode
        self.databases = databases


class DistributedAvailabilityGroupDatabase(_serialization.Model):
    """Database specific information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: The name of the database in link.
    :vartype database_name: str
    :ivar instance_replica_id: Managed instance replica id.
    :vartype instance_replica_id: str
    :ivar partner_replica_id: SQL server replica id.
    :vartype partner_replica_id: str
    :ivar replica_state: Current link state.
    :vartype replica_state: str
    :ivar seeding_progress: Seeding progress.
    :vartype seeding_progress: str
    :ivar synchronization_health: Link health state. Known values are: "NOT_HEALTHY",
     "PARTIALLY_HEALTHY", and "HEALTHY".
    :vartype synchronization_health: str or ~azure.mgmt.sql.models.ReplicaSynchronizationHealth
    :ivar connected_state: Link connected state. Known values are: "DISCONNECTED" and "CONNECTED".
    :vartype connected_state: str or ~azure.mgmt.sql.models.ReplicaConnectedState
    :ivar last_received_lsn: Last received LSN.
    :vartype last_received_lsn: str
    :ivar last_received_time: Last received LSN time.
    :vartype last_received_time: ~datetime.datetime
    :ivar last_sent_lsn: Last sent LSN.
    :vartype last_sent_lsn: str
    :ivar last_sent_time: Last sent LSN time.
    :vartype last_sent_time: ~datetime.datetime
    :ivar last_commit_lsn: Last commit LSN.
    :vartype last_commit_lsn: str
    :ivar last_commit_time: Last commit LSN time.
    :vartype last_commit_time: ~datetime.datetime
    :ivar last_hardened_lsn: Last hardened LSN.
    :vartype last_hardened_lsn: str
    :ivar last_hardened_time: Last hardened LSN time.
    :vartype last_hardened_time: ~datetime.datetime
    :ivar last_backup_lsn: Last backup LSN.
    :vartype last_backup_lsn: str
    :ivar last_backup_time: Last backup LSN time.
    :vartype last_backup_time: ~datetime.datetime
    :ivar most_recent_link_error: The most recent link connection error description.
    :vartype most_recent_link_error: str
    :ivar partner_auth_cert_validity: SQL server certificate validity.
    :vartype partner_auth_cert_validity: ~azure.mgmt.sql.models.CertificateInfo
    :ivar instance_send_replication_lag_seconds: Replication lag when Managed Instance link side is
     primary.
    :vartype instance_send_replication_lag_seconds: int
    :ivar instance_redo_replication_lag_seconds: Redo lag when Managed Instance link side is
     primary.
    :vartype instance_redo_replication_lag_seconds: int
    """

    _validation = {
        "instance_replica_id": {"readonly": True},
        "partner_replica_id": {"readonly": True},
        "replica_state": {"readonly": True},
        "seeding_progress": {"readonly": True},
        "synchronization_health": {"readonly": True},
        "connected_state": {"readonly": True},
        "last_received_lsn": {"readonly": True},
        "last_received_time": {"readonly": True},
        "last_sent_lsn": {"readonly": True},
        "last_sent_time": {"readonly": True},
        "last_commit_lsn": {"readonly": True},
        "last_commit_time": {"readonly": True},
        "last_hardened_lsn": {"readonly": True},
        "last_hardened_time": {"readonly": True},
        "last_backup_lsn": {"readonly": True},
        "last_backup_time": {"readonly": True},
        "most_recent_link_error": {"readonly": True},
        "partner_auth_cert_validity": {"readonly": True},
        "instance_send_replication_lag_seconds": {"readonly": True},
        "instance_redo_replication_lag_seconds": {"readonly": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "instance_replica_id": {"key": "instanceReplicaId", "type": "str"},
        "partner_replica_id": {"key": "partnerReplicaId", "type": "str"},
        "replica_state": {"key": "replicaState", "type": "str"},
        "seeding_progress": {"key": "seedingProgress", "type": "str"},
        "synchronization_health": {"key": "synchronizationHealth", "type": "str"},
        "connected_state": {"key": "connectedState", "type": "str"},
        "last_received_lsn": {"key": "lastReceivedLsn", "type": "str"},
        "last_received_time": {"key": "lastReceivedTime", "type": "iso-8601"},
        "last_sent_lsn": {"key": "lastSentLsn", "type": "str"},
        "last_sent_time": {"key": "lastSentTime", "type": "iso-8601"},
        "last_commit_lsn": {"key": "lastCommitLsn", "type": "str"},
        "last_commit_time": {"key": "lastCommitTime", "type": "iso-8601"},
        "last_hardened_lsn": {"key": "lastHardenedLsn", "type": "str"},
        "last_hardened_time": {"key": "lastHardenedTime", "type": "iso-8601"},
        "last_backup_lsn": {"key": "lastBackupLsn", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "most_recent_link_error": {"key": "mostRecentLinkError", "type": "str"},
        "partner_auth_cert_validity": {"key": "partnerAuthCertValidity", "type": "CertificateInfo"},
        "instance_send_replication_lag_seconds": {"key": "instanceSendReplicationLagSeconds", "type": "int"},
        "instance_redo_replication_lag_seconds": {"key": "instanceRedoReplicationLagSeconds", "type": "int"},
    }

    def __init__(self, *, database_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword database_name: The name of the database in link.
        :paramtype database_name: str
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.instance_replica_id: Optional[str] = None
        self.partner_replica_id: Optional[str] = None
        self.replica_state: Optional[str] = None
        self.seeding_progress: Optional[str] = None
        self.synchronization_health: Optional[Union[str, "_models.ReplicaSynchronizationHealth"]] = None
        self.connected_state: Optional[Union[str, "_models.ReplicaConnectedState"]] = None
        self.last_received_lsn: Optional[str] = None
        self.last_received_time: Optional[datetime.datetime] = None
        self.last_sent_lsn: Optional[str] = None
        self.last_sent_time: Optional[datetime.datetime] = None
        self.last_commit_lsn: Optional[str] = None
        self.last_commit_time: Optional[datetime.datetime] = None
        self.last_hardened_lsn: Optional[str] = None
        self.last_hardened_time: Optional[datetime.datetime] = None
        self.last_backup_lsn: Optional[str] = None
        self.last_backup_time: Optional[datetime.datetime] = None
        self.most_recent_link_error: Optional[str] = None
        self.partner_auth_cert_validity: Optional["_models.CertificateInfo"] = None
        self.instance_send_replication_lag_seconds: Optional[int] = None
        self.instance_redo_replication_lag_seconds: Optional[int] = None


class DistributedAvailabilityGroupSetRole(_serialization.Model):
    """Distributed availability group failover request.

    All required parameters must be populated in order to send to server.

    :ivar instance_role: New role of managed instance in a distributed availability group, can be
     Primary or Secondary. Required. Known values are: "Primary" and "Secondary".
    :vartype instance_role: str or ~azure.mgmt.sql.models.InstanceRole
    :ivar role_change_type: The type of the role change, can be Planned or Forced. Required. Known
     values are: "Forced" and "Planned".
    :vartype role_change_type: str or ~azure.mgmt.sql.models.RoleChangeType
    """

    _validation = {
        "instance_role": {"required": True},
        "role_change_type": {"required": True},
    }

    _attribute_map = {
        "instance_role": {"key": "instanceRole", "type": "str"},
        "role_change_type": {"key": "roleChangeType", "type": "str"},
    }

    def __init__(
        self,
        *,
        instance_role: Union[str, "_models.InstanceRole"],
        role_change_type: Union[str, "_models.RoleChangeType"],
        **kwargs: Any
    ) -> None:
        """
        :keyword instance_role: New role of managed instance in a distributed availability group, can
         be Primary or Secondary. Required. Known values are: "Primary" and "Secondary".
        :paramtype instance_role: str or ~azure.mgmt.sql.models.InstanceRole
        :keyword role_change_type: The type of the role change, can be Planned or Forced. Required.
         Known values are: "Forced" and "Planned".
        :paramtype role_change_type: str or ~azure.mgmt.sql.models.RoleChangeType
        """
        super().__init__(**kwargs)
        self.instance_role = instance_role
        self.role_change_type = role_change_type


class DistributedAvailabilityGroupsFailoverRequest(_serialization.Model):  # pylint: disable=name-too-long
    """Distributed availability group failover.

    All required parameters must be populated in order to send to server.

    :ivar failover_type: The failover type, can be ForcedAllowDataLoss or Planned. Required. Known
     values are: "ForcedAllowDataLoss" and "Planned".
    :vartype failover_type: str or ~azure.mgmt.sql.models.FailoverType
    """

    _validation = {
        "failover_type": {"required": True},
    }

    _attribute_map = {
        "failover_type": {"key": "failoverType", "type": "str"},
    }

    def __init__(self, *, failover_type: Union[str, "_models.FailoverType"], **kwargs: Any) -> None:
        """
        :keyword failover_type: The failover type, can be ForcedAllowDataLoss or Planned. Required.
         Known values are: "ForcedAllowDataLoss" and "Planned".
        :paramtype failover_type: str or ~azure.mgmt.sql.models.FailoverType
        """
        super().__init__(**kwargs)
        self.failover_type = failover_type


class DistributedAvailabilityGroupsListResult(_serialization.Model):
    """A list of distributed availability groups in instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.DistributedAvailabilityGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DistributedAvailabilityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DistributedAvailabilityGroup"]] = None
        self.next_link: Optional[str] = None


class EditionCapability(_serialization.Model):
    """The edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The database edition name.
    :vartype name: str
    :ivar supported_service_level_objectives: The list of supported service objectives for the
     edition.
    :vartype supported_service_level_objectives:
     list[~azure.mgmt.sql.models.ServiceObjectiveCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the edition.
    :vartype zone_redundant: bool
    :ivar read_scale: The read scale capability for the edition.
    :vartype read_scale: ~azure.mgmt.sql.models.ReadScaleCapability
    :ivar supported_storage_capabilities: The list of supported storage capabilities for this
     edition.
    :vartype supported_storage_capabilities: list[~azure.mgmt.sql.models.StorageCapability]
    :ivar zone_pinning: Whether or not zone pinning is supported for the edition.
    :vartype zone_pinning: bool
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_service_level_objectives": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "read_scale": {"readonly": True},
        "supported_storage_capabilities": {"readonly": True},
        "zone_pinning": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_service_level_objectives": {
            "key": "supportedServiceLevelObjectives",
            "type": "[ServiceObjectiveCapability]",
        },
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "read_scale": {"key": "readScale", "type": "ReadScaleCapability"},
        "supported_storage_capabilities": {"key": "supportedStorageCapabilities", "type": "[StorageCapability]"},
        "zone_pinning": {"key": "zonePinning", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_service_level_objectives: Optional[List["_models.ServiceObjectiveCapability"]] = None
        self.zone_redundant: Optional[bool] = None
        self.read_scale: Optional["_models.ReadScaleCapability"] = None
        self.supported_storage_capabilities: Optional[List["_models.StorageCapability"]] = None
        self.zone_pinning: Optional[bool] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ElasticPool(TrackedResource):
    """An elastic pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The elastic pool SKU.

     The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU
     name, tier/edition, family, and capacity) that are available to your subscription in an Azure
     region, use the ``Capabilities_ListByLocation`` REST API or the following command:

     .. code-block:: azurecli

        az sql elastic-pool list-editions -l <location> -o table
        `.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar kind: Kind of elastic pool. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar state: The state of the elastic pool. Known values are: "Creating", "Ready", and
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.ElasticPoolState
    :ivar creation_date: The creation date of the elastic pool (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar max_size_bytes: The storage limit for the database elastic pool in bytes.
    :vartype max_size_bytes: int
    :ivar min_capacity: Minimal capacity that serverless pool will not shrink below, if not paused.
    :vartype min_capacity: float
    :ivar per_database_settings: The per database settings for the elastic pool.
    :vartype per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :ivar zone_redundant: Whether or not this elastic pool is zone redundant, which means the
     replicas of this elastic pool will be spread across multiple availability zones.
    :vartype zone_redundant: bool
    :ivar license_type: The license type to apply for this elastic pool. Known values are:
     "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :ivar maintenance_configuration_id: Maintenance configuration id assigned to the elastic pool.
     This configuration defines the period when the maintenance updates will will occur.
    :vartype maintenance_configuration_id: str
    :ivar high_availability_replica_count: The number of secondary replicas associated with the
     Business Critical, Premium, or Hyperscale edition elastic pool that are used to provide high
     availability. Applicable only to Hyperscale elastic pools.
    :vartype high_availability_replica_count: int
    :ivar auto_pause_delay: Time in minutes after which elastic pool is automatically paused. A
     value of -1 means that automatic pause is disabled.
    :vartype auto_pause_delay: int
    :ivar preferred_enclave_type: Type of enclave requested on the elastic pool. Known values are:
     "Default" and "VBS".
    :vartype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
    :ivar availability_zone: Specifies the availability zone the pool's primary replica is pinned
     to. Known values are: "NoPreference", "1", "2", and "3".
    :vartype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "kind": {"readonly": True},
        "state": {"readonly": True},
        "creation_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "kind": {"key": "kind", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "int"},
        "min_capacity": {"key": "properties.minCapacity", "type": "float"},
        "per_database_settings": {"key": "properties.perDatabaseSettings", "type": "ElasticPoolPerDatabaseSettings"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "high_availability_replica_count": {"key": "properties.highAvailabilityReplicaCount", "type": "int"},
        "auto_pause_delay": {"key": "properties.autoPauseDelay", "type": "int"},
        "preferred_enclave_type": {"key": "properties.preferredEnclaveType", "type": "str"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        max_size_bytes: Optional[int] = None,
        min_capacity: Optional[float] = None,
        per_database_settings: Optional["_models.ElasticPoolPerDatabaseSettings"] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.ElasticPoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        high_availability_replica_count: Optional[int] = None,
        auto_pause_delay: Optional[int] = None,
        preferred_enclave_type: Optional[Union[str, "_models.AlwaysEncryptedEnclaveType"]] = None,
        availability_zone: Optional[Union[str, "_models.AvailabilityZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The elastic pool SKU.

         The list of SKUs may vary by region and support offer. To determine the SKUs (including the SKU
         name, tier/edition, family, and capacity) that are available to your subscription in an Azure
         region, use the ``Capabilities_ListByLocation`` REST API or the following command:

         .. code-block:: azurecli

            az sql elastic-pool list-editions -l <location> -o table
            `.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword max_size_bytes: The storage limit for the database elastic pool in bytes.
        :paramtype max_size_bytes: int
        :keyword min_capacity: Minimal capacity that serverless pool will not shrink below, if not
         paused.
        :paramtype min_capacity: float
        :keyword per_database_settings: The per database settings for the elastic pool.
        :paramtype per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
        :keyword zone_redundant: Whether or not this elastic pool is zone redundant, which means the
         replicas of this elastic pool will be spread across multiple availability zones.
        :paramtype zone_redundant: bool
        :keyword license_type: The license type to apply for this elastic pool. Known values are:
         "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
        :keyword maintenance_configuration_id: Maintenance configuration id assigned to the elastic
         pool. This configuration defines the period when the maintenance updates will will occur.
        :paramtype maintenance_configuration_id: str
        :keyword high_availability_replica_count: The number of secondary replicas associated with the
         Business Critical, Premium, or Hyperscale edition elastic pool that are used to provide high
         availability. Applicable only to Hyperscale elastic pools.
        :paramtype high_availability_replica_count: int
        :keyword auto_pause_delay: Time in minutes after which elastic pool is automatically paused. A
         value of -1 means that automatic pause is disabled.
        :paramtype auto_pause_delay: int
        :keyword preferred_enclave_type: Type of enclave requested on the elastic pool. Known values
         are: "Default" and "VBS".
        :paramtype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
        :keyword availability_zone: Specifies the availability zone the pool's primary replica is
         pinned to. Known values are: "NoPreference", "1", "2", and "3".
        :paramtype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.kind: Optional[str] = None
        self.state: Optional[Union[str, "_models.ElasticPoolState"]] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.max_size_bytes = max_size_bytes
        self.min_capacity = min_capacity
        self.per_database_settings = per_database_settings
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.maintenance_configuration_id = maintenance_configuration_id
        self.high_availability_replica_count = high_availability_replica_count
        self.auto_pause_delay = auto_pause_delay
        self.preferred_enclave_type = preferred_enclave_type
        self.availability_zone = availability_zone


class ElasticPoolEditionCapability(_serialization.Model):
    """The elastic pool edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The elastic pool edition name.
    :vartype name: str
    :ivar supported_elastic_pool_performance_levels: The list of supported elastic pool DTU levels
     for the edition.
    :vartype supported_elastic_pool_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the edition.
    :vartype zone_redundant: bool
    :ivar zone_pinning: Whether or not zone pinning is supported for the edition.
    :vartype zone_pinning: bool
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_elastic_pool_performance_levels": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "zone_pinning": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_elastic_pool_performance_levels": {
            "key": "supportedElasticPoolPerformanceLevels",
            "type": "[ElasticPoolPerformanceLevelCapability]",
        },
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "zone_pinning": {"key": "zonePinning", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_elastic_pool_performance_levels: Optional[
            List["_models.ElasticPoolPerformanceLevelCapability"]
        ] = None
        self.zone_redundant: Optional[bool] = None
        self.zone_pinning: Optional[bool] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ElasticPoolListResult(_serialization.Model):
    """The result of an elastic pool list request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ElasticPool]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ElasticPool"]] = None
        self.next_link: Optional[str] = None


class ElasticPoolOperation(ProxyResource):
    """A elastic pool operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar elastic_pool_name: The name of the elastic pool the operation is being performed on.
    :vartype elastic_pool_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state.
    :vartype state: str
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "elastic_pool_name": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "percent_complete": {"readonly": True},
        "server_name": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "is_user_error": {"readonly": True},
        "estimated_completion_time": {"readonly": True},
        "description": {"readonly": True},
        "is_cancellable": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "elastic_pool_name": {"key": "properties.elasticPoolName", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "is_user_error": {"key": "properties.isUserError", "type": "bool"},
        "estimated_completion_time": {"key": "properties.estimatedCompletionTime", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.elastic_pool_name: Optional[str] = None
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.percent_complete: Optional[int] = None
        self.server_name: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[str] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.is_user_error: Optional[bool] = None
        self.estimated_completion_time: Optional[datetime.datetime] = None
        self.description: Optional[str] = None
        self.is_cancellable: Optional[bool] = None


class ElasticPoolOperationListResult(_serialization.Model):
    """The response to a list elastic pool operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ElasticPoolOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ElasticPoolOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ElasticPoolOperation"]] = None
        self.next_link: Optional[str] = None


class ElasticPoolPerDatabaseMaxPerformanceLevelCapability(_serialization.Model):  # pylint: disable=name-too-long
    """The max per-database performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The maximum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Known values are: "DTU" and "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar supported_per_database_min_performance_levels: The list of supported min database
     performance levels.
    :vartype supported_per_database_min_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMinPerformanceLevelCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "limit": {"readonly": True},
        "unit": {"readonly": True},
        "supported_per_database_min_performance_levels": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "float"},
        "unit": {"key": "unit", "type": "str"},
        "supported_per_database_min_performance_levels": {
            "key": "supportedPerDatabaseMinPerformanceLevels",
            "type": "[ElasticPoolPerDatabaseMinPerformanceLevelCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.limit: Optional[float] = None
        self.unit: Optional[Union[str, "_models.PerformanceLevelUnit"]] = None
        self.supported_per_database_min_performance_levels: Optional[
            List["_models.ElasticPoolPerDatabaseMinPerformanceLevelCapability"]
        ] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ElasticPoolPerDatabaseMinPerformanceLevelCapability(_serialization.Model):  # pylint: disable=name-too-long
    """The minimum per-database performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The minimum performance level per database.
    :vartype limit: float
    :ivar unit: Unit type used to measure performance level. Known values are: "DTU" and "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "limit": {"readonly": True},
        "unit": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "float"},
        "unit": {"key": "unit", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.limit: Optional[float] = None
        self.unit: Optional[Union[str, "_models.PerformanceLevelUnit"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ElasticPoolPerDatabaseSettings(_serialization.Model):
    """Per database settings of an elastic pool.

    :ivar min_capacity: The minimum capacity all databases are guaranteed.
    :vartype min_capacity: float
    :ivar max_capacity: The maximum capacity any one database can consume.
    :vartype max_capacity: float
    :ivar auto_pause_delay: Auto Pause Delay for per database within pool.
    :vartype auto_pause_delay: int
    """

    _attribute_map = {
        "min_capacity": {"key": "minCapacity", "type": "float"},
        "max_capacity": {"key": "maxCapacity", "type": "float"},
        "auto_pause_delay": {"key": "autoPauseDelay", "type": "int"},
    }

    def __init__(
        self,
        *,
        min_capacity: Optional[float] = None,
        max_capacity: Optional[float] = None,
        auto_pause_delay: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword min_capacity: The minimum capacity all databases are guaranteed.
        :paramtype min_capacity: float
        :keyword max_capacity: The maximum capacity any one database can consume.
        :paramtype max_capacity: float
        :keyword auto_pause_delay: Auto Pause Delay for per database within pool.
        :paramtype auto_pause_delay: int
        """
        super().__init__(**kwargs)
        self.min_capacity = min_capacity
        self.max_capacity = max_capacity
        self.auto_pause_delay = auto_pause_delay


class ElasticPoolPerformanceLevelCapability(_serialization.Model):
    """The Elastic Pool performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar performance_level: The performance level for the pool.
    :vartype performance_level: ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar max_database_count: The maximum number of databases supported.
    :vartype max_database_count: int
    :ivar included_max_size: The included (free) max size for this performance level.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_max_sizes: The list of supported max sizes.
    :vartype supported_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_sizes: The list of supported per database max sizes.
    :vartype supported_per_database_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar supported_per_database_max_performance_levels: The list of supported per database max
     performance levels.
    :vartype supported_per_database_max_performance_levels:
     list[~azure.mgmt.sql.models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability]
    :ivar zone_redundant: Whether or not zone redundancy is supported for the performance level.
    :vartype zone_redundant: bool
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.MaintenanceConfigurationCapability]
    :ivar supported_min_capacities: List of supported min capacities.
    :vartype supported_min_capacities: list[~azure.mgmt.sql.models.MinCapacityCapability]
    :ivar supported_auto_pause_delay: Supported time range for auto pause delay.
    :vartype supported_auto_pause_delay: ~azure.mgmt.sql.models.AutoPauseDelayTimeRange
    :ivar supported_per_database_auto_pause_delay: Supported time range for per database auto pause
     delay.
    :vartype supported_per_database_auto_pause_delay:
     ~azure.mgmt.sql.models.PerDatabaseAutoPauseDelayTimeRange
    :ivar supported_zones: List of supported availability zones.
    :vartype supported_zones: list[~azure.mgmt.sql.models.ZonePinningCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "performance_level": {"readonly": True},
        "sku": {"readonly": True},
        "supported_license_types": {"readonly": True},
        "max_database_count": {"readonly": True},
        "included_max_size": {"readonly": True},
        "supported_max_sizes": {"readonly": True},
        "supported_per_database_max_sizes": {"readonly": True},
        "supported_per_database_max_performance_levels": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "supported_maintenance_configurations": {"readonly": True},
        "supported_min_capacities": {"readonly": True},
        "supported_auto_pause_delay": {"readonly": True},
        "supported_per_database_auto_pause_delay": {"readonly": True},
        "supported_zones": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "performance_level": {"key": "performanceLevel", "type": "PerformanceLevelCapability"},
        "sku": {"key": "sku", "type": "Sku"},
        "supported_license_types": {"key": "supportedLicenseTypes", "type": "[LicenseTypeCapability]"},
        "max_database_count": {"key": "maxDatabaseCount", "type": "int"},
        "included_max_size": {"key": "includedMaxSize", "type": "MaxSizeCapability"},
        "supported_max_sizes": {"key": "supportedMaxSizes", "type": "[MaxSizeRangeCapability]"},
        "supported_per_database_max_sizes": {"key": "supportedPerDatabaseMaxSizes", "type": "[MaxSizeRangeCapability]"},
        "supported_per_database_max_performance_levels": {
            "key": "supportedPerDatabaseMaxPerformanceLevels",
            "type": "[ElasticPoolPerDatabaseMaxPerformanceLevelCapability]",
        },
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "supported_maintenance_configurations": {
            "key": "supportedMaintenanceConfigurations",
            "type": "[MaintenanceConfigurationCapability]",
        },
        "supported_min_capacities": {"key": "supportedMinCapacities", "type": "[MinCapacityCapability]"},
        "supported_auto_pause_delay": {"key": "supportedAutoPauseDelay", "type": "AutoPauseDelayTimeRange"},
        "supported_per_database_auto_pause_delay": {
            "key": "supportedPerDatabaseAutoPauseDelay",
            "type": "PerDatabaseAutoPauseDelayTimeRange",
        },
        "supported_zones": {"key": "supportedZones", "type": "[ZonePinningCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.performance_level: Optional["_models.PerformanceLevelCapability"] = None
        self.sku: Optional["_models.Sku"] = None
        self.supported_license_types: Optional[List["_models.LicenseTypeCapability"]] = None
        self.max_database_count: Optional[int] = None
        self.included_max_size: Optional["_models.MaxSizeCapability"] = None
        self.supported_max_sizes: Optional[List["_models.MaxSizeRangeCapability"]] = None
        self.supported_per_database_max_sizes: Optional[List["_models.MaxSizeRangeCapability"]] = None
        self.supported_per_database_max_performance_levels: Optional[
            List["_models.ElasticPoolPerDatabaseMaxPerformanceLevelCapability"]
        ] = None
        self.zone_redundant: Optional[bool] = None
        self.supported_maintenance_configurations: Optional[List["_models.MaintenanceConfigurationCapability"]] = None
        self.supported_min_capacities: Optional[List["_models.MinCapacityCapability"]] = None
        self.supported_auto_pause_delay: Optional["_models.AutoPauseDelayTimeRange"] = None
        self.supported_per_database_auto_pause_delay: Optional["_models.PerDatabaseAutoPauseDelayTimeRange"] = None
        self.supported_zones: Optional[List["_models.ZonePinningCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ElasticPoolUpdate(_serialization.Model):
    """An elastic pool update.

    :ivar sku: An ARM Resource SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar max_size_bytes: The storage limit for the database elastic pool in bytes.
    :vartype max_size_bytes: int
    :ivar min_capacity: Minimal capacity that serverless pool will not shrink below, if not paused.
    :vartype min_capacity: float
    :ivar per_database_settings: The per database settings for the elastic pool.
    :vartype per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
    :ivar zone_redundant: Whether or not this elastic pool is zone redundant, which means the
     replicas of this elastic pool will be spread across multiple availability zones.
    :vartype zone_redundant: bool
    :ivar license_type: The license type to apply for this elastic pool. Known values are:
     "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
    :ivar maintenance_configuration_id: Maintenance configuration id assigned to the elastic pool.
     This configuration defines the period when the maintenance updates will will occur.
    :vartype maintenance_configuration_id: str
    :ivar high_availability_replica_count: The number of secondary replicas associated with the
     Business Critical, Premium, or Hyperscale edition elastic pool that are used to provide high
     availability. Applicable only to Hyperscale elastic pools.
    :vartype high_availability_replica_count: int
    :ivar auto_pause_delay: Time in minutes after which elastic pool is automatically paused. A
     value of -1 means that automatic pause is disabled.
    :vartype auto_pause_delay: int
    :ivar preferred_enclave_type: Type of enclave requested on the elastic pool. Known values are:
     "Default" and "VBS".
    :vartype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
    :ivar availability_zone: Specifies the availability zone the pool's primary replica is pinned
     to. Known values are: "NoPreference", "1", "2", and "3".
    :vartype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "int"},
        "min_capacity": {"key": "properties.minCapacity", "type": "float"},
        "per_database_settings": {"key": "properties.perDatabaseSettings", "type": "ElasticPoolPerDatabaseSettings"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "high_availability_replica_count": {"key": "properties.highAvailabilityReplicaCount", "type": "int"},
        "auto_pause_delay": {"key": "properties.autoPauseDelay", "type": "int"},
        "preferred_enclave_type": {"key": "properties.preferredEnclaveType", "type": "str"},
        "availability_zone": {"key": "properties.availabilityZone", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        max_size_bytes: Optional[int] = None,
        min_capacity: Optional[float] = None,
        per_database_settings: Optional["_models.ElasticPoolPerDatabaseSettings"] = None,
        zone_redundant: Optional[bool] = None,
        license_type: Optional[Union[str, "_models.ElasticPoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        high_availability_replica_count: Optional[int] = None,
        auto_pause_delay: Optional[int] = None,
        preferred_enclave_type: Optional[Union[str, "_models.AlwaysEncryptedEnclaveType"]] = None,
        availability_zone: Optional[Union[str, "_models.AvailabilityZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: An ARM Resource SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword max_size_bytes: The storage limit for the database elastic pool in bytes.
        :paramtype max_size_bytes: int
        :keyword min_capacity: Minimal capacity that serverless pool will not shrink below, if not
         paused.
        :paramtype min_capacity: float
        :keyword per_database_settings: The per database settings for the elastic pool.
        :paramtype per_database_settings: ~azure.mgmt.sql.models.ElasticPoolPerDatabaseSettings
        :keyword zone_redundant: Whether or not this elastic pool is zone redundant, which means the
         replicas of this elastic pool will be spread across multiple availability zones.
        :paramtype zone_redundant: bool
        :keyword license_type: The license type to apply for this elastic pool. Known values are:
         "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.ElasticPoolLicenseType
        :keyword maintenance_configuration_id: Maintenance configuration id assigned to the elastic
         pool. This configuration defines the period when the maintenance updates will will occur.
        :paramtype maintenance_configuration_id: str
        :keyword high_availability_replica_count: The number of secondary replicas associated with the
         Business Critical, Premium, or Hyperscale edition elastic pool that are used to provide high
         availability. Applicable only to Hyperscale elastic pools.
        :paramtype high_availability_replica_count: int
        :keyword auto_pause_delay: Time in minutes after which elastic pool is automatically paused. A
         value of -1 means that automatic pause is disabled.
        :paramtype auto_pause_delay: int
        :keyword preferred_enclave_type: Type of enclave requested on the elastic pool. Known values
         are: "Default" and "VBS".
        :paramtype preferred_enclave_type: str or ~azure.mgmt.sql.models.AlwaysEncryptedEnclaveType
        :keyword availability_zone: Specifies the availability zone the pool's primary replica is
         pinned to. Known values are: "NoPreference", "1", "2", and "3".
        :paramtype availability_zone: str or ~azure.mgmt.sql.models.AvailabilityZoneType
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.max_size_bytes = max_size_bytes
        self.min_capacity = min_capacity
        self.per_database_settings = per_database_settings
        self.zone_redundant = zone_redundant
        self.license_type = license_type
        self.maintenance_configuration_id = maintenance_configuration_id
        self.high_availability_replica_count = high_availability_replica_count
        self.auto_pause_delay = auto_pause_delay
        self.preferred_enclave_type = preferred_enclave_type
        self.availability_zone = availability_zone


class EncryptionProtector(ProxyResource):
    """The server encryption protector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the encryption protector.
    :vartype subregion: str
    :ivar server_key_name: The name of the server key.
    :vartype server_key_name: str
    :ivar server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     Known values are: "ServiceManaged" and "AzureKeyVault".
    :vartype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    :ivar key_version: The version of the server key being used as encryption protector.
    :vartype key_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "location": {"readonly": True},
        "subregion": {"readonly": True},
        "uri": {"readonly": True},
        "thumbprint": {"readonly": True},
        "key_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "subregion": {"key": "properties.subregion", "type": "str"},
        "server_key_name": {"key": "properties.serverKeyName", "type": "str"},
        "server_key_type": {"key": "properties.serverKeyType", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "auto_rotation_enabled": {"key": "properties.autoRotationEnabled", "type": "bool"},
        "key_version": {"key": "properties.keyVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_key_name: Optional[str] = None,
        server_key_type: Optional[Union[str, "_models.ServerKeyType"]] = None,
        auto_rotation_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_key_name: The name of the server key.
        :paramtype server_key_name: str
        :keyword server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
         Known values are: "ServiceManaged" and "AzureKeyVault".
        :paramtype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
        :keyword auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
        :paramtype auto_rotation_enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.location: Optional[str] = None
        self.subregion: Optional[str] = None
        self.server_key_name = server_key_name
        self.server_key_type = server_key_type
        self.uri: Optional[str] = None
        self.thumbprint: Optional[str] = None
        self.auto_rotation_enabled = auto_rotation_enabled
        self.key_version: Optional[str] = None


class EncryptionProtectorListResult(_serialization.Model):
    """A list of server encryption protectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.EncryptionProtector]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EncryptionProtector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.EncryptionProtector"]] = None
        self.next_link: Optional[str] = None


class EndpointCertificate(ProxyResource):
    """Certificate used on an endpoint on the Managed Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar public_blob: The certificate public blob.
    :vartype public_blob: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "public_blob": {"key": "properties.publicBlob", "type": "str"},
    }

    def __init__(self, *, public_blob: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword public_blob: The certificate public blob.
        :paramtype public_blob: str
        """
        super().__init__(**kwargs)
        self.public_blob = public_blob


class EndpointCertificateListResult(_serialization.Model):
    """A list of endpoint certificates on the target instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.EndpointCertificate]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[EndpointCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.EndpointCertificate"]] = None
        self.next_link: Optional[str] = None


class EndpointDependency(_serialization.Model):
    """A domain name that the managed instance service needs to communicate with, along with
    additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar domain_name: The domain name of the dependency.
    :vartype domain_name: str
    :ivar endpoint_details: The IP Addresses and Ports used when connecting to DomainName.
    :vartype endpoint_details: list[~azure.mgmt.sql.models.EndpointDetail]
    """

    _validation = {
        "domain_name": {"readonly": True},
        "endpoint_details": {"readonly": True},
    }

    _attribute_map = {
        "domain_name": {"key": "domainName", "type": "str"},
        "endpoint_details": {"key": "endpointDetails", "type": "[EndpointDetail]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.domain_name: Optional[str] = None
        self.endpoint_details: Optional[List["_models.EndpointDetail"]] = None


class EndpointDetail(_serialization.Model):
    """A domain name that the managed instance service needs to communicate with, along with
    additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: The port an endpoint is connected to.
    :vartype port: int
    """

    _validation = {
        "port": {"readonly": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.port: Optional[int] = None


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.sql.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.sql.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorDetail"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.sql.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.sql.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ExportDatabaseDefinition(_serialization.Model):
    """Contains the information necessary to perform export database operation.

    All required parameters must be populated in order to send to server.

    :ivar storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
     ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
     "ManagedIdentity".
    :vartype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :ivar storage_key: Storage key for the storage account. If StorageKeyType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype storage_key: str
    :ivar storage_uri: Storage Uri. Required.
    :vartype storage_uri: str
    :ivar administrator_login: Administrator login name. If AuthenticationType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype administrator_login: str
    :ivar administrator_login_password: Administrator login password. If AuthenticationType is
     ManagedIdentity, this field should not be specified.
    :vartype administrator_login_password: str
    :ivar authentication_type: Type of credentials provided for access to the target SQL server:
     SQL, ADPassword or ManagedIdentity.
    :vartype authentication_type: str
    :ivar network_isolation: Optional resource information to enable network isolation for request.
    :vartype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        "storage_key_type": {"required": True},
        "storage_key": {"required": True},
        "storage_uri": {"required": True},
        "administrator_login": {"required": True},
    }

    _attribute_map = {
        "storage_key_type": {"key": "storageKeyType", "type": "str"},
        "storage_key": {"key": "storageKey", "type": "str"},
        "storage_uri": {"key": "storageUri", "type": "str"},
        "administrator_login": {"key": "administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "administratorLoginPassword", "type": "str"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "network_isolation": {"key": "networkIsolation", "type": "NetworkIsolationSettings"},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "_models.StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        administrator_login_password: Optional[str] = None,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["_models.NetworkIsolationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
         ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
         "ManagedIdentity".
        :paramtype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
        :keyword storage_key: Storage key for the storage account. If StorageKeyType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype storage_key: str
        :keyword storage_uri: Storage Uri. Required.
        :paramtype storage_uri: str
        :keyword administrator_login: Administrator login name. If AuthenticationType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype administrator_login: str
        :keyword administrator_login_password: Administrator login password. If AuthenticationType is
         ManagedIdentity, this field should not be specified.
        :paramtype administrator_login_password: str
        :keyword authentication_type: Type of credentials provided for access to the target SQL server:
         SQL, ADPassword or ManagedIdentity.
        :paramtype authentication_type: str
        :keyword network_isolation: Optional resource information to enable network isolation for
         request.
        :paramtype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
        """
        super().__init__(**kwargs)
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class ExtendedDatabaseBlobAuditingPolicy(ProxyResource):
    """An extended database blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar predicate_expression: Specifies condition of where clause when creating an audit.
    :vartype predicate_expression: str
    :ivar retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :vartype retention_days: int
    :ivar audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:

     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.

     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.

     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     DBCC_GROUP
     DATABASE_OWNERSHIP_CHANGE_GROUP
     DATABASE_CHANGE_GROUP
     LEDGER_OPERATION_GROUP

     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.

     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES

     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}

     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public

     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :vartype audit_actions_and_groups: list[str]
    :ivar is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :vartype is_storage_secondary_key_in_use: bool
    :ivar is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.

     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_azure_monitor_target_enabled: bool
    :ivar queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit
     actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :vartype queue_delay_ms: int
    :ivar is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
     storage.
    :vartype is_managed_identity_in_use: bool
    :ivar state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:


     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :vartype storage_account_access_key: str
    :ivar storage_account_subscription_id: Specifies the blob storage subscription Id.
    :vartype storage_account_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "predicate_expression": {"key": "properties.predicateExpression", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "audit_actions_and_groups": {"key": "properties.auditActionsAndGroups", "type": "[str]"},
        "is_storage_secondary_key_in_use": {"key": "properties.isStorageSecondaryKeyInUse", "type": "bool"},
        "is_azure_monitor_target_enabled": {"key": "properties.isAzureMonitorTargetEnabled", "type": "bool"},
        "queue_delay_ms": {"key": "properties.queueDelayMs", "type": "int"},
        "is_managed_identity_in_use": {"key": "properties.isManagedIdentityInUse", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "storage_account_subscription_id": {"key": "properties.storageAccountSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        predicate_expression: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        is_managed_identity_in_use: Optional[bool] = None,
        state: Optional[Union[str, "_models.BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword predicate_expression: Specifies condition of where clause when creating an audit.
        :paramtype predicate_expression: str
        :keyword retention_days: Specifies the number of days to keep in the audit logs in the storage
         account.
        :paramtype retention_days: int
        :keyword audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

         The recommended set of action groups to use is the following combination - this will audit all
         the queries and stored procedures executed against the database, as well as successful and
         failed logins:

         BATCH_COMPLETED_GROUP,
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
         FAILED_DATABASE_AUTHENTICATION_GROUP.

         This above combination is also the set that is configured by default when enabling auditing
         from the Azure portal.

         The supported action groups to audit are (note: choose only specific groups that cover your
         auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

         APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
         BACKUP_RESTORE_GROUP
         DATABASE_LOGOUT_GROUP
         DATABASE_OBJECT_CHANGE_GROUP
         DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
         DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
         DATABASE_OPERATION_GROUP
         DATABASE_PERMISSION_CHANGE_GROUP
         DATABASE_PRINCIPAL_CHANGE_GROUP
         DATABASE_PRINCIPAL_IMPERSONATION_GROUP
         DATABASE_ROLE_MEMBER_CHANGE_GROUP
         FAILED_DATABASE_AUTHENTICATION_GROUP
         SCHEMA_OBJECT_ACCESS_GROUP
         SCHEMA_OBJECT_CHANGE_GROUP
         SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
         SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
         USER_CHANGE_PASSWORD_GROUP
         BATCH_STARTED_GROUP
         BATCH_COMPLETED_GROUP
         DBCC_GROUP
         DATABASE_OWNERSHIP_CHANGE_GROUP
         DATABASE_CHANGE_GROUP
         LEDGER_OPERATION_GROUP

         These are groups that cover all sql statements and stored procedures executed against the
         database, and should not be used in combination with other groups as this will result in
         duplicate audit logs.

         For more information, see `Database-Level Audit Action Groups
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

         For Database auditing policy, specific Actions can also be specified (note that Actions cannot
         be specified for Server auditing policy). The supported actions to audit are:
         SELECT
         UPDATE
         INSERT
         DELETE
         EXECUTE
         RECEIVE
         REFERENCES

         The general form for defining an action to be audited is:
         {action} ON {object} BY {principal}

         Note that :code:`<object>` in the above format can refer to an object like a table, view, or
         stored procedure, or an entire database or schema. For the latter cases, the forms
         DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

         For example:
         SELECT on dbo.myTable by public
         SELECT on DATABASE::myDatabase by public
         SELECT on SCHEMA::mySchema by public

         For more information, see `Database-Level Audit Actions
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
        :paramtype audit_actions_and_groups: list[str]
        :keyword is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is
         the storage's secondary key.
        :paramtype is_storage_secondary_key_in_use: bool
        :keyword is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
         Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
         'IsAzureMonitorTargetEnabled' as true.

         When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
         diagnostic logs category on the database should be also created.
         Note that for server level audit you should use the 'master' database as {databaseName}.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_azure_monitor_target_enabled: bool
        :keyword queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
         audit actions are forced to be processed.
         The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :paramtype queue_delay_ms: int
        :keyword is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
         storage.
        :paramtype is_managed_identity_in_use: bool
        :keyword state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled is required.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the auditing storage
         account.
         If state is Enabled and storageEndpoint is specified, not specifying the
         storageAccountAccessKey will use SQL server system-assigned managed identity to access the
         storage.
         Prerequisites for using managed identity authentication:


         #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
         #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
         Contributor' RBAC role to the server identity.
            For more information, see `Auditing to storage using Managed Identity authentication
         <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
        :paramtype storage_account_access_key: str
        :keyword storage_account_subscription_id: Specifies the blob storage subscription Id.
        :paramtype storage_account_subscription_id: str
        """
        super().__init__(**kwargs)
        self.predicate_expression = predicate_expression
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.is_managed_identity_in_use = is_managed_identity_in_use
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ExtendedDatabaseBlobAuditingPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of database extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ExtendedDatabaseBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtendedDatabaseBlobAuditingPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ExtendedDatabaseBlobAuditingPolicy"]] = None
        self.next_link: Optional[str] = None


class ExtendedServerBlobAuditingPolicy(ProxyResource):
    """An extended server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled, devops
     logs will be sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
     'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true

     When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
     diagnostic logs category on the master database should also be created.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_devops_audit_enabled: bool
    :ivar predicate_expression: Specifies condition of where clause when creating an audit.
    :vartype predicate_expression: str
    :ivar retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :vartype retention_days: int
    :ivar audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:

     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.

     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.

     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     DBCC_GROUP
     DATABASE_OWNERSHIP_CHANGE_GROUP
     DATABASE_CHANGE_GROUP
     LEDGER_OPERATION_GROUP

     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.

     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES

     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}

     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public

     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :vartype audit_actions_and_groups: list[str]
    :ivar is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :vartype is_storage_secondary_key_in_use: bool
    :ivar is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.

     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_azure_monitor_target_enabled: bool
    :ivar queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit
     actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :vartype queue_delay_ms: int
    :ivar is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
     storage.
    :vartype is_managed_identity_in_use: bool
    :ivar state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:


     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :vartype storage_account_access_key: str
    :ivar storage_account_subscription_id: Specifies the blob storage subscription Id.
    :vartype storage_account_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_devops_audit_enabled": {"key": "properties.isDevopsAuditEnabled", "type": "bool"},
        "predicate_expression": {"key": "properties.predicateExpression", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "audit_actions_and_groups": {"key": "properties.auditActionsAndGroups", "type": "[str]"},
        "is_storage_secondary_key_in_use": {"key": "properties.isStorageSecondaryKeyInUse", "type": "bool"},
        "is_azure_monitor_target_enabled": {"key": "properties.isAzureMonitorTargetEnabled", "type": "bool"},
        "queue_delay_ms": {"key": "properties.queueDelayMs", "type": "int"},
        "is_managed_identity_in_use": {"key": "properties.isManagedIdentityInUse", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "storage_account_subscription_id": {"key": "properties.storageAccountSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_devops_audit_enabled: Optional[bool] = None,
        predicate_expression: Optional[str] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        is_managed_identity_in_use: Optional[bool] = None,
        state: Optional[Union[str, "_models.BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled,
         devops logs will be sent to Azure Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
         'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true

         When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
         diagnostic logs category on the master database should also be created.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_devops_audit_enabled: bool
        :keyword predicate_expression: Specifies condition of where clause when creating an audit.
        :paramtype predicate_expression: str
        :keyword retention_days: Specifies the number of days to keep in the audit logs in the storage
         account.
        :paramtype retention_days: int
        :keyword audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

         The recommended set of action groups to use is the following combination - this will audit all
         the queries and stored procedures executed against the database, as well as successful and
         failed logins:

         BATCH_COMPLETED_GROUP,
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
         FAILED_DATABASE_AUTHENTICATION_GROUP.

         This above combination is also the set that is configured by default when enabling auditing
         from the Azure portal.

         The supported action groups to audit are (note: choose only specific groups that cover your
         auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

         APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
         BACKUP_RESTORE_GROUP
         DATABASE_LOGOUT_GROUP
         DATABASE_OBJECT_CHANGE_GROUP
         DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
         DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
         DATABASE_OPERATION_GROUP
         DATABASE_PERMISSION_CHANGE_GROUP
         DATABASE_PRINCIPAL_CHANGE_GROUP
         DATABASE_PRINCIPAL_IMPERSONATION_GROUP
         DATABASE_ROLE_MEMBER_CHANGE_GROUP
         FAILED_DATABASE_AUTHENTICATION_GROUP
         SCHEMA_OBJECT_ACCESS_GROUP
         SCHEMA_OBJECT_CHANGE_GROUP
         SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
         SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
         USER_CHANGE_PASSWORD_GROUP
         BATCH_STARTED_GROUP
         BATCH_COMPLETED_GROUP
         DBCC_GROUP
         DATABASE_OWNERSHIP_CHANGE_GROUP
         DATABASE_CHANGE_GROUP
         LEDGER_OPERATION_GROUP

         These are groups that cover all sql statements and stored procedures executed against the
         database, and should not be used in combination with other groups as this will result in
         duplicate audit logs.

         For more information, see `Database-Level Audit Action Groups
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

         For Database auditing policy, specific Actions can also be specified (note that Actions cannot
         be specified for Server auditing policy). The supported actions to audit are:
         SELECT
         UPDATE
         INSERT
         DELETE
         EXECUTE
         RECEIVE
         REFERENCES

         The general form for defining an action to be audited is:
         {action} ON {object} BY {principal}

         Note that :code:`<object>` in the above format can refer to an object like a table, view, or
         stored procedure, or an entire database or schema. For the latter cases, the forms
         DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

         For example:
         SELECT on dbo.myTable by public
         SELECT on DATABASE::myDatabase by public
         SELECT on SCHEMA::mySchema by public

         For more information, see `Database-Level Audit Actions
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
        :paramtype audit_actions_and_groups: list[str]
        :keyword is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is
         the storage's secondary key.
        :paramtype is_storage_secondary_key_in_use: bool
        :keyword is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
         Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
         'IsAzureMonitorTargetEnabled' as true.

         When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
         diagnostic logs category on the database should be also created.
         Note that for server level audit you should use the 'master' database as {databaseName}.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_azure_monitor_target_enabled: bool
        :keyword queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
         audit actions are forced to be processed.
         The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :paramtype queue_delay_ms: int
        :keyword is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
         storage.
        :paramtype is_managed_identity_in_use: bool
        :keyword state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled is required.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the auditing storage
         account.
         If state is Enabled and storageEndpoint is specified, not specifying the
         storageAccountAccessKey will use SQL server system-assigned managed identity to access the
         storage.
         Prerequisites for using managed identity authentication:


         #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
         #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
         Contributor' RBAC role to the server identity.
            For more information, see `Auditing to storage using Managed Identity authentication
         <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
        :paramtype storage_account_access_key: str
        :keyword storage_account_subscription_id: Specifies the blob storage subscription Id.
        :paramtype storage_account_subscription_id: str
        """
        super().__init__(**kwargs)
        self.is_devops_audit_enabled = is_devops_audit_enabled
        self.predicate_expression = predicate_expression
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.is_managed_identity_in_use = is_managed_identity_in_use
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ExtendedServerBlobAuditingPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of server extended auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ExtendedServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExtendedServerBlobAuditingPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ExtendedServerBlobAuditingPolicy"]] = None
        self.next_link: Optional[str] = None


class FailoverGroup(ProxyResource):
    """A failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar read_write_endpoint: Read-write endpoint of the failover group instance.
    :vartype read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :ivar read_only_endpoint: Read-only endpoint of the failover group instance.
    :vartype read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group instance. Known values
     are: "Primary" and "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :ivar partner_servers: List of partner server information for the failover group.
    :vartype partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
    :ivar databases: List of databases in the failover group.
    :vartype databases: list[str]
    :ivar secondary_type: Databases secondary type on partner server. Known values are: "Geo" and
     "Standby".
    :vartype secondary_type: str or ~azure.mgmt.sql.models.FailoverGroupDatabasesSecondaryType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "replication_role": {"readonly": True},
        "replication_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "read_write_endpoint": {"key": "properties.readWriteEndpoint", "type": "FailoverGroupReadWriteEndpoint"},
        "read_only_endpoint": {"key": "properties.readOnlyEndpoint", "type": "FailoverGroupReadOnlyEndpoint"},
        "replication_role": {"key": "properties.replicationRole", "type": "str"},
        "replication_state": {"key": "properties.replicationState", "type": "str"},
        "partner_servers": {"key": "properties.partnerServers", "type": "[PartnerInfo]"},
        "databases": {"key": "properties.databases", "type": "[str]"},
        "secondary_type": {"key": "properties.secondaryType", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        read_write_endpoint: Optional["_models.FailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["_models.FailoverGroupReadOnlyEndpoint"] = None,
        partner_servers: Optional[List["_models.PartnerInfo"]] = None,
        databases: Optional[List[str]] = None,
        secondary_type: Optional[Union[str, "_models.FailoverGroupDatabasesSecondaryType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword read_write_endpoint: Read-write endpoint of the failover group instance.
        :paramtype read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
        :keyword read_only_endpoint: Read-only endpoint of the failover group instance.
        :paramtype read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
        :keyword partner_servers: List of partner server information for the failover group.
        :paramtype partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
        :keyword databases: List of databases in the failover group.
        :paramtype databases: list[str]
        :keyword secondary_type: Databases secondary type on partner server. Known values are: "Geo"
         and "Standby".
        :paramtype secondary_type: str or ~azure.mgmt.sql.models.FailoverGroupDatabasesSecondaryType
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.tags = tags
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.replication_role: Optional[Union[str, "_models.FailoverGroupReplicationRole"]] = None
        self.replication_state: Optional[str] = None
        self.partner_servers = partner_servers
        self.databases = databases
        self.secondary_type = secondary_type


class FailoverGroupListResult(_serialization.Model):
    """A list of failover groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.FailoverGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FailoverGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.FailoverGroup"]] = None
        self.next_link: Optional[str] = None


class FailoverGroupReadOnlyEndpoint(_serialization.Model):
    """Read-only endpoint of the failover group instance.

    :ivar failover_policy: Failover policy of the read-only endpoint for the failover group. Known
     values are: "Disabled" and "Enabled".
    :vartype failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    :ivar target_server: The target partner server where the read-only endpoint points to.
    :vartype target_server: str
    """

    _attribute_map = {
        "failover_policy": {"key": "failoverPolicy", "type": "str"},
        "target_server": {"key": "targetServer", "type": "str"},
    }

    def __init__(
        self,
        *,
        failover_policy: Optional[Union[str, "_models.ReadOnlyEndpointFailoverPolicy"]] = None,
        target_server: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failover_policy: Failover policy of the read-only endpoint for the failover group.
         Known values are: "Disabled" and "Enabled".
        :paramtype failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
        :keyword target_server: The target partner server where the read-only endpoint points to.
        :paramtype target_server: str
        """
        super().__init__(**kwargs)
        self.failover_policy = failover_policy
        self.target_server = target_server


class FailoverGroupReadWriteEndpoint(_serialization.Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to server.

    :ivar failover_policy: Failover policy of the read-write endpoint for the failover group. If
     failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Required.
     Known values are: "Manual" and "Automatic".
    :vartype failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :ivar failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss
     is attempted for the read-write endpoint. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required.
    :vartype failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        "failover_policy": {"required": True},
    }

    _attribute_map = {
        "failover_policy": {"key": "failoverPolicy", "type": "str"},
        "failover_with_data_loss_grace_period_minutes": {
            "key": "failoverWithDataLossGracePeriodMinutes",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        failover_policy: Union[str, "_models.ReadWriteEndpointFailoverPolicy"],
        failover_with_data_loss_grace_period_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failover_policy: Failover policy of the read-write endpoint for the failover group. If
         failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Required.
         Known values are: "Manual" and "Automatic".
        :paramtype failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
        :keyword failover_with_data_loss_grace_period_minutes: Grace period before failover with data
         loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
         failoverWithDataLossGracePeriodMinutes is required.
        :paramtype failover_with_data_loss_grace_period_minutes: int
        """
        super().__init__(**kwargs)
        self.failover_policy = failover_policy
        self.failover_with_data_loss_grace_period_minutes = failover_with_data_loss_grace_period_minutes


class FailoverGroupUpdate(_serialization.Model):
    """A failover group update request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar read_write_endpoint: Read-write endpoint of the failover group instance.
    :vartype read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
    :ivar read_only_endpoint: Read-only endpoint of the failover group instance.
    :vartype read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
    :ivar databases: List of databases in the failover group.
    :vartype databases: list[str]
    :ivar partner_servers: List of partner server information for the failover group.
    :vartype partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
    :ivar secondary_type: Databases secondary type on partner server. Known values are: "Geo" and
     "Standby".
    :vartype secondary_type: str or ~azure.mgmt.sql.models.FailoverGroupDatabasesSecondaryType
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "read_write_endpoint": {"key": "properties.readWriteEndpoint", "type": "FailoverGroupReadWriteEndpoint"},
        "read_only_endpoint": {"key": "properties.readOnlyEndpoint", "type": "FailoverGroupReadOnlyEndpoint"},
        "databases": {"key": "properties.databases", "type": "[str]"},
        "partner_servers": {"key": "properties.partnerServers", "type": "[PartnerInfo]"},
        "secondary_type": {"key": "properties.secondaryType", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        read_write_endpoint: Optional["_models.FailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["_models.FailoverGroupReadOnlyEndpoint"] = None,
        databases: Optional[List[str]] = None,
        partner_servers: Optional[List["_models.PartnerInfo"]] = None,
        secondary_type: Optional[Union[str, "_models.FailoverGroupDatabasesSecondaryType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword read_write_endpoint: Read-write endpoint of the failover group instance.
        :paramtype read_write_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadWriteEndpoint
        :keyword read_only_endpoint: Read-only endpoint of the failover group instance.
        :paramtype read_only_endpoint: ~azure.mgmt.sql.models.FailoverGroupReadOnlyEndpoint
        :keyword databases: List of databases in the failover group.
        :paramtype databases: list[str]
        :keyword partner_servers: List of partner server information for the failover group.
        :paramtype partner_servers: list[~azure.mgmt.sql.models.PartnerInfo]
        :keyword secondary_type: Databases secondary type on partner server. Known values are: "Geo"
         and "Standby".
        :paramtype secondary_type: str or ~azure.mgmt.sql.models.FailoverGroupDatabasesSecondaryType
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.databases = databases
        self.partner_servers = partner_servers
        self.secondary_type = secondary_type


class ResourceWithWritableName(_serialization.Model):
    """ARM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name = name
        self.type: Optional[str] = None


class ProxyResourceWithWritableName(ResourceWithWritableName):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """


class FirewallRule(ProxyResourceWithWritableName):
    """A server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_ip_address: The start IP address of the firewall rule. Must be IPv4 format. Use
     value '0.0.0.0' for all Azure-internal IP addresses.
    :vartype start_ip_address: str
    :ivar end_ip_address: The end IP address of the firewall rule. Must be IPv4 format. Must be
     greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP
     addresses.
    :vartype end_ip_address: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_ip_address": {"key": "properties.startIpAddress", "type": "str"},
        "end_ip_address": {"key": "properties.endIpAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_ip_address: Optional[str] = None,
        end_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword start_ip_address: The start IP address of the firewall rule. Must be IPv4 format. Use
         value '0.0.0.0' for all Azure-internal IP addresses.
        :paramtype start_ip_address: str
        :keyword end_ip_address: The end IP address of the firewall rule. Must be IPv4 format. Must be
         greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP
         addresses.
        :paramtype end_ip_address: str
        """
        super().__init__(name=name, **kwargs)
        self.start_ip_address = start_ip_address
        self.end_ip_address = end_ip_address


class FirewallRuleList(_serialization.Model):
    """A list of server firewall rules.

    :ivar values:
    :vartype values: list[~azure.mgmt.sql.models.FirewallRule]
    """

    _attribute_map = {
        "values": {"key": "values", "type": "[FirewallRule]"},
    }

    def __init__(self, *, values: Optional[List["_models.FirewallRule"]] = None, **kwargs: Any) -> None:
        """
        :keyword values:
        :paramtype values: list[~azure.mgmt.sql.models.FirewallRule]
        """
        super().__init__(**kwargs)
        self.values = values


class FirewallRuleListResult(_serialization.Model):
    """The response to a list firewall rules request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.FirewallRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.FirewallRule"]] = None
        self.next_link: Optional[str] = None


class FreeLimitExhaustionBehaviorCapability(_serialization.Model):
    """Supported free limit exhaustion behavior options.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar exhaustion_behavior_type: Free limit exhaustion behavior type. Known values are:
     "AutoPause" and "BillOverUsage".
    :vartype exhaustion_behavior_type: str or ~azure.mgmt.sql.models.FreeLimitExhaustionBehavior
    :ivar status: Free limit exhaustion behavior status. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    """

    _validation = {
        "exhaustion_behavior_type": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "exhaustion_behavior_type": {"key": "exhaustionBehaviorType", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.exhaustion_behavior_type: Optional[Union[str, "_models.FreeLimitExhaustionBehavior"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None


class GeoBackupPolicy(ProxyResource):
    """A Geo backup policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Backup policy location.
    :vartype location: str
    :ivar kind: Kind of geo backup policy.  This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar state: The state of the geo backup policy. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.GeoBackupPolicyState
    :ivar storage_type: The storage type of the geo backup policy.
    :vartype storage_type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "kind": {"readonly": True},
        "storage_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_type": {"key": "properties.storageType", "type": "str"},
    }

    def __init__(self, *, state: Optional[Union[str, "_models.GeoBackupPolicyState"]] = None, **kwargs: Any) -> None:
        """
        :keyword state: The state of the geo backup policy. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.GeoBackupPolicyState
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.kind: Optional[str] = None
        self.state = state
        self.storage_type: Optional[str] = None


class GeoBackupPolicyListResult(_serialization.Model):
    """The list of geo backup policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.GeoBackupPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GeoBackupPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.GeoBackupPolicy"]] = None
        self.next_link: Optional[str] = None


class ImportExistingDatabaseDefinition(_serialization.Model):
    """Contains the information necessary to perform import operation for existing database.

    All required parameters must be populated in order to send to server.

    :ivar storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
     ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
     "ManagedIdentity".
    :vartype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :ivar storage_key: Storage key for the storage account. If StorageKeyType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype storage_key: str
    :ivar storage_uri: Storage Uri. Required.
    :vartype storage_uri: str
    :ivar administrator_login: Administrator login name. If AuthenticationType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype administrator_login: str
    :ivar administrator_login_password: Administrator login password. If AuthenticationType is
     ManagedIdentity, this field should not be specified.
    :vartype administrator_login_password: str
    :ivar authentication_type: Type of credentials provided for access to the target SQL server:
     SQL, ADPassword or ManagedIdentity.
    :vartype authentication_type: str
    :ivar network_isolation: Optional resource information to enable network isolation for request.
    :vartype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        "storage_key_type": {"required": True},
        "storage_key": {"required": True},
        "storage_uri": {"required": True},
        "administrator_login": {"required": True},
    }

    _attribute_map = {
        "storage_key_type": {"key": "storageKeyType", "type": "str"},
        "storage_key": {"key": "storageKey", "type": "str"},
        "storage_uri": {"key": "storageUri", "type": "str"},
        "administrator_login": {"key": "administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "administratorLoginPassword", "type": "str"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "network_isolation": {"key": "networkIsolation", "type": "NetworkIsolationSettings"},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "_models.StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        administrator_login_password: Optional[str] = None,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["_models.NetworkIsolationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
         ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
         "ManagedIdentity".
        :paramtype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
        :keyword storage_key: Storage key for the storage account. If StorageKeyType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype storage_key: str
        :keyword storage_uri: Storage Uri. Required.
        :paramtype storage_uri: str
        :keyword administrator_login: Administrator login name. If AuthenticationType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype administrator_login: str
        :keyword administrator_login_password: Administrator login password. If AuthenticationType is
         ManagedIdentity, this field should not be specified.
        :paramtype administrator_login_password: str
        :keyword authentication_type: Type of credentials provided for access to the target SQL server:
         SQL, ADPassword or ManagedIdentity.
        :paramtype authentication_type: str
        :keyword network_isolation: Optional resource information to enable network isolation for
         request.
        :paramtype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
        """
        super().__init__(**kwargs)
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class ImportExportExtensionsOperationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Import export operation extensions list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ImportExportExtensionsOperationResult]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ImportExportExtensionsOperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ImportExportExtensionsOperationResult"]] = None
        self.next_link: Optional[str] = None


class ImportExportExtensionsOperationResult(ProxyResource):
    """An Extension operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar last_modified_time: Last modified time.
    :vartype last_modified_time: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar blob_uri: Blob URI.
    :vartype blob_uri: str
    :ivar private_endpoint_connections: Gets the status of private endpoints associated with this
     request.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.PrivateEndpointConnectionRequestStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "request_id": {"readonly": True},
        "request_type": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "server_name": {"readonly": True},
        "database_name": {"readonly": True},
        "status": {"readonly": True},
        "error_message": {"readonly": True},
        "queued_time": {"readonly": True},
        "blob_uri": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "request_id": {"key": "properties.requestId", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "str"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "queued_time": {"key": "properties.queuedTime", "type": "str"},
        "blob_uri": {"key": "properties.blobUri", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnectionRequestStatus]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.request_id: Optional[str] = None
        self.request_type: Optional[str] = None
        self.last_modified_time: Optional[str] = None
        self.server_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.status: Optional[str] = None
        self.error_message: Optional[str] = None
        self.queued_time: Optional[str] = None
        self.blob_uri: Optional[str] = None
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnectionRequestStatus"]] = None


class ImportExportOperationResult(ProxyResource):
    """An ImportExport operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar last_modified_time: Last modified time.
    :vartype last_modified_time: str
    :ivar blob_uri: Blob Uri.
    :vartype blob_uri: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar database_name: Database name.
    :vartype database_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    :ivar private_endpoint_connections: Gets the status of private endpoints associated with this
     request.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.PrivateEndpointConnectionRequestStatus]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "request_id": {"readonly": True},
        "request_type": {"readonly": True},
        "queued_time": {"readonly": True},
        "last_modified_time": {"readonly": True},
        "blob_uri": {"readonly": True},
        "server_name": {"readonly": True},
        "database_name": {"readonly": True},
        "status": {"readonly": True},
        "error_message": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "request_id": {"key": "properties.requestId", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "queued_time": {"key": "properties.queuedTime", "type": "str"},
        "last_modified_time": {"key": "properties.lastModifiedTime", "type": "str"},
        "blob_uri": {"key": "properties.blobUri", "type": "str"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnectionRequestStatus]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.request_id: Optional[str] = None
        self.request_type: Optional[str] = None
        self.queued_time: Optional[str] = None
        self.last_modified_time: Optional[str] = None
        self.blob_uri: Optional[str] = None
        self.server_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.status: Optional[str] = None
        self.error_message: Optional[str] = None
        self.private_endpoint_connections: Optional[List["_models.PrivateEndpointConnectionRequestStatus"]] = None


class ImportNewDatabaseDefinition(_serialization.Model):
    """Contains the information necessary to perform import operation for new database.

    All required parameters must be populated in order to send to server.

    :ivar database_name: Name of the import database.
    :vartype database_name: str
    :ivar edition: Edition of the import database.
    :vartype edition: str
    :ivar service_objective_name: Service level objective name of the import database.
    :vartype service_objective_name: str
    :ivar max_size_bytes: Max size in bytes for the import database.
    :vartype max_size_bytes: str
    :ivar storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
     ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
     "ManagedIdentity".
    :vartype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
    :ivar storage_key: Storage key for the storage account. If StorageKeyType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype storage_key: str
    :ivar storage_uri: Storage Uri. Required.
    :vartype storage_uri: str
    :ivar administrator_login: Administrator login name. If AuthenticationType is ManagedIdentity,
     this field should specify the Managed Identity's resource ID. Required.
    :vartype administrator_login: str
    :ivar administrator_login_password: Administrator login password. If AuthenticationType is
     ManagedIdentity, this field should not be specified.
    :vartype administrator_login_password: str
    :ivar authentication_type: Type of credentials provided for access to the target SQL server:
     SQL, ADPassword or ManagedIdentity.
    :vartype authentication_type: str
    :ivar network_isolation: Optional resource information to enable network isolation for request.
    :vartype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
    """

    _validation = {
        "storage_key_type": {"required": True},
        "storage_key": {"required": True},
        "storage_uri": {"required": True},
        "administrator_login": {"required": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "edition": {"key": "edition", "type": "str"},
        "service_objective_name": {"key": "serviceObjectiveName", "type": "str"},
        "max_size_bytes": {"key": "maxSizeBytes", "type": "str"},
        "storage_key_type": {"key": "storageKeyType", "type": "str"},
        "storage_key": {"key": "storageKey", "type": "str"},
        "storage_uri": {"key": "storageUri", "type": "str"},
        "administrator_login": {"key": "administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "administratorLoginPassword", "type": "str"},
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "network_isolation": {"key": "networkIsolation", "type": "NetworkIsolationSettings"},
    }

    def __init__(
        self,
        *,
        storage_key_type: Union[str, "_models.StorageKeyType"],
        storage_key: str,
        storage_uri: str,
        administrator_login: str,
        database_name: Optional[str] = None,
        edition: Optional[str] = None,
        service_objective_name: Optional[str] = None,
        max_size_bytes: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        authentication_type: Optional[str] = None,
        network_isolation: Optional["_models.NetworkIsolationSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_name: Name of the import database.
        :paramtype database_name: str
        :keyword edition: Edition of the import database.
        :paramtype edition: str
        :keyword service_objective_name: Service level objective name of the import database.
        :paramtype service_objective_name: str
        :keyword max_size_bytes: Max size in bytes for the import database.
        :paramtype max_size_bytes: str
        :keyword storage_key_type: Storage key type: StorageAccessKey, SharedAccessKey, or
         ManagedIdentity. Required. Known values are: "SharedAccessKey", "StorageAccessKey", and
         "ManagedIdentity".
        :paramtype storage_key_type: str or ~azure.mgmt.sql.models.StorageKeyType
        :keyword storage_key: Storage key for the storage account. If StorageKeyType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype storage_key: str
        :keyword storage_uri: Storage Uri. Required.
        :paramtype storage_uri: str
        :keyword administrator_login: Administrator login name. If AuthenticationType is
         ManagedIdentity, this field should specify the Managed Identity's resource ID. Required.
        :paramtype administrator_login: str
        :keyword administrator_login_password: Administrator login password. If AuthenticationType is
         ManagedIdentity, this field should not be specified.
        :paramtype administrator_login_password: str
        :keyword authentication_type: Type of credentials provided for access to the target SQL server:
         SQL, ADPassword or ManagedIdentity.
        :paramtype authentication_type: str
        :keyword network_isolation: Optional resource information to enable network isolation for
         request.
        :paramtype network_isolation: ~azure.mgmt.sql.models.NetworkIsolationSettings
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.edition = edition
        self.service_objective_name = service_objective_name
        self.max_size_bytes = max_size_bytes
        self.storage_key_type = storage_key_type
        self.storage_key = storage_key
        self.storage_uri = storage_uri
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.authentication_type = authentication_type
        self.network_isolation = network_isolation


class InstanceFailoverGroup(ProxyResource):
    """An instance failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar secondary_type: Type of the geo-secondary instance. Set 'Standby' if the instance is used
     as a DR option only. Known values are: "Geo" and "Standby".
    :vartype secondary_type: str or ~azure.mgmt.sql.models.SecondaryInstanceType
    :ivar read_write_endpoint: Read-write endpoint of the failover group instance.
    :vartype read_write_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadWriteEndpoint
    :ivar read_only_endpoint: Read-only endpoint of the failover group instance.
    :vartype read_only_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadOnlyEndpoint
    :ivar replication_role: Local replication role of the failover group instance. Known values
     are: "Primary" and "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    :ivar replication_state: Replication state of the failover group instance.
    :vartype replication_state: str
    :ivar partner_regions: Partner region information for the failover group.
    :vartype partner_regions: list[~azure.mgmt.sql.models.PartnerRegionInfo]
    :ivar managed_instance_pairs: List of managed instance pairs in the failover group.
    :vartype managed_instance_pairs: list[~azure.mgmt.sql.models.ManagedInstancePairInfo]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "replication_role": {"readonly": True},
        "replication_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "secondary_type": {"key": "properties.secondaryType", "type": "str"},
        "read_write_endpoint": {
            "key": "properties.readWriteEndpoint",
            "type": "InstanceFailoverGroupReadWriteEndpoint",
        },
        "read_only_endpoint": {"key": "properties.readOnlyEndpoint", "type": "InstanceFailoverGroupReadOnlyEndpoint"},
        "replication_role": {"key": "properties.replicationRole", "type": "str"},
        "replication_state": {"key": "properties.replicationState", "type": "str"},
        "partner_regions": {"key": "properties.partnerRegions", "type": "[PartnerRegionInfo]"},
        "managed_instance_pairs": {"key": "properties.managedInstancePairs", "type": "[ManagedInstancePairInfo]"},
    }

    def __init__(
        self,
        *,
        secondary_type: Optional[Union[str, "_models.SecondaryInstanceType"]] = None,
        read_write_endpoint: Optional["_models.InstanceFailoverGroupReadWriteEndpoint"] = None,
        read_only_endpoint: Optional["_models.InstanceFailoverGroupReadOnlyEndpoint"] = None,
        partner_regions: Optional[List["_models.PartnerRegionInfo"]] = None,
        managed_instance_pairs: Optional[List["_models.ManagedInstancePairInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secondary_type: Type of the geo-secondary instance. Set 'Standby' if the instance is
         used as a DR option only. Known values are: "Geo" and "Standby".
        :paramtype secondary_type: str or ~azure.mgmt.sql.models.SecondaryInstanceType
        :keyword read_write_endpoint: Read-write endpoint of the failover group instance.
        :paramtype read_write_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadWriteEndpoint
        :keyword read_only_endpoint: Read-only endpoint of the failover group instance.
        :paramtype read_only_endpoint: ~azure.mgmt.sql.models.InstanceFailoverGroupReadOnlyEndpoint
        :keyword partner_regions: Partner region information for the failover group.
        :paramtype partner_regions: list[~azure.mgmt.sql.models.PartnerRegionInfo]
        :keyword managed_instance_pairs: List of managed instance pairs in the failover group.
        :paramtype managed_instance_pairs: list[~azure.mgmt.sql.models.ManagedInstancePairInfo]
        """
        super().__init__(**kwargs)
        self.secondary_type = secondary_type
        self.read_write_endpoint = read_write_endpoint
        self.read_only_endpoint = read_only_endpoint
        self.replication_role: Optional[Union[str, "_models.InstanceFailoverGroupReplicationRole"]] = None
        self.replication_state: Optional[str] = None
        self.partner_regions = partner_regions
        self.managed_instance_pairs = managed_instance_pairs


class InstanceFailoverGroupListResult(_serialization.Model):
    """A list of instance failover groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.InstanceFailoverGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InstanceFailoverGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.InstanceFailoverGroup"]] = None
        self.next_link: Optional[str] = None


class InstanceFailoverGroupReadOnlyEndpoint(_serialization.Model):
    """Read-only endpoint of the failover group instance.

    :ivar failover_policy: Failover policy of the read-only endpoint for the failover group. Known
     values are: "Disabled" and "Enabled".
    :vartype failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
    """

    _attribute_map = {
        "failover_policy": {"key": "failoverPolicy", "type": "str"},
    }

    def __init__(
        self, *, failover_policy: Optional[Union[str, "_models.ReadOnlyEndpointFailoverPolicy"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword failover_policy: Failover policy of the read-only endpoint for the failover group.
         Known values are: "Disabled" and "Enabled".
        :paramtype failover_policy: str or ~azure.mgmt.sql.models.ReadOnlyEndpointFailoverPolicy
        """
        super().__init__(**kwargs)
        self.failover_policy = failover_policy


class InstanceFailoverGroupReadWriteEndpoint(_serialization.Model):
    """Read-write endpoint of the failover group instance.

    All required parameters must be populated in order to send to server.

    :ivar failover_policy: Failover policy of the read-write endpoint for the failover group. If
     failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Required.
     Known values are: "Manual" and "Automatic".
    :vartype failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
    :ivar failover_with_data_loss_grace_period_minutes: Grace period before failover with data loss
     is attempted for the read-write endpoint. If failoverPolicy is Automatic then
     failoverWithDataLossGracePeriodMinutes is required.
    :vartype failover_with_data_loss_grace_period_minutes: int
    """

    _validation = {
        "failover_policy": {"required": True},
    }

    _attribute_map = {
        "failover_policy": {"key": "failoverPolicy", "type": "str"},
        "failover_with_data_loss_grace_period_minutes": {
            "key": "failoverWithDataLossGracePeriodMinutes",
            "type": "int",
        },
    }

    def __init__(
        self,
        *,
        failover_policy: Union[str, "_models.ReadWriteEndpointFailoverPolicy"],
        failover_with_data_loss_grace_period_minutes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword failover_policy: Failover policy of the read-write endpoint for the failover group. If
         failoverPolicy is Automatic then failoverWithDataLossGracePeriodMinutes is required. Required.
         Known values are: "Manual" and "Automatic".
        :paramtype failover_policy: str or ~azure.mgmt.sql.models.ReadWriteEndpointFailoverPolicy
        :keyword failover_with_data_loss_grace_period_minutes: Grace period before failover with data
         loss is attempted for the read-write endpoint. If failoverPolicy is Automatic then
         failoverWithDataLossGracePeriodMinutes is required.
        :paramtype failover_with_data_loss_grace_period_minutes: int
        """
        super().__init__(**kwargs)
        self.failover_policy = failover_policy
        self.failover_with_data_loss_grace_period_minutes = failover_with_data_loss_grace_period_minutes


class InstancePool(TrackedResource):
    """An Azure SQL instance pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar subnet_id: Resource ID of the subnet to place this instance pool in.
    :vartype subnet_id: str
    :ivar v_cores: Count of vCores belonging to this instance pool.
    :vartype v_cores: int
    :ivar license_type: The license type. Possible values are 'LicenseIncluded' (price for SQL
     license is included) and 'BasePrice' (without SQL license price). Known values are:
     "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
    :ivar dns_zone: The Dns Zone that the managed instance pool is in.
    :vartype dns_zone: str
    :ivar maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :vartype maintenance_configuration_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "dns_zone": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "v_cores": {"key": "properties.vCores", "type": "int"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "dns_zone": {"key": "properties.dnsZone", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        subnet_id: Optional[str] = None,
        v_cores: Optional[int] = None,
        license_type: Optional[Union[str, "_models.InstancePoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword subnet_id: Resource ID of the subnet to place this instance pool in.
        :paramtype subnet_id: str
        :keyword v_cores: Count of vCores belonging to this instance pool.
        :paramtype v_cores: int
        :keyword license_type: The license type. Possible values are 'LicenseIncluded' (price for SQL
         license is included) and 'BasePrice' (without SQL license price). Known values are:
         "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
        :keyword maintenance_configuration_id: Specifies maintenance configuration id to apply to this
         managed instance.
        :paramtype maintenance_configuration_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.subnet_id = subnet_id
        self.v_cores = v_cores
        self.license_type = license_type
        self.dns_zone: Optional[str] = None
        self.maintenance_configuration_id = maintenance_configuration_id


class InstancePoolEditionCapability(_serialization.Model):
    """The instance pool capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The instance pool version name.
    :vartype name: str
    :ivar supported_families: The supported families.
    :vartype supported_families: list[~azure.mgmt.sql.models.InstancePoolFamilyCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_families": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_families": {"key": "supportedFamilies", "type": "[InstancePoolFamilyCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_families: Optional[List["_models.InstancePoolFamilyCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class InstancePoolFamilyCapability(_serialization.Model):
    """The instance pool family capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values: list[~azure.mgmt.sql.models.InstancePoolVcoresCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_license_types": {"readonly": True},
        "supported_vcores_values": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_license_types": {"key": "supportedLicenseTypes", "type": "[LicenseTypeCapability]"},
        "supported_vcores_values": {"key": "supportedVcoresValues", "type": "[InstancePoolVcoresCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_license_types: Optional[List["_models.LicenseTypeCapability"]] = None
        self.supported_vcores_values: Optional[List["_models.InstancePoolVcoresCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class InstancePoolListResult(_serialization.Model):
    """A list of Azure SQL instance pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.InstancePool]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InstancePool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.InstancePool"]] = None
        self.next_link: Optional[str] = None


class InstancePoolOperation(ProxyResource):
    """A instance pool operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar instance_pool_name: The name of the instance pool the operation is being performed on.
    :vartype instance_pool_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar error_type: Error type (e.g. None, User). Known values are: "None" and "User".
    :vartype error_type: str or ~azure.mgmt.sql.models.ErrorType
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "instance_pool_name": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "percent_complete": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "error_type": {"readonly": True},
        "estimated_completion_time": {"readonly": True},
        "description": {"readonly": True},
        "is_cancellable": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "instance_pool_name": {"key": "properties.instancePoolName", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "error_type": {"key": "properties.errorType", "type": "str"},
        "estimated_completion_time": {"key": "properties.estimatedCompletionTime", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.instance_pool_name: Optional[str] = None
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.percent_complete: Optional[int] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.ManagementOperationState"]] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.error_type: Optional[Union[str, "_models.ErrorType"]] = None
        self.estimated_completion_time: Optional[datetime.datetime] = None
        self.description: Optional[str] = None
        self.is_cancellable: Optional[bool] = None


class InstancePoolOperationListResult(_serialization.Model):
    """The response to a list instance pool operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.InstancePoolOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[InstancePoolOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.InstancePoolOperation"]] = None
        self.next_link: Optional[str] = None


class InstancePoolUpdate(_serialization.Model):
    """An update to an Instance pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar subnet_id: Resource ID of the subnet to place this instance pool in.
    :vartype subnet_id: str
    :ivar v_cores: Count of vCores belonging to this instance pool.
    :vartype v_cores: int
    :ivar license_type: The license type. Possible values are 'LicenseIncluded' (price for SQL
     license is included) and 'BasePrice' (without SQL license price). Known values are:
     "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
    :ivar dns_zone: The Dns Zone that the managed instance pool is in.
    :vartype dns_zone: str
    :ivar maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :vartype maintenance_configuration_id: str
    """

    _validation = {
        "dns_zone": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "v_cores": {"key": "properties.vCores", "type": "int"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "dns_zone": {"key": "properties.dnsZone", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        subnet_id: Optional[str] = None,
        v_cores: Optional[int] = None,
        license_type: Optional[Union[str, "_models.InstancePoolLicenseType"]] = None,
        maintenance_configuration_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword subnet_id: Resource ID of the subnet to place this instance pool in.
        :paramtype subnet_id: str
        :keyword v_cores: Count of vCores belonging to this instance pool.
        :paramtype v_cores: int
        :keyword license_type: The license type. Possible values are 'LicenseIncluded' (price for SQL
         license is included) and 'BasePrice' (without SQL license price). Known values are:
         "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.InstancePoolLicenseType
        :keyword maintenance_configuration_id: Specifies maintenance configuration id to apply to this
         managed instance.
        :paramtype maintenance_configuration_id: str
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.tags = tags
        self.subnet_id = subnet_id
        self.v_cores = v_cores
        self.license_type = license_type
        self.dns_zone: Optional[str] = None
        self.maintenance_configuration_id = maintenance_configuration_id


class InstancePoolVcoresCapability(_serialization.Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar storage_limit: Storage limit.
    :vartype storage_limit: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
        "storage_limit": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "int"},
        "storage_limit": {"key": "storageLimit", "type": "MaxSizeCapability"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[int] = None
        self.storage_limit: Optional["_models.MaxSizeCapability"] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class IPv6FirewallRule(ProxyResourceWithWritableName):
    """An IPv6 server firewall rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar start_i_pv6_address: The start IP address of the firewall rule. Must be IPv6 format.
    :vartype start_i_pv6_address: str
    :ivar end_i_pv6_address: The end IP address of the firewall rule. Must be IPv6 format. Must be
     greater than or equal to startIpv6Address.
    :vartype end_i_pv6_address: str
    """

    _validation = {
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "start_i_pv6_address": {"key": "properties.startIPv6Address", "type": "str"},
        "end_i_pv6_address": {"key": "properties.endIPv6Address", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        start_i_pv6_address: Optional[str] = None,
        end_i_pv6_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Resource name.
        :paramtype name: str
        :keyword start_i_pv6_address: The start IP address of the firewall rule. Must be IPv6 format.
        :paramtype start_i_pv6_address: str
        :keyword end_i_pv6_address: The end IP address of the firewall rule. Must be IPv6 format. Must
         be greater than or equal to startIpv6Address.
        :paramtype end_i_pv6_address: str
        """
        super().__init__(name=name, **kwargs)
        self.start_i_pv6_address = start_i_pv6_address
        self.end_i_pv6_address = end_i_pv6_address


class IPv6FirewallRuleListResult(_serialization.Model):
    """The response to a list IPv6 firewall rules request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.IPv6FirewallRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IPv6FirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.IPv6FirewallRule"]] = None
        self.next_link: Optional[str] = None


class Job(ProxyResource):
    """A job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar description: User-defined description of the job.
    :vartype description: str
    :ivar version: The job version number.
    :vartype version: int
    :ivar schedule: Schedule properties of the job.
    :vartype schedule: ~azure.mgmt.sql.models.JobSchedule
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "version": {"key": "properties.version", "type": "int"},
        "schedule": {"key": "properties.schedule", "type": "JobSchedule"},
    }

    def __init__(
        self, *, description: str = "", schedule: Optional["_models.JobSchedule"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword description: User-defined description of the job.
        :paramtype description: str
        :keyword schedule: Schedule properties of the job.
        :paramtype schedule: ~azure.mgmt.sql.models.JobSchedule
        """
        super().__init__(**kwargs)
        self.description = description
        self.version: Optional[int] = None
        self.schedule = schedule


class JobAgent(TrackedResource):
    """An Azure SQL job agent.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar identity: The identity of the job agent.
    :vartype identity: ~azure.mgmt.sql.models.JobAgentIdentity
    :ivar database_id: Resource ID of the database to store job metadata in.
    :vartype database_id: str
    :ivar state: The state of the job agent. Known values are: "Creating", "Ready", "Updating",
     "Deleting", and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.JobAgentState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "JobAgentIdentity"},
        "database_id": {"key": "properties.databaseId", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.JobAgentIdentity"] = None,
        database_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword identity: The identity of the job agent.
        :paramtype identity: ~azure.mgmt.sql.models.JobAgentIdentity
        :keyword database_id: Resource ID of the database to store job metadata in.
        :paramtype database_id: str
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.identity = identity
        self.database_id = database_id
        self.state: Optional[Union[str, "_models.JobAgentState"]] = None


class JobAgentEditionCapability(_serialization.Model):
    """The job agent edition capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The job agent edition name.
    :vartype name: str
    :ivar supported_service_level_objectives: The list of supported service level objectives for
     the edition.
    :vartype supported_service_level_objectives:
     list[~azure.mgmt.sql.models.JobAgentServiceLevelObjectiveCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_service_level_objectives": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_service_level_objectives": {
            "key": "supportedServiceLevelObjectives",
            "type": "[JobAgentServiceLevelObjectiveCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_service_level_objectives: Optional[List["_models.JobAgentServiceLevelObjectiveCapability"]] = (
            None
        )
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class JobAgentIdentity(_serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    All required parameters must be populated in order to send to server.

    :ivar tenant_id: The job agent identity tenant id.
    :vartype tenant_id: str
    :ivar type: The job agent identity type. Required. Known values are: "None", "SystemAssigned",
     "UserAssigned", and "SystemAssignedUserAssigned".
    :vartype type: str or ~azure.mgmt.sql.models.JobAgentIdentityType
    :ivar user_assigned_identities: The resource ids of the user assigned identities to use.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.sql.models.JobAgentUserAssignedIdentity]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{JobAgentUserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.JobAgentIdentityType"],
        tenant_id: Optional[str] = None,
        user_assigned_identities: Optional[Dict[str, "_models.JobAgentUserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tenant_id: The job agent identity tenant id.
        :paramtype tenant_id: str
        :keyword type: The job agent identity type. Required. Known values are: "None",
         "SystemAssigned", "UserAssigned", and "SystemAssignedUserAssigned".
        :paramtype type: str or ~azure.mgmt.sql.models.JobAgentIdentityType
        :keyword user_assigned_identities: The resource ids of the user assigned identities to use.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.sql.models.JobAgentUserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.tenant_id = tenant_id
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class JobAgentListResult(_serialization.Model):
    """A list of Azure SQL job agents.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobAgent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobAgent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobAgent"]] = None
        self.next_link: Optional[str] = None


class JobAgentServiceLevelObjectiveCapability(_serialization.Model):
    """The job agent service level objective capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The service objective name.
    :vartype name: str
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "sku": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.sku: Optional["_models.Sku"] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class JobAgentUpdate(_serialization.Model):
    """An update to an Azure SQL job agent.

    :ivar identity: Managed identity assigned to job agent.
    :vartype identity: ~azure.mgmt.sql.models.JobAgentIdentity
    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "JobAgentIdentity"},
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.JobAgentIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Managed identity assigned to job agent.
        :paramtype identity: ~azure.mgmt.sql.models.JobAgentIdentity
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags


class JobAgentUserAssignedIdentity(_serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :ivar client_id: The Azure Active Directory client id.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class JobAgentVersionCapability(_serialization.Model):
    """The job agent version capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The job agent version name.
    :vartype name: str
    :ivar supported_editions: The list of supported editions.
    :vartype supported_editions: list[~azure.mgmt.sql.models.JobAgentEditionCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_editions": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_editions": {"key": "supportedEditions", "type": "[JobAgentEditionCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_editions: Optional[List["_models.JobAgentEditionCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class JobCredential(ProxyResource):
    """A stored credential that can be used by a job to connect to target databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar username: The credential user name.
    :vartype username: str
    :ivar password: The credential password.
    :vartype password: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "username": {"key": "properties.username", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
    }

    def __init__(self, *, username: Optional[str] = None, password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword username: The credential user name.
        :paramtype username: str
        :keyword password: The credential password.
        :paramtype password: str
        """
        super().__init__(**kwargs)
        self.username = username
        self.password = password


class JobCredentialListResult(_serialization.Model):
    """A list of job credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobCredential]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobCredential]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobCredential"]] = None
        self.next_link: Optional[str] = None


class JobExecution(ProxyResource):
    """An execution of a job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar job_version: The job version number.
    :vartype job_version: int
    :ivar step_name: The job step name.
    :vartype step_name: str
    :ivar step_id: The job step id.
    :vartype step_id: int
    :ivar job_execution_id: The unique identifier of the job execution.
    :vartype job_execution_id: str
    :ivar lifecycle: The detailed state of the job execution. Known values are: "Created",
     "InProgress", "WaitingForChildJobExecutions", "WaitingForRetry", "Succeeded",
     "SucceededWithSkipped", "Failed", "TimedOut", "Canceled", and "Skipped".
    :vartype lifecycle: str or ~azure.mgmt.sql.models.JobExecutionLifecycle
    :ivar provisioning_state: The ARM provisioning state of the job execution. Known values are:
     "Created", "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    :ivar create_time: The time that the job execution was created.
    :vartype create_time: ~datetime.datetime
    :ivar start_time: The time that the job execution started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The time that the job execution completed.
    :vartype end_time: ~datetime.datetime
    :ivar current_attempts: Number of times the job execution has been attempted.
    :vartype current_attempts: int
    :ivar current_attempt_start_time: Start time of the current attempt.
    :vartype current_attempt_start_time: ~datetime.datetime
    :ivar last_message: The last status or error message.
    :vartype last_message: str
    :ivar target: The target that this execution is executed on.
    :vartype target: ~azure.mgmt.sql.models.JobExecutionTarget
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "job_version": {"readonly": True},
        "step_name": {"readonly": True},
        "step_id": {"readonly": True},
        "job_execution_id": {"readonly": True},
        "lifecycle": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "create_time": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "current_attempt_start_time": {"readonly": True},
        "last_message": {"readonly": True},
        "target": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "job_version": {"key": "properties.jobVersion", "type": "int"},
        "step_name": {"key": "properties.stepName", "type": "str"},
        "step_id": {"key": "properties.stepId", "type": "int"},
        "job_execution_id": {"key": "properties.jobExecutionId", "type": "str"},
        "lifecycle": {"key": "properties.lifecycle", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "create_time": {"key": "properties.createTime", "type": "iso-8601"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "current_attempts": {"key": "properties.currentAttempts", "type": "int"},
        "current_attempt_start_time": {"key": "properties.currentAttemptStartTime", "type": "iso-8601"},
        "last_message": {"key": "properties.lastMessage", "type": "str"},
        "target": {"key": "properties.target", "type": "JobExecutionTarget"},
    }

    def __init__(self, *, current_attempts: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword current_attempts: Number of times the job execution has been attempted.
        :paramtype current_attempts: int
        """
        super().__init__(**kwargs)
        self.job_version: Optional[int] = None
        self.step_name: Optional[str] = None
        self.step_id: Optional[int] = None
        self.job_execution_id: Optional[str] = None
        self.lifecycle: Optional[Union[str, "_models.JobExecutionLifecycle"]] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.create_time: Optional[datetime.datetime] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None
        self.current_attempts = current_attempts
        self.current_attempt_start_time: Optional[datetime.datetime] = None
        self.last_message: Optional[str] = None
        self.target: Optional["_models.JobExecutionTarget"] = None


class JobExecutionListResult(_serialization.Model):
    """A list of job executions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobExecution]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobExecution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobExecution"]] = None
        self.next_link: Optional[str] = None


class JobExecutionTarget(_serialization.Model):
    """The target that a job execution is executed on.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of the target. Known values are: "TargetGroup", "SqlDatabase",
     "SqlElasticPool", "SqlShardMap", and "SqlServer".
    :vartype type: str or ~azure.mgmt.sql.models.JobTargetType
    :ivar server_name: The server name.
    :vartype server_name: str
    :ivar database_name: The database name.
    :vartype database_name: str
    """

    _validation = {
        "type": {"readonly": True},
        "server_name": {"readonly": True},
        "database_name": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[Union[str, "_models.JobTargetType"]] = None
        self.server_name: Optional[str] = None
        self.database_name: Optional[str] = None


class JobListResult(_serialization.Model):
    """A list of jobs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Job]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Job]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Job"]] = None
        self.next_link: Optional[str] = None


class JobPrivateEndpoint(ProxyResource):
    """A job agent private endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar target_server_azure_resource_id: ARM resource id of the server the private endpoint will
     target.
    :vartype target_server_azure_resource_id: str
    :ivar private_endpoint_id: Private endpoint id of the private endpoint.
    :vartype private_endpoint_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "private_endpoint_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "target_server_azure_resource_id": {"key": "properties.targetServerAzureResourceId", "type": "str"},
        "private_endpoint_id": {"key": "properties.privateEndpointId", "type": "str"},
    }

    def __init__(self, *, target_server_azure_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword target_server_azure_resource_id: ARM resource id of the server the private endpoint
         will target.
        :paramtype target_server_azure_resource_id: str
        """
        super().__init__(**kwargs)
        self.target_server_azure_resource_id = target_server_azure_resource_id
        self.private_endpoint_id: Optional[str] = None


class JobPrivateEndpointListResult(_serialization.Model):
    """A list of job agent private endpoints.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobPrivateEndpoint]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobPrivateEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobPrivateEndpoint"]] = None
        self.next_link: Optional[str] = None


class JobSchedule(_serialization.Model):
    """Scheduling properties of a job.

    :ivar start_time: Schedule start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Schedule end time.
    :vartype end_time: ~datetime.datetime
    :ivar type: Schedule interval type. Known values are: "Once" and "Recurring".
    :vartype type: str or ~azure.mgmt.sql.models.JobScheduleType
    :ivar enabled: Whether or not the schedule is enabled.
    :vartype enabled: bool
    :ivar interval: Value of the schedule's recurring interval, if the ScheduleType is recurring.
     ISO8601 duration format.
    :vartype interval: str
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
        "interval": {"key": "interval", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime = "0001-01-01T16:00:00-08:00",
        end_time: datetime.datetime = "9999-12-31T03:59:59-08:00",
        type: Union[str, "_models.JobScheduleType"] = "Once",
        enabled: Optional[bool] = None,
        interval: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Schedule start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Schedule end time.
        :paramtype end_time: ~datetime.datetime
        :keyword type: Schedule interval type. Known values are: "Once" and "Recurring".
        :paramtype type: str or ~azure.mgmt.sql.models.JobScheduleType
        :keyword enabled: Whether or not the schedule is enabled.
        :paramtype enabled: bool
        :keyword interval: Value of the schedule's recurring interval, if the ScheduleType is
         recurring. ISO8601 duration format.
        :paramtype interval: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.type = type
        self.enabled = enabled
        self.interval = interval


class JobStep(ProxyResource):
    """A job step.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar step_id: The job step's index within the job. If not specified when creating the job
     step, it will be created as the last step. If not specified when updating the job step, the
     step id is not modified.
    :vartype step_id: int
    :ivar target_group: The resource ID of the target group that the job step will be executed on.
    :vartype target_group: str
    :ivar credential: The resource ID of the job credential that will be used to connect to the
     targets.
    :vartype credential: str
    :ivar action: The action payload of the job step.
    :vartype action: ~azure.mgmt.sql.models.JobStepAction
    :ivar output: Output destination properties of the job step.
    :vartype output: ~azure.mgmt.sql.models.JobStepOutput
    :ivar execution_options: Execution options for the job step.
    :vartype execution_options: ~azure.mgmt.sql.models.JobStepExecutionOptions
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "step_id": {"key": "properties.stepId", "type": "int"},
        "target_group": {"key": "properties.targetGroup", "type": "str"},
        "credential": {"key": "properties.credential", "type": "str"},
        "action": {"key": "properties.action", "type": "JobStepAction"},
        "output": {"key": "properties.output", "type": "JobStepOutput"},
        "execution_options": {"key": "properties.executionOptions", "type": "JobStepExecutionOptions"},
    }

    def __init__(
        self,
        *,
        step_id: Optional[int] = None,
        target_group: Optional[str] = None,
        credential: Optional[str] = None,
        action: Optional["_models.JobStepAction"] = None,
        output: Optional["_models.JobStepOutput"] = None,
        execution_options: Optional["_models.JobStepExecutionOptions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword step_id: The job step's index within the job. If not specified when creating the job
         step, it will be created as the last step. If not specified when updating the job step, the
         step id is not modified.
        :paramtype step_id: int
        :keyword target_group: The resource ID of the target group that the job step will be executed
         on.
        :paramtype target_group: str
        :keyword credential: The resource ID of the job credential that will be used to connect to the
         targets.
        :paramtype credential: str
        :keyword action: The action payload of the job step.
        :paramtype action: ~azure.mgmt.sql.models.JobStepAction
        :keyword output: Output destination properties of the job step.
        :paramtype output: ~azure.mgmt.sql.models.JobStepOutput
        :keyword execution_options: Execution options for the job step.
        :paramtype execution_options: ~azure.mgmt.sql.models.JobStepExecutionOptions
        """
        super().__init__(**kwargs)
        self.step_id = step_id
        self.target_group = target_group
        self.credential = credential
        self.action = action
        self.output = output
        self.execution_options = execution_options


class JobStepAction(_serialization.Model):
    """The action to be executed by a job step.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of action being executed by the job step. "TSql"
    :vartype type: str or ~azure.mgmt.sql.models.JobStepActionType
    :ivar source: The source of the action to execute. "Inline"
    :vartype source: str or ~azure.mgmt.sql.models.JobStepActionSource
    :ivar value: The action value, for example the text of the T-SQL script to execute. Required.
    :vartype value: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "source": {"key": "source", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: str,
        type: Union[str, "_models.JobStepActionType"] = "TSql",
        source: Union[str, "_models.JobStepActionSource"] = "Inline",
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of action being executed by the job step. "TSql"
        :paramtype type: str or ~azure.mgmt.sql.models.JobStepActionType
        :keyword source: The source of the action to execute. "Inline"
        :paramtype source: str or ~azure.mgmt.sql.models.JobStepActionSource
        :keyword value: The action value, for example the text of the T-SQL script to execute.
         Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.source = source
        self.value = value


class JobStepExecutionOptions(_serialization.Model):
    """The execution options of a job step.

    :ivar timeout_seconds: Execution timeout for the job step.
    :vartype timeout_seconds: int
    :ivar retry_attempts: Maximum number of times the job step will be reattempted if the first
     attempt fails.
    :vartype retry_attempts: int
    :ivar initial_retry_interval_seconds: Initial delay between retries for job step execution.
    :vartype initial_retry_interval_seconds: int
    :ivar maximum_retry_interval_seconds: The maximum amount of time to wait between retries for
     job step execution.
    :vartype maximum_retry_interval_seconds: int
    :ivar retry_interval_backoff_multiplier: The backoff multiplier for the time between retries.
    :vartype retry_interval_backoff_multiplier: float
    """

    _attribute_map = {
        "timeout_seconds": {"key": "timeoutSeconds", "type": "int"},
        "retry_attempts": {"key": "retryAttempts", "type": "int"},
        "initial_retry_interval_seconds": {"key": "initialRetryIntervalSeconds", "type": "int"},
        "maximum_retry_interval_seconds": {"key": "maximumRetryIntervalSeconds", "type": "int"},
        "retry_interval_backoff_multiplier": {"key": "retryIntervalBackoffMultiplier", "type": "float"},
    }

    def __init__(
        self,
        *,
        timeout_seconds: int = 43200,
        retry_attempts: int = 10,
        initial_retry_interval_seconds: int = 1,
        maximum_retry_interval_seconds: int = 120,
        retry_interval_backoff_multiplier: float = 2,
        **kwargs: Any
    ) -> None:
        """
        :keyword timeout_seconds: Execution timeout for the job step.
        :paramtype timeout_seconds: int
        :keyword retry_attempts: Maximum number of times the job step will be reattempted if the first
         attempt fails.
        :paramtype retry_attempts: int
        :keyword initial_retry_interval_seconds: Initial delay between retries for job step execution.
        :paramtype initial_retry_interval_seconds: int
        :keyword maximum_retry_interval_seconds: The maximum amount of time to wait between retries for
         job step execution.
        :paramtype maximum_retry_interval_seconds: int
        :keyword retry_interval_backoff_multiplier: The backoff multiplier for the time between
         retries.
        :paramtype retry_interval_backoff_multiplier: float
        """
        super().__init__(**kwargs)
        self.timeout_seconds = timeout_seconds
        self.retry_attempts = retry_attempts
        self.initial_retry_interval_seconds = initial_retry_interval_seconds
        self.maximum_retry_interval_seconds = maximum_retry_interval_seconds
        self.retry_interval_backoff_multiplier = retry_interval_backoff_multiplier


class JobStepListResult(_serialization.Model):
    """A list of job steps.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobStep]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobStep]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobStep"]] = None
        self.next_link: Optional[str] = None


class JobStepOutput(_serialization.Model):
    """The output configuration of a job step.

    All required parameters must be populated in order to send to server.

    :ivar type: The output destination type. "SqlDatabase"
    :vartype type: str or ~azure.mgmt.sql.models.JobStepOutputType
    :ivar subscription_id: The output destination subscription id.
    :vartype subscription_id: str
    :ivar resource_group_name: The output destination resource group.
    :vartype resource_group_name: str
    :ivar server_name: The output destination server name. Required.
    :vartype server_name: str
    :ivar database_name: The output destination database. Required.
    :vartype database_name: str
    :ivar schema_name: The output destination schema.
    :vartype schema_name: str
    :ivar table_name: The output destination table. Required.
    :vartype table_name: str
    :ivar credential: The resource ID of the credential to use to connect to the output
     destination.
    :vartype credential: str
    """

    _validation = {
        "server_name": {"required": True},
        "database_name": {"required": True},
        "table_name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "resource_group_name": {"key": "resourceGroupName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "schema_name": {"key": "schemaName", "type": "str"},
        "table_name": {"key": "tableName", "type": "str"},
        "credential": {"key": "credential", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_name: str,
        database_name: str,
        table_name: str,
        type: Union[str, "_models.JobStepOutputType"] = "SqlDatabase",
        subscription_id: Optional[str] = None,
        resource_group_name: Optional[str] = None,
        schema_name: str = "dbo",
        credential: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The output destination type. "SqlDatabase"
        :paramtype type: str or ~azure.mgmt.sql.models.JobStepOutputType
        :keyword subscription_id: The output destination subscription id.
        :paramtype subscription_id: str
        :keyword resource_group_name: The output destination resource group.
        :paramtype resource_group_name: str
        :keyword server_name: The output destination server name. Required.
        :paramtype server_name: str
        :keyword database_name: The output destination database. Required.
        :paramtype database_name: str
        :keyword schema_name: The output destination schema.
        :paramtype schema_name: str
        :keyword table_name: The output destination table. Required.
        :paramtype table_name: str
        :keyword credential: The resource ID of the credential to use to connect to the output
         destination.
        :paramtype credential: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.server_name = server_name
        self.database_name = database_name
        self.schema_name = schema_name
        self.table_name = table_name
        self.credential = credential


class JobTarget(_serialization.Model):
    """A job target, for example a specific database or a container of databases that is evaluated
    during job execution.

    All required parameters must be populated in order to send to server.

    :ivar membership_type: Whether the target is included or excluded from the group. Known values
     are: "Include" and "Exclude".
    :vartype membership_type: str or ~azure.mgmt.sql.models.JobTargetGroupMembershipType
    :ivar type: The target type. Required. Known values are: "TargetGroup", "SqlDatabase",
     "SqlElasticPool", "SqlShardMap", and "SqlServer".
    :vartype type: str or ~azure.mgmt.sql.models.JobTargetType
    :ivar server_name: The target server name.
    :vartype server_name: str
    :ivar database_name: The target database name.
    :vartype database_name: str
    :ivar elastic_pool_name: The target elastic pool name.
    :vartype elastic_pool_name: str
    :ivar shard_map_name: The target shard map.
    :vartype shard_map_name: str
    :ivar refresh_credential: The resource ID of the credential that is used during job execution
     to connect to the target and determine the list of databases inside the target.
    :vartype refresh_credential: str
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "membership_type": {"key": "membershipType", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
        "elastic_pool_name": {"key": "elasticPoolName", "type": "str"},
        "shard_map_name": {"key": "shardMapName", "type": "str"},
        "refresh_credential": {"key": "refreshCredential", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.JobTargetType"],
        membership_type: Union[str, "_models.JobTargetGroupMembershipType"] = "Include",
        server_name: Optional[str] = None,
        database_name: Optional[str] = None,
        elastic_pool_name: Optional[str] = None,
        shard_map_name: Optional[str] = None,
        refresh_credential: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword membership_type: Whether the target is included or excluded from the group. Known
         values are: "Include" and "Exclude".
        :paramtype membership_type: str or ~azure.mgmt.sql.models.JobTargetGroupMembershipType
        :keyword type: The target type. Required. Known values are: "TargetGroup", "SqlDatabase",
         "SqlElasticPool", "SqlShardMap", and "SqlServer".
        :paramtype type: str or ~azure.mgmt.sql.models.JobTargetType
        :keyword server_name: The target server name.
        :paramtype server_name: str
        :keyword database_name: The target database name.
        :paramtype database_name: str
        :keyword elastic_pool_name: The target elastic pool name.
        :paramtype elastic_pool_name: str
        :keyword shard_map_name: The target shard map.
        :paramtype shard_map_name: str
        :keyword refresh_credential: The resource ID of the credential that is used during job
         execution to connect to the target and determine the list of databases inside the target.
        :paramtype refresh_credential: str
        """
        super().__init__(**kwargs)
        self.membership_type = membership_type
        self.type = type
        self.server_name = server_name
        self.database_name = database_name
        self.elastic_pool_name = elastic_pool_name
        self.shard_map_name = shard_map_name
        self.refresh_credential = refresh_credential


class JobTargetGroup(ProxyResource):
    """A group of job targets.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar members: Members of the target group.
    :vartype members: list[~azure.mgmt.sql.models.JobTarget]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "members": {"key": "properties.members", "type": "[JobTarget]"},
    }

    def __init__(self, *, members: Optional[List["_models.JobTarget"]] = None, **kwargs: Any) -> None:
        """
        :keyword members: Members of the target group.
        :paramtype members: list[~azure.mgmt.sql.models.JobTarget]
        """
        super().__init__(**kwargs)
        self.members = members


class JobTargetGroupListResult(_serialization.Model):
    """A list of target groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobTargetGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobTargetGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobTargetGroup"]] = None
        self.next_link: Optional[str] = None


class JobVersion(ProxyResource):
    """A job version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """


class JobVersionListResult(_serialization.Model):
    """A list of job versions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.JobVersion]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JobVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.JobVersion"]] = None
        self.next_link: Optional[str] = None


class LedgerDigestUploads(ProxyResource):
    """Azure SQL Database ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar digest_storage_endpoint: The digest storage endpoint, which must be either an Azure blob
     storage endpoint or an URI for Azure Confidential Ledger.
    :vartype digest_storage_endpoint: str
    :ivar state: Specifies the state of ledger digest upload. Known values are: "Enabled" and
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.LedgerDigestUploadsState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "digest_storage_endpoint": {"key": "properties.digestStorageEndpoint", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(self, *, digest_storage_endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword digest_storage_endpoint: The digest storage endpoint, which must be either an Azure
         blob storage endpoint or an URI for Azure Confidential Ledger.
        :paramtype digest_storage_endpoint: str
        """
        super().__init__(**kwargs)
        self.digest_storage_endpoint = digest_storage_endpoint
        self.state: Optional[Union[str, "_models.LedgerDigestUploadsState"]] = None


class LedgerDigestUploadsListResult(_serialization.Model):
    """A list of ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LedgerDigestUploads]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LedgerDigestUploads]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.LedgerDigestUploads"]] = None
        self.next_link: Optional[str] = None


class LicenseTypeCapability(_serialization.Model):
    """The license type capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: License type identifier.
    :vartype name: str
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class LocationCapabilities(_serialization.Model):
    """The location capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The location name.
    :vartype name: str
    :ivar supported_server_versions: The list of supported server versions.
    :vartype supported_server_versions: list[~azure.mgmt.sql.models.ServerVersionCapability]
    :ivar supported_managed_instance_versions: The list of supported managed instance versions.
    :vartype supported_managed_instance_versions:
     list[~azure.mgmt.sql.models.ManagedInstanceVersionCapability]
    :ivar supported_job_agent_versions: The list of supported job agent versions.
    :vartype supported_job_agent_versions: list[~azure.mgmt.sql.models.JobAgentVersionCapability]
    :ivar is_zone_resilient_provisioning_allowed: Whether or not the subscription is allowed to
     provision zone resilient resources.
    :vartype is_zone_resilient_provisioning_allowed: bool
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_server_versions": {"readonly": True},
        "supported_managed_instance_versions": {"readonly": True},
        "supported_job_agent_versions": {"readonly": True},
        "is_zone_resilient_provisioning_allowed": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_server_versions": {"key": "supportedServerVersions", "type": "[ServerVersionCapability]"},
        "supported_managed_instance_versions": {
            "key": "supportedManagedInstanceVersions",
            "type": "[ManagedInstanceVersionCapability]",
        },
        "supported_job_agent_versions": {"key": "supportedJobAgentVersions", "type": "[JobAgentVersionCapability]"},
        "is_zone_resilient_provisioning_allowed": {"key": "isZoneResilientProvisioningAllowed", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_server_versions: Optional[List["_models.ServerVersionCapability"]] = None
        self.supported_managed_instance_versions: Optional[List["_models.ManagedInstanceVersionCapability"]] = None
        self.supported_job_agent_versions: Optional[List["_models.JobAgentVersionCapability"]] = None
        self.is_zone_resilient_provisioning_allowed: Optional[bool] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class LogicalDatabaseTransparentDataEncryption(ProxyResource):
    """A logical database transparent data encryption scan state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Specifies the state of the transparent data encryption. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionState
    :ivar scan_state: Specifies the encryption scan state of the transparent data encryption. Known
     values are: "None", "Resume", "Running", "Suspend", "Aborted", and "Completed".
    :vartype scan_state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionScanState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "scan_state": {"key": "properties.scanState", "type": "str"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.TransparentDataEncryptionState"]] = None,
        scan_state: Optional[Union[str, "_models.TransparentDataEncryptionScanState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the transparent data encryption. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionState
        :keyword scan_state: Specifies the encryption scan state of the transparent data encryption.
         Known values are: "None", "Resume", "Running", "Suspend", "Aborted", and "Completed".
        :paramtype scan_state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionScanState
        """
        super().__init__(**kwargs)
        self.state = state
        self.scan_state = scan_state


class LogicalDatabaseTransparentDataEncryptionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of transparent data encryption scan objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LogicalDatabaseTransparentDataEncryption]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LogicalDatabaseTransparentDataEncryption]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.LogicalDatabaseTransparentDataEncryption"]] = None
        self.next_link: Optional[str] = None


class LogicalServerAdvancedThreatProtectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the server's Advanced Threat Protection configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerAdvancedThreatProtection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerAdvancedThreatProtection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerAdvancedThreatProtection"]] = None
        self.next_link: Optional[str] = None


class LogicalServerSecurityAlertPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerSecurityAlertPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerSecurityAlertPolicy"]] = None
        self.next_link: Optional[str] = None


class LogSizeCapability(_serialization.Model):
    """The log size capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The log size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Known values are: "Megabytes",
     "Gigabytes", "Terabytes", "Petabytes", and "Percent".
    :vartype unit: str or ~azure.mgmt.sql.models.LogSizeUnit
    """

    _validation = {
        "limit": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.limit: Optional[int] = None
        self.unit: Optional[Union[str, "_models.LogSizeUnit"]] = None


class LongTermRetentionBackup(ProxyResource):
    """A long term retention backup.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar server_name: The server name that the backup database belong to.
    :vartype server_name: str
    :ivar server_create_time: The create time of the server.
    :vartype server_create_time: ~datetime.datetime
    :ivar database_name: The name of the database the backup belong to.
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database.
    :vartype database_deletion_time: ~datetime.datetime
    :ivar backup_time: The time the backup was taken.
    :vartype backup_time: ~datetime.datetime
    :ivar backup_expiration_time: The time the long term retention backup will expire.
    :vartype backup_expiration_time: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage redundancy type of the backup. Known values are:
     "Geo", "Local", "Zone", and "GeoZone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar requested_backup_storage_redundancy: The storage redundancy type of the backup. Known
     values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar is_backup_immutable: The setting whether the LTR backup is immutable.
    :vartype is_backup_immutable: bool
    :ivar time_based_immutability: The setting for whether or not time-based immutability is
     enabled for the LTR backup. When time-based immutability is enabled and locked, the backup
     cannot be deleted until BackupExpirationTime. Known values are: "Enabled" and "Disabled".
    :vartype time_based_immutability: str or ~azure.mgmt.sql.models.TimeBasedImmutability
    :ivar time_based_immutability_mode: The time-based immutability mode. Only applicable if
     time-based immutability is enabled. Known values are: "Locked" and "Unlocked".
    :vartype time_based_immutability_mode: str or ~azure.mgmt.sql.models.TimeBasedImmutabilityMode
    :ivar legal_hold_immutability: The setting for whether LegalHold is enabled or disabled on the
     LTR backup. When LegalHold is enabled, the backup cannot be deleted until the LegalHold is
     removed. Known values are: "Enabled" and "Disabled".
    :vartype legal_hold_immutability: str or ~azure.mgmt.sql.models.SetLegalHoldImmutability
    :ivar backup_storage_access_tier: The BackupStorageAccessTier for the LTR backup. Known values
     are: "Hot" and "Archive".
    :vartype backup_storage_access_tier: str or ~azure.mgmt.sql.models.BackupStorageAccessTier
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "server_name": {"readonly": True},
        "server_create_time": {"readonly": True},
        "database_name": {"readonly": True},
        "database_deletion_time": {"readonly": True},
        "backup_time": {"readonly": True},
        "backup_expiration_time": {"readonly": True},
        "backup_storage_redundancy": {"readonly": True},
        "backup_storage_access_tier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "server_create_time": {"key": "properties.serverCreateTime", "type": "iso-8601"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "database_deletion_time": {"key": "properties.databaseDeletionTime", "type": "iso-8601"},
        "backup_time": {"key": "properties.backupTime", "type": "iso-8601"},
        "backup_expiration_time": {"key": "properties.backupExpirationTime", "type": "iso-8601"},
        "backup_storage_redundancy": {"key": "properties.backupStorageRedundancy", "type": "str"},
        "requested_backup_storage_redundancy": {"key": "properties.requestedBackupStorageRedundancy", "type": "str"},
        "is_backup_immutable": {"key": "properties.isBackupImmutable", "type": "bool"},
        "time_based_immutability": {"key": "properties.timeBasedImmutability", "type": "str"},
        "time_based_immutability_mode": {"key": "properties.timeBasedImmutabilityMode", "type": "str"},
        "legal_hold_immutability": {"key": "properties.legalHoldImmutability", "type": "str"},
        "backup_storage_access_tier": {"key": "properties.backupStorageAccessTier", "type": "str"},
    }

    def __init__(
        self,
        *,
        requested_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        is_backup_immutable: Optional[bool] = None,
        time_based_immutability: Optional[Union[str, "_models.TimeBasedImmutability"]] = None,
        time_based_immutability_mode: Optional[Union[str, "_models.TimeBasedImmutabilityMode"]] = None,
        legal_hold_immutability: Optional[Union[str, "_models.SetLegalHoldImmutability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword requested_backup_storage_redundancy: The storage redundancy type of the backup. Known
         values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype requested_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        :keyword is_backup_immutable: The setting whether the LTR backup is immutable.
        :paramtype is_backup_immutable: bool
        :keyword time_based_immutability: The setting for whether or not time-based immutability is
         enabled for the LTR backup. When time-based immutability is enabled and locked, the backup
         cannot be deleted until BackupExpirationTime. Known values are: "Enabled" and "Disabled".
        :paramtype time_based_immutability: str or ~azure.mgmt.sql.models.TimeBasedImmutability
        :keyword time_based_immutability_mode: The time-based immutability mode. Only applicable if
         time-based immutability is enabled. Known values are: "Locked" and "Unlocked".
        :paramtype time_based_immutability_mode: str or
         ~azure.mgmt.sql.models.TimeBasedImmutabilityMode
        :keyword legal_hold_immutability: The setting for whether LegalHold is enabled or disabled on
         the LTR backup. When LegalHold is enabled, the backup cannot be deleted until the LegalHold is
         removed. Known values are: "Enabled" and "Disabled".
        :paramtype legal_hold_immutability: str or ~azure.mgmt.sql.models.SetLegalHoldImmutability
        """
        super().__init__(**kwargs)
        self.server_name: Optional[str] = None
        self.server_create_time: Optional[datetime.datetime] = None
        self.database_name: Optional[str] = None
        self.database_deletion_time: Optional[datetime.datetime] = None
        self.backup_time: Optional[datetime.datetime] = None
        self.backup_expiration_time: Optional[datetime.datetime] = None
        self.backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.is_backup_immutable = is_backup_immutable
        self.time_based_immutability = time_based_immutability
        self.time_based_immutability_mode = time_based_immutability_mode
        self.legal_hold_immutability = legal_hold_immutability
        self.backup_storage_access_tier: Optional[Union[str, "_models.BackupStorageAccessTier"]] = None


class LongTermRetentionBackupListResult(_serialization.Model):
    """A list of long term retention backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LongTermRetentionBackup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LongTermRetentionBackup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.LongTermRetentionBackup"]] = None
        self.next_link: Optional[str] = None


class LongTermRetentionBackupOperationResult(ProxyResource):
    """A LongTermRetentionBackup operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar operation_type: Operation type.
    :vartype operation_type: str
    :ivar from_backup_resource_id: Source backup resource id.
    :vartype from_backup_resource_id: str
    :ivar to_backup_resource_id: Target backup resource id.
    :vartype to_backup_resource_id: str
    :ivar target_backup_storage_redundancy: The storage redundancy type of the copied backup. Known
     values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype target_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar status: Operation status.
    :vartype status: str
    :ivar message: Progress message.
    :vartype message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "request_id": {"readonly": True},
        "operation_type": {"readonly": True},
        "from_backup_resource_id": {"readonly": True},
        "to_backup_resource_id": {"readonly": True},
        "target_backup_storage_redundancy": {"readonly": True},
        "status": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "request_id": {"key": "properties.requestId", "type": "str"},
        "operation_type": {"key": "properties.operationType", "type": "str"},
        "from_backup_resource_id": {"key": "properties.fromBackupResourceId", "type": "str"},
        "to_backup_resource_id": {"key": "properties.toBackupResourceId", "type": "str"},
        "target_backup_storage_redundancy": {"key": "properties.targetBackupStorageRedundancy", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "message": {"key": "properties.message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.request_id: Optional[str] = None
        self.operation_type: Optional[str] = None
        self.from_backup_resource_id: Optional[str] = None
        self.to_backup_resource_id: Optional[str] = None
        self.target_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.status: Optional[str] = None
        self.message: Optional[str] = None


class LongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time_based_immutability: The setting for whether to enable time-based immutability for
     future backups. When set, future backups will have TimeBasedImmutability enabled. Known values
     are: "Enabled" and "Disabled".
    :vartype time_based_immutability: str or ~azure.mgmt.sql.models.TimeBasedImmutability
    :ivar time_based_immutability_mode: The setting for time-based immutability mode for future
     backup (Value can be either Locked or UnLocked. Only effective if TimeBasedImmutability is
     enabled). Caution: Immutability of LTR backup cannot be removed if TimeBasedImmutabilityMode is
     Locked. Known values are: "Locked" and "Unlocked".
    :vartype time_based_immutability_mode: str or ~azure.mgmt.sql.models.TimeBasedImmutabilityMode
    :ivar weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
    :vartype weekly_retention: str
    :ivar monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format.
    :vartype monthly_retention: str
    :ivar yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
    :vartype yearly_retention: str
    :ivar week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
    :vartype week_of_year: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time_based_immutability": {"key": "properties.timeBasedImmutability", "type": "str"},
        "time_based_immutability_mode": {"key": "properties.timeBasedImmutabilityMode", "type": "str"},
        "weekly_retention": {"key": "properties.weeklyRetention", "type": "str"},
        "monthly_retention": {"key": "properties.monthlyRetention", "type": "str"},
        "yearly_retention": {"key": "properties.yearlyRetention", "type": "str"},
        "week_of_year": {"key": "properties.weekOfYear", "type": "int"},
    }

    def __init__(
        self,
        *,
        time_based_immutability: Optional[Union[str, "_models.TimeBasedImmutability"]] = None,
        time_based_immutability_mode: Optional[Union[str, "_models.TimeBasedImmutabilityMode"]] = None,
        weekly_retention: Optional[str] = None,
        monthly_retention: Optional[str] = None,
        yearly_retention: Optional[str] = None,
        week_of_year: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_based_immutability: The setting for whether to enable time-based immutability for
         future backups. When set, future backups will have TimeBasedImmutability enabled. Known values
         are: "Enabled" and "Disabled".
        :paramtype time_based_immutability: str or ~azure.mgmt.sql.models.TimeBasedImmutability
        :keyword time_based_immutability_mode: The setting for time-based immutability mode for future
         backup (Value can be either Locked or UnLocked. Only effective if TimeBasedImmutability is
         enabled). Caution: Immutability of LTR backup cannot be removed if TimeBasedImmutabilityMode is
         Locked. Known values are: "Locked" and "Unlocked".
        :paramtype time_based_immutability_mode: str or
         ~azure.mgmt.sql.models.TimeBasedImmutabilityMode
        :keyword weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
        :paramtype weekly_retention: str
        :keyword monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601
         format.
        :paramtype monthly_retention: str
        :keyword yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
        :paramtype yearly_retention: str
        :keyword week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
        :paramtype week_of_year: int
        """
        super().__init__(**kwargs)
        self.time_based_immutability = time_based_immutability
        self.time_based_immutability_mode = time_based_immutability_mode
        self.weekly_retention = weekly_retention
        self.monthly_retention = monthly_retention
        self.yearly_retention = yearly_retention
        self.week_of_year = week_of_year


class LongTermRetentionPolicyListResult(_serialization.Model):
    """A list of long term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.LongTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LongTermRetentionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.LongTermRetentionPolicy"]] = None
        self.next_link: Optional[str] = None


class MaintenanceConfigurationCapability(_serialization.Model):
    """The maintenance configuration capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Maintenance configuration name.
    :vartype name: str
    :ivar zone_redundant: Whether or not zone redundancy is supported for the maintenance
     configuration.
    :vartype zone_redundant: bool
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.zone_redundant: Optional[bool] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class MaintenanceWindowOptions(ProxyResource):
    """Maintenance window options.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_enabled: Whether maintenance windows are enabled for the database.
    :vartype is_enabled: bool
    :ivar maintenance_window_cycles: Available maintenance cycles e.g. {Saturday, 0, 48\\ *60},
     {Wednesday, 0, 24*\\ 60}.
    :vartype maintenance_window_cycles: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
    :ivar min_duration_in_minutes: Minimum duration of maintenance window.
    :vartype min_duration_in_minutes: int
    :ivar default_duration_in_minutes: Default duration for maintenance window.
    :vartype default_duration_in_minutes: int
    :ivar min_cycles: Minimum number of maintenance windows cycles to be set on the database.
    :vartype min_cycles: int
    :ivar time_granularity_in_minutes: Time granularity in minutes for maintenance windows.
    :vartype time_granularity_in_minutes: int
    :ivar allow_multiple_maintenance_windows_per_cycle: Whether we allow multiple maintenance
     windows per cycle.
    :vartype allow_multiple_maintenance_windows_per_cycle: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "maintenance_window_cycles": {
            "key": "properties.maintenanceWindowCycles",
            "type": "[MaintenanceWindowTimeRange]",
        },
        "min_duration_in_minutes": {"key": "properties.minDurationInMinutes", "type": "int"},
        "default_duration_in_minutes": {"key": "properties.defaultDurationInMinutes", "type": "int"},
        "min_cycles": {"key": "properties.minCycles", "type": "int"},
        "time_granularity_in_minutes": {"key": "properties.timeGranularityInMinutes", "type": "int"},
        "allow_multiple_maintenance_windows_per_cycle": {
            "key": "properties.allowMultipleMaintenanceWindowsPerCycle",
            "type": "bool",
        },
    }

    def __init__(
        self,
        *,
        is_enabled: Optional[bool] = None,
        maintenance_window_cycles: Optional[List["_models.MaintenanceWindowTimeRange"]] = None,
        min_duration_in_minutes: Optional[int] = None,
        default_duration_in_minutes: Optional[int] = None,
        min_cycles: Optional[int] = None,
        time_granularity_in_minutes: Optional[int] = None,
        allow_multiple_maintenance_windows_per_cycle: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled: Whether maintenance windows are enabled for the database.
        :paramtype is_enabled: bool
        :keyword maintenance_window_cycles: Available maintenance cycles e.g. {Saturday, 0, 48\\ *60},
         {Wednesday, 0, 24*\\ 60}.
        :paramtype maintenance_window_cycles: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
        :keyword min_duration_in_minutes: Minimum duration of maintenance window.
        :paramtype min_duration_in_minutes: int
        :keyword default_duration_in_minutes: Default duration for maintenance window.
        :paramtype default_duration_in_minutes: int
        :keyword min_cycles: Minimum number of maintenance windows cycles to be set on the database.
        :paramtype min_cycles: int
        :keyword time_granularity_in_minutes: Time granularity in minutes for maintenance windows.
        :paramtype time_granularity_in_minutes: int
        :keyword allow_multiple_maintenance_windows_per_cycle: Whether we allow multiple maintenance
         windows per cycle.
        :paramtype allow_multiple_maintenance_windows_per_cycle: bool
        """
        super().__init__(**kwargs)
        self.is_enabled = is_enabled
        self.maintenance_window_cycles = maintenance_window_cycles
        self.min_duration_in_minutes = min_duration_in_minutes
        self.default_duration_in_minutes = default_duration_in_minutes
        self.min_cycles = min_cycles
        self.time_granularity_in_minutes = time_granularity_in_minutes
        self.allow_multiple_maintenance_windows_per_cycle = allow_multiple_maintenance_windows_per_cycle


class MaintenanceWindows(ProxyResource):
    """Maintenance windows.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar time_ranges:
    :vartype time_ranges: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "time_ranges": {"key": "properties.timeRanges", "type": "[MaintenanceWindowTimeRange]"},
    }

    def __init__(
        self, *, time_ranges: Optional[List["_models.MaintenanceWindowTimeRange"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword time_ranges:
        :paramtype time_ranges: list[~azure.mgmt.sql.models.MaintenanceWindowTimeRange]
        """
        super().__init__(**kwargs)
        self.time_ranges = time_ranges


class MaintenanceWindowTimeRange(_serialization.Model):
    """Maintenance window time range.

    :ivar day_of_week: Day of maintenance window. Known values are: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", and "Saturday".
    :vartype day_of_week: str or ~azure.mgmt.sql.models.DayOfWeek
    :ivar start_time: Start time minutes offset from 12am.
    :vartype start_time: str
    :ivar duration: Duration of maintenance window in minutes.
    :vartype duration: str
    """

    _attribute_map = {
        "day_of_week": {"key": "dayOfWeek", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "duration": {"key": "duration", "type": "str"},
    }

    def __init__(
        self,
        *,
        day_of_week: Optional[Union[str, "_models.DayOfWeek"]] = None,
        start_time: Optional[str] = None,
        duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword day_of_week: Day of maintenance window. Known values are: "Sunday", "Monday",
         "Tuesday", "Wednesday", "Thursday", "Friday", and "Saturday".
        :paramtype day_of_week: str or ~azure.mgmt.sql.models.DayOfWeek
        :keyword start_time: Start time minutes offset from 12am.
        :paramtype start_time: str
        :keyword duration: Duration of maintenance window in minutes.
        :paramtype duration: str
        """
        super().__init__(**kwargs)
        self.day_of_week = day_of_week
        self.start_time = start_time
        self.duration = duration


class ManagedBackupShortTermRetentionPolicy(ProxyResource):
    """A short term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar retention_days: The backup retention period in days. This is how many days Point-in-Time
     Restore will be supported.
    :vartype retention_days: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
    }

    def __init__(self, *, retention_days: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword retention_days: The backup retention period in days. This is how many days
         Point-in-Time Restore will be supported.
        :paramtype retention_days: int
        """
        super().__init__(**kwargs)
        self.retention_days = retention_days


class ManagedBackupShortTermRetentionPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of short term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedBackupShortTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedBackupShortTermRetentionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedBackupShortTermRetentionPolicy"]] = None
        self.next_link: Optional[str] = None


class ManagedDatabase(TrackedResource):
    """A managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar collation: Collation of the managed database.
    :vartype collation: str
    :ivar status: Status of the database. Known values are: "Online", "Offline", "Shutdown",
     "Creating", "Inaccessible", "Restoring", "Updating", "Stopping", "Stopped", "Starting",
     "DbMoving", and "DbCopying".
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: ~datetime.datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in time restore.
    :vartype earliest_restore_point: ~datetime.datetime
    :ivar restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
     required. Specifies the point in time (ISO8601 format) of the source database that will be
     restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :ivar catalog_collation: Collation of the metadata catalog. Known values are:
     "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
    :vartype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :ivar create_mode: Managed database create mode. PointInTimeRestore: Create a database by
     restoring a point in time backup of an existing database. SourceDatabaseName,
     SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
     database by restoring from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
     resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
     long term retention backup (longTermRetentionBackupResourceId required). Known values are:
     "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery", and
     "RestoreLongTermRetentionBackup".
    :vartype create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :ivar storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value is
     required. Specifies the uri of the storage container where backups for this restore are stored.
    :vartype storage_container_uri: str
    :ivar source_database_id: The resource identifier of the source database associated with create
     operation of this database.
    :vartype source_database_id: str
    :ivar cross_subscription_source_database_id: The resource identifier of the cross-subscription
     source database associated with create operation of this database.
    :vartype cross_subscription_source_database_id: str
    :ivar restorable_dropped_database_id: The restorable dropped database resource id to restore
     when creating this database.
    :vartype restorable_dropped_database_id: str
    :ivar cross_subscription_restorable_dropped_database_id: The restorable cross-subscription
     dropped database resource id to restore when creating this database.
    :vartype cross_subscription_restorable_dropped_database_id: str
    :ivar storage_container_identity: Conditional. If createMode is RestoreExternalBackup, this
     value is used. Specifies the identity used for storage container authentication. Can be
     'SharedAccessSignature' or 'ManagedIdentity'; if not specified 'SharedAccessSignature' is
     assumed.
    :vartype storage_container_identity: str
    :ivar storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup and
     storageContainerIdentity is not ManagedIdentity, this value is required. Specifies the storage
     container sas token.
    :vartype storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that this managed database
     belongs to.
    :vartype failover_group_id: str
    :ivar recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :vartype recoverable_database_id: str
    :ivar long_term_retention_backup_resource_id: The name of the Long Term Retention backup to be
     used for restore of this managed database.
    :vartype long_term_retention_backup_resource_id: str
    :ivar auto_complete_restore: Whether to auto complete restore of this managed database.
    :vartype auto_complete_restore: bool
    :ivar last_backup_name: Last backup file name for restore of this managed database.
    :vartype last_backup_name: str
    :ivar cross_subscription_target_managed_instance_id: Target managed instance id used in
     cross-subscription restore.
    :vartype cross_subscription_target_managed_instance_id: str
    :ivar is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :vartype is_ledger_on: bool
    :ivar extended_accessibility_info: Additional observability and troubleshooting information for
     databases in ‘Inaccessible’ state.
    :vartype extended_accessibility_info:
     ~azure.mgmt.sql.models.ManagedDatabaseExtendedAccessibilityInfo
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "status": {"readonly": True},
        "creation_date": {"readonly": True},
        "earliest_restore_point": {"readonly": True},
        "default_secondary_location": {"readonly": True},
        "failover_group_id": {"readonly": True},
        "extended_accessibility_info": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "collation": {"key": "properties.collation", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "earliest_restore_point": {"key": "properties.earliestRestorePoint", "type": "iso-8601"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "default_secondary_location": {"key": "properties.defaultSecondaryLocation", "type": "str"},
        "catalog_collation": {"key": "properties.catalogCollation", "type": "str"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "storage_container_uri": {"key": "properties.storageContainerUri", "type": "str"},
        "source_database_id": {"key": "properties.sourceDatabaseId", "type": "str"},
        "cross_subscription_source_database_id": {"key": "properties.crossSubscriptionSourceDatabaseId", "type": "str"},
        "restorable_dropped_database_id": {"key": "properties.restorableDroppedDatabaseId", "type": "str"},
        "cross_subscription_restorable_dropped_database_id": {
            "key": "properties.crossSubscriptionRestorableDroppedDatabaseId",
            "type": "str",
        },
        "storage_container_identity": {"key": "properties.storageContainerIdentity", "type": "str"},
        "storage_container_sas_token": {"key": "properties.storageContainerSasToken", "type": "str"},
        "failover_group_id": {"key": "properties.failoverGroupId", "type": "str"},
        "recoverable_database_id": {"key": "properties.recoverableDatabaseId", "type": "str"},
        "long_term_retention_backup_resource_id": {
            "key": "properties.longTermRetentionBackupResourceId",
            "type": "str",
        },
        "auto_complete_restore": {"key": "properties.autoCompleteRestore", "type": "bool"},
        "last_backup_name": {"key": "properties.lastBackupName", "type": "str"},
        "cross_subscription_target_managed_instance_id": {
            "key": "properties.crossSubscriptionTargetManagedInstanceId",
            "type": "str",
        },
        "is_ledger_on": {"key": "properties.isLedgerOn", "type": "bool"},
        "extended_accessibility_info": {
            "key": "properties.extendedAccessibilityInfo",
            "type": "ManagedDatabaseExtendedAccessibilityInfo",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        collation: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        catalog_collation: Optional[Union[str, "_models.CatalogCollationType"]] = None,
        create_mode: Optional[Union[str, "_models.ManagedDatabaseCreateMode"]] = None,
        storage_container_uri: Optional[str] = None,
        source_database_id: Optional[str] = None,
        cross_subscription_source_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        cross_subscription_restorable_dropped_database_id: Optional[str] = None,
        storage_container_identity: Optional[str] = None,
        storage_container_sas_token: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        auto_complete_restore: Optional[bool] = None,
        last_backup_name: Optional[str] = None,
        cross_subscription_target_managed_instance_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword collation: Collation of the managed database.
        :paramtype collation: str
        :keyword restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
         required. Specifies the point in time (ISO8601 format) of the source database that will be
         restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword catalog_collation: Collation of the metadata catalog. Known values are:
         "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
        :paramtype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
        :keyword create_mode: Managed database create mode. PointInTimeRestore: Create a database by
         restoring a point in time backup of an existing database. SourceDatabaseName,
         SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
         database by restoring from external backup files. Collation, StorageContainerUri and
         StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
         geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
         resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
         long term retention backup (longTermRetentionBackupResourceId required). Known values are:
         "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery", and
         "RestoreLongTermRetentionBackup".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
        :keyword storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value
         is required. Specifies the uri of the storage container where backups for this restore are
         stored.
        :paramtype storage_container_uri: str
        :keyword source_database_id: The resource identifier of the source database associated with
         create operation of this database.
        :paramtype source_database_id: str
        :keyword cross_subscription_source_database_id: The resource identifier of the
         cross-subscription source database associated with create operation of this database.
        :paramtype cross_subscription_source_database_id: str
        :keyword restorable_dropped_database_id: The restorable dropped database resource id to restore
         when creating this database.
        :paramtype restorable_dropped_database_id: str
        :keyword cross_subscription_restorable_dropped_database_id: The restorable cross-subscription
         dropped database resource id to restore when creating this database.
        :paramtype cross_subscription_restorable_dropped_database_id: str
        :keyword storage_container_identity: Conditional. If createMode is RestoreExternalBackup, this
         value is used. Specifies the identity used for storage container authentication. Can be
         'SharedAccessSignature' or 'ManagedIdentity'; if not specified 'SharedAccessSignature' is
         assumed.
        :paramtype storage_container_identity: str
        :keyword storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup and
         storageContainerIdentity is not ManagedIdentity, this value is required. Specifies the storage
         container sas token.
        :paramtype storage_container_sas_token: str
        :keyword recoverable_database_id: The resource identifier of the recoverable database
         associated with create operation of this database.
        :paramtype recoverable_database_id: str
        :keyword long_term_retention_backup_resource_id: The name of the Long Term Retention backup to
         be used for restore of this managed database.
        :paramtype long_term_retention_backup_resource_id: str
        :keyword auto_complete_restore: Whether to auto complete restore of this managed database.
        :paramtype auto_complete_restore: bool
        :keyword last_backup_name: Last backup file name for restore of this managed database.
        :paramtype last_backup_name: str
        :keyword cross_subscription_target_managed_instance_id: Target managed instance id used in
         cross-subscription restore.
        :paramtype cross_subscription_target_managed_instance_id: str
        :keyword is_ledger_on: Whether or not this database is a ledger database, which means all
         tables in the database are ledger tables. Note: the value of this property cannot be changed
         after the database has been created.
        :paramtype is_ledger_on: bool
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.collation = collation
        self.status: Optional[Union[str, "_models.ManagedDatabaseStatus"]] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.earliest_restore_point: Optional[datetime.datetime] = None
        self.restore_point_in_time = restore_point_in_time
        self.default_secondary_location: Optional[str] = None
        self.catalog_collation = catalog_collation
        self.create_mode = create_mode
        self.storage_container_uri = storage_container_uri
        self.source_database_id = source_database_id
        self.cross_subscription_source_database_id = cross_subscription_source_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.cross_subscription_restorable_dropped_database_id = cross_subscription_restorable_dropped_database_id
        self.storage_container_identity = storage_container_identity
        self.storage_container_sas_token = storage_container_sas_token
        self.failover_group_id: Optional[str] = None
        self.recoverable_database_id = recoverable_database_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.auto_complete_restore = auto_complete_restore
        self.last_backup_name = last_backup_name
        self.cross_subscription_target_managed_instance_id = cross_subscription_target_managed_instance_id
        self.is_ledger_on = is_ledger_on
        self.extended_accessibility_info: Optional["_models.ManagedDatabaseExtendedAccessibilityInfo"] = None


class ManagedDatabaseAdvancedThreatProtection(ProxyResource):
    """A managed database Advanced Threat Protection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of AdvancedThreatProtectionResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "New", "Enabled", and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "New", "Enabled", and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.creation_time: Optional[datetime.datetime] = None


class ManagedDatabaseAdvancedThreatProtectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the managed database's Advanced Threat Protection settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabaseAdvancedThreatProtection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedDatabaseAdvancedThreatProtection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedDatabaseAdvancedThreatProtection"]] = None
        self.next_link: Optional[str] = None


class ManagedDatabaseExtendedAccessibilityInfo(_serialization.Model):
    """Managed Database Extended Accessibility Information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar inaccessibility_reason_error_code: SQL Server error code connected to the inaccessibility
     root cause. Required.
    :vartype inaccessibility_reason_error_code: str
    :ivar inaccessibility_reason_description: Root cause explanation and mitigation action.
     Required.
    :vartype inaccessibility_reason_description: str
    :ivar inaccessibility_reason_kind: Root cause kind. Allowed values are
     “TransparentDataEncryption”, “DatabaseReplication”, and “Unknown”. Required. Known values are:
     "Unknown", "TransparentDataEncryption", and "DatabaseReplication".
    :vartype inaccessibility_reason_kind: str or ~azure.mgmt.sql.models.InaccessibilityReason
    :ivar inaccessibility_reason_tde_key_uri: For the root cause kind “TransparentDataEncryption”,
     the CMK URI.
    :vartype inaccessibility_reason_tde_key_uri: str
    """

    _validation = {
        "inaccessibility_reason_error_code": {"required": True, "readonly": True},
        "inaccessibility_reason_description": {"required": True, "readonly": True},
        "inaccessibility_reason_kind": {"required": True, "readonly": True},
        "inaccessibility_reason_tde_key_uri": {"readonly": True},
    }

    _attribute_map = {
        "inaccessibility_reason_error_code": {"key": "inaccessibilityReasonErrorCode", "type": "str"},
        "inaccessibility_reason_description": {"key": "inaccessibilityReasonDescription", "type": "str"},
        "inaccessibility_reason_kind": {"key": "inaccessibilityReasonKind", "type": "str"},
        "inaccessibility_reason_tde_key_uri": {"key": "inaccessibilityReasonTdeKeyUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.inaccessibility_reason_error_code: Optional[str] = None
        self.inaccessibility_reason_description: Optional[str] = None
        self.inaccessibility_reason_kind: Optional[Union[str, "_models.InaccessibilityReason"]] = None
        self.inaccessibility_reason_tde_key_uri: Optional[str] = None


class ManagedDatabaseListResult(_serialization.Model):
    """A list of managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedDatabase"]] = None
        self.next_link: Optional[str] = None


class ManagedDatabaseMoveDefinition(_serialization.Model):
    """Contains the information necessary to perform a managed database move.

    All required parameters must be populated in order to send to server.

    :ivar destination_managed_database_id: The destination managed database ID. Required.
    :vartype destination_managed_database_id: str
    """

    _validation = {
        "destination_managed_database_id": {"required": True},
    }

    _attribute_map = {
        "destination_managed_database_id": {"key": "destinationManagedDatabaseId", "type": "str"},
    }

    def __init__(self, *, destination_managed_database_id: str, **kwargs: Any) -> None:
        """
        :keyword destination_managed_database_id: The destination managed database ID. Required.
        :paramtype destination_managed_database_id: str
        """
        super().__init__(**kwargs)
        self.destination_managed_database_id = destination_managed_database_id


class ManagedDatabaseMoveOperationListResult(_serialization.Model):
    """List of managed database move operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabaseMoveOperationResult]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedDatabaseMoveOperationResult]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedDatabaseMoveOperationResult"]] = None
        self.next_link: Optional[str] = None


class ManagedDatabaseMoveOperationResult(ProxyResource):
    """A managed database move operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar operation_mode: Operation mode. Known values are: "Move" and "Copy".
    :vartype operation_mode: str or ~azure.mgmt.sql.models.MoveOperationMode
    :ivar source_managed_instance_name: Source Managed Instance name.
    :vartype source_managed_instance_name: str
    :ivar target_managed_instance_name: Target Managed Instance name.
    :vartype target_managed_instance_name: str
    :ivar source_managed_instance_id: Source Managed Instance resource id.
    :vartype source_managed_instance_id: str
    :ivar target_managed_instance_id: Target Managed instance resource id.
    :vartype target_managed_instance_id: str
    :ivar source_database_name: Source database name.
    :vartype source_database_name: str
    :ivar target_database_name: Target database name.
    :vartype target_database_name: str
    :ivar is_cancellable: Is move operation cancellable.
    :vartype is_cancellable: bool
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "operation_mode": {"readonly": True},
        "source_managed_instance_name": {"readonly": True},
        "target_managed_instance_name": {"readonly": True},
        "source_managed_instance_id": {"readonly": True},
        "target_managed_instance_id": {"readonly": True},
        "source_database_name": {"readonly": True},
        "target_database_name": {"readonly": True},
        "is_cancellable": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "is_user_error": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "operation_mode": {"key": "properties.operationMode", "type": "str"},
        "source_managed_instance_name": {"key": "properties.sourceManagedInstanceName", "type": "str"},
        "target_managed_instance_name": {"key": "properties.targetManagedInstanceName", "type": "str"},
        "source_managed_instance_id": {"key": "properties.sourceManagedInstanceId", "type": "str"},
        "target_managed_instance_id": {"key": "properties.targetManagedInstanceId", "type": "str"},
        "source_database_name": {"key": "properties.sourceDatabaseName", "type": "str"},
        "target_database_name": {"key": "properties.targetDatabaseName", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "is_user_error": {"key": "properties.isUserError", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.ManagementOperationState"]] = None
        self.operation_mode: Optional[Union[str, "_models.MoveOperationMode"]] = None
        self.source_managed_instance_name: Optional[str] = None
        self.target_managed_instance_name: Optional[str] = None
        self.source_managed_instance_id: Optional[str] = None
        self.target_managed_instance_id: Optional[str] = None
        self.source_database_name: Optional[str] = None
        self.target_database_name: Optional[str] = None
        self.is_cancellable: Optional[bool] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.is_user_error: Optional[bool] = None


class ManagedDatabaseRestoreDetailsBackupSetProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The managed database's restore details backup set properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Backup set status.
    :vartype status: str
    :ivar first_stripe_name: First stripe name.
    :vartype first_stripe_name: str
    :ivar number_of_stripes: Number of stripes.
    :vartype number_of_stripes: int
    :ivar backup_size_mb: Backup size.
    :vartype backup_size_mb: int
    :ivar restore_started_timestamp_utc: Last restored file time.
    :vartype restore_started_timestamp_utc: ~datetime.datetime
    :ivar restore_finished_timestamp_utc: Last restored file time.
    :vartype restore_finished_timestamp_utc: ~datetime.datetime
    """

    _validation = {
        "status": {"readonly": True},
        "first_stripe_name": {"readonly": True},
        "number_of_stripes": {"readonly": True},
        "backup_size_mb": {"readonly": True},
        "restore_started_timestamp_utc": {"readonly": True},
        "restore_finished_timestamp_utc": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "first_stripe_name": {"key": "firstStripeName", "type": "str"},
        "number_of_stripes": {"key": "numberOfStripes", "type": "int"},
        "backup_size_mb": {"key": "backupSizeMB", "type": "int"},
        "restore_started_timestamp_utc": {"key": "restoreStartedTimestampUtc", "type": "iso-8601"},
        "restore_finished_timestamp_utc": {"key": "restoreFinishedTimestampUtc", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status: Optional[str] = None
        self.first_stripe_name: Optional[str] = None
        self.number_of_stripes: Optional[int] = None
        self.backup_size_mb: Optional[int] = None
        self.restore_started_timestamp_utc: Optional[datetime.datetime] = None
        self.restore_finished_timestamp_utc: Optional[datetime.datetime] = None


class ManagedDatabaseRestoreDetailsResult(ProxyResource):
    """A managed database restore details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar type_properties_type: Restore type.
    :vartype type_properties_type: str
    :ivar status: Restore status.
    :vartype status: str
    :ivar block_reason: The reason why restore is in Blocked state.
    :vartype block_reason: str
    :ivar last_uploaded_file_name: Last uploaded file name.
    :vartype last_uploaded_file_name: str
    :ivar last_uploaded_file_time: Last uploaded file time.
    :vartype last_uploaded_file_time: ~datetime.datetime
    :ivar last_restored_file_name: Last restored file name.
    :vartype last_restored_file_name: str
    :ivar last_restored_file_time: Last restored file time.
    :vartype last_restored_file_time: ~datetime.datetime
    :ivar percent_completed: Percent completed.
    :vartype percent_completed: int
    :ivar current_restored_size_mb: Current restored size MB.
    :vartype current_restored_size_mb: int
    :ivar current_restore_plan_size_mb: Current restore plan size MB.
    :vartype current_restore_plan_size_mb: int
    :ivar current_backup_type: Current backup type.
    :vartype current_backup_type: str
    :ivar current_restoring_file_name: Current restoring file name.
    :vartype current_restoring_file_name: str
    :ivar number_of_files_detected: Number of files detected.
    :vartype number_of_files_detected: int
    :ivar number_of_files_queued: Number of files queued.
    :vartype number_of_files_queued: int
    :ivar number_of_files_skipped: Number of files skipped.
    :vartype number_of_files_skipped: int
    :ivar number_of_files_restoring: Number of files restoring.
    :vartype number_of_files_restoring: int
    :ivar number_of_files_restored: Number of files restored.
    :vartype number_of_files_restored: int
    :ivar number_of_files_unrestorable: Number of files unrestorable.
    :vartype number_of_files_unrestorable: int
    :ivar full_backup_sets: Full backup sets.
    :vartype full_backup_sets:
     list[~azure.mgmt.sql.models.ManagedDatabaseRestoreDetailsBackupSetProperties]
    :ivar diff_backup_sets: Diff backup sets.
    :vartype diff_backup_sets:
     list[~azure.mgmt.sql.models.ManagedDatabaseRestoreDetailsBackupSetProperties]
    :ivar log_backup_sets: Log backup sets.
    :vartype log_backup_sets:
     list[~azure.mgmt.sql.models.ManagedDatabaseRestoreDetailsBackupSetProperties]
    :ivar unrestorable_files: Unrestorable files.
    :vartype unrestorable_files:
     list[~azure.mgmt.sql.models.ManagedDatabaseRestoreDetailsUnrestorableFileProperties]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "type_properties_type": {"readonly": True},
        "status": {"readonly": True},
        "block_reason": {"readonly": True},
        "last_uploaded_file_name": {"readonly": True},
        "last_uploaded_file_time": {"readonly": True},
        "last_restored_file_name": {"readonly": True},
        "last_restored_file_time": {"readonly": True},
        "percent_completed": {"readonly": True},
        "current_restored_size_mb": {"readonly": True},
        "current_restore_plan_size_mb": {"readonly": True},
        "current_backup_type": {"readonly": True},
        "current_restoring_file_name": {"readonly": True},
        "number_of_files_detected": {"readonly": True},
        "number_of_files_queued": {"readonly": True},
        "number_of_files_skipped": {"readonly": True},
        "number_of_files_restoring": {"readonly": True},
        "number_of_files_restored": {"readonly": True},
        "number_of_files_unrestorable": {"readonly": True},
        "full_backup_sets": {"readonly": True},
        "diff_backup_sets": {"readonly": True},
        "log_backup_sets": {"readonly": True},
        "unrestorable_files": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "block_reason": {"key": "properties.blockReason", "type": "str"},
        "last_uploaded_file_name": {"key": "properties.lastUploadedFileName", "type": "str"},
        "last_uploaded_file_time": {"key": "properties.lastUploadedFileTime", "type": "iso-8601"},
        "last_restored_file_name": {"key": "properties.lastRestoredFileName", "type": "str"},
        "last_restored_file_time": {"key": "properties.lastRestoredFileTime", "type": "iso-8601"},
        "percent_completed": {"key": "properties.percentCompleted", "type": "int"},
        "current_restored_size_mb": {"key": "properties.currentRestoredSizeMB", "type": "int"},
        "current_restore_plan_size_mb": {"key": "properties.currentRestorePlanSizeMB", "type": "int"},
        "current_backup_type": {"key": "properties.currentBackupType", "type": "str"},
        "current_restoring_file_name": {"key": "properties.currentRestoringFileName", "type": "str"},
        "number_of_files_detected": {"key": "properties.numberOfFilesDetected", "type": "int"},
        "number_of_files_queued": {"key": "properties.numberOfFilesQueued", "type": "int"},
        "number_of_files_skipped": {"key": "properties.numberOfFilesSkipped", "type": "int"},
        "number_of_files_restoring": {"key": "properties.numberOfFilesRestoring", "type": "int"},
        "number_of_files_restored": {"key": "properties.numberOfFilesRestored", "type": "int"},
        "number_of_files_unrestorable": {"key": "properties.numberOfFilesUnrestorable", "type": "int"},
        "full_backup_sets": {
            "key": "properties.fullBackupSets",
            "type": "[ManagedDatabaseRestoreDetailsBackupSetProperties]",
        },
        "diff_backup_sets": {
            "key": "properties.diffBackupSets",
            "type": "[ManagedDatabaseRestoreDetailsBackupSetProperties]",
        },
        "log_backup_sets": {
            "key": "properties.logBackupSets",
            "type": "[ManagedDatabaseRestoreDetailsBackupSetProperties]",
        },
        "unrestorable_files": {
            "key": "properties.unrestorableFiles",
            "type": "[ManagedDatabaseRestoreDetailsUnrestorableFileProperties]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:  # pylint: disable=too-many-locals
        """ """
        super().__init__(**kwargs)
        self.type_properties_type: Optional[str] = None
        self.status: Optional[str] = None
        self.block_reason: Optional[str] = None
        self.last_uploaded_file_name: Optional[str] = None
        self.last_uploaded_file_time: Optional[datetime.datetime] = None
        self.last_restored_file_name: Optional[str] = None
        self.last_restored_file_time: Optional[datetime.datetime] = None
        self.percent_completed: Optional[int] = None
        self.current_restored_size_mb: Optional[int] = None
        self.current_restore_plan_size_mb: Optional[int] = None
        self.current_backup_type: Optional[str] = None
        self.current_restoring_file_name: Optional[str] = None
        self.number_of_files_detected: Optional[int] = None
        self.number_of_files_queued: Optional[int] = None
        self.number_of_files_skipped: Optional[int] = None
        self.number_of_files_restoring: Optional[int] = None
        self.number_of_files_restored: Optional[int] = None
        self.number_of_files_unrestorable: Optional[int] = None
        self.full_backup_sets: Optional[List["_models.ManagedDatabaseRestoreDetailsBackupSetProperties"]] = None
        self.diff_backup_sets: Optional[List["_models.ManagedDatabaseRestoreDetailsBackupSetProperties"]] = None
        self.log_backup_sets: Optional[List["_models.ManagedDatabaseRestoreDetailsBackupSetProperties"]] = None
        self.unrestorable_files: Optional[List["_models.ManagedDatabaseRestoreDetailsUnrestorableFileProperties"]] = (
            None
        )


class ManagedDatabaseRestoreDetailsUnrestorableFileProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The managed database's restore details unrestorable file properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: File name.
    :vartype name: str
    """

    _validation = {
        "name": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None


class ManagedDatabaseSecurityAlertPolicy(ProxyResource):
    """A managed database security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Known values are: "New", "Enabled", and
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
    :ivar disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :vartype disabled_alerts: list[str]
    :ivar email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :vartype email_addresses: list[str]
    :ivar email_account_admins: Specifies that the alert is sent to the account administrators.
    :vartype email_account_admins: bool
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :vartype storage_account_access_key: str
    :ivar retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :vartype retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "disabled_alerts": {"key": "properties.disabledAlerts", "type": "[str]"},
        "email_addresses": {"key": "properties.emailAddresses", "type": "[str]"},
        "email_account_admins": {"key": "properties.emailAccountAdmins", "type": "bool"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SecurityAlertPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the policy, whether it is enabled or disabled or a
         policy has not been applied yet on the specific database. Known values are: "New", "Enabled",
         and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SecurityAlertPolicyState
        :keyword disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
         Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
         Brute_Force.
        :paramtype disabled_alerts: list[str]
        :keyword email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
        :paramtype email_addresses: list[str]
        :keyword email_account_admins: Specifies that the alert is sent to the account administrators.
        :paramtype email_account_admins: bool
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
         audit logs.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the Threat Detection audit
         storage account.
        :paramtype storage_account_access_key: str
        :keyword retention_days: Specifies the number of days to keep in the Threat Detection audit
         logs.
        :paramtype retention_days: int
        """
        super().__init__(**kwargs)
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time: Optional[datetime.datetime] = None


class ManagedDatabaseSecurityAlertPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the managed database's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedDatabaseSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedDatabaseSecurityAlertPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedDatabaseSecurityAlertPolicy"]] = None
        self.next_link: Optional[str] = None


class ManagedDatabaseStartMoveDefinition(_serialization.Model):
    """Contains the information necessary to start a managed database move.

    All required parameters must be populated in order to send to server.

    :ivar destination_managed_database_id: The destination managed database ID. Required.
    :vartype destination_managed_database_id: str
    :ivar operation_mode: The move operation mode. Known values are: "Move" and "Copy".
    :vartype operation_mode: str or ~azure.mgmt.sql.models.MoveOperationMode
    """

    _validation = {
        "destination_managed_database_id": {"required": True},
    }

    _attribute_map = {
        "destination_managed_database_id": {"key": "destinationManagedDatabaseId", "type": "str"},
        "operation_mode": {"key": "operationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        destination_managed_database_id: str,
        operation_mode: Optional[Union[str, "_models.MoveOperationMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword destination_managed_database_id: The destination managed database ID. Required.
        :paramtype destination_managed_database_id: str
        :keyword operation_mode: The move operation mode. Known values are: "Move" and "Copy".
        :paramtype operation_mode: str or ~azure.mgmt.sql.models.MoveOperationMode
        """
        super().__init__(**kwargs)
        self.destination_managed_database_id = destination_managed_database_id
        self.operation_mode = operation_mode


class ManagedDatabaseUpdate(_serialization.Model):
    """An managed database update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar collation: Collation of the managed database.
    :vartype collation: str
    :ivar status: Status of the database. Known values are: "Online", "Offline", "Shutdown",
     "Creating", "Inaccessible", "Restoring", "Updating", "Stopping", "Stopped", "Starting",
     "DbMoving", and "DbCopying".
    :vartype status: str or ~azure.mgmt.sql.models.ManagedDatabaseStatus
    :ivar creation_date: Creation date of the database.
    :vartype creation_date: ~datetime.datetime
    :ivar earliest_restore_point: Earliest restore point in time for point in time restore.
    :vartype earliest_restore_point: ~datetime.datetime
    :ivar restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
     required. Specifies the point in time (ISO8601 format) of the source database that will be
     restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar default_secondary_location: Geo paired region.
    :vartype default_secondary_location: str
    :ivar catalog_collation: Collation of the metadata catalog. Known values are:
     "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
    :vartype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
    :ivar create_mode: Managed database create mode. PointInTimeRestore: Create a database by
     restoring a point in time backup of an existing database. SourceDatabaseName,
     SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
     database by restoring from external backup files. Collation, StorageContainerUri and
     StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
     geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
     resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
     long term retention backup (longTermRetentionBackupResourceId required). Known values are:
     "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery", and
     "RestoreLongTermRetentionBackup".
    :vartype create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
    :ivar storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value is
     required. Specifies the uri of the storage container where backups for this restore are stored.
    :vartype storage_container_uri: str
    :ivar source_database_id: The resource identifier of the source database associated with create
     operation of this database.
    :vartype source_database_id: str
    :ivar cross_subscription_source_database_id: The resource identifier of the cross-subscription
     source database associated with create operation of this database.
    :vartype cross_subscription_source_database_id: str
    :ivar restorable_dropped_database_id: The restorable dropped database resource id to restore
     when creating this database.
    :vartype restorable_dropped_database_id: str
    :ivar cross_subscription_restorable_dropped_database_id: The restorable cross-subscription
     dropped database resource id to restore when creating this database.
    :vartype cross_subscription_restorable_dropped_database_id: str
    :ivar storage_container_identity: Conditional. If createMode is RestoreExternalBackup, this
     value is used. Specifies the identity used for storage container authentication. Can be
     'SharedAccessSignature' or 'ManagedIdentity'; if not specified 'SharedAccessSignature' is
     assumed.
    :vartype storage_container_identity: str
    :ivar storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup and
     storageContainerIdentity is not ManagedIdentity, this value is required. Specifies the storage
     container sas token.
    :vartype storage_container_sas_token: str
    :ivar failover_group_id: Instance Failover Group resource identifier that this managed database
     belongs to.
    :vartype failover_group_id: str
    :ivar recoverable_database_id: The resource identifier of the recoverable database associated
     with create operation of this database.
    :vartype recoverable_database_id: str
    :ivar long_term_retention_backup_resource_id: The name of the Long Term Retention backup to be
     used for restore of this managed database.
    :vartype long_term_retention_backup_resource_id: str
    :ivar auto_complete_restore: Whether to auto complete restore of this managed database.
    :vartype auto_complete_restore: bool
    :ivar last_backup_name: Last backup file name for restore of this managed database.
    :vartype last_backup_name: str
    :ivar cross_subscription_target_managed_instance_id: Target managed instance id used in
     cross-subscription restore.
    :vartype cross_subscription_target_managed_instance_id: str
    :ivar is_ledger_on: Whether or not this database is a ledger database, which means all tables
     in the database are ledger tables. Note: the value of this property cannot be changed after the
     database has been created.
    :vartype is_ledger_on: bool
    :ivar extended_accessibility_info: Additional observability and troubleshooting information for
     databases in ‘Inaccessible’ state.
    :vartype extended_accessibility_info:
     ~azure.mgmt.sql.models.ManagedDatabaseExtendedAccessibilityInfo
    """

    _validation = {
        "status": {"readonly": True},
        "creation_date": {"readonly": True},
        "earliest_restore_point": {"readonly": True},
        "default_secondary_location": {"readonly": True},
        "failover_group_id": {"readonly": True},
        "extended_accessibility_info": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "collation": {"key": "properties.collation", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "earliest_restore_point": {"key": "properties.earliestRestorePoint", "type": "iso-8601"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "default_secondary_location": {"key": "properties.defaultSecondaryLocation", "type": "str"},
        "catalog_collation": {"key": "properties.catalogCollation", "type": "str"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
        "storage_container_uri": {"key": "properties.storageContainerUri", "type": "str"},
        "source_database_id": {"key": "properties.sourceDatabaseId", "type": "str"},
        "cross_subscription_source_database_id": {"key": "properties.crossSubscriptionSourceDatabaseId", "type": "str"},
        "restorable_dropped_database_id": {"key": "properties.restorableDroppedDatabaseId", "type": "str"},
        "cross_subscription_restorable_dropped_database_id": {
            "key": "properties.crossSubscriptionRestorableDroppedDatabaseId",
            "type": "str",
        },
        "storage_container_identity": {"key": "properties.storageContainerIdentity", "type": "str"},
        "storage_container_sas_token": {"key": "properties.storageContainerSasToken", "type": "str"},
        "failover_group_id": {"key": "properties.failoverGroupId", "type": "str"},
        "recoverable_database_id": {"key": "properties.recoverableDatabaseId", "type": "str"},
        "long_term_retention_backup_resource_id": {
            "key": "properties.longTermRetentionBackupResourceId",
            "type": "str",
        },
        "auto_complete_restore": {"key": "properties.autoCompleteRestore", "type": "bool"},
        "last_backup_name": {"key": "properties.lastBackupName", "type": "str"},
        "cross_subscription_target_managed_instance_id": {
            "key": "properties.crossSubscriptionTargetManagedInstanceId",
            "type": "str",
        },
        "is_ledger_on": {"key": "properties.isLedgerOn", "type": "bool"},
        "extended_accessibility_info": {
            "key": "properties.extendedAccessibilityInfo",
            "type": "ManagedDatabaseExtendedAccessibilityInfo",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        collation: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        catalog_collation: Optional[Union[str, "_models.CatalogCollationType"]] = None,
        create_mode: Optional[Union[str, "_models.ManagedDatabaseCreateMode"]] = None,
        storage_container_uri: Optional[str] = None,
        source_database_id: Optional[str] = None,
        cross_subscription_source_database_id: Optional[str] = None,
        restorable_dropped_database_id: Optional[str] = None,
        cross_subscription_restorable_dropped_database_id: Optional[str] = None,
        storage_container_identity: Optional[str] = None,
        storage_container_sas_token: Optional[str] = None,
        recoverable_database_id: Optional[str] = None,
        long_term_retention_backup_resource_id: Optional[str] = None,
        auto_complete_restore: Optional[bool] = None,
        last_backup_name: Optional[str] = None,
        cross_subscription_target_managed_instance_id: Optional[str] = None,
        is_ledger_on: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword collation: Collation of the managed database.
        :paramtype collation: str
        :keyword restore_point_in_time: Conditional. If createMode is PointInTimeRestore, this value is
         required. Specifies the point in time (ISO8601 format) of the source database that will be
         restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword catalog_collation: Collation of the metadata catalog. Known values are:
         "DATABASE_DEFAULT" and "SQL_Latin1_General_CP1_CI_AS".
        :paramtype catalog_collation: str or ~azure.mgmt.sql.models.CatalogCollationType
        :keyword create_mode: Managed database create mode. PointInTimeRestore: Create a database by
         restoring a point in time backup of an existing database. SourceDatabaseName,
         SourceManagedInstanceName and PointInTime must be specified. RestoreExternalBackup: Create a
         database by restoring from external backup files. Collation, StorageContainerUri and
         StorageContainerSasToken must be specified. Recovery: Creates a database by restoring a
         geo-replicated backup. RecoverableDatabaseId must be specified as the recoverable database
         resource ID to restore. RestoreLongTermRetentionBackup: Create a database by restoring from a
         long term retention backup (longTermRetentionBackupResourceId required). Known values are:
         "Default", "RestoreExternalBackup", "PointInTimeRestore", "Recovery", and
         "RestoreLongTermRetentionBackup".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.ManagedDatabaseCreateMode
        :keyword storage_container_uri: Conditional. If createMode is RestoreExternalBackup, this value
         is required. Specifies the uri of the storage container where backups for this restore are
         stored.
        :paramtype storage_container_uri: str
        :keyword source_database_id: The resource identifier of the source database associated with
         create operation of this database.
        :paramtype source_database_id: str
        :keyword cross_subscription_source_database_id: The resource identifier of the
         cross-subscription source database associated with create operation of this database.
        :paramtype cross_subscription_source_database_id: str
        :keyword restorable_dropped_database_id: The restorable dropped database resource id to restore
         when creating this database.
        :paramtype restorable_dropped_database_id: str
        :keyword cross_subscription_restorable_dropped_database_id: The restorable cross-subscription
         dropped database resource id to restore when creating this database.
        :paramtype cross_subscription_restorable_dropped_database_id: str
        :keyword storage_container_identity: Conditional. If createMode is RestoreExternalBackup, this
         value is used. Specifies the identity used for storage container authentication. Can be
         'SharedAccessSignature' or 'ManagedIdentity'; if not specified 'SharedAccessSignature' is
         assumed.
        :paramtype storage_container_identity: str
        :keyword storage_container_sas_token: Conditional. If createMode is RestoreExternalBackup and
         storageContainerIdentity is not ManagedIdentity, this value is required. Specifies the storage
         container sas token.
        :paramtype storage_container_sas_token: str
        :keyword recoverable_database_id: The resource identifier of the recoverable database
         associated with create operation of this database.
        :paramtype recoverable_database_id: str
        :keyword long_term_retention_backup_resource_id: The name of the Long Term Retention backup to
         be used for restore of this managed database.
        :paramtype long_term_retention_backup_resource_id: str
        :keyword auto_complete_restore: Whether to auto complete restore of this managed database.
        :paramtype auto_complete_restore: bool
        :keyword last_backup_name: Last backup file name for restore of this managed database.
        :paramtype last_backup_name: str
        :keyword cross_subscription_target_managed_instance_id: Target managed instance id used in
         cross-subscription restore.
        :paramtype cross_subscription_target_managed_instance_id: str
        :keyword is_ledger_on: Whether or not this database is a ledger database, which means all
         tables in the database are ledger tables. Note: the value of this property cannot be changed
         after the database has been created.
        :paramtype is_ledger_on: bool
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.collation = collation
        self.status: Optional[Union[str, "_models.ManagedDatabaseStatus"]] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.earliest_restore_point: Optional[datetime.datetime] = None
        self.restore_point_in_time = restore_point_in_time
        self.default_secondary_location: Optional[str] = None
        self.catalog_collation = catalog_collation
        self.create_mode = create_mode
        self.storage_container_uri = storage_container_uri
        self.source_database_id = source_database_id
        self.cross_subscription_source_database_id = cross_subscription_source_database_id
        self.restorable_dropped_database_id = restorable_dropped_database_id
        self.cross_subscription_restorable_dropped_database_id = cross_subscription_restorable_dropped_database_id
        self.storage_container_identity = storage_container_identity
        self.storage_container_sas_token = storage_container_sas_token
        self.failover_group_id: Optional[str] = None
        self.recoverable_database_id = recoverable_database_id
        self.long_term_retention_backup_resource_id = long_term_retention_backup_resource_id
        self.auto_complete_restore = auto_complete_restore
        self.last_backup_name = last_backup_name
        self.cross_subscription_target_managed_instance_id = cross_subscription_target_managed_instance_id
        self.is_ledger_on = is_ledger_on
        self.extended_accessibility_info: Optional["_models.ManagedDatabaseExtendedAccessibilityInfo"] = None


class ManagedInstance(TrackedResource):
    """An Azure SQL managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The Azure Active Directory identity of the managed instance.
    :vartype identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar sku: Managed instance SKU. Allowed values for sku.name: GP_Gen5 (General Purpose,
     Standard-series); GP_G8IM (General Purpose, Premium-series); GP_G8IH (General Purpose,
     Premium-series memory optimized); BC_Gen5 (Business Critical, Standard-Series); BC_G8IM
     (Business Critical, Premium-series); BC_G8IH (Business Critical, Premium-series memory
     optimized).
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar provisioning_state: Provisioning state of managed instance. Known values are: "Created",
     "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    :ivar managed_instance_create_mode: Specifies the mode of database creation.

     Default: Regular instance creation.

     Restore: Creates an instance by restoring a set of backups to specific point in time.
     RestorePointInTime and SourceManagedInstanceId must be specified. Known values are: "Default"
     and "PointInTimeRestore".
    :vartype managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the managed instance.
    :vartype fully_qualified_domain_name: str
    :ivar is_general_purpose_v2: Whether or not this is a GPv2 variant of General Purpose edition.
    :vartype is_general_purpose_v2: bool
    :ivar administrator_login: Administrator username for the managed instance. Can only be
     specified when the managed instance is being created (and is required for creation).
    :vartype administrator_login: str
    :ivar administrator_login_password: The administrator login password (required for managed
     instance creation).
    :vartype administrator_login_password: str
    :ivar subnet_id: Subnet resource ID for the managed instance.
    :vartype subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :ivar license_type: The license type. Possible values are 'LicenseIncluded' (regular price
     inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
     licenses). Known values are: "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :ivar hybrid_secondary_usage: Hybrid secondary usage. Possible values are 'Active' (default
     value) and 'Passive' (customer uses the secondary as Passive DR). Known values are: "Active"
     and "Passive".
    :vartype hybrid_secondary_usage: str or ~azure.mgmt.sql.models.HybridSecondaryUsage
    :ivar hybrid_secondary_usage_detected: Hybrid secondary usage detected. Possible values are
     'Active' (customer does not meet the requirements to use the secondary as Passive DR) and
     'Passive' (customer meets the requirements to use the secondary as Passive DR). Known values
     are: "Active" and "Passive".
    :vartype hybrid_secondary_usage_detected: str or
     ~azure.mgmt.sql.models.HybridSecondaryUsageDetected
    :ivar v_cores: The number of vCores. Allowed values: 4, 6, 8, 10, 12, 16, 20, 24, 32, 40, 48,
     56, 64, 80, 96, 128. Supported vCores depends on the selected hardware family and service tier.
    :vartype v_cores: int
    :ivar storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 32768.
     Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and
     number of vCores.
    :vartype storage_size_in_gb: int
    :ivar storage_iops: Storage IOps. Minimum value: 300. Maximum value: 80000. Increments of 1
     IOps allowed only. Maximum value depends on the selected hardware family and number of vCores.
    :vartype storage_iops: int
    :ivar storage_throughput_mbps: Storage throughput MBps parameter is not supported in the
     instance create/update operation.
    :vartype storage_throughput_mbps: int
    :ivar memory_size_in_gb: Memory size in GB. Minimum value: 28. Maximum value: 870. Minimum and
     maximum value depend on the number of vCores and service tier. Read more about resource limits:
     https://aka.ms/mi-resource-limits-api.
    :vartype memory_size_in_gb: int
    :ivar collation: Collation of the managed instance.
    :vartype collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :ivar dns_zone_partner: The resource id of another managed instance whose DNS zone this managed
     instance will share after creation.
    :vartype dns_zone_partner: str
    :ivar public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
    :vartype public_data_endpoint_enabled: bool
    :ivar source_managed_instance_id: The resource identifier of the source managed instance
     associated with create operation of this instance.
    :vartype source_managed_instance_id: str
    :ivar restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar proxy_override: Connection type used for connecting to the instance. Known values are:
     "Proxy", "Redirect", and "Default".
    :vartype proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :ivar timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
     Windows keeps details on supported timezones, including the id, in registry under
     KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones.
     You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
     sys.time_zone_info.
     List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
     PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
    :vartype timezone_id: str
    :ivar instance_pool_id: The Id of the instance pool this managed server belongs to.
    :vartype instance_pool_id: str
    :ivar maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :vartype maintenance_configuration_id: str
    :ivar private_endpoint_connections: List of private endpoint connections on a managed instance.
    :vartype private_endpoint_connections: list[~azure.mgmt.sql.models.ManagedInstancePecProperty]
    :ivar minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
    :vartype minimal_tls_version: str
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage),
     Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known values are: "Geo",
     "Local", "Zone", and "GeoZone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar requested_backup_storage_redundancy: The storage account type to be used to store backups
     for this instance. The options are Local (LocallyRedundantStorage), Zone
     (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known
     values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar zone_redundant: Whether or not the zone-redundancy is enabled.
    :vartype zone_redundant: bool
    :ivar primary_user_assigned_identity_id: The resource id of a user assigned identity to be used
     by default.
    :vartype primary_user_assigned_identity_id: str
    :ivar key_id: A CMK URI of the key to use for encryption.
    :vartype key_id: str
    :ivar administrators: The Azure Active Directory administrator can be utilized during instance
     creation and for instance updates, except for the azureADOnlyAuthentication property. To update
     the azureADOnlyAuthentication property, individual API must be used.
    :vartype administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
    :ivar service_principal: The managed instance's service principal.
    :vartype service_principal: ~azure.mgmt.sql.models.ServicePrincipal
    :ivar virtual_cluster_id: Virtual cluster resource id for the Managed Instance.
    :vartype virtual_cluster_id: str
    :ivar external_governance_status: Status of external governance. Known values are: "Enabled"
     and "Disabled".
    :vartype external_governance_status: str or ~azure.mgmt.sql.models.ExternalGovernanceStatus
    :ivar pricing_model: Pricing model of Managed Instance. Known values are: "Regular" and
     "Freemium".
    :vartype pricing_model: str or ~azure.mgmt.sql.models.PricingModel
    :ivar create_time: Specifies the point in time (ISO8601 format) of the Managed Instance
     creation.
    :vartype create_time: ~datetime.datetime
    :ivar authentication_metadata: The managed instance's authentication metadata lookup mode.
     Known values are: "AzureAD", "Paired", and "Windows".
    :vartype authentication_metadata: str or ~azure.mgmt.sql.models.AuthMetadataLookupModes
    :ivar database_format: Specifies the internal format of instance databases specific to the SQL
     engine version. Known values are: "AlwaysUpToDate", "SQLServer2022", and "SQLServer2025".
    :vartype database_format: str or ~azure.mgmt.sql.models.ManagedInstanceDatabaseFormat
    :ivar requested_logical_availability_zone: Specifies the logical availability zone Managed
     Instance is pinned to. Known values are: "NoPreference", "1", "2", and "3".
    :vartype requested_logical_availability_zone: str or
     ~azure.mgmt.sql.models.AvailabilityZoneType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "state": {"readonly": True},
        "hybrid_secondary_usage_detected": {"readonly": True},
        "dns_zone": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "current_backup_storage_redundancy": {"readonly": True},
        "virtual_cluster_id": {"readonly": True},
        "external_governance_status": {"readonly": True},
        "create_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "sku": {"key": "sku", "type": "Sku"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "managed_instance_create_mode": {"key": "properties.managedInstanceCreateMode", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "is_general_purpose_v2": {"key": "properties.isGeneralPurposeV2", "type": "bool"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "hybrid_secondary_usage": {"key": "properties.hybridSecondaryUsage", "type": "str"},
        "hybrid_secondary_usage_detected": {"key": "properties.hybridSecondaryUsageDetected", "type": "str"},
        "v_cores": {"key": "properties.vCores", "type": "int"},
        "storage_size_in_gb": {"key": "properties.storageSizeInGB", "type": "int"},
        "storage_iops": {"key": "properties.storageIOps", "type": "int"},
        "storage_throughput_mbps": {"key": "properties.storageThroughputMBps", "type": "int"},
        "memory_size_in_gb": {"key": "properties.memorySizeInGB", "type": "int"},
        "collation": {"key": "properties.collation", "type": "str"},
        "dns_zone": {"key": "properties.dnsZone", "type": "str"},
        "dns_zone_partner": {"key": "properties.dnsZonePartner", "type": "str"},
        "public_data_endpoint_enabled": {"key": "properties.publicDataEndpointEnabled", "type": "bool"},
        "source_managed_instance_id": {"key": "properties.sourceManagedInstanceId", "type": "str"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "proxy_override": {"key": "properties.proxyOverride", "type": "str"},
        "timezone_id": {"key": "properties.timezoneId", "type": "str"},
        "instance_pool_id": {"key": "properties.instancePoolId", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ManagedInstancePecProperty]",
        },
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "current_backup_storage_redundancy": {"key": "properties.currentBackupStorageRedundancy", "type": "str"},
        "requested_backup_storage_redundancy": {"key": "properties.requestedBackupStorageRedundancy", "type": "str"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "primary_user_assigned_identity_id": {"key": "properties.primaryUserAssignedIdentityId", "type": "str"},
        "key_id": {"key": "properties.keyId", "type": "str"},
        "administrators": {"key": "properties.administrators", "type": "ManagedInstanceExternalAdministrator"},
        "service_principal": {"key": "properties.servicePrincipal", "type": "ServicePrincipal"},
        "virtual_cluster_id": {"key": "properties.virtualClusterId", "type": "str"},
        "external_governance_status": {"key": "properties.externalGovernanceStatus", "type": "str"},
        "pricing_model": {"key": "properties.pricingModel", "type": "str"},
        "create_time": {"key": "properties.createTime", "type": "iso-8601"},
        "authentication_metadata": {"key": "properties.authenticationMetadata", "type": "str"},
        "database_format": {"key": "properties.databaseFormat", "type": "str"},
        "requested_logical_availability_zone": {"key": "properties.requestedLogicalAvailabilityZone", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        managed_instance_create_mode: Optional[Union[str, "_models.ManagedServerCreateMode"]] = None,
        is_general_purpose_v2: Optional[bool] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        subnet_id: Optional[str] = None,
        license_type: Optional[Union[str, "_models.ManagedInstanceLicenseType"]] = None,
        hybrid_secondary_usage: Optional[Union[str, "_models.HybridSecondaryUsage"]] = None,
        v_cores: Optional[int] = None,
        storage_size_in_gb: Optional[int] = None,
        storage_iops: Optional[int] = None,
        storage_throughput_mbps: Optional[int] = None,
        memory_size_in_gb: Optional[int] = None,
        collation: Optional[str] = None,
        dns_zone_partner: Optional[str] = None,
        public_data_endpoint_enabled: Optional[bool] = None,
        source_managed_instance_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        proxy_override: Optional[Union[str, "_models.ManagedInstanceProxyOverride"]] = None,
        timezone_id: Optional[str] = None,
        instance_pool_id: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        zone_redundant: Optional[bool] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["_models.ManagedInstanceExternalAdministrator"] = None,
        service_principal: Optional["_models.ServicePrincipal"] = None,
        pricing_model: Optional[Union[str, "_models.PricingModel"]] = None,
        authentication_metadata: Optional[Union[str, "_models.AuthMetadataLookupModes"]] = None,
        database_format: Optional[Union[str, "_models.ManagedInstanceDatabaseFormat"]] = None,
        requested_logical_availability_zone: Optional[Union[str, "_models.AvailabilityZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The Azure Active Directory identity of the managed instance.
        :paramtype identity: ~azure.mgmt.sql.models.ResourceIdentity
        :keyword sku: Managed instance SKU. Allowed values for sku.name: GP_Gen5 (General Purpose,
         Standard-series); GP_G8IM (General Purpose, Premium-series); GP_G8IH (General Purpose,
         Premium-series memory optimized); BC_Gen5 (Business Critical, Standard-Series); BC_G8IM
         (Business Critical, Premium-series); BC_G8IH (Business Critical, Premium-series memory
         optimized).
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword managed_instance_create_mode: Specifies the mode of database creation.

         Default: Regular instance creation.

         Restore: Creates an instance by restoring a set of backups to specific point in time.
         RestorePointInTime and SourceManagedInstanceId must be specified. Known values are: "Default"
         and "PointInTimeRestore".
        :paramtype managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
        :keyword is_general_purpose_v2: Whether or not this is a GPv2 variant of General Purpose
         edition.
        :paramtype is_general_purpose_v2: bool
        :keyword administrator_login: Administrator username for the managed instance. Can only be
         specified when the managed instance is being created (and is required for creation).
        :paramtype administrator_login: str
        :keyword administrator_login_password: The administrator login password (required for managed
         instance creation).
        :paramtype administrator_login_password: str
        :keyword subnet_id: Subnet resource ID for the managed instance.
        :paramtype subnet_id: str
        :keyword license_type: The license type. Possible values are 'LicenseIncluded' (regular price
         inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
         licenses). Known values are: "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
        :keyword hybrid_secondary_usage: Hybrid secondary usage. Possible values are 'Active' (default
         value) and 'Passive' (customer uses the secondary as Passive DR). Known values are: "Active"
         and "Passive".
        :paramtype hybrid_secondary_usage: str or ~azure.mgmt.sql.models.HybridSecondaryUsage
        :keyword v_cores: The number of vCores. Allowed values: 4, 6, 8, 10, 12, 16, 20, 24, 32, 40,
         48, 56, 64, 80, 96, 128. Supported vCores depends on the selected hardware family and service
         tier.
        :paramtype v_cores: int
        :keyword storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 32768.
         Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and
         number of vCores.
        :paramtype storage_size_in_gb: int
        :keyword storage_iops: Storage IOps. Minimum value: 300. Maximum value: 80000. Increments of 1
         IOps allowed only. Maximum value depends on the selected hardware family and number of vCores.
        :paramtype storage_iops: int
        :keyword storage_throughput_mbps: Storage throughput MBps parameter is not supported in the
         instance create/update operation.
        :paramtype storage_throughput_mbps: int
        :keyword memory_size_in_gb: Memory size in GB. Minimum value: 28. Maximum value: 870. Minimum
         and maximum value depend on the number of vCores and service tier. Read more about resource
         limits: https://aka.ms/mi-resource-limits-api.
        :paramtype memory_size_in_gb: int
        :keyword collation: Collation of the managed instance.
        :paramtype collation: str
        :keyword dns_zone_partner: The resource id of another managed instance whose DNS zone this
         managed instance will share after creation.
        :paramtype dns_zone_partner: str
        :keyword public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
        :paramtype public_data_endpoint_enabled: bool
        :keyword source_managed_instance_id: The resource identifier of the source managed instance
         associated with create operation of this instance.
        :paramtype source_managed_instance_id: str
        :keyword restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
         database that will be restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword proxy_override: Connection type used for connecting to the instance. Known values are:
         "Proxy", "Redirect", and "Default".
        :paramtype proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
        :keyword timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
         Windows keeps details on supported timezones, including the id, in registry under
         KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones.
         You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
         sys.time_zone_info.
         List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
         PowerShell.
         An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
        :paramtype timezone_id: str
        :keyword instance_pool_id: The Id of the instance pool this managed server belongs to.
        :paramtype instance_pool_id: str
        :keyword maintenance_configuration_id: Specifies maintenance configuration id to apply to this
         managed instance.
        :paramtype maintenance_configuration_id: str
        :keyword minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
        :paramtype minimal_tls_version: str
        :keyword requested_backup_storage_redundancy: The storage account type to be used to store
         backups for this instance. The options are Local (LocallyRedundantStorage), Zone
         (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known
         values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype requested_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        :keyword zone_redundant: Whether or not the zone-redundancy is enabled.
        :paramtype zone_redundant: bool
        :keyword primary_user_assigned_identity_id: The resource id of a user assigned identity to be
         used by default.
        :paramtype primary_user_assigned_identity_id: str
        :keyword key_id: A CMK URI of the key to use for encryption.
        :paramtype key_id: str
        :keyword administrators: The Azure Active Directory administrator can be utilized during
         instance creation and for instance updates, except for the azureADOnlyAuthentication property.
         To update the azureADOnlyAuthentication property, individual API must be used.
        :paramtype administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
        :keyword service_principal: The managed instance's service principal.
        :paramtype service_principal: ~azure.mgmt.sql.models.ServicePrincipal
        :keyword pricing_model: Pricing model of Managed Instance. Known values are: "Regular" and
         "Freemium".
        :paramtype pricing_model: str or ~azure.mgmt.sql.models.PricingModel
        :keyword authentication_metadata: The managed instance's authentication metadata lookup mode.
         Known values are: "AzureAD", "Paired", and "Windows".
        :paramtype authentication_metadata: str or ~azure.mgmt.sql.models.AuthMetadataLookupModes
        :keyword database_format: Specifies the internal format of instance databases specific to the
         SQL engine version. Known values are: "AlwaysUpToDate", "SQLServer2022", and "SQLServer2025".
        :paramtype database_format: str or ~azure.mgmt.sql.models.ManagedInstanceDatabaseFormat
        :keyword requested_logical_availability_zone: Specifies the logical availability zone Managed
         Instance is pinned to. Known values are: "NoPreference", "1", "2", and "3".
        :paramtype requested_logical_availability_zone: str or
         ~azure.mgmt.sql.models.AvailabilityZoneType
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.sku = sku
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.managed_instance_create_mode = managed_instance_create_mode
        self.fully_qualified_domain_name: Optional[str] = None
        self.is_general_purpose_v2 = is_general_purpose_v2
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.subnet_id = subnet_id
        self.state: Optional[str] = None
        self.license_type = license_type
        self.hybrid_secondary_usage = hybrid_secondary_usage
        self.hybrid_secondary_usage_detected: Optional[Union[str, "_models.HybridSecondaryUsageDetected"]] = None
        self.v_cores = v_cores
        self.storage_size_in_gb = storage_size_in_gb
        self.storage_iops = storage_iops
        self.storage_throughput_mbps = storage_throughput_mbps
        self.memory_size_in_gb = memory_size_in_gb
        self.collation = collation
        self.dns_zone: Optional[str] = None
        self.dns_zone_partner = dns_zone_partner
        self.public_data_endpoint_enabled = public_data_endpoint_enabled
        self.source_managed_instance_id = source_managed_instance_id
        self.restore_point_in_time = restore_point_in_time
        self.proxy_override = proxy_override
        self.timezone_id = timezone_id
        self.instance_pool_id = instance_pool_id
        self.maintenance_configuration_id = maintenance_configuration_id
        self.private_endpoint_connections: Optional[List["_models.ManagedInstancePecProperty"]] = None
        self.minimal_tls_version = minimal_tls_version
        self.current_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.zone_redundant = zone_redundant
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.key_id = key_id
        self.administrators = administrators
        self.service_principal = service_principal
        self.virtual_cluster_id: Optional[str] = None
        self.external_governance_status: Optional[Union[str, "_models.ExternalGovernanceStatus"]] = None
        self.pricing_model = pricing_model
        self.create_time: Optional[datetime.datetime] = None
        self.authentication_metadata = authentication_metadata
        self.database_format = database_format
        self.requested_logical_availability_zone = requested_logical_availability_zone


class ManagedInstanceAdministrator(ProxyResource):
    """An Azure SQL managed instance administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar administrator_type: Type of the managed instance administrator. "ActiveDirectory"
    :vartype administrator_type: str or ~azure.mgmt.sql.models.ManagedInstanceAdministratorType
    :ivar login: Login name of the managed instance administrator.
    :vartype login: str
    :ivar sid: SID (object ID) of the managed instance administrator.
    :vartype sid: str
    :ivar tenant_id: Tenant ID of the managed instance administrator.
    :vartype tenant_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "administrator_type": {"key": "properties.administratorType", "type": "str"},
        "login": {"key": "properties.login", "type": "str"},
        "sid": {"key": "properties.sid", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "_models.ManagedInstanceAdministratorType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_type: Type of the managed instance administrator. "ActiveDirectory"
        :paramtype administrator_type: str or ~azure.mgmt.sql.models.ManagedInstanceAdministratorType
        :keyword login: Login name of the managed instance administrator.
        :paramtype login: str
        :keyword sid: SID (object ID) of the managed instance administrator.
        :paramtype sid: str
        :keyword tenant_id: Tenant ID of the managed instance administrator.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id


class ManagedInstanceAdministratorListResult(_serialization.Model):
    """A list of managed instance administrators.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceAdministrator]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceAdministrator]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceAdministrator"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceAdvancedThreatProtection(ProxyResource):
    """A managed instance Advanced Threat Protection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of AdvancedThreatProtectionResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "New", "Enabled", and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "New", "Enabled", and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.creation_time: Optional[datetime.datetime] = None


class ManagedInstanceAdvancedThreatProtectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the managed instance's Advanced Threat Protection settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceAdvancedThreatProtection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceAdvancedThreatProtection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceAdvancedThreatProtection"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "azure_ad_only_authentication": {"key": "properties.azureADOnlyAuthentication", "type": "bool"},
    }

    def __init__(self, *, azure_ad_only_authentication: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :paramtype azure_ad_only_authentication: bool
        """
        super().__init__(**kwargs)
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ManagedInstanceAzureADOnlyAuthListResult(_serialization.Model):
    """A list of active directory only authentications.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceAzureADOnlyAuthentication]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceAzureADOnlyAuthentication]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceAzureADOnlyAuthentication"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceDtc(ProxyResource):
    """SQL Managed Instance DTC.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar dtc_enabled: Active status of managed instance DTC.
    :vartype dtc_enabled: bool
    :ivar security_settings: Security settings of managed instance DTC.
    :vartype security_settings: ~azure.mgmt.sql.models.ManagedInstanceDtcSecuritySettings
    :ivar external_dns_suffix_search_list: External dns suffix search list of managed instance DTC.
    :vartype external_dns_suffix_search_list: list[str]
    :ivar dtc_host_name_dns_suffix: Host name dns suffix of managed instance DTC.
    :vartype dtc_host_name_dns_suffix: str
    :ivar provisioning_state: Provisioning state of managed instance DTC. Known values are:
     "Created", "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "dtc_host_name_dns_suffix": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "dtc_enabled": {"key": "properties.dtcEnabled", "type": "bool"},
        "security_settings": {"key": "properties.securitySettings", "type": "ManagedInstanceDtcSecuritySettings"},
        "external_dns_suffix_search_list": {"key": "properties.externalDnsSuffixSearchList", "type": "[str]"},
        "dtc_host_name_dns_suffix": {"key": "properties.dtcHostNameDnsSuffix", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        dtc_enabled: Optional[bool] = None,
        security_settings: Optional["_models.ManagedInstanceDtcSecuritySettings"] = None,
        external_dns_suffix_search_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dtc_enabled: Active status of managed instance DTC.
        :paramtype dtc_enabled: bool
        :keyword security_settings: Security settings of managed instance DTC.
        :paramtype security_settings: ~azure.mgmt.sql.models.ManagedInstanceDtcSecuritySettings
        :keyword external_dns_suffix_search_list: External dns suffix search list of managed instance
         DTC.
        :paramtype external_dns_suffix_search_list: list[str]
        """
        super().__init__(**kwargs)
        self.dtc_enabled = dtc_enabled
        self.security_settings = security_settings
        self.external_dns_suffix_search_list = external_dns_suffix_search_list
        self.dtc_host_name_dns_suffix: Optional[str] = None
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ManagedInstanceDtcListResult(_serialization.Model):
    """A list of managed instance's DTCs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceDtc]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceDtc]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceDtc"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceDtcSecuritySettings(_serialization.Model):
    """The Security Settings of managed instance DTC.

    :ivar transaction_manager_communication_settings: Transaction Manager communication settings of
     managed instance DTC.
    :vartype transaction_manager_communication_settings:
     ~azure.mgmt.sql.models.ManagedInstanceDtcTransactionManagerCommunicationSettings
    :ivar xa_transactions_enabled: Allow XA Transactions to managed instance DTC.
    :vartype xa_transactions_enabled: bool
    :ivar sna_lu6_point2_transactions_enabled: Allow SNA LU 6.2 Transactions to managed instance
     DTC.
    :vartype sna_lu6_point2_transactions_enabled: bool
    :ivar xa_transactions_default_timeout: Default timeout for XA Transactions (in seconds).
    :vartype xa_transactions_default_timeout: int
    :ivar xa_transactions_maximum_timeout: Maximum timeout for XA Transactions (in seconds).
    :vartype xa_transactions_maximum_timeout: int
    """

    _attribute_map = {
        "transaction_manager_communication_settings": {
            "key": "transactionManagerCommunicationSettings",
            "type": "ManagedInstanceDtcTransactionManagerCommunicationSettings",
        },
        "xa_transactions_enabled": {"key": "xaTransactionsEnabled", "type": "bool"},
        "sna_lu6_point2_transactions_enabled": {"key": "snaLu6point2TransactionsEnabled", "type": "bool"},
        "xa_transactions_default_timeout": {"key": "xaTransactionsDefaultTimeout", "type": "int"},
        "xa_transactions_maximum_timeout": {"key": "xaTransactionsMaximumTimeout", "type": "int"},
    }

    def __init__(
        self,
        *,
        transaction_manager_communication_settings: Optional[
            "_models.ManagedInstanceDtcTransactionManagerCommunicationSettings"
        ] = None,
        xa_transactions_enabled: Optional[bool] = None,
        sna_lu6_point2_transactions_enabled: Optional[bool] = None,
        xa_transactions_default_timeout: Optional[int] = None,
        xa_transactions_maximum_timeout: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transaction_manager_communication_settings: Transaction Manager communication settings
         of managed instance DTC.
        :paramtype transaction_manager_communication_settings:
         ~azure.mgmt.sql.models.ManagedInstanceDtcTransactionManagerCommunicationSettings
        :keyword xa_transactions_enabled: Allow XA Transactions to managed instance DTC.
        :paramtype xa_transactions_enabled: bool
        :keyword sna_lu6_point2_transactions_enabled: Allow SNA LU 6.2 Transactions to managed instance
         DTC.
        :paramtype sna_lu6_point2_transactions_enabled: bool
        :keyword xa_transactions_default_timeout: Default timeout for XA Transactions (in seconds).
        :paramtype xa_transactions_default_timeout: int
        :keyword xa_transactions_maximum_timeout: Maximum timeout for XA Transactions (in seconds).
        :paramtype xa_transactions_maximum_timeout: int
        """
        super().__init__(**kwargs)
        self.transaction_manager_communication_settings = transaction_manager_communication_settings
        self.xa_transactions_enabled = xa_transactions_enabled
        self.sna_lu6_point2_transactions_enabled = sna_lu6_point2_transactions_enabled
        self.xa_transactions_default_timeout = xa_transactions_default_timeout
        self.xa_transactions_maximum_timeout = xa_transactions_maximum_timeout


class ManagedInstanceDtcTransactionManagerCommunicationSettings(_serialization.Model):  # pylint: disable=name-too-long
    """The Transaction Manager Communication Settings of managed instance DTC.

    :ivar allow_inbound_enabled: Allow Inbound traffic to managed instance DTC.
    :vartype allow_inbound_enabled: bool
    :ivar allow_outbound_enabled: Allow Outbound traffic of managed instance DTC.
    :vartype allow_outbound_enabled: bool
    :ivar authentication: Authentication type of managed instance DTC.
    :vartype authentication: str
    """

    _attribute_map = {
        "allow_inbound_enabled": {"key": "allowInboundEnabled", "type": "bool"},
        "allow_outbound_enabled": {"key": "allowOutboundEnabled", "type": "bool"},
        "authentication": {"key": "authentication", "type": "str"},
    }

    def __init__(
        self,
        *,
        allow_inbound_enabled: Optional[bool] = None,
        allow_outbound_enabled: Optional[bool] = None,
        authentication: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword allow_inbound_enabled: Allow Inbound traffic to managed instance DTC.
        :paramtype allow_inbound_enabled: bool
        :keyword allow_outbound_enabled: Allow Outbound traffic of managed instance DTC.
        :paramtype allow_outbound_enabled: bool
        :keyword authentication: Authentication type of managed instance DTC.
        :paramtype authentication: str
        """
        super().__init__(**kwargs)
        self.allow_inbound_enabled = allow_inbound_enabled
        self.allow_outbound_enabled = allow_outbound_enabled
        self.authentication = authentication


class ManagedInstanceEditionCapability(_serialization.Model):
    """The managed server capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The managed server version name.
    :vartype name: str
    :ivar is_general_purpose_v2: Whether or not this is a GPv2 variant of General Purpose edition.
    :vartype is_general_purpose_v2: bool
    :ivar supported_families: The supported families.
    :vartype supported_families: list[~azure.mgmt.sql.models.ManagedInstanceFamilyCapability]
    :ivar supported_storage_capabilities: The list of supported storage capabilities for this
     edition.
    :vartype supported_storage_capabilities: list[~azure.mgmt.sql.models.StorageCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "is_general_purpose_v2": {"readonly": True},
        "supported_families": {"readonly": True},
        "supported_storage_capabilities": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_general_purpose_v2": {"key": "isGeneralPurposeV2", "type": "bool"},
        "supported_families": {"key": "supportedFamilies", "type": "[ManagedInstanceFamilyCapability]"},
        "supported_storage_capabilities": {"key": "supportedStorageCapabilities", "type": "[StorageCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.is_general_purpose_v2: Optional[bool] = None
        self.supported_families: Optional[List["_models.ManagedInstanceFamilyCapability"]] = None
        self.supported_storage_capabilities: Optional[List["_models.StorageCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ManagedInstanceEncryptionProtector(ProxyResource):
    """The managed instance encryption protector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar server_key_name: The name of the managed instance key.
    :vartype server_key_name: str
    :ivar server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
     Known values are: "ServiceManaged" and "AzureKeyVault".
    :vartype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "uri": {"readonly": True},
        "thumbprint": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "server_key_name": {"key": "properties.serverKeyName", "type": "str"},
        "server_key_type": {"key": "properties.serverKeyType", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "auto_rotation_enabled": {"key": "properties.autoRotationEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        server_key_name: Optional[str] = None,
        server_key_type: Optional[Union[str, "_models.ServerKeyType"]] = None,
        auto_rotation_enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_key_name: The name of the managed instance key.
        :paramtype server_key_name: str
        :keyword server_key_type: The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
         Known values are: "ServiceManaged" and "AzureKeyVault".
        :paramtype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
        :keyword auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
        :paramtype auto_rotation_enabled: bool
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.server_key_name = server_key_name
        self.server_key_type = server_key_type
        self.uri: Optional[str] = None
        self.thumbprint: Optional[str] = None
        self.auto_rotation_enabled = auto_rotation_enabled


class ManagedInstanceEncryptionProtectorListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of managed instance encryption protectors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceEncryptionProtector]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceEncryptionProtector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceEncryptionProtector"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceExternalAdministrator(_serialization.Model):
    """Properties of a active directory administrator.

    :ivar administrator_type: Type of the sever administrator. "ActiveDirectory"
    :vartype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :ivar principal_type: Principal Type of the sever administrator. Known values are: "User",
     "Group", and "Application".
    :vartype principal_type: str or ~azure.mgmt.sql.models.PrincipalType
    :ivar login: Login name of the server administrator.
    :vartype login: str
    :ivar sid: SID (object ID) of the server administrator.
    :vartype sid: str
    :ivar tenant_id: Tenant ID of the administrator.
    :vartype tenant_id: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _attribute_map = {
        "administrator_type": {"key": "administratorType", "type": "str"},
        "principal_type": {"key": "principalType", "type": "str"},
        "login": {"key": "login", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "azure_ad_only_authentication": {"key": "azureADOnlyAuthentication", "type": "bool"},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "_models.AdministratorType"]] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_type: Type of the sever administrator. "ActiveDirectory"
        :paramtype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
        :keyword principal_type: Principal Type of the sever administrator. Known values are: "User",
         "Group", and "Application".
        :paramtype principal_type: str or ~azure.mgmt.sql.models.PrincipalType
        :keyword login: Login name of the server administrator.
        :paramtype login: str
        :keyword sid: SID (object ID) of the server administrator.
        :paramtype sid: str
        :keyword tenant_id: Tenant ID of the administrator.
        :paramtype tenant_id: str
        :keyword azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :paramtype azure_ad_only_authentication: bool
        """
        super().__init__(**kwargs)
        self.administrator_type = administrator_type
        self.principal_type = principal_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ManagedInstanceFamilyCapability(_serialization.Model):
    """The managed server family capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Family name.
    :vartype name: str
    :ivar sku: SKU name.
    :vartype sku: str
    :ivar zone_redundant: Whether or not zone redundancy is supported for the family.
    :vartype zone_redundant: bool
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar supported_vcores_values: List of supported virtual cores values.
    :vartype supported_vcores_values: list[~azure.mgmt.sql.models.ManagedInstanceVcoresCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "sku": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "supported_license_types": {"readonly": True},
        "supported_vcores_values": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "sku": {"key": "sku", "type": "str"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "supported_license_types": {"key": "supportedLicenseTypes", "type": "[LicenseTypeCapability]"},
        "supported_vcores_values": {"key": "supportedVcoresValues", "type": "[ManagedInstanceVcoresCapability]"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.sku: Optional[str] = None
        self.zone_redundant: Optional[bool] = None
        self.supported_license_types: Optional[List["_models.LicenseTypeCapability"]] = None
        self.supported_vcores_values: Optional[List["_models.ManagedInstanceVcoresCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ManagedInstanceKey(ProxyResource):
    """A managed instance key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar server_key_type: The key type like 'ServiceManaged', 'AzureKeyVault'. Known values are:
     "ServiceManaged" and "AzureKeyVault".
    :vartype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is required.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the key.
    :vartype thumbprint: str
    :ivar creation_date: The key creation date.
    :vartype creation_date: ~datetime.datetime
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "thumbprint": {"readonly": True},
        "creation_date": {"readonly": True},
        "auto_rotation_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "server_key_type": {"key": "properties.serverKeyType", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "auto_rotation_enabled": {"key": "properties.autoRotationEnabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        server_key_type: Optional[Union[str, "_models.ServerKeyType"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_key_type: The key type like 'ServiceManaged', 'AzureKeyVault'. Known values
         are: "ServiceManaged" and "AzureKeyVault".
        :paramtype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
        :keyword uri: The URI of the key. If the ServerKeyType is AzureKeyVault, then the URI is
         required.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.server_key_type = server_key_type
        self.uri = uri
        self.thumbprint: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.auto_rotation_enabled: Optional[bool] = None


class ManagedInstanceKeyListResult(_serialization.Model):
    """A list of managed instance keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceKey]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceKey"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceListResult(_serialization.Model):
    """A list of managed instances.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstance]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstance]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstance"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceLongTermRetentionBackup(ProxyResource):
    """A long term retention backup for a managed database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The managed instance that the backup database belongs to.
    :vartype managed_instance_name: str
    :ivar managed_instance_create_time: The create time of the instance.
    :vartype managed_instance_create_time: ~datetime.datetime
    :ivar database_name: The name of the database the backup belong to.
    :vartype database_name: str
    :ivar database_deletion_time: The delete time of the database.
    :vartype database_deletion_time: ~datetime.datetime
    :ivar backup_time: The time the backup was taken.
    :vartype backup_time: ~datetime.datetime
    :ivar backup_expiration_time: The time the long term retention backup will expire.
    :vartype backup_expiration_time: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage redundancy type of the backup. Known values are:
     "Geo", "Local", "Zone", and "GeoZone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar backup_storage_access_tier: The BackupStorageAccessTier for the LTR backup. Known values
     are: "Hot" and "Archive".
    :vartype backup_storage_access_tier: str or ~azure.mgmt.sql.models.BackupStorageAccessTier
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "managed_instance_name": {"readonly": True},
        "managed_instance_create_time": {"readonly": True},
        "database_name": {"readonly": True},
        "database_deletion_time": {"readonly": True},
        "backup_time": {"readonly": True},
        "backup_expiration_time": {"readonly": True},
        "backup_storage_redundancy": {"readonly": True},
        "backup_storage_access_tier": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_instance_name": {"key": "properties.managedInstanceName", "type": "str"},
        "managed_instance_create_time": {"key": "properties.managedInstanceCreateTime", "type": "iso-8601"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "database_deletion_time": {"key": "properties.databaseDeletionTime", "type": "iso-8601"},
        "backup_time": {"key": "properties.backupTime", "type": "iso-8601"},
        "backup_expiration_time": {"key": "properties.backupExpirationTime", "type": "iso-8601"},
        "backup_storage_redundancy": {"key": "properties.backupStorageRedundancy", "type": "str"},
        "backup_storage_access_tier": {"key": "properties.backupStorageAccessTier", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.managed_instance_name: Optional[str] = None
        self.managed_instance_create_time: Optional[datetime.datetime] = None
        self.database_name: Optional[str] = None
        self.database_deletion_time: Optional[datetime.datetime] = None
        self.backup_time: Optional[datetime.datetime] = None
        self.backup_expiration_time: Optional[datetime.datetime] = None
        self.backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.backup_storage_access_tier: Optional[Union[str, "_models.BackupStorageAccessTier"]] = None


class ManagedInstanceLongTermRetentionBackupListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of long term retention backups for managed database(s).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionBackup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceLongTermRetentionBackup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceLongTermRetentionBackup"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceLongTermRetentionPolicy(ProxyResource):
    """A long term retention policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar backup_storage_access_tier: The BackupStorageAccessTier for the LTR backups. Known values
     are: "Hot" and "Archive".
    :vartype backup_storage_access_tier: str or ~azure.mgmt.sql.models.BackupStorageAccessTier
    :ivar weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
    :vartype weekly_retention: str
    :ivar monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601 format.
    :vartype monthly_retention: str
    :ivar yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
    :vartype yearly_retention: str
    :ivar week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
    :vartype week_of_year: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "backup_storage_access_tier": {"key": "properties.backupStorageAccessTier", "type": "str"},
        "weekly_retention": {"key": "properties.weeklyRetention", "type": "str"},
        "monthly_retention": {"key": "properties.monthlyRetention", "type": "str"},
        "yearly_retention": {"key": "properties.yearlyRetention", "type": "str"},
        "week_of_year": {"key": "properties.weekOfYear", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_storage_access_tier: Optional[Union[str, "_models.BackupStorageAccessTier"]] = None,
        weekly_retention: Optional[str] = None,
        monthly_retention: Optional[str] = None,
        yearly_retention: Optional[str] = None,
        week_of_year: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_storage_access_tier: The BackupStorageAccessTier for the LTR backups. Known
         values are: "Hot" and "Archive".
        :paramtype backup_storage_access_tier: str or ~azure.mgmt.sql.models.BackupStorageAccessTier
        :keyword weekly_retention: The weekly retention policy for an LTR backup in an ISO 8601 format.
        :paramtype weekly_retention: str
        :keyword monthly_retention: The monthly retention policy for an LTR backup in an ISO 8601
         format.
        :paramtype monthly_retention: str
        :keyword yearly_retention: The yearly retention policy for an LTR backup in an ISO 8601 format.
        :paramtype yearly_retention: str
        :keyword week_of_year: The week of year to take the yearly backup in an ISO 8601 format.
        :paramtype week_of_year: int
        """
        super().__init__(**kwargs)
        self.backup_storage_access_tier = backup_storage_access_tier
        self.weekly_retention = weekly_retention
        self.monthly_retention = monthly_retention
        self.yearly_retention = yearly_retention
        self.week_of_year = week_of_year


class ManagedInstanceLongTermRetentionPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of long term retention policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceLongTermRetentionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceLongTermRetentionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceLongTermRetentionPolicy"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceMaintenanceConfigurationCapability(_serialization.Model):  # pylint: disable=name-too-long
    """The maintenance configuration capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Maintenance configuration name.
    :vartype name: str
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ManagedInstanceOperation(ProxyResource):
    """A managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_instance_name: The name of the managed instance the operation is being performed
     on.
    :vartype managed_instance_name: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    :ivar operation_parameters: The operation parameters.
    :vartype operation_parameters: ~azure.mgmt.sql.models.ManagedInstanceOperationParametersPair
    :ivar operation_steps: The operation steps.
    :vartype operation_steps: ~azure.mgmt.sql.models.ManagedInstanceOperationSteps
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "managed_instance_name": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "percent_complete": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "is_user_error": {"readonly": True},
        "estimated_completion_time": {"readonly": True},
        "description": {"readonly": True},
        "is_cancellable": {"readonly": True},
        "operation_parameters": {"readonly": True},
        "operation_steps": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_instance_name": {"key": "properties.managedInstanceName", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "is_user_error": {"key": "properties.isUserError", "type": "bool"},
        "estimated_completion_time": {"key": "properties.estimatedCompletionTime", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
        "operation_parameters": {
            "key": "properties.operationParameters",
            "type": "ManagedInstanceOperationParametersPair",
        },
        "operation_steps": {"key": "properties.operationSteps", "type": "ManagedInstanceOperationSteps"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.managed_instance_name: Optional[str] = None
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.percent_complete: Optional[int] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.ManagementOperationState"]] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.is_user_error: Optional[bool] = None
        self.estimated_completion_time: Optional[datetime.datetime] = None
        self.description: Optional[str] = None
        self.is_cancellable: Optional[bool] = None
        self.operation_parameters: Optional["_models.ManagedInstanceOperationParametersPair"] = None
        self.operation_steps: Optional["_models.ManagedInstanceOperationSteps"] = None


class ManagedInstanceOperationListResult(_serialization.Model):
    """The response to a list managed instance operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceOperation"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceOperationParametersPair(_serialization.Model):
    """The parameters of a managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar current_parameters: The current parameters.
    :vartype current_parameters: ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    :ivar requested_parameters: The requested parameters.
    :vartype requested_parameters: ~azure.mgmt.sql.models.UpsertManagedServerOperationParameters
    """

    _validation = {
        "current_parameters": {"readonly": True},
        "requested_parameters": {"readonly": True},
    }

    _attribute_map = {
        "current_parameters": {"key": "currentParameters", "type": "UpsertManagedServerOperationParameters"},
        "requested_parameters": {"key": "requestedParameters", "type": "UpsertManagedServerOperationParameters"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.current_parameters: Optional["_models.UpsertManagedServerOperationParameters"] = None
        self.requested_parameters: Optional["_models.UpsertManagedServerOperationParameters"] = None


class ManagedInstanceOperationSteps(_serialization.Model):
    """The steps of a managed instance operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_steps: The total number of operation steps.
    :vartype total_steps: str
    :ivar current_step: The number of current operation steps.
    :vartype current_step: int
    :ivar steps_list: The operation steps list.
    :vartype steps_list:
     list[~azure.mgmt.sql.models.UpsertManagedServerOperationStepWithEstimatesAndDuration]
    """

    _validation = {
        "total_steps": {"readonly": True},
        "current_step": {"readonly": True},
        "steps_list": {"readonly": True},
    }

    _attribute_map = {
        "total_steps": {"key": "totalSteps", "type": "str"},
        "current_step": {"key": "currentStep", "type": "int"},
        "steps_list": {"key": "stepsList", "type": "[UpsertManagedServerOperationStepWithEstimatesAndDuration]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.total_steps: Optional[str] = None
        self.current_step: Optional[int] = None
        self.steps_list: Optional[List["_models.UpsertManagedServerOperationStepWithEstimatesAndDuration"]] = None


class ManagedInstancePairInfo(_serialization.Model):
    """Pairs of Managed Instances in the failover group.

    :ivar primary_managed_instance_id: Id of Primary Managed Instance in pair.
    :vartype primary_managed_instance_id: str
    :ivar partner_managed_instance_id: Id of Partner Managed Instance in pair.
    :vartype partner_managed_instance_id: str
    """

    _attribute_map = {
        "primary_managed_instance_id": {"key": "primaryManagedInstanceId", "type": "str"},
        "partner_managed_instance_id": {"key": "partnerManagedInstanceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        primary_managed_instance_id: Optional[str] = None,
        partner_managed_instance_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_managed_instance_id: Id of Primary Managed Instance in pair.
        :paramtype primary_managed_instance_id: str
        :keyword partner_managed_instance_id: Id of Partner Managed Instance in pair.
        :paramtype partner_managed_instance_id: str
        """
        super().__init__(**kwargs)
        self.primary_managed_instance_id = primary_managed_instance_id
        self.partner_managed_instance_id = partner_managed_instance_id


class ManagedInstancePecProperty(_serialization.Model):
    """A private endpoint connection under a managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "properties": {"key": "properties", "type": "ManagedInstancePrivateEndpointConnectionProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.properties: Optional["_models.ManagedInstancePrivateEndpointConnectionProperties"] = None


class ManagedInstancePrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the Private Endpoint Connection.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "ManagedInstancePrivateEndpointProperty"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "ManagedInstancePrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.ManagedInstancePrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional[
            "_models.ManagedInstancePrivateLinkServiceConnectionStateProperty"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection State of the Private Endpoint
         Connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[str] = None


class ManagedInstancePrivateEndpointConnectionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstancePrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstancePrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstancePrivateEndpointConnection"]] = None
        self.next_link: Optional[str] = None


class ManagedInstancePrivateEndpointConnectionProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
    :ivar private_link_service_connection_state: Connection State of the Private Endpoint
     Connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the Private Endpoint Connection.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "ManagedInstancePrivateEndpointProperty"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "ManagedInstancePrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.ManagedInstancePrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional[
            "_models.ManagedInstancePrivateLinkServiceConnectionStateProperty"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.sql.models.ManagedInstancePrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection State of the Private Endpoint
         Connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.sql.models.ManagedInstancePrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[str] = None


class ManagedInstancePrivateEndpointProperty(_serialization.Model):
    """ManagedInstancePrivateEndpointProperty.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ManagedInstancePrivateLink(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.sql.models.ManagedInstancePrivateLinkProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ManagedInstancePrivateLinkProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.ManagedInstancePrivateLinkProperties"] = None


class ManagedInstancePrivateLinkListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstancePrivateLink]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstancePrivateLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstancePrivateLink"]] = None
        self.next_link: Optional[str] = None


class ManagedInstancePrivateLinkProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[List[str]] = None
        self.required_zone_names: Optional[List[str]] = None


class ManagedInstancePrivateLinkServiceConnectionStateProperty(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedInstancePrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: The private link service connection status. Required.
    :vartype status: str
    :ivar description: The private link service connection description. Required.
    :vartype description: str
    :ivar actions_required: The private link service connection description.
    :vartype actions_required: str
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(self, *, status: str, description: str, **kwargs: Any) -> None:
        """
        :keyword status: The private link service connection status. Required.
        :paramtype status: str
        :keyword description: The private link service connection description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required: Optional[str] = None


class ManagedInstanceQuery(ProxyResource):
    """Database query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar query_text: Query text.
    :vartype query_text: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "query_text": {"key": "properties.queryText", "type": "str"},
    }

    def __init__(self, *, query_text: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword query_text: Query text.
        :paramtype query_text: str
        """
        super().__init__(**kwargs)
        self.query_text = query_text


class ManagedInstanceQueryStatistics(_serialization.Model):
    """Execution statistics for one particular query.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.QueryStatistics]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[QueryStatistics]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.QueryStatistics"]] = None
        self.next_link: Optional[str] = None


class ManagedInstanceUpdate(_serialization.Model):
    """An update request for an Azure SQL Database managed instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: Managed instance sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar identity: Managed instance identity.
    :vartype identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: Provisioning state of managed instance. Known values are: "Created",
     "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    :ivar managed_instance_create_mode: Specifies the mode of database creation.

     Default: Regular instance creation.

     Restore: Creates an instance by restoring a set of backups to specific point in time.
     RestorePointInTime and SourceManagedInstanceId must be specified. Known values are: "Default"
     and "PointInTimeRestore".
    :vartype managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
    :ivar fully_qualified_domain_name: The fully qualified domain name of the managed instance.
    :vartype fully_qualified_domain_name: str
    :ivar is_general_purpose_v2: Whether or not this is a GPv2 variant of General Purpose edition.
    :vartype is_general_purpose_v2: bool
    :ivar administrator_login: Administrator username for the managed instance. Can only be
     specified when the managed instance is being created (and is required for creation).
    :vartype administrator_login: str
    :ivar administrator_login_password: The administrator login password (required for managed
     instance creation).
    :vartype administrator_login_password: str
    :ivar subnet_id: Subnet resource ID for the managed instance.
    :vartype subnet_id: str
    :ivar state: The state of the managed instance.
    :vartype state: str
    :ivar license_type: The license type. Possible values are 'LicenseIncluded' (regular price
     inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
     licenses). Known values are: "LicenseIncluded" and "BasePrice".
    :vartype license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
    :ivar hybrid_secondary_usage: Hybrid secondary usage. Possible values are 'Active' (default
     value) and 'Passive' (customer uses the secondary as Passive DR). Known values are: "Active"
     and "Passive".
    :vartype hybrid_secondary_usage: str or ~azure.mgmt.sql.models.HybridSecondaryUsage
    :ivar hybrid_secondary_usage_detected: Hybrid secondary usage detected. Possible values are
     'Active' (customer does not meet the requirements to use the secondary as Passive DR) and
     'Passive' (customer meets the requirements to use the secondary as Passive DR). Known values
     are: "Active" and "Passive".
    :vartype hybrid_secondary_usage_detected: str or
     ~azure.mgmt.sql.models.HybridSecondaryUsageDetected
    :ivar v_cores: The number of vCores. Allowed values: 4, 6, 8, 10, 12, 16, 20, 24, 32, 40, 48,
     56, 64, 80, 96, 128. Supported vCores depends on the selected hardware family and service tier.
    :vartype v_cores: int
    :ivar storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 32768.
     Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and
     number of vCores.
    :vartype storage_size_in_gb: int
    :ivar storage_iops: Storage IOps. Minimum value: 300. Maximum value: 80000. Increments of 1
     IOps allowed only. Maximum value depends on the selected hardware family and number of vCores.
    :vartype storage_iops: int
    :ivar storage_throughput_mbps: Storage throughput MBps parameter is not supported in the
     instance create/update operation.
    :vartype storage_throughput_mbps: int
    :ivar memory_size_in_gb: Memory size in GB. Minimum value: 28. Maximum value: 870. Minimum and
     maximum value depend on the number of vCores and service tier. Read more about resource limits:
     https://aka.ms/mi-resource-limits-api.
    :vartype memory_size_in_gb: int
    :ivar collation: Collation of the managed instance.
    :vartype collation: str
    :ivar dns_zone: The Dns Zone that the managed instance is in.
    :vartype dns_zone: str
    :ivar dns_zone_partner: The resource id of another managed instance whose DNS zone this managed
     instance will share after creation.
    :vartype dns_zone_partner: str
    :ivar public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
    :vartype public_data_endpoint_enabled: bool
    :ivar source_managed_instance_id: The resource identifier of the source managed instance
     associated with create operation of this instance.
    :vartype source_managed_instance_id: str
    :ivar restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
     database that will be restored to create the new database.
    :vartype restore_point_in_time: ~datetime.datetime
    :ivar proxy_override: Connection type used for connecting to the instance. Known values are:
     "Proxy", "Redirect", and "Default".
    :vartype proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
    :ivar timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
     Windows keeps details on supported timezones, including the id, in registry under
     KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones.
     You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
     sys.time_zone_info.
     List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
     PowerShell.
     An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
    :vartype timezone_id: str
    :ivar instance_pool_id: The Id of the instance pool this managed server belongs to.
    :vartype instance_pool_id: str
    :ivar maintenance_configuration_id: Specifies maintenance configuration id to apply to this
     managed instance.
    :vartype maintenance_configuration_id: str
    :ivar private_endpoint_connections: List of private endpoint connections on a managed instance.
    :vartype private_endpoint_connections: list[~azure.mgmt.sql.models.ManagedInstancePecProperty]
    :ivar minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
    :vartype minimal_tls_version: str
    :ivar current_backup_storage_redundancy: The storage account type used to store backups for
     this instance. The options are Local (LocallyRedundantStorage), Zone (ZoneRedundantStorage),
     Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known values are: "Geo",
     "Local", "Zone", and "GeoZone".
    :vartype current_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar requested_backup_storage_redundancy: The storage account type to be used to store backups
     for this instance. The options are Local (LocallyRedundantStorage), Zone
     (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known
     values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype requested_backup_storage_redundancy: str or
     ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar zone_redundant: Whether or not the zone-redundancy is enabled.
    :vartype zone_redundant: bool
    :ivar primary_user_assigned_identity_id: The resource id of a user assigned identity to be used
     by default.
    :vartype primary_user_assigned_identity_id: str
    :ivar key_id: A CMK URI of the key to use for encryption.
    :vartype key_id: str
    :ivar administrators: The Azure Active Directory administrator can be utilized during instance
     creation and for instance updates, except for the azureADOnlyAuthentication property. To update
     the azureADOnlyAuthentication property, individual API must be used.
    :vartype administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
    :ivar service_principal: The managed instance's service principal.
    :vartype service_principal: ~azure.mgmt.sql.models.ServicePrincipal
    :ivar virtual_cluster_id: Virtual cluster resource id for the Managed Instance.
    :vartype virtual_cluster_id: str
    :ivar external_governance_status: Status of external governance. Known values are: "Enabled"
     and "Disabled".
    :vartype external_governance_status: str or ~azure.mgmt.sql.models.ExternalGovernanceStatus
    :ivar pricing_model: Pricing model of Managed Instance. Known values are: "Regular" and
     "Freemium".
    :vartype pricing_model: str or ~azure.mgmt.sql.models.PricingModel
    :ivar create_time: Specifies the point in time (ISO8601 format) of the Managed Instance
     creation.
    :vartype create_time: ~datetime.datetime
    :ivar authentication_metadata: The managed instance's authentication metadata lookup mode.
     Known values are: "AzureAD", "Paired", and "Windows".
    :vartype authentication_metadata: str or ~azure.mgmt.sql.models.AuthMetadataLookupModes
    :ivar database_format: Specifies the internal format of instance databases specific to the SQL
     engine version. Known values are: "AlwaysUpToDate", "SQLServer2022", and "SQLServer2025".
    :vartype database_format: str or ~azure.mgmt.sql.models.ManagedInstanceDatabaseFormat
    :ivar requested_logical_availability_zone: Specifies the logical availability zone Managed
     Instance is pinned to. Known values are: "NoPreference", "1", "2", and "3".
    :vartype requested_logical_availability_zone: str or
     ~azure.mgmt.sql.models.AvailabilityZoneType
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "state": {"readonly": True},
        "hybrid_secondary_usage_detected": {"readonly": True},
        "dns_zone": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "current_backup_storage_redundancy": {"readonly": True},
        "virtual_cluster_id": {"readonly": True},
        "external_governance_status": {"readonly": True},
        "create_time": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "managed_instance_create_mode": {"key": "properties.managedInstanceCreateMode", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "is_general_purpose_v2": {"key": "properties.isGeneralPurposeV2", "type": "bool"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "subnet_id": {"key": "properties.subnetId", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "license_type": {"key": "properties.licenseType", "type": "str"},
        "hybrid_secondary_usage": {"key": "properties.hybridSecondaryUsage", "type": "str"},
        "hybrid_secondary_usage_detected": {"key": "properties.hybridSecondaryUsageDetected", "type": "str"},
        "v_cores": {"key": "properties.vCores", "type": "int"},
        "storage_size_in_gb": {"key": "properties.storageSizeInGB", "type": "int"},
        "storage_iops": {"key": "properties.storageIOps", "type": "int"},
        "storage_throughput_mbps": {"key": "properties.storageThroughputMBps", "type": "int"},
        "memory_size_in_gb": {"key": "properties.memorySizeInGB", "type": "int"},
        "collation": {"key": "properties.collation", "type": "str"},
        "dns_zone": {"key": "properties.dnsZone", "type": "str"},
        "dns_zone_partner": {"key": "properties.dnsZonePartner", "type": "str"},
        "public_data_endpoint_enabled": {"key": "properties.publicDataEndpointEnabled", "type": "bool"},
        "source_managed_instance_id": {"key": "properties.sourceManagedInstanceId", "type": "str"},
        "restore_point_in_time": {"key": "properties.restorePointInTime", "type": "iso-8601"},
        "proxy_override": {"key": "properties.proxyOverride", "type": "str"},
        "timezone_id": {"key": "properties.timezoneId", "type": "str"},
        "instance_pool_id": {"key": "properties.instancePoolId", "type": "str"},
        "maintenance_configuration_id": {"key": "properties.maintenanceConfigurationId", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ManagedInstancePecProperty]",
        },
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "current_backup_storage_redundancy": {"key": "properties.currentBackupStorageRedundancy", "type": "str"},
        "requested_backup_storage_redundancy": {"key": "properties.requestedBackupStorageRedundancy", "type": "str"},
        "zone_redundant": {"key": "properties.zoneRedundant", "type": "bool"},
        "primary_user_assigned_identity_id": {"key": "properties.primaryUserAssignedIdentityId", "type": "str"},
        "key_id": {"key": "properties.keyId", "type": "str"},
        "administrators": {"key": "properties.administrators", "type": "ManagedInstanceExternalAdministrator"},
        "service_principal": {"key": "properties.servicePrincipal", "type": "ServicePrincipal"},
        "virtual_cluster_id": {"key": "properties.virtualClusterId", "type": "str"},
        "external_governance_status": {"key": "properties.externalGovernanceStatus", "type": "str"},
        "pricing_model": {"key": "properties.pricingModel", "type": "str"},
        "create_time": {"key": "properties.createTime", "type": "iso-8601"},
        "authentication_metadata": {"key": "properties.authenticationMetadata", "type": "str"},
        "database_format": {"key": "properties.databaseFormat", "type": "str"},
        "requested_logical_availability_zone": {"key": "properties.requestedLogicalAvailabilityZone", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        managed_instance_create_mode: Optional[Union[str, "_models.ManagedServerCreateMode"]] = None,
        is_general_purpose_v2: Optional[bool] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        subnet_id: Optional[str] = None,
        license_type: Optional[Union[str, "_models.ManagedInstanceLicenseType"]] = None,
        hybrid_secondary_usage: Optional[Union[str, "_models.HybridSecondaryUsage"]] = None,
        v_cores: Optional[int] = None,
        storage_size_in_gb: Optional[int] = None,
        storage_iops: Optional[int] = None,
        storage_throughput_mbps: Optional[int] = None,
        memory_size_in_gb: Optional[int] = None,
        collation: Optional[str] = None,
        dns_zone_partner: Optional[str] = None,
        public_data_endpoint_enabled: Optional[bool] = None,
        source_managed_instance_id: Optional[str] = None,
        restore_point_in_time: Optional[datetime.datetime] = None,
        proxy_override: Optional[Union[str, "_models.ManagedInstanceProxyOverride"]] = None,
        timezone_id: Optional[str] = None,
        instance_pool_id: Optional[str] = None,
        maintenance_configuration_id: Optional[str] = None,
        minimal_tls_version: Optional[str] = None,
        requested_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None,
        zone_redundant: Optional[bool] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["_models.ManagedInstanceExternalAdministrator"] = None,
        service_principal: Optional["_models.ServicePrincipal"] = None,
        pricing_model: Optional[Union[str, "_models.PricingModel"]] = None,
        authentication_metadata: Optional[Union[str, "_models.AuthMetadataLookupModes"]] = None,
        database_format: Optional[Union[str, "_models.ManagedInstanceDatabaseFormat"]] = None,
        requested_logical_availability_zone: Optional[Union[str, "_models.AvailabilityZoneType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: Managed instance sku.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword identity: Managed instance identity.
        :paramtype identity: ~azure.mgmt.sql.models.ResourceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword managed_instance_create_mode: Specifies the mode of database creation.

         Default: Regular instance creation.

         Restore: Creates an instance by restoring a set of backups to specific point in time.
         RestorePointInTime and SourceManagedInstanceId must be specified. Known values are: "Default"
         and "PointInTimeRestore".
        :paramtype managed_instance_create_mode: str or ~azure.mgmt.sql.models.ManagedServerCreateMode
        :keyword is_general_purpose_v2: Whether or not this is a GPv2 variant of General Purpose
         edition.
        :paramtype is_general_purpose_v2: bool
        :keyword administrator_login: Administrator username for the managed instance. Can only be
         specified when the managed instance is being created (and is required for creation).
        :paramtype administrator_login: str
        :keyword administrator_login_password: The administrator login password (required for managed
         instance creation).
        :paramtype administrator_login_password: str
        :keyword subnet_id: Subnet resource ID for the managed instance.
        :paramtype subnet_id: str
        :keyword license_type: The license type. Possible values are 'LicenseIncluded' (regular price
         inclusive of a new SQL license) and 'BasePrice' (discounted AHB price for bringing your own SQL
         licenses). Known values are: "LicenseIncluded" and "BasePrice".
        :paramtype license_type: str or ~azure.mgmt.sql.models.ManagedInstanceLicenseType
        :keyword hybrid_secondary_usage: Hybrid secondary usage. Possible values are 'Active' (default
         value) and 'Passive' (customer uses the secondary as Passive DR). Known values are: "Active"
         and "Passive".
        :paramtype hybrid_secondary_usage: str or ~azure.mgmt.sql.models.HybridSecondaryUsage
        :keyword v_cores: The number of vCores. Allowed values: 4, 6, 8, 10, 12, 16, 20, 24, 32, 40,
         48, 56, 64, 80, 96, 128. Supported vCores depends on the selected hardware family and service
         tier.
        :paramtype v_cores: int
        :keyword storage_size_in_gb: Storage size in GB. Minimum value: 32. Maximum value: 32768.
         Increments of 32 GB allowed only. Maximum value depends on the selected hardware family and
         number of vCores.
        :paramtype storage_size_in_gb: int
        :keyword storage_iops: Storage IOps. Minimum value: 300. Maximum value: 80000. Increments of 1
         IOps allowed only. Maximum value depends on the selected hardware family and number of vCores.
        :paramtype storage_iops: int
        :keyword storage_throughput_mbps: Storage throughput MBps parameter is not supported in the
         instance create/update operation.
        :paramtype storage_throughput_mbps: int
        :keyword memory_size_in_gb: Memory size in GB. Minimum value: 28. Maximum value: 870. Minimum
         and maximum value depend on the number of vCores and service tier. Read more about resource
         limits: https://aka.ms/mi-resource-limits-api.
        :paramtype memory_size_in_gb: int
        :keyword collation: Collation of the managed instance.
        :paramtype collation: str
        :keyword dns_zone_partner: The resource id of another managed instance whose DNS zone this
         managed instance will share after creation.
        :paramtype dns_zone_partner: str
        :keyword public_data_endpoint_enabled: Whether or not the public data endpoint is enabled.
        :paramtype public_data_endpoint_enabled: bool
        :keyword source_managed_instance_id: The resource identifier of the source managed instance
         associated with create operation of this instance.
        :paramtype source_managed_instance_id: str
        :keyword restore_point_in_time: Specifies the point in time (ISO8601 format) of the source
         database that will be restored to create the new database.
        :paramtype restore_point_in_time: ~datetime.datetime
        :keyword proxy_override: Connection type used for connecting to the instance. Known values are:
         "Proxy", "Redirect", and "Default".
        :paramtype proxy_override: str or ~azure.mgmt.sql.models.ManagedInstanceProxyOverride
        :keyword timezone_id: Id of the timezone. Allowed values are timezones supported by Windows.
         Windows keeps details on supported timezones, including the id, in registry under
         KEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Time Zones.
         You can get those registry values via SQL Server by querying SELECT name AS timezone_id FROM
         sys.time_zone_info.
         List of Ids can also be obtained by executing [System.TimeZoneInfo]::GetSystemTimeZones() in
         PowerShell.
         An example of valid timezone id is "Pacific Standard Time" or "W. Europe Standard Time".
        :paramtype timezone_id: str
        :keyword instance_pool_id: The Id of the instance pool this managed server belongs to.
        :paramtype instance_pool_id: str
        :keyword maintenance_configuration_id: Specifies maintenance configuration id to apply to this
         managed instance.
        :paramtype maintenance_configuration_id: str
        :keyword minimal_tls_version: Minimal TLS version. Allowed values: 'None', '1.0', '1.1', '1.2'.
        :paramtype minimal_tls_version: str
        :keyword requested_backup_storage_redundancy: The storage account type to be used to store
         backups for this instance. The options are Local (LocallyRedundantStorage), Zone
         (ZoneRedundantStorage), Geo (GeoRedundantStorage) and GeoZone(GeoZoneRedundantStorage). Known
         values are: "Geo", "Local", "Zone", and "GeoZone".
        :paramtype requested_backup_storage_redundancy: str or
         ~azure.mgmt.sql.models.BackupStorageRedundancy
        :keyword zone_redundant: Whether or not the zone-redundancy is enabled.
        :paramtype zone_redundant: bool
        :keyword primary_user_assigned_identity_id: The resource id of a user assigned identity to be
         used by default.
        :paramtype primary_user_assigned_identity_id: str
        :keyword key_id: A CMK URI of the key to use for encryption.
        :paramtype key_id: str
        :keyword administrators: The Azure Active Directory administrator can be utilized during
         instance creation and for instance updates, except for the azureADOnlyAuthentication property.
         To update the azureADOnlyAuthentication property, individual API must be used.
        :paramtype administrators: ~azure.mgmt.sql.models.ManagedInstanceExternalAdministrator
        :keyword service_principal: The managed instance's service principal.
        :paramtype service_principal: ~azure.mgmt.sql.models.ServicePrincipal
        :keyword pricing_model: Pricing model of Managed Instance. Known values are: "Regular" and
         "Freemium".
        :paramtype pricing_model: str or ~azure.mgmt.sql.models.PricingModel
        :keyword authentication_metadata: The managed instance's authentication metadata lookup mode.
         Known values are: "AzureAD", "Paired", and "Windows".
        :paramtype authentication_metadata: str or ~azure.mgmt.sql.models.AuthMetadataLookupModes
        :keyword database_format: Specifies the internal format of instance databases specific to the
         SQL engine version. Known values are: "AlwaysUpToDate", "SQLServer2022", and "SQLServer2025".
        :paramtype database_format: str or ~azure.mgmt.sql.models.ManagedInstanceDatabaseFormat
        :keyword requested_logical_availability_zone: Specifies the logical availability zone Managed
         Instance is pinned to. Known values are: "NoPreference", "1", "2", and "3".
        :paramtype requested_logical_availability_zone: str or
         ~azure.mgmt.sql.models.AvailabilityZoneType
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.identity = identity
        self.tags = tags
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None
        self.managed_instance_create_mode = managed_instance_create_mode
        self.fully_qualified_domain_name: Optional[str] = None
        self.is_general_purpose_v2 = is_general_purpose_v2
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.subnet_id = subnet_id
        self.state: Optional[str] = None
        self.license_type = license_type
        self.hybrid_secondary_usage = hybrid_secondary_usage
        self.hybrid_secondary_usage_detected: Optional[Union[str, "_models.HybridSecondaryUsageDetected"]] = None
        self.v_cores = v_cores
        self.storage_size_in_gb = storage_size_in_gb
        self.storage_iops = storage_iops
        self.storage_throughput_mbps = storage_throughput_mbps
        self.memory_size_in_gb = memory_size_in_gb
        self.collation = collation
        self.dns_zone: Optional[str] = None
        self.dns_zone_partner = dns_zone_partner
        self.public_data_endpoint_enabled = public_data_endpoint_enabled
        self.source_managed_instance_id = source_managed_instance_id
        self.restore_point_in_time = restore_point_in_time
        self.proxy_override = proxy_override
        self.timezone_id = timezone_id
        self.instance_pool_id = instance_pool_id
        self.maintenance_configuration_id = maintenance_configuration_id
        self.private_endpoint_connections: Optional[List["_models.ManagedInstancePecProperty"]] = None
        self.minimal_tls_version = minimal_tls_version
        self.current_backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.requested_backup_storage_redundancy = requested_backup_storage_redundancy
        self.zone_redundant = zone_redundant
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.key_id = key_id
        self.administrators = administrators
        self.service_principal = service_principal
        self.virtual_cluster_id: Optional[str] = None
        self.external_governance_status: Optional[Union[str, "_models.ExternalGovernanceStatus"]] = None
        self.pricing_model = pricing_model
        self.create_time: Optional[datetime.datetime] = None
        self.authentication_metadata = authentication_metadata
        self.database_format = database_format
        self.requested_logical_availability_zone = requested_logical_availability_zone


class ManagedInstanceValidateAzureKeyVaultEncryptionKeyRequest(_serialization.Model):  # pylint: disable=name-too-long
    """Validate azure key vault encryption key.

    All required parameters must be populated in order to send to server.

    :ivar tde_key_uri: The URI of the key. Required.
    :vartype tde_key_uri: str
    """

    _validation = {
        "tde_key_uri": {"required": True},
    }

    _attribute_map = {
        "tde_key_uri": {"key": "tdeKeyUri", "type": "str"},
    }

    def __init__(self, *, tde_key_uri: str, **kwargs: Any) -> None:
        """
        :keyword tde_key_uri: The URI of the key. Required.
        :paramtype tde_key_uri: str
        """
        super().__init__(**kwargs)
        self.tde_key_uri = tde_key_uri


class ManagedInstanceVcoresCapability(_serialization.Model):
    """The managed instance virtual cores capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The virtual cores identifier.
    :vartype name: str
    :ivar value: The virtual cores value.
    :vartype value: int
    :ivar supported_memory_sizes_in_gb: Supported memory sizes in GB.
    :vartype supported_memory_sizes_in_gb: ~azure.mgmt.sql.models.MaxLimitRangeCapability
    :ivar included_max_size: Included size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar supported_storage_sizes: Storage size ranges.
    :vartype supported_storage_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar included_storage_i_ops: Included storage IOps.
    :vartype included_storage_i_ops: int
    :ivar supported_storage_i_ops: Storage IOps ranges.
    :vartype supported_storage_i_ops: ~azure.mgmt.sql.models.MaxLimitRangeCapability
    :ivar iops_min_value_override_factor_per_selected_storage_gb: Min IOps override factor per
     selected storage GB.
    :vartype iops_min_value_override_factor_per_selected_storage_gb: float
    :ivar iops_included_value_override_factor_per_selected_storage_gb: Included IOps override
     factor per selected storage GB.
    :vartype iops_included_value_override_factor_per_selected_storage_gb: float
    :ivar included_storage_throughput_m_bps: Included storage throughput MBps.
    :vartype included_storage_throughput_m_bps: int
    :ivar supported_storage_throughput_m_bps: Storage throughput MBps ranges.
    :vartype supported_storage_throughput_m_bps: ~azure.mgmt.sql.models.MaxLimitRangeCapability
    :ivar throughput_m_bps_min_value_override_factor_per_selected_storage_gb: Min throughput MBps
     override factor per selected storage GB.
    :vartype throughput_m_bps_min_value_override_factor_per_selected_storage_gb: float
    :ivar throughput_m_bps_included_value_override_factor_per_selected_storage_gb: Included
     throughput MBps override factor per selected storage GB.
    :vartype throughput_m_bps_included_value_override_factor_per_selected_storage_gb: float
    :ivar instance_pool_supported: True if this service objective is supported for managed
     instances in an instance pool.
    :vartype instance_pool_supported: bool
    :ivar standalone_supported: True if this service objective is supported for standalone managed
     instances.
    :vartype standalone_supported: bool
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.ManagedInstanceMaintenanceConfigurationCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
        "supported_memory_sizes_in_gb": {"readonly": True},
        "included_max_size": {"readonly": True},
        "supported_storage_sizes": {"readonly": True},
        "included_storage_i_ops": {"readonly": True},
        "supported_storage_i_ops": {"readonly": True},
        "iops_min_value_override_factor_per_selected_storage_gb": {"readonly": True},
        "iops_included_value_override_factor_per_selected_storage_gb": {"readonly": True},
        "included_storage_throughput_m_bps": {"readonly": True},
        "supported_storage_throughput_m_bps": {"readonly": True},
        "throughput_m_bps_min_value_override_factor_per_selected_storage_gb": {"readonly": True},
        "throughput_m_bps_included_value_override_factor_per_selected_storage_gb": {"readonly": True},
        "instance_pool_supported": {"readonly": True},
        "standalone_supported": {"readonly": True},
        "supported_maintenance_configurations": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "int"},
        "supported_memory_sizes_in_gb": {"key": "supportedMemorySizesInGB", "type": "MaxLimitRangeCapability"},
        "included_max_size": {"key": "includedMaxSize", "type": "MaxSizeCapability"},
        "supported_storage_sizes": {"key": "supportedStorageSizes", "type": "[MaxSizeRangeCapability]"},
        "included_storage_i_ops": {"key": "includedStorageIOps", "type": "int"},
        "supported_storage_i_ops": {"key": "supportedStorageIOps", "type": "MaxLimitRangeCapability"},
        "iops_min_value_override_factor_per_selected_storage_gb": {
            "key": "iopsMinValueOverrideFactorPerSelectedStorageGB",
            "type": "float",
        },
        "iops_included_value_override_factor_per_selected_storage_gb": {
            "key": "iopsIncludedValueOverrideFactorPerSelectedStorageGB",
            "type": "float",
        },
        "included_storage_throughput_m_bps": {"key": "includedStorageThroughputMBps", "type": "int"},
        "supported_storage_throughput_m_bps": {
            "key": "supportedStorageThroughputMBps",
            "type": "MaxLimitRangeCapability",
        },
        "throughput_m_bps_min_value_override_factor_per_selected_storage_gb": {
            "key": "throughputMBpsMinValueOverrideFactorPerSelectedStorageGB",
            "type": "float",
        },
        "throughput_m_bps_included_value_override_factor_per_selected_storage_gb": {
            "key": "throughputMBpsIncludedValueOverrideFactorPerSelectedStorageGB",
            "type": "float",
        },
        "instance_pool_supported": {"key": "instancePoolSupported", "type": "bool"},
        "standalone_supported": {"key": "standaloneSupported", "type": "bool"},
        "supported_maintenance_configurations": {
            "key": "supportedMaintenanceConfigurations",
            "type": "[ManagedInstanceMaintenanceConfigurationCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[int] = None
        self.supported_memory_sizes_in_gb: Optional["_models.MaxLimitRangeCapability"] = None
        self.included_max_size: Optional["_models.MaxSizeCapability"] = None
        self.supported_storage_sizes: Optional[List["_models.MaxSizeRangeCapability"]] = None
        self.included_storage_i_ops: Optional[int] = None
        self.supported_storage_i_ops: Optional["_models.MaxLimitRangeCapability"] = None
        self.iops_min_value_override_factor_per_selected_storage_gb: Optional[float] = None
        self.iops_included_value_override_factor_per_selected_storage_gb: Optional[float] = None
        self.included_storage_throughput_m_bps: Optional[int] = None
        self.supported_storage_throughput_m_bps: Optional["_models.MaxLimitRangeCapability"] = None
        self.throughput_m_bps_min_value_override_factor_per_selected_storage_gb: Optional[float] = None
        self.throughput_m_bps_included_value_override_factor_per_selected_storage_gb: Optional[float] = None
        self.instance_pool_supported: Optional[bool] = None
        self.standalone_supported: Optional[bool] = None
        self.supported_maintenance_configurations: Optional[
            List["_models.ManagedInstanceMaintenanceConfigurationCapability"]
        ] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ManagedInstanceVersionCapability(_serialization.Model):
    """The managed instance capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported managed instance editions.
    :vartype supported_editions: list[~azure.mgmt.sql.models.ManagedInstanceEditionCapability]
    :ivar supported_instance_pool_editions: The list of supported instance pool editions.
    :vartype supported_instance_pool_editions:
     list[~azure.mgmt.sql.models.InstancePoolEditionCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_editions": {"readonly": True},
        "supported_instance_pool_editions": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_editions": {"key": "supportedEditions", "type": "[ManagedInstanceEditionCapability]"},
        "supported_instance_pool_editions": {
            "key": "supportedInstancePoolEditions",
            "type": "[InstancePoolEditionCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_editions: Optional[List["_models.ManagedInstanceEditionCapability"]] = None
        self.supported_instance_pool_editions: Optional[List["_models.InstancePoolEditionCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ManagedInstanceVulnerabilityAssessment(ProxyResource):
    """A managed instance vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :vartype storage_container_path: str
    :ivar storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not
     behind a Vnet or a firewall.
    :vartype storage_container_sas_key: str
    :ivar storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
     or a firewall.
    :vartype storage_account_access_key: str
    :ivar recurring_scans: The recurring scans settings.
    :vartype recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_container_path": {"key": "properties.storageContainerPath", "type": "str"},
        "storage_container_sas_key": {"key": "properties.storageContainerSasKey", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "recurring_scans": {
            "key": "properties.recurringScans",
            "type": "VulnerabilityAssessmentRecurringScansProperties",
        },
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["_models.VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_container_path: A blob storage container path to hold the scan results (e.g.
         https://myStorage.blob.core.windows.net/VaScans/).
        :paramtype storage_container_path: str
        :keyword storage_container_sas_key: A shared access signature (SAS Key) that has write access
         to the blob container specified in 'storageContainerPath' parameter. If
         'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if
         the storage account is not behind a Vnet or a firewall.
        :paramtype storage_container_sas_key: str
        :keyword storage_account_access_key: Specifies the identifier key of the storage account for
         vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
         storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
         or a firewall.
        :paramtype storage_account_access_key: str
        :keyword recurring_scans: The recurring scans settings.
        :paramtype recurring_scans:
         ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
        """
        super().__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class ManagedInstanceVulnerabilityAssessmentListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the ManagedInstance's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedInstanceVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedInstanceVulnerabilityAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedInstanceVulnerabilityAssessment"]] = None
        self.next_link: Optional[str] = None


class ManagedLedgerDigestUploads(ProxyResource):
    """Azure SQL Database ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar digest_storage_endpoint: The digest storage endpoint, which must be either an Azure blob
     storage endpoint or an URI for Azure Confidential Ledger.
    :vartype digest_storage_endpoint: str
    :ivar state: Specifies the state of ledger digest upload. Known values are: "Enabled" and
     "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagedLedgerDigestUploadsState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "digest_storage_endpoint": {"key": "properties.digestStorageEndpoint", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(self, *, digest_storage_endpoint: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword digest_storage_endpoint: The digest storage endpoint, which must be either an Azure
         blob storage endpoint or an URI for Azure Confidential Ledger.
        :paramtype digest_storage_endpoint: str
        """
        super().__init__(**kwargs)
        self.digest_storage_endpoint = digest_storage_endpoint
        self.state: Optional[Union[str, "_models.ManagedLedgerDigestUploadsState"]] = None


class ManagedLedgerDigestUploadsListResult(_serialization.Model):
    """A list of ledger digest upload settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedLedgerDigestUploads]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedLedgerDigestUploads]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedLedgerDigestUploads"]] = None
        self.next_link: Optional[str] = None


class ManagedServerDnsAlias(ProxyResource):
    """A managed server DNS alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_dns_record: The fully qualified DNS record for managed server alias.
    :vartype azure_dns_record: str
    :ivar public_azure_dns_record: The fully qualified public DNS record for managed server alias.
    :vartype public_azure_dns_record: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "azure_dns_record": {"readonly": True},
        "public_azure_dns_record": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "azure_dns_record": {"key": "properties.azureDnsRecord", "type": "str"},
        "public_azure_dns_record": {"key": "properties.publicAzureDnsRecord", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_dns_record: Optional[str] = None
        self.public_azure_dns_record: Optional[str] = None


class ManagedServerDnsAliasAcquisition(_serialization.Model):
    """A managed server DNS alias acquisition request.

    All required parameters must be populated in order to send to server.

    :ivar old_managed_server_dns_alias_resource_id: The resource ID of the managed server DNS alias
     that will be acquired to point to this managed server instead. Required.
    :vartype old_managed_server_dns_alias_resource_id: str
    """

    _validation = {
        "old_managed_server_dns_alias_resource_id": {"required": True},
    }

    _attribute_map = {
        "old_managed_server_dns_alias_resource_id": {"key": "oldManagedServerDnsAliasResourceId", "type": "str"},
    }

    def __init__(self, *, old_managed_server_dns_alias_resource_id: str, **kwargs: Any) -> None:
        """
        :keyword old_managed_server_dns_alias_resource_id: The resource ID of the managed server DNS
         alias that will be acquired to point to this managed server instead. Required.
        :paramtype old_managed_server_dns_alias_resource_id: str
        """
        super().__init__(**kwargs)
        self.old_managed_server_dns_alias_resource_id = old_managed_server_dns_alias_resource_id


class ManagedServerDnsAliasCreation(_serialization.Model):
    """A managed server dns alias creation request.

    :ivar create_dns_record: Whether or not DNS record should be created for this alias.
    :vartype create_dns_record: bool
    """

    _attribute_map = {
        "create_dns_record": {"key": "createDnsRecord", "type": "bool"},
    }

    def __init__(self, *, create_dns_record: bool = True, **kwargs: Any) -> None:
        """
        :keyword create_dns_record: Whether or not DNS record should be created for this alias.
        :paramtype create_dns_record: bool
        """
        super().__init__(**kwargs)
        self.create_dns_record = create_dns_record


class ManagedServerDnsAliasListResult(_serialization.Model):
    """A list of managed server DNS aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedServerDnsAlias]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedServerDnsAlias]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedServerDnsAlias"]] = None
        self.next_link: Optional[str] = None


class ManagedServerSecurityAlertPolicy(ProxyResource):
    """A managed server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :ivar disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :vartype disabled_alerts: list[str]
    :ivar email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :vartype email_addresses: list[str]
    :ivar email_account_admins: Specifies that the alert is sent to the account administrators.
    :vartype email_account_admins: bool
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :vartype storage_account_access_key: str
    :ivar retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :vartype retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "disabled_alerts": {"key": "properties.disabledAlerts", "type": "[str]"},
        "email_addresses": {"key": "properties.emailAddresses", "type": "[str]"},
        "email_account_admins": {"key": "properties.emailAccountAdmins", "type": "bool"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the policy, whether it is enabled or disabled or a
         policy has not been applied yet on the specific database. Known values are: "Enabled" and
         "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
        :keyword disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
         Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
         Brute_Force.
        :paramtype disabled_alerts: list[str]
        :keyword email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
        :paramtype email_addresses: list[str]
        :keyword email_account_admins: Specifies that the alert is sent to the account administrators.
        :paramtype email_account_admins: bool
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
         audit logs.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the Threat Detection audit
         storage account.
        :paramtype storage_account_access_key: str
        :keyword retention_days: Specifies the number of days to keep in the Threat Detection audit
         logs.
        :paramtype retention_days: int
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time: Optional[datetime.datetime] = None


class ManagedServerSecurityAlertPolicyListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of the managed Server's security alert policies.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedServerSecurityAlertPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedServerSecurityAlertPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedServerSecurityAlertPolicy"]] = None
        self.next_link: Optional[str] = None


class ManagedTransparentDataEncryption(ProxyResource):
    """A managed database transparent data encryption state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: Specifies the state of the transparent data encryption. Known values are:
     "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.TransparentDataEncryptionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the transparent data encryption. Known values are:
         "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.TransparentDataEncryptionState
        """
        super().__init__(**kwargs)
        self.state = state


class ManagedTransparentDataEncryptionListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of managed transparent data encryptions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ManagedTransparentDataEncryption]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedTransparentDataEncryption]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ManagedTransparentDataEncryption"]] = None
        self.next_link: Optional[str] = None


class MaxLimitRangeCapability(_serialization.Model):
    """The maximum limit range capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: int
    :ivar max_value: Maximum value.
    :vartype max_value: int
    :ivar scale_size: Scale/step size for discrete values between the minimum value and the maximum
     value.
    :vartype scale_size: int
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "min_value": {"readonly": True},
        "max_value": {"readonly": True},
        "scale_size": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "min_value": {"key": "minValue", "type": "int"},
        "max_value": {"key": "maxValue", "type": "int"},
        "scale_size": {"key": "scaleSize", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.min_value: Optional[int] = None
        self.max_value: Optional[int] = None
        self.scale_size: Optional[int] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class MaxSizeCapability(_serialization.Model):
    """The maximum size capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar limit: The maximum size limit (see 'unit' for the units).
    :vartype limit: int
    :ivar unit: The units that the limit is expressed in. Known values are: "Megabytes",
     "Gigabytes", "Terabytes", and "Petabytes".
    :vartype unit: str or ~azure.mgmt.sql.models.MaxSizeUnit
    """

    _validation = {
        "limit": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "limit": {"key": "limit", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.limit: Optional[int] = None
        self.unit: Optional[Union[str, "_models.MaxSizeUnit"]] = None


class MaxSizeRangeCapability(_serialization.Model):
    """The maximum size range capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar max_value: Maximum value.
    :vartype max_value: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar scale_size: Scale/step size for discrete values between the minimum value and the maximum
     value.
    :vartype scale_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar log_size: Size of transaction log.
    :vartype log_size: ~azure.mgmt.sql.models.LogSizeCapability
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "min_value": {"readonly": True},
        "max_value": {"readonly": True},
        "scale_size": {"readonly": True},
        "log_size": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "min_value": {"key": "minValue", "type": "MaxSizeCapability"},
        "max_value": {"key": "maxValue", "type": "MaxSizeCapability"},
        "scale_size": {"key": "scaleSize", "type": "MaxSizeCapability"},
        "log_size": {"key": "logSize", "type": "LogSizeCapability"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.min_value: Optional["_models.MaxSizeCapability"] = None
        self.max_value: Optional["_models.MaxSizeCapability"] = None
        self.scale_size: Optional["_models.MaxSizeCapability"] = None
        self.log_size: Optional["_models.LogSizeCapability"] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class MinCapacityCapability(_serialization.Model):
    """The min capacity capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Min capacity value.
    :vartype value: float
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "value": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "float"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.value: Optional[float] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class Name(_serialization.Model):
    """ARM Usage Name.

    :ivar value: Usage name value.
    :vartype value: str
    :ivar localized_value: Usage name localized value.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Usage name value.
        :paramtype value: str
        :keyword localized_value: Usage name localized value.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class NetworkIsolationSettings(_serialization.Model):
    """Contains the ARM resources for which to create private endpoint connection.

    :ivar storage_account_resource_id: The resource id for the storage account used to store BACPAC
     file. If set, private endpoint connection will be created for the storage account. Must match
     storage account used for StorageUri parameter.
    :vartype storage_account_resource_id: str
    :ivar sql_server_resource_id: The resource id for the SQL server which is the target of this
     request. If set, private endpoint connection will be created for the SQL server. Must match
     server which is target of the operation.
    :vartype sql_server_resource_id: str
    """

    _attribute_map = {
        "storage_account_resource_id": {"key": "storageAccountResourceId", "type": "str"},
        "sql_server_resource_id": {"key": "sqlServerResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_resource_id: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_resource_id: The resource id for the storage account used to store
         BACPAC file. If set, private endpoint connection will be created for the storage account. Must
         match storage account used for StorageUri parameter.
        :paramtype storage_account_resource_id: str
        :keyword sql_server_resource_id: The resource id for the SQL server which is the target of this
         request. If set, private endpoint connection will be created for the SQL server. Must match
         server which is target of the operation.
        :paramtype sql_server_resource_id: str
        """
        super().__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.sql_server_resource_id = sql_server_resource_id


class NetworkSecurityPerimeterConfiguration(ProxyResource):
    """NSP Configuration for a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state:
    :vartype provisioning_state: str
    :ivar network_security_perimeter:
    :vartype network_security_perimeter: ~azure.mgmt.sql.models.NSPConfigPerimeter
    :ivar resource_association:
    :vartype resource_association: ~azure.mgmt.sql.models.NSPConfigAssociation
    :ivar profile:
    :vartype profile: ~azure.mgmt.sql.models.NSPConfigProfile
    :ivar provisioning_issues:
    :vartype provisioning_issues: list[~azure.mgmt.sql.models.NSPProvisioningIssue]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_security_perimeter": {"key": "properties.networkSecurityPerimeter", "type": "NSPConfigPerimeter"},
        "resource_association": {"key": "properties.resourceAssociation", "type": "NSPConfigAssociation"},
        "profile": {"key": "properties.profile", "type": "NSPConfigProfile"},
        "provisioning_issues": {"key": "properties.provisioningIssues", "type": "[NSPProvisioningIssue]"},
    }

    def __init__(
        self,
        *,
        network_security_perimeter: Optional["_models.NSPConfigPerimeter"] = None,
        resource_association: Optional["_models.NSPConfigAssociation"] = None,
        profile: Optional["_models.NSPConfigProfile"] = None,
        provisioning_issues: Optional[List["_models.NSPProvisioningIssue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_security_perimeter:
        :paramtype network_security_perimeter: ~azure.mgmt.sql.models.NSPConfigPerimeter
        :keyword resource_association:
        :paramtype resource_association: ~azure.mgmt.sql.models.NSPConfigAssociation
        :keyword profile:
        :paramtype profile: ~azure.mgmt.sql.models.NSPConfigProfile
        :keyword provisioning_issues:
        :paramtype provisioning_issues: list[~azure.mgmt.sql.models.NSPProvisioningIssue]
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None
        self.network_security_perimeter = network_security_perimeter
        self.resource_association = resource_association
        self.profile = profile
        self.provisioning_issues = provisioning_issues


class NetworkSecurityPerimeterConfigurationListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of NSP configurations for a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.NetworkSecurityPerimeterConfiguration]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityPerimeterConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.NetworkSecurityPerimeterConfiguration"]] = None
        self.next_link: Optional[str] = None


class NSPConfigAccessRule(_serialization.Model):
    """NSPConfigAccessRule.

    :ivar name:
    :vartype name: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.sql.models.NSPConfigAccessRuleProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "NSPConfigAccessRuleProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.NSPConfigAccessRuleProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword properties:
        :paramtype properties: ~azure.mgmt.sql.models.NSPConfigAccessRuleProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class NSPConfigAccessRuleProperties(_serialization.Model):
    """NSPConfigAccessRuleProperties.

    :ivar direction:
    :vartype direction: str
    :ivar address_prefixes:
    :vartype address_prefixes: list[str]
    :ivar fully_qualified_domain_names:
    :vartype fully_qualified_domain_names: list[str]
    :ivar subscriptions:
    :vartype subscriptions: list[str]
    :ivar network_security_perimeters:
    :vartype network_security_perimeters:
     list[~azure.mgmt.sql.models.NSPConfigNetworkSecurityPerimeterRule]
    :ivar service_tags:
    :vartype service_tags: list[str]
    """

    _attribute_map = {
        "direction": {"key": "direction", "type": "str"},
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
        "fully_qualified_domain_names": {"key": "fullyQualifiedDomainNames", "type": "[str]"},
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
        "network_security_perimeters": {
            "key": "networkSecurityPerimeters",
            "type": "[NSPConfigNetworkSecurityPerimeterRule]",
        },
        "service_tags": {"key": "serviceTags", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        direction: Optional[str] = None,
        address_prefixes: Optional[List[str]] = None,
        fully_qualified_domain_names: Optional[List[str]] = None,
        subscriptions: Optional[List[str]] = None,
        network_security_perimeters: Optional[List["_models.NSPConfigNetworkSecurityPerimeterRule"]] = None,
        service_tags: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword direction:
        :paramtype direction: str
        :keyword address_prefixes:
        :paramtype address_prefixes: list[str]
        :keyword fully_qualified_domain_names:
        :paramtype fully_qualified_domain_names: list[str]
        :keyword subscriptions:
        :paramtype subscriptions: list[str]
        :keyword network_security_perimeters:
        :paramtype network_security_perimeters:
         list[~azure.mgmt.sql.models.NSPConfigNetworkSecurityPerimeterRule]
        :keyword service_tags:
        :paramtype service_tags: list[str]
        """
        super().__init__(**kwargs)
        self.direction = direction
        self.address_prefixes = address_prefixes
        self.fully_qualified_domain_names = fully_qualified_domain_names
        self.subscriptions = subscriptions
        self.network_security_perimeters = network_security_perimeters
        self.service_tags = service_tags


class NSPConfigAssociation(_serialization.Model):
    """NSPConfigAssociation.

    :ivar name:
    :vartype name: str
    :ivar access_mode:
    :vartype access_mode: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_mode": {"key": "accessMode", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, access_mode: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword access_mode:
        :paramtype access_mode: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_mode = access_mode


class NSPConfigNetworkSecurityPerimeterRule(_serialization.Model):
    """NSPConfigNetworkSecurityPerimeterRule.

    :ivar id:
    :vartype id: str
    :ivar perimeter_guid:
    :vartype perimeter_guid: str
    :ivar location:
    :vartype location: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "perimeter_guid": {"key": "perimeterGuid", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        perimeter_guid: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword perimeter_guid:
        :paramtype perimeter_guid: str
        :keyword location:
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.perimeter_guid = perimeter_guid
        self.location = location


class NSPConfigPerimeter(_serialization.Model):
    """NSPConfigPerimeter.

    :ivar id:
    :vartype id: str
    :ivar perimeter_guid:
    :vartype perimeter_guid: str
    :ivar location:
    :vartype location: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "perimeter_guid": {"key": "perimeterGuid", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        perimeter_guid: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id:
        :paramtype id: str
        :keyword perimeter_guid:
        :paramtype perimeter_guid: str
        :keyword location:
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.perimeter_guid = perimeter_guid
        self.location = location


class NSPConfigProfile(_serialization.Model):
    """NSPConfigProfile.

    :ivar name:
    :vartype name: str
    :ivar access_rules_version:
    :vartype access_rules_version: str
    :ivar access_rules:
    :vartype access_rules: list[~azure.mgmt.sql.models.NSPConfigAccessRule]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "access_rules_version": {"key": "accessRulesVersion", "type": "str"},
        "access_rules": {"key": "accessRules", "type": "[NSPConfigAccessRule]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        access_rules_version: Optional[str] = None,
        access_rules: Optional[List["_models.NSPConfigAccessRule"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword access_rules_version:
        :paramtype access_rules_version: str
        :keyword access_rules:
        :paramtype access_rules: list[~azure.mgmt.sql.models.NSPConfigAccessRule]
        """
        super().__init__(**kwargs)
        self.name = name
        self.access_rules_version = access_rules_version
        self.access_rules = access_rules


class NSPProvisioningIssue(_serialization.Model):
    """NSPProvisioningIssue.

    :ivar name:
    :vartype name: str
    :ivar properties:
    :vartype properties: ~azure.mgmt.sql.models.NSPProvisioningIssueProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "NSPProvisioningIssueProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.NSPProvisioningIssueProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword properties:
        :paramtype properties: ~azure.mgmt.sql.models.NSPProvisioningIssueProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties


class NSPProvisioningIssueProperties(_serialization.Model):
    """NSPProvisioningIssueProperties.

    :ivar issue_type:
    :vartype issue_type: str
    :ivar severity:
    :vartype severity: str
    :ivar description:
    :vartype description: str
    :ivar suggested_resource_ids:
    :vartype suggested_resource_ids: list[str]
    :ivar suggested_access_rules:
    :vartype suggested_access_rules: list[str]
    """

    _attribute_map = {
        "issue_type": {"key": "issueType", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "suggested_resource_ids": {"key": "suggestedResourceIds", "type": "[str]"},
        "suggested_access_rules": {"key": "suggestedAccessRules", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        issue_type: Optional[str] = None,
        severity: Optional[str] = None,
        description: Optional[str] = None,
        suggested_resource_ids: Optional[List[str]] = None,
        suggested_access_rules: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue_type:
        :paramtype issue_type: str
        :keyword severity:
        :paramtype severity: str
        :keyword description:
        :paramtype description: str
        :keyword suggested_resource_ids:
        :paramtype suggested_resource_ids: list[str]
        :keyword suggested_access_rules:
        :paramtype suggested_access_rules: list[str]
        """
        super().__init__(**kwargs)
        self.issue_type = issue_type
        self.severity = severity
        self.description = description
        self.suggested_resource_ids = suggested_resource_ids
        self.suggested_access_rules = suggested_access_rules


class Operation(_serialization.Model):
    """SQL REST API operation definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation being performed on this particular object.
    :vartype name: str
    :ivar display: The localized display information for this particular operation / action.
    :vartype display: ~azure.mgmt.sql.models.OperationDisplay
    :ivar origin: The intended executor of the operation. Known values are: "user" and "system".
    :vartype origin: str or ~azure.mgmt.sql.models.OperationOrigin
    :ivar properties: Additional descriptions for the operation.
    :vartype properties: dict[str, JSON]
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "origin": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "{object}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.display: Optional["_models.OperationDisplay"] = None
        self.origin: Optional[Union[str, "_models.OperationOrigin"]] = None
        self.properties: Optional[Dict[str, JSON]] = None


class OperationDisplay(_serialization.Model):
    """Display metadata associated with the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name.
    :vartype provider: str
    :ivar resource: The localized friendly form of the resource type related to this
     action/operation.
    :vartype resource: str
    :ivar operation: The localized friendly name for the operation.
    :vartype operation: str
    :ivar description: The localized friendly description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider: Optional[str] = None
        self.resource: Optional[str] = None
        self.operation: Optional[str] = None
        self.description: Optional[str] = None


class OperationListResult(_serialization.Model):
    """Result of the request to list SQL operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Operation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Operation"]] = None
        self.next_link: Optional[str] = None


class OutboundEnvironmentEndpoint(_serialization.Model):
    """An endpoint that the managed instance service requires outbound network access to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar category: The type of service accessed by the managed instance service, e.g., Azure
     Storage, Azure Active Directory, etc.
    :vartype category: str
    :ivar endpoints: The endpoints that the managed instance service communicates with in order to
     function correctly.
    :vartype endpoints: list[~azure.mgmt.sql.models.EndpointDependency]
    """

    _validation = {
        "category": {"readonly": True},
        "endpoints": {"readonly": True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "endpoints": {"key": "endpoints", "type": "[EndpointDependency]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.category: Optional[str] = None
        self.endpoints: Optional[List["_models.EndpointDependency"]] = None


class OutboundEnvironmentEndpointCollection(_serialization.Model):
    """A collection of endpoints that the managed instance service requires outbound network access
    to.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.OutboundEnvironmentEndpoint]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundEnvironmentEndpoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.OutboundEnvironmentEndpoint"]] = None
        self.next_link: Optional[str] = None


class OutboundFirewallRule(ProxyResource):
    """An Azure SQL DB Server Outbound Firewall Rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The state of the outbound rule.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None


class OutboundFirewallRuleListResult(_serialization.Model):
    """A list of outbound rules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.OutboundFirewallRule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OutboundFirewallRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.OutboundFirewallRule"]] = None
        self.next_link: Optional[str] = None


class PartnerInfo(_serialization.Model):
    """Partner server information for the failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource identifier of the partner server. Required.
    :vartype id: str
    :ivar location: Geo location of the partner server.
    :vartype location: str
    :ivar replication_role: Replication role of the partner server. Known values are: "Primary" and
     "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.FailoverGroupReplicationRole
    """

    _validation = {
        "id": {"required": True},
        "location": {"readonly": True},
        "replication_role": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "replication_role": {"key": "replicationRole", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource identifier of the partner server. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.location: Optional[str] = None
        self.replication_role: Optional[Union[str, "_models.FailoverGroupReplicationRole"]] = None


class PartnerRegionInfo(_serialization.Model):
    """Partner region information for the failover group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Geo location of the partner managed instances.
    :vartype location: str
    :ivar replication_role: Replication role of the partner managed instances. Known values are:
     "Primary" and "Secondary".
    :vartype replication_role: str or ~azure.mgmt.sql.models.InstanceFailoverGroupReplicationRole
    """

    _validation = {
        "replication_role": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "replication_role": {"key": "replicationRole", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Geo location of the partner managed instances.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location
        self.replication_role: Optional[Union[str, "_models.InstanceFailoverGroupReplicationRole"]] = None


class PerDatabaseAutoPauseDelayTimeRange(_serialization.Model):
    """Supported auto pause delay time range.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar min_value: Minimum value.
    :vartype min_value: int
    :ivar max_value: Maximum value.
    :vartype max_value: int
    :ivar step_size: Step value for discrete values between the minimum value and the maximum
     value.
    :vartype step_size: int
    :ivar default: Default value if no value is provided.
    :vartype default: int
    :ivar unit: Unit of time that delay is expressed in. "Minutes"
    :vartype unit: str or ~azure.mgmt.sql.models.PauseDelayTimeUnit
    :ivar do_not_pause_value: Value that is used to not pause (infinite delay before pause).
    :vartype do_not_pause_value: int
    """

    _validation = {
        "min_value": {"readonly": True},
        "max_value": {"readonly": True},
        "step_size": {"readonly": True},
        "default": {"readonly": True},
        "unit": {"readonly": True},
        "do_not_pause_value": {"readonly": True},
    }

    _attribute_map = {
        "min_value": {"key": "minValue", "type": "int"},
        "max_value": {"key": "maxValue", "type": "int"},
        "step_size": {"key": "stepSize", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "unit": {"key": "unit", "type": "str"},
        "do_not_pause_value": {"key": "doNotPauseValue", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.min_value: Optional[int] = None
        self.max_value: Optional[int] = None
        self.step_size: Optional[int] = None
        self.default: Optional[int] = None
        self.unit: Optional[Union[str, "_models.PauseDelayTimeUnit"]] = None
        self.do_not_pause_value: Optional[int] = None


class PerformanceLevelCapability(_serialization.Model):
    """The performance level capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Performance level value.
    :vartype value: float
    :ivar unit: Unit type used to measure performance level. Known values are: "DTU" and "VCores".
    :vartype unit: str or ~azure.mgmt.sql.models.PerformanceLevelUnit
    """

    _validation = {
        "value": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "float"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[float] = None
        self.unit: Optional[Union[str, "_models.PerformanceLevelUnit"]] = None


class PhaseDetails(_serialization.Model):
    """The phase details properties of a database operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar phase: The operation phase. Known values are: "LogTransitionInProgress", "Copying",
     "BuildingHyperscaleComponents", "Catchup", "WaitingForCutover", and "CutoverInProgress".
    :vartype phase: str or ~azure.mgmt.sql.models.Phase
    :ivar phase_information: The operation phase information.
    :vartype phase_information: dict[str, str]
    """

    _validation = {
        "phase": {"readonly": True},
        "phase_information": {"readonly": True},
    }

    _attribute_map = {
        "phase": {"key": "phase", "type": "str"},
        "phase_information": {"key": "phaseInformation", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.phase: Optional[Union[str, "_models.Phase"]] = None
        self.phase_information: Optional[Dict[str, str]] = None


class PrivateEndpointConnection(ProxyResource):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :ivar group_ids: Group IDs.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Known values are:
     "Approving", "Ready", "Dropping", "Failed", and "Rejecting".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpointProperty"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids: Optional[List[str]] = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointProvisioningState"]] = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.PrivateEndpointConnection]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PrivateEndpointConnection"]] = None
        self.next_link: Optional[str] = None


class PrivateEndpointConnectionProperties(_serialization.Model):
    """Properties of a private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_endpoint: Private endpoint which the connection belongs to.
    :vartype private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
    :ivar group_ids: Group IDs.
    :vartype group_ids: list[str]
    :ivar private_link_service_connection_state: Connection state of the private endpoint
     connection.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
    :ivar provisioning_state: State of the private endpoint connection. Known values are:
     "Approving", "Ready", "Dropping", "Failed", and "Rejecting".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.PrivateEndpointProvisioningState
    """

    _validation = {
        "group_ids": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpointProperty"},
        "group_ids": {"key": "groupIds", "type": "[str]"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionStateProperty",
        },
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpointProperty"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionStateProperty"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: Private endpoint which the connection belongs to.
        :paramtype private_endpoint: ~azure.mgmt.sql.models.PrivateEndpointProperty
        :keyword private_link_service_connection_state: Connection state of the private endpoint
         connection.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateProperty
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids: Optional[List[str]] = None
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state: Optional[Union[str, "_models.PrivateEndpointProvisioningState"]] = None


class PrivateEndpointConnectionRequestStatus(_serialization.Model):
    """Contains the private endpoint connection requests status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar private_link_service_id: Resource id for which the private endpoint is created.
    :vartype private_link_service_id: str
    :ivar private_endpoint_connection_name: The connection name for the private endpoint.
    :vartype private_endpoint_connection_name: str
    :ivar status: Status of this private endpoint connection.
    :vartype status: str
    """

    _validation = {
        "private_link_service_id": {"readonly": True},
        "private_endpoint_connection_name": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "private_link_service_id": {"key": "privateLinkServiceId", "type": "str"},
        "private_endpoint_connection_name": {"key": "privateEndpointConnectionName", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.private_link_service_id: Optional[str] = None
        self.private_endpoint_connection_name: Optional[str] = None
        self.status: Optional[str] = None


class PrivateEndpointProperty(_serialization.Model):
    """PrivateEndpointProperty.

    :ivar id: Resource id of the private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource id of the private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateLinkResource(ProxyResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The private link resource group id.
    :vartype properties: ~azure.mgmt.sql.models.PrivateLinkResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateLinkResourceProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.properties: Optional["_models.PrivateLinkResourceProperties"] = None


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.PrivateLinkResource]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.PrivateLinkResource"]] = None
        self.next_link: Optional[str] = None


class PrivateLinkResourceProperties(_serialization.Model):
    """Properties of a private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource required zone names.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "group_id": {"key": "groupId", "type": "str"},
        "required_members": {"key": "requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.group_id: Optional[str] = None
        self.required_members: Optional[List[str]] = None
        self.required_zone_names: Optional[List[str]] = None


class PrivateLinkServiceConnectionStateProperty(_serialization.Model):  # pylint: disable=name-too-long
    """PrivateLinkServiceConnectionStateProperty.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: The private link service connection status. Required. Known values are:
     "Approved", "Pending", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateStatus
    :ivar description: The private link service connection description. Required.
    :vartype description: str
    :ivar actions_required: The actions required for private link service connection. "None"
    :vartype actions_required: str or
     ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateActionsRequire
    """

    _validation = {
        "status": {"required": True},
        "description": {"required": True},
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self, *, status: Union[str, "_models.PrivateLinkServiceConnectionStateStatus"], description: str, **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Required. Known values are:
         "Approved", "Pending", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.sql.models.PrivateLinkServiceConnectionStateStatus
        :keyword description: The private link service connection description. Required.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required: Optional[Union[str, "_models.PrivateLinkServiceConnectionStateActionsRequire"]] = None


class QueryCheck(_serialization.Model):
    """SQL Vulnerability Assessment query check object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar query: SQL Vulnerability Assessment rule query.
    :vartype query: str
    :ivar expected_result: SQL Vulnerability Assessment query expected result.
    :vartype expected_result: list[list[str]]
    :ivar column_names: SQL Vulnerability Assessment column names of query expected result.
    :vartype column_names: list[str]
    """

    _validation = {
        "query": {"readonly": True},
        "expected_result": {"readonly": True},
        "column_names": {"readonly": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "expected_result": {"key": "expectedResult", "type": "[[str]]"},
        "column_names": {"key": "columnNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.query: Optional[str] = None
        self.expected_result: Optional[List[List[str]]] = None
        self.column_names: Optional[List[str]] = None


class QueryMetricInterval(_serialization.Model):
    """Properties of a query metrics interval.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar interval_start_time: The start time for the metric interval (ISO-8601 format).
    :vartype interval_start_time: str
    :ivar interval_type: Interval type (length). Known values are: "PT1H" and "P1D".
    :vartype interval_type: str or ~azure.mgmt.sql.models.QueryTimeGrainType
    :ivar execution_count: Execution count of a query in this interval.
    :vartype execution_count: int
    :ivar metrics: List of metric objects for this interval.
    :vartype metrics: list[~azure.mgmt.sql.models.QueryMetricProperties]
    """

    _validation = {
        "interval_start_time": {"readonly": True},
        "interval_type": {"readonly": True},
        "execution_count": {"readonly": True},
    }

    _attribute_map = {
        "interval_start_time": {"key": "intervalStartTime", "type": "str"},
        "interval_type": {"key": "intervalType", "type": "str"},
        "execution_count": {"key": "executionCount", "type": "int"},
        "metrics": {"key": "metrics", "type": "[QueryMetricProperties]"},
    }

    def __init__(self, *, metrics: Optional[List["_models.QueryMetricProperties"]] = None, **kwargs: Any) -> None:
        """
        :keyword metrics: List of metric objects for this interval.
        :paramtype metrics: list[~azure.mgmt.sql.models.QueryMetricProperties]
        """
        super().__init__(**kwargs)
        self.interval_start_time: Optional[str] = None
        self.interval_type: Optional[Union[str, "_models.QueryTimeGrainType"]] = None
        self.execution_count: Optional[int] = None
        self.metrics = metrics


class QueryMetricProperties(_serialization.Model):
    """Properties of a topquery metric in one interval.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name information for the metric.
    :vartype name: str
    :ivar display_name: The UI appropriate name for the metric.
    :vartype display_name: str
    :ivar unit: The unit of the metric. Known values are: "percentage", "KB", "microseconds", and
     "count".
    :vartype unit: str or ~azure.mgmt.sql.models.QueryMetricUnitType
    :ivar value: The value of the metric.
    :vartype value: float
    :ivar min: Metric value when min() aggregate function is used over the interval.
    :vartype min: float
    :ivar max: Metric value when max() aggregate function is used over the interval.
    :vartype max: float
    :ivar avg: Metric value when avg() aggregate function is used over the interval.
    :vartype avg: float
    :ivar sum: Metric value when sum() aggregate function is used over the interval.
    :vartype sum: float
    :ivar stdev: Metric value when stdev aggregate function is used over the interval.
    :vartype stdev: float
    """

    _validation = {
        "name": {"readonly": True},
        "display_name": {"readonly": True},
        "unit": {"readonly": True},
        "value": {"readonly": True},
        "min": {"readonly": True},
        "max": {"readonly": True},
        "avg": {"readonly": True},
        "sum": {"readonly": True},
        "stdev": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "value": {"key": "value", "type": "float"},
        "min": {"key": "min", "type": "float"},
        "max": {"key": "max", "type": "float"},
        "avg": {"key": "avg", "type": "float"},
        "sum": {"key": "sum", "type": "float"},
        "stdev": {"key": "stdev", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.display_name: Optional[str] = None
        self.unit: Optional[Union[str, "_models.QueryMetricUnitType"]] = None
        self.value: Optional[float] = None
        self.min: Optional[float] = None
        self.max: Optional[float] = None
        self.avg: Optional[float] = None
        self.sum: Optional[float] = None
        self.stdev: Optional[float] = None


class QueryStatistics(ProxyResource):
    """QueryStatistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_name: Database name of the database in which this query was executed.
    :vartype database_name: str
    :ivar query_id: Unique query id (unique within one database).
    :vartype query_id: str
    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: str
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: str
    :ivar intervals: List of intervals with appropriate metric data.
    :vartype intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "database_name": {"readonly": True},
        "query_id": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "query_id": {"key": "properties.queryId", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "str"},
        "end_time": {"key": "properties.endTime", "type": "str"},
        "intervals": {"key": "properties.intervals", "type": "[QueryMetricInterval]"},
    }

    def __init__(self, *, intervals: Optional[List["_models.QueryMetricInterval"]] = None, **kwargs: Any) -> None:
        """
        :keyword intervals: List of intervals with appropriate metric data.
        :paramtype intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
        """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.query_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.intervals = intervals


class QueryStatisticsProperties(_serialization.Model):
    """Properties of a query execution statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar database_name: Database name of the database in which this query was executed.
    :vartype database_name: str
    :ivar query_id: Unique query id (unique within one database).
    :vartype query_id: str
    :ivar start_time: The start time for the metric (ISO-8601 format).
    :vartype start_time: str
    :ivar end_time: The end time for the metric (ISO-8601 format).
    :vartype end_time: str
    :ivar intervals: List of intervals with appropriate metric data.
    :vartype intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
    """

    _validation = {
        "database_name": {"readonly": True},
        "query_id": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
    }

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "query_id": {"key": "queryId", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "end_time": {"key": "endTime", "type": "str"},
        "intervals": {"key": "intervals", "type": "[QueryMetricInterval]"},
    }

    def __init__(self, *, intervals: Optional[List["_models.QueryMetricInterval"]] = None, **kwargs: Any) -> None:
        """
        :keyword intervals: List of intervals with appropriate metric data.
        :paramtype intervals: list[~azure.mgmt.sql.models.QueryMetricInterval]
        """
        super().__init__(**kwargs)
        self.database_name: Optional[str] = None
        self.query_id: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        self.intervals = intervals


class ReadScaleCapability(_serialization.Model):
    """The read scale capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max_number_of_replicas: The maximum number of read scale replicas.
    :vartype max_number_of_replicas: int
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "max_number_of_replicas": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "max_number_of_replicas": {"key": "maxNumberOfReplicas", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.max_number_of_replicas: Optional[int] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class RecommendedAction(_serialization.Model):
    """Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_reason: Gets the reason for recommending this action. e.g.,
     DuplicateIndex.
    :vartype recommendation_reason: str
    :ivar valid_since: Gets the time since when this recommended action is valid.
    :vartype valid_since: ~datetime.datetime
    :ivar last_refresh: Gets time when this recommended action was last refreshed.
    :vartype last_refresh: ~datetime.datetime
    :ivar state: Gets the info of the current state the recommended action is in.
    :vartype state: ~azure.mgmt.sql.models.RecommendedActionStateInfo
    :ivar is_executable_action: Gets if this recommended action is actionable by user.
    :vartype is_executable_action: bool
    :ivar is_revertable_action: Gets if changes applied by this recommended action can be reverted
     by user.
    :vartype is_revertable_action: bool
    :ivar is_archived_action: Gets if this recommended action was suggested some time ago but user
     chose to ignore this and system added a new recommended action again.
    :vartype is_archived_action: bool
    :ivar execute_action_start_time: Gets the time when system started applying this recommended
     action on the user resource. e.g., index creation start time.
    :vartype execute_action_start_time: ~datetime.datetime
    :ivar execute_action_duration: Gets the time taken for applying this recommended action on user
     resource. e.g., time taken for index creation.
    :vartype execute_action_duration: ~datetime.timedelta
    :ivar revert_action_start_time: Gets the time when system started reverting changes of this
     recommended action on user resource. e.g., time when index drop is executed.
    :vartype revert_action_start_time: ~datetime.datetime
    :ivar revert_action_duration: Gets the time taken for reverting changes of this recommended
     action on user resource. e.g., time taken for dropping the created index.
    :vartype revert_action_duration: ~datetime.timedelta
    :ivar execute_action_initiated_by: Gets if approval for applying this recommended action was
     given by user/system. Known values are: "User" and "System".
    :vartype execute_action_initiated_by: str or
     ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar execute_action_initiated_time: Gets the time when this recommended action was approved
     for execution.
    :vartype execute_action_initiated_time: ~datetime.datetime
    :ivar revert_action_initiated_by: Gets if approval for reverting this recommended action was
     given by user/system. Known values are: "User" and "System".
    :vartype revert_action_initiated_by: str or ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar revert_action_initiated_time: Gets the time when this recommended action was approved for
     revert.
    :vartype revert_action_initiated_time: ~datetime.datetime
    :ivar score: Gets the impact of this recommended action. Possible values are 1 - Low impact, 2
     - Medium Impact and 3 - High Impact.
    :vartype score: int
    :ivar implementation_details: Gets the implementation details of this recommended action for
     user to apply it manually.
    :vartype implementation_details: ~azure.mgmt.sql.models.RecommendedActionImplementationInfo
    :ivar error_details: Gets the error details if and why this recommended action is put to error
     state.
    :vartype error_details: ~azure.mgmt.sql.models.RecommendedActionErrorInfo
    :ivar estimated_impact: Gets the estimated impact info for this recommended action e.g.,
     Estimated CPU gain, Estimated Disk Space change.
    :vartype estimated_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar observed_impact: Gets the observed/actual impact info for this recommended action e.g.,
     Actual CPU gain, Actual Disk Space change.
    :vartype observed_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar time_series: Gets the time series info of metrics for this recommended action e.g., CPU
     consumption time series.
    :vartype time_series: list[~azure.mgmt.sql.models.RecommendedActionMetricInfo]
    :ivar linked_objects: Gets the linked objects, if any.
    :vartype linked_objects: list[str]
    :ivar details: Gets additional details specific to this recommended action.
    :vartype details: dict[str, str]
    """

    _validation = {
        "kind": {"readonly": True},
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "recommendation_reason": {"readonly": True},
        "valid_since": {"readonly": True},
        "last_refresh": {"readonly": True},
        "is_executable_action": {"readonly": True},
        "is_revertable_action": {"readonly": True},
        "is_archived_action": {"readonly": True},
        "execute_action_start_time": {"readonly": True},
        "execute_action_duration": {"readonly": True},
        "revert_action_start_time": {"readonly": True},
        "revert_action_duration": {"readonly": True},
        "execute_action_initiated_by": {"readonly": True},
        "execute_action_initiated_time": {"readonly": True},
        "revert_action_initiated_by": {"readonly": True},
        "revert_action_initiated_time": {"readonly": True},
        "score": {"readonly": True},
        "implementation_details": {"readonly": True},
        "error_details": {"readonly": True},
        "estimated_impact": {"readonly": True},
        "observed_impact": {"readonly": True},
        "time_series": {"readonly": True},
        "linked_objects": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation_reason": {"key": "properties.recommendationReason", "type": "str"},
        "valid_since": {"key": "properties.validSince", "type": "iso-8601"},
        "last_refresh": {"key": "properties.lastRefresh", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "RecommendedActionStateInfo"},
        "is_executable_action": {"key": "properties.isExecutableAction", "type": "bool"},
        "is_revertable_action": {"key": "properties.isRevertableAction", "type": "bool"},
        "is_archived_action": {"key": "properties.isArchivedAction", "type": "bool"},
        "execute_action_start_time": {"key": "properties.executeActionStartTime", "type": "iso-8601"},
        "execute_action_duration": {"key": "properties.executeActionDuration", "type": "duration"},
        "revert_action_start_time": {"key": "properties.revertActionStartTime", "type": "iso-8601"},
        "revert_action_duration": {"key": "properties.revertActionDuration", "type": "duration"},
        "execute_action_initiated_by": {"key": "properties.executeActionInitiatedBy", "type": "str"},
        "execute_action_initiated_time": {"key": "properties.executeActionInitiatedTime", "type": "iso-8601"},
        "revert_action_initiated_by": {"key": "properties.revertActionInitiatedBy", "type": "str"},
        "revert_action_initiated_time": {"key": "properties.revertActionInitiatedTime", "type": "iso-8601"},
        "score": {"key": "properties.score", "type": "int"},
        "implementation_details": {
            "key": "properties.implementationDetails",
            "type": "RecommendedActionImplementationInfo",
        },
        "error_details": {"key": "properties.errorDetails", "type": "RecommendedActionErrorInfo"},
        "estimated_impact": {"key": "properties.estimatedImpact", "type": "[RecommendedActionImpactRecord]"},
        "observed_impact": {"key": "properties.observedImpact", "type": "[RecommendedActionImpactRecord]"},
        "time_series": {"key": "properties.timeSeries", "type": "[RecommendedActionMetricInfo]"},
        "linked_objects": {"key": "properties.linkedObjects", "type": "[str]"},
        "details": {"key": "properties.details", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, state: Optional["_models.RecommendedActionStateInfo"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Gets the info of the current state the recommended action is in.
        :paramtype state: ~azure.mgmt.sql.models.RecommendedActionStateInfo
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.location: Optional[str] = None
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.recommendation_reason: Optional[str] = None
        self.valid_since: Optional[datetime.datetime] = None
        self.last_refresh: Optional[datetime.datetime] = None
        self.state = state
        self.is_executable_action: Optional[bool] = None
        self.is_revertable_action: Optional[bool] = None
        self.is_archived_action: Optional[bool] = None
        self.execute_action_start_time: Optional[datetime.datetime] = None
        self.execute_action_duration: Optional[datetime.timedelta] = None
        self.revert_action_start_time: Optional[datetime.datetime] = None
        self.revert_action_duration: Optional[datetime.timedelta] = None
        self.execute_action_initiated_by: Optional[Union[str, "_models.RecommendedActionInitiatedBy"]] = None
        self.execute_action_initiated_time: Optional[datetime.datetime] = None
        self.revert_action_initiated_by: Optional[Union[str, "_models.RecommendedActionInitiatedBy"]] = None
        self.revert_action_initiated_time: Optional[datetime.datetime] = None
        self.score: Optional[int] = None
        self.implementation_details: Optional["_models.RecommendedActionImplementationInfo"] = None
        self.error_details: Optional["_models.RecommendedActionErrorInfo"] = None
        self.estimated_impact: Optional[List["_models.RecommendedActionImpactRecord"]] = None
        self.observed_impact: Optional[List["_models.RecommendedActionImpactRecord"]] = None
        self.time_series: Optional[List["_models.RecommendedActionMetricInfo"]] = None
        self.linked_objects: Optional[List[str]] = None
        self.details: Optional[Dict[str, str]] = None


class RecommendedActionAutoGenerated(ProxyResource):
    """Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Resource kind.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar recommendation_reason: Gets the reason for recommending this action. e.g.,
     DuplicateIndex.
    :vartype recommendation_reason: str
    :ivar valid_since: Gets the time since when this recommended action is valid.
    :vartype valid_since: ~datetime.datetime
    :ivar last_refresh: Gets time when this recommended action was last refreshed.
    :vartype last_refresh: ~datetime.datetime
    :ivar state: Gets the info of the current state the recommended action is in.
    :vartype state: ~azure.mgmt.sql.models.RecommendedActionStateInfo
    :ivar is_executable_action: Gets if this recommended action is actionable by user.
    :vartype is_executable_action: bool
    :ivar is_revertable_action: Gets if changes applied by this recommended action can be reverted
     by user.
    :vartype is_revertable_action: bool
    :ivar is_archived_action: Gets if this recommended action was suggested some time ago but user
     chose to ignore this and system added a new recommended action again.
    :vartype is_archived_action: bool
    :ivar execute_action_start_time: Gets the time when system started applying this recommended
     action on the user resource. e.g., index creation start time.
    :vartype execute_action_start_time: ~datetime.datetime
    :ivar execute_action_duration: Gets the time taken for applying this recommended action on user
     resource. e.g., time taken for index creation.
    :vartype execute_action_duration: ~datetime.timedelta
    :ivar revert_action_start_time: Gets the time when system started reverting changes of this
     recommended action on user resource. e.g., time when index drop is executed.
    :vartype revert_action_start_time: ~datetime.datetime
    :ivar revert_action_duration: Gets the time taken for reverting changes of this recommended
     action on user resource. e.g., time taken for dropping the created index.
    :vartype revert_action_duration: ~datetime.timedelta
    :ivar execute_action_initiated_by: Gets if approval for applying this recommended action was
     given by user/system. Known values are: "User" and "System".
    :vartype execute_action_initiated_by: str or
     ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar execute_action_initiated_time: Gets the time when this recommended action was approved
     for execution.
    :vartype execute_action_initiated_time: ~datetime.datetime
    :ivar revert_action_initiated_by: Gets if approval for reverting this recommended action was
     given by user/system. Known values are: "User" and "System".
    :vartype revert_action_initiated_by: str or ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar revert_action_initiated_time: Gets the time when this recommended action was approved for
     revert.
    :vartype revert_action_initiated_time: ~datetime.datetime
    :ivar score: Gets the impact of this recommended action. Possible values are 1 - Low impact, 2
     - Medium Impact and 3 - High Impact.
    :vartype score: int
    :ivar implementation_details: Gets the implementation details of this recommended action for
     user to apply it manually.
    :vartype implementation_details: ~azure.mgmt.sql.models.RecommendedActionImplementationInfo
    :ivar error_details: Gets the error details if and why this recommended action is put to error
     state.
    :vartype error_details: ~azure.mgmt.sql.models.RecommendedActionErrorInfo
    :ivar estimated_impact: Gets the estimated impact info for this recommended action e.g.,
     Estimated CPU gain, Estimated Disk Space change.
    :vartype estimated_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar observed_impact: Gets the observed/actual impact info for this recommended action e.g.,
     Actual CPU gain, Actual Disk Space change.
    :vartype observed_impact: list[~azure.mgmt.sql.models.RecommendedActionImpactRecord]
    :ivar time_series: Gets the time series info of metrics for this recommended action e.g., CPU
     consumption time series.
    :vartype time_series: list[~azure.mgmt.sql.models.RecommendedActionMetricInfo]
    :ivar linked_objects: Gets the linked objects, if any.
    :vartype linked_objects: list[str]
    :ivar details: Gets additional details specific to this recommended action.
    :vartype details: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "location": {"readonly": True},
        "recommendation_reason": {"readonly": True},
        "valid_since": {"readonly": True},
        "last_refresh": {"readonly": True},
        "is_executable_action": {"readonly": True},
        "is_revertable_action": {"readonly": True},
        "is_archived_action": {"readonly": True},
        "execute_action_start_time": {"readonly": True},
        "execute_action_duration": {"readonly": True},
        "revert_action_start_time": {"readonly": True},
        "revert_action_duration": {"readonly": True},
        "execute_action_initiated_by": {"readonly": True},
        "execute_action_initiated_time": {"readonly": True},
        "revert_action_initiated_by": {"readonly": True},
        "revert_action_initiated_time": {"readonly": True},
        "score": {"readonly": True},
        "implementation_details": {"readonly": True},
        "error_details": {"readonly": True},
        "estimated_impact": {"readonly": True},
        "observed_impact": {"readonly": True},
        "time_series": {"readonly": True},
        "linked_objects": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "recommendation_reason": {"key": "properties.recommendationReason", "type": "str"},
        "valid_since": {"key": "properties.validSince", "type": "iso-8601"},
        "last_refresh": {"key": "properties.lastRefresh", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "RecommendedActionStateInfo"},
        "is_executable_action": {"key": "properties.isExecutableAction", "type": "bool"},
        "is_revertable_action": {"key": "properties.isRevertableAction", "type": "bool"},
        "is_archived_action": {"key": "properties.isArchivedAction", "type": "bool"},
        "execute_action_start_time": {"key": "properties.executeActionStartTime", "type": "iso-8601"},
        "execute_action_duration": {"key": "properties.executeActionDuration", "type": "duration"},
        "revert_action_start_time": {"key": "properties.revertActionStartTime", "type": "iso-8601"},
        "revert_action_duration": {"key": "properties.revertActionDuration", "type": "duration"},
        "execute_action_initiated_by": {"key": "properties.executeActionInitiatedBy", "type": "str"},
        "execute_action_initiated_time": {"key": "properties.executeActionInitiatedTime", "type": "iso-8601"},
        "revert_action_initiated_by": {"key": "properties.revertActionInitiatedBy", "type": "str"},
        "revert_action_initiated_time": {"key": "properties.revertActionInitiatedTime", "type": "iso-8601"},
        "score": {"key": "properties.score", "type": "int"},
        "implementation_details": {
            "key": "properties.implementationDetails",
            "type": "RecommendedActionImplementationInfo",
        },
        "error_details": {"key": "properties.errorDetails", "type": "RecommendedActionErrorInfo"},
        "estimated_impact": {"key": "properties.estimatedImpact", "type": "[RecommendedActionImpactRecord]"},
        "observed_impact": {"key": "properties.observedImpact", "type": "[RecommendedActionImpactRecord]"},
        "time_series": {"key": "properties.timeSeries", "type": "[RecommendedActionMetricInfo]"},
        "linked_objects": {"key": "properties.linkedObjects", "type": "[str]"},
        "details": {"key": "properties.details", "type": "{str}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self, *, state: Optional["_models.RecommendedActionStateInfo"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Gets the info of the current state the recommended action is in.
        :paramtype state: ~azure.mgmt.sql.models.RecommendedActionStateInfo
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.location: Optional[str] = None
        self.recommendation_reason: Optional[str] = None
        self.valid_since: Optional[datetime.datetime] = None
        self.last_refresh: Optional[datetime.datetime] = None
        self.state = state
        self.is_executable_action: Optional[bool] = None
        self.is_revertable_action: Optional[bool] = None
        self.is_archived_action: Optional[bool] = None
        self.execute_action_start_time: Optional[datetime.datetime] = None
        self.execute_action_duration: Optional[datetime.timedelta] = None
        self.revert_action_start_time: Optional[datetime.datetime] = None
        self.revert_action_duration: Optional[datetime.timedelta] = None
        self.execute_action_initiated_by: Optional[Union[str, "_models.RecommendedActionInitiatedBy"]] = None
        self.execute_action_initiated_time: Optional[datetime.datetime] = None
        self.revert_action_initiated_by: Optional[Union[str, "_models.RecommendedActionInitiatedBy"]] = None
        self.revert_action_initiated_time: Optional[datetime.datetime] = None
        self.score: Optional[int] = None
        self.implementation_details: Optional["_models.RecommendedActionImplementationInfo"] = None
        self.error_details: Optional["_models.RecommendedActionErrorInfo"] = None
        self.estimated_impact: Optional[List["_models.RecommendedActionImpactRecord"]] = None
        self.observed_impact: Optional[List["_models.RecommendedActionImpactRecord"]] = None
        self.time_series: Optional[List["_models.RecommendedActionMetricInfo"]] = None
        self.linked_objects: Optional[List[str]] = None
        self.details: Optional[Dict[str, str]] = None


class RecommendedActionErrorInfo(_serialization.Model):
    """Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended
    Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Gets the reason why the recommended action was put to error state. e.g.,
     DatabaseHasQdsOff, IndexAlreadyExists.
    :vartype error_code: str
    :ivar is_retryable: Gets whether the error could be ignored and recommended action could be
     retried. Possible values are: Yes/No. Known values are: "Yes" and "No".
    :vartype is_retryable: str or ~azure.mgmt.sql.models.IsRetryable
    """

    _validation = {
        "error_code": {"readonly": True},
        "is_retryable": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "is_retryable": {"key": "isRetryable", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_code: Optional[str] = None
        self.is_retryable: Optional[Union[str, "_models.IsRetryable"]] = None


class RecommendedActionImpactRecord(_serialization.Model):
    """Contains information of estimated or observed impact on various metrics for an Azure SQL
    Database, Server or Elastic Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar dimension_name: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     NumberOfQueriesAffected.
    :vartype dimension_name: str
    :ivar unit: Gets the name of the impact dimension. e.g., CPUChange, DiskSpaceChange,
     NumberOfQueriesAffected.
    :vartype unit: str
    :ivar absolute_value: Gets the absolute value of this dimension if applicable. e.g., Number of
     Queries affected.
    :vartype absolute_value: float
    :ivar change_value_absolute: Gets the absolute change in the value of this dimension. e.g.,
     Absolute Disk space change in Megabytes.
    :vartype change_value_absolute: float
    :ivar change_value_relative: Gets the relative change in the value of this dimension. e.g.,
     Relative Disk space change in Percentage.
    :vartype change_value_relative: float
    """

    _validation = {
        "dimension_name": {"readonly": True},
        "unit": {"readonly": True},
        "absolute_value": {"readonly": True},
        "change_value_absolute": {"readonly": True},
        "change_value_relative": {"readonly": True},
    }

    _attribute_map = {
        "dimension_name": {"key": "dimensionName", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "absolute_value": {"key": "absoluteValue", "type": "float"},
        "change_value_absolute": {"key": "changeValueAbsolute", "type": "float"},
        "change_value_relative": {"key": "changeValueRelative", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.dimension_name: Optional[str] = None
        self.unit: Optional[str] = None
        self.absolute_value: Optional[float] = None
        self.change_value_absolute: Optional[float] = None
        self.change_value_relative: Optional[float] = None


class RecommendedActionImplementationInfo(_serialization.Model):
    """Contains information for manual implementation for an Azure SQL Database, Server or Elastic
    Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar method: Gets the method in which this recommended action can be manually implemented.
     e.g., TSql, AzurePowerShell. Known values are: "TSql" and "AzurePowerShell".
    :vartype method: str or ~azure.mgmt.sql.models.ImplementationMethod
    :ivar script: Gets the manual implementation script. e.g., T-SQL script that could be executed
     on the database.
    :vartype script: str
    """

    _validation = {
        "method": {"readonly": True},
        "script": {"readonly": True},
    }

    _attribute_map = {
        "method": {"key": "method", "type": "str"},
        "script": {"key": "script", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.method: Optional[Union[str, "_models.ImplementationMethod"]] = None
        self.script: Optional[str] = None


class RecommendedActionMetricInfo(_serialization.Model):
    """Contains time series of various impacted metrics for an Azure SQL Database, Server or Elastic
    Pool Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar metric_name: Gets the name of the metric. e.g., CPU, Number of Queries.
    :vartype metric_name: str
    :ivar unit: Gets the unit in which metric is measured. e.g., DTU, Frequency.
    :vartype unit: str
    :ivar time_grain: Gets the duration of time interval for the value given by this MetricInfo.
     e.g., PT1H (1 hour).
    :vartype time_grain: str
    :ivar start_time: Gets the start time of time interval given by this MetricInfo.
    :vartype start_time: ~datetime.datetime
    :ivar value: Gets the value of the metric in the time interval given by this MetricInfo.
    :vartype value: float
    """

    _validation = {
        "metric_name": {"readonly": True},
        "unit": {"readonly": True},
        "time_grain": {"readonly": True},
        "start_time": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "metric_name": {"key": "metricName", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "time_grain": {"key": "timeGrain", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "value": {"key": "value", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.metric_name: Optional[str] = None
        self.unit: Optional[str] = None
        self.time_grain: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.value: Optional[float] = None


class RecommendedActionStateInfo(_serialization.Model):
    """Contains information of current state for an Azure SQL Database, Server or Elastic Pool
    Recommended Action.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar current_value: Current state the recommended action is in. Some commonly used states are:
     Active      -> recommended action is active and no action has been taken yet. Pending     ->
     recommended action is approved for and is awaiting execution. Executing   -> recommended action
     is being applied on the user database. Verifying   -> recommended action was applied and is
     being verified of its usefulness by the system. Success     -> recommended action was applied
     and improvement found during verification. Pending Revert  -> verification found little or no
     improvement so recommended action is queued for revert or user has manually reverted. Reverting
     -> changes made while applying recommended action are being reverted on the user database.
     Reverted    -> successfully reverted the changes made by recommended action on user database.
     Ignored     -> user explicitly ignored/discarded the recommended action. Required. Known values
     are: "Active", "Pending", "Executing", "Verifying", "PendingRevert", "RevertCancelled",
     "Reverting", "Reverted", "Ignored", "Expired", "Monitoring", "Resolved", "Success", and
     "Error".
    :vartype current_value: str or ~azure.mgmt.sql.models.RecommendedActionCurrentState
    :ivar action_initiated_by: Gets who initiated the execution of this recommended action.
     Possible Value are: User    -> When user explicity notified system to apply the recommended
     action. System  -> When auto-execute status of this advisor was set to 'Enabled', in which case
     the system applied it. Known values are: "User" and "System".
    :vartype action_initiated_by: str or ~azure.mgmt.sql.models.RecommendedActionInitiatedBy
    :ivar last_modified: Gets the time when the state was last modified.
    :vartype last_modified: ~datetime.datetime
    """

    _validation = {
        "current_value": {"required": True},
        "action_initiated_by": {"readonly": True},
        "last_modified": {"readonly": True},
    }

    _attribute_map = {
        "current_value": {"key": "currentValue", "type": "str"},
        "action_initiated_by": {"key": "actionInitiatedBy", "type": "str"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
    }

    def __init__(self, *, current_value: Union[str, "_models.RecommendedActionCurrentState"], **kwargs: Any) -> None:
        """
        :keyword current_value: Current state the recommended action is in. Some commonly used states
         are: Active      -> recommended action is active and no action has been taken yet. Pending
         -> recommended action is approved for and is awaiting execution. Executing   -> recommended
         action is being applied on the user database. Verifying   -> recommended action was applied and
         is being verified of its usefulness by the system. Success     -> recommended action was
         applied and improvement found during verification. Pending Revert  -> verification found little
         or no improvement so recommended action is queued for revert or user has manually reverted.
         Reverting   -> changes made while applying recommended action are being reverted on the user
         database. Reverted    -> successfully reverted the changes made by recommended action on user
         database. Ignored     -> user explicitly ignored/discarded the recommended action. Required.
         Known values are: "Active", "Pending", "Executing", "Verifying", "PendingRevert",
         "RevertCancelled", "Reverting", "Reverted", "Ignored", "Expired", "Monitoring", "Resolved",
         "Success", and "Error".
        :paramtype current_value: str or ~azure.mgmt.sql.models.RecommendedActionCurrentState
        """
        super().__init__(**kwargs)
        self.current_value = current_value
        self.action_initiated_by: Optional[Union[str, "_models.RecommendedActionInitiatedBy"]] = None
        self.last_modified: Optional[datetime.datetime] = None


class RecommendedSensitivityLabelUpdate(ProxyResource):
    """A recommended sensitivity label update operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar op: Known values are: "enable" and "disable".
    :vartype op: str or ~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdateKind
    :ivar schema: Schema name of the column to update.
    :vartype schema: str
    :ivar table: Table name of the column to update.
    :vartype table: str
    :ivar column: Column name to update.
    :vartype column: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "op": {"key": "properties.op", "type": "str"},
        "schema": {"key": "properties.schema", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "column": {"key": "properties.column", "type": "str"},
    }

    def __init__(
        self,
        *,
        op: Optional[Union[str, "_models.RecommendedSensitivityLabelUpdateKind"]] = None,
        schema: Optional[str] = None,
        table: Optional[str] = None,
        column: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword op: Known values are: "enable" and "disable".
        :paramtype op: str or ~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdateKind
        :keyword schema: Schema name of the column to update.
        :paramtype schema: str
        :keyword table: Table name of the column to update.
        :paramtype table: str
        :keyword column: Column name to update.
        :paramtype column: str
        """
        super().__init__(**kwargs)
        self.op = op
        self.schema = schema
        self.table = table
        self.column = column


class RecommendedSensitivityLabelUpdateList(_serialization.Model):
    """A list of recommended sensitivity label update operations.

    :ivar operations:
    :vartype operations: list[~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdate]
    """

    _attribute_map = {
        "operations": {"key": "operations", "type": "[RecommendedSensitivityLabelUpdate]"},
    }

    def __init__(
        self, *, operations: Optional[List["_models.RecommendedSensitivityLabelUpdate"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword operations:
        :paramtype operations: list[~azure.mgmt.sql.models.RecommendedSensitivityLabelUpdate]
        """
        super().__init__(**kwargs)
        self.operations = operations


class RecoverableDatabase(ProxyResource):
    """A recoverable database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar edition: The edition of the database.
    :vartype edition: str
    :ivar service_level_objective: The service level objective name of the database.
    :vartype service_level_objective: str
    :ivar elastic_pool_name: The elastic pool name of the database.
    :vartype elastic_pool_name: str
    :ivar last_available_backup_date: The last available backup date.
    :vartype last_available_backup_date: ~datetime.datetime
    :ivar keys: The resource ids of the user assigned identities to use.
    :vartype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "edition": {"readonly": True},
        "service_level_objective": {"readonly": True},
        "elastic_pool_name": {"readonly": True},
        "last_available_backup_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "edition": {"key": "properties.edition", "type": "str"},
        "service_level_objective": {"key": "properties.serviceLevelObjective", "type": "str"},
        "elastic_pool_name": {"key": "properties.elasticPoolName", "type": "str"},
        "last_available_backup_date": {"key": "properties.lastAvailableBackupDate", "type": "iso-8601"},
        "keys": {"key": "properties.keys", "type": "{DatabaseKey}"},
    }

    def __init__(self, *, keys: Optional[Dict[str, "_models.DatabaseKey"]] = None, **kwargs: Any) -> None:
        """
        :keyword keys: The resource ids of the user assigned identities to use.
        :paramtype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
        """
        super().__init__(**kwargs)
        self.edition: Optional[str] = None
        self.service_level_objective: Optional[str] = None
        self.elastic_pool_name: Optional[str] = None
        self.last_available_backup_date: Optional[datetime.datetime] = None
        self.keys = keys


class RecoverableDatabaseListResult(_serialization.Model):
    """A list of recoverable databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RecoverableDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RecoverableDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RecoverableDatabase"]] = None
        self.next_link: Optional[str] = None


class RecoverableManagedDatabase(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar last_available_backup_date: The last available backup date.
    :vartype last_available_backup_date: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_available_backup_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "last_available_backup_date": {"key": "properties.lastAvailableBackupDate", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.last_available_backup_date: Optional[str] = None


class RecoverableManagedDatabaseListResult(_serialization.Model):
    """A list of recoverable managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RecoverableManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RecoverableManagedDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RecoverableManagedDatabase"]] = None
        self.next_link: Optional[str] = None


class RefreshExternalGovernanceStatusOperationResult(ProxyResource):  # pylint: disable=name-too-long
    """An RefreshExternalGovernanceStatus operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar server_name: Server name.
    :vartype server_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "request_id": {"readonly": True},
        "request_type": {"readonly": True},
        "queued_time": {"readonly": True},
        "server_name": {"readonly": True},
        "status": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "request_id": {"key": "properties.requestId", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "queued_time": {"key": "properties.queuedTime", "type": "str"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.request_id: Optional[str] = None
        self.request_type: Optional[str] = None
        self.queued_time: Optional[str] = None
        self.server_name: Optional[str] = None
        self.status: Optional[str] = None
        self.error_message: Optional[str] = None


class RefreshExternalGovernanceStatusOperationResultMI(ProxyResource):  # pylint: disable=name-too-long
    """An RefreshExternalGovernanceStatus operation result resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar request_id: Request Id.
    :vartype request_id: str
    :ivar request_type: Request type.
    :vartype request_type: str
    :ivar queued_time: Queued time.
    :vartype queued_time: str
    :ivar managed_instance_name: Managed instance name.
    :vartype managed_instance_name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar error_message: Error message.
    :vartype error_message: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "request_id": {"readonly": True},
        "request_type": {"readonly": True},
        "queued_time": {"readonly": True},
        "managed_instance_name": {"readonly": True},
        "status": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "request_id": {"key": "properties.requestId", "type": "str"},
        "request_type": {"key": "properties.requestType", "type": "str"},
        "queued_time": {"key": "properties.queuedTime", "type": "str"},
        "managed_instance_name": {"key": "properties.managedInstanceName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.request_id: Optional[str] = None
        self.request_type: Optional[str] = None
        self.queued_time: Optional[str] = None
        self.managed_instance_name: Optional[str] = None
        self.status: Optional[str] = None
        self.error_message: Optional[str] = None


class Remediation(_serialization.Model):
    """SQL Vulnerability Assessment remediation Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar description: SQL Vulnerability Assessment remediation description.
    :vartype description: str
    :ivar scripts: SQL Vulnerability Assessment remediation script.
    :vartype scripts: list[str]
    :ivar automated: SQL Vulnerability Assessment is remediation automated.
    :vartype automated: bool
    :ivar portal_link: SQL Vulnerability Assessment optional link to remediate in Azure Portal.
    :vartype portal_link: str
    """

    _validation = {
        "description": {"readonly": True},
        "scripts": {"readonly": True},
        "automated": {"readonly": True},
        "portal_link": {"readonly": True},
    }

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "scripts": {"key": "scripts", "type": "[str]"},
        "automated": {"key": "automated", "type": "bool"},
        "portal_link": {"key": "portalLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.description: Optional[str] = None
        self.scripts: Optional[List[str]] = None
        self.automated: Optional[bool] = None
        self.portal_link: Optional[str] = None


class ReplicationLink(ProxyResource):
    """A replication link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar partner_server: Resource partner server.
    :vartype partner_server: str
    :ivar partner_database: Resource partner database.
    :vartype partner_database: str
    :ivar partner_database_id: Resource partner database Id.
    :vartype partner_database_id: str
    :ivar partner_location: Resource partner location.
    :vartype partner_location: str
    :ivar role: Local replication role. Known values are: "Primary", "Secondary",
     "NonReadableSecondary", "Source", and "Copy".
    :vartype role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar partner_role: Partner replication role. Known values are: "Primary", "Secondary",
     "NonReadableSecondary", "Source", and "Copy".
    :vartype partner_role: str or ~azure.mgmt.sql.models.ReplicationRole
    :ivar replication_mode: Replication mode.
    :vartype replication_mode: str
    :ivar start_time: Time at which the link was created.
    :vartype start_time: ~datetime.datetime
    :ivar percent_complete: Seeding completion percentage for the link.
    :vartype percent_complete: int
    :ivar replication_state: Replication state (PENDING, SEEDING, CATCHUP, SUSPENDED). Known values
     are: "PENDING", "SEEDING", "CATCH_UP", and "SUSPENDED".
    :vartype replication_state: str or ~azure.mgmt.sql.models.ReplicationState
    :ivar is_termination_allowed: Whether the user is currently allowed to terminate the link.
    :vartype is_termination_allowed: bool
    :ivar link_type: Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     Known values are: "GEO", "NAMED", and "STANDBY".
    :vartype link_type: str or ~azure.mgmt.sql.models.ReplicationLinkType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "partner_server": {"readonly": True},
        "partner_database": {"readonly": True},
        "partner_database_id": {"readonly": True},
        "partner_location": {"readonly": True},
        "role": {"readonly": True},
        "partner_role": {"readonly": True},
        "replication_mode": {"readonly": True},
        "start_time": {"readonly": True},
        "percent_complete": {"readonly": True},
        "replication_state": {"readonly": True},
        "is_termination_allowed": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "partner_server": {"key": "properties.partnerServer", "type": "str"},
        "partner_database": {"key": "properties.partnerDatabase", "type": "str"},
        "partner_database_id": {"key": "properties.partnerDatabaseId", "type": "str"},
        "partner_location": {"key": "properties.partnerLocation", "type": "str"},
        "role": {"key": "properties.role", "type": "str"},
        "partner_role": {"key": "properties.partnerRole", "type": "str"},
        "replication_mode": {"key": "properties.replicationMode", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "replication_state": {"key": "properties.replicationState", "type": "str"},
        "is_termination_allowed": {"key": "properties.isTerminationAllowed", "type": "bool"},
        "link_type": {"key": "properties.linkType", "type": "str"},
    }

    def __init__(self, *, link_type: Optional[Union[str, "_models.ReplicationLinkType"]] = None, **kwargs: Any) -> None:
        """
        :keyword link_type: Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
         Known values are: "GEO", "NAMED", and "STANDBY".
        :paramtype link_type: str or ~azure.mgmt.sql.models.ReplicationLinkType
        """
        super().__init__(**kwargs)
        self.partner_server: Optional[str] = None
        self.partner_database: Optional[str] = None
        self.partner_database_id: Optional[str] = None
        self.partner_location: Optional[str] = None
        self.role: Optional[Union[str, "_models.ReplicationRole"]] = None
        self.partner_role: Optional[Union[str, "_models.ReplicationRole"]] = None
        self.replication_mode: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.percent_complete: Optional[int] = None
        self.replication_state: Optional[Union[str, "_models.ReplicationState"]] = None
        self.is_termination_allowed: Optional[bool] = None
        self.link_type = link_type


class ReplicationLinkListResult(_serialization.Model):
    """A list of replication links.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ReplicationLink]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ReplicationLink]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ReplicationLink"]] = None
        self.next_link: Optional[str] = None


class ReplicationLinkUpdate(ProxyResource):
    """A replication link update request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar link_type: Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
     Known values are: "GEO", "NAMED", and "STANDBY".
    :vartype link_type: str or ~azure.mgmt.sql.models.ReplicationLinkType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "link_type": {"key": "properties.linkType", "type": "str"},
    }

    def __init__(self, *, link_type: Optional[Union[str, "_models.ReplicationLinkType"]] = None, **kwargs: Any) -> None:
        """
        :keyword link_type: Link type (GEO, NAMED, STANDBY). Update operation does not support NAMED.
         Known values are: "GEO", "NAMED", and "STANDBY".
        :paramtype link_type: str or ~azure.mgmt.sql.models.ReplicationLinkType
        """
        super().__init__(**kwargs)
        self.link_type = link_type


class ResourceIdentity(_serialization.Model):
    """Azure Active Directory identity configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_assigned_identities: The resource ids of the user assigned identities to use.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.sql.models.UserIdentity]
    :ivar principal_id: The Azure Active Directory principal id.
    :vartype principal_id: str
    :ivar type: The identity type. Set this to 'SystemAssigned' in order to automatically create
     and assign an Azure Active Directory principal for the resource. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.sql.models.IdentityType
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentity}"},
        "principal_id": {"key": "principalId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentity"]] = None,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword user_assigned_identities: The resource ids of the user assigned identities to use.
        :paramtype user_assigned_identities: dict[str, ~azure.mgmt.sql.models.UserIdentity]
        :keyword type: The identity type. Set this to 'SystemAssigned' in order to automatically create
         and assign an Azure Active Directory principal for the resource. Known values are: "None",
         "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.sql.models.IdentityType
        """
        super().__init__(**kwargs)
        self.user_assigned_identities = user_assigned_identities
        self.principal_id: Optional[str] = None
        self.type = type
        self.tenant_id: Optional[str] = None


class ResourceMoveDefinition(_serialization.Model):
    """Contains the information necessary to perform a resource move (rename).

    All required parameters must be populated in order to send to server.

    :ivar id: The target ID for the resource. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The target ID for the resource. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class RestorableDroppedDatabase(ProxyResource):
    """A restorable dropped database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: The name and tier of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar max_size_bytes: The max size of the database expressed in bytes.
    :vartype max_size_bytes: int
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: ~datetime.datetime
    :ivar earliest_restore_date: The earliest restore date of the database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar backup_storage_redundancy: The storage account type used to store backups for this
     database. Known values are: "Geo", "Local", "Zone", and "GeoZone".
    :vartype backup_storage_redundancy: str or ~azure.mgmt.sql.models.BackupStorageRedundancy
    :ivar keys: The resource ids of the user assigned identities to use.
    :vartype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "database_name": {"readonly": True},
        "max_size_bytes": {"readonly": True},
        "creation_date": {"readonly": True},
        "deletion_date": {"readonly": True},
        "earliest_restore_date": {"readonly": True},
        "backup_storage_redundancy": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "max_size_bytes": {"key": "properties.maxSizeBytes", "type": "int"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "deletion_date": {"key": "properties.deletionDate", "type": "iso-8601"},
        "earliest_restore_date": {"key": "properties.earliestRestoreDate", "type": "iso-8601"},
        "backup_storage_redundancy": {"key": "properties.backupStorageRedundancy", "type": "str"},
        "keys": {"key": "properties.keys", "type": "{DatabaseKey}"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        keys: Optional[Dict[str, "_models.DatabaseKey"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The name and tier of the SKU.
        :paramtype sku: ~azure.mgmt.sql.models.Sku
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword keys: The resource ids of the user assigned identities to use.
        :paramtype keys: dict[str, ~azure.mgmt.sql.models.DatabaseKey]
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.location = location
        self.tags = tags
        self.database_name: Optional[str] = None
        self.max_size_bytes: Optional[int] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.deletion_date: Optional[datetime.datetime] = None
        self.earliest_restore_date: Optional[datetime.datetime] = None
        self.backup_storage_redundancy: Optional[Union[str, "_models.BackupStorageRedundancy"]] = None
        self.keys = keys


class RestorableDroppedDatabaseListResult(_serialization.Model):
    """A list of restorable dropped databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorableDroppedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableDroppedDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RestorableDroppedDatabase"]] = None
        self.next_link: Optional[str] = None


class RestorableDroppedManagedDatabase(TrackedResource):
    """A restorable dropped managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar database_name: The name of the database.
    :vartype database_name: str
    :ivar creation_date: The creation date of the database (ISO8601 format).
    :vartype creation_date: ~datetime.datetime
    :ivar deletion_date: The deletion date of the database (ISO8601 format).
    :vartype deletion_date: ~datetime.datetime
    :ivar earliest_restore_date: The earliest restore date of the database (ISO8601 format).
    :vartype earliest_restore_date: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "database_name": {"readonly": True},
        "creation_date": {"readonly": True},
        "deletion_date": {"readonly": True},
        "earliest_restore_date": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "deletion_date": {"key": "properties.deletionDate", "type": "iso-8601"},
        "earliest_restore_date": {"key": "properties.earliestRestoreDate", "type": "iso-8601"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.database_name: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.deletion_date: Optional[datetime.datetime] = None
        self.earliest_restore_date: Optional[datetime.datetime] = None


class RestorableDroppedManagedDatabaseListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of restorable dropped managed databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorableDroppedManagedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorableDroppedManagedDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RestorableDroppedManagedDatabase"]] = None
        self.next_link: Optional[str] = None


class RestorePoint(ProxyResource):
    """Database restore points.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar restore_point_type: The type of restore point. Known values are: "CONTINUOUS" and
     "DISCRETE".
    :vartype restore_point_type: str or ~azure.mgmt.sql.models.RestorePointType
    :ivar earliest_restore_date: The earliest time to which this database can be restored.
    :vartype earliest_restore_date: ~datetime.datetime
    :ivar restore_point_creation_date: The time the backup was taken.
    :vartype restore_point_creation_date: ~datetime.datetime
    :ivar restore_point_label: The label of restore point for backup request by user.
    :vartype restore_point_label: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "restore_point_type": {"readonly": True},
        "earliest_restore_date": {"readonly": True},
        "restore_point_creation_date": {"readonly": True},
        "restore_point_label": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "restore_point_type": {"key": "properties.restorePointType", "type": "str"},
        "earliest_restore_date": {"key": "properties.earliestRestoreDate", "type": "iso-8601"},
        "restore_point_creation_date": {"key": "properties.restorePointCreationDate", "type": "iso-8601"},
        "restore_point_label": {"key": "properties.restorePointLabel", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.restore_point_type: Optional[Union[str, "_models.RestorePointType"]] = None
        self.earliest_restore_date: Optional[datetime.datetime] = None
        self.restore_point_creation_date: Optional[datetime.datetime] = None
        self.restore_point_label: Optional[str] = None


class RestorePointListResult(_serialization.Model):
    """A list of long term retention backups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.RestorePoint]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[RestorePoint]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.RestorePoint"]] = None
        self.next_link: Optional[str] = None


class ScheduleItem(_serialization.Model):
    """Schedule info describing when the server should be started or stopped.

    All required parameters must be populated in order to send to server.

    :ivar start_day: Start day. Required. Known values are: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", and "Saturday".
    :vartype start_day: str or ~azure.mgmt.sql.models.DayOfWeek
    :ivar start_time: Start time. Required.
    :vartype start_time: str
    :ivar stop_day: Stop day. Required. Known values are: "Sunday", "Monday", "Tuesday",
     "Wednesday", "Thursday", "Friday", and "Saturday".
    :vartype stop_day: str or ~azure.mgmt.sql.models.DayOfWeek
    :ivar stop_time: Stop time. Required.
    :vartype stop_time: str
    """

    _validation = {
        "start_day": {"required": True},
        "start_time": {"required": True},
        "stop_day": {"required": True},
        "stop_time": {"required": True},
    }

    _attribute_map = {
        "start_day": {"key": "startDay", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
        "stop_day": {"key": "stopDay", "type": "str"},
        "stop_time": {"key": "stopTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        start_day: Union[str, "_models.DayOfWeek"],
        start_time: str,
        stop_day: Union[str, "_models.DayOfWeek"],
        stop_time: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_day: Start day. Required. Known values are: "Sunday", "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", and "Saturday".
        :paramtype start_day: str or ~azure.mgmt.sql.models.DayOfWeek
        :keyword start_time: Start time. Required.
        :paramtype start_time: str
        :keyword stop_day: Stop day. Required. Known values are: "Sunday", "Monday", "Tuesday",
         "Wednesday", "Thursday", "Friday", and "Saturday".
        :paramtype stop_day: str or ~azure.mgmt.sql.models.DayOfWeek
        :keyword stop_time: Stop time. Required.
        :paramtype stop_time: str
        """
        super().__init__(**kwargs)
        self.start_day = start_day
        self.start_time = start_time
        self.stop_day = stop_day
        self.stop_time = stop_time


class SecurityEvent(ProxyResource):
    """A security event.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar event_time: The time when the security event occurred.
    :vartype event_time: ~datetime.datetime
    :ivar security_event_type: The type of the security event. Known values are: "Undefined",
     "SqlInjectionVulnerability", and "SqlInjectionExploit".
    :vartype security_event_type: str or ~azure.mgmt.sql.models.SecurityEventType
    :ivar subscription: The subscription name.
    :vartype subscription: str
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar client_ip: The IP address of the client who executed the statement.
    :vartype client_ip: str
    :ivar application_name: The application used to execute the statement.
    :vartype application_name: str
    :ivar principal_name: The principal user who executed the statement.
    :vartype principal_name: str
    :ivar security_event_sql_injection_additional_properties: The sql injection additional
     properties, populated only if the type of the security event is sql injection.
    :vartype security_event_sql_injection_additional_properties:
     ~azure.mgmt.sql.models.SecurityEventSqlInjectionAdditionalProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "event_time": {"readonly": True},
        "security_event_type": {"readonly": True},
        "subscription": {"readonly": True},
        "server": {"readonly": True},
        "database": {"readonly": True},
        "client_ip": {"readonly": True},
        "application_name": {"readonly": True},
        "principal_name": {"readonly": True},
        "security_event_sql_injection_additional_properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "event_time": {"key": "properties.eventTime", "type": "iso-8601"},
        "security_event_type": {"key": "properties.securityEventType", "type": "str"},
        "subscription": {"key": "properties.subscription", "type": "str"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "client_ip": {"key": "properties.clientIp", "type": "str"},
        "application_name": {"key": "properties.applicationName", "type": "str"},
        "principal_name": {"key": "properties.principalName", "type": "str"},
        "security_event_sql_injection_additional_properties": {
            "key": "properties.securityEventSqlInjectionAdditionalProperties",
            "type": "SecurityEventSqlInjectionAdditionalProperties",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.event_time: Optional[datetime.datetime] = None
        self.security_event_type: Optional[Union[str, "_models.SecurityEventType"]] = None
        self.subscription: Optional[str] = None
        self.server: Optional[str] = None
        self.database: Optional[str] = None
        self.client_ip: Optional[str] = None
        self.application_name: Optional[str] = None
        self.principal_name: Optional[str] = None
        self.security_event_sql_injection_additional_properties: Optional[
            "_models.SecurityEventSqlInjectionAdditionalProperties"
        ] = None


class SecurityEventCollection(_serialization.Model):
    """A list of security events.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SecurityEvent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityEvent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SecurityEvent"]] = None
        self.next_link: Optional[str] = None


class SecurityEventsFilterParameters(_serialization.Model):
    """The properties that are supported in the $filter operation.

    :ivar event_time: Filter on the event time.
    :vartype event_time: ~datetime.datetime
    :ivar show_server_records: Whether to show server records or not.
    :vartype show_server_records: bool
    """

    _attribute_map = {
        "event_time": {"key": "eventTime", "type": "iso-8601"},
        "show_server_records": {"key": "showServerRecords", "type": "bool"},
    }

    def __init__(
        self,
        *,
        event_time: Optional[datetime.datetime] = None,
        show_server_records: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword event_time: Filter on the event time.
        :paramtype event_time: ~datetime.datetime
        :keyword show_server_records: Whether to show server records or not.
        :paramtype show_server_records: bool
        """
        super().__init__(**kwargs)
        self.event_time = event_time
        self.show_server_records = show_server_records


class SecurityEventSqlInjectionAdditionalProperties(_serialization.Model):  # pylint: disable=name-too-long
    """The properties of a security event sql injection additional properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar threat_id: The threat ID.
    :vartype threat_id: str
    :ivar statement: The statement.
    :vartype statement: str
    :ivar statement_highlight_offset: The statement highlight offset.
    :vartype statement_highlight_offset: int
    :ivar statement_highlight_length: The statement highlight length.
    :vartype statement_highlight_length: int
    :ivar error_code: The sql error code.
    :vartype error_code: int
    :ivar error_severity: The sql error severity.
    :vartype error_severity: int
    :ivar error_message: The sql error message.
    :vartype error_message: str
    """

    _validation = {
        "threat_id": {"readonly": True},
        "statement": {"readonly": True},
        "statement_highlight_offset": {"readonly": True},
        "statement_highlight_length": {"readonly": True},
        "error_code": {"readonly": True},
        "error_severity": {"readonly": True},
        "error_message": {"readonly": True},
    }

    _attribute_map = {
        "threat_id": {"key": "threatId", "type": "str"},
        "statement": {"key": "statement", "type": "str"},
        "statement_highlight_offset": {"key": "statementHighlightOffset", "type": "int"},
        "statement_highlight_length": {"key": "statementHighlightLength", "type": "int"},
        "error_code": {"key": "errorCode", "type": "int"},
        "error_severity": {"key": "errorSeverity", "type": "int"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.threat_id: Optional[str] = None
        self.statement: Optional[str] = None
        self.statement_highlight_offset: Optional[int] = None
        self.statement_highlight_length: Optional[int] = None
        self.error_code: Optional[int] = None
        self.error_severity: Optional[int] = None
        self.error_message: Optional[str] = None


class SensitivityLabel(ProxyResource):
    """A sensitivity label.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar managed_by: Resource that manages the sensitivity label.
    :vartype managed_by: str
    :ivar schema_name: The schema name.
    :vartype schema_name: str
    :ivar table_name: The table name.
    :vartype table_name: str
    :ivar column_name: The column name.
    :vartype column_name: str
    :ivar label_name: The label name.
    :vartype label_name: str
    :ivar label_id: The label ID.
    :vartype label_id: str
    :ivar information_type: The information type.
    :vartype information_type: str
    :ivar information_type_id: The information type ID.
    :vartype information_type_id: str
    :ivar is_disabled: Is sensitivity recommendation disabled. Applicable for recommended
     sensitivity label only. Specifies whether the sensitivity recommendation on this column is
     disabled (dismissed) or not.
    :vartype is_disabled: bool
    :ivar rank: Known values are: "None", "Low", "Medium", "High", and "Critical".
    :vartype rank: str or ~azure.mgmt.sql.models.SensitivityLabelRank
    :ivar client_classification_source: Known values are: "None", "Native", "Recommended", and
     "MIP".
    :vartype client_classification_source: str or ~azure.mgmt.sql.models.ClientClassificationSource
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "managed_by": {"readonly": True},
        "schema_name": {"readonly": True},
        "table_name": {"readonly": True},
        "column_name": {"readonly": True},
        "is_disabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
        "column_name": {"key": "properties.columnName", "type": "str"},
        "label_name": {"key": "properties.labelName", "type": "str"},
        "label_id": {"key": "properties.labelId", "type": "str"},
        "information_type": {"key": "properties.informationType", "type": "str"},
        "information_type_id": {"key": "properties.informationTypeId", "type": "str"},
        "is_disabled": {"key": "properties.isDisabled", "type": "bool"},
        "rank": {"key": "properties.rank", "type": "str"},
        "client_classification_source": {"key": "properties.clientClassificationSource", "type": "str"},
    }

    def __init__(
        self,
        *,
        label_name: Optional[str] = None,
        label_id: Optional[str] = None,
        information_type: Optional[str] = None,
        information_type_id: Optional[str] = None,
        rank: Optional[Union[str, "_models.SensitivityLabelRank"]] = None,
        client_classification_source: Optional[Union[str, "_models.ClientClassificationSource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword label_name: The label name.
        :paramtype label_name: str
        :keyword label_id: The label ID.
        :paramtype label_id: str
        :keyword information_type: The information type.
        :paramtype information_type: str
        :keyword information_type_id: The information type ID.
        :paramtype information_type_id: str
        :keyword rank: Known values are: "None", "Low", "Medium", "High", and "Critical".
        :paramtype rank: str or ~azure.mgmt.sql.models.SensitivityLabelRank
        :keyword client_classification_source: Known values are: "None", "Native", "Recommended", and
         "MIP".
        :paramtype client_classification_source: str or
         ~azure.mgmt.sql.models.ClientClassificationSource
        """
        super().__init__(**kwargs)
        self.managed_by: Optional[str] = None
        self.schema_name: Optional[str] = None
        self.table_name: Optional[str] = None
        self.column_name: Optional[str] = None
        self.label_name = label_name
        self.label_id = label_id
        self.information_type = information_type
        self.information_type_id = information_type_id
        self.is_disabled: Optional[bool] = None
        self.rank = rank
        self.client_classification_source = client_classification_source


class SensitivityLabelListResult(_serialization.Model):
    """A list of sensitivity labels.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SensitivityLabel]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SensitivityLabel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SensitivityLabel"]] = None
        self.next_link: Optional[str] = None


class SensitivityLabelUpdate(ProxyResource):
    """A sensitivity label update operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar op: Known values are: "set" and "remove".
    :vartype op: str or ~azure.mgmt.sql.models.SensitivityLabelUpdateKind
    :ivar schema: Schema name of the column to update.
    :vartype schema: str
    :ivar table: Table name of the column to update.
    :vartype table: str
    :ivar column: Column name to update.
    :vartype column: str
    :ivar sensitivity_label: The sensitivity label information to apply on a column.
    :vartype sensitivity_label: ~azure.mgmt.sql.models.SensitivityLabel
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "op": {"key": "properties.op", "type": "str"},
        "schema": {"key": "properties.schema", "type": "str"},
        "table": {"key": "properties.table", "type": "str"},
        "column": {"key": "properties.column", "type": "str"},
        "sensitivity_label": {"key": "properties.sensitivityLabel", "type": "SensitivityLabel"},
    }

    def __init__(
        self,
        *,
        op: Optional[Union[str, "_models.SensitivityLabelUpdateKind"]] = None,
        schema: Optional[str] = None,
        table: Optional[str] = None,
        column: Optional[str] = None,
        sensitivity_label: Optional["_models.SensitivityLabel"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword op: Known values are: "set" and "remove".
        :paramtype op: str or ~azure.mgmt.sql.models.SensitivityLabelUpdateKind
        :keyword schema: Schema name of the column to update.
        :paramtype schema: str
        :keyword table: Table name of the column to update.
        :paramtype table: str
        :keyword column: Column name to update.
        :paramtype column: str
        :keyword sensitivity_label: The sensitivity label information to apply on a column.
        :paramtype sensitivity_label: ~azure.mgmt.sql.models.SensitivityLabel
        """
        super().__init__(**kwargs)
        self.op = op
        self.schema = schema
        self.table = table
        self.column = column
        self.sensitivity_label = sensitivity_label


class SensitivityLabelUpdateList(_serialization.Model):
    """A list of sensitivity label update operations.

    :ivar operations:
    :vartype operations: list[~azure.mgmt.sql.models.SensitivityLabelUpdate]
    """

    _attribute_map = {
        "operations": {"key": "operations", "type": "[SensitivityLabelUpdate]"},
    }

    def __init__(self, *, operations: Optional[List["_models.SensitivityLabelUpdate"]] = None, **kwargs: Any) -> None:
        """
        :keyword operations:
        :paramtype operations: list[~azure.mgmt.sql.models.SensitivityLabelUpdate]
        """
        super().__init__(**kwargs)
        self.operations = operations


class Server(TrackedResource):
    """An Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar identity: The Azure Active Directory identity of the server.
    :vartype identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar kind: Kind of sql server. This is metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar administrator_login: Administrator username for the server. Once created it cannot be
     changed.
    :vartype administrator_login: str
    :ivar administrator_login_password: The administrator login password (required for server
     creation).
    :vartype administrator_login_password: str
    :ivar version: The version of the server.
    :vartype version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :ivar minimal_tls_version: Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2',
     '1.3'. Known values are: "None", "1.0", "1.1", "1.2", and "1.3".
    :vartype minimal_tls_version: str or ~azure.mgmt.sql.models.MinimalTlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled' or 'SecuredByPerimeter'.
     Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.sql.models.ServerPublicNetworkAccessFlag
    :ivar workspace_feature: Whether or not existing server has a workspace created and if it
     allows connection from workspace. Known values are: "Connected" and "Disconnected".
    :vartype workspace_feature: str or ~azure.mgmt.sql.models.ServerWorkspaceFeature
    :ivar primary_user_assigned_identity_id: The resource id of a user assigned identity to be used
     by default.
    :vartype primary_user_assigned_identity_id: str
    :ivar federated_client_id: The Client id used for cross tenant CMK scenario.
    :vartype federated_client_id: str
    :ivar key_id: A CMK URI of the key to use for encryption.
    :vartype key_id: str
    :ivar administrators: The Azure Active Directory administrator can be utilized during server
     creation and for server updates, except for the azureADOnlyAuthentication property. To update
     the azureADOnlyAuthentication property, individual API must be used.
    :vartype administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
    :ivar restrict_outbound_network_access: Whether or not to restrict outbound network access for
     this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values
     are: "Enabled" and "Disabled".
    :vartype restrict_outbound_network_access: str or
     ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar is_i_pv6_enabled: Whether or not to enable IPv6 support for this server.  Value is
     optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype is_i_pv6_enabled: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar external_governance_status: Status of external governance. Known values are: "Enabled"
     and "Disabled".
    :vartype external_governance_status: str or ~azure.mgmt.sql.models.ExternalGovernanceStatus
    :ivar retention_days: Number of days this server will stay soft-deleted.
    :vartype retention_days: int
    :ivar create_mode: Create mode for server, only valid values for this are Normal and Restore.
     Known values are: "Normal" and "Restore".
    :vartype create_mode: str or ~azure.mgmt.sql.models.ServerCreateMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "kind": {"readonly": True},
        "state": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "workspace_feature": {"readonly": True},
        "external_governance_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ServerPrivateEndpointConnection]",
        },
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "workspace_feature": {"key": "properties.workspaceFeature", "type": "str"},
        "primary_user_assigned_identity_id": {"key": "properties.primaryUserAssignedIdentityId", "type": "str"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
        "key_id": {"key": "properties.keyId", "type": "str"},
        "administrators": {"key": "properties.administrators", "type": "ServerExternalAdministrator"},
        "restrict_outbound_network_access": {"key": "properties.restrictOutboundNetworkAccess", "type": "str"},
        "is_i_pv6_enabled": {"key": "properties.isIPv6Enabled", "type": "str"},
        "external_governance_status": {"key": "properties.externalGovernanceStatus", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[str] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersion"]] = None,
        public_network_access: Optional[Union[str, "_models.ServerPublicNetworkAccessFlag"]] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        federated_client_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["_models.ServerExternalAdministrator"] = None,
        restrict_outbound_network_access: Optional[Union[str, "_models.ServerNetworkAccessFlag"]] = None,
        is_i_pv6_enabled: Optional[Union[str, "_models.ServerNetworkAccessFlag"]] = None,
        retention_days: Optional[int] = None,
        create_mode: Optional[Union[str, "_models.ServerCreateMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword identity: The Azure Active Directory identity of the server.
        :paramtype identity: ~azure.mgmt.sql.models.ResourceIdentity
        :keyword administrator_login: Administrator username for the server. Once created it cannot be
         changed.
        :paramtype administrator_login: str
        :keyword administrator_login_password: The administrator login password (required for server
         creation).
        :paramtype administrator_login_password: str
        :keyword version: The version of the server.
        :paramtype version: str
        :keyword minimal_tls_version: Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2',
         '1.3'. Known values are: "None", "1.0", "1.1", "1.2", and "1.3".
        :paramtype minimal_tls_version: str or ~azure.mgmt.sql.models.MinimalTlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled' or
         'SecuredByPerimeter'. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.sql.models.ServerPublicNetworkAccessFlag
        :keyword primary_user_assigned_identity_id: The resource id of a user assigned identity to be
         used by default.
        :paramtype primary_user_assigned_identity_id: str
        :keyword federated_client_id: The Client id used for cross tenant CMK scenario.
        :paramtype federated_client_id: str
        :keyword key_id: A CMK URI of the key to use for encryption.
        :paramtype key_id: str
        :keyword administrators: The Azure Active Directory administrator can be utilized during server
         creation and for server updates, except for the azureADOnlyAuthentication property. To update
         the azureADOnlyAuthentication property, individual API must be used.
        :paramtype administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
        :keyword restrict_outbound_network_access: Whether or not to restrict outbound network access
         for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known
         values are: "Enabled" and "Disabled".
        :paramtype restrict_outbound_network_access: str or
         ~azure.mgmt.sql.models.ServerNetworkAccessFlag
        :keyword is_i_pv6_enabled: Whether or not to enable IPv6 support for this server.  Value is
         optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
         "Disabled".
        :paramtype is_i_pv6_enabled: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
        :keyword retention_days: Number of days this server will stay soft-deleted.
        :paramtype retention_days: int
        :keyword create_mode: Create mode for server, only valid values for this are Normal and
         Restore. Known values are: "Normal" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.ServerCreateMode
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.kind: Optional[str] = None
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.state: Optional[str] = None
        self.fully_qualified_domain_name: Optional[str] = None
        self.private_endpoint_connections: Optional[List["_models.ServerPrivateEndpointConnection"]] = None
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.workspace_feature: Optional[Union[str, "_models.ServerWorkspaceFeature"]] = None
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.federated_client_id = federated_client_id
        self.key_id = key_id
        self.administrators = administrators
        self.restrict_outbound_network_access = restrict_outbound_network_access
        self.is_i_pv6_enabled = is_i_pv6_enabled
        self.external_governance_status: Optional[Union[str, "_models.ExternalGovernanceStatus"]] = None
        self.retention_days = retention_days
        self.create_mode = create_mode


class ServerAdvancedThreatProtection(ProxyResource):
    """A server Advanced Threat Protection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of AdvancedThreatProtectionResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "New", "Enabled", and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.AdvancedThreatProtectionState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the Advanced Threat Protection, whether it is enabled or
         disabled or a state has not been applied yet on the specific database or server. Known values
         are: "New", "Enabled", and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.AdvancedThreatProtectionState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.creation_time: Optional[datetime.datetime] = None


class ServerAutomaticTuning(ProxyResource):
    """Server-level Automatic Tuning.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar desired_state: Automatic tuning desired state. Known values are: "Custom", "Auto", and
     "Unspecified".
    :vartype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :ivar actual_state: Automatic tuning actual state. Known values are: "Custom", "Auto", and
     "Unspecified".
    :vartype actual_state: str or ~azure.mgmt.sql.models.AutomaticTuningServerMode
    :ivar options: Automatic tuning options definition.
    :vartype options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningServerOptions]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "actual_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "desired_state": {"key": "properties.desiredState", "type": "str"},
        "actual_state": {"key": "properties.actualState", "type": "str"},
        "options": {"key": "properties.options", "type": "{AutomaticTuningServerOptions}"},
    }

    def __init__(
        self,
        *,
        desired_state: Optional[Union[str, "_models.AutomaticTuningServerMode"]] = None,
        options: Optional[Dict[str, "_models.AutomaticTuningServerOptions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword desired_state: Automatic tuning desired state. Known values are: "Custom", "Auto", and
         "Unspecified".
        :paramtype desired_state: str or ~azure.mgmt.sql.models.AutomaticTuningServerMode
        :keyword options: Automatic tuning options definition.
        :paramtype options: dict[str, ~azure.mgmt.sql.models.AutomaticTuningServerOptions]
        """
        super().__init__(**kwargs)
        self.desired_state = desired_state
        self.actual_state: Optional[Union[str, "_models.AutomaticTuningServerMode"]] = None
        self.options = options


class ServerAzureADAdministrator(ProxyResource):
    """Azure Active Directory administrator.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar administrator_type: Type of the sever administrator. "ActiveDirectory"
    :vartype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :ivar login: Login name of the server administrator.
    :vartype login: str
    :ivar sid: SID (object ID) of the server administrator.
    :vartype sid: str
    :ivar tenant_id: Tenant ID of the administrator.
    :vartype tenant_id: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "azure_ad_only_authentication": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "administrator_type": {"key": "properties.administratorType", "type": "str"},
        "login": {"key": "properties.login", "type": "str"},
        "sid": {"key": "properties.sid", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "azure_ad_only_authentication": {"key": "properties.azureADOnlyAuthentication", "type": "bool"},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "_models.AdministratorType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_type: Type of the sever administrator. "ActiveDirectory"
        :paramtype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
        :keyword login: Login name of the server administrator.
        :paramtype login: str
        :keyword sid: SID (object ID) of the server administrator.
        :paramtype sid: str
        :keyword tenant_id: Tenant ID of the administrator.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.administrator_type = administrator_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication: Optional[bool] = None


class ServerAzureADOnlyAuthentication(ProxyResource):
    """Azure Active Directory only authentication.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "azure_ad_only_authentication": {"key": "properties.azureADOnlyAuthentication", "type": "bool"},
    }

    def __init__(self, *, azure_ad_only_authentication: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :paramtype azure_ad_only_authentication: bool
        """
        super().__init__(**kwargs)
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ServerBlobAuditingPolicy(ProxyResource):
    """A server blob auditing policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled, devops
     logs will be sent to Azure Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
     'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true

     When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
     diagnostic logs category on the master database should also be created.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_devops_audit_enabled: bool
    :ivar retention_days: Specifies the number of days to keep in the audit logs in the storage
     account.
    :vartype retention_days: int
    :ivar audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

     The recommended set of action groups to use is the following combination - this will audit all
     the queries and stored procedures executed against the database, as well as successful and
     failed logins:

     BATCH_COMPLETED_GROUP,
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
     FAILED_DATABASE_AUTHENTICATION_GROUP.

     This above combination is also the set that is configured by default when enabling auditing
     from the Azure portal.

     The supported action groups to audit are (note: choose only specific groups that cover your
     auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

     APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
     BACKUP_RESTORE_GROUP
     DATABASE_LOGOUT_GROUP
     DATABASE_OBJECT_CHANGE_GROUP
     DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
     DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
     DATABASE_OPERATION_GROUP
     DATABASE_PERMISSION_CHANGE_GROUP
     DATABASE_PRINCIPAL_CHANGE_GROUP
     DATABASE_PRINCIPAL_IMPERSONATION_GROUP
     DATABASE_ROLE_MEMBER_CHANGE_GROUP
     FAILED_DATABASE_AUTHENTICATION_GROUP
     SCHEMA_OBJECT_ACCESS_GROUP
     SCHEMA_OBJECT_CHANGE_GROUP
     SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
     SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
     SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
     USER_CHANGE_PASSWORD_GROUP
     BATCH_STARTED_GROUP
     BATCH_COMPLETED_GROUP
     DBCC_GROUP
     DATABASE_OWNERSHIP_CHANGE_GROUP
     DATABASE_CHANGE_GROUP
     LEDGER_OPERATION_GROUP

     These are groups that cover all sql statements and stored procedures executed against the
     database, and should not be used in combination with other groups as this will result in
     duplicate audit logs.

     For more information, see `Database-Level Audit Action Groups
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

     For Database auditing policy, specific Actions can also be specified (note that Actions cannot
     be specified for Server auditing policy). The supported actions to audit are:
     SELECT
     UPDATE
     INSERT
     DELETE
     EXECUTE
     RECEIVE
     REFERENCES

     The general form for defining an action to be audited is:
     {action} ON {object} BY {principal}

     Note that :code:`<object>` in the above format can refer to an object like a table, view, or
     stored procedure, or an entire database or schema. For the latter cases, the forms
     DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

     For example:
     SELECT on dbo.myTable by public
     SELECT on DATABASE::myDatabase by public
     SELECT on SCHEMA::mySchema by public

     For more information, see `Database-Level Audit Actions
     <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
    :vartype audit_actions_and_groups: list[str]
    :ivar is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is the
     storage's secondary key.
    :vartype is_storage_secondary_key_in_use: bool
    :ivar is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.

     When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
     diagnostic logs category on the database should be also created.
     Note that for server level audit you should use the 'master' database as {databaseName}.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_azure_monitor_target_enabled: bool
    :ivar queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before audit
     actions are forced to be processed.
     The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
    :vartype queue_delay_ms: int
    :ivar is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
     storage.
    :vartype is_managed_identity_in_use: bool
    :ivar state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:


     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :vartype storage_account_access_key: str
    :ivar storage_account_subscription_id: Specifies the blob storage subscription Id.
    :vartype storage_account_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_devops_audit_enabled": {"key": "properties.isDevopsAuditEnabled", "type": "bool"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "audit_actions_and_groups": {"key": "properties.auditActionsAndGroups", "type": "[str]"},
        "is_storage_secondary_key_in_use": {"key": "properties.isStorageSecondaryKeyInUse", "type": "bool"},
        "is_azure_monitor_target_enabled": {"key": "properties.isAzureMonitorTargetEnabled", "type": "bool"},
        "queue_delay_ms": {"key": "properties.queueDelayMs", "type": "int"},
        "is_managed_identity_in_use": {"key": "properties.isManagedIdentityInUse", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "storage_account_subscription_id": {"key": "properties.storageAccountSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_devops_audit_enabled: Optional[bool] = None,
        retention_days: Optional[int] = None,
        audit_actions_and_groups: Optional[List[str]] = None,
        is_storage_secondary_key_in_use: Optional[bool] = None,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        queue_delay_ms: Optional[int] = None,
        is_managed_identity_in_use: Optional[bool] = None,
        state: Optional[Union[str, "_models.BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_devops_audit_enabled: Specifies the state of devops audit. If state is Enabled,
         devops logs will be sent to Azure Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled',
         'IsAzureMonitorTargetEnabled' as true and 'IsDevopsAuditEnabled' as true

         When using REST API to configure auditing, Diagnostic Settings with 'DevOpsOperationsAudit'
         diagnostic logs category on the master database should also be created.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_devops_audit_enabled: bool
        :keyword retention_days: Specifies the number of days to keep in the audit logs in the storage
         account.
        :paramtype retention_days: int
        :keyword audit_actions_and_groups: Specifies the Actions-Groups and Actions to audit.

         The recommended set of action groups to use is the following combination - this will audit all
         the queries and stored procedures executed against the database, as well as successful and
         failed logins:

         BATCH_COMPLETED_GROUP,
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP,
         FAILED_DATABASE_AUTHENTICATION_GROUP.

         This above combination is also the set that is configured by default when enabling auditing
         from the Azure portal.

         The supported action groups to audit are (note: choose only specific groups that cover your
         auditing needs. Using unnecessary groups could lead to very large quantities of audit records):

         APPLICATION_ROLE_CHANGE_PASSWORD_GROUP
         BACKUP_RESTORE_GROUP
         DATABASE_LOGOUT_GROUP
         DATABASE_OBJECT_CHANGE_GROUP
         DATABASE_OBJECT_OWNERSHIP_CHANGE_GROUP
         DATABASE_OBJECT_PERMISSION_CHANGE_GROUP
         DATABASE_OPERATION_GROUP
         DATABASE_PERMISSION_CHANGE_GROUP
         DATABASE_PRINCIPAL_CHANGE_GROUP
         DATABASE_PRINCIPAL_IMPERSONATION_GROUP
         DATABASE_ROLE_MEMBER_CHANGE_GROUP
         FAILED_DATABASE_AUTHENTICATION_GROUP
         SCHEMA_OBJECT_ACCESS_GROUP
         SCHEMA_OBJECT_CHANGE_GROUP
         SCHEMA_OBJECT_OWNERSHIP_CHANGE_GROUP
         SCHEMA_OBJECT_PERMISSION_CHANGE_GROUP
         SUCCESSFUL_DATABASE_AUTHENTICATION_GROUP
         USER_CHANGE_PASSWORD_GROUP
         BATCH_STARTED_GROUP
         BATCH_COMPLETED_GROUP
         DBCC_GROUP
         DATABASE_OWNERSHIP_CHANGE_GROUP
         DATABASE_CHANGE_GROUP
         LEDGER_OPERATION_GROUP

         These are groups that cover all sql statements and stored procedures executed against the
         database, and should not be used in combination with other groups as this will result in
         duplicate audit logs.

         For more information, see `Database-Level Audit Action Groups
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-action-groups>`_.

         For Database auditing policy, specific Actions can also be specified (note that Actions cannot
         be specified for Server auditing policy). The supported actions to audit are:
         SELECT
         UPDATE
         INSERT
         DELETE
         EXECUTE
         RECEIVE
         REFERENCES

         The general form for defining an action to be audited is:
         {action} ON {object} BY {principal}

         Note that :code:`<object>` in the above format can refer to an object like a table, view, or
         stored procedure, or an entire database or schema. For the latter cases, the forms
         DATABASE::{db_name} and SCHEMA::{schema_name} are used, respectively.

         For example:
         SELECT on dbo.myTable by public
         SELECT on DATABASE::myDatabase by public
         SELECT on SCHEMA::mySchema by public

         For more information, see `Database-Level Audit Actions
         <https://docs.microsoft.com/en-us/sql/relational-databases/security/auditing/sql-server-audit-action-groups-and-actions#database-level-audit-actions>`_.
        :paramtype audit_actions_and_groups: list[str]
        :keyword is_storage_secondary_key_in_use: Specifies whether storageAccountAccessKey value is
         the storage's secondary key.
        :paramtype is_storage_secondary_key_in_use: bool
        :keyword is_azure_monitor_target_enabled: Specifies whether audit events are sent to Azure
         Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
         'IsAzureMonitorTargetEnabled' as true.

         When using REST API to configure auditing, Diagnostic Settings with 'SQLSecurityAuditEvents'
         diagnostic logs category on the database should be also created.
         Note that for server level audit you should use the 'master' database as {databaseName}.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_azure_monitor_target_enabled: bool
        :keyword queue_delay_ms: Specifies the amount of time in milliseconds that can elapse before
         audit actions are forced to be processed.
         The default minimum value is 1000 (1 second). The maximum is 2,147,483,647.
        :paramtype queue_delay_ms: int
        :keyword is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
         storage.
        :paramtype is_managed_identity_in_use: bool
        :keyword state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled is required.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the auditing storage
         account.
         If state is Enabled and storageEndpoint is specified, not specifying the
         storageAccountAccessKey will use SQL server system-assigned managed identity to access the
         storage.
         Prerequisites for using managed identity authentication:


         #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
         #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
         Contributor' RBAC role to the server identity.
            For more information, see `Auditing to storage using Managed Identity authentication
         <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
        :paramtype storage_account_access_key: str
        :keyword storage_account_subscription_id: Specifies the blob storage subscription Id.
        :paramtype storage_account_subscription_id: str
        """
        super().__init__(**kwargs)
        self.is_devops_audit_enabled = is_devops_audit_enabled
        self.retention_days = retention_days
        self.audit_actions_and_groups = audit_actions_and_groups
        self.is_storage_secondary_key_in_use = is_storage_secondary_key_in_use
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.queue_delay_ms = queue_delay_ms
        self.is_managed_identity_in_use = is_managed_identity_in_use
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ServerBlobAuditingPolicyListResult(_serialization.Model):
    """A list of server auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerBlobAuditingPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerBlobAuditingPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerBlobAuditingPolicy"]] = None
        self.next_link: Optional[str] = None


class ServerConfigurationOption(ProxyResource):
    """A server configuration option.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar server_configuration_option_value: Value of the server configuration option.
    :vartype server_configuration_option_value: int
    :ivar provisioning_state: Provisioning state of server configuration option. Known values are:
     "Created", "InProgress", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.sql.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "server_configuration_option_value": {"key": "properties.serverConfigurationOptionValue", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, server_configuration_option_value: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword server_configuration_option_value: Value of the server configuration option.
        :paramtype server_configuration_option_value: int
        """
        super().__init__(**kwargs)
        self.server_configuration_option_value = server_configuration_option_value
        self.provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None


class ServerConfigurationOptionListResult(_serialization.Model):
    """A list of server configuration options.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerConfigurationOption]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerConfigurationOption]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerConfigurationOption"]] = None
        self.next_link: Optional[str] = None


class ServerConnectionPolicy(ProxyResource):
    """A server connection policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar kind: Metadata used for the Azure portal experience.
    :vartype kind: str
    :ivar connection_type: The server connection type. Known values are: "Default", "Redirect", and
     "Proxy".
    :vartype connection_type: str or ~azure.mgmt.sql.models.ServerConnectionType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"readonly": True},
        "kind": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "connection_type": {"key": "properties.connectionType", "type": "str"},
    }

    def __init__(
        self, *, connection_type: Optional[Union[str, "_models.ServerConnectionType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connection_type: The server connection type. Known values are: "Default", "Redirect",
         and "Proxy".
        :paramtype connection_type: str or ~azure.mgmt.sql.models.ServerConnectionType
        """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.kind: Optional[str] = None
        self.connection_type = connection_type


class ServerConnectionPolicyListResult(_serialization.Model):
    """A list of server connection policy objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerConnectionPolicy]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerConnectionPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerConnectionPolicy"]] = None
        self.next_link: Optional[str] = None


class ServerDevOpsAuditingSettings(ProxyResource):
    """A server DevOps auditing settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of ServerDevOpsAuditSettingsResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar is_azure_monitor_target_enabled: Specifies whether DevOps audit events are sent to Azure
     Monitor.
     In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
     'IsAzureMonitorTargetEnabled' as true.

     When using REST API to configure DevOps audit, Diagnostic Settings with 'DevOpsOperationsAudit'
     diagnostic logs category on the master database should be also created.

     Diagnostic Settings URI format:
     PUT
     https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

     For more information, see `Diagnostic Settings REST API
     <https://go.microsoft.com/fwlink/?linkid=2033207>`_
     or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
    :vartype is_azure_monitor_target_enabled: bool
    :ivar is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
     storage.
    :vartype is_managed_identity_in_use: bool
    :ivar state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
     isAzureMonitorTargetEnabled is required.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the auditing storage account.
     If state is Enabled and storageEndpoint is specified, not specifying the
     storageAccountAccessKey will use SQL server system-assigned managed identity to access the
     storage.
     Prerequisites for using managed identity authentication:


     #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
     #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
     Contributor' RBAC role to the server identity.
        For more information, see `Auditing to storage using Managed Identity authentication
     <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
    :vartype storage_account_access_key: str
    :ivar storage_account_subscription_id: Specifies the blob storage subscription Id.
    :vartype storage_account_subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "is_azure_monitor_target_enabled": {"key": "properties.isAzureMonitorTargetEnabled", "type": "bool"},
        "is_managed_identity_in_use": {"key": "properties.isManagedIdentityInUse", "type": "bool"},
        "state": {"key": "properties.state", "type": "str"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "storage_account_subscription_id": {"key": "properties.storageAccountSubscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_azure_monitor_target_enabled: Optional[bool] = None,
        is_managed_identity_in_use: Optional[bool] = None,
        state: Optional[Union[str, "_models.BlobAuditingPolicyState"]] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        storage_account_subscription_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_azure_monitor_target_enabled: Specifies whether DevOps audit events are sent to
         Azure Monitor.
         In order to send the events to Azure Monitor, specify 'State' as 'Enabled' and
         'IsAzureMonitorTargetEnabled' as true.

         When using REST API to configure DevOps audit, Diagnostic Settings with 'DevOpsOperationsAudit'
         diagnostic logs category on the master database should be also created.

         Diagnostic Settings URI format:
         PUT
         https://management.azure.com/subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Sql/servers/{serverName}/databases/master/providers/microsoft.insights/diagnosticSettings/{settingsName}?api-version=2017-05-01-preview

         For more information, see `Diagnostic Settings REST API
         <https://go.microsoft.com/fwlink/?linkid=2033207>`_
         or `Diagnostic Settings PowerShell <https://go.microsoft.com/fwlink/?linkid=2033043>`_.
        :paramtype is_azure_monitor_target_enabled: bool
        :keyword is_managed_identity_in_use: Specifies whether Managed Identity is used to access blob
         storage.
        :paramtype is_managed_identity_in_use: bool
        :keyword state: Specifies the state of the audit. If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled are required. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.BlobAuditingPolicyState
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). If state is Enabled, storageEndpoint or
         isAzureMonitorTargetEnabled is required.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the auditing storage
         account.
         If state is Enabled and storageEndpoint is specified, not specifying the
         storageAccountAccessKey will use SQL server system-assigned managed identity to access the
         storage.
         Prerequisites for using managed identity authentication:


         #. Assign SQL Server a system-assigned managed identity in Azure Active Directory (AAD).
         #. Grant SQL Server identity access to the storage account by adding 'Storage Blob Data
         Contributor' RBAC role to the server identity.
            For more information, see `Auditing to storage using Managed Identity authentication
         <https://go.microsoft.com/fwlink/?linkid=2114355>`_.
        :paramtype storage_account_access_key: str
        :keyword storage_account_subscription_id: Specifies the blob storage subscription Id.
        :paramtype storage_account_subscription_id: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.is_azure_monitor_target_enabled = is_azure_monitor_target_enabled
        self.is_managed_identity_in_use = is_managed_identity_in_use
        self.state = state
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.storage_account_subscription_id = storage_account_subscription_id


class ServerDevOpsAuditSettingsListResult(_serialization.Model):
    """A list of server DevOps audit settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerDevOpsAuditingSettings]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerDevOpsAuditingSettings]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerDevOpsAuditingSettings"]] = None
        self.next_link: Optional[str] = None


class ServerDnsAlias(ProxyResource):
    """A server DNS alias.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar azure_dns_record: The fully qualified DNS record for alias.
    :vartype azure_dns_record: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "azure_dns_record": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "azure_dns_record": {"key": "properties.azureDnsRecord", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_dns_record: Optional[str] = None


class ServerDnsAliasAcquisition(_serialization.Model):
    """A server dns alias acquisition request.

    All required parameters must be populated in order to send to server.

    :ivar old_server_dns_alias_id: The id of the server alias that will be acquired to point to
     this server instead. Required.
    :vartype old_server_dns_alias_id: str
    """

    _validation = {
        "old_server_dns_alias_id": {"required": True},
    }

    _attribute_map = {
        "old_server_dns_alias_id": {"key": "oldServerDnsAliasId", "type": "str"},
    }

    def __init__(self, *, old_server_dns_alias_id: str, **kwargs: Any) -> None:
        """
        :keyword old_server_dns_alias_id: The id of the server alias that will be acquired to point to
         this server instead. Required.
        :paramtype old_server_dns_alias_id: str
        """
        super().__init__(**kwargs)
        self.old_server_dns_alias_id = old_server_dns_alias_id


class ServerDnsAliasListResult(_serialization.Model):
    """A list of server DNS aliases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerDnsAlias]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerDnsAlias]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerDnsAlias"]] = None
        self.next_link: Optional[str] = None


class ServerExternalAdministrator(_serialization.Model):
    """Properties of a active directory administrator.

    :ivar administrator_type: Type of the sever administrator. "ActiveDirectory"
    :vartype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
    :ivar principal_type: Principal Type of the sever administrator. Known values are: "User",
     "Group", and "Application".
    :vartype principal_type: str or ~azure.mgmt.sql.models.PrincipalType
    :ivar login: Login name of the server administrator.
    :vartype login: str
    :ivar sid: SID (object ID) of the server administrator.
    :vartype sid: str
    :ivar tenant_id: Tenant ID of the administrator.
    :vartype tenant_id: str
    :ivar azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
    :vartype azure_ad_only_authentication: bool
    """

    _attribute_map = {
        "administrator_type": {"key": "administratorType", "type": "str"},
        "principal_type": {"key": "principalType", "type": "str"},
        "login": {"key": "login", "type": "str"},
        "sid": {"key": "sid", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "azure_ad_only_authentication": {"key": "azureADOnlyAuthentication", "type": "bool"},
    }

    def __init__(
        self,
        *,
        administrator_type: Optional[Union[str, "_models.AdministratorType"]] = None,
        principal_type: Optional[Union[str, "_models.PrincipalType"]] = None,
        login: Optional[str] = None,
        sid: Optional[str] = None,
        tenant_id: Optional[str] = None,
        azure_ad_only_authentication: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword administrator_type: Type of the sever administrator. "ActiveDirectory"
        :paramtype administrator_type: str or ~azure.mgmt.sql.models.AdministratorType
        :keyword principal_type: Principal Type of the sever administrator. Known values are: "User",
         "Group", and "Application".
        :paramtype principal_type: str or ~azure.mgmt.sql.models.PrincipalType
        :keyword login: Login name of the server administrator.
        :paramtype login: str
        :keyword sid: SID (object ID) of the server administrator.
        :paramtype sid: str
        :keyword tenant_id: Tenant ID of the administrator.
        :paramtype tenant_id: str
        :keyword azure_ad_only_authentication: Azure Active Directory only Authentication enabled.
        :paramtype azure_ad_only_authentication: bool
        """
        super().__init__(**kwargs)
        self.administrator_type = administrator_type
        self.principal_type = principal_type
        self.login = login
        self.sid = sid
        self.tenant_id = tenant_id
        self.azure_ad_only_authentication = azure_ad_only_authentication


class ServerInfo(_serialization.Model):
    """Server info for the server trust group.

    All required parameters must be populated in order to send to server.

    :ivar server_id: Server Id. Required.
    :vartype server_id: str
    """

    _validation = {
        "server_id": {"required": True},
    }

    _attribute_map = {
        "server_id": {"key": "serverId", "type": "str"},
    }

    def __init__(self, *, server_id: str, **kwargs: Any) -> None:
        """
        :keyword server_id: Server Id. Required.
        :paramtype server_id: str
        """
        super().__init__(**kwargs)
        self.server_id = server_id


class ServerKey(ProxyResource):
    """A server key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar kind: Kind of encryption protector. This is metadata used for the Azure portal
     experience.
    :vartype kind: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar subregion: Subregion of the server key.
    :vartype subregion: str
    :ivar server_key_type: The server key type like 'ServiceManaged', 'AzureKeyVault'. Known values
     are: "ServiceManaged" and "AzureKeyVault".
    :vartype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
    :ivar uri: The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is
     required. The AKV URI is required to be in this format:
     'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion' or can be
     'https://YourVaultName.vault.azure.net/keys/YourKeyName'.
    :vartype uri: str
    :ivar thumbprint: Thumbprint of the server key.
    :vartype thumbprint: str
    :ivar creation_date: The server key creation date.
    :vartype creation_date: ~datetime.datetime
    :ivar auto_rotation_enabled: Key auto rotation opt-in flag. Either true or false.
    :vartype auto_rotation_enabled: bool
    :ivar key_version: The version of the server key.
    :vartype key_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"readonly": True},
        "location": {"readonly": True},
        "subregion": {"readonly": True},
        "thumbprint": {"readonly": True},
        "creation_date": {"readonly": True},
        "auto_rotation_enabled": {"readonly": True},
        "key_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "subregion": {"key": "properties.subregion", "type": "str"},
        "server_key_type": {"key": "properties.serverKeyType", "type": "str"},
        "uri": {"key": "properties.uri", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "auto_rotation_enabled": {"key": "properties.autoRotationEnabled", "type": "bool"},
        "key_version": {"key": "properties.keyVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        server_key_type: Optional[Union[str, "_models.ServerKeyType"]] = None,
        uri: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword server_key_type: The server key type like 'ServiceManaged', 'AzureKeyVault'. Known
         values are: "ServiceManaged" and "AzureKeyVault".
        :paramtype server_key_type: str or ~azure.mgmt.sql.models.ServerKeyType
        :keyword uri: The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is
         required. The AKV URI is required to be in this format:
         'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion' or can be
         'https://YourVaultName.vault.azure.net/keys/YourKeyName'.
        :paramtype uri: str
        """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.location: Optional[str] = None
        self.subregion: Optional[str] = None
        self.server_key_type = server_key_type
        self.uri = uri
        self.thumbprint: Optional[str] = None
        self.creation_date: Optional[datetime.datetime] = None
        self.auto_rotation_enabled: Optional[bool] = None
        self.key_version: Optional[str] = None


class ServerKeyListResult(_serialization.Model):
    """A list of server keys.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerKey]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerKey]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerKey"]] = None
        self.next_link: Optional[str] = None


class ServerListResult(_serialization.Model):
    """A list of servers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.Server]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Server]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Server"]] = None
        self.next_link: Optional[str] = None


class ServerOperation(ProxyResource):
    """A server operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar operation: The name of operation.
    :vartype operation: str
    :ivar operation_friendly_name: The friendly name of operation.
    :vartype operation_friendly_name: str
    :ivar percent_complete: The percentage of the operation completed.
    :vartype percent_complete: int
    :ivar server_name: The name of the server.
    :vartype server_name: str
    :ivar start_time: The operation start time.
    :vartype start_time: ~datetime.datetime
    :ivar state: The operation state. Known values are: "Pending", "InProgress", "Succeeded",
     "Failed", "CancelInProgress", and "Cancelled".
    :vartype state: str or ~azure.mgmt.sql.models.ManagementOperationState
    :ivar error_code: The operation error code.
    :vartype error_code: int
    :ivar error_description: The operation error description.
    :vartype error_description: str
    :ivar error_severity: The operation error severity.
    :vartype error_severity: int
    :ivar is_user_error: Whether or not the error is a user error.
    :vartype is_user_error: bool
    :ivar estimated_completion_time: The estimated completion time of the operation.
    :vartype estimated_completion_time: ~datetime.datetime
    :ivar description: The operation description.
    :vartype description: str
    :ivar is_cancellable: Whether the operation can be cancelled.
    :vartype is_cancellable: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operation": {"readonly": True},
        "operation_friendly_name": {"readonly": True},
        "percent_complete": {"readonly": True},
        "server_name": {"readonly": True},
        "start_time": {"readonly": True},
        "state": {"readonly": True},
        "error_code": {"readonly": True},
        "error_description": {"readonly": True},
        "error_severity": {"readonly": True},
        "is_user_error": {"readonly": True},
        "estimated_completion_time": {"readonly": True},
        "description": {"readonly": True},
        "is_cancellable": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "operation": {"key": "properties.operation", "type": "str"},
        "operation_friendly_name": {"key": "properties.operationFriendlyName", "type": "str"},
        "percent_complete": {"key": "properties.percentComplete", "type": "int"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "error_code": {"key": "properties.errorCode", "type": "int"},
        "error_description": {"key": "properties.errorDescription", "type": "str"},
        "error_severity": {"key": "properties.errorSeverity", "type": "int"},
        "is_user_error": {"key": "properties.isUserError", "type": "bool"},
        "estimated_completion_time": {"key": "properties.estimatedCompletionTime", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.operation: Optional[str] = None
        self.operation_friendly_name: Optional[str] = None
        self.percent_complete: Optional[int] = None
        self.server_name: Optional[str] = None
        self.start_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.ManagementOperationState"]] = None
        self.error_code: Optional[int] = None
        self.error_description: Optional[str] = None
        self.error_severity: Optional[int] = None
        self.is_user_error: Optional[bool] = None
        self.estimated_completion_time: Optional[datetime.datetime] = None
        self.description: Optional[str] = None
        self.is_cancellable: Optional[bool] = None


class ServerOperationListResult(_serialization.Model):
    """The response to a list server operations request.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerOperation]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerOperation"]] = None
        self.next_link: Optional[str] = None


class ServerPrivateEndpointConnection(_serialization.Model):
    """A private endpoint connection under a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar properties: Private endpoint connection properties.
    :vartype properties: ~azure.mgmt.sql.models.PrivateEndpointConnectionProperties
    """

    _validation = {
        "id": {"readonly": True},
        "properties": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnectionProperties"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.properties: Optional["_models.PrivateEndpointConnectionProperties"] = None


class ServerSecurityAlertPolicy(ProxyResource):
    """A server security alert policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SecurityAlertPolicyResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the policy, whether it is enabled or disabled or a policy
     has not been applied yet on the specific database. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
    :ivar disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
     Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
     Brute_Force.
    :vartype disabled_alerts: list[str]
    :ivar email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
    :vartype email_addresses: list[str]
    :ivar email_account_admins: Specifies that the alert is sent to the account administrators.
    :vartype email_account_admins: bool
    :ivar storage_endpoint: Specifies the blob storage endpoint (e.g.
     https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
     audit logs.
    :vartype storage_endpoint: str
    :ivar storage_account_access_key: Specifies the identifier key of the Threat Detection audit
     storage account.
    :vartype storage_account_access_key: str
    :ivar retention_days: Specifies the number of days to keep in the Threat Detection audit logs.
    :vartype retention_days: int
    :ivar creation_time: Specifies the UTC creation time of the policy.
    :vartype creation_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "creation_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
        "disabled_alerts": {"key": "properties.disabledAlerts", "type": "[str]"},
        "email_addresses": {"key": "properties.emailAddresses", "type": "[str]"},
        "email_account_admins": {"key": "properties.emailAccountAdmins", "type": "bool"},
        "storage_endpoint": {"key": "properties.storageEndpoint", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "creation_time": {"key": "properties.creationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "_models.SecurityAlertsPolicyState"]] = None,
        disabled_alerts: Optional[List[str]] = None,
        email_addresses: Optional[List[str]] = None,
        email_account_admins: Optional[bool] = None,
        storage_endpoint: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        retention_days: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the policy, whether it is enabled or disabled or a
         policy has not been applied yet on the specific database. Known values are: "Enabled" and
         "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SecurityAlertsPolicyState
        :keyword disabled_alerts: Specifies an array of alerts that are disabled. Allowed values are:
         Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action,
         Brute_Force.
        :paramtype disabled_alerts: list[str]
        :keyword email_addresses: Specifies an array of e-mail addresses to which the alert is sent.
        :paramtype email_addresses: list[str]
        :keyword email_account_admins: Specifies that the alert is sent to the account administrators.
        :paramtype email_account_admins: bool
        :keyword storage_endpoint: Specifies the blob storage endpoint (e.g.
         https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection
         audit logs.
        :paramtype storage_endpoint: str
        :keyword storage_account_access_key: Specifies the identifier key of the Threat Detection audit
         storage account.
        :paramtype storage_account_access_key: str
        :keyword retention_days: Specifies the number of days to keep in the Threat Detection audit
         logs.
        :paramtype retention_days: int
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state
        self.disabled_alerts = disabled_alerts
        self.email_addresses = email_addresses
        self.email_account_admins = email_account_admins
        self.storage_endpoint = storage_endpoint
        self.storage_account_access_key = storage_account_access_key
        self.retention_days = retention_days
        self.creation_time: Optional[datetime.datetime] = None


class ServerTrustCertificate(ProxyResource):
    """Server trust certificate imported from box to enable connection between box and Sql Managed
    Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar public_blob: The certificate public blob.
    :vartype public_blob: str
    :ivar thumbprint: The certificate thumbprint.
    :vartype thumbprint: str
    :ivar certificate_name: The certificate name.
    :vartype certificate_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "thumbprint": {"readonly": True},
        "certificate_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "public_blob": {"key": "properties.publicBlob", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "certificate_name": {"key": "properties.certificateName", "type": "str"},
    }

    def __init__(self, *, public_blob: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword public_blob: The certificate public blob.
        :paramtype public_blob: str
        """
        super().__init__(**kwargs)
        self.public_blob = public_blob
        self.thumbprint: Optional[str] = None
        self.certificate_name: Optional[str] = None


class ServerTrustCertificatesListResult(_serialization.Model):
    """A list of server trust certificates in instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerTrustCertificate]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerTrustCertificate]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerTrustCertificate"]] = None
        self.next_link: Optional[str] = None


class ServerTrustGroup(ProxyResource):
    """A server trust group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar group_members: Group members information for the server trust group.
    :vartype group_members: list[~azure.mgmt.sql.models.ServerInfo]
    :ivar trust_scopes: Trust scope of the server trust group.
    :vartype trust_scopes: list[str or
     ~azure.mgmt.sql.models.ServerTrustGroupPropertiesTrustScopesItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_members": {"key": "properties.groupMembers", "type": "[ServerInfo]"},
        "trust_scopes": {"key": "properties.trustScopes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        group_members: Optional[List["_models.ServerInfo"]] = None,
        trust_scopes: Optional[List[Union[str, "_models.ServerTrustGroupPropertiesTrustScopesItem"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword group_members: Group members information for the server trust group.
        :paramtype group_members: list[~azure.mgmt.sql.models.ServerInfo]
        :keyword trust_scopes: Trust scope of the server trust group.
        :paramtype trust_scopes: list[str or
         ~azure.mgmt.sql.models.ServerTrustGroupPropertiesTrustScopesItem]
        """
        super().__init__(**kwargs)
        self.group_members = group_members
        self.trust_scopes = trust_scopes


class ServerTrustGroupListResult(_serialization.Model):
    """A list of server trust groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerTrustGroup]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerTrustGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerTrustGroup"]] = None
        self.next_link: Optional[str] = None


class ServerUpdate(_serialization.Model):
    """An update request for an Azure SQL Database server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: Server identity.
    :vartype identity: ~azure.mgmt.sql.models.ResourceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar administrator_login: Administrator username for the server. Once created it cannot be
     changed.
    :vartype administrator_login: str
    :ivar administrator_login_password: The administrator login password (required for server
     creation).
    :vartype administrator_login_password: str
    :ivar version: The version of the server.
    :vartype version: str
    :ivar state: The state of the server.
    :vartype state: str
    :ivar fully_qualified_domain_name: The fully qualified domain name of the server.
    :vartype fully_qualified_domain_name: str
    :ivar private_endpoint_connections: List of private endpoint connections on a server.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.sql.models.ServerPrivateEndpointConnection]
    :ivar minimal_tls_version: Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2',
     '1.3'. Known values are: "None", "1.0", "1.1", "1.2", and "1.3".
    :vartype minimal_tls_version: str or ~azure.mgmt.sql.models.MinimalTlsVersion
    :ivar public_network_access: Whether or not public endpoint access is allowed for this server.
     Value is optional but if passed in, must be 'Enabled' or 'Disabled' or 'SecuredByPerimeter'.
     Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
    :vartype public_network_access: str or ~azure.mgmt.sql.models.ServerPublicNetworkAccessFlag
    :ivar workspace_feature: Whether or not existing server has a workspace created and if it
     allows connection from workspace. Known values are: "Connected" and "Disconnected".
    :vartype workspace_feature: str or ~azure.mgmt.sql.models.ServerWorkspaceFeature
    :ivar primary_user_assigned_identity_id: The resource id of a user assigned identity to be used
     by default.
    :vartype primary_user_assigned_identity_id: str
    :ivar federated_client_id: The Client id used for cross tenant CMK scenario.
    :vartype federated_client_id: str
    :ivar key_id: A CMK URI of the key to use for encryption.
    :vartype key_id: str
    :ivar administrators: The Azure Active Directory administrator can be utilized during server
     creation and for server updates, except for the azureADOnlyAuthentication property. To update
     the azureADOnlyAuthentication property, individual API must be used.
    :vartype administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
    :ivar restrict_outbound_network_access: Whether or not to restrict outbound network access for
     this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known values
     are: "Enabled" and "Disabled".
    :vartype restrict_outbound_network_access: str or
     ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar is_i_pv6_enabled: Whether or not to enable IPv6 support for this server.  Value is
     optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
     "Disabled".
    :vartype is_i_pv6_enabled: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
    :ivar external_governance_status: Status of external governance. Known values are: "Enabled"
     and "Disabled".
    :vartype external_governance_status: str or ~azure.mgmt.sql.models.ExternalGovernanceStatus
    :ivar retention_days: Number of days this server will stay soft-deleted.
    :vartype retention_days: int
    :ivar create_mode: Create mode for server, only valid values for this are Normal and Restore.
     Known values are: "Normal" and "Restore".
    :vartype create_mode: str or ~azure.mgmt.sql.models.ServerCreateMode
    """

    _validation = {
        "state": {"readonly": True},
        "fully_qualified_domain_name": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
        "workspace_feature": {"readonly": True},
        "external_governance_status": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "administrator_login": {"key": "properties.administratorLogin", "type": "str"},
        "administrator_login_password": {"key": "properties.administratorLoginPassword", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "fully_qualified_domain_name": {"key": "properties.fullyQualifiedDomainName", "type": "str"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[ServerPrivateEndpointConnection]",
        },
        "minimal_tls_version": {"key": "properties.minimalTlsVersion", "type": "str"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "workspace_feature": {"key": "properties.workspaceFeature", "type": "str"},
        "primary_user_assigned_identity_id": {"key": "properties.primaryUserAssignedIdentityId", "type": "str"},
        "federated_client_id": {"key": "properties.federatedClientId", "type": "str"},
        "key_id": {"key": "properties.keyId", "type": "str"},
        "administrators": {"key": "properties.administrators", "type": "ServerExternalAdministrator"},
        "restrict_outbound_network_access": {"key": "properties.restrictOutboundNetworkAccess", "type": "str"},
        "is_i_pv6_enabled": {"key": "properties.isIPv6Enabled", "type": "str"},
        "external_governance_status": {"key": "properties.externalGovernanceStatus", "type": "str"},
        "retention_days": {"key": "properties.retentionDays", "type": "int"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ResourceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        administrator_login: Optional[str] = None,
        administrator_login_password: Optional[str] = None,
        version: Optional[str] = None,
        minimal_tls_version: Optional[Union[str, "_models.MinimalTlsVersion"]] = None,
        public_network_access: Optional[Union[str, "_models.ServerPublicNetworkAccessFlag"]] = None,
        primary_user_assigned_identity_id: Optional[str] = None,
        federated_client_id: Optional[str] = None,
        key_id: Optional[str] = None,
        administrators: Optional["_models.ServerExternalAdministrator"] = None,
        restrict_outbound_network_access: Optional[Union[str, "_models.ServerNetworkAccessFlag"]] = None,
        is_i_pv6_enabled: Optional[Union[str, "_models.ServerNetworkAccessFlag"]] = None,
        retention_days: Optional[int] = None,
        create_mode: Optional[Union[str, "_models.ServerCreateMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: Server identity.
        :paramtype identity: ~azure.mgmt.sql.models.ResourceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword administrator_login: Administrator username for the server. Once created it cannot be
         changed.
        :paramtype administrator_login: str
        :keyword administrator_login_password: The administrator login password (required for server
         creation).
        :paramtype administrator_login_password: str
        :keyword version: The version of the server.
        :paramtype version: str
        :keyword minimal_tls_version: Minimal TLS version. Allowed values: 'None', 1.0', '1.1', '1.2',
         '1.3'. Known values are: "None", "1.0", "1.1", "1.2", and "1.3".
        :paramtype minimal_tls_version: str or ~azure.mgmt.sql.models.MinimalTlsVersion
        :keyword public_network_access: Whether or not public endpoint access is allowed for this
         server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled' or
         'SecuredByPerimeter'. Known values are: "Enabled", "Disabled", and "SecuredByPerimeter".
        :paramtype public_network_access: str or ~azure.mgmt.sql.models.ServerPublicNetworkAccessFlag
        :keyword primary_user_assigned_identity_id: The resource id of a user assigned identity to be
         used by default.
        :paramtype primary_user_assigned_identity_id: str
        :keyword federated_client_id: The Client id used for cross tenant CMK scenario.
        :paramtype federated_client_id: str
        :keyword key_id: A CMK URI of the key to use for encryption.
        :paramtype key_id: str
        :keyword administrators: The Azure Active Directory administrator can be utilized during server
         creation and for server updates, except for the azureADOnlyAuthentication property. To update
         the azureADOnlyAuthentication property, individual API must be used.
        :paramtype administrators: ~azure.mgmt.sql.models.ServerExternalAdministrator
        :keyword restrict_outbound_network_access: Whether or not to restrict outbound network access
         for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'. Known
         values are: "Enabled" and "Disabled".
        :paramtype restrict_outbound_network_access: str or
         ~azure.mgmt.sql.models.ServerNetworkAccessFlag
        :keyword is_i_pv6_enabled: Whether or not to enable IPv6 support for this server.  Value is
         optional but if passed in, must be 'Enabled' or 'Disabled'. Known values are: "Enabled" and
         "Disabled".
        :paramtype is_i_pv6_enabled: str or ~azure.mgmt.sql.models.ServerNetworkAccessFlag
        :keyword retention_days: Number of days this server will stay soft-deleted.
        :paramtype retention_days: int
        :keyword create_mode: Create mode for server, only valid values for this are Normal and
         Restore. Known values are: "Normal" and "Restore".
        :paramtype create_mode: str or ~azure.mgmt.sql.models.ServerCreateMode
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.administrator_login = administrator_login
        self.administrator_login_password = administrator_login_password
        self.version = version
        self.state: Optional[str] = None
        self.fully_qualified_domain_name: Optional[str] = None
        self.private_endpoint_connections: Optional[List["_models.ServerPrivateEndpointConnection"]] = None
        self.minimal_tls_version = minimal_tls_version
        self.public_network_access = public_network_access
        self.workspace_feature: Optional[Union[str, "_models.ServerWorkspaceFeature"]] = None
        self.primary_user_assigned_identity_id = primary_user_assigned_identity_id
        self.federated_client_id = federated_client_id
        self.key_id = key_id
        self.administrators = administrators
        self.restrict_outbound_network_access = restrict_outbound_network_access
        self.is_i_pv6_enabled = is_i_pv6_enabled
        self.external_governance_status: Optional[Union[str, "_models.ExternalGovernanceStatus"]] = None
        self.retention_days = retention_days
        self.create_mode = create_mode


class ServerUsage(ProxyResource):
    """Usage metric of a server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "float"},
        "limit": {"key": "properties.limit", "type": "float"},
        "unit": {"key": "properties.unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.current_value: Optional[float] = None
        self.limit: Optional[float] = None
        self.unit: Optional[str] = None


class ServerUsageListResult(_serialization.Model):
    """A list of server usage metrics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerUsage"]] = None
        self.next_link: Optional[str] = None


class ServerVersionCapability(_serialization.Model):
    """The server capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The server version name.
    :vartype name: str
    :ivar supported_editions: The list of supported database editions.
    :vartype supported_editions: list[~azure.mgmt.sql.models.EditionCapability]
    :ivar supported_elastic_pool_editions: The list of supported elastic pool editions.
    :vartype supported_elastic_pool_editions:
     list[~azure.mgmt.sql.models.ElasticPoolEditionCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "name": {"readonly": True},
        "supported_editions": {"readonly": True},
        "supported_elastic_pool_editions": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "supported_editions": {"key": "supportedEditions", "type": "[EditionCapability]"},
        "supported_elastic_pool_editions": {
            "key": "supportedElasticPoolEditions",
            "type": "[ElasticPoolEditionCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.supported_editions: Optional[List["_models.EditionCapability"]] = None
        self.supported_elastic_pool_editions: Optional[List["_models.ElasticPoolEditionCapability"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ServerVulnerabilityAssessment(ProxyResource):
    """A server vulnerability assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar storage_container_path: A blob storage container path to hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :vartype storage_container_path: str
    :ivar storage_container_sas_key: A shared access signature (SAS Key) that has write access to
     the blob container specified in 'storageContainerPath' parameter. If 'storageAccountAccessKey'
     isn't specified, StorageContainerSasKey is required. Applies only if the storage account is not
     behind a Vnet or a firewall.
    :vartype storage_container_sas_key: str
    :ivar storage_account_access_key: Specifies the identifier key of the storage account for
     vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
     storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
     or a firewall.
    :vartype storage_account_access_key: str
    :ivar recurring_scans: The recurring scans settings.
    :vartype recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "storage_container_path": {"key": "properties.storageContainerPath", "type": "str"},
        "storage_container_sas_key": {"key": "properties.storageContainerSasKey", "type": "str"},
        "storage_account_access_key": {"key": "properties.storageAccountAccessKey", "type": "str"},
        "recurring_scans": {
            "key": "properties.recurringScans",
            "type": "VulnerabilityAssessmentRecurringScansProperties",
        },
    }

    def __init__(
        self,
        *,
        storage_container_path: Optional[str] = None,
        storage_container_sas_key: Optional[str] = None,
        storage_account_access_key: Optional[str] = None,
        recurring_scans: Optional["_models.VulnerabilityAssessmentRecurringScansProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_container_path: A blob storage container path to hold the scan results (e.g.
         https://myStorage.blob.core.windows.net/VaScans/).
        :paramtype storage_container_path: str
        :keyword storage_container_sas_key: A shared access signature (SAS Key) that has write access
         to the blob container specified in 'storageContainerPath' parameter. If
         'storageAccountAccessKey' isn't specified, StorageContainerSasKey is required. Applies only if
         the storage account is not behind a Vnet or a firewall.
        :paramtype storage_container_sas_key: str
        :keyword storage_account_access_key: Specifies the identifier key of the storage account for
         vulnerability assessment scan results. If 'StorageContainerSasKey' isn't specified,
         storageAccountAccessKey is required. Applies only if the storage account is not behind a Vnet
         or a firewall.
        :paramtype storage_account_access_key: str
        :keyword recurring_scans: The recurring scans settings.
        :paramtype recurring_scans:
         ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
        """
        super().__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.storage_account_access_key = storage_account_access_key
        self.recurring_scans = recurring_scans


class ServerVulnerabilityAssessmentListResult(_serialization.Model):
    """A list of the server's vulnerability assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.ServerVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerVulnerabilityAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ServerVulnerabilityAssessment"]] = None
        self.next_link: Optional[str] = None


class ServiceObjectiveCapability(_serialization.Model):
    """The service objectives capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The unique ID of the service objective.
    :vartype id: str
    :ivar name: The service objective name.
    :vartype name: str
    :ivar supported_max_sizes: The list of supported maximum database sizes.
    :vartype supported_max_sizes: list[~azure.mgmt.sql.models.MaxSizeRangeCapability]
    :ivar performance_level: The performance level.
    :vartype performance_level: ~azure.mgmt.sql.models.PerformanceLevelCapability
    :ivar sku: The sku.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar supported_license_types: List of supported license types.
    :vartype supported_license_types: list[~azure.mgmt.sql.models.LicenseTypeCapability]
    :ivar included_max_size: The included (free) max size.
    :vartype included_max_size: ~azure.mgmt.sql.models.MaxSizeCapability
    :ivar zone_redundant: Whether or not zone redundancy is supported for the service objective.
    :vartype zone_redundant: bool
    :ivar supported_auto_pause_delay: Supported time range for auto pause delay.
    :vartype supported_auto_pause_delay: ~azure.mgmt.sql.models.AutoPauseDelayTimeRange
    :ivar supported_min_capacities: List of supported min capacities.
    :vartype supported_min_capacities: list[~azure.mgmt.sql.models.MinCapacityCapability]
    :ivar compute_model: The compute model.
    :vartype compute_model: str
    :ivar supported_maintenance_configurations: List of supported maintenance configurations.
    :vartype supported_maintenance_configurations:
     list[~azure.mgmt.sql.models.MaintenanceConfigurationCapability]
    :ivar zone_pinning: Whether or not zone pinning is supported.
    :vartype zone_pinning: bool
    :ivar supported_zones: List of supported availability zones.
    :vartype supported_zones: list[~azure.mgmt.sql.models.ZonePinningCapability]
    :ivar supported_free_limit_exhaustion_behaviors: List of supported free limit exhaustion
     behaviors.
    :vartype supported_free_limit_exhaustion_behaviors:
     list[~azure.mgmt.sql.models.FreeLimitExhaustionBehaviorCapability]
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "supported_max_sizes": {"readonly": True},
        "performance_level": {"readonly": True},
        "sku": {"readonly": True},
        "supported_license_types": {"readonly": True},
        "included_max_size": {"readonly": True},
        "zone_redundant": {"readonly": True},
        "supported_auto_pause_delay": {"readonly": True},
        "supported_min_capacities": {"readonly": True},
        "compute_model": {"readonly": True},
        "supported_maintenance_configurations": {"readonly": True},
        "zone_pinning": {"readonly": True},
        "supported_zones": {"readonly": True},
        "supported_free_limit_exhaustion_behaviors": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "supported_max_sizes": {"key": "supportedMaxSizes", "type": "[MaxSizeRangeCapability]"},
        "performance_level": {"key": "performanceLevel", "type": "PerformanceLevelCapability"},
        "sku": {"key": "sku", "type": "Sku"},
        "supported_license_types": {"key": "supportedLicenseTypes", "type": "[LicenseTypeCapability]"},
        "included_max_size": {"key": "includedMaxSize", "type": "MaxSizeCapability"},
        "zone_redundant": {"key": "zoneRedundant", "type": "bool"},
        "supported_auto_pause_delay": {"key": "supportedAutoPauseDelay", "type": "AutoPauseDelayTimeRange"},
        "supported_min_capacities": {"key": "supportedMinCapacities", "type": "[MinCapacityCapability]"},
        "compute_model": {"key": "computeModel", "type": "str"},
        "supported_maintenance_configurations": {
            "key": "supportedMaintenanceConfigurations",
            "type": "[MaintenanceConfigurationCapability]",
        },
        "zone_pinning": {"key": "zonePinning", "type": "bool"},
        "supported_zones": {"key": "supportedZones", "type": "[ZonePinningCapability]"},
        "supported_free_limit_exhaustion_behaviors": {
            "key": "supportedFreeLimitExhaustionBehaviors",
            "type": "[FreeLimitExhaustionBehaviorCapability]",
        },
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.supported_max_sizes: Optional[List["_models.MaxSizeRangeCapability"]] = None
        self.performance_level: Optional["_models.PerformanceLevelCapability"] = None
        self.sku: Optional["_models.Sku"] = None
        self.supported_license_types: Optional[List["_models.LicenseTypeCapability"]] = None
        self.included_max_size: Optional["_models.MaxSizeCapability"] = None
        self.zone_redundant: Optional[bool] = None
        self.supported_auto_pause_delay: Optional["_models.AutoPauseDelayTimeRange"] = None
        self.supported_min_capacities: Optional[List["_models.MinCapacityCapability"]] = None
        self.compute_model: Optional[str] = None
        self.supported_maintenance_configurations: Optional[List["_models.MaintenanceConfigurationCapability"]] = None
        self.zone_pinning: Optional[bool] = None
        self.supported_zones: Optional[List["_models.ZonePinningCapability"]] = None
        self.supported_free_limit_exhaustion_behaviors: Optional[
            List["_models.FreeLimitExhaustionBehaviorCapability"]
        ] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class ServicePrincipal(_serialization.Model):
    """The managed instance's service principal configuration for a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The Azure Active Directory application object id.
    :vartype principal_id: str
    :ivar client_id: The Azure Active Directory application client id.
    :vartype client_id: str
    :ivar tenant_id: The Azure Active Directory tenant id.
    :vartype tenant_id: str
    :ivar type: Service principal type. Known values are: "None" and "SystemAssigned".
    :vartype type: str or ~azure.mgmt.sql.models.ServicePrincipalType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ServicePrincipalType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Service principal type. Known values are: "None" and "SystemAssigned".
        :paramtype type: str or ~azure.mgmt.sql.models.ServicePrincipalType
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type


class Sku(_serialization.Model):
    """An ARM Resource SKU.

    All required parameters must be populated in order to send to server.

    :ivar name: The name of the SKU, typically, a letter + Number code, e.g. P3. Required.
    :vartype name: str
    :ivar tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
    :vartype tier: str
    :ivar size: Size of the particular SKU.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: Capacity of the particular SKU.
    :vartype capacity: int
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: str,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU, typically, a letter + Number code, e.g. P3. Required.
        :paramtype name: str
        :keyword tier: The tier or edition of the particular SKU, e.g. Basic, Premium.
        :paramtype tier: str
        :keyword size: Size of the particular SKU.
        :paramtype size: str
        :keyword family: If the service has different generations of hardware, for the same SKU, then
         that can be captured here.
        :paramtype family: str
        :keyword capacity: Capacity of the particular SKU.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.capacity = capacity


class SqlAgentConfiguration(ProxyResource):
    """A recoverable managed database resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar state: The state of Sql Agent. Known values are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SqlAgentConfigurationPropertiesState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.SqlAgentConfigurationPropertiesState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: The state of Sql Agent. Known values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SqlAgentConfigurationPropertiesState
        """
        super().__init__(**kwargs)
        self.state = state


class SqlVulnerabilityAssessment(ProxyResource):
    """A SQL Vulnerability Assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SqlVulnerabilityAssessmentResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar state: Specifies the state of the SQL Vulnerability Assessment, whether it is enabled or
     disabled or a state has not been applied yet on the specific database or server. Known values
     are: "Enabled" and "Disabled".
    :vartype state: str or ~azure.mgmt.sql.models.SqlVulnerabilityAssessmentState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "state": {"key": "properties.state", "type": "str"},
    }

    def __init__(
        self, *, state: Optional[Union[str, "_models.SqlVulnerabilityAssessmentState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword state: Specifies the state of the SQL Vulnerability Assessment, whether it is enabled
         or disabled or a state has not been applied yet on the specific database or server. Known
         values are: "Enabled" and "Disabled".
        :paramtype state: str or ~azure.mgmt.sql.models.SqlVulnerabilityAssessmentState
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.state = state


class SqlVulnerabilityAssessmentListResult(_serialization.Model):
    """A list of SQL Vulnerability Assessments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SqlVulnerabilityAssessment]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlVulnerabilityAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SqlVulnerabilityAssessment"]] = None
        self.next_link: Optional[str] = None


class SqlVulnerabilityAssessmentScanError(_serialization.Model):
    """Properties of a vulnerability assessment scan error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class SQLVulnerabilityAssessmentScanListResult(_serialization.Model):
    """A list of vulnerability assessment scan results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SqlVulnerabilityAssessmentScanResults]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlVulnerabilityAssessmentScanResults]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SqlVulnerabilityAssessmentScanResults"]] = None
        self.next_link: Optional[str] = None


class SqlVulnerabilityAssessmentScanRecord(ProxyResource):
    """A vulnerability assessment scan record.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of SqlVulnerabilityAssessmentScanRecordResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar scan_id: The scan ID.
    :vartype scan_id: str
    :ivar trigger_type: The scan trigger type. Known values are: "OnDemand" and "Recurring".
    :vartype trigger_type: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentScanTriggerType
    :ivar state: The scan status. Known values are: "Passed", "Failed", "FailedToRun", and
     "InProgress".
    :vartype state: str or ~azure.mgmt.sql.models.VulnerabilityAssessmentScanState
    :ivar start_time: The scan start time (UTC).
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The scan end time (UTC).
    :vartype end_time: ~datetime.datetime
    :ivar errors: The scan errors.
    :vartype errors: list[~azure.mgmt.sql.models.SqlVulnerabilityAssessmentScanError]
    :ivar server: The server name.
    :vartype server: str
    :ivar database: The database name.
    :vartype database: str
    :ivar sql_version: The SQL version.
    :vartype sql_version: str
    :ivar high_severity_failed_rules_count: The number of failed rules with high severity.
    :vartype high_severity_failed_rules_count: int
    :ivar medium_severity_failed_rules_count: The number of failed rules with medium severity.
    :vartype medium_severity_failed_rules_count: int
    :ivar low_severity_failed_rules_count: The number of failed rules with low severity.
    :vartype low_severity_failed_rules_count: int
    :ivar total_passed_rules_count: The number of total passed rules.
    :vartype total_passed_rules_count: int
    :ivar total_failed_rules_count: The number of total failed rules.
    :vartype total_failed_rules_count: int
    :ivar total_rules_count: The number of total rules assessed.
    :vartype total_rules_count: int
    :ivar is_baseline_applied: Baseline created for this database, and has one or more rules.
    :vartype is_baseline_applied: bool
    :ivar last_scan_time: The last scan time.
    :vartype last_scan_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "scan_id": {"readonly": True},
        "trigger_type": {"readonly": True},
        "state": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "errors": {"readonly": True},
        "server": {"readonly": True},
        "database": {"readonly": True},
        "sql_version": {"readonly": True},
        "high_severity_failed_rules_count": {"readonly": True},
        "medium_severity_failed_rules_count": {"readonly": True},
        "low_severity_failed_rules_count": {"readonly": True},
        "total_passed_rules_count": {"readonly": True},
        "total_failed_rules_count": {"readonly": True},
        "total_rules_count": {"readonly": True},
        "is_baseline_applied": {"readonly": True},
        "last_scan_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "scan_id": {"key": "properties.scanId", "type": "str"},
        "trigger_type": {"key": "properties.triggerType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "end_time": {"key": "properties.endTime", "type": "iso-8601"},
        "errors": {"key": "properties.errors", "type": "[SqlVulnerabilityAssessmentScanError]"},
        "server": {"key": "properties.server", "type": "str"},
        "database": {"key": "properties.database", "type": "str"},
        "sql_version": {"key": "properties.sqlVersion", "type": "str"},
        "high_severity_failed_rules_count": {"key": "properties.highSeverityFailedRulesCount", "type": "int"},
        "medium_severity_failed_rules_count": {"key": "properties.mediumSeverityFailedRulesCount", "type": "int"},
        "low_severity_failed_rules_count": {"key": "properties.lowSeverityFailedRulesCount", "type": "int"},
        "total_passed_rules_count": {"key": "properties.totalPassedRulesCount", "type": "int"},
        "total_failed_rules_count": {"key": "properties.totalFailedRulesCount", "type": "int"},
        "total_rules_count": {"key": "properties.totalRulesCount", "type": "int"},
        "is_baseline_applied": {"key": "properties.isBaselineApplied", "type": "bool"},
        "last_scan_time": {"key": "properties.lastScanTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.scan_id: Optional[str] = None
        self.trigger_type: Optional[Union[str, "_models.VulnerabilityAssessmentScanTriggerType"]] = None
        self.state: Optional[Union[str, "_models.VulnerabilityAssessmentScanState"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None
        self.errors: Optional[List["_models.SqlVulnerabilityAssessmentScanError"]] = None
        self.server: Optional[str] = None
        self.database: Optional[str] = None
        self.sql_version: Optional[str] = None
        self.high_severity_failed_rules_count: Optional[int] = None
        self.medium_severity_failed_rules_count: Optional[int] = None
        self.low_severity_failed_rules_count: Optional[int] = None
        self.total_passed_rules_count: Optional[int] = None
        self.total_failed_rules_count: Optional[int] = None
        self.total_rules_count: Optional[int] = None
        self.is_baseline_applied: Optional[bool] = None
        self.last_scan_time: Optional[datetime.datetime] = None


class SqlVulnerabilityAssessmentScanRecordListResult(_serialization.Model):  # pylint: disable=name-too-long
    """A list of vulnerability assessment scan records.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SqlVulnerabilityAssessmentScanRecord]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SqlVulnerabilityAssessmentScanRecord]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SqlVulnerabilityAssessmentScanRecord"]] = None
        self.next_link: Optional[str] = None


class SqlVulnerabilityAssessmentScanResults(ProxyResource):
    """SqlVulnerabilityAssessmentScanResults.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: SystemData of AdvancedThreatProtectionResource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar rule_id: SQL Vulnerability Assessment rule Id.
    :vartype rule_id: str
    :ivar status: SQL Vulnerability Assessment rule result status. Known values are: "NonFinding",
     "Finding", and "InternalError".
    :vartype status: str or ~azure.mgmt.sql.models.RuleStatus
    :ivar error_message: SQL Vulnerability Assessment error message.
    :vartype error_message: str
    :ivar is_trimmed: SQL Vulnerability Assessment is the query results trimmed.
    :vartype is_trimmed: bool
    :ivar query_results: SQL Vulnerability Assessment query results that was run.
    :vartype query_results: list[list[str]]
    :ivar remediation: SQL Vulnerability Assessment the remediation details.
    :vartype remediation: ~azure.mgmt.sql.models.Remediation
    :ivar baseline_adjusted_result: SQL Vulnerability Assessment rule result adjusted with
     baseline.
    :vartype baseline_adjusted_result: ~azure.mgmt.sql.models.BaselineAdjustedResult
    :ivar rule_metadata: SQL Vulnerability Assessment rule metadata.
    :vartype rule_metadata: ~azure.mgmt.sql.models.VaRule
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "rule_id": {"readonly": True},
        "status": {"readonly": True},
        "error_message": {"readonly": True},
        "is_trimmed": {"readonly": True},
        "query_results": {"readonly": True},
        "remediation": {"readonly": True},
        "baseline_adjusted_result": {"readonly": True},
        "rule_metadata": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "rule_id": {"key": "properties.ruleId", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "error_message": {"key": "properties.errorMessage", "type": "str"},
        "is_trimmed": {"key": "properties.isTrimmed", "type": "bool"},
        "query_results": {"key": "properties.queryResults", "type": "[[str]]"},
        "remediation": {"key": "properties.remediation", "type": "Remediation"},
        "baseline_adjusted_result": {"key": "properties.baselineAdjustedResult", "type": "BaselineAdjustedResult"},
        "rule_metadata": {"key": "properties.ruleMetadata", "type": "VaRule"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.rule_id: Optional[str] = None
        self.status: Optional[Union[str, "_models.RuleStatus"]] = None
        self.error_message: Optional[str] = None
        self.is_trimmed: Optional[bool] = None
        self.query_results: Optional[List[List[str]]] = None
        self.remediation: Optional["_models.Remediation"] = None
        self.baseline_adjusted_result: Optional["_models.BaselineAdjustedResult"] = None
        self.rule_metadata: Optional["_models.VaRule"] = None


class StartStopManagedInstanceSchedule(ProxyResource):
    """Managed instance's Start/Stop schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: System data of the scheduled resource.
    :vartype system_data: ~azure.mgmt.sql.models.SystemData
    :ivar description: The description of the schedule.
    :vartype description: str
    :ivar time_zone_id: The time zone of the schedule.
    :vartype time_zone_id: str
    :ivar schedule_list: Schedule list.
    :vartype schedule_list: list[~azure.mgmt.sql.models.ScheduleItem]
    :ivar next_run_action: Next action to be executed (Start or Stop).
    :vartype next_run_action: str
    :ivar next_execution_time: Timestamp when the next action will be executed in the corresponding
     schedule time zone.
    :vartype next_execution_time: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "next_run_action": {"readonly": True},
        "next_execution_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "time_zone_id": {"key": "properties.timeZoneId", "type": "str"},
        "schedule_list": {"key": "properties.scheduleList", "type": "[ScheduleItem]"},
        "next_run_action": {"key": "properties.nextRunAction", "type": "str"},
        "next_execution_time": {"key": "properties.nextExecutionTime", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: str = "",
        time_zone_id: str = "UTC",
        schedule_list: Optional[List["_models.ScheduleItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: The description of the schedule.
        :paramtype description: str
        :keyword time_zone_id: The time zone of the schedule.
        :paramtype time_zone_id: str
        :keyword schedule_list: Schedule list.
        :paramtype schedule_list: list[~azure.mgmt.sql.models.ScheduleItem]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.description = description
        self.time_zone_id = time_zone_id
        self.schedule_list = schedule_list
        self.next_run_action: Optional[str] = None
        self.next_execution_time: Optional[str] = None


class StartStopManagedInstanceScheduleListResult(_serialization.Model):  # pylint: disable=name-too-long
    """Managed instance's Start/Stop schedule list result.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.StartStopManagedInstanceSchedule]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StartStopManagedInstanceSchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.StartStopManagedInstanceSchedule"]] = None
        self.next_link: Optional[str] = None


class StorageCapability(_serialization.Model):
    """The storage account type capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_type: The storage account type for the database's backups. Known values
     are: "GRS", "LRS", "ZRS", and "GZRS".
    :vartype storage_account_type: str or
     ~azure.mgmt.sql.models.StorageCapabilityStorageAccountType
    :ivar status: The status of the capability. Known values are: "Visible", "Available",
     "Default", and "Disabled".
    :vartype status: str or ~azure.mgmt.sql.models.CapabilityStatus
    :ivar reason: The reason for the capability not being available.
    :vartype reason: str
    """

    _validation = {
        "storage_account_type": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_type": {"key": "storageAccountType", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword reason: The reason for the capability not being available.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.storage_account_type: Optional[Union[str, "_models.StorageCapabilityStorageAccountType"]] = None
        self.status: Optional[Union[str, "_models.CapabilityStatus"]] = None
        self.reason = reason


class SubscriptionUsage(ProxyResource):
    """Usage Metric of a Subscription in a Location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User-readable name of the metric.
    :vartype display_name: str
    :ivar current_value: Current value of the metric.
    :vartype current_value: float
    :ivar limit: Boundary value of the metric.
    :vartype limit: float
    :ivar unit: Unit of the metric.
    :vartype unit: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "current_value": {"readonly": True},
        "limit": {"readonly": True},
        "unit": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "current_value": {"key": "properties.currentValue", "type": "float"},
        "limit": {"key": "properties.limit", "type": "float"},
        "unit": {"key": "properties.unit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name: Optional[str] = None
        self.current_value: Optional[float] = None
        self.limit: Optional[float] = None
        self.unit: Optional[str] = None


class SubscriptionUsageListResult(_serialization.Model):
    """A list of subscription usage metrics in a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SubscriptionUsage]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SubscriptionUsage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SubscriptionUsage"]] = None
        self.next_link: Optional[str] = None


class SynapseLinkWorkspace(ProxyResource):
    """Synapse link workspace resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar workspaces: List of all synapselink workspaces.
    :vartype workspaces: list[~azure.mgmt.sql.models.SynapseLinkWorkspaceInfoProperties]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "workspaces": {"key": "properties.workspaces", "type": "[SynapseLinkWorkspaceInfoProperties]"},
    }

    def __init__(
        self, *, workspaces: Optional[List["_models.SynapseLinkWorkspaceInfoProperties"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workspaces: List of all synapselink workspaces.
        :paramtype workspaces: list[~azure.mgmt.sql.models.SynapseLinkWorkspaceInfoProperties]
        """
        super().__init__(**kwargs)
        self.workspaces = workspaces


class SynapseLinkWorkspaceInfoProperties(_serialization.Model):
    """Properties of a Synapse link workspaces.

    :ivar workspace_id: Synapse link workspace id.
    :vartype workspace_id: str
    :ivar link_connection_name: Link connection name.
    :vartype link_connection_name: str
    """

    _attribute_map = {
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "link_connection_name": {"key": "linkConnectionName", "type": "str"},
    }

    def __init__(
        self, *, workspace_id: Optional[str] = None, link_connection_name: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Synapse link workspace id.
        :paramtype workspace_id: str
        :keyword link_connection_name: Link connection name.
        :paramtype link_connection_name: str
        """
        super().__init__(**kwargs)
        self.workspace_id = workspace_id
        self.link_connection_name = link_connection_name


class SynapseLinkWorkspaceListResult(_serialization.Model):
    """A list of synapselink workspaces.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SynapseLinkWorkspace]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SynapseLinkWorkspace]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SynapseLinkWorkspace"]] = None
        self.next_link: Optional[str] = None


class SyncAgent(ProxyResource):
    """An Azure SQL Database sync agent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar name_properties_name: Name of the sync agent.
    :vartype name_properties_name: str
    :ivar sync_database_id: ARM resource id of the sync database in the sync agent.
    :vartype sync_database_id: str
    :ivar last_alive_time: Last alive time of the sync agent.
    :vartype last_alive_time: ~datetime.datetime
    :ivar state: State of the sync agent. Known values are: "Online", "Offline", and
     "NeverConnected".
    :vartype state: str or ~azure.mgmt.sql.models.SyncAgentState
    :ivar is_up_to_date: If the sync agent version is up to date.
    :vartype is_up_to_date: bool
    :ivar expiry_time: Expiration time of the sync agent version.
    :vartype expiry_time: ~datetime.datetime
    :ivar version: Version of the sync agent.
    :vartype version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "name_properties_name": {"readonly": True},
        "last_alive_time": {"readonly": True},
        "state": {"readonly": True},
        "is_up_to_date": {"readonly": True},
        "expiry_time": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "name_properties_name": {"key": "properties.name", "type": "str"},
        "sync_database_id": {"key": "properties.syncDatabaseId", "type": "str"},
        "last_alive_time": {"key": "properties.lastAliveTime", "type": "iso-8601"},
        "state": {"key": "properties.state", "type": "str"},
        "is_up_to_date": {"key": "properties.isUpToDate", "type": "bool"},
        "expiry_time": {"key": "properties.expiryTime", "type": "iso-8601"},
        "version": {"key": "properties.version", "type": "str"},
    }

    def __init__(self, *, sync_database_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sync_database_id: ARM resource id of the sync database in the sync agent.
        :paramtype sync_database_id: str
        """
        super().__init__(**kwargs)
        self.name_properties_name: Optional[str] = None
        self.sync_database_id = sync_database_id
        self.last_alive_time: Optional[datetime.datetime] = None
        self.state: Optional[Union[str, "_models.SyncAgentState"]] = None
        self.is_up_to_date: Optional[bool] = None
        self.expiry_time: Optional[datetime.datetime] = None
        self.version: Optional[str] = None


class SyncAgentKeyProperties(_serialization.Model):
    """Properties of an Azure SQL Database sync agent key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sync_agent_key: Key of sync agent.
    :vartype sync_agent_key: str
    """

    _validation = {
        "sync_agent_key": {"readonly": True},
    }

    _attribute_map = {
        "sync_agent_key": {"key": "syncAgentKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sync_agent_key: Optional[str] = None


class SyncAgentLinkedDatabase(ProxyResource):
    """An Azure SQL Database sync agent linked database.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar database_type: Type of the sync agent linked database. Known values are:
     "AzureSqlDatabase" and "SqlServerDatabase".
    :vartype database_type: str or ~azure.mgmt.sql.models.SyncMemberDbType
    :ivar database_id: Id of the sync agent linked database.
    :vartype database_id: str
    :ivar description: Description of the sync agent linked database.
    :vartype description: str
    :ivar server_name: Server name of the sync agent linked database.
    :vartype server_name: str
    :ivar database_name: Database name of the sync agent linked database.
    :vartype database_name: str
    :ivar user_name: User name of the sync agent linked database.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "database_type": {"readonly": True},
        "database_id": {"readonly": True},
        "description": {"readonly": True},
        "server_name": {"readonly": True},
        "database_name": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "database_type": {"key": "properties.databaseType", "type": "str"},
        "database_id": {"key": "properties.databaseId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "server_name": {"key": "properties.serverName", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.database_type: Optional[Union[str, "_models.SyncMemberDbType"]] = None
        self.database_id: Optional[str] = None
        self.description: Optional[str] = None
        self.server_name: Optional[str] = None
        self.database_name: Optional[str] = None
        self.user_name: Optional[str] = None


class SyncAgentLinkedDatabaseListResult(_serialization.Model):
    """A list of sync agent linked databases.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncAgentLinkedDatabase]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SyncAgentLinkedDatabase]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SyncAgentLinkedDatabase"]] = None
        self.next_link: Optional[str] = None


class SyncAgentListResult(_serialization.Model):
    """A list of sync agents.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncAgent]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SyncAgent]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SyncAgent"]] = None
        self.next_link: Optional[str] = None


class SyncDatabaseIdListResult(_serialization.Model):
    """A list of sync database ID properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncDatabaseIdProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SyncDatabaseIdProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SyncDatabaseIdProperties"]] = None
        self.next_link: Optional[str] = None


class SyncDatabaseIdProperties(_serialization.Model):
    """Properties of the sync database id.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM resource id of sync database.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None


class SyncFullSchemaProperties(_serialization.Model):
    """Properties of the database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tables: List of tables in the database full schema.
    :vartype tables: list[~azure.mgmt.sql.models.SyncFullSchemaTable]
    :ivar last_update_time: Last update time of the database schema.
    :vartype last_update_time: ~datetime.datetime
    """

    _validation = {
        "tables": {"readonly": True},
        "last_update_time": {"readonly": True},
    }

    _attribute_map = {
        "tables": {"key": "tables", "type": "[SyncFullSchemaTable]"},
        "last_update_time": {"key": "lastUpdateTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tables: Optional[List["_models.SyncFullSchemaTable"]] = None
        self.last_update_time: Optional[datetime.datetime] = None


class SyncFullSchemaPropertiesListResult(_serialization.Model):
    """A list of sync schema properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of results.
    :vartype value: list[~azure.mgmt.sql.models.SyncFullSchemaProperties]
    :ivar next_link: Link to retrieve next page of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SyncFullSchemaProperties]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.SyncFullSchemaProperties"]] = None
        self.next_link: Optional[str] = None


class SyncFullSchemaTable(_serialization.Model):
    """Properties of the table in the database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar columns: List of columns in the table of database full schema.
    :vartype columns: list[~azure.mgmt.sql.models.SyncFullSchemaTableColumn]
    :ivar error_id: Error id of the table.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar name: Name of the table.
    :vartype name: str
    :ivar quoted_name: Quoted name of the table.
    :vartype quoted_name: str
    """

    _validation = {
        "columns": {"readonly": True},
        "error_id": {"readonly": True},
        "has_error": {"readonly": True},
        "name": {"readonly": True},
        "quoted_name": {"readonly": True},
    }

    _attribute_map = {
        "columns": {"key": "columns", "type": "[SyncFullSchemaTableColumn]"},
        "error_id": {"key": "errorId", "type": "str"},
        "has_error": {"key": "hasError", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "quoted_name": {"key": "quotedName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.columns: Optional[List["_models.SyncFullSchemaTableColumn"]] = None
        self.error_id: Optional[str] = None
        self.has_error: Optional[bool] = None
        self.name: Optional[str] = None
        self.quoted_name: Optional[str] = None


class SyncFullSchemaTableColumn(_serialization.Model):
    """Properties of the column in the table of database full schema.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_size: Data size of the column.
    :vartype data_size: str
    :ivar data_type: Data type of the column.
    :vartype data_type: str
    :ivar error_id: Error id of the column.
    :vartype error_id: str
    :ivar has_error: If there is error in the table.
    :vartype has_error: bool
    :ivar is_primary_key: If it is the primary key of the table.
    :vartype is_primary_key: bool
    :ivar name: Name of the column.
    :vartype name: str
    :ivar quoted_name: Quoted name of the column.
    :vartype quoted_name: str
    """

    _validation = {
        "data_size": {"readonly": True},
        "data_type": {"readonly": True},
        "error_id": {"readonly": True},
        "has_error": {"readonly": True},
        "is_primary_key": {"readonly": True},
        "name": {"readonly": True},
        "quoted_name": {"readonly": True},
    }

    _attribute_map = {
        "data_size": {"key": "dataSize", "type": "str"},
        "data_type": {"key": "dataType", "type": "str"},
        "error_id": {"key": "errorId", "type": "str"},
        "has_error": {"key": "hasError", "type": "bool"},
        "is_primary_key": {"key": "isPrimaryKey", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "quoted_name": {"key": "quotedName", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_size: Optional[str] = None
        self.data_type: Optional[str] = None
        self.error_id: Optional[str] = None
        self.has_error: Optional[bool] = None
        self.is_primary_key: Optional[bool] = None
        self.name: Optional[str] = None
        self.quoted_name: Optional[str] = None


class SyncGroup(ProxyResource):
    """An Azure SQL Database sync group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar sku: The name and capacity of the SKU.
    :vartype sku: ~azure.mgmt.sql.models.Sku
    :ivar interval: Sync interval of the sync group.
    :vartype interval: int
    :ivar last_sync_time: Last sync time of the sync group.
    :vartype last_sync_time: ~datetime.datetime
    :ivar conflict_resolution_policy: Conflict resolution policy of the sync group. Known values
     are: "HubWin" and "MemberWin".
    :vartype conflict_resolution_policy: str or ~azure.mgmt.sql.models.SyncConflictResolutionPolicy
    :ivar sync_database_id: ARM resource id of the sync database in the sync group.
    :vartype sync_database_id: str
    :ivar hub_database_user_name: User name for the sync group hub database credential.
    :vartype hub_database_user_name: str
    :ivar hub_database_password: Password for the sync group hub database credential.
    :vartype hub_database_password: str
    :ivar sync_state: Sync state of the sync group. Known values are: "NotReady", "Error",
     "Warning", "Progressing", and "Good".
    :vartype sync_state: str or ~azure.mgmt.sql.models.SyncGroupState
    :ivar schema: Sync schema of the sync group.
    :vartype schema: ~azure.mgmt.sql.models.SyncGroupSchema
    :ivar enable_conflict_logging: If conflict logging is enabled.
    :vartype enable_conflict_logging: bool
    :ivar conflict_logging_retention_in_days: Conflict logging retention period.
    :vartype conflict_logging_retention_in_days: int
    :ivar use_private_link_connection: If use private link connection is enabled.
    :vartype use_private_link_connection: bool
    :ivar private_endpoint_name: Private endpoint name of the sync group if use private link
     connection is enabled.
    :vartype private_endpoint_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "last_sync_time": {"readonly": True},
        "sync_state": {"readonly": True},
        "private_endpoint_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "interval": {"key": "properties.interval", "type": "in